/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*M!100616 SET @OLD_NOTE_VERBOSITY=@@NOTE_VERBOSITY, NOTE_VERBOSITY=0 */;
DROP TABLE IF EXISTS `account_detail_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_detail_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `account_subtype_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_detail_types` WRITE;
/*!40000 ALTER TABLE `account_detail_types` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `account_detail_types` VALUES
(1,0,1,'Allowance for bad debts','Use Allowance for bad debts to estimate the part of Accounts Receivable that you think you might not collect. Use this only if you are keeping your books on the accrual basis.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(2,0,1,'Assets available for sale','Use Assets available for sale to track assets that are available for sale that are not expected to be held for a long period of time.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(3,0,1,'Development costs','Use Development costs to track amounts you deposit or set aside to arrange for financing, such as an SBA loan, or for deposits in anticipation of the purchase of property or other assets. When the deposit is refunded, or the purchase takes place, remove the amount from this account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(4,0,1,'Employee cash advances','Use Employee cash advances to track employee wages and salary you issue to an employee early, or other non-salary money given to employees. If you make a loan to an employee, use the Current asset account type called Loans to others, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(5,0,1,'Inventory','Use Inventory to track the cost of goods your business purchases for resale. When the goods are sold, assign the sale to a Cost of sales account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(6,0,1,'Investments - Other','Use Investments - Other to track the value of investments not covered by other investment account types. Examples include publicly-traded shares, coins, or gold.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(7,0,1,'Loans to officers','If you operate your business as a Corporation, use Loans to officers to track money loaned to officers of your business.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(8,0,1,'Loans to others','Use Loans to others to track money your business loans to other people or businesses. This type of account is also referred to as Notes Receivable. For early salary payments to employees, use Employee cash advances, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(9,0,1,'Loans to Shareholders','If you operate your business as a Corporation, use Loans to Shareholders to track money your business loans to its shareholders',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(10,0,1,'Other current assets','Use Other current assets for current assets not covered by the other types. Current assets are likely to be converted to cash or used up in a year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(11,0,1,'Prepaid expenses','Use Prepaid expenses to track payments for expenses that you won\'t recognise until your next accounting period. When you recognise the expense, make a journal entry to transfer money from this account to the expense account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(12,0,1,'Retainage','Use Retainage if your customers regularly hold back a portion of a contract amount until you have completed a project. This type of account is often used in the construction industry, and only if you record income on an accrual basis.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(13,0,1,'Undeposited funds','Use Undeposited funds for cash or cheques from sales that haven\'t been deposited yet. For petty cash, use Cash on hand, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(14,0,2,'Accumulated amortisation of non-current assets','Use Accumulated amortisation of non-current assets to track how much you\'ve amortised an asset whose type is Non-Current Asset.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(15,0,2,'Assets held for sale','Use Assets held for sale to track assets of a company that are available for sale that are not expected to be held for a long period of time.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(16,0,2,'Deferred tax','Use Deferred tax for tax liabilities or assets that are to be used in future accounting periods.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(17,0,2,'Goodwill','Use Goodwill only if you have acquired another company. It represents the intangible assets of the acquired company which gave it an advantage, such as favourable government relations, business name, outstanding credit ratings, location, superior management, customer lists, product quality, or good labour relations.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(18,0,2,'Intangible assets','Use Intangible assets to track intangible assets that you plan to amortise. Examples include franchises, customer lists, copyrights, and patents.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(19,0,2,'Lease buyout','Use Lease buyout to track lease payments to be applied toward the purchase of a leased asset. You don\'t track the leased asset itself until you purchase it.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(20,0,2,'Licences','Use Licences to track non-professional licences for permission to engage in an activity, like selling alcohol or radio broadcasting. For fees associated with professional licences granted to individuals, use a Legal and professional fees expense account, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(21,0,2,'Long-term investments','Use Long-term investments to track investments that have a maturity date of longer than one year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(22,0,2,'Organisational costs','Use Organisational costs to track costs incurred when forming a partnership or corporation. The costs include the legal and accounting costs necessary to organise the company, facilitate the filings of the legal documents, and other paperwork.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(23,0,2,'Other non-current assets','Use Other non-current assets to track assets not covered by other types. Non-current assets are long-term assets that are expected to provide value for more than one year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(24,0,2,'Security deposits','Use Security deposits to track funds you\'ve paid to cover any potential costs incurred by damage, loss, or theft. The funds should be returned to you at the end of the contract. If you accept down payments, advance payments, security deposits, or other kinds of deposits, use an Other Current liabilities account with the detail type Other Current liabilities.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(25,0,3,'Accumulated depletion','Use Accumulated depletion to track how much you deplete a natural resource.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(26,0,3,'Accumulated depreciation on property, plant and equipment','Use Accumulated depreciation on property, plant and equipment to track how much you depreciate a fixed asset (a physical asset you do not expect to convert to cash during one year of normal operations).',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(27,0,3,'Buildings','Use Buildings to track the cost of structures you own and use for your business. If you have a business in your home, consult your accountant. Use a Land account for the land portion of any real property you own, splitting the cost of the property between land and building in a logical method. A common method is to mimic the land-to-building ratio on the property tax statement.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(28,0,3,'Depletable assets','Use Depletable assets to track natural resources, such as timberlands, oil wells, and mineral deposits.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(29,0,3,'Furniture and fixtures','Use Furniture and fixtures to track any furniture and fixtures your business owns and uses, like a dental chair or sales booth.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(30,0,3,'Land','Use Land to track assets that are not easily convertible to cash or not expected to become cash within the next year. For example, leasehold improvements.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(31,0,3,'Leasehold improvements','Use Leasehold improvements to track improvements to a leased asset that increases the asset\'s value. For example, if you carpet a leased office space and are not reimbursed, that\'s a leasehold improvement.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(32,0,3,'Machinery and equipment','Use Machinery and equipment to track computer hardware, as well as any other non-furniture fixtures or devices owned and used for your business. This includes equipment that you ride, like tractors and lawn mowers. Cars and lorries, however, should be tracked with Vehicle accounts, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(33,0,3,'Other fixed asset','Use Other fixed asset for fixed assets that are not covered by other asset types. Fixed assets are physical property that you use in your business and that you do not expect to convert to cash or be used up during one year of normal operations.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(34,0,3,'Vehicles','Use Vehicles to track the value of vehicles your business owns and uses for business. This includes off-road vehicles, air planes, helicopters, and boats. If you use a vehicle for both business and personal use, consult your accountant to see how you should track its value.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(35,0,4,'Accounts Receivable(A/R)','Accounts receivable (also called A/R, Debtors, or Trade and other receivables) tracks money that customers owe you for products or services, and payments customers make. Ultimate Pos -Accounting Module  automatically creates one Accounts receivable account for you. Most businesses need only one. Each customer has a register, which functions like an Accounts receivable account for each customer.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(36,0,5,'Bank','Use Bank accounts to track all your current activity, including debit card transactions. Each current account your company has at a bank or other financial institution should have its own Bank type account in Ultimate POS.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(37,0,5,'Cash and Cash Equivalents','Use Cash and Cash Equivalents to track cash or assets that can be converted into cash immediately. For example, marketable securities and Treasury bills.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(38,0,5,'Cash on hand','Use a Cash on hand account to track cash your company keeps for occasional expenses, also called petty cash. To track cash from sales that have not been deposited yet, use a pre-created account called Undeposited funds, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(39,0,5,'Client trust accounts','Use Client trust accounts for money held by you for the benefit of someone else. For example, trust accounts are often used by attorneys to keep track of expense money their customers have given them. Often, to keep the amount in a trust account from looking like it\'s yours, the amount is offset in a \"contra\" liability account (a Current Liability).',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(40,0,5,'Money market','Use Money market to track amounts in money market accounts. For investments, see Current Assets, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(41,0,5,'Rents held in trust','Use Rents held in trust to track deposits and rent held on behalf of the property owners. Typically only property managers use this type of account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(42,0,5,'Savings','Use Savings accounts to track your savings and CD activity. Each savings account your company has at a bank or other financial institution should have its own Savings type account. For investments, see Current Assets, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(43,0,6,'Accrued Liabilities','Use Accrued Liabilities to track expenses that a business has incurred but has not yet paid. For example, pensions for companies that contribute to a pension fund for their employees for their retirement.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(44,0,6,'Client Trust accounts - liabilities','Use Client Trust accounts - liabilities to offset Client Trust accounts in assets. Amounts in these accounts are held by your business on behalf of others. They do not belong to your business, so should not appear to be yours on your balance sheet. This \"contra\" account takes care of that, as long as the two balances match.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(45,0,6,'Current tax liability','Use Current tax liability to track the total amount of taxes collected but not yet paid to the government.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(46,0,6,'Current portion of obligations under finance leases','Use Current portion of obligations under finance leases to track the value of lease payments due within the next 12 months.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(47,0,6,'Dividends payable','Use Dividends payable to track dividends that are owed to shareholders but have not yet been paid.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(48,0,6,'Income tax payable','Use Income tax payable to track monies that are due to pay the company\'s income tax liabilties.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(49,0,6,'Insurance payable','Use Insurance payable to keep track of insurance amounts due. This account is most useful for businesses with monthly recurring insurance expenses.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(50,0,6,'Line of credit','Use Line of credit to track the balance due on any lines of credit your business has. Each line of credit your business has should have its own Line of credit account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(51,0,6,'Loan payable','Use Loan payable to track loans your business owes which are payable within the next twelve months. For longer-term loans, use the Long-term liability called Notes payable, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(52,0,6,'Other current liabilities','Use Other current liabilities to track monies owed by the company and due within one year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(53,0,6,'Payroll clearing','Use Payroll clearing to keep track of any non-tax amounts that you have deducted from employee paycheques or that you owe as a result of doing payroll. When you forward money to the appropriate suppliers, deduct the amount from the balance of this account. Do not use this account for tax amounts you have withheld or owe from paying employee wages. For those amounts, use the Payroll tax payable account instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(54,0,6,'Payroll liabilities','Use Payroll liabilities to keep track of tax amounts that you owe to government agencies as a result of paying wages. This includes taxes withheld, health care premiums, employment insurance, government pensions, etc. When you forward the money to the government agency, deduct the amount from the balance of this account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(55,0,6,'Prepaid expenses payable','Use Prepaid expenses payable to track items such as property taxes that are due, but not yet deductible as an expense because the period they cover has not yet passed.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(56,0,6,'Rents in trust - Liability','Use Rents in trust - liability to offset the Rents in trust amount in assets. Amounts in these accounts are held by your business on behalf of others. They do not belong to your business, so should not appear to be yours on your balance sheet. This \"contra\" account takes care of that, as long as the two balances match.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(57,0,6,'Sales and service tax payable','Use Sales and service tax payable to track tax you have collected, but not yet remitted to your government tax agency. This includes value-added tax, goods and services tax, sales tax, and other consumption tax.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(58,0,7,'Accrued holiday payable','Use Accrued holiday payable to track holiday earned but that has not been paid out to employees.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(59,0,7,'Accrued Non-current liabilities','Use Accrued Non-current liabilities to track expenses that a business has incurred but has not yet paid. For example, pensions for companies that contribute to a pension fund for their employees for their retirement.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(60,0,7,'Liabilities related to assets held for sale','Use Liabilities related to assets held for sale to track any liabilities that are directly related to assets being sold or written off.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(61,0,7,'Long-term debt','Use Long-term debt to track loans and obligations with a maturity of longer than one year. For example, mortgages.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(62,0,7,'Notes payable','Use Notes payable to track the amounts your business owes in long-term (over twelve months) loans. For shorter loans, use the Current liability account type called Loan payable, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(63,0,7,'Other non-current liabilities','Use Other non-current liabilities to track liabilities due in more than twelve months that don\'t fit the other Non-Current liability account types.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(64,0,7,'Shareholder notes payable','Use Shareholder notes payable to track long-term loan balances your business owes its shareholders.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(65,0,8,'Accounts Payable (A/P)','Accounts payable (also called A/P, Trade and other payables, or Creditors) tracks amounts you owe to your suppliers. Ultimate POS automatically creates one Accounts Payable account for you. Most businesses need only one.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(66,0,9,'Credit Card','Credit card accounts track the balance due on your business credit cards. Create one Credit card account for each credit card account your business uses.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(67,0,10,'Accumulated Adjustment','Some corporations use this account to track adjustments to owner\'s equity that are not attributable to net income.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(68,0,10,'Dividend disbursed','Use Dividend disbursed to track a payment given to its shareholders out of the company\'s retained earnings.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(69,0,10,'Equity in earnings of subsidiaries','Use Equity in earnings of subsidiaries to track the original investment in shares of subsidiaries plus the share of earnings or losses from the operations of the subsidiary.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(70,0,10,'Opening balance equity','Ultimate POS creates this account the first time you enter an opening balance for a balance sheet account. As you enter opening balances, Ultimate POS records the amounts in Opening balance equity. This ensures that you have a correct balance sheet for your company, even before you\'ve finished entering all your company\'s assets and liabilities.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(71,0,10,'Ordinary shares','Corporations use Ordinary shares to track its ordinary shares in the hands of shareholders. The amount in this account should be the stated (or par) value of the stock.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(72,0,10,'Other comprehensive income','Use Other comprehensive income to track the increases or decreases in income from various businesses that is not yet absorbed by the company.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(73,0,10,'Owner\'s Equity','Corporations use Owner\'s equity to show the cumulative net income or loss of their business as of the beginning of the financial year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(74,0,10,'Paid-in capital or Surplus','Corporations use Paid-in capital to track amounts received from shareholders in exchange for shares that are over and above the shares\' stated (or par) value.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(75,0,10,'Partner contributions','Partnerships use Partner contributions to track amounts partners contribute to the partnership during the year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(76,0,10,'Partner distributions','Partnerships use Partner distributions to track amounts distributed by the partnership to its partners during the year. Don\'t use this for regular payments to partners for interest or service. For regular payments, use a Guaranteed payments account (a Expense account in Payroll expenses), instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(77,0,10,'Partner\'s Equity','Partnerships use Partner\'s equity to show the income remaining in the partnership for each partner as of the end of the prior year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(78,0,10,'Preferred Shares','Corporations use this account to track its preferred shares in the hands of shareholders. The amount in this account should be the stated (or par) value of the shares.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(79,0,10,'Retained earnings','Ultimate POS adds this account when you create your company. Retained earnings tracks net income from previous financial years. Ultimate POS automatically transfers your profit (or loss) to Retained earnings at the end of each financial year.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(80,0,10,'Share capital','Use Share capital to track the funds raised by issuing shares.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(81,0,10,'Treasury shares','Corporations use Treasury shares to track amounts paid by the corporation to buy its own shares back from shareholders.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(82,0,11,'Discounts/refunds given','Use Discounts/refunds given to track discounts you give to customers. This account typically has a negative balance so it offsets other income. For discounts from suppliers, use an expense account, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(83,0,11,'Non-profit income','Use Non-profit income to track money coming in if you are a non-profit organisation.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(84,0,11,'Other primary income','Use Other primary income to track income from normal business operations that doesn\'t fall into another Income type.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(85,0,11,'Revenue - General','Use Revenue - General to track income from normal business operations that do not fit under any other category.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(86,0,11,'Sales - retail','Use Sales - retail to track sales of goods/services that have a mark-up cost to consumers.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(87,0,11,'Sales - wholesale','Use Sales - wholesale to track the sale of goods in quantity for resale purposes.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(88,0,11,'Sales of Product Income','Use Sales of product income to track income from selling products. This can include all kinds of products, like crops and livestock, rental fees, performances, and food served.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(89,0,11,'Service/fee income','Use Service/fee income to track income from services you perform or ordinary usage fees you charge. For fees customers pay you for late payments or other uncommon situations, use an Other Income account type called Other miscellaneous income, instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(90,0,11,'Unapplied Cash Payment Income','Unapplied Cash Payment Income reports the Cash Basis income from customers payments you\'ve received but not applied to invoices or charges. In general, you would never use this directly on a purchase or sale transaction.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(91,0,12,'Dividend income','Use Dividend income to track taxable dividends from investments.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(92,0,12,'Interest earned','Use Interest earned to track interest from bank or savings accounts, investments, or interest payments to you on loans your business made.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(93,0,12,'Loss on disposal of assets','Use Loss on disposal of assets to track losses realised on the disposal of assets.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(94,0,12,'Other investment income','Use Other investment income to track other types of investment income that isn\'t from dividends or interest.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(95,0,12,'Other miscellaneous income','Use Other miscellaneous income to track income that isn\'t from normal business operations, and doesn\'t fall into another Other Income type.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(96,0,12,'Other operating income','Use Other operating income to track income from activities other than normal business operations. For example, Investment interest, foreign exchange gains, and rent income.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(97,0,12,'Tax-exempt interest','Use Tax-exempt interest to record interest that isn\'t taxable, such as interest on money in tax-exempt retirement accounts, or interest from tax-exempt bonds.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(98,0,12,'Unrealised loss on securities, net of tax','Use Unrealised loss on securities, net of tax to track losses on securities that have occurred but are yet been realised through a transaction. For example, shares whose value has fallen but that are still being held.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(99,0,13,'Advertising/Promotional','Use Advertising/promotional to track money spent promoting your company. You may want different accounts of this type to track different promotional efforts (Yellow Pages, newspaper, radio, flyers, events, and so on). If the promotion effort is a meal, use Promotional meals instead.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(100,0,13,'Amortisation Expense','Use Amortisation expense to track writing off of assets (such as intangible assets or investments) over the projected life of the assets.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(101,0,13,'Auto','Use Auto to track costs associated with vehicles. You may want different accounts of this type to track petrol, repairs, and maintenance. If your business owns a car or lorry, you may want to track its value as a Fixed Asset, in addition to tracking its expenses.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(102,0,13,'Bad debt','Use Bad debt to track debt you have written off.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(103,0,13,'Bank charges','Use Bank charges for any fees you pay to financial institutions.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(104,0,13,'Charitable contributions','Use Charitable contributions to track gifts to charity.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(105,0,13,'Commissions and fees','Use Commissions and fees to track amounts paid to agents (such as brokers) in order for them to execute a trade.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(106,0,13,'Cost of labour','Use Cost of labour to track the cost of paying employees to produce products or supply services. It includes all employment costs, including food and transportation, if applicable. This account is also available as a Cost of Sales (COS) account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(107,0,13,'Dues and subscriptions','Use Dues and subscriptions to track dues and subscriptions related to running your business. You may want different accounts of this type for professional dues, fees for licences that can\'t be transferred, magazines, newspapers, industry publications, or service subscriptions.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(108,0,13,'Equipment rental','Use Equipment rental to track the cost of renting equipment to produce products or services. This account is also available as a Cost of Sales account. If you purchase equipment, use a Fixed asset account type called Machinery and equipment.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(109,0,13,'Finance costs','Use Finance costs to track the costs of obtaining loans or credit. Examples of finance costs would be credit card fees, interest and mortgage costs.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(110,0,13,'Income tax expense','Use Income tax expense to track income taxes that the company has paid to meet their tax obligations.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(111,0,13,'Insurance','Use Insurance to track insurance payments. You may want different accounts of this type for different types of insurance (auto, general liability, and so on).',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(112,0,13,'Interest paid','Use Interest paid for all types of interest you pay, including mortgage interest, finance charges on credit cards, or interest on loans.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(113,0,13,'Legal and professional fees','Use Legal and professional fees to track money to pay to professionals to help you run your business. You may want different accounts of this type for payments to your accountant, attorney, or other consultants.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(114,0,13,'Loss on discontinued operations, net of tax','Use Loss on discontinued operations, net of tax to track the loss realised when a part of the business ceases to operate or when a product line is discontinued.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(115,0,13,'Management compensation','Use Management compensation to track remuneration paid to Management, Executives and non-Executives. For example, salary, fees, and benefits.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(116,0,13,'Meals and entertainment','Use Meals and entertainment to track how much you spend on dining with your employees to promote morale. If you dine with a customer to promote your business, use a Promotional meals account, instead. Be sure to include who you ate with and the purpose of the meal when you enter the transaction.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(117,0,13,'Office/general administrative expenses','Use Office/general administrative expenses to track all types of general or office-related expenses.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(118,0,13,'Other miscellaneous service cost','Use Other miscellaneous service cost to track costs related to providing services that don\'t fall into another Expense type. This account is also available as a Cost of Sales (COS) account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(119,0,13,'Other selling expenses','Use Other selling expenses to track selling expenses incurred that do not fall under any other category.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(120,0,13,'Payroll expenses','Use Payroll expenses to track payroll expenses. You may want different accounts of this type for things like: Compensation of officers, Guaranteed payments, Workers compensation, Salaries and wages, Payroll taxes',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(121,0,13,'Rent or lease of buildings','Use Rent or lease of buildings to track rent payments you make.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(122,0,13,'Repair and maintenance','Use Repair and maintenance to track any repairs and periodic maintenance fees. You may want different accounts of this type to track different types repair & maintenance expenses (auto, equipment, landscape, and so on).',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(123,0,13,'Shipping and delivery expense','Use Shipping and delivery expense to track the cost of shipping and delivery of goods to customers.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(124,0,13,'Supplies & materials','Use Supplies & materials to track the cost of raw goods and parts used or consumed when producing a product or providing a service. This account is also available as a Cost of Sales account.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(125,0,13,'Taxes paid','Use Taxes paid to track taxes you pay. You may want different accounts of this type for payments to different tax agencies.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(126,0,13,'Travel expenses - general and admin expenses','Use Travel expenses - general and admin expenses to track travelling costs incurred that are not directly related to the revenue-generating operation of the company. For example, flight tickets and hotel costs when performing job interviews.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(127,0,13,'Travel expenses - selling expense','Use Travel expenses - selling expense to track travelling costs incurred that are directly related to the revenue-generating operation of the company. For example, flight tickets and hotel costs when selling products and services.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(128,0,13,'Unapplied Cash Bill Payment Expense','Unapplied Cash Bill Payment Expense reports the Cash Basis expense from supplier payment cheques you\'ve sent but not yet applied to supplier bills. In general, you would never use this directly on a purchase or sale transaction.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(129,0,13,'Utilities','Use Utilities to track utility payments. You may want different accounts of this type to track different types of utility payments (gas and electric, telephone, water, and so on).',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(130,0,14,'Cost of labour - COS','Use Cost of labour - COS to track the cost of paying employees to produce products or supply services. It includes all employment costs, including food and transportation, if applicable.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(131,0,14,'Equipment rental - COS','Use Equipment rental - COS to track the cost of renting equipment to produce products or services. If you purchase equipment, use a Fixed Asset account type called Machinery and equipment.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(132,0,14,'Freight and delivery - COS','Use Freight and delivery - COS to track the cost of shipping/delivery of obtaining raw materials and producing finished goods for resale.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(133,0,14,'Other costs of sales - COS','Use Other costs of sales - COS to track costs related to services or sales that you provide that don\'t fall into another Cost of Sales type.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(134,0,14,'Supplies and materials - COS','Use Supplies and materials - COS to track the cost of raw goods and parts used or consumed when producing a product or providing a service.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(135,0,15,'Amortisation','Use Amortisation to track amortisation of intangible assets. Amortisation is spreading the cost of an intangible asset over its useful life, like depreciation of fixed assets. You may want an amortisation account for each intangible asset you have.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(136,0,15,'Depreciation','Use Depreciation to track how much you depreciate fixed assets. You may want a depreciation account for each fixed asset you have.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(137,0,15,'Exchange Gain or Loss','Use Exchange Gain or Loss to track gains or losses that occur as a result of exchange rate fluctuations.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(138,0,15,'Other expense','Use Other expense to track unusual or infrequent expenses that don\'t fall into another Other Expense type.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(139,0,15,'Penalties and settlements','Use Penalties and settlements to track money you pay for violating laws or regulations, settling lawsuits, or other penalties.',1,'2025-05-12 02:31:13','2025-05-12 02:31:13');
/*!40000 ALTER TABLE `account_detail_types` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `account_subtypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_subtypes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `account_type` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_subtypes` WRITE;
/*!40000 ALTER TABLE `account_subtypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `account_subtypes` VALUES
(1,0,'asset','Current Assets',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(2,0,'asset','Non- Current Assets',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(3,0,'asset','Fixed Assets',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(4,0,'asset','Accounts Receivable(A/R)',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(5,0,'asset','Cash and Cash Equivalents (CCE)',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(6,0,'liability','Current Liabilities',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(7,0,'liability','Non- Current Liabilities',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(8,0,'liability','Accounts Payable (A/P)',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(9,0,'liability','Credit Card',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(10,0,'equity','Owner\'s Equity',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(11,0,'income','Income',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(12,0,'income','Other Income',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(13,0,'expense','Expense',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(14,0,'expense','Cost of Sales',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13'),
(15,0,'expense','Other Expense',NULL,1,'2025-05-12 02:31:13','2025-05-12 02:31:13');
/*!40000 ALTER TABLE `account_subtypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB AUTO_INCREMENT=5113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `account_transactions` VALUES
(2,1,'credit',NULL,425000.0000,NULL,'2023-07-28 16:15:24',3,1793,136,NULL,NULL,NULL,'2023-07-28 09:15:24','2023-07-28 09:15:24'),
(3,1,'debit',NULL,36000.0000,NULL,'2023-07-29 15:24:50',17,1863,170,NULL,NULL,NULL,'2023-07-29 08:24:50','2023-07-29 08:24:50'),
(4,1,'credit',NULL,288000.0000,NULL,'2023-07-27 17:38:14',3,1732,114,NULL,NULL,NULL,'2023-07-31 07:22:50','2023-07-31 07:22:50'),
(5,1,'debit',NULL,176400.0000,NULL,'2023-08-24 21:11:00',23,14574,1476,NULL,NULL,NULL,'2023-08-24 14:14:10','2023-08-24 14:14:10'),
(6,2,'credit','opening_balance',91894942.0000,NULL,'2024-05-15 22:30:23',1,NULL,NULL,NULL,NULL,NULL,'2024-05-15 15:30:23','2024-05-15 15:30:23'),
(7,2,'debit',NULL,12768000.0000,NULL,'2024-05-16 03:37:00',1,34563,19299,NULL,NULL,NULL,'2024-05-15 20:37:40','2024-05-15 20:37:40'),
(8,2,'debit',NULL,131500.0000,NULL,'2024-05-16 03:46:00',1,34454,19300,NULL,NULL,NULL,'2024-05-15 20:46:36','2024-05-15 20:46:36'),
(9,2,'credit',NULL,250000.0000,NULL,'2024-05-16 10:08:46',5,33095,19305,NULL,NULL,NULL,'2024-05-16 03:08:46','2024-05-16 03:10:04'),
(10,2,'credit',NULL,15344000.0000,NULL,'2024-05-16 11:05:00',17,34591,19308,NULL,NULL,'2024-05-16 06:11:12','2024-05-16 04:05:59','2024-05-16 06:11:12'),
(11,2,'credit',NULL,250000.0000,NULL,'2024-05-16 11:47:11',17,34600,19311,NULL,NULL,NULL,'2024-05-16 04:47:11','2024-05-16 04:47:11'),
(12,2,'credit',NULL,15440000.0000,NULL,'2024-05-16 13:13:22',5,34608,19321,NULL,NULL,NULL,'2024-05-16 06:13:22','2024-05-16 08:17:36'),
(13,2,'credit',NULL,230000.0000,NULL,'2024-05-16 13:50:36',3,34612,19324,NULL,NULL,NULL,'2024-05-16 06:50:36','2024-05-16 06:50:36'),
(14,2,'credit',NULL,484000.0000,NULL,'2024-05-16 16:22:11',5,34608,19339,NULL,NULL,NULL,'2024-05-16 09:22:11','2024-05-18 08:12:54'),
(15,2,'credit',NULL,245000.0000,NULL,'2024-05-17 10:13:36',5,34664,19380,NULL,NULL,'2024-05-17 03:14:59','2024-05-17 03:13:36','2024-05-17 03:14:59'),
(16,2,'credit',NULL,1140000.0000,NULL,'2024-05-17 12:13:43',5,34668,19384,NULL,NULL,NULL,'2024-05-17 05:13:43','2024-05-17 05:53:36'),
(17,2,'credit',NULL,80000.0000,NULL,'2024-05-17 16:48:26',6,34702,19413,NULL,NULL,NULL,'2024-05-17 09:48:26','2024-05-17 09:48:26'),
(18,2,'credit',NULL,1000000.0000,NULL,'2024-05-17 16:56:48',5,33925,19417,NULL,NULL,NULL,'2024-05-17 09:56:48','2024-06-21 04:58:31'),
(19,2,'credit',NULL,504000.0000,NULL,'2024-05-17 19:21:25',13,34728,19430,NULL,NULL,NULL,'2024-05-17 12:21:47','2024-05-17 12:21:47'),
(20,2,'debit',NULL,3833380.0000,NULL,'2024-05-17 23:07:00',1,34441,19447,NULL,NULL,NULL,'2024-05-17 16:07:32','2024-05-17 16:07:32'),
(21,2,'debit',NULL,833000.0000,NULL,'2024-05-18 01:17:00',1,34706,19448,NULL,NULL,NULL,'2024-05-17 18:17:19','2024-05-17 18:17:19'),
(22,2,'debit',NULL,3760000.0000,NULL,'2024-05-18 01:19:00',1,34708,19449,NULL,NULL,NULL,'2024-05-17 18:19:18','2024-05-17 18:19:18'),
(23,2,'debit',NULL,7854000.0000,NULL,'2024-05-18 01:30:00',1,34709,19450,NULL,NULL,NULL,'2024-05-17 18:30:17','2024-05-17 18:30:17'),
(24,2,'debit',NULL,5644400.0000,NULL,'2024-05-18 01:38:00',1,34707,19451,NULL,NULL,NULL,'2024-05-17 18:38:34','2024-05-17 18:38:34'),
(25,2,'debit',NULL,22149064.0000,NULL,'2024-05-18 01:38:00',1,34704,19452,NULL,NULL,NULL,'2024-05-17 18:38:51','2024-05-17 18:38:51'),
(26,2,'debit',NULL,16784388.0000,NULL,'2024-05-18 02:31:00',1,34705,19453,NULL,NULL,NULL,'2024-05-17 19:31:38','2024-05-17 19:31:38'),
(27,2,'debit',NULL,10371200.0000,NULL,'2024-05-18 02:35:00',1,34737,19454,NULL,NULL,NULL,'2024-05-17 19:35:07','2024-05-17 19:35:07'),
(28,2,'debit',NULL,3914300.0000,NULL,'2024-05-18 02:35:00',1,34739,19455,NULL,NULL,NULL,'2024-05-17 19:35:44','2024-05-17 19:35:44'),
(29,2,'credit',NULL,2324000.0000,NULL,'2024-05-18 10:17:51',5,34366,19459,NULL,NULL,NULL,'2024-05-18 03:17:51','2024-05-18 03:17:51'),
(30,2,'credit',NULL,30000.0000,NULL,'2024-05-18 11:45:25',6,34767,19470,NULL,NULL,NULL,'2024-05-18 04:45:55','2024-05-18 04:45:55'),
(31,2,'credit',NULL,120000.0000,NULL,'2024-05-18 12:35:23',6,34468,19477,NULL,NULL,NULL,'2024-05-18 05:35:23','2024-05-18 05:45:19'),
(32,2,'credit',NULL,470000.0000,NULL,'2024-05-18 12:35:39',6,34776,19478,NULL,NULL,NULL,'2024-05-18 05:35:39','2024-05-18 05:35:39'),
(33,2,'debit',NULL,4873300.0000,NULL,'2024-05-18 14:11:00',1,34740,19480,NULL,NULL,NULL,'2024-05-18 07:11:32','2024-05-18 07:11:32'),
(34,2,'debit',NULL,28950000.0000,NULL,'2024-05-18 14:31:00',1,34756,19484,NULL,NULL,NULL,'2024-05-18 07:31:34','2024-05-18 07:31:34'),
(35,2,'credit',NULL,202000.0000,NULL,'2024-05-18 14:37:14',6,34785,19486,NULL,NULL,NULL,'2024-05-18 07:37:14','2024-05-18 07:37:14'),
(36,2,'credit',NULL,120000.0000,NULL,'2024-05-18 15:46:12',6,34798,19495,NULL,NULL,NULL,'2024-05-18 08:46:12','2024-05-18 08:46:12'),
(37,2,'credit',NULL,145000.0000,NULL,'2024-05-18 18:14:22',3,34815,19506,NULL,NULL,NULL,'2024-05-18 11:14:22','2024-05-18 11:14:22'),
(38,2,'credit',NULL,150000.0000,NULL,'2024-05-18 20:41:01',13,34573,19515,NULL,NULL,'2024-05-18 13:45:13','2024-05-18 13:41:01','2024-05-18 13:45:13'),
(39,2,'credit',NULL,225000.0000,NULL,'2024-05-18 20:58:59',46,34822,19518,NULL,NULL,NULL,'2024-05-18 13:58:59','2024-05-18 13:58:59'),
(40,2,'credit',NULL,500000.0000,NULL,'2024-05-19 10:58:07',6,34837,19529,NULL,NULL,NULL,'2024-05-19 03:58:07','2024-05-19 03:58:07'),
(41,2,'credit',NULL,200000.0000,NULL,'2024-05-19 14:15:51',6,34814,19544,NULL,NULL,NULL,'2024-05-19 07:15:51','2024-05-30 14:28:54'),
(42,2,'credit',NULL,225000.0000,NULL,'2024-05-19 21:33:53',6,34881,19573,NULL,NULL,NULL,'2024-05-19 14:33:53','2024-05-19 14:33:53'),
(43,2,'credit',NULL,150000.0000,NULL,'2024-05-19 21:35:13',6,33893,19576,NULL,NULL,NULL,'2024-05-19 14:35:13','2024-05-19 14:35:13'),
(44,2,'debit',NULL,1105000.0000,NULL,'2024-05-20 03:06:00',1,34713,19578,NULL,NULL,NULL,'2024-05-19 20:06:53','2024-05-19 20:06:53'),
(45,2,'debit',NULL,145000.0000,NULL,'2024-05-20 03:07:00',1,34779,19579,NULL,NULL,NULL,'2024-05-19 20:07:53','2024-05-19 20:07:53'),
(46,2,'debit',NULL,270000.0000,NULL,'2024-05-20 03:10:00',1,34474,19580,NULL,NULL,NULL,'2024-05-19 20:10:15','2024-05-19 20:10:15'),
(47,2,'credit',NULL,3800000.0000,NULL,'2024-05-20 11:18:00',19,34893,19590,NULL,NULL,NULL,'2024-05-20 04:18:15','2024-05-21 04:43:56'),
(48,2,'credit',NULL,495000.0000,NULL,'2024-05-20 15:35:50',6,34933,19609,NULL,NULL,NULL,'2024-05-20 08:35:50','2024-05-20 08:35:50'),
(49,2,'credit',NULL,353000.0000,NULL,'2024-05-20 16:43:00',6,34941,19616,NULL,NULL,NULL,'2024-05-20 09:43:55','2024-05-20 09:43:55'),
(50,2,'credit',NULL,2280000.0000,NULL,'2024-05-20 18:17:52',72,34955,19621,NULL,NULL,NULL,'2024-05-20 11:17:52','2024-05-20 11:17:52'),
(51,2,'credit',NULL,480000.0000,NULL,'2024-05-20 18:20:13',49,34955,19622,NULL,NULL,NULL,'2024-05-20 11:20:13','2024-05-20 11:20:13'),
(52,2,'credit',NULL,80000.0000,NULL,'2024-05-20 19:59:58',49,34439,19634,NULL,NULL,NULL,'2024-05-20 12:59:58','2024-05-20 12:59:58'),
(53,2,'credit',NULL,120000.0000,NULL,'2024-05-21 09:34:00',19,34792,19644,NULL,NULL,NULL,'2024-05-21 02:34:43','2024-05-21 02:41:30'),
(54,2,'credit',NULL,360000.0000,NULL,'2024-05-21 12:15:00',19,34995,19657,NULL,NULL,NULL,'2024-05-21 05:15:39','2024-05-21 05:15:39'),
(55,2,'credit',NULL,266000.0000,NULL,'2024-05-21 12:16:00',19,34953,19658,NULL,NULL,NULL,'2024-05-21 05:16:28','2024-05-21 05:16:28'),
(56,2,'credit',NULL,222000.0000,NULL,'2024-05-21 13:10:25',13,35005,19663,NULL,NULL,NULL,'2024-05-21 06:10:25','2024-05-21 06:10:25'),
(57,2,'credit',NULL,534500.0000,NULL,'2024-05-21 14:12:55',6,34916,19668,NULL,NULL,NULL,'2024-05-21 07:12:55','2024-05-31 08:56:55'),
(58,2,'credit',NULL,2198000.0000,NULL,'2024-05-21 15:31:13',3,34987,19675,NULL,NULL,NULL,'2024-05-21 08:31:13','2024-05-21 09:17:41'),
(59,2,'credit',NULL,15000.0000,NULL,'2024-05-21 16:34:43',3,35023,19679,NULL,NULL,NULL,'2024-05-21 09:34:43','2024-05-21 09:34:43'),
(60,2,'credit',NULL,120000.0000,NULL,'2024-05-21 16:35:47',3,34988,19680,NULL,NULL,NULL,'2024-05-21 09:35:47','2024-05-21 09:35:47'),
(61,2,'credit',NULL,39000.0000,NULL,'2024-05-21 16:48:10',5,35025,19684,NULL,NULL,NULL,'2024-05-21 09:48:10','2024-05-21 09:48:10'),
(62,2,'credit',NULL,707000.0000,NULL,'2024-05-21 17:54:30',6,35027,19692,NULL,NULL,NULL,'2024-05-21 10:54:30','2024-05-21 10:54:30'),
(63,2,'credit',NULL,529000.0000,NULL,'2024-05-22 11:51:49',72,35063,19710,NULL,NULL,NULL,'2024-05-22 04:51:49','2024-05-22 04:51:49'),
(64,2,'debit',NULL,1780000.0000,NULL,'2024-05-22 13:14:00',3,35072,19713,NULL,NULL,'2024-05-23 08:17:47','2024-05-22 06:15:44','2024-05-23 08:17:47'),
(65,2,'credit',NULL,448000.0000,NULL,'2024-05-22 16:51:30',19,35094,19730,NULL,NULL,NULL,'2024-05-22 09:51:30','2024-05-22 09:51:30'),
(66,2,'debit',NULL,26260600.0000,NULL,'2024-05-22 23:50:00',1,35006,19749,NULL,NULL,NULL,'2024-05-22 16:50:58','2024-05-22 16:50:58'),
(67,2,'debit',NULL,3860000.0000,NULL,'2024-05-22 23:57:00',1,34813,19750,NULL,NULL,NULL,'2024-05-22 16:57:53','2024-05-22 16:57:53'),
(68,2,'debit',NULL,129300.0000,NULL,'2024-05-23 01:36:00',1,34799,19751,NULL,NULL,NULL,'2024-05-22 18:36:22','2024-05-22 18:36:22'),
(69,2,'debit',NULL,123600.0000,NULL,'2024-05-23 01:38:00',1,34800,19752,NULL,NULL,NULL,'2024-05-22 18:38:21','2024-05-22 18:38:21'),
(70,2,'debit',NULL,3394000.0000,NULL,'2024-05-23 01:46:00',1,34812,19753,NULL,NULL,NULL,'2024-05-22 18:46:35','2024-05-22 18:46:35'),
(71,2,'debit',NULL,7515000.0000,NULL,'2024-05-23 02:13:00',1,34884,19754,NULL,NULL,NULL,'2024-05-22 19:13:11','2024-05-22 19:13:11'),
(72,2,'debit',NULL,2360000.0000,NULL,'2024-05-23 05:13:00',1,35073,19755,NULL,NULL,NULL,'2024-05-22 22:13:26','2024-05-22 22:13:26'),
(73,2,'debit',NULL,10810000.0000,NULL,'2024-05-23 05:41:00',1,35079,19756,NULL,NULL,NULL,'2024-05-22 22:41:28','2024-05-22 22:41:28'),
(74,2,'credit',NULL,200000.0000,NULL,'2024-05-23 09:41:18',3,34577,19762,NULL,NULL,NULL,'2024-05-23 02:41:18','2024-06-05 03:57:40'),
(75,2,'credit',NULL,1200000.0000,NULL,'2024-05-23 14:11:29',5,35137,19780,NULL,NULL,NULL,'2024-05-23 07:11:29','2024-05-23 07:11:29'),
(76,2,'debit',NULL,665100.0000,NULL,'2024-05-23 15:14:00',1,34944,19785,NULL,NULL,NULL,'2024-05-23 08:14:15','2024-05-23 08:14:15'),
(77,2,'debit',NULL,87400.0000,NULL,'2024-05-23 15:14:00',1,35011,19786,NULL,NULL,NULL,'2024-05-23 08:14:34','2024-05-23 08:14:34'),
(78,2,'debit',NULL,12041000.0000,NULL,'2024-05-23 15:17:00',1,34724,19787,NULL,NULL,NULL,'2024-05-23 08:17:34','2024-05-23 08:17:34'),
(79,2,'debit',NULL,191200.0000,NULL,'2024-05-23 16:39:00',19,35148,19793,NULL,NULL,NULL,'2024-05-23 09:42:09','2024-05-23 09:42:09'),
(80,2,'credit',NULL,350000.0000,NULL,'2024-05-23 16:43:45',19,35150,19795,NULL,NULL,NULL,'2024-05-23 09:43:45','2024-05-23 09:43:45'),
(81,2,'credit',NULL,36000.0000,NULL,'2024-05-23 17:11:25',3,35153,19797,NULL,NULL,NULL,'2024-05-23 10:11:25','2024-05-23 10:11:25'),
(82,2,'credit',NULL,800000.0000,NULL,'2024-05-24 11:20:44',5,35189,19830,NULL,NULL,NULL,'2024-05-24 04:21:01','2024-05-24 04:21:01'),
(83,2,'credit',NULL,100000.0000,NULL,'2024-05-24 17:10:53',49,35158,19853,NULL,NULL,NULL,'2024-05-24 10:10:53','2024-05-24 10:10:53'),
(84,2,'credit',NULL,555000.0000,NULL,'2024-05-24 18:48:13',49,35225,19861,NULL,NULL,NULL,'2024-05-24 11:58:51','2024-05-24 11:58:51'),
(85,2,'credit',NULL,150000.0000,NULL,'2024-05-24 18:48:35',49,34903,19862,NULL,NULL,NULL,'2024-05-24 11:59:12','2024-05-24 11:59:12'),
(86,2,'credit',NULL,80000.0000,NULL,'2024-05-24 20:06:44',6,23816,19869,NULL,NULL,NULL,'2024-05-24 13:06:44','2024-05-24 13:06:44'),
(87,2,'credit',NULL,1055000.0000,NULL,'2024-05-25 09:08:53',3,35236,19875,NULL,NULL,NULL,'2024-05-25 02:08:53','2024-05-25 09:22:42'),
(88,2,'credit',NULL,80000.0000,NULL,'2024-05-25 09:33:39',5,35062,19879,NULL,NULL,NULL,'2024-05-25 02:33:39','2024-05-25 02:33:39'),
(89,2,'credit',NULL,340000.0000,NULL,'2024-05-25 09:35:06',5,35238,19880,NULL,NULL,NULL,'2024-05-25 02:35:06','2024-05-25 02:35:06'),
(90,2,'credit',NULL,180000.0000,NULL,'2024-05-25 10:22:10',3,35138,19885,NULL,NULL,NULL,'2024-05-25 03:22:10','2024-05-25 03:22:10'),
(91,2,'credit',NULL,3995000.0000,NULL,'2024-05-25 15:58:51',5,35268,19904,NULL,NULL,NULL,'2024-05-25 08:58:51','2024-05-25 08:58:51'),
(92,2,'credit',NULL,355000.0000,NULL,'2024-05-25 16:22:42',3,35236,19905,NULL,NULL,NULL,'2024-05-25 09:22:42','2024-05-25 09:22:42'),
(93,2,'credit',NULL,45000.0000,NULL,'2024-05-26 11:45:02',3,35303,19936,NULL,NULL,NULL,'2024-05-26 04:45:02','2024-05-26 04:45:02'),
(94,2,'debit',NULL,11736000.0000,NULL,'2024-05-26 18:32:00',1,35080,19981,NULL,NULL,NULL,'2024-05-26 11:32:30','2024-05-26 11:32:30'),
(95,2,'credit',NULL,300000.0000,NULL,'2024-05-27 17:42:15',5,35370,20024,NULL,NULL,NULL,'2024-05-27 10:42:15','2024-05-27 10:42:15'),
(96,2,'credit',NULL,340000.0000,NULL,'2024-05-27 17:43:34',5,35407,20025,NULL,NULL,NULL,'2024-05-27 10:43:34','2024-05-27 10:43:34'),
(97,2,'credit',NULL,220000.0000,NULL,'2024-05-27 21:16:00',19,35421,20033,NULL,NULL,NULL,'2024-05-27 14:16:19','2024-05-27 14:16:19'),
(98,2,'debit',NULL,3056000.0000,NULL,'2024-05-28 07:47:00',1,35414,20038,NULL,NULL,NULL,'2024-05-28 00:47:33','2024-05-28 00:47:33'),
(99,2,'debit',NULL,568000.0000,NULL,'2024-05-28 07:51:00',1,35017,20039,NULL,NULL,NULL,'2024-05-28 00:51:19','2024-05-28 00:51:19'),
(100,2,'debit',NULL,17190000.0000,NULL,'2024-05-28 09:31:00',1,35435,20042,NULL,NULL,NULL,'2024-05-28 02:31:49','2024-05-28 02:31:49'),
(101,2,'credit',NULL,45000.0000,NULL,'2024-05-28 09:37:45',46,35438,20043,NULL,NULL,NULL,'2024-05-28 02:37:45','2024-05-28 02:37:45'),
(102,2,'debit',NULL,8310000.0000,NULL,'2024-05-28 09:38:00',1,35436,20044,NULL,NULL,NULL,'2024-05-28 02:38:36','2024-05-28 02:38:36'),
(103,2,'debit',NULL,11214100.0000,NULL,'2024-05-28 09:56:00',1,35419,20045,NULL,NULL,NULL,'2024-05-28 02:56:07','2024-05-28 02:56:07'),
(104,2,'debit',NULL,748000.0000,NULL,'2024-05-28 09:58:00',1,35136,20046,NULL,NULL,NULL,'2024-05-28 02:58:20','2024-05-28 02:58:20'),
(105,2,'debit',NULL,1590000.0000,NULL,'2024-05-28 09:59:00',1,35072,20047,NULL,NULL,NULL,'2024-05-28 02:59:08','2024-05-28 02:59:08'),
(106,2,'debit',NULL,4913000.0000,NULL,'2024-05-28 10:00:00',1,35200,20048,NULL,NULL,NULL,'2024-05-28 03:00:43','2024-05-28 03:00:43'),
(107,2,'debit',NULL,450000.0000,NULL,'2024-05-28 10:01:00',1,34910,20049,NULL,NULL,NULL,'2024-05-28 03:01:53','2024-05-28 03:01:53'),
(108,2,'debit',NULL,97050.0000,NULL,'2024-05-28 10:05:00',1,29952,20050,NULL,NULL,NULL,'2024-05-28 03:05:44','2024-05-28 03:05:44'),
(109,2,'debit',NULL,55000.0000,NULL,'2024-05-28 10:28:00',1,33861,20053,NULL,NULL,NULL,'2024-05-28 03:28:41','2024-05-28 03:28:41'),
(110,2,'debit',NULL,610000.0000,NULL,'2024-05-28 10:31:00',1,34806,20054,NULL,NULL,NULL,'2024-05-28 03:31:31','2024-05-28 03:31:31'),
(111,2,'debit',NULL,182600.0000,NULL,'2024-05-28 10:32:00',1,35269,20055,NULL,NULL,NULL,'2024-05-28 03:32:29','2024-05-28 03:32:29'),
(112,2,'debit',NULL,478600.0000,NULL,'2024-05-28 10:34:00',1,35380,20056,NULL,NULL,NULL,'2024-05-28 03:34:23','2024-05-28 03:34:23'),
(113,2,'credit',NULL,75000.0000,NULL,'2024-05-28 11:26:54',3,35450,20061,NULL,NULL,NULL,'2024-05-28 04:26:54','2024-05-28 04:26:54'),
(114,2,'debit',NULL,45121400.0000,NULL,'2024-05-28 12:05:00',1,35440,20065,NULL,NULL,NULL,'2024-05-28 05:05:31','2024-05-28 05:05:31'),
(115,2,'credit',NULL,200000.0000,NULL,'2024-05-28 13:40:07',17,35466,20069,NULL,NULL,NULL,'2024-05-28 06:40:07','2024-05-28 06:40:07'),
(116,2,'credit',NULL,50000.0000,NULL,'2024-05-28 13:40:53',17,35427,20071,NULL,NULL,NULL,'2024-05-28 06:40:53','2024-05-28 06:40:53'),
(117,2,'credit',NULL,17592000.0000,NULL,'2024-05-28 14:03:47',5,35395,20072,NULL,NULL,NULL,'2024-05-28 07:03:47','2024-05-28 07:03:47'),
(118,2,'credit',NULL,2598000.0000,NULL,'2024-05-28 14:19:37',13,35457,20073,NULL,NULL,NULL,'2024-05-28 07:19:37','2024-05-28 07:19:37'),
(119,2,'credit',NULL,250000.0000,NULL,'2024-05-28 18:12:19',19,35490,20101,NULL,NULL,NULL,'2024-05-28 11:12:19','2024-05-28 11:12:19'),
(120,2,'credit',NULL,258800.0000,NULL,'2024-05-28 18:52:27',72,35493,20104,NULL,NULL,NULL,'2024-05-28 11:52:27','2024-05-28 11:52:27'),
(121,2,'credit',NULL,120000.0000,NULL,'2024-05-29 11:03:05',6,31737,20117,NULL,NULL,NULL,'2024-05-29 04:03:05','2024-05-29 04:03:05'),
(122,2,'credit',NULL,520000.0000,NULL,'2024-05-29 11:03:43',6,35519,20118,NULL,NULL,NULL,'2024-05-29 04:03:43','2024-05-29 04:03:43'),
(123,2,'credit',NULL,455500.0000,NULL,'2024-05-29 14:24:43',72,35540,20142,NULL,NULL,NULL,'2024-05-29 07:24:43','2024-05-29 07:24:43'),
(124,2,'credit',NULL,1002000.0000,NULL,'2024-05-29 16:33:31',13,35553,20156,NULL,NULL,NULL,'2024-05-29 09:33:31','2024-05-29 09:33:31'),
(125,2,'credit',NULL,5839000.0000,NULL,'2024-05-29 18:05:59',5,35567,20165,NULL,NULL,NULL,'2024-05-29 11:05:59','2024-05-29 14:37:51'),
(126,2,'credit',NULL,205000.0000,NULL,'2024-05-29 19:09:45',3,35569,20166,NULL,NULL,NULL,'2024-05-29 12:09:45','2024-05-29 12:09:45'),
(127,2,'credit',NULL,73000.0000,NULL,'2024-05-29 20:37:04',5,35576,20170,NULL,NULL,NULL,'2024-05-29 13:37:04','2024-05-29 13:37:04'),
(128,2,'credit',NULL,400000.0000,NULL,'2024-05-29 21:54:48',5,35408,20176,NULL,NULL,NULL,'2024-05-29 14:54:48','2024-05-29 14:54:48'),
(129,2,'credit',NULL,350000.0000,NULL,'2024-05-30 08:58:55',13,34513,20178,NULL,NULL,NULL,'2024-05-30 01:58:55','2024-05-30 01:58:55'),
(130,2,'credit',NULL,800000.0000,NULL,'2024-05-30 08:59:30',13,35586,20179,NULL,NULL,NULL,'2024-05-30 01:59:30','2024-05-30 06:24:20'),
(131,2,'credit',NULL,4355000.0000,NULL,'2024-05-30 12:23:02',6,35606,20196,NULL,NULL,NULL,'2024-05-30 05:23:02','2024-05-30 05:23:02'),
(132,2,'credit',NULL,917000.0000,NULL,'2024-05-30 14:11:51',19,35627,20213,NULL,NULL,NULL,'2024-05-30 07:11:51','2024-05-30 07:11:51'),
(133,2,'credit',NULL,15000.0000,NULL,'2024-05-30 16:49:49',6,35642,20229,NULL,NULL,NULL,'2024-05-30 09:49:49','2024-05-30 09:49:49'),
(134,2,'credit',NULL,340000.0000,NULL,'2024-05-30 17:43:43',17,35655,20251,NULL,NULL,NULL,'2024-05-30 10:44:01','2024-05-30 10:44:01'),
(135,2,'credit',NULL,355000.0000,NULL,'2024-05-30 17:46:27',19,35656,20253,NULL,NULL,NULL,'2024-05-30 10:46:27','2024-05-30 10:46:27'),
(136,2,'credit',NULL,785000.0000,NULL,'2024-05-30 18:44:47',19,35660,20258,NULL,NULL,NULL,'2024-05-30 11:44:47','2024-05-30 11:44:47'),
(137,2,'credit',NULL,2850000.0000,NULL,'2024-05-30 19:58:06',5,35664,20260,NULL,NULL,NULL,'2024-05-30 12:58:06','2024-05-30 12:58:06'),
(138,2,'debit',NULL,9273000.0000,NULL,'2024-05-31 08:03:00',1,35562,20272,NULL,NULL,NULL,'2024-05-31 01:03:13','2024-05-31 01:03:13'),
(139,2,'debit',NULL,9355100.0000,NULL,'2024-05-31 08:27:00',1,35561,20276,NULL,NULL,NULL,'2024-05-31 01:27:24','2024-05-31 01:27:24'),
(140,2,'debit',NULL,828100.0000,NULL,'2024-05-31 08:46:00',1,35520,20277,NULL,NULL,NULL,'2024-05-31 01:46:53','2024-05-31 01:46:53'),
(141,2,'debit',NULL,2154000.0000,NULL,'2024-05-31 08:50:00',1,35563,20278,NULL,NULL,NULL,'2024-05-31 01:50:49','2024-05-31 01:50:49'),
(142,2,'debit',NULL,1444300.0000,NULL,'2024-05-31 08:50:00',1,35593,20279,NULL,NULL,NULL,'2024-05-31 01:51:01','2024-05-31 01:51:01'),
(143,2,'debit',NULL,1303200.0000,NULL,'2024-05-31 08:51:00',1,35558,20280,NULL,NULL,NULL,'2024-05-31 01:51:12','2024-05-31 01:51:12'),
(144,2,'debit',NULL,5250000.0000,NULL,'2024-05-31 08:51:00',1,35666,20281,NULL,NULL,NULL,'2024-05-31 01:51:19','2024-05-31 01:51:19'),
(145,2,'debit',NULL,336500.0000,NULL,'2024-05-31 08:51:00',1,35607,20282,NULL,NULL,NULL,'2024-05-31 01:51:24','2024-05-31 01:51:24'),
(146,2,'credit',NULL,120000.0000,NULL,'2024-05-31 11:10:08',49,35620,20288,NULL,NULL,NULL,'2024-05-31 04:10:08','2024-06-03 02:57:06'),
(147,2,'credit',NULL,127000.0000,NULL,'2024-05-31 11:19:45',49,35686,20289,NULL,NULL,NULL,'2024-05-31 04:19:45','2024-05-31 04:19:45'),
(148,2,'debit',NULL,50087500.0000,NULL,'2024-05-31 13:28:00',1,35675,20299,NULL,NULL,NULL,'2024-05-31 06:28:24','2024-05-31 06:28:24'),
(149,2,'credit',NULL,325000.0000,NULL,'2024-05-31 15:36:39',6,35711,20314,NULL,NULL,NULL,'2024-05-31 08:36:39','2024-05-31 08:36:39'),
(150,2,'credit',NULL,325000.0000,NULL,'2024-05-31 15:37:43',6,35712,20315,NULL,NULL,NULL,'2024-05-31 08:37:43','2024-05-31 08:37:43'),
(151,2,'credit',NULL,125000.0000,NULL,'2024-05-31 15:46:00',17,35714,20317,NULL,NULL,NULL,'2024-05-31 08:47:03','2024-05-31 08:47:03'),
(152,2,'credit',NULL,195000.0000,NULL,'2024-05-31 15:48:51',6,35716,20318,NULL,NULL,NULL,'2024-05-31 08:48:51','2024-05-31 08:48:51'),
(153,2,'credit',NULL,195000.0000,NULL,'2024-05-31 15:50:20',6,35717,20319,NULL,NULL,NULL,'2024-05-31 08:50:20','2024-05-31 08:50:49'),
(154,2,'credit',NULL,1154000.0000,NULL,'2024-05-31 15:51:13',6,34275,20320,NULL,NULL,NULL,'2024-05-31 08:51:13','2024-05-31 08:51:13'),
(155,2,'credit',NULL,150000.0000,NULL,'2024-05-31 15:55:46',6,35718,20321,NULL,NULL,NULL,'2024-05-31 08:55:46','2024-06-01 01:39:34'),
(156,2,'credit',NULL,1975000.0000,NULL,'2024-05-31 16:10:02',49,35588,20324,NULL,NULL,NULL,'2024-05-31 09:10:02','2024-05-31 09:10:02'),
(157,2,'credit',NULL,330000.0000,NULL,'2024-05-31 17:20:38',6,35732,20335,NULL,NULL,NULL,'2024-05-31 10:20:38','2024-05-31 10:20:38'),
(158,2,'debit',NULL,233000.0000,NULL,'2024-05-31 19:12:00',6,35736,20338,NULL,NULL,NULL,'2024-05-31 12:13:26','2024-05-31 12:13:26'),
(159,2,'credit',NULL,750000.0000,NULL,'2024-05-31 19:55:47',17,35742,20341,NULL,NULL,NULL,'2024-05-31 12:55:47','2024-05-31 13:00:19'),
(160,2,'credit',NULL,288000.0000,NULL,'2024-05-31 20:37:41',17,35747,20347,NULL,NULL,NULL,'2024-05-31 13:37:41','2024-05-31 13:37:41'),
(161,2,'credit',NULL,340000.0000,NULL,'2024-06-01 08:58:34',3,35522,20351,NULL,NULL,NULL,'2024-06-01 01:58:34','2024-06-01 01:58:34'),
(162,2,'credit',NULL,40000.0000,NULL,'2024-06-01 09:24:10',3,35275,20356,NULL,NULL,NULL,'2024-06-01 02:24:10','2024-06-01 02:24:10'),
(163,2,'credit',NULL,202000.0000,NULL,'2024-06-01 09:48:33',6,35766,20364,NULL,NULL,NULL,'2024-06-01 02:48:33','2024-06-01 02:48:33'),
(164,2,'credit',NULL,1160000.0000,NULL,'2024-06-01 10:10:08',3,35058,20365,NULL,NULL,NULL,'2024-06-01 03:10:08','2024-06-12 06:10:53'),
(165,2,'credit',NULL,187000.0000,NULL,'2024-06-01 10:15:08',6,35767,20367,NULL,NULL,NULL,'2024-06-01 03:15:08','2024-06-01 03:15:08'),
(166,2,'credit',NULL,150000.0000,NULL,'2024-06-01 10:56:54',3,35776,20377,NULL,NULL,NULL,'2024-06-01 03:56:54','2024-06-01 03:56:54'),
(167,2,'credit',NULL,150000.0000,NULL,'2024-06-01 10:57:10',3,35777,20378,NULL,NULL,NULL,'2024-06-01 03:57:10','2024-06-01 03:57:10'),
(168,2,'credit',NULL,105000.0000,NULL,'2024-06-01 12:00:53',6,35789,20393,NULL,NULL,NULL,'2024-06-01 05:00:53','2024-06-01 05:00:53'),
(169,2,'credit',NULL,383000.0000,NULL,'2024-06-01 12:29:03',3,35555,20400,NULL,NULL,NULL,'2024-06-01 05:29:03','2024-06-01 05:29:03'),
(170,2,'credit',NULL,120000.0000,NULL,'2024-06-01 14:19:24',19,35543,20405,NULL,NULL,NULL,'2024-06-01 07:19:24','2024-06-01 07:19:24'),
(171,2,'credit',NULL,385000.0000,NULL,'2024-06-01 14:20:02',19,35802,20406,NULL,NULL,NULL,'2024-06-01 07:20:02','2024-06-01 07:20:02'),
(172,2,'credit',NULL,165000.0000,NULL,'2024-06-01 17:01:15',3,35823,20423,NULL,NULL,NULL,'2024-06-01 10:01:15','2024-06-01 10:01:15'),
(173,2,'credit',NULL,402000.0000,NULL,'2024-06-01 19:11:11',5,35833,20447,NULL,NULL,NULL,'2024-06-01 12:11:11','2024-06-01 12:11:11'),
(174,2,'credit',NULL,463000.0000,NULL,'2024-06-01 19:52:40',17,35835,20448,NULL,NULL,NULL,'2024-06-01 12:52:40','2024-06-01 12:52:40'),
(175,2,'credit',NULL,246000.0000,NULL,'2024-06-01 20:15:54',17,35840,20451,NULL,NULL,NULL,'2024-06-01 13:15:54','2024-06-01 13:15:54'),
(176,2,'credit',NULL,200000.0000,NULL,'2024-06-02 09:39:10',3,35591,20456,NULL,NULL,NULL,'2024-06-02 02:39:10','2024-07-25 13:29:00'),
(177,2,'credit',NULL,960000.0000,NULL,'2024-06-02 11:12:39',49,35847,20460,NULL,NULL,'2024-06-07 14:08:13','2024-06-02 04:12:39','2024-06-07 14:08:13'),
(178,2,'credit',NULL,607000.0000,NULL,'2024-06-02 11:38:21',49,35851,20463,NULL,NULL,NULL,'2024-06-02 04:38:21','2024-06-02 04:38:21'),
(179,2,'credit',NULL,428000.0000,NULL,'2024-06-02 14:57:07',46,35862,20477,NULL,NULL,NULL,'2024-06-02 07:58:09','2024-06-02 07:58:09'),
(180,2,'debit',NULL,7317500.0000,NULL,'2024-06-02 15:21:00',1,35713,20479,NULL,NULL,NULL,'2024-06-02 08:21:34','2024-06-02 08:21:34'),
(181,2,'debit',NULL,5150000.0000,NULL,'2024-06-02 15:21:00',1,35709,20480,NULL,NULL,NULL,'2024-06-02 08:21:46','2024-06-02 08:21:46'),
(182,2,'credit',NULL,945000.0000,NULL,'2024-06-02 15:47:59',3,35866,20488,NULL,NULL,NULL,'2024-06-02 08:47:59','2024-06-02 10:51:27'),
(183,2,'credit',NULL,40000.0000,NULL,'2024-06-02 17:18:31',46,35883,20506,NULL,NULL,NULL,'2024-06-02 10:18:31','2024-06-02 10:18:31'),
(184,2,'credit',NULL,100000.0000,NULL,'2024-06-02 17:51:12',17,35886,20509,NULL,NULL,NULL,'2024-06-02 10:51:12','2024-06-02 10:51:12'),
(185,2,'credit',NULL,250000.0000,NULL,'2024-06-02 18:22:16',17,35844,20510,NULL,NULL,NULL,'2024-06-02 11:22:16','2024-06-02 11:22:16'),
(186,2,'credit',NULL,329000.0000,NULL,'2024-06-02 19:23:14',17,35891,20517,NULL,NULL,NULL,'2024-06-02 12:23:14','2024-06-02 12:23:14'),
(187,2,'credit',NULL,180000.0000,NULL,'2024-06-02 19:23:29',17,35514,20518,NULL,NULL,NULL,'2024-06-02 12:23:29','2024-06-02 12:23:29'),
(188,2,'credit',NULL,390000.0000,NULL,'2024-06-02 19:41:35',17,35741,20519,NULL,NULL,NULL,'2024-06-02 12:41:35','2024-06-02 12:41:35'),
(189,2,'credit',NULL,549000.0000,NULL,'2024-06-02 19:41:37',17,35892,20520,NULL,NULL,NULL,'2024-06-02 12:41:38','2024-06-02 12:41:38'),
(190,2,'credit',NULL,785000.0000,NULL,'2024-06-02 20:59:24',17,35897,20524,NULL,NULL,NULL,'2024-06-02 13:59:24','2024-06-02 13:59:24'),
(191,2,'credit',NULL,45000.0000,NULL,'2024-06-02 21:06:20',46,35898,20525,NULL,NULL,NULL,'2024-06-02 14:06:20','2024-06-02 14:06:20'),
(192,2,'credit',NULL,3000000.0000,NULL,'2024-06-03 10:26:41',3,35912,20553,NULL,NULL,NULL,'2024-06-03 03:26:41','2024-06-11 13:10:51'),
(193,2,'credit',NULL,375000.0000,NULL,'2024-06-03 11:20:50',13,35919,20557,NULL,NULL,NULL,'2024-06-03 04:20:50','2024-06-03 04:20:50'),
(194,2,'credit',NULL,3938280.0000,NULL,'2024-06-03 12:01:42',3,34584,20563,NULL,NULL,NULL,'2024-06-03 05:01:42','2024-06-30 05:49:58'),
(195,2,'credit',NULL,231100.0000,NULL,'2024-06-03 12:56:32',19,35929,20567,NULL,NULL,NULL,'2024-06-03 05:56:32','2024-06-08 03:17:55'),
(196,2,'credit',NULL,2285000.0000,NULL,'2024-06-03 13:30:30',17,35932,20569,NULL,NULL,NULL,'2024-06-03 06:30:30','2024-06-03 06:30:30'),
(197,2,'credit',NULL,48000.0000,NULL,'2024-06-03 16:03:53',17,35953,20602,NULL,NULL,NULL,'2024-06-03 09:03:53','2024-06-03 09:03:53'),
(198,2,'credit',NULL,3938280.0000,NULL,'2024-06-03 16:24:15',3,34584,20603,NULL,NULL,'2024-06-06 03:49:39','2024-06-03 09:24:15','2024-06-06 03:49:39'),
(199,2,'credit',NULL,4640000.0000,NULL,'2024-06-03 17:29:07',5,35912,20610,NULL,NULL,NULL,'2024-06-03 10:29:07','2024-06-11 13:10:51'),
(200,2,'credit',NULL,200000.0000,NULL,'2024-06-04 13:26:14',3,35605,20667,NULL,NULL,NULL,'2024-06-04 06:26:14','2024-07-08 07:02:34'),
(201,2,'credit',NULL,930000.0000,NULL,'2024-06-04 14:00:34',5,36054,20672,NULL,NULL,NULL,'2024-06-04 07:00:34','2024-06-04 07:01:04'),
(202,2,'credit',NULL,930000.0000,NULL,'2024-06-04 14:02:07',5,36055,20673,NULL,NULL,NULL,'2024-06-04 07:02:07','2024-06-04 07:03:47'),
(203,2,'credit',NULL,310000.0000,NULL,'2024-06-04 14:03:27',5,36057,20675,NULL,NULL,NULL,'2024-06-04 07:03:27','2024-06-04 07:03:27'),
(204,2,'credit',NULL,155000.0000,NULL,'2024-06-04 14:05:39',3,36058,20676,NULL,NULL,NULL,'2024-06-04 07:05:39','2024-06-04 07:05:39'),
(205,2,'credit',NULL,155000.0000,NULL,'2024-06-04 14:05:52',3,36059,20677,NULL,NULL,NULL,'2024-06-04 07:05:52','2024-06-04 07:05:52'),
(206,2,'credit',NULL,310000.0000,NULL,'2024-06-04 14:06:10',3,36060,20678,NULL,NULL,NULL,'2024-06-04 07:06:10','2024-06-04 07:06:10'),
(207,2,'credit',NULL,10654500.0000,NULL,'2024-06-04 14:07:42',5,33925,20679,NULL,NULL,NULL,'2024-06-04 07:07:42','2024-06-21 04:58:31'),
(208,2,'credit',NULL,5000000.0000,NULL,'2024-06-04 15:33:48',6,36079,20687,NULL,NULL,NULL,'2024-06-04 08:33:48','2024-06-06 14:35:54'),
(209,2,'credit',NULL,1250000.0000,NULL,'2024-06-04 20:27:07',6,36114,20711,NULL,NULL,NULL,'2024-06-04 13:27:07','2024-06-04 13:27:07'),
(210,2,'credit',NULL,587000.0000,NULL,'2024-06-05 09:01:47',19,36127,20727,NULL,NULL,NULL,'2024-06-05 02:01:47','2024-06-05 02:01:47'),
(211,2,'credit',NULL,650000.0000,NULL,'2024-06-05 10:31:57',13,34577,20736,NULL,NULL,NULL,'2024-06-05 03:31:57','2024-06-05 03:57:40'),
(212,2,'credit',NULL,370000.0000,NULL,'2024-06-05 15:28:09',13,36180,20754,NULL,NULL,NULL,'2024-06-05 08:28:09','2024-06-05 08:28:09'),
(213,2,'credit',NULL,150000.0000,NULL,'2024-06-05 16:16:45',13,36138,20761,NULL,NULL,NULL,'2024-06-05 09:16:45','2024-06-05 09:16:45'),
(214,2,'credit',NULL,2940000.0000,NULL,'2024-06-06 09:57:00',49,36249,20802,NULL,NULL,NULL,'2024-06-06 02:57:00','2024-06-06 02:57:00'),
(215,2,'credit',NULL,150000.0000,NULL,'2024-06-06 10:02:31',19,36251,20803,NULL,NULL,NULL,'2024-06-06 03:02:31','2024-06-06 03:02:31'),
(216,2,'credit',NULL,110000.0000,NULL,'2024-06-06 11:25:05',49,36263,20811,NULL,NULL,NULL,'2024-06-06 04:25:05','2024-06-06 04:25:05'),
(217,2,'debit',NULL,67300.0000,NULL,'2024-06-06 12:22:00',19,36267,20824,NULL,NULL,NULL,'2024-06-06 05:24:08','2024-06-06 05:24:08'),
(218,2,'credit',NULL,150000.0000,NULL,'2024-06-06 15:52:15',5,36299,20865,NULL,NULL,NULL,'2024-06-06 08:52:15','2024-06-06 08:52:15'),
(219,2,'credit',NULL,2000000.0000,NULL,'2024-06-06 16:04:30',3,35820,20870,NULL,NULL,NULL,'2024-06-06 09:04:30','2024-06-30 05:36:50'),
(220,2,'credit',NULL,200000.0000,NULL,'2024-06-06 17:05:48',3,36239,20879,NULL,NULL,NULL,'2024-06-06 10:05:48','2024-11-30 04:38:00'),
(221,2,'credit',NULL,200000.0000,NULL,'2024-06-06 20:48:38',5,35882,20907,NULL,NULL,NULL,'2024-06-06 13:48:38','2024-07-03 08:48:43'),
(222,2,'credit',NULL,4389000.0000,NULL,'2024-06-06 21:32:11',6,36079,20912,NULL,NULL,NULL,'2024-06-06 14:32:11','2024-06-06 14:35:55'),
(223,2,'credit',NULL,785000.0000,NULL,'2024-06-06 21:33:12',5,36355,20913,NULL,NULL,NULL,'2024-06-06 14:33:12','2024-06-06 14:33:12'),
(224,2,'credit',NULL,2850000.0000,NULL,'2024-06-07 11:51:08',13,36383,20930,NULL,NULL,NULL,'2024-06-07 04:51:08','2024-06-07 04:51:08'),
(225,2,'debit',NULL,366000.0000,NULL,'2024-06-07 12:29:00',3,36386,20934,NULL,NULL,NULL,'2024-06-07 05:33:14','2024-06-07 05:33:14'),
(226,2,'debit',NULL,3520000.0000,NULL,'2024-06-07 15:24:00',19,36417,20952,NULL,NULL,NULL,'2024-06-07 08:28:51','2024-06-07 08:28:51'),
(227,2,'credit',NULL,2000000.0000,NULL,'2024-06-07 15:30:20',19,36418,20953,NULL,NULL,NULL,'2024-06-07 08:30:20','2024-06-13 04:55:03'),
(228,2,'credit',NULL,375000.0000,NULL,'2024-06-07 19:56:11',5,36442,20971,NULL,NULL,NULL,'2024-06-07 12:56:11','2024-06-07 12:56:11'),
(229,2,'credit',NULL,960000.0000,NULL,'2024-06-07 21:11:14',5,36451,20978,NULL,NULL,NULL,'2024-06-07 14:11:14','2024-06-07 14:11:14'),
(230,2,'credit',NULL,200000.0000,NULL,'2024-06-07 21:44:38',6,36333,20985,NULL,NULL,NULL,'2024-06-07 14:48:54','2024-06-30 07:33:14'),
(231,2,'debit',NULL,46910000.0000,NULL,'2024-06-07 23:13:00',1,36390,20986,NULL,NULL,NULL,'2024-06-07 16:13:18','2024-06-07 16:13:18'),
(232,2,'debit',NULL,36973800.0000,NULL,'2024-06-07 23:23:00',1,36392,20987,NULL,NULL,NULL,'2024-06-07 16:23:42','2024-06-07 16:23:42'),
(233,2,'debit',NULL,11723700.0000,NULL,'2024-06-07 23:33:00',1,36440,20988,NULL,NULL,NULL,'2024-06-07 16:33:20','2024-06-07 16:33:20'),
(234,2,'debit',NULL,19542300.0000,NULL,'2024-06-07 23:50:00',1,36389,20989,NULL,NULL,NULL,'2024-06-07 16:50:54','2024-06-07 16:50:54'),
(235,2,'debit',NULL,14800.0000,NULL,'2024-06-07 23:53:00',1,36304,20990,NULL,NULL,NULL,'2024-06-07 16:53:52','2024-06-07 16:53:52'),
(236,2,'debit',NULL,8107000.0000,NULL,'2024-06-07 23:55:00',1,36113,20991,NULL,NULL,NULL,'2024-06-07 16:55:18','2024-06-07 16:55:18'),
(237,2,'debit',NULL,11365000.0000,NULL,'2024-06-07 23:55:00',1,35813,20992,NULL,NULL,NULL,'2024-06-07 16:55:52','2024-06-07 16:55:52'),
(238,2,'debit',NULL,6185000.0000,NULL,'2024-06-07 23:56:00',1,35825,20993,NULL,NULL,NULL,'2024-06-07 16:56:41','2024-06-07 16:56:41'),
(239,2,'debit',NULL,338200.0000,NULL,'2024-06-07 23:57:00',1,35758,20994,NULL,NULL,NULL,'2024-06-07 16:57:23','2024-06-07 16:57:23'),
(240,2,'debit',NULL,5008750.0000,NULL,'2024-06-07 23:58:00',1,36266,20995,NULL,NULL,NULL,'2024-06-07 16:58:22','2024-06-07 16:58:22'),
(241,2,'debit',NULL,226000.0000,NULL,'2024-06-07 23:59:00',1,36082,20996,NULL,NULL,NULL,'2024-06-07 16:59:20','2024-06-07 16:59:20'),
(242,2,'debit',NULL,13544200.0000,NULL,'2024-06-08 12:33:00',1,36468,21007,NULL,NULL,'2024-06-09 02:05:02','2024-06-08 05:33:21','2024-06-09 02:05:02'),
(243,2,'debit',NULL,368000.0000,NULL,'2024-06-08 15:44:00',19,36525,21023,NULL,NULL,NULL,'2024-06-08 08:48:17','2024-06-08 08:48:17'),
(244,2,'credit',NULL,5839000.0000,NULL,'2024-06-08 19:59:52',6,36536,21034,NULL,NULL,NULL,'2024-06-08 12:59:52','2024-06-08 12:59:52'),
(245,2,'credit',NULL,550000.0000,NULL,'2024-06-08 21:02:00',6,34113,21037,NULL,NULL,NULL,'2024-06-08 14:02:00','2024-06-08 14:04:16'),
(246,2,'credit',NULL,399000.0000,NULL,'2024-06-08 21:02:39',6,36538,21038,NULL,NULL,NULL,'2024-06-08 14:02:39','2024-06-08 14:02:39'),
(247,2,'debit',NULL,5772600.0000,NULL,'2024-06-09 08:49:00',1,36545,21042,NULL,NULL,'2024-06-13 06:18:50','2024-06-09 01:49:05','2024-06-13 06:18:50'),
(248,2,'debit',NULL,13724200.0000,NULL,'2024-06-09 09:05:00',1,36468,21043,NULL,NULL,NULL,'2024-06-09 02:05:16','2024-06-09 02:05:16'),
(249,2,'debit',NULL,1658000.0000,NULL,'2024-06-09 09:06:00',1,36547,21044,NULL,NULL,'2024-06-19 02:40:01','2024-06-09 02:06:42','2024-06-19 02:40:01'),
(250,2,'debit',NULL,13976400.0000,NULL,'2024-06-09 09:06:00',1,36391,21045,NULL,NULL,NULL,'2024-06-09 02:06:55','2024-06-09 02:06:55'),
(251,2,'debit',NULL,501400.0000,NULL,'2024-06-09 09:29:00',1,36552,21046,NULL,NULL,NULL,'2024-06-09 02:29:39','2024-06-09 02:29:39'),
(252,2,'debit',NULL,1011600.0000,NULL,'2024-06-09 09:35:00',1,36523,21047,NULL,NULL,NULL,'2024-06-09 02:35:15','2024-06-09 02:35:15'),
(253,2,'debit',NULL,5014000.0000,NULL,'2024-06-09 09:36:00',1,36541,21048,NULL,NULL,NULL,'2024-06-09 02:36:51','2024-06-09 02:36:51'),
(254,2,'debit',NULL,7491400.0000,NULL,'2024-06-09 09:37:00',1,36546,21049,NULL,NULL,'2024-06-13 06:29:41','2024-06-09 02:37:21','2024-06-13 06:29:41'),
(255,2,'credit',NULL,200000.0000,NULL,'2024-06-09 14:41:36',13,36549,21071,NULL,NULL,NULL,'2024-06-09 07:41:36','2024-07-03 05:39:58'),
(256,2,'credit',NULL,1387000.0000,NULL,'2024-06-09 17:11:59',5,36611,21081,NULL,NULL,NULL,'2024-06-09 10:11:59','2024-06-09 10:11:59'),
(257,2,'credit',NULL,2000000.0000,NULL,'2024-06-09 17:19:21',6,36613,21082,NULL,NULL,NULL,'2024-06-09 10:19:21','2024-06-09 13:26:49'),
(258,2,'credit',NULL,210000.0000,NULL,'2024-06-09 19:39:56',49,36612,21089,NULL,NULL,NULL,'2024-06-09 12:39:56','2024-06-30 04:53:42'),
(259,2,'credit',NULL,5150000.0000,NULL,'2024-06-09 20:17:00',19,36613,21096,NULL,NULL,NULL,'2024-06-09 13:20:00','2024-06-09 13:26:49'),
(260,2,'credit',NULL,916000.0000,NULL,'2024-06-09 20:24:00',19,36624,21097,NULL,NULL,NULL,'2024-06-09 13:24:58','2024-06-09 13:24:58'),
(261,2,'credit',NULL,516000.0000,NULL,'2024-06-09 20:27:35',19,36625,21098,NULL,NULL,NULL,'2024-06-09 13:27:35','2024-06-30 08:15:57'),
(262,2,'credit',NULL,2624000.0000,NULL,'2024-06-09 20:38:59',49,36636,21101,NULL,NULL,NULL,'2024-06-09 13:38:59','2024-06-09 13:38:59'),
(263,2,'debit',NULL,123000.0000,NULL,'2024-06-10 12:55:00',6,36672,21125,NULL,NULL,NULL,'2024-06-10 06:01:40','2024-06-10 06:01:40'),
(264,2,'credit',NULL,5922000.0000,NULL,'2024-06-10 14:31:35',13,36675,21131,NULL,NULL,NULL,'2024-06-10 07:31:35','2024-06-10 07:31:35'),
(265,2,'credit',NULL,200000.0000,NULL,'2024-06-10 21:26:59',49,36587,21158,NULL,NULL,NULL,'2024-06-10 14:26:59','2024-07-04 05:49:33'),
(266,2,'debit',NULL,4800000.0000,NULL,'2024-06-11 08:58:00',1,36716,21162,NULL,NULL,NULL,'2024-06-11 01:58:05','2024-06-11 01:58:05'),
(267,2,'credit',NULL,3938280.0000,NULL,'2024-06-11 12:38:56',5,36260,21187,NULL,NULL,NULL,'2024-06-11 05:38:56','2024-06-30 05:50:12'),
(268,2,'credit',NULL,5246000.0000,NULL,'2024-06-11 15:17:59',46,36659,21203,NULL,NULL,NULL,'2024-06-11 08:17:59','2024-07-01 09:59:51'),
(269,2,'credit',NULL,1015000.0000,NULL,'2024-06-11 16:57:44',6,36799,21218,NULL,NULL,NULL,'2024-06-11 09:57:44','2024-06-11 09:57:44'),
(270,2,'credit',NULL,235000.0000,NULL,'2024-06-11 17:45:00',3,36710,21220,NULL,NULL,NULL,'2024-06-11 10:45:00','2024-06-11 10:45:00'),
(271,2,'debit',NULL,17719100.0000,NULL,'2024-06-11 19:04:00',1,36775,21232,NULL,NULL,NULL,'2024-06-11 12:04:31','2024-06-11 12:04:31'),
(272,2,'debit',NULL,15595000.0000,NULL,'2024-06-11 19:13:00',1,36803,21233,NULL,NULL,NULL,'2024-06-11 12:13:37','2024-06-11 12:13:37'),
(273,2,'debit',NULL,7341300.0000,NULL,'2024-06-11 19:25:00',1,36774,21234,NULL,NULL,NULL,'2024-06-11 12:25:37','2024-06-11 12:25:37'),
(274,2,'credit',NULL,213000.0000,NULL,'2024-06-11 19:29:56',46,36814,21235,NULL,NULL,NULL,'2024-06-11 12:29:56','2024-06-11 12:29:56'),
(275,2,'debit',NULL,7162300.0000,NULL,'2024-06-11 19:52:00',1,36736,21242,NULL,NULL,NULL,'2024-06-11 12:52:33','2024-06-11 12:52:33'),
(276,2,'debit',NULL,7216000.0000,NULL,'2024-06-11 20:42:00',1,36715,21246,NULL,NULL,NULL,'2024-06-11 13:42:41','2024-06-11 13:42:41'),
(277,2,'debit',NULL,4483000.0000,NULL,'2024-06-11 20:48:00',1,36563,21247,NULL,NULL,NULL,'2024-06-11 13:48:07','2024-06-11 13:48:07'),
(278,2,'debit',NULL,2145800.0000,NULL,'2024-06-11 21:00:00',1,36557,21248,NULL,NULL,NULL,'2024-06-11 14:00:46','2024-06-11 14:00:46'),
(279,2,'debit',NULL,3985000.0000,NULL,'2024-06-11 21:04:00',1,36542,21249,NULL,NULL,'2024-06-13 06:24:47','2024-06-11 14:04:14','2024-06-13 06:24:47'),
(280,2,'credit',NULL,200000.0000,NULL,'2024-06-12 09:28:13',6,36757,21255,NULL,NULL,NULL,'2024-06-12 02:28:13','2024-06-15 09:40:26'),
(281,2,'debit',NULL,4878000.0000,NULL,'2024-06-12 09:45:00',1,36652,21256,NULL,NULL,NULL,'2024-06-12 02:45:46','2024-06-12 02:45:46'),
(282,2,'debit',NULL,43000.0000,NULL,'2024-06-12 09:47:00',1,36693,21257,NULL,NULL,'2024-07-18 13:49:24','2024-06-12 02:47:29','2024-07-18 13:49:24'),
(283,2,'debit',NULL,224000.0000,NULL,'2024-06-12 09:48:00',1,36532,21258,NULL,NULL,NULL,'2024-06-12 02:49:00','2024-06-12 02:49:00'),
(284,2,'credit',NULL,1990000.0000,NULL,'2024-06-12 13:12:41',13,36877,21278,NULL,NULL,NULL,'2024-06-12 06:12:41','2024-06-12 06:14:37'),
(285,2,'credit',NULL,1270000.0000,NULL,'2024-06-12 13:56:33',46,36880,21281,NULL,NULL,NULL,'2024-06-12 06:56:33','2024-06-12 06:56:33'),
(286,2,'credit',NULL,670000.0000,NULL,'2024-06-12 15:44:28',3,36888,21285,NULL,NULL,NULL,'2024-06-12 08:44:28','2024-06-13 10:17:50'),
(287,2,'credit',NULL,150000.0000,NULL,'2024-06-12 16:14:33',46,36890,21286,NULL,NULL,NULL,'2024-06-12 09:14:33','2024-06-12 09:14:33'),
(288,2,'debit',NULL,62000.0000,NULL,'2024-06-12 18:50:00',3,36905,21297,NULL,NULL,NULL,'2024-06-12 12:19:41','2024-06-12 12:19:41'),
(289,2,'debit',NULL,208000.0000,NULL,'2024-06-13 09:44:00',1,36868,21311,NULL,NULL,NULL,'2024-06-13 02:44:48','2024-06-13 02:44:48'),
(290,2,'credit',NULL,1925000.0000,NULL,'2024-06-13 11:55:03',19,36418,21321,NULL,NULL,NULL,'2024-06-13 04:55:03','2024-06-13 04:55:03'),
(291,2,'debit',NULL,28863000.0000,NULL,'2024-06-13 13:18:00',1,36545,21332,NULL,NULL,NULL,'2024-06-13 06:19:02','2024-06-13 06:19:02'),
(292,2,'debit',NULL,14665000.0000,NULL,'2024-06-13 13:24:00',1,36542,21333,NULL,NULL,NULL,'2024-06-13 06:25:06','2024-06-13 06:25:06'),
(293,2,'debit',NULL,11744200.0000,NULL,'2024-06-13 13:29:00',1,36546,21334,NULL,NULL,'2024-06-14 03:25:07','2024-06-13 06:29:55','2024-06-14 03:25:07'),
(294,2,'credit',NULL,2285000.0000,NULL,'2024-06-13 16:30:22',13,37018,21343,NULL,NULL,NULL,'2024-06-13 09:30:22','2024-06-13 09:30:22'),
(295,2,'credit',NULL,81000.0000,NULL,'2024-06-14 08:44:11',13,37069,21376,NULL,NULL,NULL,'2024-06-14 01:44:11','2024-06-14 01:44:11'),
(296,2,'credit',NULL,475000.0000,NULL,'2024-06-14 09:40:07',46,37077,21380,NULL,NULL,NULL,'2024-06-14 02:40:07','2024-06-14 02:40:07'),
(297,2,'debit',NULL,185000.0000,NULL,'2024-06-14 10:06:00',1,36179,21381,NULL,NULL,NULL,'2024-06-14 03:06:25','2024-06-14 03:06:25'),
(298,2,'debit',NULL,12114500.0000,NULL,'2024-06-14 10:25:00',1,36546,21383,NULL,NULL,NULL,'2024-06-14 03:25:18','2024-06-14 03:25:18'),
(299,2,'credit',NULL,189500.0000,NULL,'2024-06-14 10:34:47',13,37082,21384,NULL,NULL,NULL,'2024-06-14 03:35:09','2024-06-14 03:35:09'),
(300,2,'credit',NULL,250000.0000,NULL,'2024-06-14 12:32:08',13,37096,21396,NULL,NULL,NULL,'2024-06-14 05:32:08','2024-06-14 05:32:08'),
(301,2,'credit',NULL,6124425.0000,NULL,'2024-06-14 15:46:48',5,34409,21413,NULL,NULL,NULL,'2024-06-14 08:46:48','2024-06-25 04:08:27'),
(302,2,'credit',NULL,530000.0000,NULL,'2024-06-14 21:42:01',46,37178,21437,NULL,NULL,NULL,'2024-06-14 14:42:01','2024-06-14 14:42:01'),
(303,2,'credit',NULL,591000.0000,NULL,'2024-06-15 12:08:19',5,37194,21448,NULL,NULL,NULL,'2024-06-15 05:08:19','2024-06-15 05:58:19'),
(304,2,'credit',NULL,155000.0000,NULL,'2024-06-15 12:52:05',6,37197,21452,NULL,NULL,NULL,'2024-06-15 05:52:05','2024-06-15 05:52:05'),
(305,2,'credit',NULL,77000.0000,NULL,'2024-06-15 14:15:29',6,37206,21458,NULL,NULL,NULL,'2024-06-15 07:15:29','2024-06-15 07:15:29'),
(306,2,'credit',NULL,881600.0000,NULL,'2024-06-15 14:49:13',6,36832,21461,NULL,NULL,NULL,'2024-06-15 07:49:13','2024-06-15 07:49:13'),
(307,2,'credit',NULL,500000.0000,NULL,'2024-06-15 16:40:27',6,36757,21470,NULL,NULL,NULL,'2024-06-15 09:40:27','2024-06-15 09:40:27'),
(308,2,'credit',NULL,200000.0000,NULL,'2024-06-16 09:49:44',19,37088,21499,NULL,NULL,NULL,'2024-06-16 02:49:44','2024-08-06 04:53:25'),
(309,2,'credit',NULL,215000.0000,NULL,'2024-06-16 10:27:28',19,37261,21502,NULL,NULL,NULL,'2024-06-16 03:27:28','2024-06-16 03:27:28'),
(310,2,'credit',NULL,230000.0000,NULL,'2024-06-16 10:30:21',19,35715,21503,NULL,NULL,NULL,'2024-06-16 03:30:21','2024-06-16 03:30:21'),
(311,2,'credit',NULL,843000.0000,NULL,'2024-06-16 10:31:12',19,37262,21504,NULL,NULL,NULL,'2024-06-16 03:31:12','2024-06-16 03:31:12'),
(312,2,'credit',NULL,160000.0000,NULL,'2024-06-16 10:24:00',19,36960,21501,NULL,NULL,NULL,'2024-06-16 03:31:58','2024-06-16 03:31:58'),
(313,2,'credit',NULL,240000.0000,NULL,'2024-06-16 13:06:30',13,37275,21516,NULL,NULL,NULL,'2024-06-16 06:07:03','2024-06-16 06:07:03'),
(314,2,'credit',NULL,228000.0000,NULL,'2024-06-16 16:53:23',17,37307,21530,NULL,NULL,NULL,'2024-06-16 09:53:23','2024-06-16 09:53:23'),
(315,2,'credit',NULL,2285000.0000,NULL,'2024-06-16 16:58:25',19,37308,21531,NULL,NULL,NULL,'2024-06-16 09:58:25','2024-06-16 09:58:25'),
(316,2,'credit',NULL,117000.0000,NULL,'2024-06-16 17:00:18',17,37309,21532,NULL,NULL,NULL,'2024-06-16 10:00:18','2024-06-16 10:00:18'),
(317,2,'credit',NULL,785000.0000,NULL,'2024-06-16 17:19:26',19,37313,21535,NULL,NULL,NULL,'2024-06-16 10:19:26','2024-06-16 10:19:26'),
(318,2,'credit',NULL,200000.0000,NULL,'2024-06-18 11:04:45',6,37226,21554,NULL,NULL,NULL,'2024-06-18 04:04:45','2024-06-30 07:30:14'),
(319,2,'credit',NULL,3550000.0000,NULL,'2024-06-18 12:46:54',5,37361,21568,NULL,NULL,NULL,'2024-06-18 05:46:54','2024-06-27 02:24:14'),
(320,2,'credit',NULL,1587000.0000,NULL,'2024-06-18 20:20:00',19,33542,21588,NULL,NULL,NULL,'2024-06-18 13:20:46','2024-07-01 09:59:32'),
(321,2,'debit',NULL,28700000.0000,NULL,'2024-06-19 09:09:00',1,37367,21596,NULL,NULL,NULL,'2024-06-19 02:09:49','2024-06-19 02:09:49'),
(322,2,'debit',NULL,13362600.0000,NULL,'2024-06-19 09:12:00',1,37390,21597,NULL,NULL,NULL,'2024-06-19 02:13:01','2024-06-19 02:13:01'),
(323,2,'debit',NULL,6840000.0000,NULL,'2024-06-19 09:15:00',1,37301,21598,NULL,NULL,NULL,'2024-06-19 02:15:41','2024-06-19 02:15:41'),
(324,2,'debit',NULL,915000.0000,NULL,'2024-06-19 09:20:00',1,37211,21599,NULL,NULL,'2024-06-19 02:30:32','2024-06-19 02:20:07','2024-06-19 02:30:32'),
(325,2,'debit',NULL,5731200.0000,NULL,'2024-06-19 09:25:00',1,37191,21601,NULL,NULL,NULL,'2024-06-19 02:25:07','2024-06-19 02:25:07'),
(326,2,'debit',NULL,560000.0000,NULL,'2024-06-19 09:26:00',1,37115,21602,NULL,NULL,NULL,'2024-06-19 02:26:37','2024-06-19 02:26:37'),
(327,2,'debit',NULL,86400.0000,NULL,'2024-06-19 09:27:00',1,36829,21603,NULL,NULL,NULL,'2024-06-19 02:27:32','2024-06-19 02:27:32'),
(328,2,'debit',NULL,936000.0000,NULL,'2024-06-19 09:30:00',1,37211,21604,NULL,NULL,NULL,'2024-06-19 02:30:39','2024-06-19 02:30:39'),
(329,2,'debit',NULL,42114800.0000,NULL,'2024-06-19 09:59:00',1,37382,21605,NULL,NULL,NULL,'2024-06-19 02:59:20','2024-06-19 02:59:20'),
(330,2,'debit',NULL,7725000.0000,NULL,'2024-06-19 10:10:00',1,37302,21606,NULL,NULL,NULL,'2024-06-19 03:10:16','2024-06-19 03:10:16'),
(331,2,'debit',NULL,410000.0000,NULL,'2024-06-20 10:02:00',6,37501,21667,NULL,NULL,NULL,'2024-06-20 03:02:51','2024-06-20 03:02:51'),
(332,2,'credit',NULL,739000.0000,NULL,'2024-06-20 10:12:51',17,37502,21668,NULL,NULL,NULL,'2024-06-20 03:12:51','2024-06-20 03:12:51'),
(333,2,'credit',NULL,300000.0000,NULL,'2024-06-20 10:20:08',6,37182,21669,NULL,NULL,NULL,'2024-06-20 03:20:08','2024-06-30 07:30:27'),
(334,2,'credit',NULL,6609000.0000,NULL,'2024-06-20 10:28:56',17,36909,21670,NULL,NULL,NULL,'2024-06-20 03:28:56','2024-06-20 03:28:56'),
(335,2,'credit',NULL,6500000.0000,NULL,'2024-06-20 10:56:52',6,37506,21673,NULL,NULL,NULL,'2024-06-20 03:56:52','2024-06-28 07:32:35'),
(336,2,'credit',NULL,262000.0000,NULL,'2024-06-20 11:52:13',6,37513,21682,NULL,NULL,NULL,'2024-06-20 04:52:13','2024-06-20 04:52:13'),
(337,2,'credit',NULL,85000.0000,NULL,'2024-06-20 12:24:26',17,37518,21684,NULL,NULL,NULL,'2024-06-20 05:24:26','2024-06-20 05:30:38'),
(338,2,'credit',NULL,260000.0000,NULL,'2024-06-20 12:51:17',49,37520,21686,NULL,NULL,NULL,'2024-06-20 05:51:17','2024-06-20 05:51:17'),
(339,2,'credit',NULL,200000.0000,NULL,'2024-06-20 12:51:28',49,37113,21687,NULL,NULL,NULL,'2024-06-20 05:51:28','2024-06-20 05:51:28'),
(340,2,'credit',NULL,165000.0000,NULL,'2024-06-20 13:48:27',19,37523,21690,NULL,NULL,NULL,'2024-06-20 06:48:27','2024-06-20 06:48:27'),
(341,2,'credit',NULL,305000.0000,NULL,'2024-06-20 15:20:30',6,37540,21704,NULL,NULL,NULL,'2024-06-20 08:20:30','2024-06-20 08:20:30'),
(342,2,'credit',NULL,235000.0000,NULL,'2024-06-20 16:59:31',6,37546,21711,NULL,NULL,NULL,'2024-06-20 09:59:31','2024-06-20 09:59:31'),
(343,2,'credit',NULL,2883000.0000,NULL,'2024-06-20 20:11:59',3,37017,21725,NULL,NULL,NULL,'2024-06-20 13:11:59','2024-06-21 08:44:19'),
(344,2,'credit',NULL,200000.0000,NULL,'2024-06-20 20:23:32',3,37233,21726,NULL,NULL,NULL,'2024-06-20 13:23:32','2024-11-30 04:01:30'),
(345,2,'credit',NULL,3281500.0000,NULL,'2024-06-21 11:00:33',49,37564,21747,NULL,NULL,NULL,'2024-06-21 04:00:33','2024-06-21 04:00:33'),
(346,2,'credit',NULL,368000.0000,NULL,'2024-06-21 11:31:18',46,37620,21751,NULL,NULL,NULL,'2024-06-21 04:31:18','2024-06-21 04:31:18'),
(347,2,'credit',NULL,95000.0000,NULL,'2024-06-21 20:04:52',6,37684,21784,NULL,NULL,NULL,'2024-06-21 13:04:52','2024-06-21 13:04:52'),
(348,2,'credit',NULL,2009000.0000,NULL,'2024-06-22 09:55:34',46,37713,21794,NULL,NULL,NULL,'2024-06-22 02:55:34','2024-06-30 08:17:15'),
(349,2,'credit',NULL,195000.0000,NULL,'2024-06-22 14:06:28',3,37758,21813,NULL,NULL,NULL,'2024-06-22 07:06:28','2024-06-22 07:06:28'),
(350,2,'credit',NULL,156000.0000,NULL,'2024-06-22 17:03:31',46,37797,21821,NULL,NULL,NULL,'2024-06-22 10:03:31','2024-06-22 10:03:31'),
(351,2,'credit',NULL,387000.0000,NULL,'2024-06-22 21:17:34',3,37818,21840,NULL,NULL,NULL,'2024-06-22 14:17:34','2024-06-22 14:17:34'),
(352,2,'credit',NULL,150000.0000,NULL,'2024-06-22 21:49:56',3,37821,21844,NULL,NULL,NULL,'2024-06-22 14:49:56','2024-06-22 14:49:56'),
(353,2,'credit',NULL,150000.0000,NULL,'2024-06-22 21:50:38',3,37822,21845,NULL,NULL,NULL,'2024-06-22 14:50:38','2024-06-22 14:50:38'),
(354,2,'credit',NULL,482000.0000,NULL,'2024-06-22 21:50:51',3,37808,21846,NULL,NULL,NULL,'2024-06-22 14:50:51','2024-06-22 14:50:51'),
(355,2,'credit',NULL,76500.0000,NULL,'2024-06-23 09:59:55',3,37838,21848,NULL,NULL,NULL,'2024-06-23 02:59:55','2024-06-23 02:59:55'),
(356,2,'credit',NULL,1615500.0000,NULL,'2024-06-23 11:18:05',3,37844,21852,NULL,NULL,NULL,'2024-06-23 04:18:05','2024-06-23 04:18:05'),
(357,2,'debit',NULL,300000.0000,NULL,'2024-06-23 11:55:00',3,37851,21854,NULL,NULL,'2024-10-18 07:48:10','2024-06-23 04:56:18','2024-10-18 07:48:10'),
(358,2,'credit',NULL,289000.0000,NULL,'2024-06-23 13:22:59',3,37858,21857,NULL,NULL,NULL,'2024-06-23 06:22:59','2024-06-23 06:22:59'),
(359,2,'credit',NULL,7856500.0000,NULL,'2024-06-24 14:18:58',3,35820,21913,NULL,NULL,NULL,'2024-06-24 07:18:58','2024-06-30 05:36:50'),
(360,2,'credit',NULL,420000.0000,NULL,'2024-06-24 15:19:19',19,37944,21916,NULL,NULL,'2024-06-24 10:05:17','2024-06-24 08:19:19','2024-06-24 10:05:17'),
(361,2,'credit',NULL,314000.0000,NULL,'2024-06-24 15:33:24',13,37945,21917,NULL,NULL,NULL,'2024-06-24 08:33:24','2024-06-24 08:33:24'),
(362,2,'debit',NULL,315000.0000,NULL,'2024-06-24 16:39:00',3,37953,21924,NULL,NULL,NULL,'2024-06-24 09:40:29','2024-06-24 09:40:29'),
(363,2,'credit',NULL,692000.0000,NULL,'2024-06-24 18:19:33',49,37948,21928,NULL,NULL,NULL,'2024-06-24 11:19:33','2024-06-30 04:58:55'),
(364,2,'credit',NULL,200000.0000,NULL,'2024-06-24 18:22:42',6,37610,21929,NULL,NULL,NULL,'2024-06-24 11:22:42','2024-06-30 07:29:56'),
(365,2,'debit',NULL,7825000.0000,NULL,'2024-06-25 09:37:00',1,37577,21954,NULL,NULL,NULL,'2024-06-25 02:37:56','2024-06-25 02:37:56'),
(366,2,'debit',NULL,111732.0000,NULL,'2024-06-25 09:38:00',1,37418,21955,NULL,NULL,NULL,'2024-06-25 02:38:30','2024-06-25 02:38:30'),
(367,2,'debit',NULL,311200.0000,NULL,'2024-06-25 09:40:00',1,37980,21956,NULL,NULL,NULL,'2024-06-25 02:41:00','2024-06-25 02:41:00'),
(368,2,'debit',NULL,2643400.0000,NULL,'2024-06-25 09:41:00',1,36381,21957,NULL,NULL,NULL,'2024-06-25 02:42:01','2024-06-25 02:42:01'),
(369,2,'debit',NULL,35000.0000,NULL,'2024-06-25 09:44:00',1,37793,21958,NULL,NULL,NULL,'2024-06-25 02:44:13','2024-06-25 02:44:13'),
(370,2,'credit',NULL,6124425.0000,NULL,'2024-06-25 11:08:27',3,34409,21962,NULL,NULL,NULL,'2024-06-25 04:08:27','2024-06-25 04:08:27'),
(371,2,'credit',NULL,288000.0000,NULL,'2024-06-25 14:58:42',19,38042,21986,NULL,NULL,NULL,'2024-06-25 07:58:42','2024-06-25 07:58:42'),
(372,2,'credit',NULL,746000.0000,NULL,'2024-06-25 16:21:32',3,38054,22001,NULL,NULL,NULL,'2024-06-25 09:21:32','2024-06-25 09:21:32'),
(373,2,'credit',NULL,200000.0000,NULL,'2024-06-25 17:49:29',19,38003,22014,NULL,NULL,NULL,'2024-06-25 10:49:29','2024-06-30 07:29:44'),
(374,2,'credit',NULL,420000.0000,NULL,'2024-06-25 17:58:55',6,38067,22016,NULL,NULL,NULL,'2024-06-25 10:58:55','2024-06-25 10:58:55'),
(375,2,'credit',NULL,2795000.0000,NULL,'2024-06-26 09:54:14',3,38017,22042,NULL,NULL,NULL,'2024-06-26 02:54:14','2024-06-26 02:54:14'),
(376,2,'credit',NULL,670000.0000,NULL,'2024-06-26 10:59:38',15,38121,22047,NULL,NULL,NULL,'2024-06-26 03:59:38','2024-06-26 03:59:38'),
(377,2,'credit',NULL,35000.0000,NULL,'2024-06-26 12:47:08',15,38123,22055,NULL,NULL,NULL,'2024-06-26 05:47:08','2024-06-26 05:47:08'),
(378,2,'credit',NULL,2352000.0000,NULL,'2024-06-26 13:20:05',6,38140,22062,NULL,NULL,NULL,'2024-06-26 06:20:05','2024-07-05 08:16:59'),
(379,2,'credit',NULL,80000.0000,NULL,'2024-06-26 17:18:30',6,38014,22071,NULL,NULL,NULL,'2024-06-26 10:18:30','2024-06-26 10:18:30'),
(380,2,'credit',NULL,290000.0000,NULL,'2024-06-26 17:19:30',6,38178,22072,NULL,NULL,NULL,'2024-06-26 10:19:30','2024-06-26 10:19:30'),
(381,2,'credit',NULL,10995000.0000,NULL,'2024-06-26 19:08:16',6,38189,22080,NULL,NULL,NULL,'2024-06-26 12:08:16','2024-06-26 13:35:28'),
(382,2,'credit',NULL,270000.0000,NULL,'2024-06-26 19:42:35',6,38190,22081,NULL,NULL,NULL,'2024-06-26 12:42:35','2024-06-26 12:42:35'),
(383,2,'credit',NULL,596000.0000,NULL,'2024-06-26 20:35:28',6,38189,22083,NULL,NULL,NULL,'2024-06-26 13:35:28','2024-06-26 13:35:28'),
(384,2,'credit',NULL,1942000.0000,NULL,'2024-06-27 08:32:10',15,38214,22093,NULL,NULL,NULL,'2024-06-27 01:32:10','2024-06-27 01:32:10'),
(385,2,'credit',NULL,2545000.0000,NULL,'2024-06-27 17:42:00',19,38269,22135,NULL,NULL,NULL,'2024-06-27 10:42:14','2024-06-30 07:59:37'),
(386,2,'credit',NULL,865000.0000,NULL,'2024-06-27 18:25:14',49,38272,22136,NULL,NULL,NULL,'2024-06-27 11:25:14','2024-06-27 11:25:14'),
(387,2,'credit',NULL,1645000.0000,NULL,'2024-06-28 09:44:44',15,37506,22159,NULL,NULL,NULL,'2024-06-28 02:44:44','2024-06-28 07:32:35'),
(388,2,'credit',NULL,132300.0000,NULL,'2024-06-28 09:47:00',17,38308,22160,NULL,NULL,NULL,'2024-06-28 02:47:23','2024-06-28 02:47:23'),
(389,2,'debit',NULL,11800000.0000,NULL,'2024-06-28 09:48:00',1,38117,22162,NULL,NULL,NULL,'2024-06-28 02:48:29','2024-06-28 02:48:29'),
(390,2,'credit',NULL,6400000.0000,NULL,'2024-06-28 10:13:05',17,38311,22165,NULL,NULL,NULL,'2024-06-28 03:13:05','2024-06-28 03:13:05'),
(391,2,'credit',NULL,200000.0000,NULL,'2024-06-28 13:13:56',49,38087,22175,NULL,NULL,NULL,'2024-06-28 06:13:56','2024-06-30 06:08:39'),
(392,2,'debit',NULL,7040000.0000,NULL,'2024-06-28 13:42:00',19,38328,22181,NULL,NULL,NULL,'2024-06-28 06:44:46','2024-06-28 06:44:46'),
(393,2,'debit',NULL,380000.0000,NULL,'2024-06-28 13:47:00',19,38329,22182,NULL,NULL,NULL,'2024-06-28 06:48:02','2024-06-28 06:48:02'),
(394,2,'credit',NULL,10000000.0000,NULL,'2024-06-28 15:29:43',19,38201,22194,NULL,NULL,NULL,'2024-06-28 08:29:43','2024-07-01 11:46:09'),
(395,2,'credit',NULL,200000.0000,NULL,'2024-06-28 19:59:57',19,38346,22215,NULL,NULL,NULL,'2024-06-28 12:59:57','2024-08-27 13:32:38'),
(396,2,'credit',NULL,576000.0000,NULL,'2024-06-29 10:37:23',46,38362,22232,NULL,NULL,NULL,'2024-06-29 03:37:23','2024-06-29 03:37:23'),
(397,2,'credit',NULL,355000.0000,NULL,'2024-06-29 15:17:16',6,38458,22242,NULL,NULL,NULL,'2024-06-29 08:17:16','2024-06-29 08:17:16'),
(398,2,'credit',NULL,40000.0000,NULL,'2024-06-29 15:48:00',17,38463,22245,NULL,NULL,NULL,'2024-06-29 08:49:02','2024-06-29 08:52:56'),
(399,2,'credit',NULL,5569000.0000,NULL,'2024-06-29 19:24:14',19,38480,22259,NULL,NULL,NULL,'2024-06-29 12:24:14','2024-06-29 12:24:14'),
(400,2,'credit',NULL,160000.0000,NULL,'2024-06-29 19:42:13',13,37079,22262,NULL,NULL,NULL,'2024-06-29 12:42:13','2024-06-29 12:42:13'),
(401,2,'credit',NULL,7176000.0000,NULL,'2024-06-29 20:33:00',19,38366,22267,NULL,NULL,NULL,'2024-06-29 13:33:48','2024-06-30 07:37:26'),
(402,2,'credit',NULL,750000.0000,NULL,'2024-06-30 08:45:07',19,37669,22277,NULL,NULL,NULL,'2024-06-30 01:45:07','2024-06-30 01:45:07'),
(403,2,'credit',NULL,335000.0000,NULL,'2024-06-30 09:21:31',49,38521,22279,NULL,NULL,NULL,'2024-06-30 02:21:31','2024-06-30 02:21:31'),
(404,2,'credit',NULL,40000.0000,NULL,'2024-06-30 11:53:49',3,38545,22291,NULL,NULL,NULL,'2024-06-30 04:53:49','2024-06-30 04:53:49'),
(405,2,'credit',NULL,80000.0000,NULL,'2024-06-30 11:53:56',3,38546,22292,NULL,NULL,NULL,'2024-06-30 04:53:56','2024-06-30 04:53:56'),
(406,2,'credit',NULL,137500.0000,NULL,'2024-06-30 11:58:40',3,38548,22293,NULL,NULL,NULL,'2024-06-30 04:58:40','2024-06-30 04:58:40'),
(407,2,'credit',NULL,137500.0000,NULL,'2024-06-30 11:58:46',3,38549,22294,NULL,NULL,NULL,'2024-06-30 04:58:46','2024-06-30 04:58:46'),
(408,2,'credit',NULL,1050000.0000,NULL,'2024-06-30 12:34:51',3,38560,22300,NULL,NULL,NULL,'2024-06-30 05:34:51','2024-06-30 05:34:51'),
(409,2,'credit',NULL,805000.0000,NULL,'2024-06-30 12:36:21',3,38561,22301,NULL,NULL,NULL,'2024-06-30 05:36:21','2024-06-30 05:36:21'),
(410,2,'credit',NULL,830000.0000,NULL,'2024-06-30 12:36:28',3,38562,22302,NULL,NULL,NULL,'2024-06-30 05:36:28','2024-06-30 05:36:28'),
(411,2,'credit',NULL,2150000.0000,NULL,'2024-06-30 13:06:02',49,38571,22312,NULL,NULL,NULL,'2024-06-30 06:06:02','2024-06-30 06:06:02'),
(412,2,'credit',NULL,150000.0000,NULL,'2024-06-30 14:37:56',19,38580,22316,NULL,NULL,NULL,'2024-06-30 07:37:56','2024-06-30 08:19:27'),
(413,2,'credit',NULL,200000.0000,NULL,'2024-06-30 15:00:20',19,38586,22323,NULL,NULL,NULL,'2024-06-30 08:00:20','2024-06-30 08:00:20'),
(414,2,'credit',NULL,200000.0000,NULL,'2024-06-30 15:01:11',19,38587,22325,NULL,NULL,NULL,'2024-06-30 08:01:11','2024-06-30 08:01:11'),
(415,2,'credit',NULL,75000.0000,NULL,'2024-06-30 15:15:13',6,38592,22332,NULL,NULL,NULL,'2024-06-30 08:15:13','2024-06-30 08:15:13'),
(416,2,'credit',NULL,75000.0000,NULL,'2024-06-30 15:15:48',6,38593,22333,NULL,NULL,NULL,'2024-06-30 08:15:48','2024-06-30 08:15:48'),
(417,2,'credit',NULL,80000.0000,NULL,'2024-06-30 15:17:47',19,38594,22336,NULL,NULL,NULL,'2024-06-30 08:17:47','2024-06-30 08:17:47'),
(418,2,'credit',NULL,150000.0000,NULL,'2024-06-30 15:28:54',19,38596,22338,NULL,NULL,NULL,'2024-06-30 08:28:54','2024-06-30 08:28:54'),
(419,2,'credit',NULL,150000.0000,NULL,'2024-06-30 15:29:37',19,38597,22339,NULL,NULL,NULL,'2024-06-30 08:29:37','2024-06-30 08:29:37'),
(420,2,'credit',NULL,150000.0000,NULL,'2024-06-30 19:38:18',6,38622,22368,NULL,NULL,NULL,'2024-06-30 12:38:18','2024-06-30 12:38:18'),
(421,2,'credit',NULL,200000.0000,NULL,'2024-06-30 21:38:05',13,38369,22378,NULL,NULL,NULL,'2024-06-30 14:38:05','2024-06-30 14:38:05'),
(422,2,'credit',NULL,728000.0000,NULL,'2024-06-30 21:38:12',13,38638,22379,NULL,NULL,NULL,'2024-06-30 14:38:12','2024-06-30 14:38:12'),
(423,2,'credit',NULL,2090000.0000,NULL,'2024-06-14 09:08:00',19,37183,22425,NULL,NULL,NULL,'2024-07-01 02:08:57','2024-07-01 02:08:57'),
(424,2,'credit',NULL,4727000.0000,NULL,'2024-06-25 11:21:00',3,36363,21965,NULL,NULL,'2024-07-01 03:03:29','2024-07-01 02:57:55','2024-07-01 03:03:29'),
(425,2,'credit',NULL,797000.0000,NULL,'2024-07-01 10:11:00',19,38645,22446,NULL,NULL,NULL,'2024-07-01 03:12:06','2024-07-01 03:12:06'),
(426,2,'credit',NULL,435000.0000,NULL,'2024-07-01 11:13:03',49,38595,22451,NULL,NULL,NULL,'2024-07-01 04:13:03','2024-07-01 04:13:03'),
(427,2,'debit',NULL,15450000.0000,NULL,'2024-07-01 14:49:00',1,38559,22488,NULL,NULL,NULL,'2024-07-01 07:49:38','2024-07-01 07:49:38'),
(428,2,'debit',NULL,9446000.0000,NULL,'2024-07-01 16:25:00',1,38673,22489,NULL,NULL,NULL,'2024-07-01 09:25:08','2024-07-01 09:25:08'),
(429,2,'debit',NULL,2038400.0000,NULL,'2024-07-01 16:26:00',1,38648,22490,NULL,NULL,NULL,'2024-07-01 09:26:49','2024-07-01 09:26:49'),
(430,2,'debit',NULL,4789200.0000,NULL,'2024-07-01 16:49:00',1,38157,22493,NULL,NULL,'2024-07-18 13:49:13','2024-07-01 09:49:47','2024-07-18 13:49:13'),
(431,2,'debit',NULL,9716000.0000,NULL,'2024-07-01 16:53:00',1,38465,22494,NULL,NULL,NULL,'2024-07-01 09:53:16','2024-07-01 09:53:16'),
(432,2,'debit',NULL,3192000.0000,NULL,'2024-07-01 17:01:00',1,38407,22495,NULL,NULL,NULL,'2024-07-01 10:01:12','2024-07-01 10:01:12'),
(433,2,'credit',NULL,712000.0000,NULL,'2024-07-01 19:05:24',6,38692,22509,NULL,NULL,NULL,'2024-07-01 12:05:24','2024-07-01 12:05:24'),
(434,2,'credit',NULL,454000.0000,NULL,'2024-07-01 20:34:14',13,38703,22520,NULL,NULL,NULL,'2024-07-01 13:34:14','2024-07-02 03:22:02'),
(435,2,'credit',NULL,390000.0000,NULL,'2024-07-01 20:34:48',13,38397,22521,NULL,NULL,NULL,'2024-07-01 13:34:48','2024-07-01 13:34:48'),
(436,2,'credit',NULL,294000.0000,NULL,'2024-07-02 08:25:54',49,38060,22535,NULL,NULL,NULL,'2024-07-02 01:25:54','2024-07-31 12:08:47'),
(437,2,'credit',NULL,30000.0000,NULL,'2024-07-02 09:01:06',49,38716,22536,NULL,NULL,NULL,'2024-07-02 02:01:06','2024-07-02 02:01:06'),
(438,2,'credit',NULL,255000.0000,NULL,'2024-07-02 10:43:31',19,38720,22555,NULL,NULL,NULL,'2024-07-02 03:43:31','2024-07-02 03:43:31'),
(439,2,'debit',NULL,226000.0000,NULL,'2024-07-02 12:04:00',19,38738,22571,NULL,NULL,NULL,'2024-07-02 05:17:25','2024-07-02 05:17:25'),
(440,2,'credit',NULL,2270000.0000,NULL,'2024-07-02 14:14:40',6,38746,22583,NULL,NULL,NULL,'2024-07-02 07:14:40','2024-12-01 09:10:41'),
(441,2,'credit',NULL,315000.0000,NULL,'2024-07-02 14:19:17',6,38755,22584,NULL,NULL,NULL,'2024-07-02 07:19:17','2024-07-02 07:19:17'),
(442,2,'credit',NULL,147000.0000,NULL,'2024-07-02 14:59:11',13,38741,22591,NULL,NULL,NULL,'2024-07-02 07:59:11','2024-08-04 12:54:51'),
(443,2,'debit',NULL,119000.0000,NULL,'2024-07-02 14:50:00',19,38764,22593,NULL,NULL,'2024-07-02 09:49:47','2024-07-02 08:03:50','2024-07-02 09:49:47'),
(444,2,'credit',NULL,595000.0000,NULL,'2024-07-02 16:33:46',3,38774,22600,NULL,NULL,NULL,'2024-07-02 09:33:46','2024-07-02 09:33:46'),
(445,2,'credit',NULL,6529000.0000,NULL,'2024-07-02 16:34:00',19,38201,22601,NULL,NULL,NULL,'2024-07-02 09:34:39','2024-07-02 09:34:39'),
(446,2,'debit',NULL,119000.0000,NULL,'2024-07-02 16:49:00',19,38775,22602,NULL,NULL,NULL,'2024-07-02 09:50:40','2024-07-02 09:50:40'),
(447,2,'debit',NULL,175000.0000,NULL,'2024-07-02 18:12:00',6,38785,22617,NULL,NULL,NULL,'2024-07-02 11:12:55','2024-07-02 11:12:55'),
(448,2,'credit',NULL,195000.0000,NULL,'2024-07-03 10:03:00',19,38802,22631,NULL,NULL,NULL,'2024-07-03 03:03:00','2024-07-03 03:03:00'),
(449,2,'debit',NULL,10497800.0000,NULL,'2024-07-03 11:42:00',1,38338,22638,NULL,NULL,NULL,'2024-07-03 04:42:27','2024-07-03 04:42:27'),
(450,2,'debit',NULL,12356100.0000,NULL,'2024-07-03 11:48:00',1,38718,22640,NULL,NULL,NULL,'2024-07-03 04:48:18','2024-07-03 04:48:18'),
(451,2,'debit',NULL,2017000.0000,NULL,'2024-07-03 11:53:00',1,38715,22641,NULL,NULL,NULL,'2024-07-03 04:53:13','2024-07-03 04:53:13'),
(452,2,'debit',NULL,23918600.0000,NULL,'2024-07-03 12:01:00',1,38116,22642,NULL,NULL,'2024-07-03 13:46:15','2024-07-03 05:01:55','2024-07-03 13:46:15'),
(453,2,'debit',NULL,8100000.0000,NULL,'2024-07-03 12:11:00',1,38418,22643,NULL,NULL,NULL,'2024-07-03 05:11:35','2024-07-03 05:11:35'),
(454,2,'debit',NULL,6450500.0000,NULL,'2024-07-03 12:14:00',1,38271,22644,NULL,NULL,NULL,'2024-07-03 05:14:19','2024-07-03 05:14:19'),
(455,2,'debit',NULL,7866000.0000,NULL,'2024-07-03 12:21:00',1,38183,22645,NULL,NULL,NULL,'2024-07-03 05:21:51','2024-07-03 05:21:51'),
(456,2,'credit',NULL,5525000.0000,NULL,'2024-07-03 12:44:55',49,38819,22647,NULL,NULL,NULL,'2024-07-03 05:44:55','2024-07-03 10:45:34'),
(457,2,'credit',NULL,225000.0000,NULL,'2024-07-03 13:08:07',49,38812,22650,NULL,NULL,NULL,'2024-07-03 06:08:07','2024-07-03 06:08:07'),
(458,2,'credit',NULL,5595000.0000,NULL,'2024-07-03 14:28:00',19,38825,22655,NULL,NULL,NULL,'2024-07-03 07:40:04','2024-07-03 07:40:04'),
(459,2,'credit',NULL,450000.0000,NULL,'2024-07-03 15:48:43',3,35882,22676,NULL,NULL,NULL,'2024-07-03 08:48:43','2024-07-03 08:48:43'),
(460,2,'debit',NULL,64700.0000,NULL,'2024-07-03 18:12:00',19,38858,22687,NULL,NULL,NULL,'2024-07-03 11:14:28','2024-07-03 11:14:28'),
(461,2,'debit',NULL,302000.0000,NULL,'2024-07-03 20:16:00',1,38344,22692,NULL,NULL,NULL,'2024-07-03 13:16:36','2024-07-03 13:16:36'),
(462,2,'debit',NULL,272000.0000,NULL,'2024-07-03 20:20:00',1,38228,22693,NULL,NULL,NULL,'2024-07-03 13:20:26','2024-07-03 13:20:26'),
(463,2,'credit',NULL,1100000.0000,NULL,'2024-07-03 17:36:00',19,38855,22683,NULL,NULL,NULL,'2024-07-03 13:21:48','2024-07-03 13:21:48'),
(464,2,'debit',NULL,262500.0000,NULL,'2024-07-03 20:22:00',1,38345,22694,NULL,NULL,NULL,'2024-07-03 13:23:01','2024-07-03 13:23:01'),
(465,2,'debit',NULL,3825000.0000,NULL,'2024-07-03 20:29:00',1,38835,22695,NULL,NULL,NULL,'2024-07-03 13:29:44','2024-07-03 13:29:44'),
(466,2,'debit',NULL,4353500.0000,NULL,'2024-07-03 20:47:00',1,37138,22696,NULL,NULL,NULL,'2024-07-03 13:47:44','2024-07-03 13:47:44'),
(467,2,'debit',NULL,1640000.0000,NULL,'2024-07-03 20:53:00',1,38007,22697,NULL,NULL,NULL,'2024-07-03 13:53:47','2024-07-03 13:53:47'),
(468,2,'debit',NULL,195000.0000,NULL,'2024-07-03 20:54:00',1,36173,22698,NULL,NULL,NULL,'2024-07-03 13:54:56','2024-07-03 13:54:56'),
(469,2,'debit',NULL,65000.0000,NULL,'2024-07-03 20:56:00',1,38092,22699,NULL,NULL,NULL,'2024-07-03 13:56:39','2024-07-03 13:56:39'),
(470,2,'debit',NULL,207000.0000,NULL,'2024-07-03 20:57:00',1,36776,22700,NULL,NULL,NULL,'2024-07-03 13:57:11','2024-07-03 13:57:11'),
(471,2,'debit',NULL,131000.0000,NULL,'2024-07-03 20:58:00',1,34135,22702,NULL,NULL,NULL,'2024-07-03 13:58:52','2024-07-03 13:58:52'),
(472,2,'debit',NULL,266600.0000,NULL,'2024-07-03 20:59:00',1,36908,22703,NULL,NULL,NULL,'2024-07-03 13:59:47','2024-07-03 13:59:47'),
(473,2,'debit',NULL,54588500.0000,NULL,'2024-07-03 21:15:00',1,38875,22706,NULL,NULL,NULL,'2024-07-03 14:15:50','2024-07-03 14:15:50'),
(474,2,'debit',NULL,1840000.0000,NULL,'2024-07-03 21:18:00',1,38865,22707,NULL,NULL,NULL,'2024-07-03 14:18:26','2024-07-03 14:18:26'),
(475,2,'credit',NULL,1038000.0000,NULL,'2024-07-04 10:58:55',46,38915,22725,NULL,NULL,NULL,'2024-07-04 03:58:55','2024-07-04 03:58:55'),
(476,2,'credit',NULL,613000.0000,NULL,'2024-07-04 11:35:41',19,38831,22727,NULL,NULL,NULL,'2024-07-04 04:35:41','2024-07-04 04:35:41'),
(477,2,'credit',NULL,2300000.0000,NULL,'2024-07-04 12:59:17',19,38923,22733,NULL,NULL,NULL,'2024-07-04 05:59:17','2024-07-06 07:13:40'),
(478,2,'debit',NULL,7470000.0000,NULL,'2024-07-04 21:37:00',1,38971,22776,NULL,NULL,NULL,'2024-07-04 14:37:18','2024-07-04 14:37:18'),
(479,2,'debit',NULL,28083200.0000,NULL,'2024-07-04 22:03:00',1,38969,22782,NULL,NULL,NULL,'2024-07-04 15:03:34','2024-07-04 15:03:34'),
(480,2,'credit',NULL,100000.0000,NULL,'2024-07-04 22:04:32',3,38945,22783,NULL,NULL,NULL,'2024-07-04 15:04:32','2024-07-31 08:45:17'),
(481,2,'credit',NULL,350000.0000,NULL,'2024-07-05 10:25:31',49,34752,22790,NULL,NULL,NULL,'2024-07-05 03:25:31','2024-07-11 04:11:56'),
(482,2,'debit',NULL,92400.0000,NULL,'2024-07-05 13:21:00',1,38930,22803,NULL,NULL,NULL,'2024-07-05 06:21:11','2024-07-05 06:21:11'),
(483,2,'credit',NULL,198000.0000,NULL,'2024-07-05 13:42:22',13,38997,22807,NULL,NULL,NULL,'2024-07-05 06:42:22','2024-07-05 06:42:22'),
(484,2,'credit',NULL,165000.0000,NULL,'2024-07-05 13:56:58',6,38998,22808,NULL,NULL,NULL,'2024-07-05 06:56:58','2024-07-05 06:56:58'),
(485,2,'credit',NULL,200000.0000,NULL,'2024-07-05 14:53:19',49,38986,22814,NULL,NULL,NULL,'2024-07-05 07:53:19','2024-07-15 03:58:11'),
(486,2,'credit',NULL,5488000.0000,NULL,'2024-07-05 15:16:59',6,38140,22820,NULL,NULL,NULL,'2024-07-05 08:16:59','2024-07-05 08:16:59'),
(487,2,'credit',NULL,3953000.0000,NULL,'2024-07-05 15:28:49',13,38989,22822,NULL,NULL,NULL,'2024-07-05 08:28:49','2024-07-05 08:28:49'),
(488,2,'credit',NULL,80000.0000,NULL,'2024-07-05 18:13:31',6,39031,22830,NULL,NULL,NULL,'2024-07-05 11:13:31','2024-07-05 11:13:31'),
(489,2,'credit',NULL,200000.0000,NULL,'2024-07-05 19:27:10',6,38978,22834,NULL,NULL,NULL,'2024-07-05 12:27:10','2024-07-05 12:27:10'),
(490,2,'credit',NULL,63000.0000,NULL,'2024-07-05 20:07:59',6,39036,22836,NULL,NULL,NULL,'2024-07-05 13:07:59','2024-07-05 13:07:59'),
(491,2,'debit',NULL,92000.0000,NULL,'2024-07-06 10:03:00',19,39060,22852,NULL,NULL,NULL,'2024-07-06 03:05:13','2024-07-06 03:05:13'),
(492,2,'debit',NULL,70000.0000,NULL,'2024-07-06 15:40:00',3,39091,22886,NULL,NULL,NULL,'2024-07-06 08:44:16','2024-07-06 08:44:16'),
(493,2,'debit',NULL,220000.0000,NULL,'2024-07-06 16:54:00',19,39101,22896,NULL,NULL,NULL,'2024-07-06 09:55:05','2024-07-06 09:55:05'),
(494,2,'credit',NULL,317000.0000,NULL,'2024-07-06 19:01:23',6,39117,22907,NULL,NULL,NULL,'2024-07-06 12:01:23','2024-07-06 12:01:23'),
(495,2,'credit',NULL,200000.0000,NULL,'2024-07-06 20:35:39',6,33477,22915,NULL,NULL,NULL,'2024-07-06 13:35:39','2024-11-26 13:13:37'),
(496,2,'debit',NULL,16035000.0000,NULL,'2024-07-07 13:04:00',1,39109,22919,NULL,NULL,NULL,'2024-07-07 06:04:57','2024-07-07 06:04:57'),
(497,2,'credit',NULL,1050000.0000,NULL,'2024-07-08 09:04:20',13,35605,22929,NULL,NULL,NULL,'2024-07-08 02:04:21','2024-07-08 07:02:34'),
(498,2,'credit',NULL,185000.0000,NULL,'2024-07-08 09:19:06',13,39153,22931,NULL,NULL,NULL,'2024-07-08 02:19:06','2024-07-08 02:19:06'),
(499,2,'credit',NULL,530000.0000,NULL,'2024-07-08 11:29:01',6,39182,22954,NULL,NULL,NULL,'2024-07-08 04:29:01','2024-07-08 04:29:01'),
(500,2,'credit',NULL,2327500.0000,NULL,'2024-07-08 12:09:25',3,39177,22958,NULL,NULL,NULL,'2024-07-08 05:09:25','2024-07-08 05:09:25'),
(501,2,'credit',NULL,5569000.0000,NULL,'2024-07-08 15:57:26',49,39212,22976,NULL,NULL,NULL,'2024-07-08 08:57:26','2024-07-08 09:05:18'),
(502,2,'credit',NULL,160000.0000,NULL,'2024-07-08 21:25:06',19,39268,23024,NULL,NULL,NULL,'2024-07-08 14:25:06','2024-07-08 14:25:06'),
(503,2,'credit',NULL,576000.0000,NULL,'2024-07-09 09:48:18',6,39281,23035,NULL,NULL,NULL,'2024-07-09 02:48:18','2024-07-09 02:48:18'),
(504,2,'credit',NULL,948000.0000,NULL,'2024-07-09 13:18:57',3,39299,23050,NULL,NULL,NULL,'2024-07-09 06:18:57','2024-07-31 08:57:45'),
(505,2,'credit',NULL,3642000.0000,NULL,'2024-07-09 16:34:52',3,39284,23073,NULL,NULL,NULL,'2024-07-09 09:34:52','2024-07-09 09:34:52'),
(506,2,'debit',NULL,29262300.0000,NULL,'2024-07-09 20:34:00',1,39343,23095,NULL,NULL,NULL,'2024-07-09 13:34:35','2024-07-09 13:34:35'),
(507,2,'credit',NULL,200000.0000,NULL,'2024-07-09 20:41:30',19,37614,23097,NULL,NULL,NULL,'2024-07-09 13:41:30','2024-07-09 13:41:58'),
(508,2,'debit',NULL,14045065.0000,NULL,'2024-07-09 21:15:00',1,39354,23101,NULL,NULL,'2024-08-05 23:54:16','2024-07-09 14:15:25','2024-08-05 23:54:16'),
(509,2,'credit',NULL,650000.0000,NULL,'2024-07-09 21:21:00',19,39237,23102,NULL,NULL,NULL,'2024-07-09 14:21:34','2024-07-09 14:21:34'),
(510,2,'debit',NULL,1953000.0000,NULL,'2024-07-09 21:46:00',1,39345,23106,NULL,NULL,NULL,'2024-07-09 14:46:44','2024-07-09 14:46:44'),
(511,2,'debit',NULL,2370000.0000,NULL,'2024-07-09 21:52:00',1,39344,23107,NULL,NULL,NULL,'2024-07-09 14:52:25','2024-07-09 14:52:25'),
(512,2,'debit',NULL,356800.0000,NULL,'2024-07-09 21:53:00',1,39317,23108,NULL,NULL,NULL,'2024-07-09 14:53:34','2024-07-09 14:53:34'),
(513,2,'credit',NULL,100000.0000,NULL,'2024-07-10 10:43:37',6,39374,23113,NULL,NULL,NULL,'2024-07-10 03:43:37','2024-07-10 03:43:37'),
(514,2,'credit',NULL,272300.0000,NULL,'2024-07-10 13:47:04',6,39391,23125,NULL,NULL,NULL,'2024-07-10 06:47:04','2024-07-10 06:47:04'),
(515,2,'credit',NULL,80000.0000,NULL,'2024-07-10 15:56:29',49,39037,23137,NULL,NULL,NULL,'2024-07-10 08:56:29','2024-07-10 08:56:29'),
(516,2,'credit',NULL,5429000.0000,NULL,'2024-07-10 17:09:55',6,39429,23147,NULL,NULL,NULL,'2024-07-10 10:09:55','2024-07-10 10:09:55'),
(517,2,'credit',NULL,815000.0000,NULL,'2024-07-10 18:34:44',49,39434,23155,NULL,NULL,NULL,'2024-07-10 11:34:44','2024-07-30 12:24:26'),
(518,2,'credit',NULL,370000.0000,NULL,'2024-07-10 18:56:15',46,39440,23161,NULL,NULL,NULL,'2024-07-10 11:56:15','2024-07-10 11:56:15'),
(519,2,'credit',NULL,7510000.0000,NULL,'2024-07-10 19:54:37',49,39414,23163,NULL,NULL,NULL,'2024-07-10 12:54:37','2024-07-10 12:54:37'),
(520,2,'debit',NULL,6706200.0000,NULL,'2024-07-10 20:52:00',1,39419,23169,NULL,NULL,NULL,'2024-07-10 13:52:37','2024-07-10 13:52:37'),
(521,2,'debit',NULL,7614000.0000,NULL,'2024-07-10 21:44:00',1,39119,23172,NULL,NULL,NULL,'2024-07-10 14:44:56','2024-07-10 14:44:56'),
(522,2,'debit',NULL,13799100.0000,NULL,'2024-07-10 21:57:00',1,37032,23173,NULL,NULL,NULL,'2024-07-10 14:57:17','2024-07-10 14:57:17'),
(523,2,'debit',NULL,2440000.0000,NULL,'2024-07-10 21:57:00',1,38461,23174,NULL,NULL,NULL,'2024-07-10 14:57:53','2024-07-10 14:57:53'),
(524,2,'debit',NULL,20457300.0000,NULL,'2024-07-10 22:18:00',1,39110,23175,NULL,NULL,NULL,'2024-07-10 15:18:38','2024-07-10 15:18:38'),
(525,2,'debit',NULL,2051500.0000,NULL,'2024-07-10 22:21:00',1,39056,23176,NULL,NULL,NULL,'2024-07-10 15:21:45','2024-07-10 15:21:45'),
(526,2,'credit',NULL,944000.0000,NULL,'2024-07-11 08:26:39',3,39425,23177,NULL,NULL,NULL,'2024-07-11 01:26:39','2024-07-11 01:26:39'),
(527,2,'debit',NULL,25655400.0000,NULL,'2024-07-11 13:44:00',1,39481,23199,NULL,NULL,NULL,'2024-07-11 06:44:12','2024-07-11 06:44:12'),
(528,2,'credit',NULL,75000.0000,NULL,'2024-07-11 15:19:53',46,39494,23210,NULL,NULL,NULL,'2024-07-11 08:19:53','2024-07-11 08:19:53'),
(529,2,'debit',NULL,7681200.0000,NULL,'2024-07-12 09:18:00',1,39510,23237,NULL,NULL,NULL,'2024-07-12 02:18:55','2024-07-12 02:18:55'),
(530,2,'debit',NULL,2360000.0000,NULL,'2024-07-12 09:21:00',1,39504,23238,NULL,NULL,NULL,'2024-07-12 02:21:08','2024-07-12 02:21:08'),
(531,2,'debit',NULL,2610000.0000,NULL,'2024-07-12 09:27:00',1,39513,23239,NULL,NULL,NULL,'2024-07-12 02:27:47','2024-07-12 02:27:47'),
(532,2,'debit',NULL,1112500.0000,NULL,'2024-07-12 09:48:00',1,39517,23241,NULL,NULL,NULL,'2024-07-12 02:48:36','2024-07-12 02:48:36'),
(533,2,'credit',NULL,200000.0000,NULL,'2024-07-12 13:14:52',49,39500,23251,NULL,NULL,NULL,'2024-07-12 06:14:52','2024-07-31 11:29:10'),
(534,2,'credit',NULL,162500.0000,NULL,'2024-07-12 14:53:43',6,39558,23253,NULL,NULL,NULL,'2024-07-12 07:53:43','2024-07-14 04:31:04'),
(535,2,'credit',NULL,5000000.0000,NULL,'2024-07-12 15:22:39',19,39562,23255,NULL,NULL,NULL,'2024-07-12 08:22:39','2024-07-15 09:56:34'),
(536,2,'credit',NULL,931000.0000,NULL,'2024-07-12 16:58:50',6,39569,23261,NULL,NULL,NULL,'2024-07-12 09:58:50','2024-07-12 09:58:50'),
(537,2,'credit',NULL,226000.0000,NULL,'2024-07-12 18:26:44',49,39578,23273,NULL,NULL,NULL,'2024-07-12 11:26:44','2024-07-12 11:26:44'),
(538,2,'credit',NULL,200000.0000,NULL,'2024-07-12 18:45:17',49,39541,23275,NULL,NULL,NULL,'2024-07-12 11:45:17','2024-07-31 06:19:22'),
(539,2,'debit',NULL,10545600.0000,NULL,'2024-07-13 09:33:00',1,39548,23295,NULL,NULL,NULL,'2024-07-13 02:33:13','2024-07-13 02:33:13'),
(540,2,'debit',NULL,15308700.0000,NULL,'2024-07-13 09:37:00',1,39550,23296,NULL,NULL,NULL,'2024-07-13 02:37:41','2024-07-13 02:37:41'),
(541,2,'debit',NULL,11948000.0000,NULL,'2024-07-13 09:48:00',1,39514,23299,NULL,NULL,NULL,'2024-07-13 02:48:40','2024-07-13 02:48:40'),
(542,2,'debit',NULL,2560400.0000,NULL,'2024-07-13 09:53:00',1,39612,23303,NULL,NULL,NULL,'2024-07-13 02:53:28','2024-07-13 02:53:28'),
(543,2,'debit',NULL,3840600.0000,NULL,'2024-07-13 11:27:00',1,39624,23309,NULL,NULL,NULL,'2024-07-13 04:27:47','2024-07-13 04:27:47'),
(544,2,'debit',NULL,4520000.0000,NULL,'2024-07-13 12:35:00',1,39629,23314,NULL,NULL,NULL,'2024-07-13 05:35:47','2024-07-13 05:35:47'),
(545,2,'credit',NULL,3296000.0000,NULL,'2024-07-13 13:19:25',13,39631,23316,NULL,NULL,NULL,'2024-07-13 06:19:25','2024-07-13 06:19:25'),
(546,2,'credit',NULL,474000.0000,NULL,'2024-07-13 20:57:56',49,39632,23341,NULL,NULL,NULL,'2024-07-13 13:57:56','2024-07-30 12:30:59'),
(547,2,'debit',NULL,62865000.0000,NULL,'2024-07-14 11:14:00',1,39661,23353,NULL,NULL,NULL,'2024-07-14 04:14:50','2024-07-14 04:14:50'),
(548,2,'debit',NULL,4350000.0000,NULL,'2024-07-14 11:51:00',1,39650,23357,NULL,NULL,NULL,'2024-07-14 04:51:37','2024-07-14 04:51:37'),
(549,2,'credit',NULL,200000.0000,NULL,'2024-07-14 13:41:48',3,39672,23362,NULL,NULL,NULL,'2024-07-14 06:41:48','2024-07-14 06:41:48'),
(550,2,'credit',NULL,510000.0000,NULL,'2024-07-14 17:34:21',3,37919,23385,NULL,NULL,NULL,'2024-07-14 10:34:21','2024-07-14 10:34:21'),
(551,2,'credit',NULL,5599000.0000,NULL,'2024-07-14 18:19:53',3,39732,23388,NULL,NULL,NULL,'2024-07-14 11:19:53','2024-07-14 11:19:53'),
(552,2,'credit',NULL,90000.0000,NULL,'2024-07-14 20:27:27',3,39756,23410,NULL,NULL,NULL,'2024-07-14 13:27:27','2024-07-14 13:27:27'),
(553,2,'credit',NULL,165000.0000,NULL,'2024-07-14 21:10:06',3,39763,23414,NULL,NULL,NULL,'2024-07-14 14:10:06','2024-07-14 14:10:06'),
(554,2,'credit',NULL,2085000.0000,NULL,'2024-07-15 09:36:00',19,39694,23426,NULL,NULL,NULL,'2024-07-15 02:36:49','2024-07-15 02:36:49'),
(555,2,'debit',NULL,715300.0000,NULL,'2024-07-15 10:14:00',19,39775,23430,NULL,NULL,NULL,'2024-07-15 03:25:19','2024-07-15 03:25:19'),
(556,2,'debit',NULL,2160000.0000,NULL,'2024-07-15 10:46:00',1,39737,23432,NULL,NULL,NULL,'2024-07-15 03:46:31','2024-07-15 03:46:31'),
(557,2,'credit',NULL,768000.0000,NULL,'2024-07-15 10:59:00',19,39722,23434,NULL,NULL,NULL,'2024-07-15 03:59:58','2024-07-15 03:59:58'),
(558,2,'credit',NULL,255000.0000,NULL,'2024-07-15 11:36:49',13,39781,23438,NULL,NULL,NULL,'2024-07-15 04:36:49','2024-07-15 04:36:49'),
(559,2,'credit',NULL,75000.0000,NULL,'2024-07-15 11:57:43',13,39782,23439,NULL,NULL,NULL,'2024-07-15 04:57:43','2024-07-15 04:57:43'),
(560,2,'credit',NULL,85000.0000,NULL,'2024-07-15 11:58:00',19,39783,23440,NULL,NULL,NULL,'2024-07-15 04:58:00','2024-07-15 04:58:00'),
(561,2,'debit',NULL,9869000.0000,NULL,'2024-07-15 12:54:00',1,39713,23446,NULL,NULL,NULL,'2024-07-15 05:54:32','2024-07-15 05:54:32'),
(562,2,'debit',NULL,7975000.0000,NULL,'2024-07-15 13:10:00',1,39712,23451,NULL,NULL,NULL,'2024-07-15 06:10:18','2024-07-15 06:10:18'),
(563,2,'debit',NULL,4436800.0000,NULL,'2024-07-15 13:23:00',1,37505,23452,NULL,NULL,NULL,'2024-07-15 06:23:25','2024-07-15 06:23:25'),
(564,2,'debit',NULL,4881600.0000,NULL,'2024-07-15 13:26:00',1,37505,23453,NULL,NULL,NULL,'2024-07-15 06:26:40','2024-07-15 06:26:40'),
(565,2,'debit',NULL,23918600.0000,NULL,'2024-07-15 13:28:00',1,38116,23454,NULL,NULL,NULL,'2024-07-15 06:28:49','2024-07-15 06:28:49'),
(566,2,'credit',NULL,215000.0000,NULL,'2024-07-15 14:40:02',6,39802,23459,NULL,NULL,NULL,'2024-07-15 07:40:02','2024-07-15 07:40:02'),
(567,2,'credit',NULL,8200000.0000,NULL,'2024-07-15 15:56:34',13,39803,23470,NULL,NULL,NULL,'2024-07-15 08:56:34','2024-07-15 08:56:34'),
(568,2,'credit',NULL,6122000.0000,NULL,'2024-07-15 16:56:34',19,39562,23475,NULL,NULL,NULL,'2024-07-15 09:56:34','2024-07-15 09:56:34'),
(569,2,'credit',NULL,3097200.0000,NULL,'2024-07-15 18:29:30',3,38713,23485,NULL,NULL,NULL,'2024-07-15 11:29:30','2024-07-15 11:29:30'),
(570,2,'credit',NULL,457000.0000,NULL,'2024-07-16 09:54:28',13,39884,23531,NULL,NULL,NULL,'2024-07-16 02:54:28','2024-07-16 02:54:28'),
(571,2,'credit',NULL,1000000.0000,NULL,'2024-07-16 15:11:53',6,39926,23557,NULL,NULL,NULL,'2024-07-16 08:11:53','2024-07-16 12:42:10'),
(572,2,'credit',NULL,315000.0000,NULL,'2024-07-16 15:29:47',6,39923,23561,NULL,NULL,NULL,'2024-07-16 08:29:47','2024-07-16 08:32:31'),
(573,2,'credit',NULL,215000.0000,NULL,'2024-07-16 15:47:38',13,39932,23564,NULL,NULL,NULL,'2024-07-16 08:47:38','2024-07-16 08:47:38'),
(574,2,'credit',NULL,925000.0000,NULL,'2024-07-16 17:49:04',6,39937,23574,NULL,NULL,NULL,'2024-07-16 10:49:04','2024-07-16 10:49:04'),
(575,2,'credit',NULL,5500000.0000,NULL,'2024-07-16 19:42:10',6,39926,23583,NULL,NULL,NULL,'2024-07-16 12:42:10','2024-07-16 12:42:10'),
(576,2,'credit',NULL,200000.0000,NULL,'2024-07-16 20:20:39',6,39444,23585,NULL,NULL,NULL,'2024-07-16 13:20:39','2024-11-19 04:12:59'),
(577,2,'credit',NULL,165000.0000,NULL,'2024-07-16 20:54:25',6,39959,23587,NULL,NULL,NULL,'2024-07-16 13:54:25','2024-07-16 13:54:25'),
(578,2,'credit',NULL,2327500.0000,NULL,'2024-07-17 10:24:33',5,39995,23616,NULL,NULL,NULL,'2024-07-17 03:24:33','2024-07-17 03:24:33'),
(579,2,'credit',NULL,35000.0000,NULL,'2024-07-17 10:55:55',19,40000,23625,NULL,NULL,NULL,'2024-07-17 03:55:55','2024-07-17 03:55:55'),
(580,2,'credit',NULL,250000.0000,NULL,'2024-07-17 11:21:58',5,39915,23631,NULL,NULL,NULL,'2024-07-17 04:21:58','2024-07-17 07:39:30'),
(581,2,'credit',NULL,590000.0000,NULL,'2024-07-17 12:41:17',19,40014,23637,NULL,NULL,'2024-07-17 06:04:41','2024-07-17 05:41:17','2024-07-17 06:04:41'),
(582,2,'credit',NULL,355000.0000,NULL,'2024-07-17 13:05:02',19,40018,23638,NULL,NULL,NULL,'2024-07-17 06:05:02','2024-07-17 06:05:02'),
(583,2,'credit',NULL,2143000.0000,NULL,'2024-07-17 17:16:04',19,39190,23648,NULL,NULL,NULL,'2024-07-17 10:16:04','2024-08-04 12:12:15'),
(584,2,'debit',NULL,17185500.0000,NULL,'2024-07-17 22:54:00',1,39845,23679,NULL,NULL,NULL,'2024-07-17 15:54:56','2024-07-17 15:54:56'),
(585,2,'debit',NULL,5025600.0000,NULL,'2024-07-17 23:09:00',1,39844,23680,NULL,NULL,NULL,'2024-07-17 16:09:22','2024-07-17 16:09:22'),
(586,2,'debit',NULL,5120800.0000,NULL,'2024-07-17 23:10:00',1,39843,23681,NULL,NULL,NULL,'2024-07-17 16:10:28','2024-07-17 16:10:28'),
(587,2,'credit',NULL,1038000.0000,NULL,'2024-07-18 10:40:54',81,40088,23688,NULL,NULL,NULL,'2024-07-18 03:40:54','2024-07-18 03:40:54'),
(588,2,'credit',NULL,715000.0000,NULL,'2024-07-18 16:07:00',19,40115,23710,NULL,NULL,NULL,'2024-07-18 09:07:51','2024-07-31 04:57:59'),
(589,2,'credit',NULL,615000.0000,NULL,'2024-07-18 17:07:19',5,40120,23711,NULL,NULL,NULL,'2024-07-18 10:07:19','2024-07-18 10:07:19'),
(590,2,'credit',NULL,100000.0000,NULL,'2024-07-18 17:07:31',5,39424,23712,NULL,NULL,NULL,'2024-07-18 10:07:31','2024-07-18 10:07:31'),
(591,2,'credit',NULL,4888000.0000,NULL,'2024-07-18 17:16:03',5,39835,23713,NULL,NULL,NULL,'2024-07-18 10:16:03','2024-07-18 10:16:03'),
(592,2,'credit',NULL,293000.0000,NULL,'2024-07-18 18:44:40',49,40130,23719,NULL,NULL,NULL,'2024-07-18 11:44:40','2024-07-18 11:44:40'),
(593,2,'credit',NULL,95000.0000,NULL,'2024-07-18 18:45:00',49,40008,23720,NULL,NULL,NULL,'2024-07-18 11:45:00','2024-07-18 11:45:00'),
(594,2,'credit',NULL,95000.0000,NULL,'2024-07-18 18:45:05',49,40009,23721,NULL,NULL,NULL,'2024-07-18 11:45:05','2024-07-18 11:45:05'),
(595,2,'credit',NULL,347000.0000,NULL,'2024-07-19 10:58:51',13,40176,23748,NULL,NULL,NULL,'2024-07-19 03:58:51','2024-07-19 03:58:51'),
(596,2,'credit',NULL,165000.0000,NULL,'2024-07-19 17:30:53',3,40207,23775,NULL,NULL,NULL,'2024-07-19 10:30:53','2024-07-31 11:11:27'),
(597,2,'debit',NULL,3740700.0000,NULL,'2024-07-19 18:03:00',1,39614,23776,NULL,NULL,NULL,'2024-07-19 11:03:47','2024-07-19 11:03:47'),
(598,2,'debit',NULL,11699500.0000,NULL,'2024-07-19 18:05:00',1,38223,23777,NULL,NULL,NULL,'2024-07-19 11:05:19','2024-07-19 11:05:19'),
(599,2,'debit',NULL,7090600.0000,NULL,'2024-07-19 18:09:00',1,38157,23778,NULL,NULL,NULL,'2024-07-19 11:09:34','2024-07-19 11:09:34'),
(600,2,'debit',NULL,6500000.0000,NULL,'2024-07-19 18:11:00',1,39954,23779,NULL,NULL,NULL,'2024-07-19 11:11:09','2024-07-19 11:11:09'),
(601,2,'credit',NULL,4835000.0000,NULL,'2024-07-20 08:22:53',19,40257,23804,NULL,NULL,'2024-08-03 12:06:39','2024-07-20 01:22:53','2024-08-03 12:06:39'),
(602,2,'credit',NULL,170000.0000,NULL,'2024-07-20 09:10:01',3,40171,23811,NULL,NULL,NULL,'2024-07-20 02:10:01','2024-07-20 02:10:01'),
(603,2,'debit',NULL,415000.0000,NULL,'2024-07-20 11:10:00',10,40283,23828,NULL,NULL,NULL,'2024-07-20 04:57:22','2024-07-20 04:57:22'),
(604,2,'credit',NULL,362000.0000,NULL,'2024-07-20 14:09:57',6,40302,23847,NULL,NULL,NULL,'2024-07-20 07:09:57','2024-07-20 07:09:57'),
(605,2,'credit',NULL,2731000.0000,NULL,'2024-07-20 19:23:44',49,40296,23865,NULL,NULL,NULL,'2024-07-20 12:23:44','2024-07-31 08:00:11'),
(606,2,'debit',NULL,15004200.0000,NULL,'2024-07-20 19:34:00',1,40327,23866,NULL,NULL,NULL,'2024-07-20 12:34:21','2024-07-20 12:34:21'),
(607,2,'debit',NULL,4316500.0000,NULL,'2024-07-20 19:36:00',1,40286,23867,NULL,NULL,NULL,'2024-07-20 12:36:24','2024-07-20 12:36:24'),
(608,2,'credit',NULL,201000.0000,NULL,'2024-07-20 21:02:08',49,40345,23873,NULL,NULL,NULL,'2024-07-20 14:02:08','2024-07-20 14:02:08'),
(609,2,'credit',NULL,350000.0000,NULL,'2024-07-20 21:11:17',49,40296,23874,NULL,NULL,NULL,'2024-07-20 14:12:12','2024-07-31 08:00:12'),
(610,2,'credit',NULL,6016000.0000,NULL,'2024-07-20 22:08:45',6,40348,23876,NULL,NULL,NULL,'2024-07-20 15:08:45','2024-07-20 15:08:45'),
(611,2,'credit',NULL,200000.0000,NULL,'2024-07-21 11:50:17',49,40344,23892,NULL,NULL,NULL,'2024-07-21 04:50:17','2024-07-26 13:16:14'),
(612,2,'debit',NULL,15567500.0000,NULL,'2024-07-21 14:29:00',1,40333,23896,NULL,NULL,NULL,'2024-07-21 07:29:38','2024-07-23 09:58:46'),
(613,2,'debit',NULL,10262500.0000,NULL,'2024-07-21 14:40:00',1,40370,23901,NULL,NULL,NULL,'2024-07-21 07:40:48','2024-07-21 07:40:48'),
(614,2,'credit',NULL,58000.0000,NULL,'2024-07-21 19:34:51',3,40411,23925,NULL,NULL,NULL,'2024-07-21 12:34:51','2024-07-21 12:34:51'),
(615,2,'credit',NULL,1520000.0000,NULL,'2024-07-21 20:53:49',6,40428,23935,NULL,NULL,NULL,'2024-07-21 13:53:49','2024-07-21 13:53:49'),
(616,2,'credit',NULL,489000.0000,NULL,'2024-07-22 11:39:31',78,40449,23950,NULL,NULL,NULL,'2024-07-22 04:39:31','2024-07-22 04:47:20'),
(617,2,'credit',NULL,20000.0000,NULL,'2024-07-22 12:06:07',5,40453,23954,NULL,NULL,NULL,'2024-07-22 05:06:07','2024-07-22 05:06:07'),
(618,2,'credit',NULL,5787000.0000,NULL,'2024-07-22 11:19:02',5,40438,23947,NULL,NULL,NULL,'2024-07-22 09:52:04','2024-07-22 14:15:53'),
(619,2,'credit',NULL,5787000.0000,NULL,'2024-07-22 21:15:53',6,40438,24009,NULL,NULL,NULL,'2024-07-22 14:15:53','2024-07-22 14:15:53'),
(620,2,'credit',NULL,400000.0000,NULL,'2024-07-23 10:55:23',49,40631,24024,NULL,NULL,NULL,'2024-07-23 03:55:23','2024-07-23 03:55:23'),
(621,2,'credit',NULL,370000.0000,NULL,'2024-07-23 11:47:18',46,40635,24029,NULL,NULL,NULL,'2024-07-23 04:47:18','2024-07-23 04:47:18'),
(622,2,'credit',NULL,70000.0000,NULL,'2024-07-23 14:54:39',19,40657,24046,NULL,NULL,NULL,'2024-07-23 07:54:39','2024-07-23 07:54:39'),
(623,2,'credit',NULL,150000.0000,NULL,'2024-07-23 16:32:00',19,40585,24049,NULL,NULL,NULL,'2024-07-23 09:32:34','2024-07-23 09:37:43'),
(624,2,'credit',NULL,975000.0000,NULL,'2024-07-23 16:33:00',19,40661,24050,NULL,NULL,NULL,'2024-07-23 09:33:27','2024-07-23 09:37:07'),
(625,2,'credit',NULL,250000.0000,NULL,'2024-07-23 17:03:27',5,40199,24053,NULL,NULL,NULL,'2024-07-23 10:03:27','2024-07-31 11:13:56'),
(626,2,'debit',NULL,33751100.0000,NULL,'2024-07-23 17:38:00',1,40591,24054,NULL,NULL,NULL,'2024-07-23 10:38:40','2024-07-23 10:38:40'),
(627,2,'debit',NULL,1160700.0000,NULL,'2024-07-23 18:34:00',1,40641,24057,NULL,NULL,NULL,'2024-07-23 11:34:29','2024-07-23 11:34:29'),
(628,2,'credit',NULL,735500.0000,NULL,'2024-07-23 18:45:49',6,40666,24058,NULL,NULL,NULL,'2024-07-23 11:45:49','2024-07-23 11:45:49'),
(629,2,'credit',NULL,2934500.0000,NULL,'2024-07-23 20:05:40',11,40677,24068,NULL,NULL,NULL,'2024-07-23 13:05:40','2024-07-24 02:45:24'),
(630,2,'credit',NULL,175000.0000,NULL,'2024-07-23 20:13:17',6,40679,24070,NULL,NULL,NULL,'2024-07-23 13:13:17','2024-07-23 13:13:17'),
(631,2,'debit',NULL,9851200.0000,NULL,'2024-07-23 20:17:00',1,39817,24072,NULL,NULL,NULL,'2024-07-23 13:17:43','2024-07-23 13:17:43'),
(632,2,'credit',NULL,325000.0000,NULL,'2024-07-23 20:56:52',13,40685,24077,NULL,NULL,NULL,'2024-07-23 13:56:52','2024-07-23 13:56:52'),
(633,2,'credit',NULL,2934500.0000,NULL,'2024-07-23 21:27:14',11,40677,24082,NULL,NULL,NULL,'2024-07-23 14:27:14','2024-07-24 02:45:24'),
(634,2,'credit',NULL,550000.0000,NULL,'2024-07-24 09:33:58',49,40323,24084,NULL,NULL,NULL,'2024-07-24 02:33:58','2024-07-24 02:33:58'),
(635,2,'credit',NULL,469000.0000,NULL,'2024-07-24 09:35:55',49,40694,24085,NULL,NULL,NULL,'2024-07-24 02:35:55','2024-07-24 02:35:55'),
(636,2,'credit',NULL,5914000.0000,NULL,'2024-07-24 14:25:59',13,40725,24114,NULL,NULL,NULL,'2024-07-24 07:25:59','2024-07-24 07:34:24'),
(637,2,'credit',NULL,100000.0000,NULL,'2024-07-25 20:17:03',13,40841,24208,NULL,NULL,NULL,'2024-07-25 13:17:03','2024-07-25 13:17:03'),
(638,2,'credit',NULL,650000.0000,NULL,'2024-07-25 20:29:00',13,35591,24210,NULL,NULL,NULL,'2024-07-25 13:29:00','2024-07-25 13:29:00'),
(639,2,'credit',NULL,189500.0000,NULL,'2024-07-26 10:06:55',46,40869,24220,NULL,NULL,NULL,'2024-07-26 03:06:55','2024-07-26 03:06:55'),
(640,2,'credit',NULL,130000.0000,NULL,'2024-07-26 13:26:19',6,40888,24236,NULL,NULL,NULL,'2024-07-26 06:26:19','2024-07-26 06:26:19'),
(641,2,'debit',NULL,8717800.0000,NULL,'2024-07-26 13:58:00',1,40893,24241,NULL,NULL,NULL,'2024-07-26 06:58:09','2024-07-26 06:58:09'),
(642,2,'debit',NULL,111000.0000,NULL,'2024-07-26 14:00:00',3,40898,24243,NULL,NULL,NULL,'2024-07-26 07:33:33','2024-07-26 07:33:33'),
(643,2,'credit',NULL,251000.0000,NULL,'2024-07-26 16:11:45',5,40917,24258,NULL,NULL,NULL,'2024-07-26 09:11:45','2024-07-31 11:08:51'),
(644,2,'credit',NULL,127000.0000,NULL,'2024-07-26 17:34:52',78,40929,24268,NULL,NULL,NULL,'2024-07-26 10:40:22','2024-07-26 10:40:22'),
(645,2,'credit',NULL,550000.0000,NULL,'2024-07-26 20:16:14',3,40344,24295,NULL,NULL,NULL,'2024-07-26 13:16:14','2024-07-26 13:16:14'),
(646,2,'credit',NULL,2355000.0000,NULL,'2024-07-27 10:29:54',78,40978,24306,NULL,NULL,NULL,'2024-07-27 03:29:54','2024-07-27 03:29:54'),
(647,2,'credit',NULL,740000.0000,NULL,'2024-07-27 15:45:08',6,41024,24341,NULL,NULL,NULL,'2024-07-27 08:45:08','2024-08-04 10:08:15'),
(648,2,'credit',NULL,80000.0000,NULL,'2024-07-27 16:23:02',49,40709,24348,NULL,NULL,NULL,'2024-07-27 09:23:02','2024-07-27 09:23:02'),
(649,2,'credit',NULL,225000.0000,NULL,'2024-07-27 16:23:12',49,41030,24349,NULL,NULL,NULL,'2024-07-27 09:23:12','2024-07-27 09:23:12'),
(650,2,'credit',NULL,355000.0000,NULL,'2024-07-27 16:23:26',49,40708,24350,NULL,NULL,NULL,'2024-07-27 09:23:26','2024-07-27 09:23:26'),
(651,2,'credit',NULL,200000.0000,NULL,'2024-07-27 11:15:28',19,40870,24315,NULL,NULL,NULL,'2024-07-27 09:40:00','2025-01-21 12:21:14'),
(652,2,'credit',NULL,9868000.0000,NULL,'2024-07-28 11:30:01',46,41082,24401,NULL,NULL,NULL,'2024-07-28 04:30:01','2024-07-28 06:22:10'),
(653,2,'credit',NULL,300000.0000,NULL,'2024-07-28 13:36:24',5,40430,24420,NULL,NULL,NULL,'2024-07-28 06:36:24','2024-10-06 09:10:02'),
(654,2,'credit',NULL,200000.0000,NULL,'2024-07-28 15:01:30',46,41063,24430,NULL,NULL,NULL,'2024-07-28 08:01:30','2024-08-29 07:49:56'),
(655,2,'credit',NULL,305000.0000,NULL,'2024-07-28 18:54:11',19,41142,24463,NULL,NULL,NULL,'2024-07-28 11:54:11','2024-07-28 11:54:11'),
(656,2,'credit',NULL,270000.0000,NULL,'2024-07-28 19:03:22',49,33047,24464,NULL,NULL,NULL,'2024-07-28 12:03:22','2024-07-28 12:03:22'),
(657,2,'credit',NULL,201000.0000,NULL,'2024-07-28 19:03:25',49,41143,24465,NULL,NULL,NULL,'2024-07-28 12:03:25','2024-07-28 12:03:25'),
(658,2,'credit',NULL,228000.0000,NULL,'2024-07-29 10:50:23',6,41180,24498,NULL,NULL,NULL,'2024-07-29 03:50:23','2024-07-29 03:50:23'),
(659,2,'credit',NULL,15000.0000,NULL,'2024-07-29 10:51:00',6,40104,24499,NULL,NULL,NULL,'2024-07-29 03:51:00','2024-07-29 03:51:00'),
(660,2,'credit',NULL,322000.0000,NULL,'2024-07-29 13:00:46',93,41186,24510,NULL,NULL,NULL,'2024-07-29 06:00:46','2024-07-30 07:39:02'),
(661,2,'credit',NULL,500000.0000,NULL,'2024-07-29 13:42:16',19,41193,24516,NULL,NULL,NULL,'2024-07-29 06:42:16','2024-07-29 12:14:32'),
(662,2,'credit',NULL,480000.0000,NULL,'2024-07-29 13:47:57',3,41194,24517,NULL,NULL,NULL,'2024-07-29 06:47:57','2024-07-29 06:47:57'),
(663,2,'credit',NULL,439000.0000,NULL,'2024-07-29 14:15:03',19,41200,24518,NULL,NULL,'2024-08-04 11:36:53','2024-07-29 07:15:03','2024-08-04 11:36:53'),
(664,2,'credit',NULL,199000.0000,NULL,'2024-07-29 17:19:21',5,41221,24536,NULL,NULL,NULL,'2024-07-29 10:19:21','2024-07-29 10:19:21'),
(665,2,'credit',NULL,150000.0000,NULL,'2024-07-29 17:18:46',5,41220,24535,NULL,NULL,NULL,'2024-07-29 10:20:11','2024-07-29 10:20:11'),
(666,2,'credit',NULL,280000.0000,NULL,'2024-07-29 17:55:58',3,39963,24543,NULL,NULL,NULL,'2024-07-29 10:55:58','2024-07-29 10:55:58'),
(667,2,'credit',NULL,495000.0000,NULL,'2024-07-29 17:57:00',3,41229,24545,NULL,NULL,NULL,'2024-07-29 10:57:00','2024-07-29 10:57:00'),
(668,2,'credit',NULL,518000.0000,NULL,'2024-07-29 19:13:31',19,41193,24554,NULL,NULL,NULL,'2024-07-29 12:13:31','2024-07-29 12:14:32'),
(669,2,'credit',NULL,350000.0000,NULL,'2024-07-30 09:34:29',6,41267,24585,NULL,NULL,NULL,'2024-07-30 02:34:29','2024-07-30 02:34:29'),
(670,2,'credit',NULL,489000.0000,NULL,'2024-07-30 09:50:47',6,41270,24588,NULL,NULL,NULL,'2024-07-30 02:50:47','2024-08-04 11:17:03'),
(671,2,'credit',NULL,2000000.0000,NULL,'2024-07-30 11:55:07',6,41282,24595,NULL,NULL,NULL,'2024-07-30 04:55:07','2024-07-31 04:14:32'),
(672,2,'credit',NULL,225000.0000,NULL,'2024-07-30 14:32:39',19,41296,24622,NULL,NULL,NULL,'2024-07-30 07:32:39','2024-07-30 07:32:39'),
(673,2,'credit',NULL,155000.0000,NULL,'2024-07-30 14:38:04',19,41298,24625,NULL,NULL,NULL,'2024-07-30 07:38:04','2024-07-30 07:38:04'),
(674,2,'credit',NULL,155000.0000,NULL,'2024-07-30 14:39:05',19,41299,24627,NULL,NULL,NULL,'2024-07-30 07:39:05','2024-07-30 07:39:05'),
(675,2,'credit',NULL,243000.0000,NULL,'2024-07-30 17:03:17',93,41314,24643,NULL,NULL,NULL,'2024-07-30 10:03:17','2024-07-30 10:03:17'),
(676,2,'credit',NULL,287500.0000,NULL,'2024-07-30 19:25:43',3,41322,24657,NULL,NULL,NULL,'2024-07-30 12:25:43','2024-07-30 12:25:43'),
(677,2,'credit',NULL,287500.0000,NULL,'2024-07-30 19:25:50',3,41323,24658,NULL,NULL,NULL,'2024-07-30 12:25:50','2024-07-30 12:25:50'),
(678,2,'credit',NULL,150000.0000,NULL,'2024-07-30 19:31:16',3,41324,24660,NULL,NULL,NULL,'2024-07-30 12:31:16','2024-07-30 12:31:16'),
(679,2,'credit',NULL,150000.0000,NULL,'2024-07-30 19:31:21',3,41325,24661,NULL,NULL,NULL,'2024-07-30 12:31:21','2024-07-30 12:31:21'),
(680,2,'credit',NULL,400000.0000,NULL,'2024-07-31 10:06:18',6,41356,24678,NULL,NULL,NULL,'2024-07-31 03:06:18','2024-07-31 03:06:18'),
(681,2,'credit',NULL,2181000.0000,NULL,'2024-07-31 11:14:32',6,41282,24683,NULL,NULL,NULL,'2024-07-31 04:14:32','2024-07-31 04:14:32'),
(682,2,'credit',NULL,44000.0000,NULL,'2024-07-31 11:57:59',6,40115,24694,NULL,NULL,NULL,'2024-07-31 04:57:59','2024-07-31 04:57:59'),
(683,2,'credit',NULL,8811000.0000,NULL,'2024-07-31 12:31:19',13,41372,24695,NULL,NULL,NULL,'2024-07-31 05:31:19','2024-08-01 03:44:32'),
(684,2,'credit',NULL,1020000.0000,NULL,'2024-07-31 14:47:00',6,41381,24705,NULL,NULL,NULL,'2024-07-31 07:47:00','2024-07-31 07:47:00'),
(685,2,'credit',NULL,287500.0000,NULL,'2024-07-31 15:00:16',3,41386,24711,NULL,NULL,NULL,'2024-07-31 08:00:16','2024-07-31 08:00:16'),
(686,2,'credit',NULL,287500.0000,NULL,'2024-07-31 15:00:23',3,41387,24712,NULL,NULL,NULL,'2024-07-31 08:00:23','2024-07-31 08:00:23'),
(687,2,'credit',NULL,20000.0000,NULL,'2024-07-31 15:45:11',3,41399,24730,NULL,NULL,NULL,'2024-07-31 08:45:11','2024-07-31 08:45:11'),
(688,2,'credit',NULL,100000.0000,NULL,'2024-07-31 15:57:51',3,41403,24732,NULL,NULL,NULL,'2024-07-31 08:57:51','2024-07-31 08:57:51'),
(689,2,'credit',NULL,100000.0000,NULL,'2024-07-31 15:57:58',3,41404,24733,NULL,NULL,NULL,'2024-07-31 08:57:58','2024-07-31 08:57:58'),
(690,2,'credit',NULL,3995000.0000,NULL,'2024-07-31 17:17:14',5,41418,24739,NULL,NULL,'2024-07-31 10:30:33','2024-07-31 10:17:14','2024-07-31 10:30:33'),
(691,2,'credit',NULL,3995000.0000,NULL,'2024-07-31 17:30:46',5,41372,24742,NULL,NULL,'2024-07-31 10:34:40','2024-07-31 10:30:46','2024-07-31 10:34:40'),
(692,2,'credit',NULL,470000.0000,NULL,'2024-07-31 18:03:24',6,41426,24745,NULL,NULL,NULL,'2024-07-31 11:03:24','2024-07-31 11:03:24'),
(693,2,'credit',NULL,200000.0000,NULL,'2024-07-31 18:04:29',6,40877,24746,NULL,NULL,NULL,'2024-07-31 11:04:29','2024-07-31 11:04:29'),
(694,2,'credit',NULL,150000.0000,NULL,'2024-07-31 18:09:07',3,41428,24749,NULL,NULL,NULL,'2024-07-31 11:09:07','2024-07-31 11:09:07'),
(695,2,'credit',NULL,40000.0000,NULL,'2024-07-31 18:09:12',3,41429,24750,NULL,NULL,NULL,'2024-07-31 11:09:12','2024-07-31 11:09:12'),
(696,2,'credit',NULL,40000.0000,NULL,'2024-07-31 18:09:17',3,41430,24751,NULL,NULL,NULL,'2024-07-31 11:09:17','2024-07-31 11:09:17'),
(697,2,'credit',NULL,82500.0000,NULL,'2024-07-31 18:11:33',3,41431,24753,NULL,NULL,NULL,'2024-07-31 11:11:33','2024-07-31 11:11:33'),
(698,2,'credit',NULL,60000.0000,NULL,'2024-07-31 18:14:08',3,41432,24755,NULL,NULL,NULL,'2024-07-31 11:14:08','2024-07-31 11:14:08'),
(699,2,'credit',NULL,60000.0000,NULL,'2024-07-31 18:14:13',3,41433,24756,NULL,NULL,NULL,'2024-07-31 11:14:13','2024-07-31 11:14:13'),
(700,2,'credit',NULL,40000.0000,NULL,'2024-07-31 18:28:35',3,41440,24764,NULL,NULL,NULL,'2024-07-31 11:28:35','2024-07-31 11:28:35'),
(701,2,'credit',NULL,40000.0000,NULL,'2024-07-31 18:28:40',3,41441,24765,NULL,NULL,NULL,'2024-07-31 11:28:40','2024-07-31 11:28:40'),
(702,2,'credit',NULL,75000.0000,NULL,'2024-07-31 19:08:53',3,41446,24773,NULL,NULL,NULL,'2024-07-31 12:08:53','2024-07-31 12:08:53'),
(703,2,'credit',NULL,75000.0000,NULL,'2024-07-31 19:08:58',3,41447,24774,NULL,NULL,NULL,'2024-07-31 12:08:58','2024-07-31 12:08:58'),
(704,2,'credit',NULL,317000.0000,NULL,'2024-07-31 19:33:38',5,41451,24775,NULL,NULL,NULL,'2024-07-31 12:33:38','2024-07-31 12:33:38'),
(705,2,'credit',NULL,150000.0000,NULL,'2024-07-31 21:38:42',3,41396,24787,NULL,NULL,NULL,'2024-07-31 14:38:42','2024-07-31 14:38:42'),
(706,2,'debit',NULL,1840000.0000,NULL,'2024-08-01 08:39:00',6,41466,24789,NULL,NULL,NULL,'2024-08-01 01:41:23','2024-08-01 01:41:23'),
(707,2,'credit',NULL,75000.0000,NULL,'2024-08-01 10:54:02',49,41481,24801,NULL,NULL,NULL,'2024-08-01 03:54:02','2024-08-01 03:54:02'),
(708,2,'credit',NULL,100000.0000,NULL,'2024-08-01 10:55:42',6,41482,24802,NULL,NULL,NULL,'2024-08-01 03:55:42','2024-08-01 03:55:42'),
(709,2,'credit',NULL,511000.0000,NULL,'2024-08-01 11:49:17',49,41483,24807,NULL,NULL,NULL,'2024-08-01 04:49:17','2024-08-01 04:49:17'),
(710,2,'credit',NULL,120000.0000,NULL,'2024-08-01 14:34:15',49,41473,24822,NULL,NULL,NULL,'2024-08-01 07:34:15','2024-08-01 07:34:15'),
(711,2,'credit',NULL,623000.0000,NULL,'2024-08-01 14:34:20',49,41498,24823,NULL,NULL,NULL,'2024-08-01 07:34:20','2024-08-01 07:34:20'),
(712,2,'credit',NULL,178000.0000,NULL,'2024-08-01 15:28:58',49,41507,24828,NULL,NULL,NULL,'2024-08-01 08:28:58','2024-08-01 08:28:58'),
(713,2,'credit',NULL,175000.0000,NULL,'2024-08-01 17:29:40',3,41528,24852,NULL,NULL,NULL,'2024-08-01 10:29:40','2024-08-04 13:00:13'),
(714,2,'credit',NULL,160000.0000,NULL,'2024-08-01 17:30:09',3,41405,24853,NULL,NULL,NULL,'2024-08-01 10:30:09','2024-08-01 10:30:09'),
(715,2,'credit',NULL,23000.0000,NULL,'2024-08-01 18:46:25',19,41543,24866,NULL,NULL,NULL,'2024-08-01 11:46:25','2024-08-01 16:44:17'),
(716,2,'credit',NULL,700000.0000,NULL,'2024-08-01 19:01:47',3,41423,24868,NULL,NULL,NULL,'2024-08-01 12:01:47','2024-08-01 12:01:47'),
(717,2,'credit',NULL,397000.0000,NULL,'2024-08-01 19:02:25',3,41545,24869,NULL,NULL,NULL,'2024-08-01 12:02:25','2024-08-02 07:24:00'),
(718,2,'credit',NULL,447000.0000,NULL,'2024-08-01 19:51:48',3,41552,24878,NULL,NULL,NULL,'2024-08-01 12:51:48','2024-08-04 13:01:04'),
(719,2,'credit',NULL,105000.0000,NULL,'2024-08-01 21:04:56',5,41561,24886,NULL,NULL,NULL,'2024-08-01 14:04:56','2024-08-01 14:04:56'),
(720,2,'credit',NULL,4835000.0000,NULL,'2024-08-02 10:19:52',6,41586,24902,NULL,NULL,NULL,'2024-08-02 03:19:52','2024-08-02 03:19:52'),
(721,2,'credit',NULL,100000.0000,NULL,'2024-08-02 10:20:36',6,41470,24903,NULL,NULL,NULL,'2024-08-02 03:20:36','2024-08-02 03:20:36'),
(722,2,'credit',NULL,200000.0000,NULL,'2024-08-02 13:37:33',5,41573,24928,NULL,NULL,NULL,'2024-08-02 06:37:33','2025-01-31 05:06:22'),
(723,2,'credit',NULL,288000.0000,NULL,'2024-08-02 14:00:59',19,41608,24929,NULL,NULL,NULL,'2024-08-02 07:00:59','2024-08-02 07:00:59'),
(724,2,'credit',NULL,688000.0000,NULL,'2024-08-02 14:34:26',93,41610,24931,NULL,NULL,NULL,'2024-08-02 07:34:26','2024-08-02 07:34:26'),
(725,2,'credit',NULL,84000.0000,NULL,'2024-08-02 16:38:02',49,41627,24942,NULL,NULL,NULL,'2024-08-02 09:38:02','2024-08-02 09:38:02'),
(726,2,'credit',NULL,1250000.0000,NULL,'2024-08-02 18:20:51',5,41634,24945,NULL,NULL,NULL,'2024-08-02 11:20:51','2024-08-02 11:31:50'),
(727,2,'credit',NULL,96000.0000,NULL,'2024-08-02 18:41:12',5,41636,24947,NULL,NULL,NULL,'2024-08-02 12:57:20','2024-08-02 12:57:20'),
(728,2,'credit',NULL,362000.0000,NULL,'2024-08-02 20:01:07',5,41642,24952,NULL,NULL,NULL,'2024-08-02 13:01:07','2024-08-02 13:01:07'),
(729,2,'credit',NULL,302000.0000,NULL,'2024-08-03 12:20:26',93,41678,24988,NULL,NULL,NULL,'2024-08-03 05:20:26','2024-08-03 05:20:26'),
(730,2,'credit',NULL,71000.0000,NULL,'2024-08-03 15:41:31',5,41702,25006,NULL,NULL,NULL,'2024-08-03 08:41:31','2024-08-03 08:41:31'),
(731,2,'credit',NULL,493000.0000,NULL,'2024-08-03 17:11:37',19,41708,25015,NULL,NULL,NULL,'2024-08-03 10:11:37','2024-08-03 10:14:33'),
(732,2,'credit',NULL,4795000.0000,NULL,'2024-07-31 19:09:00',19,41727,25027,NULL,NULL,'2024-08-04 11:28:54','2024-08-03 12:09:30','2024-08-04 11:28:54'),
(733,2,'credit',NULL,1590000.0000,NULL,'2024-08-04 10:28:59',49,41783,25045,NULL,NULL,NULL,'2024-08-04 03:28:59','2024-08-04 03:28:59'),
(734,2,'credit',NULL,25000.0000,NULL,'2024-08-04 11:51:50',49,41787,25053,NULL,NULL,NULL,'2024-08-04 04:51:50','2024-08-04 04:51:50'),
(735,2,'credit',NULL,5569000.0000,NULL,'2024-08-04 12:48:42',49,41791,25055,NULL,NULL,NULL,'2024-08-04 05:48:42','2024-10-25 11:14:12'),
(736,2,'credit',NULL,328000.0000,NULL,'2024-08-04 17:05:32',106,41818,25078,NULL,NULL,NULL,'2024-08-04 10:05:32','2025-02-06 13:40:12'),
(737,2,'credit',NULL,135000.0000,NULL,'2024-08-04 17:33:23',6,40621,25084,NULL,NULL,NULL,'2024-08-04 10:33:23','2024-08-04 10:33:23'),
(738,2,'credit',NULL,439000.0000,NULL,'2024-07-29 18:37:00',6,41828,25090,NULL,NULL,NULL,'2024-08-04 11:37:21','2024-08-04 13:16:17'),
(739,2,'credit',NULL,165000.0000,NULL,'2024-08-05 10:34:08',93,41884,25126,NULL,NULL,NULL,'2024-08-05 03:34:08','2024-08-05 03:34:08'),
(740,2,'credit',NULL,799000.0000,NULL,'2024-08-05 13:18:03',93,41898,25138,NULL,NULL,NULL,'2024-08-05 06:18:03','2024-08-05 06:18:03'),
(741,2,'credit',NULL,640000.0000,NULL,'2024-08-05 13:19:11',19,41899,25139,NULL,NULL,NULL,'2024-08-05 06:19:11','2024-08-12 14:33:37'),
(742,2,'debit',NULL,2179800.0000,NULL,'2024-08-05 13:27:00',1,41836,25140,NULL,NULL,NULL,'2024-08-05 06:27:31','2024-08-05 06:27:31'),
(743,2,'credit',NULL,105000.0000,NULL,'2024-08-05 14:22:52',93,41906,25144,NULL,NULL,NULL,'2024-08-05 07:22:52','2024-08-05 07:22:52'),
(744,2,'credit',NULL,694000.0000,NULL,'2024-08-05 15:21:59',6,41900,25150,NULL,NULL,NULL,'2024-08-05 08:21:59','2024-08-05 09:58:30'),
(745,2,'credit',NULL,453700.0000,NULL,'2024-08-05 17:03:36',3,41491,25165,NULL,NULL,NULL,'2024-08-05 10:03:36','2024-08-05 10:03:36'),
(746,2,'credit',NULL,5900000.0000,NULL,'2024-08-05 19:59:02',6,41956,25181,NULL,NULL,NULL,'2024-08-05 12:59:02','2024-08-05 12:59:02'),
(747,2,'credit',NULL,90000.0000,NULL,'2024-08-05 21:31:24',6,41887,25188,NULL,NULL,NULL,'2024-08-05 14:31:24','2024-08-05 14:31:24'),
(748,2,'debit',NULL,3400000.0000,NULL,'2024-08-06 07:00:00',1,41685,25190,NULL,NULL,NULL,'2024-08-06 00:00:36','2024-08-06 00:00:36'),
(749,2,'debit',NULL,2042000.0000,NULL,'2024-08-06 09:33:00',1,41370,25192,NULL,NULL,NULL,'2024-08-06 02:33:43','2024-08-06 02:33:43'),
(750,2,'credit',NULL,276000.0000,NULL,'2024-08-06 09:34:00',19,41931,25193,NULL,NULL,NULL,'2024-08-06 02:34:21','2024-08-06 02:34:21'),
(751,2,'debit',NULL,12919000.0000,NULL,'2024-08-06 09:56:00',1,41723,25202,NULL,NULL,NULL,'2024-08-06 02:56:16','2024-08-06 02:56:16'),
(752,2,'debit',NULL,7809000.0000,NULL,'2024-08-06 10:01:00',1,41510,25203,NULL,NULL,NULL,'2024-08-06 03:01:30','2024-08-06 03:01:30'),
(753,2,'credit',NULL,750000.0000,NULL,'2024-08-06 11:51:17',19,37088,25210,NULL,NULL,NULL,'2024-08-06 04:51:17','2024-08-06 04:53:25'),
(754,2,'credit',NULL,80000.0000,NULL,'2024-08-06 11:53:25',19,37088,25211,NULL,NULL,NULL,'2024-08-06 04:53:25','2024-08-06 04:53:25'),
(755,2,'credit',NULL,590000.0000,NULL,'2024-08-06 11:54:29',19,42001,25212,NULL,NULL,NULL,'2024-08-06 04:54:29','2024-08-06 04:54:29'),
(756,2,'debit',NULL,5750400.0000,NULL,'2024-08-06 13:44:00',1,41509,25218,NULL,NULL,NULL,'2024-08-06 06:44:40','2024-08-06 06:44:40'),
(757,2,'debit',NULL,39547400.0000,NULL,'2024-08-06 13:55:00',1,41924,25220,NULL,NULL,NULL,'2024-08-06 06:55:11','2024-08-06 06:55:11'),
(758,2,'debit',NULL,100000.0000,NULL,'2024-08-06 13:56:00',1,41600,25221,NULL,NULL,NULL,'2024-08-06 06:56:11','2024-08-06 06:56:11'),
(759,2,'debit',NULL,570000.0000,NULL,'2024-08-06 13:57:00',1,41696,25222,NULL,NULL,NULL,'2024-08-06 06:57:44','2024-08-06 06:57:44'),
(760,2,'debit',NULL,420000.0000,NULL,'2024-08-06 14:01:00',1,41651,25223,NULL,NULL,NULL,'2024-08-06 07:01:37','2024-08-06 07:01:37'),
(761,2,'debit',NULL,647000.0000,NULL,'2024-08-06 14:03:00',1,41522,25224,NULL,NULL,NULL,'2024-08-06 07:03:08','2024-08-06 07:03:08'),
(762,2,'debit',NULL,18723200.0000,NULL,'2024-08-06 14:03:00',1,41499,25225,NULL,NULL,NULL,'2024-08-06 07:03:27','2024-08-06 07:03:27'),
(763,2,'debit',NULL,754800.0000,NULL,'2024-08-06 14:04:00',1,41615,25226,NULL,NULL,NULL,'2024-08-06 07:04:30','2024-08-06 07:04:30'),
(764,2,'debit',NULL,754800.0000,NULL,'2024-08-06 14:05:00',1,41918,25227,NULL,NULL,NULL,'2024-08-06 07:05:49','2024-08-06 07:05:49'),
(765,2,'debit',NULL,44682000.0000,NULL,'2024-08-06 14:07:00',1,41809,25228,NULL,NULL,NULL,'2024-08-06 07:07:10','2024-08-06 07:07:10'),
(766,2,'debit',NULL,7250000.0000,NULL,'2024-08-06 14:09:00',1,41776,25229,NULL,NULL,NULL,'2024-08-06 07:09:38','2024-08-06 07:09:38'),
(767,2,'debit',NULL,320000.0000,NULL,'2024-08-06 14:13:00',1,41803,25230,NULL,NULL,NULL,'2024-08-06 07:13:41','2024-08-06 07:13:41'),
(768,2,'credit',NULL,4100000.0000,NULL,'2024-08-06 18:26:24',3,42057,25263,NULL,NULL,NULL,'2024-08-06 11:26:24','2024-08-06 11:26:24'),
(769,2,'credit',NULL,120000.0000,NULL,'2024-08-07 13:50:00',3,41419,25310,NULL,NULL,NULL,'2024-08-07 06:50:00','2024-08-07 06:50:00'),
(770,2,'credit',NULL,550000.0000,NULL,'2024-08-07 13:50:12',3,42109,25311,NULL,NULL,NULL,'2024-08-07 06:50:12','2024-08-07 07:47:51'),
(771,2,'credit',NULL,160000.0000,NULL,'2024-08-07 15:12:47',5,41620,25314,NULL,NULL,NULL,'2024-08-07 08:12:47','2024-08-07 08:12:47'),
(772,2,'credit',NULL,309000.0000,NULL,'2024-08-07 15:14:32',5,42115,25316,NULL,NULL,NULL,'2024-08-07 08:14:32','2024-08-07 08:14:32'),
(773,2,'credit',NULL,314000.0000,NULL,'2024-08-07 16:16:07',5,42117,25321,NULL,NULL,NULL,'2024-08-07 09:16:07','2024-08-07 09:16:07'),
(774,2,'credit',NULL,356000.0000,NULL,'2024-08-07 16:24:47',5,42121,25323,NULL,NULL,'2024-08-28 07:25:08','2024-08-07 09:24:47','2024-08-28 07:25:08'),
(775,2,'credit',NULL,495000.0000,NULL,'2024-08-08 15:58:37',78,42214,25405,NULL,NULL,NULL,'2024-08-08 08:58:37','2024-08-08 08:58:37'),
(776,2,'credit',NULL,88000.0000,NULL,'2024-08-08 16:10:00',19,42216,25407,NULL,NULL,NULL,'2024-08-08 09:10:46','2024-08-08 09:10:46'),
(777,2,'credit',NULL,4721000.0000,NULL,'2024-08-08 20:57:23',3,42233,25437,NULL,NULL,NULL,'2024-08-08 13:57:23','2024-12-09 08:14:20'),
(778,2,'credit',NULL,1725000.0000,NULL,'2024-08-09 18:14:15',49,42312,25502,NULL,NULL,NULL,'2024-08-09 11:14:15','2024-08-09 11:14:15'),
(779,2,'credit',NULL,131000.0000,NULL,'2024-08-09 20:04:43',6,42329,25516,NULL,NULL,NULL,'2024-08-09 13:04:43','2024-08-09 13:04:43'),
(780,2,'credit',NULL,2242000.0000,NULL,'2024-08-09 20:24:55',13,42320,25517,NULL,NULL,NULL,'2024-08-09 13:24:55','2024-08-09 13:54:35'),
(781,2,'credit',NULL,739000.0000,NULL,'2024-08-09 17:47:44',6,42305,25495,NULL,NULL,NULL,'2024-08-09 14:20:40','2024-08-09 14:20:40'),
(782,2,'credit',NULL,718000.0000,NULL,'2024-08-10 08:13:47',5,39203,25530,NULL,NULL,NULL,'2024-08-10 01:13:47','2024-08-10 01:13:47'),
(783,2,'credit',NULL,710000.0000,NULL,'2024-08-10 12:59:34',5,42383,25560,NULL,NULL,NULL,'2024-08-10 05:59:34','2024-08-11 09:38:49'),
(784,2,'credit',NULL,355000.0000,NULL,'2024-08-10 16:14:24',93,42413,25580,NULL,NULL,NULL,'2024-08-10 09:14:24','2024-08-10 09:14:24'),
(785,2,'credit',NULL,578000.0000,NULL,'2024-08-10 17:14:51',78,42421,25585,NULL,NULL,NULL,'2024-08-10 10:14:51','2024-08-10 10:14:51'),
(786,2,'credit',NULL,450000.0000,NULL,'2024-08-10 20:44:24',11,42455,25611,NULL,NULL,'2024-08-10 13:54:46','2024-08-10 13:46:21','2024-08-10 13:54:46'),
(787,2,'credit',NULL,450000.0000,NULL,'2024-08-10 20:58:53',78,42385,25613,NULL,NULL,NULL,'2024-08-10 13:58:53','2024-08-10 13:58:53'),
(788,2,'credit',NULL,200000.0000,NULL,'2024-08-10 21:04:38',49,42416,25614,NULL,NULL,NULL,'2024-08-10 14:04:38','2024-08-14 12:16:59'),
(789,2,'credit',NULL,643000.0000,NULL,'2024-08-11 09:41:08',5,42415,25620,NULL,NULL,NULL,'2024-08-11 02:41:08','2024-08-11 02:41:08'),
(790,2,'credit',NULL,200000.0000,NULL,'2024-08-11 13:50:40',78,42333,25637,NULL,NULL,NULL,'2024-08-11 06:50:40','2024-08-12 05:44:28'),
(791,2,'credit',NULL,370000.0000,NULL,'2024-08-11 14:29:25',78,42482,25639,NULL,NULL,NULL,'2024-08-11 07:29:25','2024-08-11 07:29:25'),
(792,2,'credit',NULL,8115000.0000,NULL,'2024-08-11 15:44:53',93,42490,25646,NULL,NULL,NULL,'2024-08-11 08:44:53','2024-08-11 08:44:53'),
(793,2,'credit',NULL,85000.0000,NULL,'2024-08-12 10:16:22',19,42544,25701,NULL,NULL,NULL,'2024-08-12 03:16:22','2024-08-12 03:16:22'),
(794,2,'debit',NULL,129400.0000,NULL,'2024-08-12 11:07:00',19,42550,25705,NULL,NULL,NULL,'2024-08-12 04:09:31','2024-08-12 04:09:31'),
(795,2,'credit',NULL,655000.0000,NULL,'2024-08-12 14:17:41',11,42569,25719,NULL,NULL,NULL,'2024-08-12 07:17:41','2024-08-12 07:17:41'),
(796,2,'debit',NULL,482000.0000,NULL,'2024-08-12 15:37:00',3,42579,25727,NULL,NULL,NULL,'2024-08-12 08:41:40','2024-08-12 08:41:40'),
(797,2,'credit',NULL,8800000.0000,NULL,'2024-08-12 17:37:30',49,42590,25733,NULL,NULL,NULL,'2024-08-12 10:37:30','2024-08-12 10:37:30'),
(798,2,'credit',NULL,10600000.0000,NULL,'2024-08-12 17:57:16',3,42578,25736,NULL,NULL,NULL,'2024-08-12 10:57:16','2024-08-12 10:57:16'),
(799,2,'credit',NULL,200000.0000,NULL,'2024-08-12 20:29:40',6,40705,25749,NULL,NULL,NULL,'2024-08-12 13:29:40','2024-08-12 13:29:40'),
(800,2,'credit',NULL,640000.0000,NULL,'2024-08-12 20:29:54',6,41899,25750,NULL,NULL,NULL,'2024-08-12 13:29:54','2024-08-12 14:33:37'),
(801,2,'credit',NULL,834000.0000,NULL,'2024-08-12 20:47:36',13,42589,25753,NULL,NULL,NULL,'2024-08-12 13:47:36','2024-08-28 07:30:37'),
(802,2,'credit',NULL,422000.0000,NULL,'2024-08-13 11:58:00',19,42301,25785,NULL,NULL,NULL,'2024-08-13 04:58:20','2024-08-13 04:58:20'),
(803,2,'debit',NULL,122000.0000,NULL,'2024-08-13 16:17:00',3,42679,25798,NULL,NULL,NULL,'2024-08-13 09:19:00','2024-08-13 09:19:00'),
(804,2,'debit',NULL,90000.0000,NULL,'2024-08-13 16:19:00',3,42682,25800,NULL,NULL,NULL,'2024-08-13 09:33:18','2024-08-13 09:33:18'),
(805,2,'credit',NULL,395000.0000,NULL,'2024-08-13 17:18:09',3,42680,25805,NULL,NULL,NULL,'2024-08-13 10:18:09','2024-08-28 08:12:09'),
(806,2,'credit',NULL,200000.0000,NULL,'2024-08-13 18:38:02',3,42663,25812,NULL,NULL,NULL,'2024-08-13 11:38:02','2024-08-22 06:08:21'),
(807,2,'credit',NULL,197000.0000,NULL,'2024-08-14 08:51:59',49,42709,25824,NULL,NULL,NULL,'2024-08-14 01:51:59','2024-08-14 01:51:59'),
(808,2,'credit',NULL,910000.0000,NULL,'2024-08-14 10:36:58',19,42723,25831,NULL,NULL,NULL,'2024-08-14 03:36:58','2024-08-14 03:36:58'),
(809,2,'credit',NULL,790000.0000,NULL,'2024-08-14 12:34:37',19,42741,25845,NULL,NULL,NULL,'2024-08-14 05:34:37','2024-08-14 05:34:37'),
(810,2,'credit',NULL,62500.0000,NULL,'2024-08-14 12:45:47',19,42743,25846,NULL,NULL,NULL,'2024-08-14 05:45:47','2024-08-14 05:45:47'),
(811,2,'credit',NULL,210000.0000,NULL,'2024-08-14 13:01:45',3,42746,25850,NULL,NULL,NULL,'2024-08-14 06:01:45','2024-08-14 06:01:45'),
(812,2,'credit',NULL,200000.0000,NULL,'2024-08-14 13:07:32',3,42671,25851,NULL,NULL,NULL,'2024-08-14 06:07:32','2024-08-22 10:59:45'),
(813,2,'credit',NULL,676000.0000,NULL,'2024-08-14 15:19:03',49,42714,25861,NULL,NULL,NULL,'2024-08-14 08:19:03','2024-08-14 08:19:03'),
(814,2,'credit',NULL,200000.0000,NULL,'2024-08-15 12:05:50',5,42771,25906,NULL,NULL,NULL,'2024-08-15 05:05:50','2024-08-30 06:30:15'),
(815,2,'credit',NULL,2130000.0000,NULL,'2024-08-15 12:28:15',19,42824,25908,NULL,NULL,NULL,'2024-08-15 05:28:15','2024-08-15 05:28:15'),
(816,2,'credit',NULL,5599000.0000,NULL,'2024-08-15 14:07:41',13,42829,25910,NULL,NULL,NULL,'2024-08-15 07:07:41','2024-10-25 12:06:40'),
(817,2,'credit',NULL,1800000.0000,NULL,'2024-08-15 15:32:03',6,42840,25919,NULL,NULL,NULL,'2024-08-15 08:32:03','2024-08-15 08:32:03'),
(818,2,'credit',NULL,195000.0000,NULL,'2024-08-15 18:58:27',93,42861,25934,NULL,NULL,NULL,'2024-08-15 11:58:27','2024-08-15 11:58:27'),
(819,2,'credit',NULL,240000.0000,NULL,'2024-08-15 18:59:58',93,41649,25935,NULL,NULL,NULL,'2024-08-15 11:59:58','2024-08-15 11:59:58'),
(820,2,'debit',NULL,75000.0000,NULL,'2024-08-15 21:27:00',93,42881,25959,NULL,NULL,NULL,'2024-08-15 14:33:04','2024-08-15 14:33:04'),
(821,2,'credit',NULL,200000.0000,NULL,'2024-08-16 08:43:43',3,42856,25965,NULL,NULL,NULL,'2024-08-16 01:43:43','2024-08-24 08:03:55'),
(822,2,'credit',NULL,739000.0000,NULL,'2024-08-16 11:57:25',19,42914,25979,NULL,NULL,NULL,'2024-08-16 04:57:25','2024-08-16 04:57:25'),
(823,2,'credit',NULL,739000.0000,NULL,'2024-08-16 12:21:00',19,42916,25981,NULL,NULL,NULL,'2024-08-16 05:21:44','2024-08-16 05:56:20'),
(824,2,'credit',NULL,1189000.0000,NULL,'2024-08-16 13:55:30',78,42922,25986,NULL,NULL,NULL,'2024-08-16 06:55:30','2024-08-16 06:55:30'),
(825,2,'debit',NULL,7030000.0000,NULL,'2024-08-16 14:37:00',3,42929,25991,NULL,NULL,NULL,'2024-08-16 07:39:02','2024-08-16 07:39:02'),
(826,2,'credit',NULL,80000.0000,NULL,'2024-08-16 15:41:09',78,42931,25995,NULL,NULL,NULL,'2024-08-16 08:41:46','2024-08-16 08:41:46'),
(827,2,'credit',NULL,120000.0000,NULL,'2024-08-16 15:42:56',78,41621,25996,NULL,NULL,NULL,'2024-08-16 08:42:56','2024-08-16 08:42:56'),
(828,2,'debit',NULL,100000.0000,NULL,'2024-08-16 16:30:00',106,42939,26004,NULL,NULL,NULL,'2024-08-16 09:38:09','2024-08-16 09:38:09'),
(829,2,'credit',NULL,7000000.0000,NULL,'2024-08-16 19:50:51',13,42955,26021,NULL,NULL,NULL,'2024-08-16 12:50:51','2024-08-16 12:50:51'),
(830,2,'credit',NULL,98000.0000,NULL,'2024-08-16 20:21:13',13,42950,26022,NULL,NULL,NULL,'2024-08-16 13:21:13','2024-08-28 08:15:28'),
(831,2,'credit',NULL,702000.0000,NULL,'2024-08-17 10:26:49',6,42972,26036,NULL,NULL,NULL,'2024-08-17 03:26:49','2024-08-17 03:26:49'),
(832,2,'credit',NULL,2350000.0000,NULL,'2024-08-17 11:58:12',49,42981,26039,NULL,NULL,NULL,'2024-08-17 04:58:12','2024-08-17 04:58:12'),
(833,2,'credit',NULL,160000.0000,NULL,'2024-08-17 17:00:35',5,42888,26061,NULL,NULL,NULL,'2024-08-17 10:00:35','2024-08-17 10:29:04'),
(834,2,'credit',NULL,335000.0000,NULL,'2024-08-17 17:01:41',5,43016,26062,NULL,NULL,NULL,'2024-08-17 10:01:41','2024-08-17 10:01:41'),
(835,2,'credit',NULL,2301976.0000,NULL,'2024-08-17 18:23:11',13,43005,26066,NULL,NULL,NULL,'2024-08-17 11:23:11','2024-08-28 08:23:59'),
(836,2,'credit',NULL,5499000.0000,NULL,'2024-08-18 08:35:50',78,43038,26079,NULL,NULL,NULL,'2024-08-18 01:35:50','2024-08-18 03:14:05'),
(837,2,'credit',NULL,104500.0000,NULL,'2024-08-18 08:52:16',5,43039,26080,NULL,NULL,NULL,'2024-08-18 01:52:16','2024-08-18 01:52:16'),
(838,2,'credit',NULL,297000.0000,NULL,'2024-08-19 09:26:39',13,43089,26115,NULL,NULL,NULL,'2024-08-19 02:26:39','2024-08-19 02:56:10'),
(839,2,'credit',NULL,30000.0000,NULL,'2024-08-19 13:29:31',19,43110,26131,NULL,NULL,NULL,'2024-08-19 06:29:31','2024-08-19 06:29:31'),
(840,2,'credit',NULL,60000.0000,NULL,'2024-08-19 14:01:37',106,43112,26133,NULL,NULL,NULL,'2024-08-19 07:01:37','2024-08-19 07:01:37'),
(841,2,'credit',NULL,555000.0000,NULL,'2024-08-19 14:40:47',49,43117,26135,NULL,NULL,NULL,'2024-08-19 07:40:47','2024-08-19 07:40:47'),
(842,2,'credit',NULL,180000.0000,NULL,'2024-08-19 16:54:19',3,43147,26155,NULL,NULL,NULL,'2024-08-19 09:54:19','2024-08-19 09:54:19'),
(843,2,'credit',NULL,10839000.0000,NULL,'2024-08-19 20:39:06',19,43168,26176,NULL,NULL,NULL,'2024-08-19 13:39:06','2024-08-19 13:39:06'),
(844,2,'debit',NULL,375000.0000,NULL,'2024-08-20 09:24:00',3,42897,26188,NULL,NULL,NULL,'2024-08-20 02:24:49','2024-08-20 02:24:49'),
(845,2,'debit',NULL,240000.0000,NULL,'2024-08-20 09:34:00',3,42668,26190,NULL,NULL,NULL,'2024-08-20 02:35:04','2024-08-20 02:35:04'),
(846,2,'debit',NULL,676000.0000,NULL,'2024-08-20 09:41:00',3,41422,26191,NULL,NULL,NULL,'2024-08-20 02:41:25','2024-08-20 02:41:25'),
(847,2,'credit',NULL,2850000.0000,NULL,'2024-08-20 12:14:18',6,43187,26209,NULL,NULL,NULL,'2024-08-20 05:14:18','2024-08-21 01:53:50'),
(848,2,'debit',NULL,895000.0000,NULL,'2024-08-20 12:55:00',3,42251,26215,NULL,NULL,NULL,'2024-08-20 05:55:26','2024-08-20 05:55:26'),
(849,2,'debit',NULL,2268500.0000,NULL,'2024-08-20 13:01:00',3,41018,26216,NULL,NULL,NULL,'2024-08-20 06:02:02','2024-08-20 06:02:02'),
(850,2,'debit',NULL,314000.0000,NULL,'2024-08-20 13:17:00',6,39400,26223,NULL,NULL,NULL,'2024-08-20 06:17:48','2024-08-20 06:17:48'),
(851,2,'debit',NULL,6046300.0000,NULL,'2024-08-20 13:55:00',19,43200,26226,NULL,NULL,'2024-08-27 11:32:51','2024-08-20 06:58:41','2024-08-27 11:32:51'),
(852,2,'debit',NULL,67000.0000,NULL,'2024-08-20 14:37:00',6,42360,26235,NULL,NULL,NULL,'2024-08-20 07:37:47','2024-08-20 07:37:47'),
(853,2,'credit',NULL,250000.0000,NULL,'2024-08-20 15:22:05',5,43206,26242,NULL,NULL,'2024-08-20 08:22:06','2024-08-20 08:22:05','2024-08-20 08:22:06'),
(854,2,'credit',NULL,250000.0000,NULL,'2024-08-20 15:22:06',5,43206,26243,NULL,NULL,'2024-08-30 06:44:09','2024-08-20 08:22:06','2024-08-30 06:44:09'),
(855,2,'credit',NULL,8325000.0000,NULL,'2024-08-20 15:22:36',5,42352,26244,NULL,NULL,NULL,'2024-08-20 08:22:36','2025-10-30 12:53:49'),
(856,2,'credit',NULL,8979000.0000,NULL,'2024-08-20 15:23:00',5,42349,26246,NULL,NULL,NULL,'2024-08-20 08:23:00','2024-12-09 07:57:15'),
(857,2,'debit',NULL,55000.0000,NULL,'2024-08-20 15:55:00',6,39198,26254,NULL,NULL,NULL,'2024-08-20 08:55:46','2024-08-20 08:55:46'),
(858,2,'debit',NULL,1352600.0000,NULL,'2024-08-20 16:11:00',6,40478,26259,NULL,NULL,NULL,'2024-08-20 09:11:46','2024-08-20 09:11:46'),
(859,2,'debit',NULL,36845300.0000,NULL,'2024-08-20 16:23:00',6,40241,26262,NULL,NULL,NULL,'2024-08-20 09:23:42','2024-08-20 09:23:42'),
(860,2,'debit',NULL,400000.0000,NULL,'2024-08-20 16:29:00',6,42665,26266,NULL,NULL,NULL,'2024-08-20 09:30:02','2024-08-20 09:30:02'),
(861,2,'debit',NULL,60000.0000,NULL,'2024-08-20 17:00:00',3,42761,26271,NULL,NULL,NULL,'2024-08-20 10:00:46','2024-08-20 10:00:46'),
(862,2,'debit',NULL,132000.0000,NULL,'2024-08-20 17:05:00',3,40316,26273,NULL,NULL,NULL,'2024-08-20 10:05:21','2024-08-20 10:05:21'),
(863,2,'debit',NULL,95600.0000,NULL,'2024-08-20 19:50:00',19,43245,26284,NULL,NULL,NULL,'2024-08-20 12:54:49','2024-08-20 12:54:49'),
(864,2,'credit',NULL,189000.0000,NULL,'2024-08-20 20:22:21',49,43249,26288,NULL,NULL,NULL,'2024-08-20 13:22:21','2024-08-20 13:22:21'),
(865,2,'credit',NULL,5599000.0000,NULL,'2024-08-21 11:54:33',6,43285,26316,NULL,NULL,NULL,'2024-08-21 04:54:33','2024-08-21 04:54:33'),
(866,2,'credit',NULL,3181000.0000,NULL,'2024-08-21 13:18:39',5,43241,26332,NULL,NULL,NULL,'2024-08-21 06:18:39','2024-09-01 05:39:09'),
(867,2,'credit',NULL,5881000.0000,NULL,'2024-08-21 17:15:00',19,43320,26343,NULL,NULL,NULL,'2024-08-21 10:15:11','2024-08-21 10:15:11'),
(868,2,'credit',NULL,300000.0000,NULL,'2024-08-21 17:56:15',5,43284,26346,NULL,NULL,NULL,'2024-08-21 10:56:15','2024-09-10 08:29:22'),
(869,2,'credit',NULL,77000.0000,NULL,'2024-08-21 18:15:22',5,43322,26349,NULL,NULL,NULL,'2024-08-21 11:15:22','2024-08-28 08:46:07'),
(870,2,'credit',NULL,656000.0000,NULL,'2024-08-21 18:54:10',19,43334,26353,NULL,NULL,NULL,'2024-08-21 11:54:10','2024-08-21 11:54:10'),
(871,2,'credit',NULL,22000.0000,NULL,'2024-08-21 21:25:11',19,37941,26365,NULL,NULL,NULL,'2024-08-21 14:25:11','2024-08-21 14:25:11'),
(872,2,'credit',NULL,829000.0000,NULL,'2024-08-22 11:15:39',6,43366,26378,NULL,NULL,NULL,'2024-08-22 04:15:39','2024-08-22 04:15:39'),
(873,2,'credit',NULL,6000000.0000,NULL,'2024-08-22 12:42:52',6,43372,26385,NULL,NULL,NULL,'2024-08-22 05:42:52','2024-08-22 05:42:52'),
(874,2,'credit',NULL,2315000.0000,NULL,'2024-08-22 12:55:59',13,35064,26387,NULL,NULL,NULL,'2024-08-22 05:55:59','2024-08-22 05:55:59'),
(875,2,'credit',NULL,100000.0000,NULL,'2024-08-22 12:56:16',13,31962,26388,NULL,NULL,NULL,'2024-08-22 05:56:16','2024-08-22 05:56:16'),
(876,2,'credit',NULL,750000.0000,NULL,'2024-08-22 13:08:21',13,42663,26391,NULL,NULL,NULL,'2024-08-22 06:08:21','2024-08-22 06:08:21'),
(877,2,'credit',NULL,297000.0000,NULL,'2024-08-22 14:07:06',19,43381,26397,NULL,NULL,NULL,'2024-08-22 07:07:06','2024-08-22 07:07:06'),
(878,2,'credit',NULL,495000.0000,NULL,'2024-08-22 17:28:30',19,43403,26410,NULL,NULL,NULL,'2024-08-22 10:28:30','2024-08-22 10:28:30'),
(879,2,'credit',NULL,10000.0000,NULL,'2024-08-22 20:04:35',19,43414,26419,NULL,NULL,NULL,'2024-08-22 13:04:35','2024-08-22 13:04:35'),
(880,2,'credit',NULL,160000.0000,NULL,'2024-08-23 14:30:26',6,43070,26453,NULL,NULL,NULL,'2024-08-23 07:30:26','2024-08-23 07:30:26'),
(881,2,'credit',NULL,86000.0000,NULL,'2024-08-24 10:04:36',13,43515,26504,NULL,NULL,NULL,'2024-08-24 03:04:36','2024-08-28 08:48:53'),
(882,2,'debit',NULL,27056400.0000,NULL,'2024-08-24 10:07:00',1,43377,26505,NULL,NULL,NULL,'2024-08-24 03:07:44','2024-08-24 03:07:44'),
(883,2,'debit',NULL,29587500.0000,NULL,'2024-08-24 10:19:00',1,42985,26507,NULL,NULL,NULL,'2024-08-24 03:19:27','2024-08-24 03:19:27'),
(884,2,'debit',NULL,11428000.0000,NULL,'2024-08-24 10:59:00',1,43362,26509,NULL,NULL,NULL,'2024-08-24 03:59:40','2024-08-24 03:59:40'),
(885,2,'credit',NULL,274000.0000,NULL,'2024-08-24 13:11:27',3,43526,26517,NULL,NULL,NULL,'2024-08-24 06:11:27','2024-08-24 06:11:27'),
(886,2,'credit',NULL,740000.0000,NULL,'2024-08-24 13:25:02',19,43541,26527,NULL,NULL,NULL,'2024-08-24 06:25:02','2024-08-24 06:25:02'),
(887,2,'debit',NULL,432000.0000,NULL,'2024-08-24 14:28:00',3,43548,26528,NULL,NULL,NULL,'2024-08-24 07:37:57','2024-08-24 07:37:57'),
(888,2,'credit',NULL,530000.0000,NULL,'2024-08-25 13:08:53',5,43621,26584,NULL,NULL,NULL,'2024-08-25 06:08:53','2024-08-25 06:08:53'),
(889,2,'credit',NULL,164000.0000,NULL,'2024-08-25 14:47:56',19,43625,26588,NULL,NULL,NULL,'2024-08-25 07:47:56','2024-08-25 07:47:56'),
(890,2,'credit',NULL,655000.0000,NULL,'2024-08-25 17:30:47',11,43646,26605,NULL,NULL,NULL,'2024-08-25 10:30:47','2024-08-25 10:30:47'),
(891,2,'credit',NULL,670000.0000,NULL,'2024-08-26 12:50:16',6,43693,26647,NULL,NULL,NULL,'2024-08-26 05:50:16','2024-08-26 05:50:16'),
(892,2,'credit',NULL,213000.0000,NULL,'2024-08-26 15:01:05',3,43699,26652,NULL,NULL,NULL,'2024-08-26 08:01:05','2024-08-26 08:01:05'),
(893,2,'credit',NULL,5300.0000,NULL,'2024-08-26 15:24:58',19,43704,26657,NULL,NULL,NULL,'2024-08-26 08:24:58','2025-01-06 08:18:15'),
(894,2,'credit',NULL,386000.0000,NULL,'2024-08-26 17:15:16',3,43719,26666,NULL,NULL,NULL,'2024-08-26 10:15:16','2024-08-28 08:52:01'),
(895,2,'credit',NULL,3000000.0000,NULL,'2024-08-26 17:16:02',78,43722,26667,NULL,NULL,NULL,'2024-08-26 10:16:02','2024-08-26 10:25:58'),
(896,2,'credit',NULL,2682000.0000,NULL,'2024-08-26 17:25:58',78,43722,26669,NULL,NULL,NULL,'2024-08-26 10:25:58','2024-08-26 10:25:58'),
(897,2,'credit',NULL,6925000.0000,NULL,'2024-08-27 17:08:33',6,43797,26725,NULL,NULL,NULL,'2024-08-27 10:08:33','2024-08-27 10:08:33'),
(898,2,'credit',NULL,5642000.0000,NULL,'2024-08-27 18:09:46',19,43802,26727,NULL,NULL,NULL,'2024-08-27 11:09:46','2024-08-27 11:09:46'),
(899,2,'credit',NULL,4659000.0000,NULL,'2024-08-27 18:39:00',19,43571,26736,NULL,NULL,NULL,'2024-08-27 11:39:40','2024-08-29 08:02:45'),
(900,2,'credit',NULL,50000.0000,NULL,'2024-08-27 19:55:57',13,43818,26743,NULL,NULL,NULL,'2024-08-27 12:55:57','2024-08-27 12:55:57'),
(901,2,'credit',NULL,5595000.0000,NULL,'2024-08-27 14:17:00',11,43767,26706,NULL,NULL,NULL,'2024-08-27 13:06:59','2024-08-27 13:20:45'),
(902,2,'credit',NULL,450000.0000,NULL,'2024-08-28 08:20:32',49,43792,26749,NULL,NULL,NULL,'2024-08-28 01:20:32','2024-08-28 01:20:32'),
(903,2,'credit',NULL,776000.0000,NULL,'2024-08-28 14:05:35',5,43826,26783,NULL,NULL,NULL,'2024-08-28 07:05:35','2024-08-28 07:05:35'),
(904,2,'credit',NULL,137500.0000,NULL,'2024-08-28 14:31:10',3,43860,26786,NULL,NULL,NULL,'2024-08-28 07:31:10','2024-08-28 07:31:10'),
(905,2,'credit',NULL,137500.0000,NULL,'2024-08-28 14:31:18',3,43861,26787,NULL,NULL,NULL,'2024-08-28 07:31:18','2024-08-28 07:31:18'),
(906,2,'debit',NULL,90000.0000,NULL,'2024-08-28 15:09:00',19,43868,26791,NULL,NULL,NULL,'2024-08-28 08:11:39','2024-08-28 08:11:39'),
(907,2,'credit',NULL,75000.0000,NULL,'2024-08-28 15:11:49',3,43869,26792,NULL,NULL,NULL,'2024-08-28 08:11:49','2024-08-28 08:11:49'),
(908,2,'credit',NULL,75000.0000,NULL,'2024-08-28 15:12:03',3,43870,26793,NULL,NULL,NULL,'2024-08-28 08:12:03','2024-08-28 08:12:03'),
(909,2,'credit',NULL,100000.0000,NULL,'2024-08-28 15:13:59',19,43871,26795,NULL,NULL,NULL,'2024-08-28 08:13:59','2024-08-28 14:06:02'),
(910,2,'credit',NULL,40000.0000,NULL,'2024-08-28 15:15:23',3,43872,26796,NULL,NULL,NULL,'2024-08-28 08:15:23','2024-08-28 08:15:23'),
(911,2,'credit',NULL,300000.0000,NULL,'2024-08-28 15:24:11',3,43873,26799,NULL,NULL,NULL,'2024-08-28 08:24:11','2024-08-28 08:24:11'),
(912,2,'credit',NULL,300000.0000,NULL,'2024-08-28 15:24:16',3,43874,26800,NULL,NULL,NULL,'2024-08-28 08:24:16','2024-08-28 08:24:16'),
(913,2,'credit',NULL,164000.0000,NULL,'2024-08-28 15:27:15',93,43876,26801,NULL,NULL,NULL,'2024-08-28 08:27:15','2024-08-28 08:27:15'),
(914,2,'credit',NULL,25000.0000,NULL,'2024-08-28 15:46:03',3,43879,26804,NULL,NULL,NULL,'2024-08-28 08:46:03','2024-08-28 08:46:03'),
(915,2,'credit',NULL,40000.0000,NULL,'2024-08-28 15:48:56',3,43880,26807,NULL,NULL,NULL,'2024-08-28 08:48:56','2024-08-28 08:48:56'),
(916,2,'debit',NULL,18949300.0000,NULL,'2024-08-29 06:49:00',1,43523,26839,NULL,NULL,'2024-08-29 00:20:06','2024-08-28 23:49:37','2024-08-29 00:20:06'),
(917,2,'debit',NULL,4752000.0000,NULL,'2024-08-29 06:55:00',1,43810,26840,NULL,NULL,NULL,'2024-08-28 23:55:09','2024-08-28 23:55:09'),
(918,2,'debit',NULL,379600.0000,NULL,'2024-08-29 07:12:00',1,43866,26841,NULL,NULL,NULL,'2024-08-29 00:12:14','2024-08-29 00:12:14'),
(919,2,'debit',NULL,22500000.0000,NULL,'2024-08-29 07:16:00',1,43753,26842,NULL,NULL,NULL,'2024-08-29 00:16:47','2024-08-29 00:16:47'),
(920,2,'debit',NULL,24528000.0000,NULL,'2024-08-29 07:17:00',1,43780,26843,NULL,NULL,NULL,'2024-08-29 00:17:52','2024-08-29 00:17:52'),
(921,2,'debit',NULL,2700000.0000,NULL,'2024-08-29 07:19:00',1,43559,26844,NULL,NULL,NULL,'2024-08-29 00:19:20','2024-08-29 00:19:20'),
(922,2,'debit',NULL,8717800.0000,NULL,'2024-08-29 07:27:00',1,40789,26845,NULL,NULL,NULL,'2024-08-29 00:28:00','2024-08-29 00:28:00'),
(923,2,'debit',NULL,305000.0000,NULL,'2024-08-29 07:45:00',1,41997,26846,NULL,NULL,NULL,'2024-08-29 00:45:55','2024-08-29 00:45:55'),
(924,2,'debit',NULL,32429600.0000,NULL,'2024-08-29 08:28:00',1,42409,26847,NULL,NULL,NULL,'2024-08-29 01:28:34','2024-08-29 01:28:34'),
(925,2,'debit',NULL,196954.0000,NULL,'2024-08-29 08:29:00',1,43325,26848,NULL,NULL,NULL,'2024-08-29 01:29:58','2024-08-29 01:29:58'),
(926,2,'debit',NULL,5175000.0000,NULL,'2024-08-29 08:32:00',1,43710,26849,NULL,NULL,NULL,'2024-08-29 01:32:40','2024-08-29 01:32:40'),
(927,2,'credit',NULL,2500000.0000,NULL,'2024-08-29 09:03:05',6,43897,26850,NULL,NULL,NULL,'2024-08-29 02:03:05','2025-01-16 07:11:17'),
(928,2,'debit',NULL,17979000.0000,NULL,'2024-08-29 10:22:00',1,43923,26856,NULL,NULL,NULL,'2024-08-29 03:23:00','2024-08-29 03:23:00'),
(929,2,'credit',NULL,1466000.0000,NULL,'2024-08-29 13:54:44',19,43949,26868,NULL,NULL,NULL,'2024-08-29 06:54:44','2024-08-29 06:54:44'),
(930,2,'debit',NULL,37041400.0000,NULL,'2024-08-30 09:18:00',1,43965,26918,NULL,NULL,NULL,'2024-08-30 02:18:07','2024-08-30 02:18:07'),
(931,2,'credit',NULL,180000.0000,NULL,'2024-08-30 10:46:55',49,43746,26951,NULL,NULL,NULL,'2024-08-30 03:46:55','2024-08-30 04:19:12'),
(932,2,'credit',NULL,1437450.0000,NULL,'2024-08-20 15:57:23',3,39372,26255,NULL,NULL,NULL,'2024-08-30 04:52:57','2024-10-24 06:28:09'),
(933,2,'credit',NULL,1380000.0000,NULL,'2024-08-30 14:44:21',3,44042,26971,NULL,NULL,NULL,'2024-08-30 07:44:21','2024-08-30 07:44:21'),
(934,2,'credit',NULL,1380000.0000,NULL,'2024-08-30 14:44:27',3,44043,26972,NULL,NULL,NULL,'2024-08-30 07:44:27','2024-08-30 07:44:27'),
(935,2,'credit',NULL,1390000.0000,NULL,'2024-08-30 14:44:35',3,44044,26973,NULL,NULL,NULL,'2024-08-30 07:44:35','2024-08-30 07:44:35'),
(936,2,'credit',NULL,676000.0000,NULL,'2024-08-31 09:08:27',11,44090,27012,NULL,NULL,NULL,'2024-08-31 02:08:27','2024-08-31 02:08:27'),
(937,2,'credit',NULL,370000.0000,NULL,'2024-08-31 09:31:11',93,44099,27019,NULL,NULL,NULL,'2024-08-31 02:31:11','2024-08-31 02:31:11'),
(938,2,'credit',NULL,1170000.0000,NULL,'2024-08-31 17:11:28',5,44145,27045,NULL,NULL,NULL,'2024-08-31 10:11:28','2024-09-02 03:51:45'),
(939,2,'credit',NULL,80000.0000,NULL,'2024-08-31 21:53:51',106,44116,27065,NULL,NULL,NULL,'2024-08-31 14:53:51','2024-08-31 14:53:51'),
(940,2,'credit',NULL,309000.0000,NULL,'2024-08-31 21:52:06',106,44177,27064,NULL,NULL,NULL,'2024-08-31 14:55:19','2024-08-31 14:55:19'),
(941,2,'credit',NULL,150000.0000,NULL,'2024-09-01 09:06:44',3,44180,27070,NULL,NULL,NULL,'2024-09-01 02:06:44','2024-09-01 02:06:44'),
(942,2,'credit',NULL,150000.0000,NULL,'2024-09-01 09:06:49',3,44181,27071,NULL,NULL,NULL,'2024-09-01 02:06:49','2024-09-01 02:06:49'),
(943,2,'credit',NULL,100000.0000,NULL,'2024-09-01 09:38:39',3,44183,27072,NULL,NULL,NULL,'2024-09-01 02:38:39','2024-09-01 02:38:39'),
(944,2,'credit',NULL,129000.0000,NULL,'2024-09-01 11:07:34',3,44192,27078,NULL,NULL,NULL,'2024-09-01 04:07:34','2024-09-29 03:10:24'),
(945,2,'credit',NULL,150000.0000,NULL,'2024-09-01 12:32:07',3,44200,27086,NULL,NULL,NULL,'2024-09-01 05:32:07','2024-09-01 05:32:07'),
(946,2,'credit',NULL,150000.0000,NULL,'2024-09-01 12:32:16',3,44201,27087,NULL,NULL,NULL,'2024-09-01 05:32:16','2024-09-01 05:32:16'),
(947,2,'credit',NULL,362500.0000,NULL,'2024-09-01 12:39:15',3,44202,27089,NULL,NULL,NULL,'2024-09-01 05:39:15','2024-09-01 05:39:15'),
(948,2,'credit',NULL,362500.0000,NULL,'2024-09-01 12:39:22',3,44203,27090,NULL,NULL,NULL,'2024-09-01 05:39:22','2024-09-01 05:39:22'),
(949,2,'credit',NULL,317000.0000,NULL,'2024-09-01 16:43:46',3,44225,27106,NULL,NULL,NULL,'2024-09-01 09:43:46','2024-09-01 09:43:46'),
(950,2,'credit',NULL,60000.0000,NULL,'2024-09-02 12:34:37',106,44040,27154,NULL,NULL,NULL,'2024-09-02 05:34:37','2024-09-02 05:34:37'),
(951,2,'debit',NULL,336600.0000,NULL,'2024-09-03 14:50:00',19,44381,27249,NULL,NULL,NULL,'2024-09-03 07:52:37','2024-09-03 07:52:37'),
(952,2,'credit',NULL,435000.0000,NULL,'2024-09-03 16:53:52',3,41044,27274,NULL,NULL,NULL,'2024-09-03 09:53:52','2024-09-03 09:53:52'),
(953,2,'credit',NULL,4799000.0000,NULL,'2024-09-03 18:46:23',19,44414,27290,NULL,NULL,NULL,'2024-09-03 11:46:23','2024-09-03 11:46:23'),
(954,2,'credit',NULL,2864000.0000,NULL,'2024-09-03 20:32:17',19,43897,27306,NULL,NULL,NULL,'2024-09-03 13:32:17','2025-01-16 07:11:17'),
(955,2,'credit',NULL,200000.0000,NULL,'2024-09-03 20:36:33',13,44397,27307,NULL,NULL,NULL,'2024-09-03 13:36:33','2024-10-16 10:01:27'),
(956,2,'debit',NULL,544000.0000,NULL,'2024-09-04 07:09:00',1,44395,27314,NULL,NULL,NULL,'2024-09-04 00:09:52','2024-09-04 00:09:52'),
(957,2,'debit',NULL,61800.0000,NULL,'2024-09-04 07:12:00',1,44279,27315,NULL,NULL,NULL,'2024-09-04 00:12:25','2024-09-04 00:12:25'),
(958,2,'credit',NULL,240000.0000,NULL,'2024-09-04 08:15:14',49,42687,27316,NULL,NULL,NULL,'2024-09-04 01:15:14','2024-09-04 01:15:14'),
(959,2,'debit',NULL,5148600.0000,NULL,'2024-09-04 09:36:00',1,43692,27320,NULL,NULL,NULL,'2024-09-04 02:36:40','2024-09-04 02:36:40'),
(960,2,'credit',NULL,10591000.0000,NULL,'2024-09-04 10:09:15',49,44442,27324,NULL,NULL,NULL,'2024-09-04 03:09:15','2024-09-15 11:57:48'),
(961,2,'credit',NULL,499500.0000,NULL,'2024-09-04 11:29:14',49,44147,27327,NULL,NULL,NULL,'2024-09-04 04:29:14','2024-09-04 04:29:14'),
(962,2,'credit',NULL,177000.0000,NULL,'2024-09-04 12:40:07',49,44453,27331,NULL,NULL,NULL,'2024-09-04 05:40:07','2024-09-29 03:08:04'),
(963,2,'credit',NULL,2892000.0000,NULL,'2024-09-04 16:38:49',49,44490,27352,NULL,NULL,NULL,'2024-09-04 09:38:49','2024-09-04 09:42:31'),
(964,2,'credit',NULL,220000.0000,NULL,'2024-09-04 20:36:45',78,44298,27377,NULL,NULL,NULL,'2024-09-04 13:37:22','2024-09-04 13:37:22'),
(965,2,'credit',NULL,200000.0000,NULL,'2024-09-05 09:02:18',49,44053,27385,NULL,NULL,NULL,'2024-09-05 02:02:18','2024-09-10 12:50:46'),
(966,2,'credit',NULL,110000.0000,NULL,'2024-09-05 10:15:03',49,44528,27387,NULL,NULL,NULL,'2024-09-05 03:15:03','2024-09-05 03:15:03'),
(967,2,'credit',NULL,200000.0000,NULL,'2024-09-05 11:46:41',6,43413,27392,NULL,NULL,NULL,'2024-09-05 04:46:41','2024-10-18 09:02:16'),
(968,2,'credit',NULL,55000.0000,NULL,'2024-09-05 14:44:42',19,44524,27400,NULL,NULL,NULL,'2024-09-05 07:44:42','2024-09-05 07:44:42'),
(969,2,'credit',NULL,577000.0000,NULL,'2024-09-05 14:45:38',19,44548,27401,NULL,NULL,NULL,'2024-09-05 07:45:39','2024-09-05 07:45:39'),
(970,2,'credit',NULL,530000.0000,NULL,'2024-09-05 16:22:20',6,44565,27413,NULL,NULL,NULL,'2024-09-05 09:22:20','2024-09-05 09:22:20'),
(971,2,'credit',NULL,872000.0000,NULL,'2024-09-05 18:23:55',5,44569,27426,NULL,NULL,NULL,'2024-09-05 11:23:55','2024-09-29 03:34:02'),
(972,2,'credit',NULL,799000.0000,NULL,'2024-09-05 20:10:33',5,44589,27437,NULL,NULL,NULL,'2024-09-05 13:10:33','2024-09-05 13:10:33'),
(973,2,'credit',NULL,200000.0000,NULL,'2024-09-06 15:30:20',6,44376,27461,NULL,NULL,NULL,'2024-09-06 08:30:20','2024-09-26 07:48:43'),
(974,2,'credit',NULL,2979000.0000,NULL,'2024-09-06 16:09:34',6,44631,27467,NULL,NULL,NULL,'2024-09-06 09:09:34','2024-09-06 09:09:34'),
(975,2,'debit',NULL,544000.0000,NULL,'2024-09-06 16:31:00',6,44635,27469,NULL,NULL,NULL,'2024-09-06 09:32:49','2024-09-06 09:32:49'),
(976,2,'credit',NULL,714000.0000,NULL,'2024-09-06 17:20:09',6,44639,27476,NULL,NULL,NULL,'2024-09-06 10:20:09','2024-09-06 10:20:09'),
(977,2,'credit',NULL,795000.0000,NULL,'2024-09-07 12:05:04',10,44677,27511,NULL,NULL,NULL,'2024-09-07 05:06:21','2024-09-07 05:06:21'),
(978,2,'credit',NULL,303000.0000,NULL,'2024-09-07 14:50:48',13,44691,27522,NULL,NULL,NULL,'2024-09-07 07:50:48','2024-09-07 07:50:48'),
(979,2,'credit',NULL,152000.0000,NULL,'2024-09-07 15:44:00',19,44697,27525,NULL,NULL,NULL,'2024-09-07 08:45:13','2024-09-29 04:46:15'),
(980,2,'credit',NULL,81000.0000,NULL,'2024-09-07 17:47:35',19,44711,27530,NULL,NULL,NULL,'2024-09-07 10:47:35','2024-09-07 10:47:35'),
(981,2,'debit',NULL,312056.0000,NULL,'2024-09-07 18:05:00',19,44712,27531,NULL,NULL,'2024-09-13 01:58:16','2024-09-07 11:08:15','2024-09-13 01:58:16'),
(982,2,'credit',NULL,15000.0000,NULL,'2024-09-07 18:30:00',19,44709,27534,NULL,NULL,NULL,'2024-09-07 11:31:03','2024-09-26 12:28:23'),
(983,2,'credit',NULL,5099000.0000,NULL,'2024-09-08 17:31:26',19,44764,27578,NULL,NULL,NULL,'2024-09-08 10:31:26','2024-09-08 11:17:27'),
(984,2,'credit',NULL,180000.0000,NULL,'2024-09-09 08:33:09',19,44774,27591,NULL,NULL,NULL,'2024-09-09 01:33:09','2024-09-09 01:33:09'),
(985,2,'credit',NULL,666000.0000,NULL,'2024-09-09 09:25:05',93,44782,27593,NULL,NULL,NULL,'2024-09-09 02:25:05','2024-09-09 02:25:05'),
(986,2,'credit',NULL,350000.0000,NULL,'2024-09-09 11:14:48',5,44775,27600,NULL,NULL,'2024-09-11 09:51:52','2024-09-09 04:14:48','2024-09-11 09:51:52'),
(987,2,'credit',NULL,1437450.0000,NULL,'2024-09-09 17:15:21',3,39372,27625,NULL,NULL,'2024-09-09 13:47:31','2024-09-09 10:15:21','2024-09-09 13:47:31'),
(988,2,'credit',NULL,3429500.0000,NULL,'2024-09-09 20:38:24',6,44869,27652,NULL,NULL,NULL,'2024-09-09 13:38:56','2024-09-26 12:31:54'),
(989,2,'credit',NULL,70000.0000,NULL,'2024-09-09 21:23:51',3,44797,27654,NULL,NULL,NULL,'2024-09-09 14:23:51','2024-09-10 04:26:14'),
(990,2,'debit',NULL,52000.0000,NULL,'2024-09-10 10:24:00',19,44887,27668,NULL,NULL,NULL,'2024-09-10 03:24:39','2024-09-10 03:24:39'),
(991,2,'credit',NULL,980000.0000,NULL,'2024-09-10 10:26:31',5,44610,27669,NULL,NULL,NULL,'2024-09-10 03:26:31','2024-09-10 03:26:31'),
(992,2,'debit',NULL,183234.0000,NULL,'2024-09-10 11:06:00',19,44896,27675,NULL,NULL,NULL,'2024-09-10 04:07:50','2024-09-10 04:07:50'),
(993,2,'credit',NULL,3015000.0000,NULL,'2024-09-10 13:14:42',13,44803,27678,NULL,NULL,NULL,'2024-09-10 06:14:42','2024-09-10 06:14:42'),
(994,2,'credit',NULL,80000.0000,NULL,'2024-09-10 14:32:53',19,44875,27684,NULL,NULL,NULL,'2024-09-10 07:32:53','2024-09-10 07:51:58'),
(995,2,'credit',NULL,610000.0000,NULL,'2024-09-10 15:35:00',19,44919,27689,NULL,NULL,NULL,'2024-09-10 08:35:16','2024-09-10 08:35:16'),
(996,2,'debit',NULL,200000.0000,NULL,'2024-09-10 15:49:00',19,44925,27691,NULL,NULL,NULL,'2024-09-10 08:50:34','2024-09-10 08:50:34'),
(997,2,'credit',NULL,80000.0000,NULL,'2024-09-10 17:33:51',13,44939,27696,NULL,NULL,NULL,'2024-09-10 10:33:51','2024-09-10 10:33:51'),
(998,2,'credit',NULL,175000.0000,NULL,'2024-09-10 17:58:58',13,44941,27697,NULL,NULL,NULL,'2024-09-10 10:58:58','2024-09-10 10:58:58'),
(999,2,'credit',NULL,258000.0000,NULL,'2024-09-10 18:06:15',13,44937,27699,NULL,NULL,NULL,'2024-09-10 11:06:15','2024-09-29 03:02:58'),
(1000,2,'credit',NULL,400000.0000,NULL,'2024-09-10 18:08:28',13,44945,27701,NULL,NULL,NULL,'2024-09-10 11:08:28','2024-09-10 11:08:28'),
(1001,2,'credit',NULL,125000.0000,NULL,'2024-09-10 18:32:10',106,44948,27705,NULL,NULL,NULL,'2024-09-10 11:32:10','2024-09-10 11:32:10'),
(1002,2,'credit',NULL,847000.0000,NULL,'2024-09-10 20:59:09',19,44956,27716,NULL,NULL,'2024-09-10 14:04:22','2024-09-10 13:59:09','2024-09-10 14:04:22'),
(1003,2,'debit',NULL,4000000.0000,NULL,'2024-09-11 09:20:00',1,44633,27726,NULL,NULL,NULL,'2024-09-11 02:20:44','2024-09-11 02:20:44'),
(1004,2,'debit',NULL,225000.0000,NULL,'2024-09-11 09:21:00',1,44543,27727,NULL,NULL,NULL,'2024-09-11 02:21:42','2024-09-11 02:21:42'),
(1005,2,'debit',NULL,71000.0000,NULL,'2024-09-11 09:22:00',1,44492,27728,NULL,NULL,NULL,'2024-09-11 02:22:48','2024-09-11 02:22:48'),
(1006,2,'debit',NULL,70000.0000,NULL,'2024-09-11 09:23:00',1,44553,27729,NULL,NULL,NULL,'2024-09-11 02:23:25','2024-09-11 02:23:25'),
(1007,2,'debit',NULL,113000.0000,NULL,'2024-09-11 09:25:00',1,44471,27730,NULL,NULL,NULL,'2024-09-11 02:25:42','2024-09-11 02:25:42'),
(1008,2,'debit',NULL,4100000.0000,NULL,'2024-09-11 09:33:00',1,44621,27731,NULL,NULL,NULL,'2024-09-11 02:33:44','2024-09-11 02:33:44'),
(1009,2,'debit',NULL,544000.0000,NULL,'2024-09-11 09:38:00',1,44891,27732,NULL,NULL,NULL,'2024-09-11 02:38:43','2024-09-11 02:38:43'),
(1010,2,'debit',NULL,55000.0000,NULL,'2024-09-11 09:39:00',1,44890,27733,NULL,NULL,NULL,'2024-09-11 02:39:42','2024-09-11 02:39:42'),
(1011,2,'debit',NULL,65000.0000,NULL,'2024-09-11 09:40:00',1,44391,27734,NULL,NULL,NULL,'2024-09-11 02:40:54','2024-09-11 02:40:54'),
(1012,2,'debit',NULL,13594000.0000,NULL,'2024-09-11 09:56:00',1,43922,27735,NULL,NULL,NULL,'2024-09-11 02:56:31','2024-09-11 02:56:31'),
(1013,2,'credit',NULL,50000.0000,NULL,'2024-09-11 10:04:04',19,44965,27736,NULL,NULL,NULL,'2024-09-11 03:04:04','2024-09-11 03:04:04'),
(1014,2,'credit',NULL,2893000.0000,NULL,'2024-09-11 11:05:00',19,44969,27741,NULL,NULL,NULL,'2024-09-11 04:05:42','2024-09-26 12:34:09'),
(1015,2,'credit',NULL,928000.0000,NULL,'2024-09-11 11:22:13',49,44728,27742,NULL,NULL,NULL,'2024-09-11 04:22:13','2024-09-11 04:22:13'),
(1016,2,'credit',NULL,25000.0000,NULL,'2024-09-11 14:57:12',106,44980,27749,NULL,NULL,NULL,'2024-09-11 07:57:12','2024-09-11 07:57:12'),
(1017,2,'credit',NULL,200000.0000,NULL,'2024-09-11 15:12:39',78,44736,27753,NULL,NULL,NULL,'2024-09-11 08:12:39','2024-09-11 08:22:43'),
(1018,2,'credit',NULL,755000.0000,NULL,'2024-09-11 15:14:11',78,44984,27754,NULL,NULL,NULL,'2024-09-11 08:14:11','2024-09-11 08:14:11'),
(1019,2,'credit',NULL,147000.0000,NULL,'2024-09-11 15:31:12',49,44985,27755,NULL,NULL,NULL,'2024-09-11 08:31:12','2024-09-11 08:31:12'),
(1020,2,'credit',NULL,147000.0000,NULL,'2024-09-11 15:31:13',49,44986,27756,NULL,NULL,'2024-09-11 08:36:09','2024-09-11 08:31:14','2024-09-11 08:36:09'),
(1021,2,'credit',NULL,350000.0000,NULL,'2024-09-11 16:50:49',49,44993,27767,NULL,NULL,NULL,'2024-09-11 09:50:49','2024-09-29 02:59:09'),
(1022,2,'credit',NULL,814500.0000,NULL,'2024-09-11 17:09:43',49,44993,27768,NULL,NULL,NULL,'2024-09-11 10:09:43','2024-09-29 02:59:09'),
(1023,2,'credit',NULL,200000.0000,NULL,'2024-09-11 18:38:40',6,45006,27771,NULL,NULL,NULL,'2024-09-11 11:38:40','2024-11-30 01:43:02'),
(1024,2,'credit',NULL,165000.0000,NULL,'2024-09-12 10:10:07',11,45022,27783,NULL,NULL,NULL,'2024-09-12 03:10:07','2024-09-12 03:10:07'),
(1025,2,'credit',NULL,120000.0000,NULL,'2024-09-12 10:14:56',11,44787,27784,NULL,NULL,NULL,'2024-09-12 03:14:56','2024-09-12 03:14:56'),
(1026,2,'credit',NULL,90000.0000,NULL,'2024-09-12 13:16:56',6,45046,27798,NULL,NULL,NULL,'2024-09-12 06:16:56','2024-09-12 06:16:56'),
(1027,2,'credit',NULL,390000.0000,NULL,'2024-09-12 13:52:32',6,45048,27800,NULL,NULL,NULL,'2024-09-12 06:52:32','2024-09-12 06:52:32'),
(1028,2,'credit',NULL,60000.0000,NULL,'2024-09-12 14:47:40',19,45051,27803,NULL,NULL,NULL,'2024-09-12 07:47:40','2024-09-12 07:47:40'),
(1029,2,'debit',NULL,315000.0000,NULL,'2024-09-13 08:32:00',1,43936,27826,NULL,NULL,NULL,'2024-09-13 01:32:40','2024-09-13 01:32:40'),
(1030,2,'debit',NULL,2051500.0000,NULL,'2024-09-13 08:33:00',1,43225,27827,NULL,NULL,NULL,'2024-09-13 01:33:13','2024-09-13 01:33:13'),
(1031,2,'debit',NULL,12528300.0000,NULL,'2024-09-13 08:58:00',1,42412,27832,NULL,NULL,NULL,'2024-09-13 01:58:03','2024-09-13 01:58:03'),
(1032,2,'debit',NULL,535000.0000,NULL,'2024-09-13 08:59:00',1,44153,27833,NULL,NULL,NULL,'2024-09-13 01:59:06','2024-09-13 01:59:06'),
(1033,2,'debit',NULL,3543600.0000,NULL,'2024-09-13 09:08:00',1,44675,27834,NULL,NULL,NULL,'2024-09-13 02:08:09','2024-09-13 02:08:09'),
(1034,2,'debit',NULL,1000501.0000,NULL,'2024-09-13 09:10:00',1,43790,27835,NULL,NULL,NULL,'2024-09-13 02:10:07','2024-09-13 02:10:07'),
(1035,2,'debit',NULL,215000.0000,NULL,'2024-09-13 09:10:00',1,43740,27836,NULL,NULL,NULL,'2024-09-13 02:10:44','2024-09-13 02:10:44'),
(1036,2,'debit',NULL,75900.0000,NULL,'2024-09-13 09:11:00',1,43492,27837,NULL,NULL,NULL,'2024-09-13 02:11:27','2024-09-13 02:11:27'),
(1037,2,'debit',NULL,250000.0000,NULL,'2024-09-13 09:12:00',1,43456,27838,NULL,NULL,NULL,'2024-09-13 02:12:11','2024-09-13 02:12:11'),
(1038,2,'debit',NULL,130000.0000,NULL,'2024-09-13 09:14:00',1,43383,27840,NULL,NULL,NULL,'2024-09-13 02:14:36','2024-09-13 02:14:36'),
(1039,2,'debit',NULL,4390000.0000,NULL,'2024-09-13 09:21:00',1,43305,27843,NULL,NULL,NULL,'2024-09-13 02:21:08','2024-09-13 02:21:08'),
(1040,2,'debit',NULL,58000.0000,NULL,'2024-09-13 09:22:00',1,43150,27844,NULL,NULL,NULL,'2024-09-13 02:22:42','2024-09-13 02:22:42'),
(1041,2,'debit',NULL,220000.0000,NULL,'2024-09-13 09:23:00',1,44058,27845,NULL,NULL,NULL,'2024-09-13 02:23:28','2024-09-13 02:23:28'),
(1042,2,'debit',NULL,21587500.0000,NULL,'2024-09-13 09:25:00',1,44246,27847,NULL,NULL,'2024-09-13 07:04:47','2024-09-13 02:25:39','2024-09-13 07:04:47'),
(1043,2,'debit',NULL,262000.0000,NULL,'2024-09-13 09:27:00',1,45066,27848,NULL,NULL,NULL,'2024-09-13 02:27:59','2024-09-13 02:27:59'),
(1044,2,'debit',NULL,2734000.0000,NULL,'2024-09-13 09:28:00',1,44972,27849,NULL,NULL,NULL,'2024-09-13 02:28:38','2024-09-13 02:28:38'),
(1045,2,'debit',NULL,352000.0000,NULL,'2024-09-13 09:28:00',1,44836,27850,NULL,NULL,NULL,'2024-09-13 02:28:55','2024-09-13 02:28:55'),
(1046,2,'debit',NULL,460000.0000,NULL,'2024-09-13 09:31:00',1,44704,27851,NULL,NULL,NULL,'2024-09-13 02:31:28','2024-09-13 02:31:28'),
(1047,2,'debit',NULL,738000.0000,NULL,'2024-09-13 09:32:00',1,44634,27852,NULL,NULL,NULL,'2024-09-13 02:32:20','2024-09-13 02:32:20'),
(1048,2,'debit',NULL,11025000.0000,NULL,'2024-09-13 09:33:00',1,44185,27853,NULL,NULL,NULL,'2024-09-13 02:33:59','2024-09-13 02:33:59'),
(1049,2,'credit',NULL,27845000.0000,NULL,'2024-09-13 14:19:03',6,45106,27862,NULL,NULL,NULL,'2024-09-13 07:19:03','2024-09-21 03:22:07'),
(1050,2,'credit',NULL,390000.0000,NULL,'2024-09-13 16:48:02',49,45114,27875,NULL,NULL,NULL,'2024-09-13 09:48:02','2024-09-13 09:48:02'),
(1051,2,'credit',NULL,105000.0000,NULL,'2024-09-13 17:01:16',6,45125,27877,NULL,NULL,NULL,'2024-09-13 10:01:16','2024-09-29 03:05:58'),
(1052,2,'debit',NULL,6246000.0000,NULL,'2024-09-13 20:07:00',1,44832,27896,NULL,NULL,NULL,'2024-09-13 13:07:48','2024-09-13 13:07:48'),
(1053,2,'debit',NULL,19355900.0000,NULL,'2024-09-13 20:38:00',1,44848,27899,NULL,NULL,NULL,'2024-09-13 13:38:09','2024-09-13 13:38:09'),
(1054,2,'debit',NULL,11853300.0000,NULL,'2024-09-13 20:48:00',1,44834,27900,NULL,NULL,NULL,'2024-09-13 13:48:16','2024-09-13 13:48:16'),
(1055,2,'credit',NULL,42000.0000,NULL,'2024-09-14 10:56:28',49,45159,27907,NULL,NULL,NULL,'2024-09-14 03:56:28','2024-09-14 03:56:28'),
(1056,2,'credit',NULL,100000.0000,NULL,'2024-09-14 13:01:13',93,45090,27913,NULL,NULL,NULL,'2024-09-14 06:01:13','2024-09-14 06:01:13'),
(1057,2,'credit',NULL,4844000.0000,NULL,'2024-09-14 15:36:13',11,45182,27926,NULL,NULL,NULL,'2024-09-14 08:36:13','2024-09-14 08:39:14'),
(1058,2,'credit',NULL,564000.0000,NULL,'2024-09-15 08:21:03',13,45221,27950,NULL,NULL,NULL,'2024-09-15 01:21:03','2024-09-15 01:21:03'),
(1059,2,'credit',NULL,160000.0000,NULL,'2024-09-15 08:21:30',13,45107,27951,NULL,NULL,NULL,'2024-09-15 01:21:30','2024-09-15 01:21:30'),
(1060,2,'credit',NULL,296500.0000,NULL,'2024-09-15 13:17:00',19,44513,27961,NULL,NULL,'2024-09-15 06:25:00','2024-09-15 06:24:17','2024-09-15 06:25:00'),
(1061,2,'credit',NULL,390000.0000,NULL,'2024-09-15 13:17:00',19,45067,27962,NULL,NULL,'2024-09-15 06:25:04','2024-09-15 06:24:37','2024-09-15 06:25:04'),
(1062,2,'credit',NULL,7209000.0000,NULL,'2024-09-15 18:57:48',49,44442,27979,NULL,NULL,NULL,'2024-09-15 11:57:48','2024-09-15 11:57:48'),
(1063,2,'credit',NULL,855000.0000,NULL,'2024-09-15 20:49:16',49,45261,27987,NULL,NULL,NULL,'2024-09-15 13:49:16','2024-09-15 13:49:16'),
(1064,2,'credit',NULL,610000.0000,NULL,'2024-09-17 09:31:58',6,45268,27994,NULL,NULL,NULL,'2024-09-17 02:31:58','2024-09-17 02:31:58'),
(1065,2,'credit',NULL,47000.0000,NULL,'2024-09-17 10:14:37',106,45273,27999,NULL,NULL,NULL,'2024-09-17 03:14:37','2024-09-17 03:14:37'),
(1066,2,'credit',NULL,200000.0000,NULL,'2024-09-17 16:48:17',106,45185,28035,NULL,NULL,NULL,'2024-09-17 09:48:17','2024-09-17 09:48:17'),
(1067,2,'credit',NULL,579000.0000,NULL,'2024-09-17 16:48:46',106,45323,28036,NULL,NULL,NULL,'2024-09-17 09:48:46','2024-09-17 09:48:46'),
(1068,2,'credit',NULL,245000.0000,NULL,'2024-09-17 20:42:02',49,45339,28047,NULL,NULL,NULL,'2024-09-17 13:42:02','2024-09-17 13:42:02'),
(1069,2,'debit',NULL,135000.0000,NULL,'2024-09-18 13:58:00',1,45326,28076,NULL,NULL,NULL,'2024-09-18 06:58:05','2024-09-18 06:58:05'),
(1070,2,'credit',NULL,1257600.0000,NULL,'2024-09-18 14:06:05',5,45376,28077,NULL,NULL,NULL,'2024-09-18 07:06:05','2024-09-18 07:06:05'),
(1071,2,'credit',NULL,10439000.0000,NULL,'2024-09-18 19:18:39',93,45410,28093,NULL,NULL,NULL,'2024-09-18 12:18:39','2024-09-18 12:18:39'),
(1072,2,'debit',NULL,775000.0000,NULL,'2024-09-19 13:44:00',3,45448,28126,NULL,NULL,NULL,'2024-09-19 06:45:48','2024-09-19 06:45:48'),
(1073,2,'credit',NULL,855000.0000,NULL,'2024-09-19 13:46:46',6,45449,28127,NULL,NULL,NULL,'2024-09-19 06:46:46','2024-09-19 06:46:46'),
(1074,2,'credit',NULL,895000.0000,NULL,'2024-09-19 13:48:44',6,45451,28129,NULL,NULL,NULL,'2024-09-19 06:48:44','2024-09-19 06:48:44'),
(1075,2,'credit',NULL,100.0000,NULL,'2024-09-19 17:17:16',49,44877,28145,NULL,NULL,NULL,'2024-09-19 10:17:38','2024-09-19 10:17:38'),
(1076,2,'credit',NULL,275000.0000,NULL,'2024-09-19 17:17:53',49,45464,28146,NULL,NULL,NULL,'2024-09-19 10:17:53','2024-09-19 10:17:53'),
(1077,2,'credit',NULL,200000.0000,NULL,'2024-09-20 09:18:21',106,44240,28164,NULL,NULL,NULL,'2024-09-20 02:18:21','2024-09-20 02:18:21'),
(1078,2,'credit',NULL,195000.0000,NULL,'2024-09-20 09:19:16',106,45489,28165,NULL,NULL,NULL,'2024-09-20 02:19:16','2024-09-20 02:19:16'),
(1079,2,'credit',NULL,102000.0000,NULL,'2024-09-20 09:19:25',3,45490,28166,NULL,NULL,NULL,'2024-09-20 02:19:25','2024-09-20 02:19:25'),
(1080,2,'credit',NULL,180000.0000,NULL,'2024-09-20 10:21:03',3,45495,28170,NULL,NULL,NULL,'2024-09-20 03:21:03','2024-09-20 03:21:03'),
(1081,2,'debit',NULL,6682500.0000,NULL,'2024-09-20 14:36:00',1,45400,28185,NULL,NULL,NULL,'2024-09-20 07:36:43','2024-09-20 07:36:43'),
(1082,2,'debit',NULL,6120000.0000,NULL,'2024-09-20 14:40:00',1,45399,28186,NULL,NULL,NULL,'2024-09-20 07:40:56','2024-09-20 07:40:56'),
(1083,2,'credit',NULL,673000.0000,NULL,'2024-09-20 14:57:19',3,39613,28187,NULL,NULL,NULL,'2024-09-20 07:57:19','2025-02-04 11:44:45'),
(1084,2,'credit',NULL,151000.0000,NULL,'2024-09-20 19:04:49',5,45516,28204,NULL,NULL,NULL,'2024-09-20 12:04:49','2024-09-29 02:56:12'),
(1085,2,'credit',NULL,8060000.0000,NULL,'2024-09-21 10:15:21',6,45106,28216,NULL,NULL,NULL,'2024-09-21 03:15:21','2024-09-21 03:22:07'),
(1086,2,'debit',NULL,330000.0000,NULL,'2024-09-22 08:30:00',1,44341,28251,NULL,NULL,NULL,'2024-09-22 01:30:42','2024-09-22 01:30:42'),
(1087,2,'debit',NULL,196100.0000,NULL,'2024-09-22 08:32:00',1,43690,28252,NULL,NULL,NULL,'2024-09-22 01:32:39','2024-09-22 01:32:39'),
(1088,2,'debit',NULL,609900.0000,NULL,'2024-09-22 08:33:00',1,45180,28253,NULL,NULL,NULL,'2024-09-22 01:33:12','2024-09-22 01:33:12'),
(1089,2,'debit',NULL,2900000.0000,NULL,'2024-09-22 08:33:00',1,44280,28254,NULL,NULL,NULL,'2024-09-22 01:33:59','2024-09-22 01:33:59'),
(1090,2,'debit',NULL,500000.0000,NULL,'2024-09-22 08:34:00',1,45514,28255,NULL,NULL,NULL,'2024-09-22 01:34:35','2024-09-22 01:34:35'),
(1091,2,'debit',NULL,48797700.0000,NULL,'2024-09-22 08:35:00',1,45391,28256,NULL,NULL,NULL,'2024-09-22 01:35:15','2024-09-22 01:35:15'),
(1092,2,'debit',NULL,110000.0000,NULL,'2024-09-22 08:37:00',1,45204,28257,NULL,NULL,NULL,'2024-09-22 01:37:29','2024-09-22 01:37:29'),
(1093,2,'debit',NULL,6936000.0000,NULL,'2024-09-22 08:38:00',1,45121,28258,NULL,NULL,NULL,'2024-09-22 01:38:05','2024-09-22 01:38:05'),
(1094,2,'debit',NULL,3840000.0000,NULL,'2024-09-22 08:47:00',1,45208,28259,NULL,NULL,NULL,'2024-09-22 01:47:18','2024-09-22 01:47:18'),
(1095,2,'credit',NULL,2000000.0000,NULL,'2024-09-22 18:30:25',49,45638,28283,NULL,NULL,NULL,'2024-09-22 11:30:25','2024-09-30 04:33:58'),
(1096,2,'credit',NULL,5569000.0000,NULL,'2024-09-22 19:23:41',6,45646,28290,NULL,NULL,NULL,'2024-09-22 12:23:41','2024-09-22 12:23:41'),
(1097,2,'credit',NULL,3412000.0000,NULL,'2024-09-23 16:04:09',3,45656,28336,NULL,NULL,NULL,'2024-09-23 09:04:09','2024-09-29 03:25:31'),
(1098,2,'credit',NULL,1745000.0000,NULL,'2024-09-23 17:30:15',49,45701,28342,NULL,NULL,NULL,'2024-09-23 10:30:15','2024-09-23 10:30:15'),
(1099,2,'credit',NULL,200000.0000,NULL,'2024-09-23 19:03:17',49,45706,28347,NULL,NULL,NULL,'2024-09-23 12:03:17','2024-09-23 14:51:09'),
(1100,2,'credit',NULL,251000.0000,NULL,'2024-09-23 21:50:52',49,45749,28362,NULL,NULL,NULL,'2024-09-23 14:50:52','2024-09-23 14:50:52'),
(1101,2,'credit',NULL,495000.0000,NULL,'2024-09-24 08:50:37',106,45754,28365,NULL,NULL,NULL,'2024-09-24 01:50:37','2024-09-24 01:50:37'),
(1102,2,'credit',NULL,330000.0000,NULL,'2024-09-24 17:47:39',93,45808,28401,NULL,NULL,NULL,'2024-09-24 10:47:39','2024-09-24 10:47:39'),
(1103,2,'credit',NULL,6763000.0000,NULL,'2024-09-24 20:05:04',93,45636,28406,NULL,NULL,NULL,'2024-09-24 13:05:04','2025-09-28 14:59:23'),
(1104,2,'credit',NULL,950000.0000,NULL,'2024-09-25 11:37:36',19,45848,28420,NULL,NULL,NULL,'2024-09-25 04:37:36','2024-09-25 06:08:35'),
(1105,2,'credit',NULL,150000.0000,NULL,'2024-09-25 12:59:57',19,45854,28428,NULL,NULL,NULL,'2024-09-25 05:59:57','2024-09-25 06:08:19'),
(1106,2,'debit',NULL,2010000.0000,NULL,'2024-09-25 13:36:00',1,45681,28430,NULL,NULL,NULL,'2024-09-25 06:37:01','2024-09-25 06:37:01'),
(1107,2,'credit',NULL,4935000.0000,NULL,'2024-09-25 19:56:10',3,45561,28461,NULL,NULL,NULL,'2024-09-25 12:56:10','2024-09-29 03:42:38'),
(1108,2,'credit',NULL,380000.0000,NULL,'2024-09-26 14:45:39',3,45561,28487,NULL,NULL,NULL,'2024-09-26 07:45:39','2024-09-29 03:42:38'),
(1109,2,'credit',NULL,662500.0000,NULL,'2024-09-26 19:21:06',6,45966,28507,NULL,NULL,NULL,'2024-09-26 12:21:06','2024-09-26 12:21:06'),
(1110,2,'credit',NULL,662500.0000,NULL,'2024-09-26 19:21:45',6,45967,28508,NULL,NULL,NULL,'2024-09-26 12:21:45','2024-09-26 12:21:45'),
(1111,2,'credit',NULL,200000.0000,NULL,'2024-09-26 19:26:43',6,45968,28510,NULL,NULL,NULL,'2024-09-26 12:26:43','2024-09-26 12:26:43'),
(1112,2,'credit',NULL,200000.0000,NULL,'2024-09-26 19:27:51',6,45970,28512,NULL,NULL,NULL,'2024-09-26 12:27:51','2024-09-26 12:27:51'),
(1113,2,'credit',NULL,300000.0000,NULL,'2024-09-26 19:31:09',6,45971,28513,NULL,NULL,NULL,'2024-09-26 12:31:09','2024-09-26 12:31:09'),
(1114,2,'credit',NULL,300000.0000,NULL,'2024-09-26 19:31:35',6,45972,28514,NULL,NULL,NULL,'2024-09-26 12:31:35','2024-09-26 12:31:35'),
(1115,2,'credit',NULL,0.0000,NULL,'2024-09-26 20:38:42',49,45941,28524,NULL,NULL,NULL,'2024-09-26 13:38:42','2024-12-31 05:39:51'),
(1116,2,'debit',NULL,260000.0000,NULL,'2024-09-26 21:12:00',1,45979,28525,NULL,NULL,NULL,'2024-09-26 14:12:34','2024-09-26 14:12:34'),
(1117,2,'debit',NULL,21588000.0000,NULL,'2024-09-27 13:02:00',1,44246,28541,NULL,NULL,NULL,'2024-09-27 06:02:16','2024-09-27 06:02:16'),
(1118,2,'debit',NULL,18867800.0000,NULL,'2024-09-27 15:14:00',1,45936,28550,NULL,NULL,NULL,'2024-09-27 08:14:48','2024-09-27 08:14:48'),
(1119,2,'debit',NULL,18968400.0000,NULL,'2024-09-27 15:15:00',1,43523,28551,NULL,NULL,NULL,'2024-09-27 08:15:04','2024-09-27 08:15:04'),
(1120,2,'credit',NULL,60000.0000,NULL,'2024-09-27 15:15:26',6,46008,28552,NULL,NULL,NULL,'2024-09-27 08:15:26','2024-09-27 08:15:26'),
(1121,2,'credit',NULL,370000.0000,NULL,'2024-09-27 15:24:12',93,46010,28553,NULL,NULL,NULL,'2024-09-27 08:24:12','2024-09-27 08:24:12'),
(1122,2,'credit',NULL,612000.0000,NULL,'2024-09-27 16:50:11',5,46020,28556,NULL,NULL,NULL,'2024-09-27 09:50:11','2024-09-27 09:50:11'),
(1123,2,'credit',NULL,360000.0000,NULL,'2024-09-27 17:51:41',93,46025,28561,NULL,NULL,NULL,'2024-09-27 10:51:41','2024-09-27 10:51:41'),
(1124,2,'credit',NULL,80000.0000,NULL,'2024-09-27 17:53:34',93,45815,28562,NULL,NULL,NULL,'2024-09-27 10:53:34','2024-09-27 10:53:34'),
(1125,2,'credit',NULL,180000.0000,NULL,'2024-09-27 18:36:59',93,45073,28564,NULL,NULL,NULL,'2024-09-27 11:36:59','2024-09-27 11:36:59'),
(1126,2,'credit',NULL,90000.0000,NULL,'2024-09-27 18:37:27',93,46029,28565,NULL,NULL,NULL,'2024-09-27 11:37:27','2024-09-27 11:37:27'),
(1127,2,'credit',NULL,200000.0000,NULL,'2024-09-27 20:38:18',93,45860,28574,NULL,NULL,NULL,'2024-09-27 13:38:18','2024-09-27 13:38:18'),
(1128,2,'credit',NULL,265000.0000,NULL,'2024-09-28 10:30:03',13,46052,28584,NULL,NULL,NULL,'2024-09-28 03:30:03','2024-09-28 03:30:03'),
(1129,2,'credit',NULL,85000.0000,NULL,'2024-09-28 12:44:01',106,46060,28593,NULL,NULL,NULL,'2024-09-28 05:44:01','2024-09-28 05:44:01'),
(1130,2,'credit',NULL,345000.0000,NULL,'2024-09-28 15:37:34',6,46077,28604,NULL,NULL,NULL,'2024-09-28 08:37:34','2024-09-28 08:37:34'),
(1131,2,'credit',NULL,200000.0000,NULL,'2024-09-28 15:37:47',6,45898,28605,NULL,NULL,NULL,'2024-09-28 08:37:47','2024-09-28 08:37:47'),
(1132,2,'credit',NULL,200000.0000,NULL,'2024-09-28 16:24:45',106,45889,28609,NULL,NULL,NULL,'2024-09-28 09:24:45','2024-09-28 09:24:45'),
(1133,2,'credit',NULL,569000.0000,NULL,'2024-09-28 16:25:24',106,46082,28610,NULL,NULL,NULL,'2024-09-28 09:25:24','2024-09-28 09:25:24'),
(1134,2,'credit',NULL,1762000.0000,NULL,'2024-09-28 18:06:14',5,45277,28611,NULL,NULL,NULL,'2024-09-28 11:06:14','2024-09-28 11:06:14'),
(1135,2,'credit',NULL,439000.0000,NULL,'2024-09-28 19:59:06',6,46098,28615,NULL,NULL,NULL,'2024-09-28 12:59:06','2024-09-28 12:59:06'),
(1136,2,'credit',NULL,1325000.0000,NULL,'2024-09-28 21:17:54',6,46109,28624,NULL,NULL,NULL,'2024-09-28 14:17:54','2024-09-28 14:17:54'),
(1137,2,'credit',NULL,100000.0000,NULL,'2024-09-29 08:23:35',49,46056,28627,NULL,NULL,NULL,'2024-09-29 01:23:35','2024-09-29 09:10:21'),
(1138,2,'credit',NULL,3700000.0000,NULL,'2024-09-29 09:18:43',6,46112,28633,NULL,NULL,NULL,'2024-09-29 02:18:43','2024-10-01 06:14:00'),
(1139,2,'credit',NULL,20000.0000,NULL,'2024-09-29 09:56:04',3,46126,28637,NULL,NULL,NULL,'2024-09-29 02:56:04','2024-09-29 02:56:04'),
(1140,2,'credit',NULL,20000.0000,NULL,'2024-09-29 09:56:09',3,46127,28638,NULL,NULL,NULL,'2024-09-29 02:56:09','2024-09-29 02:56:09'),
(1141,2,'credit',NULL,75000.0000,NULL,'2024-09-29 09:58:42',3,46128,28639,NULL,NULL,NULL,'2024-09-29 02:58:42','2024-09-29 02:58:42'),
(1142,2,'credit',NULL,75000.0000,NULL,'2024-09-29 09:59:05',3,46129,28640,NULL,NULL,NULL,'2024-09-29 02:59:05','2024-09-29 02:59:05'),
(1143,2,'credit',NULL,75000.0000,NULL,'2024-09-29 10:02:32',3,46134,28646,NULL,NULL,NULL,'2024-09-29 03:02:32','2024-09-29 03:02:32'),
(1144,2,'credit',NULL,75000.0000,NULL,'2024-09-29 10:02:45',3,46135,28647,NULL,NULL,NULL,'2024-09-29 03:02:45','2024-09-29 03:02:45'),
(1145,2,'credit',NULL,60000.0000,NULL,'2024-09-29 10:05:03',6,46137,28651,NULL,NULL,NULL,'2024-09-29 03:05:03','2024-09-29 03:05:03'),
(1146,2,'credit',NULL,60000.0000,NULL,'2024-09-29 10:05:36',6,46138,28652,NULL,NULL,NULL,'2024-09-29 03:05:36','2024-09-29 03:05:36'),
(1147,2,'credit',NULL,75000.0000,NULL,'2024-09-29 10:08:08',3,46139,28654,NULL,NULL,NULL,'2024-09-29 03:08:08','2024-09-29 03:08:08'),
(1148,2,'credit',NULL,342500.0000,NULL,'2024-09-29 10:25:52',3,46143,28660,NULL,NULL,NULL,'2024-09-29 03:25:52','2024-09-29 03:25:52'),
(1149,2,'credit',NULL,100000.0000,NULL,'2024-09-29 10:34:09',3,46144,28662,NULL,NULL,NULL,'2024-09-29 03:34:09','2024-09-29 03:34:09'),
(1150,2,'credit',NULL,100000.0000,NULL,'2024-09-29 10:34:15',3,46145,28663,NULL,NULL,NULL,'2024-09-29 03:34:15','2024-09-29 03:34:15'),
(1151,2,'credit',NULL,550000.0000,NULL,'2024-09-29 10:42:43',3,46149,28665,NULL,NULL,NULL,'2024-09-29 03:42:43','2024-09-29 03:42:43'),
(1152,2,'credit',NULL,135000.0000,NULL,'2024-09-29 11:45:02',6,46154,28668,NULL,NULL,NULL,'2024-09-29 04:45:02','2024-09-29 04:45:02'),
(1153,2,'credit',NULL,135000.0000,NULL,'2024-09-29 11:45:51',6,46155,28669,NULL,NULL,NULL,'2024-09-29 04:45:51','2024-09-29 04:45:51'),
(1154,2,'credit',NULL,5000000.0000,NULL,'2024-09-29 11:48:32',49,46120,28672,NULL,NULL,NULL,'2024-09-29 04:48:32','2024-11-01 12:17:14'),
(1155,2,'credit',NULL,510000.0000,NULL,'2024-09-29 13:08:10',10,46164,28676,NULL,NULL,NULL,'2024-09-29 06:08:10','2024-09-29 06:08:10'),
(1156,2,'credit',NULL,335000.0000,NULL,'2024-09-29 13:40:04',5,45868,28677,NULL,NULL,NULL,'2024-09-29 06:40:04','2024-09-29 06:40:04'),
(1157,2,'credit',NULL,70000.0000,NULL,'2024-09-29 13:40:41',5,45777,28678,NULL,NULL,NULL,'2024-09-29 06:40:41','2024-09-29 06:40:41'),
(1158,2,'credit',NULL,105000.0000,NULL,'2024-09-29 09:04:00',13,46121,28632,NULL,NULL,NULL,'2024-09-29 06:54:43','2024-09-29 06:54:43'),
(1159,2,'credit',NULL,215000.0000,NULL,'2024-09-29 16:11:32',49,46179,28687,NULL,NULL,NULL,'2024-09-29 09:11:32','2024-09-29 09:11:32'),
(1160,2,'credit',NULL,190000.0000,NULL,'2024-09-29 16:36:54',6,45598,28690,NULL,NULL,NULL,'2024-09-29 09:36:54','2024-09-29 09:36:54'),
(1161,2,'credit',NULL,510000.0000,NULL,'2024-09-29 16:38:42',6,46184,28691,NULL,NULL,NULL,'2024-09-29 09:38:42','2024-09-29 09:38:42'),
(1162,2,'credit',NULL,2000000.0000,NULL,'2024-09-29 17:33:48',13,46178,28696,NULL,NULL,NULL,'2024-09-29 10:33:48','2024-09-29 10:33:48'),
(1163,2,'credit',NULL,175000.0000,NULL,'2024-09-29 17:40:13',13,46188,28698,NULL,NULL,NULL,'2024-09-29 10:40:13','2024-09-29 10:40:13'),
(1164,2,'credit',NULL,120000.0000,NULL,'2024-09-29 19:02:55',19,45703,28702,NULL,NULL,NULL,'2024-09-29 12:02:55','2024-09-29 12:04:48'),
(1165,2,'credit',NULL,315000.0000,NULL,'2024-09-29 19:06:52',19,46193,28703,NULL,NULL,NULL,'2024-09-29 12:06:52','2024-09-29 12:06:52'),
(1166,2,'credit',NULL,415000.0000,NULL,'2024-09-29 20:57:03',19,46200,28707,NULL,NULL,NULL,'2024-09-29 13:57:03','2024-09-29 13:57:03'),
(1167,2,'credit',NULL,80000.0000,NULL,'2024-09-29 20:58:51',19,46201,28708,NULL,NULL,NULL,'2024-09-29 13:58:51','2024-09-29 13:58:51'),
(1168,2,'credit',NULL,740000.0000,NULL,'2024-09-30 09:12:22',49,46207,28730,NULL,NULL,NULL,'2024-09-30 02:12:22','2024-09-30 02:12:22'),
(1169,2,'credit',NULL,2350000.0000,NULL,'2024-09-30 11:33:58',49,45638,28741,NULL,NULL,NULL,'2024-09-30 04:33:58','2024-09-30 04:33:58'),
(1170,2,'credit',NULL,948000.0000,NULL,'2024-09-30 11:37:15',3,46221,28744,NULL,NULL,NULL,'2024-09-30 04:37:15','2024-09-30 04:37:15'),
(1171,2,'credit',NULL,680000.0000,NULL,'2024-09-30 11:37:14',10,46220,28743,NULL,NULL,NULL,'2024-09-30 04:38:00','2024-09-30 04:38:00'),
(1172,2,'credit',NULL,181000.0000,NULL,'2024-09-30 12:06:14',6,46223,28746,NULL,NULL,NULL,'2024-09-30 05:06:15','2024-09-30 05:06:15'),
(1173,2,'credit',NULL,273000.0000,NULL,'2024-09-30 12:56:31',6,46235,28755,NULL,NULL,NULL,'2024-09-30 05:56:31','2024-09-30 05:56:31'),
(1174,2,'credit',NULL,97000.0000,NULL,'2024-09-30 14:08:11',19,46255,28765,NULL,NULL,NULL,'2024-09-30 07:08:11','2024-09-30 07:08:11'),
(1175,2,'credit',NULL,420000.0000,NULL,'2024-09-30 14:33:52',5,46254,28767,NULL,NULL,NULL,'2024-09-30 07:33:52','2024-09-30 07:37:46'),
(1176,2,'credit',NULL,80000.0000,NULL,'2024-09-30 17:48:50',5,46258,28778,NULL,NULL,NULL,'2024-09-30 10:49:02','2024-09-30 10:49:02'),
(1177,2,'credit',NULL,29000.0000,NULL,'2024-09-30 17:57:15',5,44339,28779,NULL,NULL,NULL,'2024-09-30 10:57:15','2024-09-30 10:57:15'),
(1178,2,'debit',NULL,633500.0000,NULL,'2024-09-30 18:34:00',1,46204,28782,NULL,NULL,NULL,'2024-09-30 11:34:53','2024-09-30 11:34:53'),
(1179,2,'debit',NULL,8826000.0000,NULL,'2024-09-30 18:36:00',1,45879,28783,NULL,NULL,NULL,'2024-09-30 11:36:07','2024-09-30 11:36:07'),
(1180,2,'debit',NULL,520000.0000,NULL,'2024-09-30 18:38:00',1,46241,28784,NULL,NULL,NULL,'2024-09-30 11:38:24','2024-09-30 11:38:24'),
(1181,2,'debit',NULL,2445300.0000,NULL,'2024-09-30 18:47:00',1,45692,28785,NULL,NULL,NULL,'2024-09-30 11:47:33','2024-09-30 11:47:33'),
(1182,2,'debit',NULL,2445300.0000,NULL,'2024-09-30 18:47:00',1,45583,28786,NULL,NULL,NULL,'2024-09-30 11:47:44','2024-09-30 11:47:44'),
(1183,2,'debit',NULL,1990000.0000,NULL,'2024-09-30 18:53:00',1,45923,28788,NULL,NULL,NULL,'2024-09-30 11:53:16','2024-09-30 11:53:16'),
(1184,2,'debit',NULL,780000.0000,NULL,'2024-09-30 18:57:00',1,46240,28789,NULL,NULL,NULL,'2024-09-30 11:57:34','2024-09-30 11:57:34'),
(1185,2,'debit',NULL,570000.0000,NULL,'2024-09-30 19:06:00',1,46103,28790,NULL,NULL,NULL,'2024-09-30 12:06:16','2024-09-30 12:06:16'),
(1186,2,'credit',NULL,390000.0000,NULL,'2024-09-30 19:16:34',19,46283,28791,NULL,NULL,NULL,'2024-09-30 12:16:34','2024-09-30 12:16:34'),
(1187,2,'debit',NULL,2022700.0000,NULL,'2024-09-30 19:22:00',1,45863,28792,NULL,NULL,NULL,'2024-09-30 12:22:04','2024-09-30 12:22:04'),
(1188,2,'debit',NULL,425000.0000,NULL,'2024-09-30 19:22:00',1,46218,28793,NULL,NULL,NULL,'2024-09-30 12:22:30','2024-09-30 12:22:30'),
(1189,2,'debit',NULL,492500.0000,NULL,'2024-09-30 19:23:00',1,45556,28795,NULL,NULL,NULL,'2024-09-30 12:23:10','2024-09-30 12:23:10'),
(1190,2,'debit',NULL,8767550.0000,NULL,'2024-09-30 19:25:00',1,45647,28796,NULL,NULL,NULL,'2024-09-30 12:25:59','2024-09-30 12:25:59'),
(1191,2,'credit',NULL,69000.0000,NULL,'2024-09-30 19:42:41',5,46290,28800,NULL,NULL,NULL,'2024-09-30 12:42:41','2024-09-30 12:42:41'),
(1192,2,'credit',NULL,176000.0000,NULL,'2024-09-30 20:05:44',106,46295,28804,NULL,NULL,NULL,'2024-09-30 14:33:08','2024-09-30 14:33:08'),
(1193,2,'credit',NULL,195000.0000,NULL,'2024-10-01 08:16:28',6,46308,28813,NULL,NULL,NULL,'2024-10-01 01:16:28','2024-10-01 01:16:28'),
(1194,2,'credit',NULL,410000.0000,NULL,'2024-10-01 08:19:36',6,46084,28814,NULL,NULL,NULL,'2024-10-01 01:19:36','2024-10-01 01:19:36'),
(1195,2,'credit',NULL,640000.0000,NULL,'2024-10-01 08:20:24',6,46309,28815,NULL,NULL,NULL,'2024-10-01 01:20:24','2024-10-01 01:20:24'),
(1196,2,'credit',NULL,150000.0000,NULL,'2024-10-01 10:19:21',6,46322,28830,NULL,NULL,NULL,'2024-10-01 03:19:21','2024-10-01 03:19:21'),
(1197,2,'credit',NULL,310000.0000,NULL,'2024-10-01 10:23:42',6,46323,28831,NULL,NULL,NULL,'2024-10-01 03:23:42','2024-10-01 03:23:42'),
(1198,2,'debit',NULL,476000.0000,NULL,'2024-10-01 16:15:00',3,46366,28864,NULL,NULL,NULL,'2024-10-01 09:23:14','2024-10-01 09:23:14'),
(1199,2,'credit',NULL,185000.0000,NULL,'2024-10-01 20:07:00',19,46393,28887,NULL,NULL,NULL,'2024-10-01 13:07:02','2024-10-01 13:09:05'),
(1200,2,'credit',NULL,93000.0000,NULL,'2024-10-01 20:08:26',19,46394,28888,NULL,NULL,NULL,'2024-10-01 13:08:26','2024-10-01 13:08:26'),
(1201,2,'credit',NULL,92000.0000,NULL,'2024-10-02 09:46:26',49,46370,28900,NULL,NULL,NULL,'2024-10-02 02:46:26','2024-11-01 10:00:44'),
(1202,2,'credit',NULL,423000.0000,NULL,'2024-10-02 15:16:18',93,46454,28933,NULL,NULL,NULL,'2024-10-02 08:16:18','2024-10-02 08:16:18'),
(1203,2,'credit',NULL,190000.0000,NULL,'2024-10-02 15:19:57',13,46448,28934,NULL,NULL,NULL,'2024-10-02 08:19:57','2024-11-01 08:38:28'),
(1204,2,'credit',NULL,100000.0000,NULL,'2024-10-02 17:58:11',5,46463,28938,NULL,NULL,NULL,'2024-10-02 10:58:11','2024-10-02 10:58:11'),
(1205,2,'credit',NULL,200000.0000,NULL,'2024-10-02 18:21:58',13,46420,28939,NULL,NULL,NULL,'2024-10-02 11:21:58','2024-10-08 12:21:17'),
(1206,2,'credit',NULL,200000.0000,NULL,'2024-10-03 11:37:38',49,46442,28963,NULL,NULL,NULL,'2024-10-03 04:37:38','2024-10-05 09:31:56'),
(1207,2,'credit',NULL,268000.0000,NULL,'2024-10-03 13:35:23',19,46508,28984,NULL,NULL,NULL,'2024-10-03 06:35:23','2024-10-03 10:51:37'),
(1208,2,'credit',NULL,498000.0000,NULL,'2024-10-03 15:17:56',5,46513,28988,NULL,NULL,NULL,'2024-10-03 08:17:56','2024-10-05 11:50:13'),
(1209,2,'credit',NULL,95000.0000,NULL,'2024-10-03 15:18:45',5,45316,28989,NULL,NULL,NULL,'2024-10-03 08:18:45','2024-10-03 08:18:45'),
(1210,2,'credit',NULL,1437450.0000,NULL,'2024-10-03 16:40:48',3,39372,28991,NULL,NULL,NULL,'2024-10-03 09:40:48','2024-10-24 06:28:09'),
(1211,2,'credit',NULL,136500.0000,NULL,'2024-10-03 19:32:43',19,46529,29003,NULL,NULL,NULL,'2024-10-03 12:32:43','2024-10-03 12:32:43'),
(1212,2,'credit',NULL,3700000.0000,NULL,'2024-10-04 15:14:56',6,46575,29035,NULL,NULL,NULL,'2024-10-04 08:14:56','2024-10-06 08:48:39'),
(1213,2,'credit',NULL,470000.0000,NULL,'2024-10-04 17:27:54',106,46238,29044,NULL,NULL,NULL,'2024-10-04 10:27:54','2024-10-04 10:27:54'),
(1214,2,'credit',NULL,340000.0000,NULL,'2024-10-04 17:28:25',106,46573,29045,NULL,NULL,NULL,'2024-10-04 10:28:25','2024-10-05 03:42:37'),
(1215,2,'credit',NULL,244000.0000,NULL,'2024-10-04 17:29:29',93,46593,29046,NULL,NULL,NULL,'2024-10-04 10:29:29','2024-10-05 09:26:56'),
(1216,2,'debit',NULL,34557200.0000,NULL,'2024-10-04 20:42:00',1,46473,29058,NULL,NULL,NULL,'2024-10-04 13:42:17','2024-10-04 13:42:17'),
(1217,2,'debit',NULL,1367000.0000,NULL,'2024-10-04 20:51:00',1,46445,29059,NULL,NULL,NULL,'2024-10-04 13:51:31','2024-10-04 13:51:31'),
(1218,2,'credit',NULL,4884000.0000,NULL,'2024-10-04 21:12:57',13,46613,29062,NULL,NULL,NULL,'2024-10-04 14:12:57','2024-10-04 14:12:57'),
(1219,2,'credit',NULL,1325000.0000,NULL,'2024-10-05 11:42:06',6,46642,29077,NULL,NULL,NULL,'2024-10-05 04:42:06','2024-10-05 09:20:59'),
(1220,2,'credit',NULL,50000.0000,NULL,'2024-10-05 12:49:21',49,46442,29082,NULL,NULL,NULL,'2024-10-05 05:49:21','2024-10-05 09:31:56'),
(1221,2,'credit',NULL,397000.0000,NULL,'2024-10-05 12:50:53',49,46652,29083,NULL,NULL,NULL,'2024-10-05 05:50:53','2024-10-05 05:50:53'),
(1222,2,'credit',NULL,195000.0000,NULL,'2024-10-05 16:14:25',6,46666,29106,NULL,NULL,NULL,'2024-10-05 09:14:25','2024-10-05 09:19:49'),
(1223,2,'credit',NULL,927000.0000,NULL,'2024-10-05 18:50:00',19,46680,29133,NULL,NULL,NULL,'2024-10-05 11:50:11','2024-10-27 02:42:12'),
(1224,2,'credit',NULL,195000.0000,NULL,'2024-10-06 09:13:22',5,46695,29143,NULL,NULL,NULL,'2024-10-06 02:13:22','2024-10-06 02:13:22'),
(1225,2,'credit',NULL,749000.0000,NULL,'2024-10-06 13:29:53',19,46709,29152,NULL,NULL,NULL,'2024-10-06 06:29:53','2024-10-06 06:29:53'),
(1226,2,'credit',NULL,3170000.0000,NULL,'2024-10-06 15:48:39',3,46575,29168,NULL,NULL,NULL,'2024-10-06 08:48:39','2024-10-06 08:48:39'),
(1227,2,'credit',NULL,3389000.0000,NULL,'2024-10-07 08:41:49',5,46499,29215,NULL,NULL,NULL,'2024-10-07 01:41:49','2024-10-08 08:56:28'),
(1228,2,'credit',NULL,94350.0000,NULL,'2024-10-07 11:08:21',5,46011,29233,NULL,NULL,NULL,'2024-10-07 04:08:21','2024-10-07 04:14:06'),
(1229,2,'credit',NULL,200000.0000,NULL,'2024-10-07 15:00:23',19,46798,29244,NULL,NULL,NULL,'2024-10-07 08:00:23','2024-10-07 14:33:46'),
(1230,2,'credit',NULL,239000.0000,NULL,'2024-10-07 15:26:14',3,46802,29248,NULL,NULL,NULL,'2024-10-07 08:26:14','2024-11-01 08:57:14'),
(1231,2,'credit',NULL,230000.0000,NULL,'2024-10-07 16:55:15',5,46517,29254,NULL,NULL,NULL,'2024-10-07 09:55:15','2024-10-24 06:52:07'),
(1232,2,'credit',NULL,230000.0000,NULL,'2024-10-08 08:51:38',13,46850,29291,NULL,NULL,NULL,'2024-10-08 01:51:38','2024-10-08 01:51:38'),
(1233,2,'credit',NULL,70000.0000,NULL,'2024-10-08 09:56:43',19,46856,29294,NULL,NULL,NULL,'2024-10-08 02:56:43','2024-10-08 02:56:43'),
(1234,2,'credit',NULL,500000.0000,NULL,'2024-10-08 12:25:00',19,46869,29306,NULL,NULL,NULL,'2024-10-08 05:25:10','2024-10-10 12:50:54'),
(1235,2,'debit',NULL,752000.0000,NULL,'2024-10-08 15:21:00',13,46885,29318,NULL,NULL,NULL,'2024-10-08 08:35:48','2024-10-08 08:35:48'),
(1236,2,'credit',NULL,3389000.0000,NULL,'2024-10-08 15:56:28',49,46499,29320,NULL,NULL,NULL,'2024-10-08 08:56:28','2024-10-08 08:56:28'),
(1237,2,'credit',NULL,200000.0000,NULL,'2024-10-08 19:44:08',49,46895,29340,NULL,NULL,NULL,'2024-10-08 12:44:08','2024-11-30 04:01:51'),
(1238,2,'debit',NULL,3606000.0000,NULL,'2024-10-09 13:11:00',1,46469,29368,NULL,NULL,NULL,'2024-10-09 06:11:53','2024-10-09 06:11:53'),
(1239,2,'debit',NULL,4663000.0000,NULL,'2024-10-09 13:29:00',1,46468,29370,NULL,NULL,NULL,'2024-10-09 06:29:59','2024-10-09 06:29:59'),
(1240,2,'debit',NULL,15482700.0000,NULL,'2024-10-09 13:52:00',1,45130,29374,NULL,NULL,NULL,'2024-10-09 06:53:00','2024-10-09 06:53:00'),
(1241,2,'debit',NULL,990500.0000,NULL,'2024-10-09 13:59:00',1,46310,29375,NULL,NULL,'2024-11-07 07:11:41','2024-10-09 06:59:24','2024-11-07 07:11:41'),
(1242,2,'debit',NULL,312056.0000,NULL,'2024-10-09 14:01:00',1,44712,29376,NULL,NULL,NULL,'2024-10-09 07:01:37','2024-10-09 07:01:37'),
(1243,2,'debit',NULL,6173363.0000,NULL,'2024-10-09 14:35:00',1,46547,29383,NULL,NULL,NULL,'2024-10-09 07:35:22','2024-10-09 07:35:22'),
(1244,2,'debit',NULL,7891200.0000,NULL,'2024-10-09 15:16:00',1,45160,29385,NULL,NULL,NULL,'2024-10-09 08:16:23','2024-10-09 08:16:23'),
(1245,2,'debit',NULL,390000.0000,NULL,'2024-10-09 15:26:00',1,46941,29387,NULL,NULL,NULL,'2024-10-09 08:26:58','2024-10-09 08:26:58'),
(1246,2,'credit',NULL,248000.0000,NULL,'2024-10-09 15:47:07',6,46966,29388,NULL,NULL,NULL,'2024-10-09 08:47:07','2024-10-09 08:47:07'),
(1247,2,'debit',NULL,91000.0000,NULL,'2024-10-09 15:49:00',1,46620,29389,NULL,NULL,NULL,'2024-10-09 08:49:57','2024-10-09 08:49:57'),
(1248,2,'debit',NULL,360000.0000,NULL,'2024-10-09 15:52:00',1,45787,29390,NULL,NULL,NULL,'2024-10-09 08:53:00','2024-10-09 08:53:00'),
(1249,2,'debit',NULL,466000.0000,NULL,'2024-10-09 16:24:00',1,46898,29394,NULL,NULL,NULL,'2024-10-09 09:24:38','2024-10-09 09:24:38'),
(1250,2,'debit',NULL,21870000.0000,NULL,'2024-10-09 16:25:00',1,45630,29395,NULL,NULL,NULL,'2024-10-09 09:25:34','2024-10-09 09:25:34'),
(1251,2,'credit',NULL,420000.0000,NULL,'2024-10-10 09:43:05',106,47011,29424,NULL,NULL,NULL,'2024-10-10 02:43:05','2024-10-11 02:44:14'),
(1252,2,'credit',NULL,690000.0000,NULL,'2024-10-10 12:48:38',19,47037,29439,NULL,NULL,NULL,'2024-10-10 05:48:38','2024-10-10 05:48:38'),
(1253,2,'debit',NULL,5090000.0000,NULL,'2024-10-10 13:53:00',1,46690,29448,NULL,NULL,NULL,'2024-10-10 06:53:46','2024-10-10 06:53:46'),
(1254,2,'credit',NULL,25052000.0000,NULL,'2024-10-10 14:43:53',3,47053,29451,NULL,NULL,NULL,'2024-10-10 07:43:53','2024-10-14 11:50:46'),
(1255,2,'debit',NULL,31340000.0000,NULL,'2024-10-10 16:37:00',1,45508,29460,NULL,NULL,NULL,'2024-10-10 09:37:10','2024-10-10 09:37:10'),
(1256,2,'debit',NULL,5050800.0000,NULL,'2024-10-10 16:45:00',1,46905,29461,NULL,NULL,NULL,'2024-10-10 09:45:18','2024-10-10 09:45:18'),
(1257,2,'debit',NULL,4650000.0000,NULL,'2024-10-10 16:58:00',1,46832,29463,NULL,NULL,NULL,'2024-10-10 09:58:33','2024-10-10 09:58:33'),
(1258,2,'credit',NULL,5435000.0000,NULL,'2024-10-10 19:40:41',6,46869,29471,NULL,NULL,NULL,'2024-10-10 12:40:41','2024-10-10 12:50:54'),
(1259,2,'credit',NULL,236000.0000,NULL,'2024-10-10 20:16:13',6,47082,29475,NULL,NULL,NULL,'2024-10-10 13:16:13','2024-10-10 13:16:13'),
(1260,2,'credit',NULL,200000.0000,NULL,'2024-10-10 20:40:36',93,47092,29476,NULL,NULL,NULL,'2024-10-10 13:42:33','2024-10-10 13:42:33'),
(1261,2,'credit',NULL,4330000.0000,NULL,'2024-10-10 21:04:03',6,47025,29477,NULL,NULL,NULL,'2024-10-10 14:04:03','2024-10-27 02:40:47'),
(1262,2,'credit',NULL,1805000.0000,NULL,'2024-10-10 21:23:25',6,47077,29482,NULL,NULL,NULL,'2024-10-10 14:23:25','2024-10-10 14:23:25'),
(1263,2,'debit',NULL,2251000.0000,NULL,'2024-10-10 21:46:00',3,47100,29486,NULL,NULL,NULL,'2024-10-10 15:01:01','2024-10-10 15:01:01'),
(1264,2,'credit',NULL,3000000.0000,NULL,'2024-10-10 15:59:21',3,47001,29454,NULL,NULL,NULL,'2024-10-10 15:01:48','2024-10-15 03:19:29'),
(1265,2,'credit',NULL,284000.0000,NULL,'2024-10-11 09:44:14',106,47011,29491,NULL,NULL,NULL,'2024-10-11 02:44:15','2024-10-11 02:44:15'),
(1266,2,'credit',NULL,90000.0000,NULL,'2024-10-11 10:18:16',13,47109,29503,NULL,NULL,NULL,'2024-10-11 03:18:16','2024-10-11 03:18:16'),
(1267,2,'credit',NULL,10484000.0000,NULL,'2024-10-11 11:38:34',106,47115,29510,NULL,NULL,NULL,'2024-10-11 05:00:52','2024-10-11 05:01:38'),
(1268,2,'credit',NULL,5569000.0000,NULL,'2024-10-11 16:52:43',6,47136,29523,NULL,NULL,NULL,'2024-10-11 09:52:43','2024-10-11 09:52:43'),
(1269,2,'credit',NULL,2176000.0000,NULL,'2024-10-12 08:18:43',93,47167,29542,NULL,NULL,NULL,'2024-10-12 01:18:43','2024-10-12 01:18:43'),
(1270,2,'credit',NULL,215000.0000,NULL,'2024-10-12 10:05:34',93,47174,29548,NULL,NULL,NULL,'2024-10-12 03:05:34','2024-10-12 03:05:34'),
(1271,2,'credit',NULL,400000.0000,NULL,'2024-10-12 12:24:32',93,47185,29558,NULL,NULL,NULL,'2024-10-12 05:24:32','2024-10-12 05:24:32'),
(1272,2,'debit',NULL,5989200.0000,NULL,'2024-10-12 12:30:00',1,46646,29559,NULL,NULL,NULL,'2024-10-12 05:30:45','2024-10-12 05:30:45'),
(1273,2,'debit',NULL,400000.0000,NULL,'2024-10-12 12:32:00',1,46784,29560,NULL,NULL,'2024-10-12 12:08:15','2024-10-12 05:32:20','2024-10-12 12:08:15'),
(1274,2,'credit',NULL,749000.0000,NULL,'2024-10-13 18:13:47',93,47281,29635,NULL,NULL,NULL,'2024-10-13 11:13:47','2024-10-13 11:13:47'),
(1275,2,'debit',NULL,775000.0000,NULL,'2024-10-14 09:31:00',6,47307,29655,NULL,NULL,NULL,'2024-10-14 02:32:34','2024-10-14 02:32:34'),
(1276,2,'credit',NULL,1178400.0000,NULL,'2024-10-14 10:15:38',106,47296,29661,NULL,NULL,NULL,'2024-10-14 03:15:38','2024-10-14 03:15:38'),
(1277,2,'credit',NULL,1780000.0000,NULL,'2024-10-14 10:21:56',6,47320,29662,NULL,NULL,NULL,'2024-10-14 03:21:56','2024-10-14 03:21:56'),
(1278,2,'credit',NULL,230000.0000,NULL,'2024-10-14 15:58:37',19,47360,29676,NULL,NULL,NULL,'2024-10-14 08:58:37','2024-10-14 08:58:37'),
(1279,2,'credit',NULL,150000.0000,NULL,'2024-10-14 16:10:45',13,47110,29678,NULL,NULL,NULL,'2024-10-14 09:10:45','2024-10-15 01:20:00'),
(1280,2,'credit',NULL,800000.0000,NULL,'2024-10-14 16:23:03',13,47365,29681,NULL,NULL,NULL,'2024-10-14 09:23:03','2024-10-14 09:23:03'),
(1281,2,'credit',NULL,12000000.0000,NULL,'2024-10-14 18:50:25',5,47053,29691,NULL,NULL,NULL,'2024-10-14 11:50:46','2024-10-14 11:50:46'),
(1282,2,'credit',NULL,860000.0000,NULL,'2024-10-15 12:02:56',93,47418,29719,NULL,NULL,NULL,'2024-10-15 05:02:56','2024-10-15 05:02:56'),
(1283,2,'credit',NULL,720000.0000,NULL,'2024-10-15 12:23:03',93,47421,29722,NULL,NULL,NULL,'2024-10-15 05:23:03','2024-10-15 05:23:03'),
(1284,2,'credit',NULL,150000.0000,NULL,'2024-10-15 13:09:44',3,47354,29727,NULL,NULL,NULL,'2024-10-15 06:09:44','2024-10-16 07:44:01'),
(1285,2,'debit',NULL,5604300.0000,NULL,'2024-10-15 13:47:00',1,47425,29730,NULL,NULL,NULL,'2024-10-15 06:47:59','2024-10-15 06:47:59'),
(1286,2,'credit',NULL,827000.0000,NULL,'2024-10-15 13:53:00',19,47404,29731,NULL,NULL,NULL,'2024-10-15 06:53:48','2024-10-15 06:53:48'),
(1287,2,'credit',NULL,170000.0000,NULL,'2024-10-15 16:30:41',106,47443,29744,NULL,NULL,NULL,'2024-10-15 09:34:46','2024-10-15 09:34:46'),
(1288,2,'credit',NULL,6815000.0000,NULL,'2024-10-15 19:47:59',49,47262,29763,NULL,NULL,NULL,'2024-10-15 12:47:59','2024-10-15 12:50:07'),
(1289,2,'credit',NULL,1227000.0000,NULL,'2024-10-15 19:49:14',19,47460,29764,NULL,NULL,NULL,'2024-10-15 12:49:14','2024-10-15 12:49:14'),
(1290,2,'credit',NULL,40000.0000,NULL,'2024-10-15 19:58:48',19,46989,29766,NULL,NULL,NULL,'2024-10-15 12:58:48','2024-10-15 12:58:48'),
(1291,2,'credit',NULL,86000.0000,NULL,'2024-10-15 20:46:24',49,47457,29771,NULL,NULL,NULL,'2024-10-15 13:46:24','2024-11-01 08:59:53'),
(1292,2,'debit',NULL,95000.0000,NULL,'2024-10-16 08:46:00',3,47473,29778,NULL,NULL,NULL,'2024-10-16 01:48:17','2024-10-16 01:48:17'),
(1293,2,'credit',NULL,108000.0000,NULL,'2024-10-16 08:53:43',3,47064,29779,NULL,NULL,NULL,'2024-10-16 01:53:43','2024-10-16 01:53:43'),
(1294,2,'credit',NULL,310000.0000,NULL,'2024-10-16 14:18:27',3,47507,29801,NULL,NULL,NULL,'2024-10-16 07:18:27','2024-10-16 07:18:27'),
(1295,2,'credit',NULL,375000.0000,NULL,'2024-10-16 15:12:54',19,47521,29809,NULL,NULL,NULL,'2024-10-16 08:12:54','2024-10-16 08:12:54'),
(1296,2,'credit',NULL,600000.0000,NULL,'2024-10-16 15:55:57',13,47527,29810,NULL,NULL,NULL,'2024-10-16 08:55:57','2024-10-16 08:55:57'),
(1297,2,'debit',NULL,95000.0000,NULL,'2024-10-16 16:44:00',3,47538,29813,NULL,NULL,NULL,'2024-10-16 09:47:03','2024-10-16 09:47:03'),
(1298,2,'credit',NULL,87000.0000,NULL,'2024-10-16 17:04:22',106,47539,29815,NULL,NULL,NULL,'2024-10-16 10:04:22','2024-10-16 10:04:22'),
(1299,2,'credit',NULL,648000.0000,NULL,'2024-10-16 17:25:43',5,47542,29818,NULL,NULL,NULL,'2024-10-16 10:25:43','2024-10-16 10:25:43'),
(1300,2,'credit',NULL,120000.0000,NULL,'2024-10-16 17:25:52',5,47474,29819,NULL,NULL,NULL,'2024-10-16 10:25:52','2024-10-16 10:25:52'),
(1301,2,'credit',NULL,2040000.0000,NULL,'2024-10-16 19:31:00',19,47518,29827,NULL,NULL,NULL,'2024-10-16 12:31:18','2024-10-27 02:51:01'),
(1302,2,'credit',NULL,199000.0000,NULL,'2024-10-16 20:50:52',13,47554,29832,NULL,NULL,NULL,'2024-10-16 13:51:29','2024-10-16 13:51:29'),
(1303,2,'credit',NULL,10000000.0000,NULL,'2024-10-17 08:37:47',3,46996,29841,NULL,NULL,NULL,'2024-10-17 01:37:47','2024-10-22 11:10:48'),
(1304,2,'credit',NULL,8319600.0000,NULL,'2024-10-17 08:37:47',3,46996,29842,NULL,NULL,NULL,'2024-10-17 01:37:47','2024-10-22 11:10:48'),
(1305,2,'debit',NULL,5135000.0000,NULL,'2024-10-17 09:37:00',1,47535,29849,NULL,NULL,NULL,'2024-10-17 02:38:01','2024-10-17 02:38:01'),
(1306,2,'credit',NULL,855000.0000,NULL,'2024-10-17 10:49:50',6,47577,29852,NULL,NULL,NULL,'2024-10-17 03:49:50','2024-10-17 04:09:05'),
(1307,2,'credit',NULL,120000.0000,NULL,'2024-10-17 10:51:03',6,47503,29853,NULL,NULL,NULL,'2024-10-17 03:51:03','2024-10-17 04:09:56'),
(1308,2,'credit',NULL,200000.0000,NULL,'2024-10-17 12:52:21',93,47530,29863,NULL,NULL,NULL,'2024-10-17 05:52:21','2025-02-28 06:14:34'),
(1309,2,'credit',NULL,400000.0000,NULL,'2024-10-17 15:25:26',19,47600,29866,NULL,NULL,NULL,'2024-10-17 08:25:26','2024-10-17 08:25:26'),
(1310,2,'credit',NULL,390000.0000,NULL,'2024-10-17 16:46:48',10,47471,29873,NULL,NULL,NULL,'2024-10-17 09:46:48','2024-10-17 09:46:48'),
(1311,2,'credit',NULL,300000.0000,NULL,'2024-10-17 18:23:19',19,47469,29881,NULL,NULL,NULL,'2024-10-17 11:23:19','2024-10-27 02:24:20'),
(1312,2,'credit',NULL,265000.0000,NULL,'2024-10-17 21:06:40',49,47630,29890,NULL,NULL,NULL,'2024-10-17 14:06:40','2024-10-17 14:06:40'),
(1313,2,'credit',NULL,585000.0000,NULL,'2024-10-17 22:05:25',19,47633,29893,NULL,NULL,NULL,'2024-10-17 15:05:25','2024-10-17 15:05:25'),
(1314,2,'credit',NULL,390000.0000,NULL,'2024-10-18 09:35:15',6,47648,29902,NULL,NULL,NULL,'2024-10-18 02:35:15','2024-10-18 02:35:15'),
(1315,2,'debit',NULL,10590000.0000,NULL,'2024-10-18 13:04:00',1,47055,29908,NULL,NULL,NULL,'2024-10-18 06:05:00','2024-10-18 06:05:00'),
(1316,2,'debit',NULL,460000.0000,NULL,'2024-10-18 13:05:00',1,46046,29909,NULL,NULL,NULL,'2024-10-18 06:05:35','2024-10-18 06:05:35'),
(1317,2,'debit',NULL,17648000.0000,NULL,'2024-10-18 13:09:00',1,45207,29910,NULL,NULL,NULL,'2024-10-18 06:09:53','2024-10-18 06:09:53'),
(1318,2,'debit',NULL,400000.0000,NULL,'2024-10-18 13:11:00',1,47342,29911,NULL,NULL,NULL,'2024-10-18 06:11:43','2024-10-18 06:11:43'),
(1319,2,'debit',NULL,2487520.0000,NULL,'2024-10-18 13:13:00',1,47585,29912,NULL,NULL,NULL,'2024-10-18 06:13:27','2024-10-18 06:13:27'),
(1320,2,'debit',NULL,1147200.0000,NULL,'2024-10-18 13:15:00',1,39733,29913,NULL,NULL,NULL,'2024-10-18 06:15:06','2024-10-18 06:15:06'),
(1321,2,'debit',NULL,65000.0000,NULL,'2024-10-18 13:26:00',1,45111,29915,NULL,NULL,NULL,'2024-10-18 06:26:27','2024-10-18 06:26:27'),
(1322,2,'debit',NULL,541000.0000,NULL,'2024-10-18 13:27:00',1,44132,29916,NULL,NULL,NULL,'2024-10-18 06:27:31','2024-10-18 06:27:31'),
(1323,2,'debit',NULL,465000.0000,NULL,'2024-10-18 13:30:00',1,45306,29917,NULL,NULL,NULL,'2024-10-18 06:30:18','2024-10-18 06:30:18'),
(1324,2,'debit',NULL,259100.0000,NULL,'2024-10-18 13:33:00',1,45511,29918,NULL,NULL,NULL,'2024-10-18 06:33:23','2024-10-18 06:33:23'),
(1325,2,'debit',NULL,224800.0000,NULL,'2024-10-18 13:34:00',1,45521,29919,NULL,NULL,NULL,'2024-10-18 06:34:56','2024-10-18 06:34:56'),
(1326,2,'debit',NULL,43088000.0000,NULL,'2024-10-18 13:41:00',1,45791,29920,NULL,NULL,NULL,'2024-10-18 06:41:08','2024-10-18 06:41:08'),
(1327,2,'credit',NULL,730000.0000,NULL,'2024-10-18 14:30:18',6,47675,29924,NULL,NULL,NULL,'2024-10-18 07:30:18','2024-10-18 07:30:18'),
(1328,2,'credit',NULL,1150000.0000,NULL,'2024-10-18 18:03:19',19,47708,29949,NULL,NULL,NULL,'2024-10-18 11:03:19','2024-10-18 11:03:19'),
(1329,2,'credit',NULL,120000.0000,NULL,'2024-10-18 19:18:22',19,47340,29953,NULL,NULL,NULL,'2024-10-18 12:18:22','2024-10-18 12:18:22'),
(1330,2,'credit',NULL,160000.0000,NULL,'2024-10-18 19:22:42',19,47341,29954,NULL,NULL,NULL,'2024-10-18 12:22:42','2024-10-18 12:22:42'),
(1331,2,'credit',NULL,195000.0000,NULL,'2024-10-18 19:24:05',19,47713,29955,NULL,NULL,NULL,'2024-10-18 12:24:05','2024-10-18 12:24:05'),
(1332,2,'credit',NULL,80000.0000,NULL,'2024-10-18 19:07:00',19,47338,29952,NULL,NULL,NULL,'2024-10-18 12:25:53','2024-10-18 12:25:53'),
(1333,2,'debit',NULL,5600000.0000,NULL,'2024-10-18 22:07:00',1,47588,29971,NULL,NULL,NULL,'2024-10-18 15:08:00','2024-10-18 15:08:00'),
(1334,2,'debit',NULL,390000.0000,NULL,'2024-10-18 22:08:00',1,47322,29972,NULL,NULL,NULL,'2024-10-18 15:08:32','2024-10-18 15:08:32'),
(1335,2,'debit',NULL,1063000.0000,NULL,'2024-10-18 22:10:00',1,47151,29973,NULL,NULL,NULL,'2024-10-18 15:10:36','2024-10-18 15:10:36'),
(1336,2,'debit',NULL,5135000.0000,NULL,'2024-10-18 22:11:00',1,47275,29974,NULL,NULL,NULL,'2024-10-18 15:11:04','2024-10-18 15:11:04'),
(1337,2,'debit',NULL,440000.0000,NULL,'2024-10-18 22:11:00',1,47068,29975,NULL,NULL,NULL,'2024-10-18 15:11:46','2024-10-18 15:11:46'),
(1338,2,'debit',NULL,508000.0000,NULL,'2024-10-18 22:13:00',1,47298,29976,NULL,NULL,NULL,'2024-10-18 15:13:47','2024-10-18 15:13:47'),
(1339,2,'debit',NULL,775000.0000,NULL,'2024-10-18 22:14:00',1,47504,29977,NULL,NULL,NULL,'2024-10-18 15:14:58','2024-10-18 15:14:58'),
(1340,2,'debit',NULL,775000.0000,NULL,'2024-10-18 22:15:00',1,47400,29978,NULL,NULL,NULL,'2024-10-18 15:15:23','2024-10-18 15:15:23'),
(1341,2,'debit',NULL,775000.0000,NULL,'2024-10-18 22:15:00',1,47337,29979,NULL,NULL,NULL,'2024-10-18 15:15:43','2024-10-18 15:15:43'),
(1342,2,'debit',NULL,430000.0000,NULL,'2024-10-18 22:18:00',1,46977,29980,NULL,NULL,NULL,'2024-10-18 15:18:54','2024-10-18 15:18:54'),
(1343,2,'debit',NULL,908100.0000,NULL,'2024-10-18 22:19:00',1,46944,29981,NULL,NULL,NULL,'2024-10-18 15:20:00','2024-10-18 15:20:00'),
(1344,2,'debit',NULL,46090000.0000,NULL,'2024-10-18 22:21:00',1,46953,29982,NULL,NULL,NULL,'2024-10-18 15:21:33','2024-10-18 15:21:33'),
(1345,2,'debit',NULL,400000.0000,NULL,'2024-10-18 22:22:00',1,46875,29983,NULL,NULL,NULL,'2024-10-18 15:22:47','2024-10-18 15:22:47'),
(1346,2,'debit',NULL,367700.0000,NULL,'2024-10-18 22:24:00',1,47049,29984,NULL,NULL,NULL,'2024-10-18 15:24:08','2024-10-18 15:24:08'),
(1347,2,'debit',NULL,192429.0000,NULL,'2024-10-18 22:24:00',1,47058,29985,NULL,NULL,NULL,'2024-10-18 15:24:35','2024-10-18 15:24:35'),
(1348,2,'debit',NULL,1190000.0000,NULL,'2024-10-18 22:25:00',1,46838,29986,NULL,NULL,NULL,'2024-10-18 15:25:13','2024-10-18 15:25:13'),
(1349,2,'debit',NULL,60000.0000,NULL,'2024-10-18 22:26:00',1,46851,29987,NULL,NULL,NULL,'2024-10-18 15:26:57','2024-10-18 15:26:57'),
(1350,2,'debit',NULL,7977200.0000,NULL,'2024-10-18 22:28:00',1,46831,29988,NULL,NULL,NULL,'2024-10-18 15:28:05','2024-10-18 15:28:05'),
(1351,2,'debit',NULL,51835000.0000,NULL,'2024-10-18 22:30:00',1,47299,29989,NULL,NULL,NULL,'2024-10-18 15:30:39','2024-10-18 15:30:39'),
(1352,2,'debit',NULL,126519.0000,NULL,'2024-10-18 22:31:00',1,47344,29990,NULL,NULL,NULL,'2024-10-18 15:31:14','2024-10-18 15:31:14'),
(1353,2,'debit',NULL,340000.0000,NULL,'2024-10-18 22:31:00',1,47359,29991,NULL,NULL,NULL,'2024-10-18 15:31:42','2024-10-18 15:31:42'),
(1354,2,'debit',NULL,522601.0000,NULL,'2024-10-18 22:33:00',1,46694,29992,NULL,NULL,NULL,'2024-10-18 15:33:12','2024-10-18 15:33:12'),
(1355,2,'debit',NULL,390000.0000,NULL,'2024-10-18 22:33:00',1,47378,29993,NULL,NULL,NULL,'2024-10-18 15:33:52','2024-10-18 15:33:52'),
(1356,2,'debit',NULL,4186100.0000,NULL,'2024-10-18 22:34:00',1,46691,29994,NULL,NULL,NULL,'2024-10-18 15:34:45','2024-10-18 15:34:45'),
(1357,2,'debit',NULL,227000.0000,NULL,'2024-10-18 22:35:00',1,46796,29995,NULL,NULL,NULL,'2024-10-18 15:35:22','2024-10-18 15:35:22'),
(1358,2,'debit',NULL,250000.0000,NULL,'2024-10-18 22:36:00',1,46793,29996,NULL,NULL,NULL,'2024-10-18 15:36:11','2024-10-18 15:36:11'),
(1359,2,'debit',NULL,235000.0000,NULL,'2024-10-18 22:37:00',1,46435,29997,NULL,NULL,NULL,'2024-10-18 15:37:48','2024-10-18 15:37:48'),
(1360,2,'debit',NULL,415000.0000,NULL,'2024-10-18 22:38:00',1,47523,29998,NULL,NULL,NULL,'2024-10-18 15:38:34','2024-10-18 15:38:34'),
(1361,2,'debit',NULL,90000.0000,NULL,'2024-10-18 22:39:00',1,47520,29999,NULL,NULL,'2024-10-24 01:48:51','2024-10-18 15:39:59','2024-10-24 01:48:51'),
(1362,2,'debit',NULL,200000.0000,NULL,'2024-10-18 22:44:00',1,46027,30000,NULL,NULL,NULL,'2024-10-18 15:44:46','2024-10-18 15:44:46'),
(1363,2,'debit',NULL,65000.0000,NULL,'2024-10-18 22:45:00',1,46089,30001,NULL,NULL,NULL,'2024-10-18 15:45:57','2024-10-18 15:45:57'),
(1364,2,'credit',NULL,250000.0000,NULL,'2024-10-19 08:30:45',13,47729,30002,NULL,NULL,NULL,'2024-10-19 01:30:45','2024-10-19 01:30:45'),
(1365,2,'credit',NULL,960000.0000,NULL,'2024-10-19 10:21:23',3,47738,30006,NULL,NULL,NULL,'2024-10-19 03:21:23','2024-10-19 03:21:23'),
(1366,2,'credit',NULL,80000.0000,NULL,'2024-10-19 10:39:30',3,47595,30007,NULL,NULL,NULL,'2024-10-19 03:39:30','2024-10-19 04:29:13'),
(1367,2,'credit',NULL,80000.0000,NULL,'2024-10-19 10:53:03',6,47140,30011,NULL,NULL,NULL,'2024-10-19 03:53:03','2024-10-19 03:53:03'),
(1368,2,'credit',NULL,295000.0000,NULL,'2024-10-19 10:53:14',6,47741,30012,NULL,NULL,NULL,'2024-10-19 03:53:14','2024-10-19 03:53:14'),
(1369,2,'credit',NULL,495000.0000,NULL,'2024-10-19 11:29:46',106,47745,30016,NULL,NULL,NULL,'2024-10-19 04:29:46','2024-10-19 04:29:46'),
(1370,2,'credit',NULL,69000.0000,NULL,'2024-10-19 11:37:17',3,47746,30017,NULL,NULL,NULL,'2024-10-19 04:37:17','2024-10-19 04:37:17'),
(1371,2,'credit',NULL,244000.0000,NULL,'2024-10-19 16:32:56',3,47434,30048,NULL,NULL,NULL,'2024-10-19 09:32:56','2024-10-19 09:32:56'),
(1372,2,'credit',NULL,1532000.0000,NULL,'2024-10-20 15:34:02',19,47840,30101,NULL,NULL,NULL,'2024-10-20 08:34:02','2024-10-20 08:34:02'),
(1373,2,'credit',NULL,1091000.0000,NULL,'2024-10-20 17:28:42',106,47841,30112,NULL,NULL,NULL,'2024-10-20 10:28:42','2024-11-01 09:58:36'),
(1374,2,'credit',NULL,350000.0000,NULL,'2024-10-20 18:56:56',106,47838,30118,NULL,NULL,NULL,'2024-10-20 11:56:56','2024-10-20 11:56:56'),
(1375,2,'credit',NULL,10000000.0000,NULL,'2024-10-20 19:31:26',6,47868,30122,NULL,NULL,NULL,'2024-10-20 12:31:26','2024-10-22 09:38:52'),
(1376,2,'credit',NULL,470000.0000,NULL,'2024-10-20 20:36:32',6,44594,30125,NULL,NULL,NULL,'2024-10-20 13:36:32','2024-10-20 13:36:32'),
(1377,2,'credit',NULL,875000.0000,NULL,'2024-10-20 20:36:56',6,47872,30126,NULL,NULL,NULL,'2024-10-20 13:36:56','2024-10-20 13:36:56'),
(1378,2,'credit',NULL,259000.0000,NULL,'2024-10-21 09:18:36',46,47878,30131,NULL,NULL,NULL,'2024-10-21 02:18:36','2024-10-21 02:18:36'),
(1379,2,'credit',NULL,655000.0000,NULL,'2024-10-21 10:17:36',46,47887,30139,NULL,NULL,NULL,'2024-10-21 03:17:36','2024-10-21 03:17:36'),
(1380,2,'credit',NULL,200000.0000,NULL,'2024-10-21 10:19:46',46,47776,30140,NULL,NULL,NULL,'2024-10-21 03:19:46','2024-10-21 03:19:46'),
(1381,2,'credit',NULL,5875000.0000,NULL,'2024-10-21 09:46:40',5,47884,30137,NULL,NULL,NULL,'2024-10-21 05:46:00','2024-10-21 05:46:00'),
(1382,2,'credit',NULL,3559000.0000,NULL,'2024-10-21 12:49:00',19,47901,30153,NULL,NULL,NULL,'2024-10-21 05:49:56','2024-10-21 05:49:56'),
(1383,2,'credit',NULL,330000.0000,NULL,'2024-10-21 14:49:57',6,47921,30164,NULL,NULL,NULL,'2024-10-21 07:49:57','2024-10-21 07:49:57'),
(1384,2,'credit',NULL,110000.0000,NULL,'2024-10-21 17:14:35',13,47928,30171,NULL,NULL,NULL,'2024-10-21 10:14:35','2024-11-01 09:10:14'),
(1385,2,'credit',NULL,4625000.0000,NULL,'2024-10-21 17:25:57',13,46120,30175,NULL,NULL,'2024-11-01 11:21:22','2024-10-21 10:25:57','2024-11-01 11:21:22'),
(1386,2,'credit',NULL,200000.0000,NULL,'2024-10-21 21:14:23',106,47948,30192,NULL,NULL,NULL,'2024-10-21 14:14:23','2024-11-06 02:36:45'),
(1387,2,'credit',NULL,676000.0000,NULL,'2024-10-22 09:50:44',19,47968,30198,NULL,NULL,NULL,'2024-10-22 02:50:44','2024-10-22 02:50:44'),
(1388,2,'credit',NULL,2895000.0000,NULL,'2024-10-22 11:12:58',5,47978,30207,NULL,NULL,NULL,'2024-10-22 04:15:15','2024-10-22 04:15:15'),
(1389,2,'credit',NULL,333000.0000,NULL,'2024-10-22 12:33:00',19,47774,30215,NULL,NULL,NULL,'2024-10-22 05:33:59','2024-10-27 02:38:14'),
(1390,2,'credit',NULL,1078000.0000,NULL,'2024-10-22 12:35:53',5,47988,30216,NULL,NULL,NULL,'2024-10-22 05:35:53','2024-10-22 05:35:53'),
(1391,2,'credit',NULL,495000.0000,NULL,'2024-10-22 14:38:35',13,48003,30228,NULL,NULL,NULL,'2024-10-22 07:38:35','2024-10-22 11:30:14'),
(1392,2,'credit',NULL,10110000.0000,NULL,'2024-10-22 16:38:52',19,47868,30237,NULL,NULL,NULL,'2024-10-22 09:38:52','2024-10-22 09:38:52'),
(1393,2,'credit',NULL,1078000.0000,NULL,'2024-10-23 09:25:32',5,48058,30270,NULL,NULL,NULL,'2024-10-23 02:25:32','2024-10-23 02:25:32'),
(1394,2,'credit',NULL,195000.0000,NULL,'2024-10-23 12:17:48',5,48069,30278,NULL,NULL,'2024-10-23 05:18:21','2024-10-23 05:17:48','2024-10-23 05:18:21'),
(1395,2,'credit',NULL,195000.0000,NULL,'2024-10-23 12:25:30',5,48070,30280,NULL,NULL,NULL,'2024-10-23 05:25:30','2024-10-23 05:25:30'),
(1396,2,'credit',NULL,1140900.0000,NULL,'2024-10-23 13:32:36',93,48033,30290,NULL,NULL,NULL,'2024-10-23 06:32:36','2024-11-04 08:27:15'),
(1397,2,'credit',NULL,140000.0000,NULL,'2024-10-23 14:36:24',13,48081,30292,NULL,NULL,NULL,'2024-10-23 07:36:24','2024-10-23 07:36:24'),
(1398,2,'credit',NULL,250000.0000,NULL,'2024-10-23 14:41:12',93,47859,30294,NULL,NULL,NULL,'2024-10-23 07:41:12','2024-10-23 07:45:45'),
(1399,2,'credit',NULL,50000.0000,NULL,'2024-10-23 14:46:29',93,48088,30295,NULL,NULL,NULL,'2024-10-23 07:46:29','2024-10-23 07:46:29'),
(1400,2,'credit',NULL,208000.0000,NULL,'2024-10-23 16:30:18',5,48090,30299,NULL,NULL,NULL,'2024-10-23 09:30:18','2024-11-01 09:12:08'),
(1401,2,'credit',NULL,516000.0000,NULL,'2024-10-23 16:50:36',19,48093,30300,NULL,NULL,NULL,'2024-10-23 09:50:36','2024-10-27 02:33:56'),
(1402,2,'credit',NULL,80000.0000,NULL,'2024-10-23 20:17:57',3,48107,30310,NULL,NULL,NULL,'2024-10-23 13:17:57','2024-10-23 13:17:57'),
(1403,2,'credit',NULL,15000.0000,NULL,'2024-10-23 20:18:46',3,48108,30311,NULL,NULL,NULL,'2024-10-23 13:18:46','2024-10-23 13:18:46'),
(1404,2,'credit',NULL,309000.0000,NULL,'2024-10-23 20:43:02',93,48109,30312,NULL,NULL,NULL,'2024-10-23 13:43:02','2024-10-23 13:43:02'),
(1405,2,'debit',NULL,7170000.0000,NULL,'2024-10-24 08:21:00',1,47775,30321,NULL,NULL,NULL,'2024-10-24 01:21:13','2024-10-24 01:21:13'),
(1406,2,'debit',NULL,2970000.0000,NULL,'2024-10-24 08:24:00',1,48115,30322,NULL,NULL,NULL,'2024-10-24 01:24:27','2024-10-24 01:24:27'),
(1407,2,'debit',NULL,11184000.0000,NULL,'2024-10-24 08:26:00',1,48113,30323,NULL,NULL,NULL,'2024-10-24 01:26:15','2024-10-24 01:26:15'),
(1408,2,'debit',NULL,31344000.0000,NULL,'2024-10-24 08:28:00',1,48105,30324,NULL,NULL,NULL,'2024-10-24 01:29:00','2024-10-24 01:29:00'),
(1409,2,'debit',NULL,11170000.0000,NULL,'2024-10-24 08:33:00',1,48116,30326,NULL,NULL,NULL,'2024-10-24 01:34:05','2024-10-24 01:34:05'),
(1410,2,'debit',NULL,1350000.0000,NULL,'2024-10-24 08:38:00',1,48057,30328,NULL,NULL,NULL,'2024-10-24 01:38:27','2024-10-24 01:38:27'),
(1411,2,'debit',NULL,182600.0000,NULL,'2024-10-24 08:38:00',1,48042,30329,NULL,NULL,NULL,'2024-10-24 01:38:46','2024-10-24 01:38:46'),
(1412,2,'debit',NULL,775000.0000,NULL,'2024-10-24 08:39:00',1,47852,30330,NULL,NULL,NULL,'2024-10-24 01:39:15','2024-10-24 01:39:15'),
(1413,2,'debit',NULL,775000.0000,NULL,'2024-10-24 08:39:00',1,47956,30331,NULL,NULL,NULL,'2024-10-24 01:39:40','2024-10-24 01:39:40'),
(1414,2,'debit',NULL,276550.0000,NULL,'2024-10-24 08:42:00',1,47922,30332,NULL,NULL,NULL,'2024-10-24 01:42:31','2024-10-24 01:42:31'),
(1415,2,'debit',NULL,3340000.0000,NULL,'2024-10-24 08:42:00',1,47736,30333,NULL,NULL,NULL,'2024-10-24 01:42:54','2024-10-24 01:42:54'),
(1416,2,'debit',NULL,915000.0000,NULL,'2024-10-24 08:44:00',1,47689,30334,NULL,NULL,NULL,'2024-10-24 01:44:11','2024-10-24 01:44:11'),
(1417,2,'debit',NULL,1830000.0000,NULL,'2024-10-24 08:44:00',1,47923,30335,NULL,NULL,NULL,'2024-10-24 01:44:56','2024-10-24 01:44:56'),
(1418,2,'debit',NULL,17344100.0000,NULL,'2024-10-24 08:45:00',1,47869,30336,NULL,NULL,NULL,'2024-10-24 01:45:34','2024-10-24 01:45:34'),
(1419,2,'debit',NULL,318000.0000,NULL,'2024-10-24 08:47:00',1,47678,30337,NULL,NULL,NULL,'2024-10-24 01:47:17','2024-10-24 01:47:17'),
(1420,2,'debit',NULL,1620000.0000,NULL,'2024-10-24 08:49:00',1,47782,30339,NULL,NULL,NULL,'2024-10-24 01:49:59','2024-10-24 01:49:59'),
(1421,2,'debit',NULL,505000.0000,NULL,'2024-10-24 08:50:00',1,47703,30340,NULL,NULL,NULL,'2024-10-24 01:50:09','2024-10-24 01:50:09'),
(1422,2,'debit',NULL,190000.0000,NULL,'2024-10-24 08:50:00',1,47908,30341,NULL,NULL,NULL,'2024-10-24 01:50:35','2024-10-24 01:50:35'),
(1423,2,'debit',NULL,653000.0000,NULL,'2024-10-24 08:51:00',1,48043,30342,NULL,NULL,NULL,'2024-10-24 01:51:06','2024-10-24 01:51:06'),
(1424,2,'debit',NULL,390000.0000,NULL,'2024-10-24 08:51:00',1,47970,30345,NULL,NULL,NULL,'2024-10-24 01:51:47','2024-10-24 01:51:47'),
(1425,2,'debit',NULL,4770000.0000,NULL,'2024-10-24 08:52:00',1,48013,30346,NULL,NULL,NULL,'2024-10-24 01:52:14','2024-10-24 01:52:14'),
(1426,2,'debit',NULL,215000.0000,NULL,'2024-10-24 08:52:00',1,47981,30347,NULL,NULL,NULL,'2024-10-24 01:52:49','2024-10-24 01:52:49'),
(1427,2,'debit',NULL,960000.0000,NULL,'2024-10-24 08:53:00',1,47985,30348,NULL,NULL,NULL,'2024-10-24 01:53:05','2024-10-24 01:53:05'),
(1428,2,'debit',NULL,11645282.0000,NULL,'2024-10-24 08:54:00',1,47330,30349,NULL,NULL,NULL,'2024-10-24 01:54:14','2024-10-24 01:54:14'),
(1429,2,'debit',NULL,35198000.0000,NULL,'2024-10-24 08:56:00',1,47052,30350,NULL,NULL,NULL,'2024-10-24 01:56:09','2024-10-24 01:56:09'),
(1430,2,'debit',NULL,524400.0000,NULL,'2024-10-24 09:06:00',1,46351,30352,NULL,NULL,NULL,'2024-10-24 02:06:36','2024-10-24 02:06:36'),
(1431,2,'debit',NULL,6025000.0000,NULL,'2024-10-24 09:07:00',1,46152,30353,NULL,NULL,NULL,'2024-10-24 02:07:16','2024-10-24 02:07:16'),
(1432,2,'debit',NULL,6025000.0000,NULL,'2024-10-24 09:07:00',1,46799,30354,NULL,NULL,NULL,'2024-10-24 02:08:01','2024-10-24 02:08:01'),
(1433,2,'debit',NULL,990500.0000,NULL,'2024-10-24 09:35:00',1,45981,30356,NULL,NULL,NULL,'2024-10-24 02:36:10','2024-10-24 02:36:10'),
(1434,2,'credit',NULL,503000.0000,NULL,'2024-10-24 15:04:38',13,48178,30398,NULL,NULL,NULL,'2024-10-24 08:04:38','2024-10-24 08:04:38'),
(1435,2,'credit',NULL,120000.0000,NULL,'2024-10-24 15:05:06',13,48124,30400,NULL,NULL,NULL,'2024-10-24 08:05:06','2024-10-24 08:05:06'),
(1436,2,'credit',NULL,1624000.0000,NULL,'2024-10-24 15:06:14',93,48175,30401,NULL,NULL,NULL,'2024-10-24 08:06:14','2024-10-24 08:06:14'),
(1437,2,'debit',NULL,626700.0000,NULL,'2024-10-25 08:20:00',1,48156,30425,NULL,NULL,NULL,'2024-10-25 01:20:44','2024-10-25 01:20:44'),
(1438,2,'debit',NULL,775000.0000,NULL,'2024-10-25 08:20:00',1,48146,30426,NULL,NULL,NULL,'2024-10-25 01:20:54','2024-10-25 01:20:54'),
(1439,2,'debit',NULL,55700.0000,NULL,'2024-10-25 08:27:00',1,45816,30427,NULL,NULL,NULL,'2024-10-25 01:27:18','2024-10-25 01:27:18'),
(1440,2,'debit',NULL,121200.0000,NULL,'2024-10-25 08:29:00',1,45959,30428,NULL,NULL,NULL,'2024-10-25 01:29:10','2024-10-25 01:29:10'),
(1441,2,'debit',NULL,3325000.0000,NULL,'2024-10-25 08:29:00',1,46280,30429,NULL,NULL,NULL,'2024-10-25 01:29:59','2024-10-25 01:29:59'),
(1442,2,'debit',NULL,278000.0000,NULL,'2024-10-25 08:31:00',1,45878,30430,NULL,NULL,NULL,'2024-10-25 01:31:17','2024-10-25 01:31:17'),
(1443,2,'debit',NULL,251200.0000,NULL,'2024-10-25 08:32:00',1,45997,30431,NULL,NULL,NULL,'2024-10-25 01:32:10','2024-10-25 01:32:10'),
(1444,2,'debit',NULL,83600.0000,NULL,'2024-10-25 08:33:00',1,46156,30432,NULL,NULL,NULL,'2024-10-25 01:33:17','2024-10-25 01:33:17'),
(1445,2,'debit',NULL,119600.0000,NULL,'2024-10-25 08:34:00',1,45955,30433,NULL,NULL,NULL,'2024-10-25 01:34:33','2024-10-25 01:34:33'),
(1446,2,'debit',NULL,8159820.0000,NULL,'2024-10-25 09:20:00',1,47606,30435,NULL,NULL,NULL,'2024-10-25 02:20:17','2024-10-25 02:20:17'),
(1447,2,'credit',NULL,0.0000,NULL,'2024-10-25 12:02:07',6,47779,30449,NULL,NULL,NULL,'2024-10-25 05:02:07','2025-02-05 14:19:30'),
(1448,2,'credit',NULL,2174000.0000,NULL,'2024-10-25 12:59:47',6,48235,30451,NULL,NULL,NULL,'2024-10-25 05:59:47','2024-10-25 05:59:47'),
(1449,2,'credit',NULL,87000.0000,NULL,'2024-10-25 13:26:07',93,48237,30453,NULL,NULL,NULL,'2024-10-25 06:26:07','2024-10-25 06:26:07'),
(1450,2,'credit',NULL,51000.0000,NULL,'2024-10-25 13:27:36',93,48238,30454,NULL,NULL,NULL,'2024-10-25 06:27:36','2024-10-25 06:27:36'),
(1451,2,'credit',NULL,445000.0000,NULL,'2024-10-25 14:21:08',6,48243,30458,NULL,NULL,NULL,'2024-10-25 07:21:08','2024-10-25 07:21:08'),
(1452,2,'credit',NULL,80000.0000,NULL,'2024-10-25 15:28:07',6,48165,30460,NULL,NULL,NULL,'2024-10-25 08:28:07','2024-10-25 08:28:07'),
(1453,2,'credit',NULL,435000.0000,NULL,'2024-10-25 15:57:37',6,48248,30462,NULL,NULL,NULL,'2024-10-25 08:57:37','2024-10-25 08:57:37'),
(1454,2,'credit',NULL,330000.0000,NULL,'2024-10-25 16:27:59',3,48250,30463,NULL,NULL,NULL,'2024-10-25 09:31:41','2024-10-25 09:31:41'),
(1455,2,'credit',NULL,100000.0000,NULL,'2024-10-25 16:34:23',10,48188,30464,NULL,NULL,NULL,'2024-10-25 09:34:23','2024-10-25 09:34:23'),
(1456,2,'credit',NULL,80000.0000,NULL,'2024-10-25 20:26:30',93,48256,30475,NULL,NULL,NULL,'2024-10-25 13:26:30','2024-10-25 13:26:30'),
(1457,2,'credit',NULL,2495000.0000,NULL,'2024-10-26 09:15:06',3,48138,30479,NULL,NULL,NULL,'2024-10-26 02:15:06','2024-10-26 02:15:06'),
(1458,2,'credit',NULL,749000.0000,NULL,'2024-10-26 12:54:12',46,48300,30500,NULL,NULL,NULL,'2024-10-26 05:54:12','2024-10-26 05:54:12'),
(1459,2,'credit',NULL,396000.0000,NULL,'2024-10-26 13:04:45',46,48302,30502,NULL,NULL,NULL,'2024-10-26 06:04:45','2024-10-26 06:04:45'),
(1460,2,'credit',NULL,626880.0000,NULL,'2024-10-26 16:26:14',3,48330,30514,NULL,NULL,NULL,'2024-10-26 09:26:14','2024-10-26 09:26:14'),
(1461,2,'credit',NULL,200000.0000,NULL,'2024-10-26 19:51:57',5,48350,30527,NULL,NULL,NULL,'2024-10-26 12:51:57','2024-11-05 01:53:08'),
(1462,2,'credit',NULL,340000.0000,NULL,'2024-10-26 20:41:51',93,48360,30529,NULL,NULL,NULL,'2024-10-26 13:41:51','2024-10-26 13:41:51'),
(1463,2,'credit',NULL,309000.0000,NULL,'2024-10-27 09:29:55',13,48376,30538,NULL,NULL,NULL,'2024-10-27 02:29:55','2024-10-27 02:29:55'),
(1464,2,'credit',NULL,100000.0000,NULL,'2024-10-27 09:32:18',6,48378,30541,NULL,NULL,NULL,'2024-10-27 02:32:18','2024-10-27 02:32:18'),
(1465,2,'credit',NULL,100000.0000,NULL,'2024-10-27 09:33:02',6,48379,30543,NULL,NULL,NULL,'2024-10-27 02:33:02','2024-10-27 02:33:02'),
(1466,2,'credit',NULL,75000.0000,NULL,'2024-10-27 09:33:55',6,48380,30545,NULL,NULL,NULL,'2024-10-27 02:33:55','2024-10-27 02:33:55'),
(1467,2,'credit',NULL,75000.0000,NULL,'2024-10-27 09:34:59',6,48381,30546,NULL,NULL,NULL,'2024-10-27 02:34:59','2024-10-27 02:34:59'),
(1468,2,'credit',NULL,135000.0000,NULL,'2024-10-27 09:37:30',6,48382,30547,NULL,NULL,NULL,'2024-10-27 02:37:30','2024-10-27 02:37:30'),
(1469,2,'credit',NULL,135000.0000,NULL,'2024-10-27 09:38:09',6,48383,30548,NULL,NULL,NULL,'2024-10-27 02:38:09','2024-10-27 02:38:09'),
(1470,2,'credit',NULL,375000.0000,NULL,'2024-10-27 09:40:38',6,48384,30550,NULL,NULL,NULL,'2024-10-27 02:40:38','2024-10-27 02:40:38'),
(1471,2,'credit',NULL,375000.0000,NULL,'2024-10-27 09:41:11',6,48385,30552,NULL,NULL,NULL,'2024-10-27 02:41:11','2024-10-27 02:41:11'),
(1472,2,'credit',NULL,150000.0000,NULL,'2024-10-27 09:41:52',6,48386,30553,NULL,NULL,NULL,'2024-10-27 02:41:52','2024-10-27 02:41:52'),
(1473,2,'credit',NULL,150000.0000,NULL,'2024-10-27 09:42:11',6,48387,30554,NULL,NULL,NULL,'2024-10-27 02:42:11','2024-10-27 02:42:11'),
(1474,2,'credit',NULL,100000.0000,NULL,'2024-10-27 09:45:05',6,48388,30555,NULL,NULL,NULL,'2024-10-27 02:45:05','2024-10-27 02:45:05'),
(1475,2,'credit',NULL,100000.0000,NULL,'2024-10-27 09:45:48',6,48390,30556,NULL,NULL,NULL,'2024-10-27 02:45:48','2024-10-27 02:45:48'),
(1476,2,'credit',NULL,212500.0000,NULL,'2024-10-27 09:50:20',6,48393,30559,NULL,NULL,NULL,'2024-10-27 02:50:20','2024-10-27 02:50:20'),
(1477,2,'credit',NULL,212500.0000,NULL,'2024-10-27 09:50:47',6,48394,30560,NULL,NULL,NULL,'2024-10-27 02:50:47','2024-10-27 02:50:47'),
(1478,2,'debit',NULL,22290000.0000,NULL,'2024-10-27 11:12:00',1,46458,30570,NULL,NULL,'2024-10-27 04:24:06','2024-10-27 04:12:46','2024-10-27 04:24:06'),
(1479,2,'credit',NULL,2985000.0000,NULL,'2024-10-27 12:09:06',6,48413,30574,NULL,NULL,NULL,'2024-10-27 05:09:07','2024-10-27 05:09:07'),
(1480,2,'credit',NULL,439000.0000,NULL,'2024-10-27 16:12:45',93,48438,30587,NULL,NULL,NULL,'2024-10-27 09:12:45','2024-10-27 09:12:45'),
(1481,2,'credit',NULL,160000.0000,NULL,'2024-10-27 16:30:25',3,48314,30590,NULL,NULL,NULL,'2024-10-27 09:30:25','2024-10-27 10:36:17'),
(1482,2,'credit',NULL,158000.0000,NULL,'2024-10-27 16:35:03',3,48441,30591,NULL,NULL,NULL,'2024-10-27 09:35:03','2024-10-27 09:35:03'),
(1483,2,'credit',NULL,120000.0000,NULL,'2024-10-27 16:36:03',3,47593,30592,NULL,NULL,NULL,'2024-10-27 09:36:03','2024-10-27 09:36:03'),
(1484,2,'credit',NULL,150000.0000,NULL,'2024-10-27 16:58:49',3,48239,30594,NULL,NULL,NULL,'2024-10-27 09:58:49','2024-10-27 13:35:53'),
(1485,2,'credit',NULL,740000.0000,NULL,'2024-10-27 17:34:11',5,48259,30597,NULL,NULL,NULL,'2024-10-27 10:34:11','2024-10-27 10:34:11'),
(1486,2,'credit',NULL,600000.0000,NULL,'2024-10-27 17:35:35',5,48447,30598,NULL,NULL,NULL,'2024-10-27 10:35:35','2024-10-27 10:35:35'),
(1487,2,'credit',NULL,400000.0000,NULL,'2024-10-27 17:37:40',106,48448,30599,NULL,NULL,NULL,'2024-10-27 10:37:40','2024-10-27 10:37:40'),
(1488,2,'credit',NULL,395000.0000,NULL,'2024-10-27 17:48:57',5,48450,30600,NULL,NULL,NULL,'2024-10-27 10:48:57','2024-10-27 10:48:57'),
(1489,2,'credit',NULL,350000.0000,NULL,'2024-10-27 17:49:14',5,47893,30601,NULL,NULL,NULL,'2024-10-27 10:49:14','2024-10-27 10:49:14'),
(1490,2,'credit',NULL,80000.0000,NULL,'2024-10-27 19:07:40',106,48313,30606,NULL,NULL,NULL,'2024-10-27 12:07:40','2024-10-27 12:07:40'),
(1491,2,'credit',NULL,175000.0000,NULL,'2024-10-27 19:08:35',106,48456,30607,NULL,NULL,NULL,'2024-10-27 12:08:35','2024-10-27 12:08:35'),
(1492,2,'credit',NULL,138000.0000,NULL,'2024-10-27 20:36:25',106,48461,30610,NULL,NULL,NULL,'2024-10-27 13:36:25','2024-10-27 13:36:25'),
(1493,2,'credit',NULL,175000.0000,NULL,'2024-10-28 09:39:34',13,48476,30622,NULL,NULL,NULL,'2024-10-28 02:39:34','2024-10-28 02:39:34'),
(1494,2,'credit',NULL,201000.0000,NULL,'2024-10-28 12:56:41',6,48499,30640,NULL,NULL,NULL,'2024-10-28 05:56:41','2024-10-28 05:56:41'),
(1495,2,'credit',NULL,397000.0000,NULL,'2024-10-28 13:13:54',106,48501,30642,NULL,NULL,NULL,'2024-10-28 06:13:54','2024-10-28 06:13:54'),
(1496,2,'credit',NULL,550000.0000,NULL,'2024-10-28 13:15:40',106,48485,30643,NULL,NULL,NULL,'2024-10-28 06:15:40','2024-10-28 07:18:41'),
(1497,2,'credit',NULL,1027000.0000,NULL,'2024-10-28 13:32:06',93,47944,30644,NULL,NULL,NULL,'2024-10-28 06:32:06','2024-10-28 06:32:06'),
(1498,2,'credit',NULL,200000.0000,NULL,'2024-10-28 16:27:35',6,48513,30652,NULL,NULL,NULL,'2024-10-28 09:27:35','2024-10-28 10:01:54'),
(1499,2,'credit',NULL,500000.0000,NULL,'2024-10-28 17:48:06',5,48401,30663,NULL,NULL,NULL,'2024-10-28 10:48:06','2024-10-28 10:48:06'),
(1500,2,'credit',NULL,241000.0000,NULL,'2024-10-28 17:49:10',5,48532,30664,NULL,NULL,NULL,'2024-10-28 10:49:10','2024-10-28 10:49:10'),
(1501,2,'credit',NULL,190000.0000,NULL,'2024-10-29 09:11:45',49,48554,30672,NULL,NULL,NULL,'2024-10-29 02:11:45','2024-10-29 02:11:45'),
(1502,2,'credit',NULL,200000.0000,NULL,'2024-10-29 10:36:19',6,47623,30674,NULL,NULL,NULL,'2024-10-29 03:36:19','2024-10-29 03:36:19'),
(1503,2,'credit',NULL,209000.0000,NULL,'2024-10-29 11:27:21',6,48564,30679,NULL,NULL,NULL,'2024-10-29 04:27:21','2024-10-29 04:27:21'),
(1504,2,'credit',NULL,80000.0000,NULL,'2024-10-29 14:44:12',19,48361,30694,NULL,NULL,NULL,'2024-10-29 07:44:12','2024-10-29 07:44:12'),
(1505,2,'credit',NULL,750000.0000,NULL,'2024-10-29 15:27:07',106,48581,30698,NULL,NULL,NULL,'2024-10-29 08:27:07','2024-10-29 08:31:13'),
(1506,2,'credit',NULL,397000.0000,NULL,'2024-10-29 15:32:28',49,48582,30700,NULL,NULL,NULL,'2024-10-29 08:32:28','2024-10-29 08:32:28'),
(1507,2,'credit',NULL,550000.0000,NULL,'2024-10-29 15:32:51',49,48547,30701,NULL,NULL,NULL,'2024-10-29 08:32:51','2024-10-29 08:32:51'),
(1508,2,'credit',NULL,345000.0000,NULL,'2024-10-29 17:34:28',19,48588,30706,NULL,NULL,NULL,'2024-10-29 10:34:28','2024-10-30 07:22:15'),
(1509,2,'credit',NULL,195000.0000,NULL,'2024-10-29 18:32:06',19,48591,30710,NULL,NULL,NULL,'2024-10-29 11:32:06','2024-10-29 11:32:06'),
(1510,2,'credit',NULL,139000.0000,NULL,'2024-10-29 18:51:01',106,48592,30711,NULL,NULL,NULL,'2024-10-29 11:51:01','2024-10-29 11:51:01'),
(1511,2,'credit',NULL,3496000.0000,NULL,'2024-10-29 20:41:38',19,48602,30713,NULL,NULL,NULL,'2024-10-29 13:41:38','2024-10-29 13:41:38'),
(1512,2,'credit',NULL,398000.0000,NULL,'2024-10-29 20:42:16',19,48603,30714,NULL,NULL,NULL,'2024-10-29 13:42:16','2024-10-29 13:42:16'),
(1513,2,'credit',NULL,600000.0000,NULL,'2024-10-29 20:58:01',19,48593,30715,NULL,NULL,NULL,'2024-10-29 13:58:01','2024-10-30 07:31:07'),
(1514,2,'credit',NULL,15000000.0000,NULL,'2024-10-30 08:57:03',13,48618,30739,NULL,NULL,NULL,'2024-10-30 01:57:03','2024-10-31 10:35:35'),
(1515,2,'credit',NULL,120000.0000,NULL,'2024-10-30 10:34:56',49,46017,30745,NULL,NULL,NULL,'2024-10-30 03:34:56','2024-10-30 03:34:56'),
(1516,2,'credit',NULL,79000.0000,NULL,'2024-10-30 10:44:01',6,48624,30746,NULL,NULL,NULL,'2024-10-30 03:44:01','2024-10-30 03:44:01'),
(1517,2,'debit',NULL,775000.0000,NULL,'2024-10-30 11:42:00',1,48569,30753,NULL,NULL,NULL,'2024-10-30 04:42:30','2024-10-30 04:42:30'),
(1518,2,'debit',NULL,112000.0000,NULL,'2024-10-30 12:08:00',1,48617,30758,NULL,NULL,NULL,'2024-10-30 05:08:49','2024-10-30 05:08:49'),
(1519,2,'debit',NULL,149000.0000,NULL,'2024-10-30 12:09:00',1,48610,30759,NULL,NULL,NULL,'2024-10-30 05:09:21','2024-10-30 05:09:21'),
(1520,2,'credit',NULL,384000.0000,NULL,'2024-10-30 12:09:38',46,48631,30760,NULL,NULL,NULL,'2024-10-30 05:09:38','2024-10-30 05:34:24'),
(1521,2,'debit',NULL,251568.0000,NULL,'2024-10-30 12:15:00',1,48452,30761,NULL,NULL,NULL,'2024-10-30 05:15:59','2024-10-30 05:15:59'),
(1522,2,'credit',NULL,4000000.0000,NULL,'2024-10-30 14:03:29',93,48640,30767,NULL,NULL,NULL,'2024-10-30 07:03:29','2024-10-30 07:05:34'),
(1523,2,'credit',NULL,525000.0000,NULL,'2024-10-30 14:20:11',6,48642,30771,NULL,NULL,NULL,'2024-10-30 07:20:11','2024-10-30 07:20:11'),
(1524,2,'credit',NULL,525000.0000,NULL,'2024-10-30 14:21:43',6,48643,30772,NULL,NULL,NULL,'2024-10-30 07:21:43','2024-10-30 07:21:43'),
(1525,2,'credit',NULL,1049000.0000,NULL,'2024-10-30 14:24:21',19,48593,30773,NULL,NULL,NULL,'2024-10-30 07:24:21','2024-10-30 07:31:07'),
(1526,2,'credit',NULL,100000.0000,NULL,'2024-10-30 14:31:57',6,48647,30776,NULL,NULL,NULL,'2024-10-30 07:31:57','2024-10-30 07:31:57'),
(1527,2,'credit',NULL,201000.0000,NULL,'2024-10-30 15:01:46',19,48654,30779,NULL,NULL,NULL,'2024-10-30 08:01:46','2024-10-30 08:01:46'),
(1528,2,'credit',NULL,96000.0000,NULL,'2024-10-30 15:48:29',106,48662,30781,NULL,NULL,NULL,'2024-10-30 08:48:29','2024-10-30 08:48:29'),
(1529,2,'credit',NULL,200000.0000,NULL,'2024-10-30 18:16:24',106,48600,30798,NULL,NULL,NULL,'2024-10-30 11:16:24','2025-01-31 05:09:06'),
(1530,2,'credit',NULL,374000.0000,NULL,'2024-10-30 20:17:02',93,48693,30807,NULL,NULL,NULL,'2024-10-30 13:17:02','2024-10-30 13:17:02'),
(1531,2,'credit',NULL,740000.0000,NULL,'2024-10-30 21:11:00',19,48695,30809,NULL,NULL,NULL,'2024-10-30 14:11:00','2024-10-30 14:11:00'),
(1532,2,'credit',NULL,230000.0000,NULL,'2024-10-30 21:36:37',19,48637,30810,NULL,NULL,NULL,'2024-10-30 14:36:37','2024-10-30 14:36:37'),
(1533,2,'credit',NULL,175000.0000,NULL,'2024-10-30 21:37:40',19,48697,30811,NULL,NULL,NULL,'2024-10-30 14:37:40','2024-10-30 14:37:40'),
(1534,2,'credit',NULL,145000.0000,NULL,'2024-10-31 08:59:12',46,48702,30813,NULL,NULL,NULL,'2024-10-31 01:59:12','2024-10-31 01:59:12'),
(1535,2,'credit',NULL,228000.0000,NULL,'2024-10-31 11:44:08',46,48715,30822,NULL,NULL,NULL,'2024-10-31 04:44:08','2024-10-31 04:44:08'),
(1536,2,'credit',NULL,450000.0000,NULL,'2024-10-31 15:14:00',19,46230,30848,NULL,NULL,NULL,'2024-10-31 08:14:35','2024-10-31 08:15:07'),
(1537,2,'credit',NULL,410000.0000,NULL,'2024-10-31 15:33:46',106,48733,30856,NULL,NULL,NULL,'2024-10-31 08:33:46','2024-10-31 08:33:46'),
(1538,2,'credit',NULL,265000.0000,NULL,'2024-10-31 15:40:41',19,48734,30857,NULL,NULL,NULL,'2024-10-31 08:40:41','2024-10-31 08:40:41'),
(1539,2,'credit',NULL,2000000.0000,NULL,'2024-10-31 16:02:52',49,48738,30861,NULL,NULL,NULL,'2024-10-31 09:02:52','2024-11-05 10:15:53'),
(1540,2,'credit',NULL,80000.0000,NULL,'2024-10-31 16:15:14',49,48586,30865,NULL,NULL,NULL,'2024-10-31 09:15:14','2024-10-31 09:15:14'),
(1541,2,'credit',NULL,70000.0000,NULL,'2024-10-31 16:15:52',49,48739,30866,NULL,NULL,NULL,'2024-10-31 09:15:52','2024-10-31 09:15:52'),
(1542,2,'credit',NULL,4849000.0000,NULL,'2024-10-31 17:41:54',19,48745,30875,NULL,NULL,NULL,'2024-10-31 10:41:54','2024-10-31 10:41:54'),
(1543,2,'credit',NULL,290000.0000,NULL,'2024-10-31 20:20:07',106,48690,30899,NULL,NULL,NULL,'2024-10-31 13:20:07','2024-11-01 06:46:48'),
(1544,2,'credit',NULL,268000.0000,NULL,'2024-10-31 20:37:01',93,48769,30901,NULL,NULL,NULL,'2024-10-31 13:37:01','2024-10-31 13:37:01'),
(1545,2,'debit',NULL,3100000.0000,NULL,'2024-11-01 07:10:00',1,48735,30905,NULL,NULL,NULL,'2024-11-01 00:10:25','2024-11-01 00:10:25'),
(1546,2,'credit',NULL,46000.0000,NULL,'2024-11-01 13:23:43',5,48788,30932,NULL,NULL,NULL,'2024-11-01 06:23:43','2024-11-05 02:10:37'),
(1547,2,'credit',NULL,2500000.0000,NULL,'2024-11-01 13:45:50',1,48793,30935,NULL,NULL,'2024-11-12 08:14:31','2024-11-01 06:45:50','2024-11-12 08:14:31'),
(1548,2,'credit',NULL,200000.0000,NULL,'2024-11-01 14:41:13',6,48756,30941,NULL,NULL,NULL,'2024-11-01 07:41:13','2024-11-16 11:57:25'),
(1549,2,'debit',NULL,18755000.0000,NULL,'2024-11-01 14:48:00',1,47435,30944,NULL,NULL,NULL,'2024-11-01 07:48:24','2024-11-01 07:48:24'),
(1550,2,'debit',NULL,775000.0000,NULL,'2024-11-01 14:48:00',1,48655,30945,NULL,NULL,NULL,'2024-11-01 07:49:01','2024-11-01 07:49:01'),
(1551,2,'credit',NULL,80000.0000,NULL,'2024-11-01 15:38:23',3,48819,30952,NULL,NULL,NULL,'2024-11-01 08:38:23','2024-11-01 08:38:23'),
(1552,2,'credit',NULL,190000.0000,NULL,'2024-11-01 15:57:21',3,48822,30958,NULL,NULL,NULL,'2024-11-01 08:57:21','2024-11-01 08:57:21'),
(1553,2,'credit',NULL,40000.0000,NULL,'2024-11-01 16:00:02',3,48824,30961,NULL,NULL,NULL,'2024-11-01 09:00:02','2024-11-01 09:00:02'),
(1554,2,'credit',NULL,75000.0000,NULL,'2024-11-01 16:09:13',3,48825,30963,NULL,NULL,NULL,'2024-11-01 09:09:13','2024-11-01 09:09:13'),
(1555,2,'credit',NULL,75000.0000,NULL,'2024-11-01 16:09:32',3,48826,30964,NULL,NULL,NULL,'2024-11-01 09:09:32','2024-11-01 09:09:32'),
(1556,2,'credit',NULL,40000.0000,NULL,'2024-11-01 16:12:32',3,48827,30967,NULL,NULL,NULL,'2024-11-01 09:12:32','2024-11-01 09:12:32'),
(1557,2,'credit',NULL,40000.0000,NULL,'2024-11-01 16:12:48',3,48828,30968,NULL,NULL,NULL,'2024-11-01 09:12:48','2024-11-01 09:12:48'),
(1558,2,'credit',NULL,40000.0000,NULL,'2024-11-01 16:44:27',3,48840,30986,NULL,NULL,NULL,'2024-11-01 09:44:27','2024-11-01 09:44:27'),
(1559,2,'credit',NULL,40000.0000,NULL,'2024-11-01 16:44:49',3,48841,30987,NULL,NULL,NULL,'2024-11-01 09:44:49','2024-11-01 09:44:49'),
(1560,2,'credit',NULL,1750000.0000,NULL,'2024-11-01 18:20:18',5,48851,30996,NULL,NULL,NULL,'2024-11-01 11:20:18','2024-11-01 11:20:18'),
(1561,2,'credit',NULL,1750000.0000,NULL,'2024-11-01 18:21:01',5,48852,30997,NULL,NULL,NULL,'2024-11-01 11:21:01','2024-11-01 11:21:01'),
(1562,2,'credit',NULL,279500.0000,NULL,'2024-11-01 20:43:56',106,48869,31007,NULL,NULL,NULL,'2024-11-01 13:43:56','2024-11-01 13:43:56'),
(1563,2,'credit',NULL,140000.0000,NULL,'2024-11-01 19:06:12',5,48856,31000,NULL,NULL,'2024-11-05 04:07:55','2024-11-01 14:41:03','2024-11-05 04:07:55'),
(1564,2,'credit',NULL,2024500.0000,NULL,'2024-11-02 11:45:15',3,48813,31034,NULL,NULL,NULL,'2024-11-02 04:45:15','2024-11-23 04:12:59'),
(1565,2,'credit',NULL,476000.0000,NULL,'2024-11-02 12:32:21',49,48907,31042,NULL,NULL,NULL,'2024-11-02 05:32:21','2024-11-02 05:32:21'),
(1566,2,'credit',NULL,305000.0000,NULL,'2024-11-02 12:33:57',3,48813,31043,NULL,NULL,NULL,'2024-11-02 05:33:58','2024-11-23 04:12:59'),
(1567,2,'debit',NULL,92606400.0000,NULL,'2024-11-02 14:04:00',1,48411,31051,NULL,NULL,NULL,'2024-11-02 07:05:08','2024-11-02 07:05:08'),
(1568,2,'debit',NULL,1315480.0000,NULL,'2024-11-02 14:15:00',1,48523,31054,NULL,NULL,NULL,'2024-11-02 07:15:55','2024-11-02 07:15:55'),
(1569,2,'debit',NULL,714000.0000,NULL,'2024-11-02 14:16:00',1,48335,31055,NULL,NULL,NULL,'2024-11-02 07:16:42','2024-11-02 07:16:42'),
(1570,2,'debit',NULL,1895500.0000,NULL,'2024-11-02 14:32:00',1,45712,31059,NULL,NULL,NULL,'2024-11-02 07:32:37','2024-11-02 07:32:37'),
(1571,2,'debit',NULL,5482500.0000,NULL,'2024-11-02 14:34:00',1,45536,31060,NULL,NULL,NULL,'2024-11-02 07:34:21','2024-11-02 07:34:21'),
(1572,2,'debit',NULL,185000.0000,NULL,'2024-11-02 14:38:00',1,45927,31062,NULL,NULL,NULL,'2024-11-02 07:38:30','2024-11-02 07:38:30'),
(1573,2,'debit',NULL,403400.0000,NULL,'2024-11-02 14:40:00',1,46853,31063,NULL,NULL,NULL,'2024-11-02 07:40:22','2024-11-02 07:40:22'),
(1574,2,'debit',NULL,2430000.0000,NULL,'2024-11-02 14:45:00',1,48409,31064,NULL,NULL,NULL,'2024-11-02 07:45:10','2024-11-02 07:45:10'),
(1575,2,'debit',NULL,149000.0000,NULL,'2024-11-02 14:50:00',1,46577,31065,NULL,NULL,NULL,'2024-11-02 07:50:29','2024-11-02 07:50:29'),
(1576,2,'debit',NULL,562800.0000,NULL,'2024-11-02 14:54:00',1,48347,31066,NULL,NULL,NULL,'2024-11-02 07:54:19','2024-11-02 07:54:19'),
(1577,2,'debit',NULL,3867554.0000,NULL,'2024-11-02 14:58:00',1,48615,31067,NULL,NULL,NULL,'2024-11-02 07:58:20','2024-11-02 07:58:20'),
(1578,2,'debit',NULL,5904600.0000,NULL,'2024-11-02 15:20:00',3,47662,31072,NULL,NULL,NULL,'2024-11-02 08:20:39','2024-11-02 08:20:39'),
(1579,2,'credit',NULL,70000.0000,NULL,'2024-11-02 15:26:05',6,48932,31073,NULL,NULL,NULL,'2024-11-02 08:26:05','2024-11-06 11:16:55'),
(1580,2,'credit',NULL,212000.0000,NULL,'2024-11-02 17:40:00',19,48945,31082,NULL,NULL,NULL,'2024-11-02 10:40:22','2024-11-06 02:51:27'),
(1581,2,'debit',NULL,4750000.0000,NULL,'2024-11-03 13:13:00',1,48234,31115,NULL,NULL,NULL,'2024-11-03 06:13:17','2024-11-03 06:13:17'),
(1582,2,'debit',NULL,178000.0000,NULL,'2024-11-03 13:15:00',1,48926,31116,NULL,NULL,NULL,'2024-11-03 06:15:51','2024-11-03 06:15:51'),
(1583,2,'debit',NULL,17000.0000,NULL,'2024-11-03 13:17:00',1,48518,31117,NULL,NULL,NULL,'2024-11-03 06:17:51','2024-11-03 06:17:51'),
(1584,2,'debit',NULL,17160000.0000,NULL,'2024-11-03 13:22:00',1,48345,31118,NULL,NULL,NULL,'2024-11-03 06:22:23','2024-11-03 06:22:23'),
(1585,2,'debit',NULL,2260000.0000,NULL,'2024-11-03 13:33:00',1,48775,31119,NULL,NULL,NULL,'2024-11-03 06:33:24','2024-11-03 06:33:24'),
(1586,2,'debit',NULL,1259000.0000,NULL,'2024-11-03 13:34:00',1,48095,31120,NULL,NULL,NULL,'2024-11-03 06:34:33','2024-11-03 06:34:33'),
(1587,2,'debit',NULL,2240000.0000,NULL,'2024-11-03 13:36:00',1,48923,31121,NULL,NULL,'2024-11-05 07:19:04','2024-11-03 06:36:46','2024-11-05 07:19:04'),
(1588,2,'credit',NULL,200000.0000,NULL,'2024-11-03 20:54:56',49,48987,31136,NULL,NULL,NULL,'2024-11-03 13:54:56','2024-12-04 05:29:38'),
(1589,2,'credit',NULL,235000.0000,NULL,'2024-11-04 09:06:10',19,49002,31145,NULL,NULL,NULL,'2024-11-04 02:06:10','2024-11-06 01:53:28'),
(1590,2,'credit',NULL,25000.0000,NULL,'2024-11-04 09:44:17',13,49006,31148,NULL,NULL,NULL,'2024-11-04 02:44:17','2024-11-04 02:44:17'),
(1591,2,'credit',NULL,120000.0000,NULL,'2024-11-04 12:45:29',19,49020,31152,NULL,NULL,NULL,'2024-11-04 05:45:29','2024-11-04 05:45:29'),
(1592,2,'credit',NULL,1709000.0000,NULL,'2024-11-04 13:20:37',6,49024,31153,NULL,NULL,NULL,'2024-11-04 06:20:37','2024-11-06 01:50:35'),
(1593,2,'credit',NULL,40000.0000,NULL,'2024-11-05 09:26:45',19,49073,31189,NULL,NULL,NULL,'2024-11-05 02:26:45','2024-11-06 01:42:50'),
(1594,2,'credit',NULL,377000.0000,NULL,'2024-11-05 09:55:10',13,49045,31190,NULL,NULL,NULL,'2024-11-05 02:55:10','2024-11-30 06:41:07'),
(1595,2,'debit',NULL,4005000.0000,NULL,'2024-11-05 13:46:00',1,48814,31222,NULL,NULL,NULL,'2024-11-05 06:46:14','2024-11-05 06:46:14'),
(1596,2,'credit',NULL,343000.0000,NULL,'2024-11-05 13:55:46',6,49098,31225,NULL,NULL,NULL,'2024-11-05 06:55:46','2024-11-06 06:40:21'),
(1597,2,'debit',NULL,2240000.0000,NULL,'2024-11-05 13:56:00',1,49009,31226,NULL,NULL,NULL,'2024-11-05 06:56:14','2024-11-05 06:56:14'),
(1598,2,'debit',NULL,3598600.0000,NULL,'2024-11-05 14:01:00',1,48925,31227,NULL,NULL,NULL,'2024-11-05 07:01:52','2024-11-05 07:01:52'),
(1599,2,'credit',NULL,1535000.0000,NULL,'2024-11-05 14:34:08',5,49102,31230,NULL,NULL,NULL,'2024-11-05 07:34:08','2024-11-05 07:34:08'),
(1600,2,'credit',NULL,5695000.0000,NULL,'2024-11-05 17:14:56',2,48738,31244,NULL,NULL,NULL,'2024-11-05 10:15:53','2024-11-05 10:15:53'),
(1601,2,'credit',NULL,20000000.0000,NULL,'2024-11-05 18:26:18',3,49127,31251,NULL,NULL,NULL,'2024-11-05 11:26:18','2024-11-23 04:49:20'),
(1602,2,'credit',NULL,12564000.0000,NULL,'2024-11-05 18:26:18',3,49127,31252,NULL,NULL,NULL,'2024-11-05 11:26:18','2024-11-23 04:49:20'),
(1603,2,'credit',NULL,1377000.0000,NULL,'2024-11-05 19:36:40',6,49130,31254,NULL,NULL,NULL,'2024-11-05 12:36:40','2024-11-06 06:38:28'),
(1604,2,'credit',NULL,1120000.0000,NULL,'2024-11-05 19:36:54',6,39373,31257,NULL,NULL,NULL,'2024-11-05 12:36:54','2024-11-05 12:36:54'),
(1605,2,'credit',NULL,400000.0000,NULL,'2024-11-05 19:40:31',6,49131,31258,NULL,NULL,NULL,'2024-11-05 12:40:31','2024-11-06 01:37:56'),
(1606,2,'credit',NULL,200000.0000,NULL,'2024-11-06 08:28:41',5,49134,31263,NULL,NULL,NULL,'2024-11-06 01:28:41','2024-11-30 04:41:10'),
(1607,2,'credit',NULL,9750000.0000,NULL,'2024-11-06 12:59:33',19,49168,31277,NULL,NULL,NULL,'2024-11-06 05:59:33','2024-11-11 10:29:29'),
(1608,2,'credit',NULL,63000.0000,NULL,'2024-11-06 13:54:41',49,49176,31281,NULL,NULL,NULL,'2024-11-06 06:54:41','2024-11-06 06:54:41'),
(1609,2,'credit',NULL,1060000.0000,NULL,'2024-11-06 15:19:35',46,49183,31283,NULL,NULL,NULL,'2024-11-06 08:19:35','2024-11-06 08:19:35'),
(1610,2,'credit',NULL,820000.0000,NULL,'2024-11-06 16:21:34',5,49191,31287,NULL,NULL,NULL,'2024-11-06 09:21:34','2024-11-06 09:21:34'),
(1611,2,'credit',NULL,340000.0000,NULL,'2024-11-06 16:29:21',13,49192,31288,NULL,NULL,NULL,'2024-11-06 09:29:21','2024-11-06 09:29:21'),
(1612,2,'credit',NULL,640000.0000,NULL,'2024-11-06 17:06:21',3,39613,31291,NULL,NULL,NULL,'2024-11-06 10:06:21','2025-02-04 11:44:45'),
(1613,2,'credit',NULL,2625000.0000,NULL,'2024-11-07 11:54:49',19,49237,31316,NULL,NULL,NULL,'2024-11-07 04:54:49','2024-11-08 06:59:24'),
(1614,2,'credit',NULL,120000.0000,NULL,'2024-11-07 13:51:38',3,48184,31333,NULL,NULL,NULL,'2024-11-07 06:51:38','2024-11-07 06:51:38'),
(1615,2,'credit',NULL,113000.0000,NULL,'2024-11-07 13:52:44',3,49251,31334,NULL,NULL,NULL,'2024-11-07 06:52:44','2024-11-07 06:52:44'),
(1616,2,'credit',NULL,500000.0000,NULL,'2024-11-07 13:57:00',6,49171,31335,NULL,NULL,NULL,'2024-11-07 06:57:00','2024-11-08 05:54:34'),
(1617,2,'credit',NULL,7922000.0000,NULL,'2024-11-08 08:12:32',5,49299,31364,NULL,NULL,NULL,'2024-11-08 01:12:32','2024-11-08 01:12:32'),
(1618,2,'credit',NULL,1209000.0000,NULL,'2024-11-08 10:35:36',46,49171,31373,NULL,NULL,NULL,'2024-11-08 03:35:36','2024-11-08 03:35:36'),
(1619,2,'debit',NULL,775000.0000,NULL,'2024-11-08 13:10:00',1,49321,31381,NULL,NULL,NULL,'2024-11-08 06:10:29','2024-11-08 06:10:29'),
(1620,2,'debit',NULL,18620000.0000,NULL,'2024-11-08 13:10:00',1,49261,31382,NULL,NULL,NULL,'2024-11-08 06:10:52','2024-11-08 06:10:52'),
(1621,2,'debit',NULL,775000.0000,NULL,'2024-11-08 13:11:00',1,49273,31383,NULL,NULL,NULL,'2024-11-08 06:11:06','2024-11-08 06:11:06'),
(1622,2,'debit',NULL,18305100.0000,NULL,'2024-11-08 13:40:00',1,49139,31386,NULL,NULL,NULL,'2024-11-08 06:40:23','2024-11-08 06:40:23'),
(1623,2,'credit',NULL,2625000.0000,NULL,'2024-11-08 13:46:29',93,49237,31387,NULL,NULL,NULL,'2024-11-08 06:46:29','2024-11-08 06:59:24'),
(1624,2,'debit',NULL,60000.0000,NULL,'2024-11-08 14:08:00',1,49272,31388,NULL,NULL,NULL,'2024-11-08 07:08:12','2024-11-08 07:08:12'),
(1625,2,'debit',NULL,260000.0000,NULL,'2024-11-08 14:08:00',1,49288,31389,NULL,NULL,NULL,'2024-11-08 07:08:29','2024-11-08 07:08:29'),
(1626,2,'debit',NULL,12291000.0000,NULL,'2024-11-08 14:10:00',1,49213,31390,NULL,NULL,NULL,'2024-11-08 07:10:33','2024-11-08 07:10:33'),
(1627,2,'debit',NULL,1300000.0000,NULL,'2024-11-08 14:20:00',1,49119,31391,NULL,NULL,NULL,'2024-11-08 07:20:43','2024-11-08 07:20:43'),
(1628,2,'credit',NULL,1500000.0000,NULL,'2024-11-08 15:59:21',6,49350,31403,NULL,NULL,NULL,'2024-11-08 08:59:21','2024-11-08 08:59:21'),
(1629,2,'credit',NULL,1755000.0000,NULL,'2024-11-08 15:59:21',6,49350,31404,NULL,NULL,NULL,'2024-11-08 08:59:21','2024-11-08 08:59:21'),
(1630,2,'debit',NULL,1550000.0000,NULL,'2024-11-09 08:38:00',1,49324,31438,NULL,NULL,NULL,'2024-11-09 01:38:12','2024-11-09 01:38:12'),
(1631,2,'debit',NULL,1550000.0000,NULL,'2024-11-09 08:40:00',1,49069,31439,NULL,NULL,NULL,'2024-11-09 01:40:09','2024-11-09 01:40:09'),
(1632,2,'credit',NULL,6880000.0000,NULL,'2024-11-09 11:21:30',106,49399,31447,NULL,NULL,NULL,'2024-11-09 04:21:30','2024-11-09 04:21:30'),
(1633,2,'credit',NULL,200000.0000,NULL,'2024-11-09 18:18:59',6,49144,31471,NULL,NULL,NULL,'2024-11-09 11:18:59','2024-11-30 01:39:34'),
(1634,2,'credit',NULL,61000.0000,NULL,'2024-11-10 12:36:30',93,49456,31497,NULL,NULL,NULL,'2024-11-10 06:13:04','2024-11-10 06:13:04'),
(1635,2,'credit',NULL,250000.0000,NULL,'2024-11-10 18:07:00',106,49284,31517,NULL,NULL,NULL,'2024-11-10 11:07:00','2024-11-10 11:07:00'),
(1636,2,'credit',NULL,39000.0000,NULL,'2024-11-11 10:04:13',19,49518,31539,NULL,NULL,NULL,'2024-11-11 03:04:13','2024-11-11 03:04:13'),
(1637,2,'credit',NULL,9750000.0000,NULL,'2024-07-24 11:49:00',19,49535,31548,NULL,NULL,NULL,'2024-11-11 04:49:44','2024-11-11 04:50:24'),
(1638,2,'credit',NULL,1110000.0000,NULL,'2024-11-11 12:34:38',19,49537,31552,NULL,NULL,NULL,'2024-11-11 05:34:38','2024-11-11 05:34:38'),
(1639,2,'credit',NULL,10000000.0000,NULL,'2024-11-11 14:30:29',6,49553,31563,NULL,NULL,NULL,'2024-11-11 07:30:29','2024-11-14 02:10:59'),
(1640,2,'credit',NULL,1395000.0000,NULL,'2024-11-11 14:56:30',46,49557,31566,NULL,NULL,NULL,'2024-11-11 07:56:30','2024-11-11 07:56:30'),
(1641,2,'credit',NULL,1000000.0000,NULL,'2024-11-11 15:06:53',13,49561,31567,NULL,NULL,NULL,'2024-11-11 08:06:53','2024-11-20 13:06:30'),
(1642,2,'credit',NULL,950000.0000,NULL,'2024-11-11 15:20:27',13,43019,31568,NULL,NULL,NULL,'2024-11-11 08:20:27','2024-11-13 08:25:30'),
(1643,2,'credit',NULL,1074000.0000,NULL,'2024-11-11 15:57:16',6,49568,31576,NULL,NULL,NULL,'2024-11-11 08:57:16','2024-11-11 08:57:16'),
(1644,2,'credit',NULL,200000.0000,NULL,'2024-11-11 16:47:26',19,49541,31578,NULL,NULL,NULL,'2024-11-11 09:47:26','2024-11-11 09:47:26'),
(1645,2,'credit',NULL,367000.0000,NULL,'2024-11-11 17:10:47',13,49566,31579,NULL,NULL,'2024-12-11 09:21:46','2024-11-11 10:10:47','2024-12-11 09:21:46'),
(1646,2,'credit',NULL,1651000.0000,NULL,'2024-11-11 21:17:07',13,49598,31592,NULL,NULL,NULL,'2024-11-11 14:17:07','2024-11-22 08:24:20'),
(1647,2,'credit',NULL,200000.0000,NULL,'2024-11-12 09:37:55',49,49479,31600,NULL,NULL,NULL,'2024-11-12 02:37:55','2024-11-24 14:38:21'),
(1648,2,'credit',NULL,180000.0000,NULL,'2024-11-12 12:27:24',49,49622,31608,NULL,NULL,NULL,'2024-11-12 05:27:24','2024-11-12 05:27:24'),
(1649,2,'credit',NULL,1275000.0000,NULL,'2024-11-12 12:37:47',93,49511,31610,NULL,NULL,NULL,'2024-11-12 05:37:47','2024-11-14 06:55:25'),
(1650,2,'credit',NULL,5813000.0000,NULL,'2024-11-12 12:43:05',10,48793,31612,NULL,NULL,'2024-11-12 08:14:31','2024-11-12 05:43:05','2024-11-12 08:14:31'),
(1651,2,'credit',NULL,30000.0000,NULL,'2024-11-12 14:14:14',10,49631,31619,NULL,NULL,NULL,'2024-11-12 07:14:14','2024-12-05 06:30:46'),
(1652,2,'credit',NULL,435000.0000,NULL,'2024-11-12 14:47:36',46,49582,31624,NULL,NULL,NULL,'2024-11-12 07:47:36','2024-11-12 07:47:36'),
(1653,2,'credit',NULL,489000.0000,NULL,'2024-11-12 15:03:50',10,49644,31628,NULL,NULL,NULL,'2024-11-12 08:03:50','2024-11-12 08:03:50'),
(1654,2,'credit',NULL,342000.0000,NULL,'2024-11-12 15:08:57',13,49642,31632,NULL,NULL,NULL,'2024-11-12 08:08:57','2024-11-12 08:08:57'),
(1655,2,'credit',NULL,2500000.0000,NULL,'2024-11-12 15:11:01',10,49648,31634,NULL,NULL,NULL,'2024-11-12 08:12:22','2024-12-05 06:31:33'),
(1656,2,'credit',NULL,5813000.0000,NULL,'2024-11-12 15:12:22',10,49648,31635,NULL,NULL,NULL,'2024-11-12 08:12:22','2024-12-05 06:31:33'),
(1657,2,'credit',NULL,500000.0000,NULL,'2024-11-12 15:30:25',5,49652,31636,NULL,NULL,NULL,'2024-11-12 08:30:25','2024-11-12 09:19:11'),
(1658,2,'credit',NULL,200000.0000,NULL,'2024-11-12 15:47:06',5,49534,31637,NULL,NULL,NULL,'2024-11-12 08:47:06','2024-11-30 04:42:22'),
(1659,2,'credit',NULL,200000.0000,NULL,'2024-11-12 16:10:01',3,49591,31640,NULL,NULL,NULL,'2024-11-12 09:10:01','2024-12-31 05:40:50'),
(1660,2,'credit',NULL,200000.0000,NULL,'2024-11-13 08:39:43',49,49674,31660,NULL,NULL,NULL,'2024-11-13 01:39:43','2024-11-21 05:54:01'),
(1661,2,'credit',NULL,19000.0000,NULL,'2024-11-13 11:11:06',49,49697,31675,NULL,NULL,NULL,'2024-11-13 04:11:07','2024-11-13 04:11:07'),
(1662,2,'credit',NULL,195000.0000,NULL,'2024-11-13 11:23:06',49,49698,31676,NULL,NULL,NULL,'2024-11-13 04:23:06','2024-11-13 04:23:06'),
(1663,2,'credit',NULL,325000.0000,NULL,'2024-11-13 11:36:28',10,49700,31677,NULL,NULL,NULL,'2024-11-13 04:36:28','2024-12-05 07:23:49'),
(1664,2,'credit',NULL,1920000.0000,NULL,'2024-11-13 12:57:26',49,49705,31681,NULL,NULL,NULL,'2024-11-13 05:57:26','2024-11-13 05:57:26'),
(1665,2,'credit',NULL,80000.0000,NULL,'2024-11-13 13:56:39',13,49693,31688,NULL,NULL,NULL,'2024-11-13 06:56:39','2024-11-13 07:14:29'),
(1666,2,'credit',NULL,2000000.0000,NULL,'2024-11-13 15:14:09',13,49725,31695,NULL,NULL,NULL,'2024-11-13 08:14:09','2024-12-01 06:35:05'),
(1667,2,'credit',NULL,4178000.0000,NULL,'2024-11-13 15:24:25',13,49725,31696,NULL,NULL,NULL,'2024-11-13 08:24:25','2024-12-01 06:35:05'),
(1668,2,'credit',NULL,3498000.0000,NULL,'2024-11-13 16:53:57',49,49496,31701,NULL,NULL,NULL,'2024-11-13 09:53:57','2025-07-04 01:53:32'),
(1669,2,'credit',NULL,225000.0000,NULL,'2024-11-13 20:15:37',106,49761,31714,NULL,NULL,NULL,'2024-11-13 13:15:37','2024-11-13 13:15:37'),
(1670,2,'credit',NULL,482000.0000,NULL,'2024-11-13 20:15:59',106,49762,31715,NULL,NULL,NULL,'2024-11-13 13:15:59','2024-11-13 13:15:59'),
(1671,2,'credit',NULL,9555000.0000,NULL,'2024-11-14 08:56:52',19,49553,31723,NULL,NULL,NULL,'2024-11-14 01:56:52','2024-11-14 02:10:59'),
(1672,2,'credit',NULL,200000.0000,NULL,'2024-11-14 10:39:50',93,49446,31735,NULL,NULL,NULL,'2024-11-14 03:39:50','2024-11-30 01:39:50'),
(1673,2,'credit',NULL,35016000.0000,NULL,'2024-11-14 14:38:45',106,49801,31749,NULL,NULL,NULL,'2024-11-14 07:38:45','2024-11-14 07:38:45'),
(1674,2,'credit',NULL,317000.0000,NULL,'2024-11-14 16:48:01',49,49818,31760,NULL,NULL,NULL,'2024-11-14 09:48:01','2024-11-30 06:43:40'),
(1675,2,'credit',NULL,3063600.0000,NULL,'2024-11-14 17:06:00',19,49816,31762,NULL,NULL,'2024-11-14 10:12:22','2024-11-14 10:06:43','2024-11-14 10:12:22'),
(1676,2,'credit',NULL,2710000.0000,NULL,'2024-11-14 17:09:00',19,49781,31763,NULL,NULL,NULL,'2024-11-14 10:09:35','2024-11-14 10:09:35'),
(1677,2,'credit',NULL,115000.0000,NULL,'2024-11-14 21:07:56',5,49831,31773,NULL,NULL,NULL,'2024-11-14 14:07:56','2024-11-14 14:07:56'),
(1678,2,'debit',NULL,2325000.0000,NULL,'2024-11-16 08:19:00',1,49900,31822,NULL,NULL,NULL,'2024-11-16 01:19:37','2024-11-16 01:19:37'),
(1679,2,'debit',NULL,8316000.0000,NULL,'2024-11-16 08:25:00',1,49809,31823,NULL,NULL,NULL,'2024-11-16 01:25:21','2024-11-16 01:25:21'),
(1680,2,'debit',NULL,3875000.0000,NULL,'2024-11-16 08:26:00',1,49773,31824,NULL,NULL,NULL,'2024-11-16 01:26:28','2024-11-16 01:26:28'),
(1681,2,'debit',NULL,775000.0000,NULL,'2024-11-16 08:26:00',1,49685,31825,NULL,NULL,NULL,'2024-11-16 01:26:41','2024-11-16 01:26:41'),
(1682,2,'debit',NULL,20622300.0000,NULL,'2024-11-16 08:32:00',1,49768,31826,NULL,NULL,NULL,'2024-11-16 01:32:18','2024-11-16 01:32:18'),
(1683,2,'debit',NULL,1450000.0000,NULL,'2024-11-16 08:35:00',1,49748,31827,NULL,NULL,NULL,'2024-11-16 01:35:40','2024-11-16 01:35:40'),
(1684,2,'debit',NULL,523000.0000,NULL,'2024-11-16 08:35:00',1,49766,31828,NULL,NULL,NULL,'2024-11-16 01:35:54','2024-11-16 01:35:54'),
(1685,2,'debit',NULL,1860000.0000,NULL,'2024-11-16 08:40:00',1,49745,31829,NULL,NULL,NULL,'2024-11-16 01:40:44','2024-11-16 01:40:44'),
(1686,2,'debit',NULL,65000.0000,NULL,'2024-11-16 08:47:00',1,45002,31830,NULL,NULL,NULL,'2024-11-16 01:47:31','2024-11-16 01:47:31'),
(1687,2,'debit',NULL,160000.0000,NULL,'2024-11-16 08:47:00',1,45524,31831,NULL,NULL,NULL,'2024-11-16 01:47:58','2024-11-16 01:47:58'),
(1688,2,'debit',NULL,53500.0000,NULL,'2024-11-16 08:51:00',1,46183,31832,NULL,NULL,NULL,'2024-11-16 01:51:38','2024-11-16 01:51:38'),
(1689,2,'debit',NULL,60700.0000,NULL,'2024-11-16 08:52:00',1,46236,31833,NULL,NULL,NULL,'2024-11-16 01:52:35','2024-11-16 01:52:35'),
(1690,2,'debit',NULL,208000.0000,NULL,'2024-11-16 08:53:00',1,47175,31834,NULL,NULL,NULL,'2024-11-16 01:53:07','2024-11-16 01:53:07'),
(1691,2,'debit',NULL,280000.0000,NULL,'2024-11-16 08:54:00',1,47514,31835,NULL,NULL,NULL,'2024-11-16 01:54:12','2024-11-16 01:54:12'),
(1692,2,'debit',NULL,53000.0000,NULL,'2024-11-16 08:55:00',1,48486,31836,NULL,NULL,NULL,'2024-11-16 01:55:46','2024-11-16 01:55:46'),
(1693,2,'debit',NULL,740000.0000,NULL,'2024-11-16 09:06:00',1,48519,31837,NULL,NULL,NULL,'2024-11-16 02:06:15','2024-11-16 02:06:15'),
(1694,2,'debit',NULL,53000.0000,NULL,'2024-11-16 09:07:00',1,48584,31838,NULL,NULL,NULL,'2024-11-16 02:07:30','2024-11-16 02:07:30'),
(1695,2,'debit',NULL,70000.0000,NULL,'2024-11-16 09:07:00',1,48663,31839,NULL,NULL,NULL,'2024-11-16 02:08:01','2024-11-16 02:08:01'),
(1696,2,'debit',NULL,75000.0000,NULL,'2024-11-16 09:08:00',1,49065,31840,NULL,NULL,NULL,'2024-11-16 02:08:44','2024-11-16 02:08:44'),
(1697,2,'debit',NULL,59000.0000,NULL,'2024-11-16 09:09:00',1,49210,31841,NULL,NULL,NULL,'2024-11-16 02:09:28','2024-11-16 02:09:28'),
(1698,2,'debit',NULL,110000.0000,NULL,'2024-11-16 09:09:00',1,49575,31842,NULL,NULL,NULL,'2024-11-16 02:09:55','2024-11-16 02:09:55'),
(1699,2,'debit',NULL,7383800.0000,NULL,'2024-11-16 09:12:00',1,49074,31843,NULL,NULL,NULL,'2024-11-16 02:12:50','2024-11-16 02:12:50'),
(1700,2,'debit',NULL,16835000.0000,NULL,'2024-11-16 09:14:00',1,49185,31844,NULL,NULL,NULL,'2024-11-16 02:14:26','2024-11-16 02:14:26'),
(1701,2,'debit',NULL,29934000.0000,NULL,'2024-11-16 09:17:00',1,48935,31845,NULL,NULL,NULL,'2024-11-16 02:17:11','2024-11-16 02:17:11'),
(1702,2,'debit',NULL,4954400.0000,NULL,'2024-11-16 09:20:00',1,49408,31846,NULL,NULL,NULL,'2024-11-16 02:20:22','2024-11-16 02:20:22'),
(1703,2,'debit',NULL,20894000.0000,NULL,'2024-11-16 09:32:00',1,48758,31849,NULL,NULL,NULL,'2024-11-16 02:32:59','2024-11-16 02:32:59'),
(1704,2,'debit',NULL,4740000.0000,NULL,'2024-11-16 09:40:00',1,48757,31850,NULL,NULL,NULL,'2024-11-16 02:40:56','2024-11-16 02:40:56'),
(1705,2,'debit',NULL,19988000.0000,NULL,'2024-11-16 09:45:00',1,48587,31851,NULL,NULL,NULL,'2024-11-16 02:45:35','2024-11-16 02:45:35'),
(1706,2,'debit',NULL,2900000.0000,NULL,'2024-11-16 09:51:00',1,49746,31853,NULL,NULL,NULL,'2024-11-16 02:51:48','2024-11-16 02:51:48'),
(1707,2,'debit',NULL,370000.0000,NULL,'2024-11-16 09:55:00',1,35056,31854,NULL,NULL,'2024-11-16 02:57:15','2024-11-16 02:55:46','2024-11-16 02:57:15'),
(1708,2,'debit',NULL,975000.0000,NULL,'2024-11-16 09:56:00',1,39655,31855,NULL,NULL,NULL,'2024-11-16 02:56:27','2024-11-16 02:56:27'),
(1709,2,'credit',NULL,155000.0000,NULL,'2024-11-16 10:12:46',49,49912,31856,NULL,NULL,NULL,'2024-11-16 03:12:46','2024-11-16 03:12:46'),
(1710,2,'credit',NULL,181000.0000,NULL,'2024-11-16 10:27:04',19,49913,31857,NULL,NULL,NULL,'2024-11-16 03:27:04','2024-11-16 03:27:04'),
(1711,2,'credit',NULL,250000.0000,NULL,'2024-11-16 14:36:33',19,47486,31877,NULL,NULL,NULL,'2024-11-16 07:36:33','2024-11-16 07:36:33'),
(1712,2,'credit',NULL,1195000.0000,NULL,'2024-11-16 14:37:34',19,49947,31878,NULL,NULL,NULL,'2024-11-16 07:37:34','2024-11-16 07:37:34'),
(1713,2,'credit',NULL,983000.0000,NULL,'2024-11-16 15:30:35',49,49919,31881,NULL,NULL,NULL,'2024-11-16 08:30:35','2024-12-01 08:16:33'),
(1714,2,'credit',NULL,835000.0000,NULL,'2024-11-16 16:15:42',46,49954,31884,NULL,NULL,NULL,'2024-11-16 09:15:42','2024-11-16 09:15:42'),
(1715,2,'credit',NULL,108000.0000,NULL,'2024-11-16 18:19:11',6,49964,31895,NULL,NULL,NULL,'2024-11-16 11:19:11','2024-11-16 11:19:11'),
(1716,2,'credit',NULL,749000.0000,NULL,'2024-11-16 19:09:25',5,49972,31900,NULL,NULL,NULL,'2024-11-16 12:09:25','2024-11-16 12:09:25'),
(1717,2,'debit',NULL,2029500.0000,NULL,'2024-11-17 08:46:00',1,49951,31913,NULL,NULL,NULL,'2024-11-17 01:47:04','2024-11-17 01:47:04'),
(1718,2,'debit',NULL,20140000.0000,NULL,'2024-11-17 08:49:00',1,49930,31914,NULL,NULL,NULL,'2024-11-17 01:49:33','2024-11-17 01:49:33'),
(1719,2,'credit',NULL,4800000.0000,NULL,'2024-11-17 15:41:50',19,50012,31929,NULL,NULL,NULL,'2024-11-17 08:41:50','2024-11-17 08:41:50'),
(1720,2,'credit',NULL,80000.0000,NULL,'2024-11-17 19:33:40',5,49921,31945,NULL,NULL,NULL,'2024-11-17 12:33:40','2024-11-17 12:33:40'),
(1721,2,'credit',NULL,325000.0000,NULL,'2024-11-18 12:47:48',10,50068,31974,NULL,NULL,NULL,'2024-11-18 05:47:48','2024-12-05 07:25:29'),
(1722,2,'credit',NULL,295000.0000,NULL,'2024-11-18 14:35:36',13,49948,31983,NULL,NULL,NULL,'2024-11-18 07:35:36','2024-11-18 07:35:36'),
(1723,2,'credit',NULL,944000.0000,NULL,'2024-11-18 15:37:15',13,49871,31987,NULL,NULL,NULL,'2024-11-18 08:37:15','2024-11-18 08:37:15'),
(1724,2,'credit',NULL,380000.0000,NULL,'2024-11-18 20:07:07',49,50103,32001,NULL,NULL,'2024-11-30 07:01:22','2024-11-18 13:07:07','2024-11-30 07:01:22'),
(1725,2,'credit',NULL,235000.0000,NULL,'2024-11-19 11:48:23',6,50126,32016,NULL,NULL,NULL,'2024-11-19 04:48:23','2024-11-19 04:48:23'),
(1726,2,'credit',NULL,14928000.0000,NULL,'2024-11-19 12:05:34',6,50129,32017,NULL,NULL,NULL,'2024-11-19 05:05:34','2024-11-19 05:05:34'),
(1727,2,'credit',NULL,116000.0000,NULL,'2024-11-19 16:17:47',3,50158,32030,NULL,NULL,NULL,'2024-11-19 09:17:47','2024-12-01 08:31:52'),
(1728,2,'credit',NULL,1504000.0000,NULL,'2024-11-19 16:30:47',3,50135,32031,NULL,NULL,NULL,'2024-11-19 09:30:47','2024-11-19 09:30:47'),
(1729,2,'credit',NULL,423000.0000,NULL,'2024-11-19 18:28:29',19,50168,32035,NULL,NULL,NULL,'2024-11-19 11:28:29','2024-11-19 11:28:29'),
(1730,2,'credit',NULL,100000.0000,NULL,'2024-08-10 18:36:10',6,42064,25595,NULL,NULL,NULL,'2024-11-19 14:00:54','2024-11-19 14:00:54'),
(1731,2,'credit',NULL,55000.0000,NULL,'2024-11-20 09:30:36',106,50196,32054,NULL,NULL,NULL,'2024-11-20 02:30:36','2024-11-20 02:30:36'),
(1732,2,'credit',NULL,887500.0000,NULL,'2024-11-20 17:02:39',6,50232,32078,NULL,NULL,NULL,'2024-11-20 10:02:39','2024-11-27 10:16:15'),
(1733,2,'credit',NULL,1030000.0000,NULL,'2024-11-21 20:52:44',49,50302,32135,NULL,NULL,NULL,'2024-11-21 13:52:44','2024-11-21 14:14:38'),
(1734,2,'credit',NULL,160000.0000,NULL,'2024-11-21 20:52:57',49,49952,32136,NULL,NULL,NULL,'2024-11-21 13:52:57','2024-11-21 13:52:57'),
(1735,2,'credit',NULL,6604000.0000,NULL,'2024-11-22 15:24:20',13,49598,32152,NULL,NULL,NULL,'2024-11-22 08:24:20','2024-11-22 08:24:20'),
(1736,2,'credit',NULL,189000.0000,NULL,'2024-11-22 17:56:50',49,50341,32159,NULL,NULL,NULL,'2024-11-22 10:56:50','2024-11-22 10:56:50'),
(1737,2,'credit',NULL,5577000.0000,NULL,'2024-11-22 18:06:26',93,50342,32160,NULL,NULL,NULL,'2024-11-22 11:06:26','2024-11-22 11:16:35'),
(1738,2,'credit',NULL,270000.0000,NULL,'2024-11-23 13:33:11',49,50381,32194,NULL,NULL,NULL,'2024-11-23 06:33:11','2024-11-23 06:33:11'),
(1739,2,'credit',NULL,80000.0000,NULL,'2024-11-23 15:49:51',3,50403,32199,NULL,NULL,NULL,'2024-11-23 08:49:51','2024-11-23 08:49:51'),
(1740,2,'credit',NULL,2022000.0000,NULL,'2024-11-23 16:25:56',3,50212,32201,NULL,NULL,NULL,'2024-11-23 09:25:56','2025-04-21 03:00:54'),
(1741,2,'credit',NULL,200000.0000,NULL,'2024-11-23 17:01:59',6,50410,32204,NULL,NULL,NULL,'2024-11-23 10:01:59','2024-11-24 08:53:03'),
(1742,2,'credit',NULL,155000.0000,NULL,'2024-11-24 15:53:03',46,50410,32236,NULL,NULL,NULL,'2024-11-24 08:53:03','2024-11-24 08:53:03'),
(1743,2,'debit',NULL,9375000.0000,NULL,'2024-11-24 16:05:00',1,46891,32238,NULL,NULL,NULL,'2024-11-24 09:05:51','2024-11-24 09:05:51'),
(1744,2,'debit',NULL,23887300.0000,NULL,'2024-11-24 16:09:00',1,48100,32239,NULL,NULL,NULL,'2024-11-24 09:09:11','2024-11-24 09:09:11'),
(1745,2,'credit',NULL,77000.0000,NULL,'2024-11-24 16:58:30',49,50461,32243,NULL,NULL,NULL,'2024-11-24 09:58:30','2024-11-24 09:58:30'),
(1746,2,'credit',NULL,150000.0000,NULL,'2024-11-24 17:11:19',49,50395,32244,NULL,NULL,NULL,'2024-11-24 10:11:19','2024-11-24 10:11:19'),
(1747,2,'credit',NULL,650000.0000,NULL,'2024-11-24 19:00:18',13,49479,32250,NULL,NULL,NULL,'2024-11-24 12:00:18','2024-11-24 12:00:18'),
(1748,2,'credit',NULL,137000.0000,NULL,'2024-11-24 20:19:49',19,50470,32251,NULL,NULL,NULL,'2024-11-24 13:19:49','2024-11-24 13:19:49'),
(1749,2,'credit',NULL,200000.0000,NULL,'2024-11-24 20:45:15',13,50339,32252,NULL,NULL,NULL,'2024-11-24 13:45:15','2024-11-30 04:39:46'),
(1750,2,'credit',NULL,105000.0000,NULL,'2024-11-24 21:01:05',19,50472,32253,NULL,NULL,NULL,'2024-11-24 14:01:05','2024-11-24 14:42:17'),
(1751,2,'credit',NULL,110000.0000,NULL,'2024-11-24 21:02:26',19,50472,32254,NULL,NULL,NULL,'2024-11-24 14:42:17','2024-11-24 14:42:17'),
(1752,2,'credit',NULL,298000.0000,NULL,'2024-11-26 08:57:31',6,50475,32258,NULL,NULL,NULL,'2024-11-26 01:57:31','2024-11-26 01:57:31'),
(1753,2,'credit',NULL,327000.0000,NULL,'2024-11-26 09:37:53',49,50328,32260,NULL,NULL,NULL,'2024-11-26 02:37:53','2024-11-26 02:37:53'),
(1754,2,'credit',NULL,390000.0000,NULL,'2024-11-26 10:56:32',5,50484,32263,NULL,NULL,NULL,'2024-11-26 03:56:32','2024-11-26 03:56:32'),
(1755,2,'credit',NULL,395000.0000,NULL,'2024-11-26 11:38:30',6,50491,32268,NULL,NULL,NULL,'2024-11-26 04:38:30','2024-12-06 01:43:06'),
(1756,2,'credit',NULL,117000.0000,NULL,'2024-11-26 13:07:18',19,50499,32273,NULL,NULL,NULL,'2024-11-26 06:07:18','2024-11-26 06:07:18'),
(1757,2,'credit',NULL,60000.0000,NULL,'2024-11-26 14:52:00',19,50505,32281,NULL,NULL,NULL,'2024-11-26 07:52:24','2024-11-30 03:16:08'),
(1758,2,'credit',NULL,160000.0000,NULL,'2024-11-26 14:56:24',6,49440,32282,NULL,NULL,NULL,'2024-11-26 07:56:24','2024-11-26 07:56:24'),
(1759,2,'credit',NULL,589000.0000,NULL,'2024-11-26 14:56:43',6,50508,32283,NULL,NULL,NULL,'2024-11-26 07:56:43','2024-11-26 07:56:43'),
(1760,2,'credit',NULL,390000.0000,NULL,'2024-11-26 16:17:45',1,50518,32288,NULL,NULL,NULL,'2024-11-26 09:17:45','2024-11-30 06:35:05'),
(1761,2,'credit',NULL,315000.0000,NULL,'2024-11-26 17:11:09',49,50524,32293,NULL,NULL,NULL,'2024-11-26 10:11:09','2024-11-26 10:11:09'),
(1762,2,'credit',NULL,749000.0000,NULL,'2024-11-26 17:52:21',19,50530,32295,NULL,NULL,NULL,'2024-11-26 10:52:21','2024-11-26 10:52:21'),
(1763,2,'credit',NULL,470000.0000,NULL,'2024-11-27 10:49:12',5,50555,32313,NULL,NULL,NULL,'2024-11-27 03:49:12','2024-11-27 03:49:12'),
(1764,2,'credit',NULL,207000.0000,NULL,'2024-11-27 13:58:10',49,50569,32321,NULL,NULL,NULL,'2024-11-27 06:58:10','2024-11-27 06:58:10'),
(1765,2,'credit',NULL,220000.0000,NULL,'2024-11-27 13:58:19',49,50501,32322,NULL,NULL,NULL,'2024-11-27 06:58:19','2024-11-27 06:58:19'),
(1766,2,'credit',NULL,678000.0000,NULL,'2024-11-27 16:24:25',6,50584,32328,NULL,NULL,NULL,'2024-11-27 09:24:25','2024-11-27 09:26:36'),
(1767,2,'credit',NULL,135000.0000,NULL,'2024-11-27 16:58:52',106,50393,32333,NULL,NULL,NULL,'2024-11-27 09:58:52','2024-11-27 09:58:52'),
(1768,2,'credit',NULL,282000.0000,NULL,'2024-11-27 16:59:31',106,50587,32334,NULL,NULL,NULL,'2024-11-27 09:59:31','2024-11-27 09:59:31'),
(1769,2,'credit',NULL,887500.0000,NULL,'2024-11-27 09:28:48',6,50232,32310,NULL,NULL,NULL,'2024-11-27 10:16:15','2024-11-27 10:16:15'),
(1770,2,'credit',NULL,746000.0000,NULL,'2024-11-27 20:04:19',49,50598,32348,NULL,NULL,NULL,'2024-11-27 13:04:19','2024-11-27 13:04:19'),
(1771,2,'credit',NULL,180000.0000,NULL,'2024-11-27 21:16:24',49,50604,32353,NULL,NULL,NULL,'2024-11-27 14:16:24','2024-11-27 14:16:24'),
(1772,2,'credit',NULL,160000.0000,NULL,'2024-11-27 21:16:39',49,50566,32354,NULL,NULL,NULL,'2024-11-27 14:16:39','2024-11-27 14:16:39'),
(1773,2,'credit',NULL,118000.0000,NULL,'2024-11-27 21:27:36',49,50606,32356,NULL,NULL,NULL,'2024-11-27 14:27:36','2024-11-27 14:27:36'),
(1774,2,'credit',NULL,3020000.0000,NULL,'2024-11-28 09:07:43',6,50612,32360,NULL,NULL,NULL,'2024-11-28 02:07:43','2024-11-30 04:38:04'),
(1775,2,'credit',NULL,592000.0000,NULL,'2024-11-28 10:27:40',106,50619,32364,NULL,NULL,NULL,'2024-11-28 03:27:40','2024-11-28 03:27:40'),
(1776,2,'credit',NULL,450000.0000,NULL,'2024-11-28 10:28:13',106,50255,32365,NULL,NULL,NULL,'2024-11-28 03:28:13','2024-11-28 03:28:13'),
(1777,2,'credit',NULL,35000.0000,NULL,'2024-11-28 11:25:26',93,50628,32369,NULL,NULL,NULL,'2024-11-28 04:25:26','2024-11-28 04:25:26'),
(1778,2,'credit',NULL,293000.0000,NULL,'2024-11-28 13:26:10',106,50641,32376,NULL,NULL,NULL,'2024-11-28 06:26:10','2024-11-28 06:26:10'),
(1779,2,'credit',NULL,360000.0000,NULL,'2024-11-28 20:05:17',19,50669,32396,NULL,NULL,NULL,'2024-11-28 13:05:17','2024-11-28 13:05:17'),
(1780,2,'credit',NULL,353000.0000,NULL,'2024-11-28 21:04:33',46,50673,32401,NULL,NULL,NULL,'2024-11-28 14:04:33','2024-11-30 02:16:26'),
(1781,2,'credit',NULL,597000.0000,NULL,'2024-11-29 11:50:17',93,50693,32406,NULL,NULL,NULL,'2024-11-29 04:50:17','2024-11-29 04:50:17'),
(1782,2,'credit',NULL,165000.0000,NULL,'2024-11-29 14:21:41',3,50710,32414,NULL,NULL,NULL,'2024-11-29 07:21:41','2024-11-29 07:21:41'),
(1783,2,'credit',NULL,200000.0000,NULL,'2024-11-29 14:25:39',3,50332,32415,NULL,NULL,NULL,'2024-11-29 07:25:39','2025-02-08 13:07:29'),
(1784,2,'credit',NULL,438000.0000,NULL,'2024-11-29 14:32:46',46,50711,32416,NULL,NULL,NULL,'2024-11-29 07:32:46','2024-11-29 07:32:46'),
(1785,2,'credit',NULL,100000.0000,NULL,'2024-11-29 15:35:02',106,50621,32420,NULL,NULL,NULL,'2024-11-29 08:35:02','2024-11-29 08:35:02'),
(1786,2,'credit',NULL,129000.0000,NULL,'2024-11-29 16:59:12',93,50729,32428,NULL,NULL,NULL,'2024-11-29 09:59:12','2024-11-29 09:59:12'),
(1787,2,'credit',NULL,95000.0000,NULL,'2024-11-29 18:09:56',93,50738,32437,NULL,NULL,NULL,'2024-11-29 11:09:56','2024-11-29 11:09:56'),
(1788,2,'credit',NULL,6271000.0000,NULL,'2024-11-29 19:45:29',13,50745,32445,NULL,NULL,NULL,'2024-11-29 12:45:29','2024-11-29 14:26:46'),
(1789,2,'credit',NULL,80000.0000,NULL,'2024-11-29 19:45:54',13,50707,32446,NULL,NULL,NULL,'2024-11-29 12:45:54','2024-11-29 12:45:54'),
(1790,2,'credit',NULL,7667000.0000,NULL,'2024-11-29 20:30:47',3,50749,32450,NULL,NULL,NULL,'2024-11-29 13:30:47','2024-12-02 01:52:38'),
(1791,2,'credit',NULL,117000.0000,NULL,'2024-11-29 20:57:42',3,50758,32456,NULL,NULL,NULL,'2024-11-29 13:57:42','2024-11-29 13:57:42'),
(1792,2,'credit',NULL,55000.0000,NULL,'2024-11-29 21:27:55',19,50770,32458,NULL,NULL,'2024-11-29 14:33:06','2024-11-29 14:27:55','2024-11-29 14:33:06'),
(1793,2,'credit',NULL,200000.0000,NULL,'2024-11-30 09:48:51',5,50703,32465,NULL,NULL,NULL,'2024-11-30 02:48:51','2024-11-30 02:48:51'),
(1794,2,'credit',NULL,60000.0000,NULL,'2024-11-30 10:05:10',6,50780,32483,NULL,NULL,NULL,'2024-11-30 03:05:10','2024-11-30 03:07:30'),
(1795,2,'credit',NULL,35000.0000,NULL,'2024-11-30 11:37:44',6,50800,32497,NULL,NULL,NULL,'2024-11-30 04:37:44','2024-11-30 04:37:44'),
(1796,2,'credit',NULL,746000.0000,NULL,'2024-11-30 11:56:42',6,50258,32500,NULL,NULL,NULL,'2024-11-30 04:56:42','2024-11-30 04:56:42'),
(1797,2,'debit',NULL,3480000.0000,NULL,'2024-11-30 12:07:00',1,43908,32501,NULL,NULL,NULL,'2024-11-30 05:07:16','2024-11-30 05:07:16'),
(1798,2,'debit',NULL,5733500.0000,NULL,'2024-11-30 12:13:00',1,45478,32502,NULL,NULL,NULL,'2024-11-30 05:13:20','2024-11-30 05:13:20'),
(1799,2,'debit',NULL,364900.0000,NULL,'2024-11-30 12:20:00',1,44055,32503,NULL,NULL,NULL,'2024-11-30 05:21:03','2024-11-30 05:21:03'),
(1800,2,'credit',NULL,1978000.0000,NULL,'2024-11-30 13:05:18',6,50806,32506,NULL,NULL,NULL,'2024-11-30 06:05:18','2024-11-30 06:05:18'),
(1801,2,'debit',NULL,10695400.0000,NULL,'2024-11-30 13:16:00',1,50570,32509,NULL,NULL,NULL,'2024-11-30 06:16:46','2024-11-30 06:16:46'),
(1802,2,'debit',NULL,775000.0000,NULL,'2024-11-30 13:17:00',1,50746,32510,NULL,NULL,NULL,'2024-11-30 06:17:31','2024-11-30 06:17:31'),
(1803,2,'credit',NULL,200000.0000,NULL,'2024-11-30 13:31:07',19,50811,32512,NULL,NULL,NULL,'2024-11-30 06:31:07','2024-11-30 06:31:07'),
(1804,2,'debit',NULL,46695.0000,NULL,'2024-11-30 13:34:00',1,50298,32514,NULL,NULL,NULL,'2024-11-30 06:34:32','2024-11-30 06:34:32'),
(1805,2,'debit',NULL,520000.0000,NULL,'2024-11-30 13:35:00',1,50162,32516,NULL,NULL,NULL,'2024-11-30 06:35:19','2024-11-30 06:35:19'),
(1806,2,'debit',NULL,11348600.0000,NULL,'2024-11-30 13:36:00',1,50157,32517,NULL,NULL,NULL,'2024-11-30 06:36:29','2024-11-30 06:36:29'),
(1807,2,'debit',NULL,899000.0000,NULL,'2024-11-30 13:37:00',1,50261,32518,NULL,NULL,NULL,'2024-11-30 06:38:04','2024-11-30 06:38:04'),
(1808,2,'debit',NULL,549000.0000,NULL,'2024-11-30 13:39:00',1,50655,32519,NULL,NULL,NULL,'2024-11-30 06:39:27','2024-11-30 06:39:27'),
(1809,2,'debit',NULL,775000.0000,NULL,'2024-11-30 13:41:00',1,50592,32521,NULL,NULL,NULL,'2024-11-30 06:41:08','2024-11-30 06:41:08'),
(1810,2,'debit',NULL,775000.0000,NULL,'2024-11-30 13:41:00',1,50141,32522,NULL,NULL,NULL,'2024-11-30 06:41:38','2024-11-30 06:41:38'),
(1811,2,'debit',NULL,775000.0000,NULL,'2024-11-30 13:42:00',1,50415,32523,NULL,NULL,NULL,'2024-11-30 06:42:08','2024-11-30 06:42:08'),
(1812,2,'debit',NULL,2530000.0000,NULL,'2024-11-30 13:44:00',1,50155,32526,NULL,NULL,NULL,'2024-11-30 06:44:19','2024-11-30 06:44:19'),
(1813,2,'debit',NULL,61000.0000,NULL,'2024-11-30 13:46:00',1,50105,32527,NULL,NULL,NULL,'2024-11-30 06:46:18','2024-11-30 06:46:18'),
(1814,2,'debit',NULL,28800.0000,NULL,'2024-11-30 13:48:00',1,50107,32528,NULL,NULL,NULL,'2024-11-30 06:48:53','2024-11-30 06:48:53'),
(1815,2,'debit',NULL,58400.0000,NULL,'2024-11-30 13:50:00',1,50001,32529,NULL,NULL,NULL,'2024-11-30 06:50:55','2024-11-30 06:50:55'),
(1816,2,'debit',NULL,314300.0000,NULL,'2024-11-30 13:52:00',1,50006,32530,NULL,NULL,NULL,'2024-11-30 06:52:20','2024-11-30 06:52:20'),
(1817,2,'debit',NULL,11807000.0000,NULL,'2024-11-30 13:53:00',1,49992,32531,NULL,NULL,NULL,'2024-11-30 06:54:02','2024-11-30 06:54:02'),
(1818,2,'credit',NULL,307000.0000,NULL,'2024-11-30 14:04:08',46,50815,32532,NULL,NULL,NULL,'2024-11-30 07:04:08','2024-11-30 07:04:08'),
(1819,2,'credit',NULL,330000.0000,NULL,'2024-11-30 14:21:37',13,50817,32533,NULL,NULL,NULL,'2024-11-30 07:21:37','2024-11-30 07:21:37'),
(1820,2,'debit',NULL,20722800.0000,NULL,'2024-11-30 14:27:00',1,50130,32536,NULL,NULL,NULL,'2024-11-30 07:27:34','2024-11-30 07:27:34'),
(1821,2,'debit',NULL,3402200.0000,NULL,'2024-11-30 15:13:00',1,46815,32539,NULL,NULL,NULL,'2024-11-30 08:13:35','2024-11-30 08:13:35'),
(1822,2,'debit',NULL,55000.0000,NULL,'2024-11-30 15:42:00',1,49993,32543,NULL,NULL,NULL,'2024-11-30 08:42:13','2024-11-30 08:42:13'),
(1823,2,'debit',NULL,86000.0000,NULL,'2024-11-30 16:50:00',1,46991,32552,NULL,NULL,NULL,'2024-11-30 09:50:54','2024-11-30 09:50:54'),
(1824,2,'debit',NULL,90500.0000,NULL,'2024-11-30 16:51:00',1,45744,32553,NULL,NULL,NULL,'2024-11-30 09:51:38','2024-11-30 09:51:38'),
(1825,2,'debit',NULL,960000.0000,NULL,'2024-11-30 16:52:00',1,48567,32554,NULL,NULL,NULL,'2024-11-30 09:52:53','2024-11-30 09:52:53'),
(1826,2,'debit',NULL,420300.0000,NULL,'2024-11-30 16:54:00',1,47094,32555,NULL,NULL,NULL,'2024-11-30 09:54:11','2024-11-30 09:54:11'),
(1827,2,'credit',NULL,274000.0000,NULL,'2024-11-30 18:05:31',106,50851,32558,NULL,NULL,NULL,'2024-11-30 11:06:24','2024-11-30 11:06:24'),
(1828,2,'credit',NULL,30000.0000,NULL,'2024-11-30 18:45:09',106,50709,32559,NULL,NULL,NULL,'2024-11-30 11:45:09','2024-11-30 11:45:09'),
(1829,2,'credit',NULL,50000000.0000,NULL,'2024-11-30 18:57:48',3,38216,32561,NULL,NULL,NULL,'2024-11-30 11:57:48','2025-01-31 05:59:04'),
(1830,2,'credit',NULL,200000.0000,NULL,'2024-11-30 20:25:03',13,50602,32564,NULL,NULL,NULL,'2024-11-30 13:25:03','2024-11-30 13:25:03'),
(1831,2,'credit',NULL,215000.0000,NULL,'2024-11-30 20:25:29',13,50860,32565,NULL,NULL,NULL,'2024-11-30 13:25:29','2024-12-02 06:46:16'),
(1832,2,'credit',NULL,200000.0000,NULL,'2024-12-01 08:40:27',13,42205,32571,NULL,NULL,NULL,'2024-12-01 01:40:27','2025-05-07 01:56:27'),
(1833,2,'credit',NULL,418000.0000,NULL,'2024-12-01 09:16:33',6,49218,32574,NULL,NULL,NULL,'2024-12-01 02:17:01','2024-12-01 02:17:01'),
(1834,2,'credit',NULL,420000.0000,NULL,'2024-12-01 09:40:45',13,49398,32575,NULL,NULL,NULL,'2024-12-01 02:40:46','2024-12-01 02:40:46'),
(1835,2,'credit',NULL,305000.0000,NULL,'2024-12-01 15:14:25',5,50905,32597,NULL,NULL,NULL,'2024-12-01 08:14:25','2024-12-01 08:14:25'),
(1836,2,'credit',NULL,305000.0000,NULL,'2024-12-01 15:15:25',5,50906,32598,NULL,NULL,NULL,'2024-12-01 08:15:25','2024-12-01 08:15:49'),
(1837,2,'credit',NULL,200000.0000,NULL,'2024-12-01 16:40:31',6,50886,32622,NULL,NULL,NULL,'2024-12-01 09:40:31','2024-12-30 06:45:46'),
(1838,2,'credit',NULL,230000.0000,NULL,'2024-12-01 17:35:29',5,50933,32625,NULL,NULL,NULL,'2024-12-01 10:35:29','2024-12-02 14:15:05'),
(1839,2,'credit',NULL,946000.0000,NULL,'2024-12-01 21:16:08',19,50936,32634,NULL,NULL,NULL,'2024-12-01 14:16:08','2024-12-15 02:41:02'),
(1840,2,'credit',NULL,234000.0000,NULL,'2024-12-01 21:40:00',19,50936,32635,NULL,NULL,NULL,'2024-12-01 14:40:44','2024-12-15 02:41:02'),
(1841,2,'credit',NULL,828000.0000,NULL,'2024-12-02 08:52:38',13,50749,32637,NULL,NULL,NULL,'2024-12-02 01:52:38','2024-12-02 01:52:38'),
(1842,2,'credit',NULL,200000.0000,NULL,'2024-12-02 09:40:19',106,50687,32652,NULL,NULL,NULL,'2024-12-02 02:40:19','2024-12-02 02:40:19'),
(1843,2,'credit',NULL,218000.0000,NULL,'2024-12-02 10:19:39',13,50955,32653,NULL,NULL,NULL,'2024-12-02 03:19:39','2024-12-02 03:19:39'),
(1844,2,'credit',NULL,200000.0000,NULL,'2024-12-02 10:28:06',13,50934,32656,NULL,NULL,NULL,'2024-12-02 03:28:06','2024-12-30 04:32:09'),
(1845,2,'credit',NULL,749000.0000,NULL,'2024-12-02 12:15:30',10,50970,32663,NULL,NULL,NULL,'2024-12-02 05:15:30','2024-12-02 05:15:30'),
(1846,2,'credit',NULL,164000.0000,NULL,'2024-12-02 14:47:43',6,50998,32673,NULL,NULL,NULL,'2024-12-02 07:47:43','2024-12-06 01:44:12'),
(1847,2,'credit',NULL,200000.0000,NULL,'2024-12-03 10:23:13',10,50961,32732,NULL,NULL,NULL,'2024-12-03 03:23:13','2024-12-09 08:43:37'),
(1848,2,'credit',NULL,7325000.0000,NULL,'2024-12-03 11:33:45',3,50212,32738,NULL,NULL,NULL,'2024-12-03 04:33:45','2025-04-21 03:00:54'),
(1849,2,'credit',NULL,2325000.0000,NULL,'2024-12-03 11:41:08',3,50861,32740,NULL,NULL,NULL,'2024-12-03 04:41:08','2024-12-30 09:35:51'),
(1850,2,'credit',NULL,200000.0000,NULL,'2024-12-03 17:05:43',3,51054,32762,NULL,NULL,NULL,'2024-12-03 10:05:43','2025-01-01 07:29:06'),
(1851,2,'credit',NULL,500000.0000,NULL,'2024-12-04 08:43:21',5,51115,32774,NULL,NULL,NULL,'2024-12-04 01:43:21','2024-12-04 02:56:41'),
(1852,2,'credit',NULL,120000.0000,NULL,'2024-12-04 12:30:41',3,51135,32787,NULL,NULL,NULL,'2024-12-04 05:30:41','2024-12-17 04:55:40'),
(1853,2,'credit',NULL,80000.0000,NULL,'2024-12-04 13:30:03',106,51123,32804,NULL,NULL,NULL,'2024-12-04 06:30:03','2024-12-05 01:59:10'),
(1854,2,'credit',NULL,400000.0000,NULL,'2024-12-04 13:30:27',106,51137,32805,NULL,NULL,NULL,'2024-12-04 06:30:27','2024-12-04 06:30:27'),
(1855,2,'credit',NULL,639000.0000,NULL,'2024-12-04 15:24:00',19,51151,32812,NULL,NULL,NULL,'2024-12-04 08:24:00','2024-12-15 02:44:48'),
(1856,2,'credit',NULL,200000.0000,NULL,'2024-12-04 15:45:36',3,51124,32818,NULL,NULL,NULL,'2024-12-04 08:45:36','2025-01-01 07:28:49'),
(1857,2,'credit',NULL,185000.0000,NULL,'2024-12-05 11:59:53',10,51194,32846,NULL,NULL,NULL,'2024-12-05 04:59:53','2024-12-05 04:59:53'),
(1858,2,'credit',NULL,200000.0000,NULL,'2024-12-05 15:06:58',13,50958,32878,NULL,NULL,NULL,'2024-12-05 08:06:58','2025-01-01 07:29:29'),
(1859,2,'credit',NULL,200000.0000,NULL,'2024-12-05 15:53:56',93,51026,32879,NULL,NULL,NULL,'2024-12-05 08:53:56','2024-12-29 03:51:54'),
(1860,2,'credit',NULL,4550000.0000,NULL,'2024-12-05 21:13:36',93,51241,32894,NULL,NULL,NULL,'2024-12-05 14:13:36','2024-12-15 02:52:54'),
(1861,2,'debit',NULL,1335000.0000,NULL,'2024-12-07 10:01:00',1,49089,32934,NULL,NULL,NULL,'2024-12-07 03:01:39','2024-12-07 03:01:39'),
(1862,2,'credit',NULL,469000.0000,NULL,'2024-12-07 10:02:29',106,51148,32935,NULL,NULL,NULL,'2024-12-07 03:02:29','2024-12-17 04:58:40'),
(1863,2,'debit',NULL,10789500.0000,NULL,'2024-12-07 10:17:00',1,51208,32936,NULL,NULL,NULL,'2024-12-07 03:17:13','2024-12-07 03:17:13'),
(1864,2,'debit',NULL,6006000.0000,NULL,'2024-12-07 10:27:00',1,50814,32940,NULL,NULL,NULL,'2024-12-07 03:27:48','2024-12-07 03:27:48'),
(1865,2,'credit',NULL,185000.0000,NULL,'2024-12-07 11:04:29',6,51332,32944,NULL,NULL,NULL,'2024-12-07 04:04:29','2024-12-07 04:04:29'),
(1866,2,'credit',NULL,81000.0000,NULL,'2024-12-07 13:20:40',13,51341,32949,NULL,NULL,NULL,'2024-12-07 06:20:40','2024-12-07 06:20:40'),
(1867,2,'credit',NULL,1435000.0000,NULL,'2024-12-07 15:25:10',93,51355,32961,NULL,NULL,NULL,'2024-12-07 08:25:10','2024-12-07 08:25:10'),
(1868,2,'credit',NULL,13500.0000,NULL,'2024-12-07 15:39:33',49,51356,32962,NULL,NULL,NULL,'2024-12-07 08:39:33','2024-12-07 08:39:33'),
(1869,2,'credit',NULL,53000.0000,NULL,'2024-12-07 16:05:40',49,51360,32965,NULL,NULL,NULL,'2024-12-07 09:05:40','2024-12-07 09:05:40'),
(1870,2,'credit',NULL,150000.0000,NULL,'2024-12-07 18:15:14',3,50727,32978,NULL,NULL,NULL,'2024-12-07 11:15:14','2024-12-07 11:15:14'),
(1871,2,'credit',NULL,80000.0000,NULL,'2024-12-08 10:14:32',106,51374,32991,NULL,NULL,NULL,'2024-12-08 03:14:32','2024-12-08 03:48:23'),
(1872,2,'credit',NULL,590000.0000,NULL,'2024-12-08 10:15:20',106,51391,32992,NULL,NULL,NULL,'2024-12-08 03:15:20','2024-12-08 03:15:20'),
(1873,2,'credit',NULL,220000.0000,NULL,'2024-12-08 14:31:40',93,51402,33003,NULL,NULL,NULL,'2024-12-08 07:31:40','2024-12-08 07:31:40'),
(1874,2,'credit',NULL,97000.0000,NULL,'2024-12-08 16:16:18',93,51414,33011,NULL,NULL,NULL,'2024-12-08 09:16:18','2024-12-08 09:16:18'),
(1875,2,'credit',NULL,300000.0000,NULL,'2024-12-09 09:39:33',49,49521,33027,NULL,NULL,NULL,'2024-12-09 02:39:33','2024-12-09 02:39:33'),
(1876,2,'credit',NULL,713000.0000,NULL,'2024-12-09 09:40:22',49,51436,33028,NULL,NULL,NULL,'2024-12-09 02:40:22','2024-12-30 07:45:23'),
(1877,2,'debit',NULL,800000.0000,NULL,'2024-12-09 10:50:00',1,51389,33033,NULL,NULL,NULL,'2024-12-09 03:50:49','2024-12-09 03:50:49'),
(1878,2,'debit',NULL,2300000.0000,NULL,'2024-12-09 10:51:00',1,51367,33034,NULL,NULL,NULL,'2024-12-09 03:51:15','2024-12-09 03:51:15'),
(1879,2,'debit',NULL,6846000.0000,NULL,'2024-12-09 11:09:00',1,51361,33036,NULL,NULL,'2024-12-09 04:28:34','2024-12-09 04:10:04','2024-12-09 04:28:34'),
(1880,2,'debit',NULL,6285000.0000,NULL,'2024-12-09 11:28:00',1,51361,33038,NULL,NULL,NULL,'2024-12-09 04:28:46','2024-12-09 04:28:46'),
(1881,2,'debit',NULL,800000.0000,NULL,'2024-12-09 11:32:00',1,51342,33039,NULL,NULL,NULL,'2024-12-09 04:32:57','2024-12-09 04:32:57'),
(1882,2,'debit',NULL,2400000.0000,NULL,'2024-12-09 11:35:00',1,51072,33040,NULL,NULL,NULL,'2024-12-09 04:35:10','2024-12-09 04:35:10'),
(1883,2,'debit',NULL,800000.0000,NULL,'2024-12-09 11:37:00',1,51319,33043,NULL,NULL,NULL,'2024-12-09 04:38:00','2024-12-09 04:38:00'),
(1884,2,'debit',NULL,800000.0000,NULL,'2024-12-09 11:38:00',1,51281,33044,NULL,NULL,NULL,'2024-12-09 04:38:29','2024-12-09 04:38:29'),
(1885,2,'debit',NULL,800000.0000,NULL,'2024-12-09 11:39:00',1,51213,33045,NULL,NULL,NULL,'2024-12-09 04:39:29','2024-12-09 04:39:29'),
(1886,2,'debit',NULL,17611100.0000,NULL,'2024-12-09 11:50:00',1,51380,33047,NULL,NULL,NULL,'2024-12-09 04:50:41','2024-12-09 04:50:41'),
(1887,2,'debit',NULL,1186000.0000,NULL,'2024-12-09 12:03:00',1,50133,33048,NULL,NULL,NULL,'2024-12-09 05:03:28','2024-12-09 05:03:28'),
(1888,2,'debit',NULL,430000.0000,NULL,'2024-12-09 12:04:00',1,50822,33049,NULL,NULL,NULL,'2024-12-09 05:04:56','2024-12-09 05:04:56'),
(1889,2,'debit',NULL,4959000.0000,NULL,'2024-12-09 12:08:00',1,51181,33050,NULL,NULL,NULL,'2024-12-09 05:08:40','2024-12-09 05:08:40'),
(1890,2,'debit',NULL,5109000.0000,NULL,'2024-12-09 12:09:00',1,51182,33051,NULL,NULL,NULL,'2024-12-09 05:09:09','2024-12-09 05:09:09'),
(1891,2,'debit',NULL,59000.0000,NULL,'2024-12-09 12:31:00',1,51395,33052,NULL,NULL,NULL,'2024-12-09 05:34:56','2024-12-09 05:34:56'),
(1892,2,'debit',NULL,190000.0000,NULL,'2024-12-09 12:54:00',1,51340,33055,NULL,NULL,NULL,'2024-12-09 05:54:35','2024-12-09 05:54:35'),
(1893,2,'debit',NULL,60000.0000,NULL,'2024-12-09 13:05:00',1,51297,33057,NULL,NULL,NULL,'2024-12-09 06:05:40','2024-12-09 06:05:40'),
(1894,2,'debit',NULL,413000.0000,NULL,'2024-12-09 13:07:00',1,51236,33059,NULL,NULL,NULL,'2024-12-09 06:07:38','2024-12-09 06:07:38'),
(1895,2,'debit',NULL,240000.0000,NULL,'2024-12-09 13:09:00',1,51193,33061,NULL,NULL,NULL,'2024-12-09 06:09:21','2024-12-09 06:09:21'),
(1896,2,'debit',NULL,8759100.0000,NULL,'2024-12-09 13:14:00',1,51051,33062,NULL,NULL,NULL,'2024-12-09 06:14:44','2024-12-09 06:14:44'),
(1897,2,'debit',NULL,9900000.0000,NULL,'2024-12-09 13:17:00',1,50630,33063,NULL,NULL,NULL,'2024-12-09 06:17:28','2024-12-09 06:17:28'),
(1898,2,'debit',NULL,4220000.0000,NULL,'2024-12-09 13:18:00',1,50629,33064,NULL,NULL,NULL,'2024-12-09 06:18:28','2024-12-09 06:18:28'),
(1899,2,'credit',NULL,2662490.0000,NULL,'2024-12-09 14:52:13',13,51471,33073,NULL,NULL,'2024-12-30 07:48:46','2024-12-09 07:52:13','2024-12-30 07:48:46'),
(1900,2,'credit',NULL,80000.0000,NULL,'2024-12-09 15:31:55',5,51452,33086,NULL,NULL,NULL,'2024-12-09 08:31:55','2024-12-09 08:31:55'),
(1901,2,'credit',NULL,150000.0000,NULL,'2024-12-09 15:36:41',19,51477,33087,NULL,NULL,NULL,'2024-12-09 08:36:41','2024-12-09 08:36:41'),
(1902,2,'credit',NULL,450000.0000,NULL,'2024-12-09 15:43:37',16,50961,33088,NULL,NULL,NULL,'2024-12-09 08:43:37','2024-12-09 08:43:37'),
(1903,2,'credit',NULL,185000.0000,NULL,'2024-12-09 15:51:06',16,51478,33089,NULL,NULL,'2024-12-09 09:00:31','2024-12-09 08:51:06','2024-12-09 09:00:31'),
(1904,2,'credit',NULL,185000.0000,NULL,'2024-12-09 16:01:33',19,51480,33091,NULL,NULL,'2024-12-09 09:08:44','2024-12-09 09:01:33','2024-12-09 09:08:44'),
(1905,2,'credit',NULL,185000.0000,NULL,'2024-12-09 16:02:41',16,51481,33092,NULL,NULL,NULL,'2024-12-09 09:02:41','2025-01-01 09:11:58'),
(1906,2,'debit',NULL,31752200.0000,NULL,'2024-12-09 16:25:00',1,50516,33096,NULL,NULL,NULL,'2024-12-09 09:25:26','2024-12-09 09:25:26'),
(1907,2,'credit',NULL,38500.0000,NULL,'2024-12-09 17:21:00',6,51498,33105,NULL,NULL,NULL,'2024-12-09 10:21:00','2024-12-09 10:21:00'),
(1908,2,'credit',NULL,200000.0000,NULL,'2024-12-10 08:37:26',49,51444,33127,NULL,NULL,NULL,'2024-12-10 01:37:26','2024-12-10 05:47:43'),
(1909,2,'credit',NULL,1712000.0000,NULL,'2024-12-10 11:02:43',19,51536,33138,NULL,NULL,NULL,'2024-12-10 04:02:43','2024-12-10 04:02:43'),
(1910,2,'credit',NULL,40000.0000,NULL,'2024-12-10 12:17:22',49,51530,33141,NULL,NULL,NULL,'2024-12-10 05:17:22','2024-12-10 05:17:22'),
(1911,2,'credit',NULL,546000.0000,NULL,'2024-12-10 12:39:26',5,51532,33144,NULL,NULL,NULL,'2024-12-10 05:39:26','2024-12-10 05:39:26'),
(1912,2,'credit',NULL,1075000.0000,NULL,'2024-12-10 10:41:57',49,51444,33133,NULL,NULL,NULL,'2024-12-10 05:47:43','2024-12-10 05:47:43'),
(1913,2,'debit',NULL,800000.0000,NULL,'2024-12-10 13:34:00',1,51487,33147,NULL,NULL,NULL,'2024-12-10 06:34:45','2024-12-10 06:34:45'),
(1914,2,'debit',NULL,300200.0000,NULL,'2024-12-10 13:42:00',1,50733,33148,NULL,NULL,NULL,'2024-12-10 06:42:57','2024-12-10 06:42:57'),
(1915,2,'credit',NULL,557000.0000,NULL,'2024-12-10 15:49:29',46,51555,33157,NULL,NULL,NULL,'2024-12-10 08:49:29','2024-12-10 09:36:55'),
(1916,2,'credit',NULL,86000.0000,NULL,'2024-12-10 16:45:28',93,51560,33161,NULL,NULL,'2024-12-30 06:59:52','2024-12-10 09:45:28','2024-12-30 06:59:52'),
(1917,2,'credit',NULL,44000.0000,NULL,'2024-12-10 18:26:29',6,51571,33168,NULL,NULL,NULL,'2024-12-10 11:26:29','2024-12-10 11:26:29'),
(1918,2,'credit',NULL,5154000.0000,NULL,'2024-12-10 18:40:24',106,51573,33169,NULL,NULL,NULL,'2024-12-10 11:40:24','2024-12-10 11:41:30'),
(1919,2,'credit',NULL,1447500.0000,NULL,'2024-12-10 19:29:24',106,51576,33172,NULL,NULL,NULL,'2024-12-10 12:29:24','2024-12-12 06:19:44'),
(1920,2,'credit',NULL,734000.0000,NULL,'2024-12-11 10:23:55',19,51597,33185,NULL,NULL,NULL,'2024-12-11 03:23:55','2024-12-11 03:23:55'),
(1921,2,'credit',NULL,450000.0000,NULL,'2024-12-11 12:15:46',1,51320,33194,NULL,NULL,NULL,'2024-12-11 05:15:46','2024-12-11 05:15:46'),
(1922,2,'debit',NULL,2530000.0000,NULL,'2024-12-11 12:41:00',1,51569,33196,NULL,NULL,NULL,'2024-12-11 05:41:08','2024-12-11 05:41:08'),
(1923,2,'debit',NULL,1800000.0000,NULL,'2024-12-11 12:50:00',1,50852,33198,NULL,NULL,NULL,'2024-12-11 05:50:48','2024-12-11 05:50:48'),
(1924,2,'debit',NULL,7463423.0000,NULL,'2024-12-11 12:53:00',1,50859,33199,NULL,NULL,NULL,'2024-12-11 05:53:19','2024-12-11 05:53:19'),
(1925,2,'debit',NULL,2300000.0000,NULL,'2024-12-11 14:24:00',1,51494,33212,NULL,NULL,NULL,'2024-12-11 07:24:29','2024-12-11 07:24:29'),
(1926,2,'debit',NULL,1520000.0000,NULL,'2024-12-11 14:24:00',1,51535,33213,NULL,NULL,NULL,'2024-12-11 07:24:49','2024-12-11 07:24:49'),
(1927,2,'credit',NULL,275000.0000,NULL,'2024-12-11 16:54:37',19,51638,33225,NULL,NULL,NULL,'2024-12-11 09:54:37','2024-12-11 09:54:37'),
(1928,2,'credit',NULL,1447500.0000,NULL,'2024-12-12 08:38:33',49,51576,33236,NULL,NULL,NULL,'2024-12-12 01:38:33','2024-12-12 06:19:44'),
(1929,2,'credit',NULL,1034000.0000,NULL,'2024-12-12 08:51:10',5,51094,33237,NULL,NULL,NULL,'2024-12-12 01:51:10','2024-12-30 06:19:51'),
(1930,2,'credit',NULL,2366000.0000,NULL,'2024-12-12 09:44:02',5,51076,33240,NULL,NULL,NULL,'2024-12-12 02:44:34','2024-12-30 10:55:14'),
(1931,2,'credit',NULL,627000.0000,NULL,'2024-12-12 20:19:31',6,51724,33280,NULL,NULL,NULL,'2024-12-12 13:19:31','2024-12-30 07:05:00'),
(1932,2,'credit',NULL,1175000.0000,NULL,'2024-12-13 11:35:47',19,51761,33308,NULL,NULL,NULL,'2024-12-13 04:35:47','2024-12-13 04:35:47'),
(1933,2,'credit',NULL,150000.0000,NULL,'2024-12-13 15:42:09',49,51708,33315,NULL,NULL,NULL,'2024-12-13 08:42:09','2024-12-13 08:42:09'),
(1934,2,'credit',NULL,200000.0000,NULL,'2024-12-13 15:51:04',5,51759,33316,NULL,NULL,NULL,'2024-12-13 08:51:04','2024-12-14 05:18:03'),
(1935,2,'credit',NULL,15000.0000,NULL,'2024-12-13 17:35:44',13,51785,33321,NULL,NULL,NULL,'2024-12-13 10:35:44','2024-12-13 10:35:44'),
(1936,2,'credit',NULL,120000.0000,NULL,'2024-12-13 19:47:14',13,51577,33330,NULL,NULL,NULL,'2024-12-13 12:47:14','2024-12-13 12:47:14'),
(1937,2,'credit',NULL,131000.0000,NULL,'2024-12-13 20:25:53',13,51803,33331,NULL,NULL,NULL,'2024-12-13 13:26:46','2024-12-14 05:30:57'),
(1938,2,'credit',NULL,155000.0000,NULL,'2024-12-14 19:22:42',106,51857,33372,NULL,NULL,NULL,'2024-12-14 12:22:42','2024-12-14 12:22:42'),
(1939,2,'credit',NULL,1682500.0000,NULL,'2024-12-14 21:46:12',3,51873,33380,NULL,NULL,NULL,'2024-12-14 14:46:12','2025-01-01 06:44:04'),
(1940,2,'credit',NULL,190000.0000,NULL,'2024-12-14 21:47:18',3,51850,33381,NULL,NULL,NULL,'2024-12-14 14:47:18','2024-12-22 11:15:55'),
(1941,2,'credit',NULL,65000.0000,NULL,'2024-12-15 13:50:41',46,51906,33405,NULL,NULL,NULL,'2024-12-15 06:50:41','2024-12-15 06:50:41'),
(1942,2,'credit',NULL,200000.0000,NULL,'2024-12-16 13:29:44',93,51868,33437,NULL,NULL,NULL,'2024-12-16 06:29:44','2025-02-01 12:32:41'),
(1943,2,'debit',NULL,5553500.0000,NULL,'2024-12-16 13:57:00',1,51887,33438,NULL,NULL,NULL,'2024-12-16 06:57:44','2024-12-16 06:57:44'),
(1944,2,'debit',NULL,4420000.0000,NULL,'2024-12-16 13:57:00',1,51885,33439,NULL,NULL,NULL,'2024-12-16 06:57:57','2024-12-16 06:57:57'),
(1945,2,'debit',NULL,6300000.0000,NULL,'2024-12-16 14:01:00',1,51966,33440,NULL,NULL,NULL,'2024-12-16 07:01:32','2024-12-16 07:01:32'),
(1946,2,'debit',NULL,360000.0000,NULL,'2024-12-16 14:03:00',1,51609,33441,NULL,NULL,NULL,'2024-12-16 07:03:52','2024-12-16 07:03:52'),
(1947,2,'debit',NULL,225000.0000,NULL,'2024-12-16 14:04:00',1,51627,33442,NULL,NULL,NULL,'2024-12-16 07:04:29','2024-12-16 07:04:29'),
(1948,2,'credit',NULL,181000.0000,NULL,'2024-12-16 14:09:26',93,51970,33443,NULL,NULL,NULL,'2024-12-16 07:09:26','2024-12-16 07:09:26'),
(1949,2,'debit',NULL,18308700.0000,NULL,'2024-12-16 14:11:00',1,51675,33444,NULL,NULL,NULL,'2024-12-16 07:11:32','2024-12-16 07:11:32'),
(1950,2,'debit',NULL,139440.0000,NULL,'2024-12-16 14:30:00',1,51677,33446,NULL,NULL,NULL,'2024-12-16 07:30:46','2024-12-16 07:30:46'),
(1951,2,'debit',NULL,8000000.0000,NULL,'2024-12-16 14:35:00',1,51682,33447,NULL,NULL,NULL,'2024-12-16 07:35:57','2024-12-16 07:35:57'),
(1952,2,'credit',NULL,317000.0000,NULL,'2024-12-16 15:20:41',6,51976,33450,NULL,NULL,NULL,'2024-12-16 08:20:41','2024-12-16 08:20:41'),
(1953,2,'credit',NULL,848000.0000,NULL,'2024-12-16 19:54:30',19,51995,33466,NULL,NULL,NULL,'2024-12-16 12:54:30','2024-12-16 12:54:30'),
(1954,2,'credit',NULL,65000.0000,NULL,'2024-12-17 09:44:04',6,52011,33477,NULL,NULL,NULL,'2024-12-17 02:44:04','2024-12-17 02:44:04'),
(1955,2,'credit',NULL,1175000.0000,NULL,'2024-12-17 12:42:45',93,52023,33485,NULL,NULL,NULL,'2024-12-17 05:42:45','2024-12-25 09:10:51'),
(1956,2,'credit',NULL,620000.0000,NULL,'2024-12-17 12:44:36',6,52025,33486,NULL,NULL,NULL,'2024-12-17 05:44:36','2024-12-17 05:44:36'),
(1957,2,'credit',NULL,584000.0000,NULL,'2024-12-17 12:58:16',6,52028,33489,NULL,NULL,NULL,'2024-12-17 05:58:16','2024-12-17 05:58:16'),
(1958,2,'credit',NULL,35000.0000,NULL,'2024-12-17 20:49:21',19,52066,33524,NULL,NULL,NULL,'2024-12-17 13:49:21','2024-12-17 13:49:21'),
(1959,2,'credit',NULL,92000.0000,NULL,'2024-12-18 10:12:45',6,52076,33528,NULL,NULL,NULL,'2024-12-18 03:12:45','2024-12-18 03:12:45'),
(1960,2,'credit',NULL,11000.0000,NULL,'2024-12-18 16:51:15',13,52100,33553,NULL,NULL,NULL,'2024-12-18 09:51:15','2024-12-18 09:51:15'),
(1961,2,'credit',NULL,520000.0000,NULL,'2024-12-18 17:09:46',93,52104,33557,NULL,NULL,'2024-12-19 05:07:49','2024-12-18 10:09:46','2024-12-19 05:07:49'),
(1962,2,'credit',NULL,134000.0000,NULL,'2024-12-18 17:10:46',93,52105,33558,NULL,NULL,'2024-12-19 05:08:00','2024-12-18 10:10:46','2024-12-19 05:08:00'),
(1963,2,'credit',NULL,250000.0000,NULL,'2024-12-18 17:20:36',5,51989,33559,NULL,NULL,NULL,'2024-12-18 10:20:36','2024-12-18 10:20:36'),
(1964,2,'credit',NULL,572000.0000,NULL,'2024-12-18 20:25:32',93,52115,33567,NULL,NULL,NULL,'2024-12-18 13:25:32','2024-12-18 13:25:32'),
(1965,2,'credit',NULL,5580000.0000,NULL,'2024-12-19 12:09:43',13,52135,33584,NULL,NULL,NULL,'2024-12-19 05:09:43','2024-12-19 05:09:43'),
(1966,2,'credit',NULL,250000.0000,NULL,'2024-12-19 14:37:00',13,51975,33586,NULL,NULL,NULL,'2024-12-19 07:37:00','2024-12-19 07:37:00'),
(1967,2,'credit',NULL,310000.0000,NULL,'2024-12-19 16:57:13',6,52145,33591,NULL,NULL,NULL,'2024-12-19 09:57:13','2024-12-19 09:57:13'),
(1968,2,'credit',NULL,1000000.0000,NULL,'2024-12-20 11:22:31',6,52182,33617,NULL,NULL,NULL,'2024-12-20 04:22:31','2024-12-20 10:22:36'),
(1969,2,'credit',NULL,717000.0000,NULL,'2024-12-20 16:57:03',3,52206,33633,NULL,NULL,NULL,'2024-12-20 09:57:03','2024-12-20 09:57:03'),
(1970,2,'credit',NULL,955000.0000,NULL,'2024-12-20 17:22:36',93,52182,33637,NULL,NULL,NULL,'2024-12-20 10:22:36','2024-12-20 10:22:36'),
(1971,2,'credit',NULL,1993000.0000,NULL,'2024-12-20 17:30:54',5,51641,33641,NULL,NULL,NULL,'2024-12-20 10:30:54','2024-12-20 10:30:54'),
(1972,2,'credit',NULL,1325000.0000,NULL,'2024-12-20 19:26:01',106,52221,33648,NULL,NULL,NULL,'2024-12-20 12:26:01','2024-12-28 14:09:59'),
(1973,2,'credit',NULL,415000.0000,NULL,'2024-12-21 10:25:48',6,52244,33666,NULL,NULL,NULL,'2024-12-21 03:25:48','2024-12-21 03:25:48'),
(1974,2,'credit',NULL,92000.0000,NULL,'2024-12-21 11:41:03',6,52248,33668,NULL,NULL,NULL,'2024-12-21 04:41:03','2024-12-21 04:41:03'),
(1975,2,'credit',NULL,175000.0000,NULL,'2024-12-21 17:39:36',106,52274,33686,NULL,NULL,NULL,'2024-12-21 10:39:36','2024-12-21 10:39:36'),
(1976,2,'credit',NULL,10000.0000,NULL,'2024-12-21 20:44:48',93,52291,33696,NULL,NULL,NULL,'2024-12-21 13:44:48','2024-12-21 13:44:48'),
(1977,2,'credit',NULL,7190000.0000,NULL,'2024-12-21 21:19:04',93,52294,33699,NULL,NULL,NULL,'2024-12-21 14:19:04','2024-12-21 14:19:04'),
(1978,2,'credit',NULL,120000.0000,NULL,'2024-12-22 12:38:12',5,52289,33710,NULL,NULL,NULL,'2024-12-22 05:38:12','2024-12-22 09:53:24'),
(1979,2,'credit',NULL,450000.0000,NULL,'2024-12-22 12:38:27',5,52288,33711,NULL,NULL,NULL,'2024-12-22 05:38:27','2024-12-22 09:53:09'),
(1980,2,'credit',NULL,1366700.0000,NULL,'2024-12-22 17:30:40',3,52315,33718,NULL,NULL,NULL,'2024-12-22 10:30:40','2024-12-22 10:30:40'),
(1981,2,'credit',NULL,1366600.0000,NULL,'2024-12-22 17:32:11',3,52316,33719,NULL,NULL,NULL,'2024-12-22 10:32:11','2024-12-22 10:32:11'),
(1982,2,'credit',NULL,1366700.0000,NULL,'2024-12-22 17:34:25',3,52318,33721,NULL,NULL,NULL,'2024-12-22 10:34:25','2024-12-22 10:34:25'),
(1983,2,'credit',NULL,345000.0000,NULL,'2024-12-22 17:55:50',3,52320,33724,NULL,NULL,NULL,'2024-12-22 10:55:50','2024-12-22 10:55:50'),
(1984,2,'credit',NULL,345000.0000,NULL,'2024-12-22 17:55:56',3,52321,33725,NULL,NULL,NULL,'2024-12-22 10:55:56','2024-12-22 10:55:56'),
(1985,2,'credit',NULL,150000.0000,NULL,'2024-12-22 18:13:38',3,52323,33728,NULL,NULL,NULL,'2024-12-22 11:13:38','2024-12-22 11:13:38'),
(1986,2,'credit',NULL,150000.0000,NULL,'2024-12-22 18:13:44',3,52324,33729,NULL,NULL,NULL,'2024-12-22 11:13:44','2024-12-22 11:13:44'),
(1987,2,'credit',NULL,80000.0000,NULL,'2024-12-22 18:16:32',3,52325,33731,NULL,NULL,NULL,'2024-12-22 11:16:32','2024-12-22 11:16:32'),
(1988,2,'credit',NULL,80000.0000,NULL,'2024-12-22 18:16:53',3,52326,33732,NULL,NULL,NULL,'2024-12-22 11:16:53','2024-12-22 11:16:53'),
(1989,2,'credit',NULL,125000.0000,NULL,'2024-12-22 19:02:17',3,52227,33734,NULL,NULL,NULL,'2024-12-22 12:02:17','2025-03-28 03:12:11'),
(1990,2,'credit',NULL,305000.0000,NULL,'2024-12-23 09:01:36',46,52343,33748,NULL,NULL,NULL,'2024-12-23 02:01:36','2024-12-23 02:01:36'),
(1991,2,'credit',NULL,193000.0000,NULL,'2024-12-23 13:24:28',6,52364,33758,NULL,NULL,NULL,'2024-12-23 06:24:28','2024-12-23 06:24:28'),
(1992,2,'credit',NULL,519000.0000,NULL,'2024-12-23 14:20:29',6,52367,33761,NULL,NULL,NULL,'2024-12-23 07:20:29','2024-12-23 07:20:29'),
(1993,2,'credit',NULL,400000.0000,NULL,'2024-12-23 18:30:41',93,52388,33778,NULL,NULL,NULL,'2024-12-23 11:30:41','2024-12-23 11:30:41'),
(1994,2,'credit',NULL,25000.0000,NULL,'2024-12-24 11:03:36',10,52412,33798,NULL,NULL,NULL,'2024-12-24 04:03:36','2024-12-24 04:03:36'),
(1995,2,'credit',NULL,0.0000,NULL,'2024-12-24 13:01:37',19,52349,33805,NULL,NULL,NULL,'2024-12-24 06:01:37','2025-02-16 07:38:04'),
(1996,2,'credit',NULL,2025000.0000,NULL,'2024-12-24 15:00:42',3,52389,33812,NULL,NULL,NULL,'2024-12-24 08:00:42','2024-12-24 08:00:42'),
(1997,2,'credit',NULL,500000.0000,NULL,'2024-12-24 17:32:30',93,52358,33825,NULL,NULL,NULL,'2024-12-24 10:32:30','2024-12-24 10:32:30'),
(1998,2,'credit',NULL,120000.0000,NULL,'2024-12-24 17:33:09',93,52448,33826,NULL,NULL,NULL,'2024-12-24 10:33:09','2024-12-24 10:33:09'),
(1999,2,'credit',NULL,3522585.0000,NULL,'2024-12-24 18:35:48',3,49276,33830,NULL,NULL,NULL,'2024-12-24 11:35:48','2024-12-24 13:28:54'),
(2000,2,'credit',NULL,200000.0000,NULL,'2024-12-24 19:13:49',6,52373,33836,NULL,NULL,NULL,'2024-12-24 12:13:49','2025-02-11 02:57:07'),
(2001,2,'credit',NULL,1748000.0000,NULL,'2024-12-24 20:43:41',6,52466,33843,NULL,NULL,NULL,'2024-12-24 13:43:41','2024-12-24 13:43:41'),
(2002,2,'credit',NULL,5173000.0000,NULL,'2024-12-24 21:40:55',13,52471,33845,NULL,NULL,NULL,'2024-12-24 14:40:55','2024-12-24 14:40:55'),
(2003,2,'credit',NULL,110000.0000,NULL,'2024-12-25 09:13:48',19,52478,33847,NULL,NULL,NULL,'2024-12-25 02:13:48','2024-12-25 02:13:48'),
(2004,2,'credit',NULL,160000.0000,NULL,'2024-12-25 09:57:27',49,52346,33849,NULL,NULL,NULL,'2024-12-25 02:57:27','2024-12-25 02:57:27'),
(2005,2,'credit',NULL,492000.0000,NULL,'2024-12-25 10:51:00',19,52425,33851,NULL,NULL,NULL,'2024-12-25 03:51:49','2024-12-25 03:51:49'),
(2006,2,'credit',NULL,46000.0000,NULL,'2024-12-25 11:44:32',49,52486,33852,NULL,NULL,NULL,'2024-12-25 04:44:32','2024-12-25 04:44:32'),
(2007,2,'credit',NULL,140000.0000,NULL,'2024-12-25 11:47:43',5,52487,33853,NULL,NULL,NULL,'2024-12-25 04:47:54','2024-12-25 04:47:54'),
(2008,2,'credit',NULL,2511000.0000,NULL,'2024-12-25 12:21:18',5,52488,33854,NULL,NULL,'2024-12-26 14:04:44','2024-12-25 05:21:18','2024-12-26 14:04:44'),
(2009,2,'credit',NULL,26000.0000,NULL,'2024-12-25 12:54:22',46,52489,33855,NULL,NULL,NULL,'2024-12-25 05:54:22','2024-12-25 05:54:22'),
(2010,2,'credit',NULL,150000.0000,NULL,'2024-12-25 15:57:18',19,52506,33864,NULL,NULL,NULL,'2024-12-25 08:57:18','2024-12-25 08:57:18'),
(2011,2,'credit',NULL,350000.0000,NULL,'2024-12-25 16:09:45',19,51824,33866,NULL,NULL,NULL,'2024-12-25 09:09:45','2024-12-25 09:09:45'),
(2012,2,'credit',NULL,1175000.0000,NULL,'2024-12-25 16:10:51',19,52023,33867,NULL,NULL,NULL,'2024-12-25 09:10:51','2024-12-25 09:10:51'),
(2013,2,'credit',NULL,2700000.0000,NULL,'2024-12-25 16:15:58',19,52508,33868,NULL,NULL,'2024-12-25 09:21:42','2024-12-25 09:15:58','2024-12-25 09:21:42'),
(2014,2,'credit',NULL,220000.0000,NULL,'2024-12-25 16:57:25',49,52510,33869,NULL,NULL,NULL,'2024-12-25 09:57:25','2024-12-25 09:57:25'),
(2015,2,'credit',NULL,120000.0000,NULL,'2024-12-25 17:22:48',93,52226,33870,NULL,NULL,NULL,'2024-12-25 10:22:48','2024-12-25 10:22:48'),
(2016,2,'credit',NULL,92000.0000,NULL,'2024-12-25 17:23:36',93,52511,33871,NULL,NULL,NULL,'2024-12-25 10:23:36','2024-12-25 10:23:36'),
(2017,2,'credit',NULL,175000.0000,NULL,'2024-12-25 19:08:05',93,52517,33875,NULL,NULL,NULL,'2024-12-25 12:08:05','2024-12-25 12:08:05'),
(2018,2,'credit',NULL,165000.0000,NULL,'2024-12-25 21:37:22',93,52520,33879,NULL,NULL,NULL,'2024-12-25 14:37:22','2024-12-25 14:37:22'),
(2019,2,'credit',NULL,21000.0000,NULL,'2024-12-26 09:18:00',49,52525,33883,NULL,NULL,NULL,'2024-12-26 02:18:00','2024-12-26 02:18:00'),
(2020,2,'credit',NULL,550000.0000,NULL,'2024-12-26 12:52:21',49,52524,33890,NULL,NULL,NULL,'2024-12-26 05:52:21','2024-12-26 05:52:21'),
(2021,2,'credit',NULL,1755000.0000,NULL,'2024-12-26 13:15:03',93,52544,33891,NULL,NULL,NULL,'2024-12-26 06:15:03','2024-12-26 06:15:03'),
(2022,2,'credit',NULL,1956000.0000,NULL,'2024-12-26 15:33:04',13,52553,33899,NULL,NULL,NULL,'2024-12-26 08:33:04','2024-12-26 08:33:04'),
(2023,2,'credit',NULL,372000.0000,NULL,'2024-12-26 17:25:07',106,52560,33902,NULL,NULL,NULL,'2024-12-26 10:25:07','2024-12-26 10:25:07'),
(2024,2,'credit',NULL,480000.0000,NULL,'2024-12-26 19:17:06',6,52563,33905,NULL,NULL,NULL,'2024-12-26 12:17:06','2024-12-26 12:17:06'),
(2025,2,'credit',NULL,330000.0000,NULL,'2024-12-26 19:20:35',6,52564,33906,NULL,NULL,NULL,'2024-12-26 12:20:35','2024-12-26 12:20:35'),
(2026,2,'credit',NULL,500000.0000,NULL,'2024-12-26 19:36:32',6,52565,33907,NULL,NULL,NULL,'2024-12-26 12:36:32','2024-12-27 11:20:05'),
(2027,2,'credit',NULL,2511000.0000,NULL,'2024-12-26 20:58:03',13,52546,33910,NULL,NULL,NULL,'2024-12-26 13:58:03','2025-01-16 07:04:05'),
(2028,2,'credit',NULL,261000.0000,NULL,'2024-12-26 21:05:55',106,52569,33911,NULL,NULL,NULL,'2024-12-26 14:05:55','2024-12-26 14:05:55'),
(2029,2,'credit',NULL,16100.0000,NULL,'2024-12-26 21:42:18',13,52546,33913,NULL,NULL,NULL,'2024-12-26 14:43:10','2025-01-16 07:04:05'),
(2030,2,'credit',NULL,24000.0000,NULL,'2024-12-27 13:27:49',6,52587,33923,NULL,NULL,NULL,'2024-12-27 06:27:49','2024-12-27 06:27:49'),
(2031,2,'credit',NULL,560000.0000,NULL,'2024-12-27 18:19:43',6,52565,33934,NULL,NULL,NULL,'2024-12-27 11:19:43','2024-12-27 11:20:05'),
(2032,2,'credit',NULL,3901000.0000,NULL,'2024-12-27 18:25:05',13,52443,33935,NULL,NULL,NULL,'2024-12-27 11:25:05','2024-12-27 11:25:05'),
(2033,2,'credit',NULL,112000.0000,NULL,'2024-12-28 09:02:54',106,52614,33943,NULL,NULL,NULL,'2024-12-28 02:02:54','2024-12-28 02:02:54'),
(2034,2,'credit',NULL,220000.0000,NULL,'2024-12-28 09:07:01',106,52418,33944,NULL,NULL,NULL,'2024-12-28 02:07:01','2024-12-28 02:28:57'),
(2035,2,'credit',NULL,536000.0000,NULL,'2024-12-28 09:08:17',106,52615,33945,NULL,NULL,NULL,'2024-12-28 02:08:17','2024-12-28 02:08:17'),
(2036,2,'credit',NULL,55000.0000,NULL,'2024-12-28 11:56:00',19,52625,33950,NULL,NULL,NULL,'2024-12-28 04:56:14','2024-12-28 04:56:14'),
(2037,2,'credit',NULL,100000.0000,NULL,'2024-12-28 13:16:04',13,52630,33951,NULL,NULL,NULL,'2024-12-28 06:16:04','2024-12-31 03:58:42'),
(2038,2,'credit',NULL,2917000.0000,NULL,'2024-12-28 14:36:16',13,52639,33956,NULL,NULL,NULL,'2024-12-28 07:36:16','2024-12-30 09:11:20'),
(2039,2,'credit',NULL,300000.0000,NULL,'2024-12-28 16:20:21',106,52590,33964,NULL,NULL,NULL,'2024-12-28 09:20:21','2024-12-28 09:20:21'),
(2040,2,'credit',NULL,87000.0000,NULL,'2024-12-28 17:36:06',13,52652,33974,NULL,NULL,NULL,'2024-12-28 10:36:06','2024-12-28 10:36:06'),
(2041,2,'credit',NULL,250000.0000,NULL,'2024-12-28 17:40:33',3,52512,33975,NULL,NULL,NULL,'2024-12-28 10:40:33','2024-12-28 10:40:33'),
(2042,2,'credit',NULL,295000.0000,NULL,'2024-12-28 18:01:08',13,52495,33976,NULL,NULL,NULL,'2024-12-28 11:01:08','2024-12-28 11:01:08'),
(2043,2,'credit',NULL,470000.0000,NULL,'2024-12-28 20:29:37',13,52395,33980,NULL,NULL,NULL,'2024-12-28 13:29:37','2024-12-28 13:29:37'),
(2044,2,'credit',NULL,140000.0000,NULL,'2024-12-28 20:30:06',13,52661,33981,NULL,NULL,NULL,'2024-12-28 13:30:06','2024-12-28 13:30:06'),
(2045,2,'credit',NULL,35000.0000,NULL,'2024-12-28 20:45:10',13,52663,33982,NULL,NULL,NULL,'2024-12-28 13:45:10','2024-12-28 13:45:10'),
(2046,2,'credit',NULL,1000000.0000,NULL,'2024-12-28 21:09:59',93,52221,33983,NULL,NULL,NULL,'2024-12-28 14:09:59','2024-12-28 14:09:59'),
(2047,2,'credit',NULL,1405000.0000,NULL,'2024-12-28 21:30:39',13,52665,33984,NULL,NULL,NULL,'2024-12-28 14:30:39','2024-12-28 14:30:39'),
(2048,2,'credit',NULL,30500.0000,NULL,'2024-12-29 09:58:01',3,52668,33987,NULL,NULL,NULL,'2024-12-29 02:58:01','2024-12-29 02:58:01'),
(2049,2,'credit',NULL,1150000.0000,NULL,'2024-12-29 10:51:54',19,51026,33992,NULL,NULL,NULL,'2024-12-29 03:51:54','2024-12-29 03:51:54'),
(2050,2,'credit',NULL,300000.0000,NULL,'2024-12-29 11:24:33',3,52673,33996,NULL,NULL,NULL,'2024-12-29 04:24:33','2024-12-29 04:24:33'),
(2051,2,'credit',NULL,300000.0000,NULL,'2024-12-29 11:24:38',3,52674,33997,NULL,NULL,NULL,'2024-12-29 04:24:38','2024-12-29 04:24:38'),
(2052,2,'credit',NULL,595000.0000,NULL,'2024-12-29 11:46:04',3,52677,34001,NULL,NULL,NULL,'2024-12-29 04:46:04','2024-12-29 04:46:04'),
(2053,2,'credit',NULL,595000.0000,NULL,'2024-12-29 11:46:10',3,52678,34002,NULL,NULL,NULL,'2024-12-29 04:46:10','2024-12-29 04:46:10'),
(2054,2,'credit',NULL,1474000.0000,NULL,'2024-12-29 13:01:11',3,52662,34004,NULL,NULL,NULL,'2024-12-29 06:01:11','2024-12-29 06:01:11'),
(2055,2,'credit',NULL,200000.0000,NULL,'2024-12-29 13:24:24',49,52667,34006,NULL,NULL,NULL,'2024-12-29 06:24:24','2025-01-02 12:56:23'),
(2056,2,'credit',NULL,294000.0000,NULL,'2024-12-29 14:37:56',106,52680,34007,NULL,NULL,NULL,'2024-12-29 07:37:56','2024-12-29 07:37:56'),
(2057,2,'credit',NULL,197000.0000,NULL,'2024-12-29 15:51:29',49,52685,34012,NULL,NULL,NULL,'2024-12-29 08:51:29','2024-12-29 08:51:29'),
(2058,2,'credit',NULL,1459000.0000,NULL,'2024-12-29 20:37:29',49,52688,34025,NULL,NULL,NULL,'2024-12-29 13:37:29','2025-01-01 07:12:16'),
(2059,2,'credit',NULL,620000.0000,NULL,'2024-12-30 08:48:58',10,52701,34030,NULL,NULL,NULL,'2024-12-30 01:48:58','2024-12-30 01:48:58'),
(2060,2,'credit',NULL,200000.0000,NULL,'2024-12-30 09:48:12',19,50704,34035,NULL,NULL,NULL,'2024-12-30 02:48:12','2024-12-30 02:48:12'),
(2061,2,'credit',NULL,1210000.0000,NULL,'2024-12-30 09:49:42',19,52705,34036,NULL,NULL,NULL,'2024-12-30 02:49:42','2024-12-30 02:49:42'),
(2062,2,'credit',NULL,200000.0000,NULL,'2024-12-30 12:30:17',19,52578,34054,NULL,NULL,NULL,'2024-12-30 05:30:17','2024-12-30 05:30:17'),
(2063,2,'credit',NULL,800000.0000,NULL,'2024-12-30 13:19:06',13,51018,34059,NULL,NULL,NULL,'2024-12-30 06:19:06','2024-12-30 06:19:06'),
(2064,2,'credit',NULL,125000.0000,NULL,'2024-12-30 14:04:18',6,52747,34066,NULL,NULL,NULL,'2024-12-30 07:04:18','2024-12-30 07:04:18'),
(2065,2,'credit',NULL,125000.0000,NULL,'2024-12-30 14:04:43',6,52748,34067,NULL,NULL,NULL,'2024-12-30 07:04:43','2024-12-30 07:04:43'),
(2066,2,'credit',NULL,1171080.0000,NULL,'2024-12-30 14:42:09',3,52762,34071,NULL,NULL,NULL,'2024-12-30 07:42:09','2025-01-16 07:35:57'),
(2067,2,'credit',NULL,215000.0000,NULL,'2024-12-30 15:05:15',5,52765,34075,NULL,NULL,NULL,'2024-12-30 08:05:15','2024-12-30 08:05:15'),
(2068,2,'credit',NULL,365000.0000,NULL,'2024-12-30 15:10:22',93,52766,34076,NULL,NULL,NULL,'2024-12-30 08:10:22','2024-12-30 08:10:22'),
(2069,2,'credit',NULL,27000.0000,NULL,'2024-12-30 16:54:34',13,52776,34080,NULL,NULL,NULL,'2024-12-30 09:54:34','2024-12-30 09:54:34'),
(2070,2,'credit',NULL,95000.0000,NULL,'2024-12-30 16:55:13',13,52558,34081,NULL,NULL,NULL,'2024-12-30 09:55:13','2024-12-30 09:55:13'),
(2071,2,'credit',NULL,325000.0000,NULL,'2024-12-30 17:53:23',93,52780,34083,NULL,NULL,NULL,'2024-12-30 10:53:23','2024-12-30 10:53:23'),
(2072,2,'credit',NULL,1560000.0000,NULL,'2024-12-30 18:42:46',93,52784,34087,NULL,NULL,NULL,'2024-12-30 11:42:46','2024-12-30 11:42:46'),
(2073,2,'credit',NULL,1959000.0000,NULL,'2024-12-30 21:34:58',49,52688,34093,NULL,NULL,NULL,'2024-12-30 14:34:58','2025-01-01 07:12:16'),
(2074,2,'debit',NULL,16520000.0000,NULL,'2024-12-30 23:09:00',1,49552,34094,NULL,NULL,NULL,'2024-12-30 16:09:58','2024-12-30 16:09:58'),
(2075,2,'credit',NULL,379000.0000,NULL,'2024-12-31 09:48:21',49,52827,34105,NULL,NULL,NULL,'2024-12-31 02:48:21','2024-12-31 02:48:21'),
(2076,2,'credit',NULL,701000.0000,NULL,'2024-12-31 11:50:45',5,52831,34110,NULL,NULL,NULL,'2024-12-31 04:50:45','2025-01-01 06:45:53'),
(2077,2,'credit',NULL,836500.0000,NULL,'2024-12-31 13:03:38',3,52410,34135,NULL,NULL,NULL,'2024-12-31 06:03:38','2024-12-31 08:14:22'),
(2078,2,'credit',NULL,1600000.0000,NULL,'2024-12-31 13:26:19',93,52840,34136,NULL,NULL,NULL,'2024-12-31 06:26:19','2024-12-31 06:29:23'),
(2079,2,'credit',NULL,170000.0000,NULL,'2024-12-31 13:29:05',93,52841,34137,NULL,NULL,NULL,'2024-12-31 06:29:05','2024-12-31 06:29:05'),
(2080,2,'credit',NULL,836500.0000,NULL,'2024-12-31 15:13:00',5,52410,34141,NULL,NULL,NULL,'2024-12-31 08:13:00','2024-12-31 08:14:22'),
(2081,2,'credit',NULL,75000.0000,NULL,'2024-12-31 15:14:59',5,52852,34143,NULL,NULL,NULL,'2024-12-31 08:14:59','2024-12-31 08:14:59'),
(2082,2,'credit',NULL,75000.0000,NULL,'2024-12-31 15:15:26',5,52853,34144,NULL,NULL,NULL,'2024-12-31 08:15:26','2024-12-31 08:15:26'),
(2083,2,'credit',NULL,1360000.0000,NULL,'2024-12-31 15:24:19',3,52855,34145,NULL,NULL,NULL,'2024-12-31 08:24:19','2024-12-31 08:24:19'),
(2084,2,'debit',NULL,53519500.0000,NULL,'2024-12-31 16:50:00',1,51856,34160,NULL,NULL,NULL,'2024-12-31 09:50:38','2024-12-31 09:50:38'),
(2085,2,'credit',NULL,438000.0000,NULL,'2025-01-01 14:09:31',5,52870,34170,NULL,NULL,NULL,'2025-01-01 07:09:31','2025-01-01 07:09:31'),
(2086,2,'credit',NULL,437000.0000,NULL,'2025-01-01 14:10:21',5,52871,34171,NULL,NULL,NULL,'2025-01-01 07:10:21','2025-01-01 07:10:21'),
(2087,2,'credit',NULL,1082000.0000,NULL,'2025-01-01 16:32:30',3,52286,34178,NULL,NULL,NULL,'2025-01-01 09:32:30','2025-01-06 01:36:24'),
(2088,2,'credit',NULL,120000.0000,NULL,'2025-01-02 15:07:57',13,52869,34232,NULL,NULL,NULL,'2025-01-02 08:07:57','2025-01-02 08:07:57'),
(2089,2,'credit',NULL,400000.0000,NULL,'2025-01-02 15:08:31',13,52935,34233,NULL,NULL,NULL,'2025-01-02 08:08:31','2025-01-02 08:08:31'),
(2090,2,'credit',NULL,392500.0000,NULL,'2025-01-02 15:12:30',5,39613,34234,NULL,NULL,NULL,'2025-01-02 08:12:30','2025-02-04 11:44:45'),
(2091,2,'credit',NULL,98000.0000,NULL,'2025-01-02 15:18:32',13,52937,34235,NULL,NULL,NULL,'2025-01-02 08:18:32','2025-01-02 08:18:32'),
(2092,2,'credit',NULL,174000.0000,NULL,'2025-01-02 16:58:48',13,52944,34241,NULL,NULL,NULL,'2025-01-02 09:58:48','2025-01-02 09:58:48'),
(2093,2,'debit',NULL,25137500.0000,NULL,'2025-01-03 11:06:00',19,52974,34268,NULL,NULL,'2025-01-03 04:18:46','2025-01-03 04:14:46','2025-01-03 04:18:46'),
(2094,2,'debit',NULL,26387500.0000,NULL,'2025-01-03 11:19:00',19,52974,34270,NULL,NULL,NULL,'2025-01-03 04:19:38','2025-01-03 04:19:38'),
(2095,2,'credit',NULL,2499000.0000,NULL,'2025-01-03 15:40:26',49,52991,34282,NULL,NULL,NULL,'2025-01-03 08:40:26','2025-01-03 11:28:10'),
(2096,2,'credit',NULL,350000.0000,NULL,'2025-01-03 18:58:54',106,52629,34292,NULL,NULL,NULL,'2025-01-03 11:58:54','2025-01-03 11:58:54'),
(2097,2,'debit',NULL,360000.0000,NULL,'2025-01-04 15:14:00',3,53042,34317,NULL,NULL,NULL,'2025-01-04 08:16:12','2025-01-04 08:16:12'),
(2098,2,'credit',NULL,120000.0000,NULL,'2025-01-05 10:20:36',13,53055,34352,NULL,NULL,NULL,'2025-01-05 03:20:36','2025-01-05 03:20:36'),
(2099,2,'credit',NULL,800000.0000,NULL,'2025-01-05 11:17:26',6,53068,34353,NULL,NULL,NULL,'2025-01-05 04:17:26','2025-01-13 13:29:37'),
(2100,2,'credit',NULL,75000.0000,NULL,'2025-01-06 08:35:26',5,53084,34363,NULL,NULL,NULL,'2025-01-06 01:35:27','2025-01-06 01:35:27'),
(2101,2,'credit',NULL,75000.0000,NULL,'2025-01-06 08:35:55',5,53085,34364,NULL,NULL,NULL,'2025-01-06 01:35:55','2025-01-06 01:35:55'),
(2102,2,'credit',NULL,5115000.0000,NULL,'2025-01-06 09:13:43',49,53088,34367,NULL,NULL,NULL,'2025-01-06 02:13:43','2025-01-11 07:47:54'),
(2103,2,'credit',NULL,350000.0000,NULL,'2025-01-06 09:50:57',5,53093,34369,NULL,NULL,NULL,'2025-01-06 02:50:57','2025-01-06 02:50:57'),
(2104,2,'credit',NULL,530000.0000,NULL,'2025-01-06 10:17:33',13,52938,34370,NULL,NULL,NULL,'2025-01-06 03:17:33','2025-01-06 03:17:33'),
(2105,2,'credit',NULL,140000.0000,NULL,'2025-01-06 10:17:42',13,53096,34371,NULL,NULL,NULL,'2025-01-06 03:17:42','2025-01-06 03:17:42'),
(2106,2,'credit',NULL,5933000.0000,NULL,'2025-01-06 10:21:25',93,53007,34372,NULL,NULL,NULL,'2025-01-06 03:21:25','2025-01-10 07:23:59'),
(2107,2,'credit',NULL,240000.0000,NULL,'2025-01-06 14:30:03',93,53111,34383,NULL,NULL,NULL,'2025-01-06 07:30:03','2025-01-31 13:11:46'),
(2108,2,'credit',NULL,255500.0000,NULL,'2025-01-06 15:18:15',46,43704,34386,NULL,NULL,NULL,'2025-01-06 08:18:15','2025-01-06 08:18:15'),
(2109,2,'credit',NULL,749000.0000,NULL,'2025-01-06 15:36:55',10,53116,34402,NULL,NULL,NULL,'2025-01-06 08:36:55','2025-01-06 08:36:55'),
(2110,2,'credit',NULL,6793000.0000,NULL,'2025-01-06 19:54:13',106,53139,34420,NULL,NULL,NULL,'2025-01-06 12:54:13','2025-01-06 12:55:41'),
(2111,2,'credit',NULL,450000.0000,NULL,'2025-01-07 12:03:54',93,52373,34454,NULL,NULL,NULL,'2025-01-07 05:03:54','2025-02-11 02:57:07'),
(2112,2,'credit',NULL,0.0000,NULL,'2025-01-07 16:07:31',5,52533,34463,NULL,NULL,NULL,'2025-01-07 09:07:31','2025-01-31 10:03:25'),
(2113,2,'credit',NULL,240000.0000,NULL,'2025-01-07 16:32:40',10,52772,34466,NULL,NULL,NULL,'2025-01-07 09:32:40','2025-01-07 09:32:40'),
(2114,2,'credit',NULL,520000.0000,NULL,'2025-01-07 16:51:31',93,53189,34470,NULL,NULL,NULL,'2025-01-07 09:51:31','2025-01-07 09:51:31'),
(2115,2,'credit',NULL,120000.0000,NULL,'2025-01-07 16:51:48',93,52728,34471,NULL,NULL,NULL,'2025-01-07 09:51:48','2025-01-07 09:51:48'),
(2116,2,'credit',NULL,195000.0000,NULL,'2025-01-07 16:52:18',10,53190,34472,NULL,NULL,NULL,'2025-01-07 09:52:18','2025-01-07 09:59:17'),
(2117,2,'credit',NULL,250000.0000,NULL,'2025-01-07 18:15:01',106,52931,34476,NULL,NULL,NULL,'2025-01-07 11:15:01','2025-01-07 11:15:01'),
(2118,2,'credit',NULL,930000.0000,NULL,'2025-01-07 20:17:46',106,53210,34490,NULL,NULL,NULL,'2025-01-07 13:17:46','2025-01-11 07:48:15'),
(2119,2,'credit',NULL,1500000.0000,NULL,'2025-01-08 08:29:45',93,53147,34500,NULL,NULL,NULL,'2025-01-08 01:29:45','2025-01-11 08:23:07'),
(2120,2,'credit',NULL,4974000.0000,NULL,'2025-01-08 14:27:09',3,52942,34524,NULL,NULL,NULL,'2025-01-08 07:27:09','2025-01-31 09:28:40'),
(2121,2,'credit',NULL,160000.0000,NULL,'2025-01-08 14:40:32',3,52408,34525,NULL,NULL,NULL,'2025-01-08 07:40:32','2025-01-08 08:58:55'),
(2122,2,'credit',NULL,185000.0000,NULL,'2025-01-08 16:28:15',6,53270,34529,NULL,NULL,NULL,'2025-01-08 09:28:15','2025-01-08 09:28:15'),
(2123,2,'credit',NULL,140000.0000,NULL,'2025-01-08 16:29:00',6,53154,34530,NULL,NULL,NULL,'2025-01-08 09:29:00','2025-01-08 09:29:25'),
(2124,2,'credit',NULL,1201000.0000,NULL,'2025-01-08 17:22:38',19,53279,34538,NULL,NULL,NULL,'2025-01-08 10:22:38','2025-01-08 10:22:38'),
(2125,2,'credit',NULL,50000.0000,NULL,'2025-01-08 17:22:00',19,53131,34539,NULL,NULL,NULL,'2025-01-08 10:23:04','2025-01-08 10:23:04'),
(2126,2,'credit',NULL,140000.0000,NULL,'2025-01-08 18:01:25',3,52654,34542,NULL,NULL,NULL,'2025-01-08 11:01:25','2025-01-08 11:01:25'),
(2127,2,'credit',NULL,175000.0000,NULL,'2025-01-08 18:01:32',3,53282,34543,NULL,NULL,NULL,'2025-01-08 11:01:32','2025-01-08 11:01:32'),
(2128,2,'credit',NULL,46000.0000,NULL,'2025-01-08 18:03:11',3,53283,34544,NULL,NULL,NULL,'2025-01-08 11:03:11','2025-01-08 11:03:11'),
(2129,2,'debit',NULL,941500.0000,NULL,'2025-01-08 18:46:00',3,53286,34547,NULL,NULL,NULL,'2025-01-08 11:47:48','2025-01-08 11:47:48'),
(2130,2,'credit',NULL,4010000.0000,NULL,'2025-01-08 21:37:11',19,53287,34553,NULL,NULL,NULL,'2025-01-08 14:37:11','2025-01-31 11:19:50'),
(2131,2,'credit',NULL,16000.0000,NULL,'2025-01-09 11:27:18',5,53309,34565,NULL,NULL,NULL,'2025-01-09 04:27:18','2025-01-09 04:27:18'),
(2132,2,'credit',NULL,359000.0000,NULL,'2025-01-09 11:44:10',6,53312,34567,NULL,NULL,NULL,'2025-01-09 04:44:10','2025-01-09 04:44:10'),
(2133,2,'credit',NULL,16538000.0000,NULL,'2025-01-09 13:19:40',49,53318,34569,NULL,NULL,NULL,'2025-01-09 06:19:40','2025-02-04 02:45:05'),
(2134,2,'credit',NULL,87000.0000,NULL,'2025-01-09 21:27:25',106,53354,34595,NULL,NULL,NULL,'2025-01-09 14:27:25','2025-01-09 14:27:25'),
(2135,2,'credit',NULL,4150000.0000,NULL,'2025-01-09 21:43:25',106,53353,34597,NULL,NULL,NULL,'2025-01-09 14:43:25','2025-01-09 14:43:25'),
(2136,2,'debit',NULL,3523000.0000,NULL,'2025-01-10 08:12:00',1,53252,34598,NULL,NULL,NULL,'2025-01-10 01:12:39','2025-01-10 01:12:39'),
(2137,2,'debit',NULL,28000000.0000,NULL,'2025-01-10 08:13:00',1,53047,34599,NULL,NULL,NULL,'2025-01-10 01:13:30','2025-01-10 01:13:30'),
(2138,2,'debit',NULL,800000.0000,NULL,'2025-01-10 08:13:00',1,53058,34600,NULL,NULL,NULL,'2025-01-10 01:13:47','2025-01-10 01:13:47'),
(2139,2,'debit',NULL,2290000.0000,NULL,'2025-01-10 08:14:00',1,53089,34601,NULL,NULL,NULL,'2025-01-10 01:14:08','2025-01-10 01:14:08'),
(2140,2,'debit',NULL,2953000.0000,NULL,'2025-01-10 08:21:00',1,53126,34602,NULL,NULL,NULL,'2025-01-10 01:21:35','2025-01-10 01:21:35'),
(2141,2,'debit',NULL,800000.0000,NULL,'2025-01-10 08:21:00',1,52907,34603,NULL,NULL,NULL,'2025-01-10 01:21:57','2025-01-10 01:21:57'),
(2142,2,'debit',NULL,800000.0000,NULL,'2025-01-10 08:32:00',1,53026,34606,NULL,NULL,NULL,'2025-01-10 01:32:14','2025-01-10 01:32:14'),
(2143,2,'debit',NULL,900000.0000,NULL,'2025-01-10 08:36:00',1,53330,34607,NULL,NULL,NULL,'2025-01-10 01:36:53','2025-01-10 01:36:53'),
(2144,2,'debit',NULL,88000.0000,NULL,'2025-01-10 08:37:00',1,53329,34608,NULL,NULL,NULL,'2025-01-10 01:37:17','2025-01-10 01:37:17'),
(2145,2,'debit',NULL,1666000.0000,NULL,'2025-01-10 08:37:00',1,53349,34609,NULL,NULL,NULL,'2025-01-10 01:37:59','2025-01-10 01:37:59'),
(2146,2,'debit',NULL,489000.0000,NULL,'2025-01-10 14:07:00',1,53043,34633,NULL,NULL,NULL,'2025-01-10 07:07:40','2025-01-10 07:07:40'),
(2147,2,'debit',NULL,11225000.0000,NULL,'2025-01-10 14:19:00',1,52962,34634,NULL,NULL,NULL,'2025-01-10 07:20:04','2025-01-10 07:20:04'),
(2148,2,'debit',NULL,48200.0000,NULL,'2025-01-10 14:24:00',1,53005,34635,NULL,NULL,NULL,'2025-01-10 07:24:57','2025-01-10 07:24:57'),
(2149,2,'debit',NULL,130000.0000,NULL,'2025-01-10 14:56:00',1,53121,34636,NULL,NULL,NULL,'2025-01-10 07:56:33','2025-01-10 07:56:33'),
(2150,2,'debit',NULL,187500.0000,NULL,'2025-01-10 14:57:00',1,53122,34637,NULL,NULL,NULL,'2025-01-10 07:57:36','2025-01-10 07:57:36'),
(2151,2,'credit',NULL,571000.0000,NULL,'2025-01-10 18:47:27',3,53003,34649,NULL,NULL,NULL,'2025-01-10 11:47:27','2025-01-11 07:35:32'),
(2152,2,'debit',NULL,800000.0000,NULL,'2025-01-10 19:59:00',3,53397,34651,NULL,NULL,NULL,'2025-01-10 13:02:35','2025-01-10 13:02:35'),
(2153,2,'debit',NULL,391000.0000,NULL,'2025-01-10 20:05:00',1,53313,34652,NULL,NULL,NULL,'2025-01-10 13:05:47','2025-01-10 13:05:47'),
(2154,2,'debit',NULL,730000.0000,NULL,'2025-01-10 20:14:00',1,53162,34653,NULL,NULL,NULL,'2025-01-10 13:14:49','2025-01-10 13:14:49'),
(2155,2,'debit',NULL,190000.0000,NULL,'2025-01-10 20:36:00',1,53186,34654,NULL,NULL,NULL,'2025-01-10 13:36:05','2025-01-10 13:36:05'),
(2156,2,'debit',NULL,20282800.0000,NULL,'2025-01-10 20:39:00',1,53160,34655,NULL,NULL,NULL,'2025-01-10 13:39:42','2025-01-10 13:39:42'),
(2157,2,'debit',NULL,422400.0000,NULL,'2025-01-10 20:40:00',1,50130,34656,NULL,NULL,NULL,'2025-01-10 13:40:44','2025-01-10 13:40:44'),
(2158,2,'debit',NULL,1259600.0000,NULL,'2025-01-10 20:52:00',1,52980,34657,NULL,NULL,NULL,'2025-01-10 13:52:40','2025-01-10 13:52:40'),
(2159,2,'credit',NULL,5500000.0000,NULL,'2025-01-11 11:00:40',5,53411,34670,NULL,NULL,NULL,'2025-01-11 04:00:40','2025-01-11 04:00:40'),
(2160,2,'debit',NULL,8075800.0000,NULL,'2025-01-11 14:27:00',1,53160,34678,NULL,NULL,NULL,'2025-01-11 07:27:10','2025-01-11 07:27:10'),
(2161,2,'credit',NULL,371000.0000,NULL,'2025-01-11 14:28:00',3,53423,34679,NULL,NULL,NULL,'2025-01-11 07:28:00','2025-01-14 01:54:16'),
(2162,2,'credit',NULL,110000.0000,NULL,'2025-01-11 17:19:25',93,53441,34690,NULL,NULL,NULL,'2025-01-11 10:19:25','2025-01-11 10:19:25'),
(2163,2,'credit',NULL,2000.0000,NULL,'2025-01-11 17:29:18',46,53442,34692,NULL,NULL,'2025-01-11 14:49:59','2025-01-11 10:29:18','2025-01-11 14:49:59'),
(2164,2,'credit',NULL,5500000.0000,NULL,'2025-01-11 18:17:20',3,53412,34697,NULL,NULL,'2025-01-11 14:30:15','2025-01-11 11:17:20','2025-01-11 14:30:15'),
(2165,2,'credit',NULL,3129000.0000,NULL,'2025-01-11 19:57:53',46,53453,34704,NULL,NULL,NULL,'2025-01-11 12:57:53','2025-01-31 13:05:33'),
(2166,2,'credit',NULL,5110000.0000,NULL,'2025-01-11 20:30:53',93,51716,34706,NULL,NULL,NULL,'2025-01-11 13:30:53','2025-01-11 14:04:36'),
(2167,2,'debit',NULL,4420000.0000,NULL,'2025-01-12 09:12:00',1,53443,34716,NULL,NULL,NULL,'2025-01-12 02:12:39','2025-01-12 02:12:39'),
(2168,2,'debit',NULL,4329000.0000,NULL,'2025-01-12 09:16:00',1,53198,34718,NULL,NULL,NULL,'2025-01-12 02:16:20','2025-01-12 02:16:20'),
(2169,2,'debit',NULL,445000.0000,NULL,'2025-01-12 09:18:00',1,53199,34719,NULL,NULL,NULL,'2025-01-12 02:18:41','2025-01-12 02:18:41'),
(2170,2,'debit',NULL,2400000.0000,NULL,'2025-01-12 09:20:00',1,53248,34720,NULL,NULL,NULL,'2025-01-12 02:20:57','2025-01-12 02:20:57'),
(2171,2,'debit',NULL,225000.0000,NULL,'2025-01-12 09:22:00',1,53264,34721,NULL,NULL,NULL,'2025-01-12 02:22:49','2025-01-12 02:22:49'),
(2172,2,'debit',NULL,800000.0000,NULL,'2025-01-12 09:23:00',1,53449,34722,NULL,NULL,NULL,'2025-01-12 02:23:07','2025-01-12 02:23:07'),
(2173,2,'debit',NULL,32985800.0000,NULL,'2025-01-12 09:27:00',1,53197,34724,NULL,NULL,NULL,'2025-01-12 02:27:10','2025-01-12 02:27:10'),
(2174,2,'credit',NULL,1320000.0000,NULL,'2025-01-12 09:58:00',19,51276,34725,NULL,NULL,NULL,'2025-01-12 02:58:00','2025-01-12 05:49:51'),
(2175,2,'credit',NULL,640000.0000,NULL,'2025-01-12 10:00:13',19,53466,34726,NULL,NULL,NULL,'2025-01-12 03:00:13','2025-01-12 03:00:13'),
(2176,2,'credit',NULL,4710000.0000,NULL,'2025-01-12 14:00:16',5,53480,34732,NULL,NULL,NULL,'2025-01-12 07:00:16','2025-01-12 07:00:16'),
(2177,2,'credit',NULL,3734000.0000,NULL,'2025-01-12 14:24:34',49,53479,34733,NULL,NULL,NULL,'2025-01-12 07:24:34','2025-01-12 09:42:00'),
(2178,2,'credit',NULL,7305000.0000,NULL,'2025-01-12 17:23:51',93,53488,34737,NULL,NULL,NULL,'2025-01-12 10:23:51','2025-01-31 08:06:33'),
(2179,2,'credit',NULL,160000.0000,NULL,'2025-01-13 09:34:11',106,53370,34744,NULL,NULL,NULL,'2025-01-13 02:34:11','2025-01-13 02:34:11'),
(2180,2,'credit',NULL,140000.0000,NULL,'2025-01-13 09:36:33',106,53504,34745,NULL,NULL,NULL,'2025-01-13 02:36:33','2025-01-13 02:36:33'),
(2181,2,'credit',NULL,140000.0000,NULL,'2025-01-13 12:14:03',46,53522,34761,NULL,NULL,NULL,'2025-01-13 05:14:03','2025-01-13 05:14:03'),
(2182,2,'credit',NULL,2376000.0000,NULL,'2025-01-13 12:26:35',3,53523,34762,NULL,NULL,NULL,'2025-01-13 05:30:33','2025-01-13 05:30:33'),
(2183,2,'credit',NULL,160000.0000,NULL,'2025-01-13 16:25:28',19,51652,34774,NULL,NULL,NULL,'2025-01-13 09:25:28','2025-01-13 09:25:28'),
(2184,2,'credit',NULL,145000.0000,NULL,'2025-01-13 16:27:27',19,53550,34776,NULL,NULL,NULL,'2025-01-13 09:27:27','2025-01-13 09:30:49'),
(2185,2,'credit',NULL,1050000.0000,NULL,'2025-01-13 16:59:29',19,53555,34779,NULL,NULL,NULL,'2025-01-13 09:59:29','2025-01-13 09:59:29'),
(2186,2,'credit',NULL,470000.0000,NULL,'2025-01-13 17:16:09',6,53558,34781,NULL,NULL,NULL,'2025-01-13 10:16:09','2025-01-31 03:06:55'),
(2187,2,'credit',NULL,180000.0000,NULL,'2025-01-13 17:17:50',6,52957,34782,NULL,NULL,NULL,'2025-01-13 10:17:50','2025-01-13 10:17:50'),
(2188,2,'credit',NULL,180000.0000,NULL,'2025-01-14 12:48:00',19,50762,34819,NULL,NULL,NULL,'2025-01-14 05:48:30','2025-01-14 05:48:30'),
(2189,2,'credit',NULL,650000.0000,NULL,'2025-01-14 12:49:00',19,51551,34820,NULL,NULL,NULL,'2025-01-14 05:49:07','2025-01-14 05:49:07'),
(2190,2,'credit',NULL,125000.0000,NULL,'2025-01-14 12:49:00',19,50761,34821,NULL,NULL,NULL,'2025-01-14 05:49:49','2025-01-14 05:49:49'),
(2191,2,'credit',NULL,287000.0000,NULL,'2025-01-14 12:50:00',19,53322,34822,NULL,NULL,NULL,'2025-01-14 05:50:19','2025-01-14 05:50:19'),
(2192,2,'credit',NULL,195000.0000,NULL,'2025-01-14 12:50:00',19,50767,34823,NULL,NULL,NULL,'2025-01-14 05:50:47','2025-01-14 05:50:47'),
(2193,2,'credit',NULL,496000.0000,NULL,'2025-01-14 12:51:00',19,53323,34824,NULL,NULL,NULL,'2025-01-14 05:51:06','2025-01-14 05:51:06'),
(2194,2,'credit',NULL,67000.0000,NULL,'2025-01-14 12:51:00',19,50764,34825,NULL,NULL,NULL,'2025-01-14 05:51:48','2025-01-14 05:51:48'),
(2195,2,'credit',NULL,280000.0000,NULL,'2025-01-14 13:39:01',93,53478,34828,NULL,NULL,NULL,'2025-01-14 06:39:01','2025-01-14 06:39:01'),
(2196,2,'credit',NULL,45000.0000,NULL,'2025-01-14 15:51:03',13,53618,34837,NULL,NULL,NULL,'2025-01-14 08:51:03','2025-01-14 08:51:03'),
(2197,2,'credit',NULL,200000.0000,NULL,'2025-01-14 15:51:35',13,53492,34838,NULL,NULL,NULL,'2025-01-14 08:51:35','2025-01-14 08:51:35'),
(2198,2,'credit',NULL,3000000.0000,NULL,'2025-01-14 16:10:00',19,53622,34841,NULL,NULL,NULL,'2025-01-14 09:40:33','2025-01-15 09:47:16'),
(2199,2,'credit',NULL,65000.0000,NULL,'2025-01-14 19:26:51',5,53619,34850,NULL,NULL,NULL,'2025-01-14 12:26:51','2025-01-14 12:26:51'),
(2200,2,'debit',NULL,54975000.0000,NULL,'2025-01-14 21:14:00',1,52596,34854,NULL,NULL,NULL,'2025-01-14 14:14:07','2025-01-14 14:14:07'),
(2201,2,'debit',NULL,380000.0000,NULL,'2025-01-14 21:17:00',1,53250,34855,NULL,NULL,NULL,'2025-01-14 14:17:45','2025-01-14 14:17:45'),
(2202,2,'debit',NULL,1376300.0000,NULL,'2025-01-14 21:37:00',1,53273,34856,NULL,NULL,NULL,'2025-01-14 14:37:50','2025-01-14 14:37:50'),
(2203,2,'debit',NULL,59624000.0000,NULL,'2025-01-14 21:51:00',1,53407,34857,NULL,NULL,NULL,'2025-01-14 14:52:01','2025-01-14 14:52:01'),
(2204,2,'debit',NULL,230000.0000,NULL,'2025-01-14 21:58:00',1,53421,34858,NULL,NULL,'2025-01-14 14:59:17','2025-01-14 14:58:37','2025-01-14 14:59:17'),
(2205,2,'debit',NULL,3875000.0000,NULL,'2025-01-14 22:04:00',1,53444,34859,NULL,NULL,NULL,'2025-01-14 15:04:10','2025-01-14 15:04:10'),
(2206,2,'debit',NULL,141400.0000,NULL,'2025-01-14 22:09:00',1,53481,34860,NULL,NULL,NULL,'2025-01-14 15:09:12','2025-01-14 15:09:12'),
(2207,2,'debit',NULL,175000.0000,NULL,'2025-01-14 22:13:00',1,53544,34861,NULL,NULL,NULL,'2025-01-14 15:13:31','2025-01-14 15:13:31'),
(2208,2,'debit',NULL,800000.0000,NULL,'2025-01-14 22:13:00',1,53545,34862,NULL,NULL,NULL,'2025-01-14 15:13:43','2025-01-14 15:13:43'),
(2209,2,'debit',NULL,414700.0000,NULL,'2025-01-14 22:14:00',1,53588,34863,NULL,NULL,NULL,'2025-01-14 15:14:23','2025-01-14 15:14:23'),
(2210,2,'debit',NULL,372000.0000,NULL,'2025-01-14 22:16:00',1,53610,34864,NULL,NULL,NULL,'2025-01-14 15:16:15','2025-01-14 15:16:15'),
(2211,2,'debit',NULL,740800.0000,NULL,'2025-01-14 22:18:00',1,53533,34865,NULL,NULL,NULL,'2025-01-14 15:19:01','2025-01-14 15:19:01'),
(2212,2,'debit',NULL,800000.0000,NULL,'2025-01-16 12:41:00',1,53690,34940,NULL,NULL,NULL,'2025-01-16 05:42:01','2025-01-16 05:42:01'),
(2213,2,'debit',NULL,343000.0000,NULL,'2025-01-16 12:42:00',1,53627,34941,NULL,NULL,NULL,'2025-01-16 05:42:30','2025-01-16 05:42:30'),
(2214,2,'debit',NULL,6550000.0000,NULL,'2025-01-16 12:43:00',1,53621,34942,NULL,NULL,NULL,'2025-01-16 05:43:07','2025-01-16 05:43:07'),
(2215,2,'debit',NULL,230000.0000,NULL,'2025-01-16 12:47:00',1,53421,34943,NULL,NULL,NULL,'2025-01-16 05:48:03','2025-01-16 05:48:03'),
(2216,2,'debit',NULL,730000.0000,NULL,'2025-01-16 12:48:00',1,53671,34944,NULL,NULL,NULL,'2025-01-16 05:49:00','2025-01-16 05:49:00'),
(2217,2,'debit',NULL,13843300.0000,NULL,'2025-01-16 13:23:00',1,53685,34946,NULL,NULL,NULL,'2025-01-16 06:23:42','2025-01-16 06:23:42'),
(2218,2,'debit',NULL,10606000.0000,NULL,'2025-01-16 13:32:00',1,53689,34948,NULL,NULL,NULL,'2025-01-16 06:32:18','2025-01-16 06:32:18'),
(2219,2,'debit',NULL,498000.0000,NULL,'2025-01-16 14:11:00',1,52856,34949,NULL,NULL,NULL,'2025-01-16 07:11:43','2025-01-16 07:11:43'),
(2220,2,'debit',NULL,936000.0000,NULL,'2025-01-16 14:17:00',1,52823,34950,NULL,NULL,NULL,'2025-01-16 07:17:39','2025-01-16 07:17:39'),
(2221,2,'debit',NULL,53000.0000,NULL,'2025-01-16 14:20:00',1,52770,34951,NULL,NULL,NULL,'2025-01-16 07:20:03','2025-01-16 07:20:03'),
(2222,2,'debit',NULL,373000.0000,NULL,'2025-01-16 14:21:00',1,52758,34952,NULL,NULL,NULL,'2025-01-16 07:21:08','2025-01-16 07:21:08'),
(2223,2,'debit',NULL,152000.0000,NULL,'2025-01-16 14:22:00',1,52756,34953,NULL,NULL,NULL,'2025-01-16 07:22:34','2025-01-16 07:22:34'),
(2224,2,'debit',NULL,100000.0000,NULL,'2025-01-16 14:25:00',1,52750,34954,NULL,NULL,NULL,'2025-01-16 07:25:12','2025-01-16 07:25:12'),
(2225,2,'debit',NULL,345000.0000,NULL,'2025-01-16 14:25:00',1,52731,34955,NULL,NULL,NULL,'2025-01-16 07:25:38','2025-01-16 07:25:38'),
(2226,2,'debit',NULL,167000.0000,NULL,'2025-01-16 14:27:00',1,52729,34956,NULL,NULL,NULL,'2025-01-16 07:27:47','2025-01-16 07:27:47'),
(2227,2,'credit',NULL,53000.0000,NULL,'2025-01-16 16:36:00',19,53757,34968,NULL,NULL,NULL,'2025-01-16 09:55:20','2025-01-16 09:55:20'),
(2228,2,'credit',NULL,84500.0000,NULL,'2025-01-18 11:25:17',46,53857,35049,NULL,NULL,NULL,'2025-01-18 04:25:17','2025-01-18 04:25:17'),
(2229,2,'credit',NULL,155000.0000,NULL,'2025-01-18 12:32:26',49,53708,35057,NULL,NULL,NULL,'2025-01-18 05:32:26','2025-01-18 12:27:19'),
(2230,2,'credit',NULL,210000.0000,NULL,'2025-01-18 14:24:44',6,53874,35064,NULL,NULL,NULL,'2025-01-18 07:24:44','2025-01-18 07:24:44'),
(2231,2,'credit',NULL,946000.0000,NULL,'2025-01-18 16:31:39',46,53885,35075,NULL,NULL,NULL,'2025-01-18 09:31:39','2025-01-31 13:04:08'),
(2232,2,'credit',NULL,4959000.0000,NULL,'2025-01-19 13:23:37',19,53925,35101,NULL,NULL,NULL,'2025-01-19 06:23:37','2025-01-22 10:07:59'),
(2233,2,'credit',NULL,178000.0000,NULL,'2025-01-20 08:41:17',106,53956,35131,NULL,NULL,NULL,'2025-01-20 01:41:17','2025-01-20 01:41:17'),
(2234,2,'credit',NULL,46000000.0000,NULL,'2025-01-20 09:43:30',93,53964,35140,NULL,NULL,NULL,'2025-01-20 03:43:17','2025-01-21 07:17:00'),
(2235,2,'credit',NULL,785000.0000,NULL,'2025-01-20 11:26:12',106,53968,35147,NULL,NULL,NULL,'2025-01-20 04:26:12','2025-01-20 04:26:12'),
(2236,2,'credit',NULL,217000.0000,NULL,'2025-01-20 12:44:30',93,53983,35154,NULL,NULL,'2025-01-31 12:50:05','2025-01-20 05:44:30','2025-01-31 12:50:05'),
(2237,2,'credit',NULL,4657000.0000,NULL,'2025-01-20 13:47:49',49,52942,35160,NULL,NULL,NULL,'2025-01-20 06:47:49','2025-01-31 09:28:40'),
(2238,2,'debit',NULL,95000.0000,NULL,'2025-01-20 15:38:00',3,54004,35169,NULL,NULL,NULL,'2025-01-20 08:40:30','2025-01-20 08:40:30'),
(2239,2,'credit',NULL,202000.0000,NULL,'2025-01-20 16:37:55',3,53446,35172,NULL,NULL,NULL,'2025-01-20 09:37:55','2025-01-20 09:47:58'),
(2240,2,'credit',NULL,1527000.0000,NULL,'2025-01-20 20:07:47',49,54026,35191,NULL,NULL,NULL,'2025-01-20 13:07:47','2025-01-20 13:07:47'),
(2241,2,'credit',NULL,190000.0000,NULL,'2025-01-20 20:45:25',13,54033,35193,NULL,NULL,NULL,'2025-01-20 13:45:25','2025-01-20 13:45:25'),
(2242,2,'credit',NULL,1390000.0000,NULL,'2025-01-21 09:43:17',5,54044,35197,NULL,NULL,NULL,'2025-01-21 02:43:17','2025-01-21 02:43:17'),
(2243,2,'credit',NULL,261000.0000,NULL,'2025-01-21 10:01:30',106,54046,35199,NULL,NULL,NULL,'2025-01-21 03:01:46','2025-01-22 06:47:12'),
(2244,2,'credit',NULL,2130000.0000,NULL,'2025-01-21 11:41:16',106,53957,35206,NULL,NULL,NULL,'2025-01-21 04:41:16','2025-01-21 04:41:16'),
(2245,2,'credit',NULL,300000.0000,NULL,'2025-01-21 12:42:28',106,54022,35208,NULL,NULL,NULL,'2025-01-21 05:42:28','2025-01-21 05:42:28'),
(2246,2,'credit',NULL,370000.0000,NULL,'2025-01-21 18:03:57',49,53889,35228,NULL,NULL,NULL,'2025-01-21 11:03:57','2025-01-21 11:03:57'),
(2247,2,'credit',NULL,195000.0000,NULL,'2025-01-21 18:04:03',49,54080,35229,NULL,NULL,NULL,'2025-01-21 11:04:03','2025-01-21 11:04:03'),
(2248,2,'credit',NULL,450000.0000,NULL,'2025-01-22 13:17:14',93,54120,35261,NULL,NULL,NULL,'2025-01-22 06:17:14','2025-01-22 10:21:25'),
(2249,2,'credit',NULL,1120000.0000,NULL,'2025-01-22 13:32:04',46,54120,35262,NULL,NULL,NULL,'2025-01-22 06:32:04','2025-01-22 10:21:25'),
(2250,2,'credit',NULL,2355000.0000,NULL,'2025-01-22 13:40:06',13,54123,35264,NULL,NULL,NULL,'2025-01-22 06:40:06','2025-01-22 06:40:06'),
(2251,2,'credit',NULL,261000.0000,NULL,'2025-01-22 13:47:12',13,54046,35265,NULL,NULL,NULL,'2025-01-22 06:47:12','2025-01-22 06:47:12'),
(2252,2,'credit',NULL,430000.0000,NULL,'2025-01-22 15:03:18',19,54128,35268,NULL,NULL,NULL,'2025-01-22 08:03:18','2025-01-22 08:03:18'),
(2253,2,'credit',NULL,220000.0000,NULL,'2025-01-22 15:47:06',19,54135,35276,NULL,NULL,NULL,'2025-01-22 08:47:06','2025-01-22 08:47:06'),
(2254,2,'credit',NULL,120000.0000,NULL,'2025-01-22 18:48:12',13,54093,35283,NULL,NULL,NULL,'2025-01-22 11:48:12','2025-01-22 11:48:12'),
(2255,2,'credit',NULL,270000.0000,NULL,'2025-01-23 10:54:49',5,54169,35298,NULL,NULL,NULL,'2025-01-23 03:54:50','2025-01-23 03:54:50'),
(2256,2,'credit',NULL,350000.0000,NULL,'2025-01-23 14:53:39',93,54192,35312,NULL,NULL,NULL,'2025-01-23 07:53:39','2025-01-23 07:53:39'),
(2257,2,'credit',NULL,15000.0000,NULL,'2025-01-23 16:11:40',5,54097,35320,NULL,NULL,NULL,'2025-01-23 09:11:40','2025-01-23 09:11:40'),
(2258,2,'credit',NULL,160000.0000,NULL,'2025-01-23 16:12:05',5,54098,35321,NULL,NULL,NULL,'2025-01-23 09:12:05','2025-01-23 09:12:05'),
(2259,2,'credit',NULL,70000.0000,NULL,'2025-01-23 16:12:40',5,54201,35322,NULL,NULL,NULL,'2025-01-23 09:12:40','2025-01-23 09:12:40'),
(2260,2,'credit',NULL,200000.0000,NULL,'2025-01-23 17:27:19',13,52792,35327,NULL,NULL,NULL,'2025-01-23 10:27:19','2025-02-13 08:02:08'),
(2261,2,'credit',NULL,200000.0000,NULL,'2025-01-23 17:28:41',13,52793,35329,NULL,NULL,NULL,'2025-01-23 10:28:41','2025-01-23 10:28:41'),
(2262,2,'credit',NULL,200000.0000,NULL,'2025-01-23 18:09:40',19,54202,35331,NULL,NULL,NULL,'2025-01-23 11:09:40','2025-02-28 06:14:55'),
(2263,2,'debit',NULL,43569000.0000,NULL,'2025-01-24 08:34:00',1,53638,35341,NULL,NULL,NULL,'2025-01-24 01:34:48','2025-01-24 01:34:48'),
(2264,2,'credit',NULL,230000.0000,NULL,'2025-01-24 10:52:48',106,54232,35348,NULL,NULL,NULL,'2025-01-24 03:52:48','2025-01-24 03:52:48'),
(2265,2,'credit',NULL,40000.0000,NULL,'2025-01-24 12:05:59',5,54238,35355,NULL,NULL,NULL,'2025-01-24 05:05:59','2025-01-24 05:05:59'),
(2266,2,'credit',NULL,53000.0000,NULL,'2025-01-24 16:20:23',46,54262,35364,NULL,NULL,NULL,'2025-01-24 09:20:23','2025-01-24 09:20:23'),
(2267,2,'credit',NULL,350000.0000,NULL,'2025-01-24 16:34:38',5,54256,35368,NULL,NULL,'2025-02-04 02:21:37','2025-01-24 09:34:38','2025-02-04 02:21:37'),
(2268,2,'credit',NULL,190000.0000,NULL,'2025-01-24 16:56:07',106,54263,35370,NULL,NULL,NULL,'2025-01-24 09:56:07','2025-01-24 09:56:07'),
(2269,2,'credit',NULL,200000.0000,NULL,'2025-01-25 08:28:12',5,54239,35387,NULL,NULL,NULL,'2025-01-25 01:28:12','2025-02-01 01:30:18'),
(2270,2,'credit',NULL,200000.0000,NULL,'2025-01-25 11:34:53',5,54103,35390,NULL,NULL,NULL,'2025-01-25 04:34:53','2025-01-25 04:34:53'),
(2271,2,'credit',NULL,185000.0000,NULL,'2025-01-25 11:35:30',5,54291,35391,NULL,NULL,NULL,'2025-01-25 04:35:30','2025-01-25 09:01:41'),
(2272,2,'debit',NULL,1200000.0000,NULL,'2025-01-25 11:49:00',1,53903,35392,NULL,NULL,NULL,'2025-01-25 04:49:54','2025-01-25 04:49:54'),
(2273,2,'debit',NULL,3251000.0000,NULL,'2025-01-25 16:48:00',1,53639,35412,NULL,NULL,NULL,'2025-01-25 09:48:47','2025-01-25 09:48:47'),
(2274,2,'debit',NULL,98450.0000,NULL,'2025-01-25 16:50:00',1,53541,35413,NULL,NULL,NULL,'2025-01-25 09:50:47','2025-01-25 09:50:47'),
(2275,2,'debit',NULL,800000.0000,NULL,'2025-01-25 16:52:00',1,53860,35414,NULL,NULL,NULL,'2025-01-25 09:52:15','2025-01-25 09:52:15'),
(2276,2,'debit',NULL,3607200.0000,NULL,'2025-01-25 17:02:00',1,53902,35415,NULL,NULL,NULL,'2025-01-25 10:02:29','2025-01-25 10:02:29'),
(2277,2,'debit',NULL,5305800.0000,NULL,'2025-01-25 17:18:00',1,53883,35417,NULL,NULL,NULL,'2025-01-25 10:18:49','2025-01-25 10:18:49'),
(2278,2,'credit',NULL,1334000.0000,NULL,'2025-01-25 17:20:17',13,54189,35418,NULL,NULL,NULL,'2025-01-25 10:20:17','2025-01-25 10:20:17'),
(2279,2,'debit',NULL,842000.0000,NULL,'2025-01-25 17:33:00',1,53827,35419,NULL,NULL,NULL,'2025-01-25 10:33:56','2025-01-25 10:33:56'),
(2280,2,'debit',NULL,408300.0000,NULL,'2025-01-25 17:37:00',1,53792,35420,NULL,NULL,NULL,'2025-01-25 10:37:19','2025-01-25 10:37:19'),
(2281,2,'debit',NULL,197500.0000,NULL,'2025-01-25 17:38:00',1,53314,35422,NULL,NULL,NULL,'2025-01-25 10:38:35','2025-01-25 10:38:35'),
(2282,2,'debit',NULL,408000.0000,NULL,'2025-01-25 17:39:00',1,53686,35423,NULL,NULL,NULL,'2025-01-25 10:39:58','2025-01-25 10:39:58'),
(2283,2,'debit',NULL,329000.0000,NULL,'2025-01-25 17:46:00',1,53937,35424,NULL,NULL,NULL,'2025-01-25 10:46:26','2025-01-25 10:46:26'),
(2284,2,'credit',NULL,1150000.0000,NULL,'2025-01-25 19:24:37',49,54341,35432,NULL,NULL,NULL,'2025-01-25 12:24:37','2025-01-25 12:24:37'),
(2285,2,'credit',NULL,800000.0000,NULL,'2025-01-26 12:23:43',3,54364,35452,NULL,NULL,NULL,'2025-01-26 05:23:43','2025-01-26 05:23:43'),
(2286,2,'credit',NULL,800000.0000,NULL,'2025-01-26 12:23:48',3,54365,35453,NULL,NULL,NULL,'2025-01-26 05:23:48','2025-01-26 06:06:36'),
(2287,2,'credit',NULL,800000.0000,NULL,'2025-01-26 12:25:01',3,54366,35454,NULL,NULL,NULL,'2025-01-26 05:25:01','2025-01-26 06:06:22'),
(2288,2,'credit',NULL,98000.0000,NULL,'2025-01-26 13:12:58',3,54306,35463,NULL,NULL,NULL,'2025-01-26 06:12:58','2025-01-26 06:12:58'),
(2289,2,'credit',NULL,1096000.0000,NULL,'2025-01-26 16:56:27',93,54330,35472,NULL,NULL,NULL,'2025-01-26 09:56:27','2025-01-31 12:44:55'),
(2290,2,'debit',NULL,110000.0000,NULL,'2025-01-27 10:19:00',1,53793,35484,NULL,NULL,NULL,'2025-01-27 03:19:13','2025-01-27 03:19:13'),
(2291,2,'debit',NULL,295000.0000,NULL,'2025-01-27 10:20:00',1,54045,35485,NULL,NULL,NULL,'2025-01-27 03:20:59','2025-01-27 03:20:59'),
(2292,2,'debit',NULL,19253200.0000,NULL,'2025-01-27 10:31:00',1,54082,35486,NULL,NULL,NULL,'2025-01-27 03:31:43','2025-01-27 03:31:43'),
(2293,2,'debit',NULL,800000.0000,NULL,'2025-01-27 10:32:00',1,54106,35487,NULL,NULL,NULL,'2025-01-27 03:32:20','2025-01-27 03:32:20'),
(2294,2,'debit',NULL,1568000.0000,NULL,'2025-01-27 10:33:00',1,54160,35488,NULL,NULL,NULL,'2025-01-27 03:33:21','2025-01-27 03:33:21'),
(2295,2,'debit',NULL,160000.0000,NULL,'2025-01-27 10:33:00',1,54165,35489,NULL,NULL,NULL,'2025-01-27 03:33:48','2025-01-27 03:33:48'),
(2296,2,'debit',NULL,150000.0000,NULL,'2025-01-27 10:34:00',1,54168,35490,NULL,NULL,NULL,'2025-01-27 03:34:22','2025-01-27 03:34:22'),
(2297,2,'debit',NULL,11800.0000,NULL,'2025-01-27 10:34:00',1,54170,35491,NULL,NULL,NULL,'2025-01-27 03:34:55','2025-01-27 03:34:55'),
(2298,2,'debit',NULL,26837900.0000,NULL,'2025-01-27 11:04:00',1,54242,35492,NULL,NULL,NULL,'2025-01-27 04:04:50','2025-01-27 04:04:50'),
(2299,2,'debit',NULL,369000.0000,NULL,'2025-01-27 11:21:00',1,54260,35493,NULL,NULL,NULL,'2025-01-27 04:21:45','2025-01-27 04:21:45'),
(2300,2,'debit',NULL,395000.0000,NULL,'2025-01-27 11:24:00',1,54284,35494,NULL,NULL,NULL,'2025-01-27 04:24:20','2025-01-27 04:24:20'),
(2301,2,'debit',NULL,170000.0000,NULL,'2025-01-27 11:26:00',1,54345,35495,NULL,NULL,NULL,'2025-01-27 04:27:02','2025-01-27 04:27:02'),
(2302,2,'debit',NULL,61000.0000,NULL,'2025-01-27 11:28:00',1,54371,35496,NULL,NULL,NULL,'2025-01-27 04:28:06','2025-01-27 04:28:06'),
(2303,2,'debit',NULL,3740000.0000,NULL,'2025-01-27 11:34:00',1,52173,35498,NULL,NULL,NULL,'2025-01-27 04:34:05','2025-01-27 04:34:05'),
(2304,2,'debit',NULL,1690718.0000,NULL,'2025-01-27 11:36:00',1,52051,35499,NULL,NULL,NULL,'2025-01-27 04:36:20','2025-01-27 04:36:20'),
(2305,2,'debit',NULL,201500.0000,NULL,'2025-01-27 11:37:00',1,52039,35500,NULL,NULL,NULL,'2025-01-27 04:37:11','2025-01-27 04:37:11'),
(2306,2,'debit',NULL,220000.0000,NULL,'2025-01-27 11:38:00',1,52107,35501,NULL,NULL,NULL,'2025-01-27 04:38:38','2025-01-27 04:38:38'),
(2307,2,'debit',NULL,375900.0000,NULL,'2025-01-27 11:43:00',1,51852,35502,NULL,NULL,NULL,'2025-01-27 04:43:52','2025-01-27 04:43:52'),
(2308,2,'debit',NULL,14980000.0000,NULL,'2025-01-27 11:57:00',1,52726,35503,NULL,NULL,NULL,'2025-01-27 04:58:00','2025-01-27 04:58:00'),
(2309,2,'debit',NULL,11800000.0000,NULL,'2025-01-27 11:58:00',1,52725,35504,NULL,NULL,NULL,'2025-01-27 04:58:20','2025-01-27 04:58:20'),
(2310,2,'debit',NULL,1026000.0000,NULL,'2025-01-27 11:58:00',1,52647,35505,NULL,NULL,NULL,'2025-01-27 04:58:40','2025-01-27 04:58:40'),
(2311,2,'debit',NULL,800000.0000,NULL,'2025-01-27 12:00:00',1,52637,35506,NULL,NULL,NULL,'2025-01-27 05:00:05','2025-01-27 05:00:05'),
(2312,2,'debit',NULL,115000.0000,NULL,'2025-01-27 12:00:00',1,52598,35507,NULL,NULL,NULL,'2025-01-27 05:00:48','2025-01-27 05:00:48'),
(2313,2,'debit',NULL,930000.0000,NULL,'2025-01-27 12:04:00',1,52586,35508,NULL,NULL,NULL,'2025-01-27 05:04:29','2025-01-27 05:04:29'),
(2314,2,'debit',NULL,1182500.0000,NULL,'2025-01-27 12:05:00',1,52541,35509,NULL,NULL,NULL,'2025-01-27 05:05:51','2025-01-27 05:05:51'),
(2315,2,'debit',NULL,166500.0000,NULL,'2025-01-27 12:06:00',1,52538,35510,NULL,NULL,NULL,'2025-01-27 05:06:59','2025-01-27 05:06:59'),
(2316,2,'debit',NULL,817000.0000,NULL,'2025-01-27 12:07:00',1,52539,35511,NULL,NULL,NULL,'2025-01-27 05:07:39','2025-01-27 05:07:39'),
(2317,2,'debit',NULL,391000.0000,NULL,'2025-01-27 12:08:00',1,52509,35512,NULL,NULL,NULL,'2025-01-27 05:08:43','2025-01-27 05:08:43'),
(2318,2,'debit',NULL,800000.0000,NULL,'2025-01-27 12:09:00',1,52470,35513,NULL,NULL,NULL,'2025-01-27 05:09:08','2025-01-27 05:09:08'),
(2319,2,'credit',NULL,99000.0000,NULL,'2025-01-27 12:46:05',1,54394,35514,NULL,NULL,NULL,'2025-01-27 05:46:05','2025-01-27 05:46:05'),
(2320,2,'credit',NULL,200000.0000,NULL,'2025-01-28 09:15:22',3,54359,35515,NULL,NULL,NULL,'2025-01-28 02:15:22','2025-01-31 10:06:11'),
(2321,2,'credit',NULL,505000.0000,NULL,'2025-01-28 09:36:46',3,51907,35518,NULL,NULL,NULL,'2025-01-28 02:36:46','2025-01-28 02:36:46'),
(2322,2,'debit',NULL,5040000.0000,NULL,'2025-01-28 10:34:00',1,54302,35524,NULL,NULL,NULL,'2025-01-28 03:34:38','2025-01-28 03:34:38'),
(2323,2,'debit',NULL,55000.0000,NULL,'2025-01-28 10:42:00',1,54332,35525,NULL,NULL,NULL,'2025-01-28 03:42:47','2025-01-28 03:42:47'),
(2324,2,'debit',NULL,122000.0000,NULL,'2025-01-28 10:45:00',1,54062,35526,NULL,NULL,NULL,'2025-01-28 03:45:29','2025-01-28 03:45:29'),
(2325,2,'debit',NULL,225000.0000,NULL,'2025-01-28 10:47:00',1,54067,35527,NULL,NULL,NULL,'2025-01-28 03:47:06','2025-01-28 03:47:06'),
(2326,2,'debit',NULL,889000.0000,NULL,'2025-01-28 10:47:00',1,54229,35528,NULL,NULL,NULL,'2025-01-28 03:47:41','2025-01-28 03:47:41'),
(2327,2,'debit',NULL,165000.0000,NULL,'2025-01-28 10:50:00',1,54197,35529,NULL,NULL,NULL,'2025-01-28 03:50:15','2025-01-28 03:50:15'),
(2328,2,'debit',NULL,199000.0000,NULL,'2025-01-28 10:53:00',1,54250,35530,NULL,NULL,NULL,'2025-01-28 03:53:30','2025-01-28 03:53:30'),
(2329,2,'debit',NULL,98000.0000,NULL,'2025-01-28 11:06:00',1,54204,35531,NULL,NULL,NULL,'2025-01-28 04:06:28','2025-01-28 04:06:28'),
(2330,2,'debit',NULL,153856.0000,NULL,'2025-01-28 11:15:00',1,52597,35532,NULL,NULL,NULL,'2025-01-28 04:15:51','2025-01-28 04:15:51'),
(2331,2,'credit',NULL,67000.0000,NULL,'2025-01-28 11:17:42',13,54405,35533,NULL,NULL,NULL,'2025-01-28 04:17:42','2025-01-28 04:17:42'),
(2332,2,'credit',NULL,144000.0000,NULL,'2025-01-28 11:17:42',13,54405,35534,NULL,NULL,NULL,'2025-01-28 04:17:42','2025-01-28 04:17:42'),
(2333,2,'credit',NULL,240000.0000,NULL,'2025-01-28 11:35:40',19,54406,35535,NULL,NULL,NULL,'2025-01-28 04:35:40','2025-01-28 04:35:40'),
(2334,2,'credit',NULL,925000.0000,NULL,'2025-01-28 14:55:51',6,54423,35546,NULL,NULL,NULL,'2025-01-28 07:55:51','2025-01-28 07:55:51'),
(2335,2,'credit',NULL,147500.0000,NULL,'2025-01-28 15:04:25',3,39613,35547,NULL,NULL,NULL,'2025-01-28 08:04:25','2025-02-04 11:44:45'),
(2336,2,'credit',NULL,2000000.0000,NULL,'2025-01-28 15:32:44',49,54425,35549,NULL,NULL,NULL,'2025-01-28 08:32:44','2025-02-28 08:28:01'),
(2337,2,'credit',NULL,200000.0000,NULL,'2025-01-28 16:28:04',19,54259,35553,NULL,NULL,NULL,'2025-01-28 09:28:04','2025-02-19 04:14:33'),
(2338,2,'credit',NULL,55000.0000,NULL,'2025-01-28 21:38:10',6,54446,35564,NULL,NULL,NULL,'2025-01-28 14:38:10','2025-01-28 14:38:10'),
(2339,2,'credit',NULL,5995000.0000,NULL,'2025-01-29 11:11:26',93,54393,35573,NULL,NULL,NULL,'2025-01-29 04:11:26','2025-01-29 04:46:29'),
(2340,2,'credit',NULL,700000.0000,NULL,'2025-01-29 14:04:47',6,54034,35579,NULL,NULL,NULL,'2025-01-29 07:04:47','2025-01-29 07:04:47'),
(2341,2,'credit',NULL,2203000.0000,NULL,'2025-01-29 14:04:54',6,54476,35580,NULL,NULL,NULL,'2025-01-29 07:04:54','2025-01-29 07:04:54'),
(2342,2,'credit',NULL,120000.0000,NULL,'2025-01-29 15:59:47',49,54487,35588,NULL,NULL,NULL,'2025-01-29 08:59:47','2025-01-29 09:18:21'),
(2343,2,'credit',NULL,65000.0000,NULL,'2025-01-29 17:30:24',6,54499,35598,NULL,NULL,NULL,'2025-01-29 10:30:24','2025-01-29 10:30:24'),
(2344,2,'credit',NULL,80000.0000,NULL,'2025-01-29 17:38:43',6,54449,35599,NULL,NULL,NULL,'2025-01-29 10:38:43','2025-01-29 10:38:43'),
(2345,2,'credit',NULL,750000.0000,NULL,'2025-01-29 17:39:17',6,54501,35600,NULL,NULL,NULL,'2025-01-29 10:39:17','2025-01-29 10:39:17'),
(2346,2,'debit',NULL,6465000.0000,NULL,'2025-01-29 23:09:00',1,52476,35606,NULL,NULL,NULL,'2025-01-29 16:09:26','2025-01-29 16:09:26'),
(2347,2,'debit',NULL,4800000.0000,NULL,'2025-01-29 23:10:00',1,52370,35607,NULL,NULL,NULL,'2025-01-29 16:10:17','2025-01-29 16:10:17'),
(2348,2,'debit',NULL,240000.0000,NULL,'2025-01-29 23:12:00',1,52440,35608,NULL,NULL,NULL,'2025-01-29 16:12:27','2025-01-29 16:12:27'),
(2349,2,'debit',NULL,6545000.0000,NULL,'2025-01-29 23:12:00',1,52327,35609,NULL,NULL,NULL,'2025-01-29 16:12:58','2025-01-29 16:12:58'),
(2350,2,'debit',NULL,1950000.0000,NULL,'2025-01-29 23:13:00',1,52305,35610,NULL,NULL,NULL,'2025-01-29 16:13:40','2025-01-29 16:13:40'),
(2351,2,'debit',NULL,7035000.0000,NULL,'2025-01-30 13:43:00',1,54444,35625,NULL,NULL,NULL,'2025-01-30 06:43:31','2025-01-30 06:43:31'),
(2352,2,'credit',NULL,1575000.0000,NULL,'2025-01-30 15:02:16',106,54541,35629,NULL,NULL,NULL,'2025-01-30 08:02:16','2025-01-30 08:07:58'),
(2353,2,'credit',NULL,128000.0000,NULL,'2025-01-30 15:30:57',106,54547,35633,NULL,NULL,NULL,'2025-01-30 08:30:57','2025-01-30 08:30:57'),
(2354,2,'credit',NULL,200000.0000,NULL,'2025-01-30 20:34:53',46,54407,35651,NULL,NULL,NULL,'2025-01-30 13:34:53','2025-01-30 13:34:53'),
(2355,2,'credit',NULL,237000.0000,NULL,'2025-01-30 20:42:34',49,54580,35652,NULL,NULL,NULL,'2025-01-30 13:50:54','2025-01-30 13:50:54'),
(2356,2,'credit',NULL,50000.0000,NULL,'2025-01-31 10:53:01',3,52559,35664,NULL,NULL,NULL,'2025-01-31 03:53:01','2025-01-31 03:53:01'),
(2357,2,'credit',NULL,105000.0000,NULL,'2025-01-31 12:16:04',3,54614,35667,NULL,NULL,NULL,'2025-01-31 05:16:04','2025-01-31 05:16:04'),
(2358,2,'credit',NULL,608000.0000,NULL,'2025-01-31 14:18:00',5,54619,35690,NULL,NULL,NULL,'2025-01-31 07:18:00','2025-01-31 07:18:00'),
(2359,2,'credit',NULL,105000.0000,NULL,'2025-01-31 14:54:44',19,54626,35691,NULL,NULL,NULL,'2025-01-31 07:54:44','2025-01-31 13:16:59'),
(2360,2,'credit',NULL,150000.0000,NULL,'2025-01-31 15:05:47',6,54627,35693,NULL,NULL,NULL,'2025-01-31 08:05:47','2025-01-31 08:05:47'),
(2361,2,'credit',NULL,225000.0000,NULL,'2025-01-31 15:06:27',6,54628,35694,NULL,NULL,NULL,'2025-01-31 08:06:27','2025-01-31 08:06:27'),
(2362,2,'credit',NULL,635000.0000,NULL,'2025-01-31 15:12:01',3,54359,35696,NULL,NULL,NULL,'2025-01-31 08:12:01','2025-01-31 10:06:11'),
(2363,2,'debit',NULL,70000.0000,NULL,'2025-01-31 15:30:00',3,54637,35702,NULL,NULL,NULL,'2025-01-31 08:41:31','2025-01-31 08:41:31'),
(2364,2,'credit',NULL,650000.0000,NULL,'2025-01-31 15:49:10',19,54639,35703,NULL,NULL,'2025-01-31 09:28:29','2025-01-31 08:49:10','2025-01-31 09:28:29'),
(2365,2,'credit',NULL,180000.0000,NULL,'2025-01-31 15:49:53',19,54640,35704,NULL,NULL,'2025-01-31 09:27:31','2025-01-31 08:49:53','2025-01-31 09:27:31'),
(2366,2,'credit',NULL,144000.0000,NULL,'2025-01-31 15:50:31',46,54641,35705,NULL,NULL,NULL,'2025-01-31 08:50:31','2025-01-31 08:50:31'),
(2367,2,'credit',NULL,125000.0000,NULL,'2025-01-31 15:50:51',19,54642,35706,NULL,NULL,'2025-01-31 09:28:40','2025-01-31 08:50:51','2025-01-31 09:28:40'),
(2368,2,'credit',NULL,280000.0000,NULL,'2025-01-31 15:51:42',19,54643,35707,NULL,NULL,'2025-01-31 09:27:44','2025-01-31 08:51:42','2025-01-31 09:27:44'),
(2369,2,'credit',NULL,195000.0000,NULL,'2025-01-31 15:52:37',19,54645,35710,NULL,NULL,'2025-01-31 09:28:33','2025-01-31 08:52:37','2025-01-31 09:28:33'),
(2370,2,'credit',NULL,105000.0000,NULL,'2025-01-31 15:59:39',19,54638,35711,NULL,NULL,NULL,'2025-01-31 08:59:39','2025-01-31 13:14:48'),
(2371,2,'credit',NULL,150000.0000,NULL,'2025-01-31 16:06:26',19,54194,35714,NULL,NULL,NULL,'2025-01-31 09:06:26','2025-01-31 09:06:26'),
(2372,2,'credit',NULL,175000.0000,NULL,'2025-01-31 16:07:44',19,54191,35716,NULL,NULL,NULL,'2025-01-31 09:07:44','2025-01-31 09:21:57'),
(2373,2,'credit',NULL,280000.0000,NULL,'2025-01-31 16:09:24',19,54193,35717,NULL,NULL,NULL,'2025-01-31 09:09:25','2025-01-31 09:09:25'),
(2374,2,'credit',NULL,195000.0000,NULL,'2025-01-31 16:12:02',19,54648,35718,NULL,NULL,NULL,'2025-01-31 09:12:02','2025-01-31 09:12:02'),
(2375,2,'credit',NULL,185000.0000,NULL,'2025-01-31 17:06:45',3,54655,35726,NULL,NULL,NULL,'2025-01-31 10:06:45','2025-01-31 10:06:45'),
(2376,2,'credit',NULL,335000.0000,NULL,'2025-01-31 18:07:51',5,54659,35728,NULL,NULL,NULL,'2025-01-31 11:07:51','2025-01-31 11:07:51'),
(2377,2,'credit',NULL,440000.0000,NULL,'2025-01-31 18:12:48',6,54660,35729,NULL,NULL,NULL,'2025-01-31 11:12:48','2025-01-31 11:12:48'),
(2378,2,'credit',NULL,440000.0000,NULL,'2025-01-31 18:19:18',6,54663,35731,NULL,NULL,NULL,'2025-01-31 11:19:18','2025-01-31 11:19:18'),
(2379,2,'credit',NULL,412500.0000,NULL,'2025-01-31 19:43:32',6,54669,35734,NULL,NULL,NULL,'2025-01-31 12:43:32','2025-01-31 12:43:32'),
(2380,2,'credit',NULL,412500.0000,NULL,'2025-01-31 19:44:36',6,54670,35735,NULL,NULL,NULL,'2025-01-31 12:44:36','2025-01-31 12:44:36'),
(2381,2,'credit',NULL,102500.0000,NULL,'2025-01-31 19:46:48',6,54671,35737,NULL,NULL,NULL,'2025-01-31 12:46:48','2025-01-31 12:46:48'),
(2382,2,'credit',NULL,102500.0000,NULL,'2025-01-31 19:49:53',6,54672,35738,NULL,NULL,NULL,'2025-01-31 12:49:53','2025-01-31 12:49:53'),
(2383,2,'credit',NULL,160000.0000,NULL,'2025-01-31 20:03:09',6,54675,35739,NULL,NULL,NULL,'2025-01-31 13:03:09','2025-01-31 13:03:09'),
(2384,2,'credit',NULL,160000.0000,NULL,'2025-01-31 20:03:51',6,54676,35740,NULL,NULL,NULL,'2025-01-31 13:03:51','2025-01-31 13:03:51'),
(2385,2,'credit',NULL,150000.0000,NULL,'2025-01-31 20:05:12',6,54677,35741,NULL,NULL,NULL,'2025-01-31 13:05:12','2025-01-31 13:05:12'),
(2386,2,'credit',NULL,5000.0000,NULL,'2025-01-31 20:11:32',6,54678,35743,NULL,NULL,NULL,'2025-01-31 13:11:32','2025-01-31 13:11:32'),
(2387,2,'credit',NULL,40000.0000,NULL,'2025-01-31 20:13:56',6,54679,35745,NULL,NULL,NULL,'2025-01-31 13:13:56','2025-01-31 13:13:56'),
(2388,2,'credit',NULL,465000.0000,NULL,'2025-01-31 20:14:29',6,54680,35746,NULL,NULL,NULL,'2025-01-31 13:14:29','2025-01-31 13:14:29'),
(2389,2,'credit',NULL,40000.0000,NULL,'2025-01-31 20:16:10',6,54683,35748,NULL,NULL,NULL,'2025-01-31 13:16:10','2025-01-31 13:16:10'),
(2390,2,'credit',NULL,40000.0000,NULL,'2025-01-31 20:16:44',6,54684,35749,NULL,NULL,NULL,'2025-01-31 13:16:44','2025-01-31 13:16:44'),
(2391,2,'credit',NULL,176000.0000,NULL,'2025-02-01 11:54:26',3,54695,35773,NULL,NULL,NULL,'2025-02-01 04:54:26','2025-02-04 11:10:49'),
(2392,2,'credit',NULL,712000.0000,NULL,'2025-02-01 14:15:21',106,54621,35783,NULL,NULL,NULL,'2025-02-01 07:15:21','2025-02-01 08:47:32'),
(2393,2,'debit',NULL,395000.0000,NULL,'2025-02-01 23:57:00',1,54722,35821,NULL,NULL,NULL,'2025-02-01 16:57:12','2025-02-01 16:57:12'),
(2394,2,'debit',NULL,30000.0000,NULL,'2025-02-01 23:57:00',1,54661,35822,NULL,NULL,NULL,'2025-02-01 16:57:20','2025-02-01 16:57:20'),
(2395,2,'debit',NULL,880000.0000,NULL,'2025-02-02 00:03:00',1,53641,35823,NULL,NULL,NULL,'2025-02-01 17:03:46','2025-02-01 17:03:46'),
(2396,2,'debit',NULL,437000.0000,NULL,'2025-02-02 01:49:00',1,54634,35824,NULL,NULL,NULL,'2025-02-01 18:49:10','2025-02-01 18:49:10'),
(2397,2,'debit',NULL,36715000.0000,NULL,'2025-02-02 06:11:00',1,51606,35825,NULL,NULL,NULL,'2025-02-01 23:11:36','2025-02-01 23:11:36'),
(2398,2,'debit',NULL,100000.0000,NULL,'2025-02-02 10:58:00',1,54076,35834,NULL,NULL,NULL,'2025-02-02 03:58:20','2025-02-02 03:58:20'),
(2399,2,'debit',NULL,49500.0000,NULL,'2025-02-02 11:01:00',1,54246,35835,NULL,NULL,NULL,'2025-02-02 04:01:38','2025-02-02 04:01:38'),
(2400,2,'debit',NULL,412000.0000,NULL,'2025-02-02 11:07:00',1,54258,35838,NULL,NULL,NULL,'2025-02-02 04:08:02','2025-02-02 04:08:02'),
(2401,2,'debit',NULL,495275.0000,NULL,'2025-02-02 11:10:00',1,54358,35839,NULL,NULL,NULL,'2025-02-02 04:10:09','2025-02-02 04:10:09'),
(2402,2,'debit',NULL,1440000.0000,NULL,'2025-02-02 11:27:00',1,54557,35842,NULL,NULL,NULL,'2025-02-02 04:27:48','2025-02-02 04:27:48'),
(2403,2,'debit',NULL,2370000.0000,NULL,'2025-02-02 11:28:00',1,54563,35843,NULL,NULL,NULL,'2025-02-02 04:28:05','2025-02-02 04:28:05'),
(2404,2,'debit',NULL,390000.0000,NULL,'2025-02-02 11:30:00',1,54592,35845,NULL,NULL,NULL,'2025-02-02 04:30:28','2025-02-02 04:30:28'),
(2405,2,'debit',NULL,2425500.0000,NULL,'2025-02-02 11:33:00',1,54299,35846,NULL,NULL,NULL,'2025-02-02 04:34:01','2025-02-02 04:34:01'),
(2406,2,'debit',NULL,260000.0000,NULL,'2025-02-02 11:37:00',1,54429,35847,NULL,NULL,NULL,'2025-02-02 04:37:58','2025-02-02 04:37:58'),
(2407,2,'debit',NULL,2626700.0000,NULL,'2025-02-02 11:39:00',1,54530,35848,NULL,NULL,NULL,'2025-02-02 04:39:49','2025-02-02 04:39:49'),
(2408,2,'debit',NULL,336700.0000,NULL,'2025-02-02 11:40:00',1,54608,35849,NULL,NULL,NULL,'2025-02-02 04:40:38','2025-02-02 04:40:38'),
(2409,2,'debit',NULL,480400.0000,NULL,'2025-02-02 11:56:00',1,54607,35850,NULL,NULL,NULL,'2025-02-02 04:56:33','2025-02-02 04:56:33'),
(2410,2,'credit',NULL,5820000.0000,NULL,'2025-02-02 12:06:33',6,54765,35851,NULL,NULL,NULL,'2025-02-02 05:06:33','2025-02-05 02:20:28'),
(2411,2,'debit',NULL,1620000.0000,NULL,'2025-02-02 14:39:00',1,54441,35860,NULL,NULL,NULL,'2025-02-02 07:39:38','2025-02-02 07:39:38'),
(2412,2,'credit',NULL,260000.0000,NULL,'2025-02-02 15:58:26',106,54327,35870,NULL,NULL,NULL,'2025-02-02 08:58:26','2025-02-02 08:58:26'),
(2413,2,'debit',NULL,2277000.0000,NULL,'2025-02-03 09:15:00',1,49029,35900,NULL,NULL,NULL,'2025-02-03 02:15:08','2025-02-03 02:15:08'),
(2414,2,'credit',NULL,1570000.0000,NULL,'2025-02-03 10:23:28',106,54814,35905,NULL,NULL,NULL,'2025-02-03 03:23:28','2025-02-03 03:23:28'),
(2415,2,'credit',NULL,200000.0000,NULL,'2025-02-03 11:41:55',5,54576,35920,NULL,NULL,NULL,'2025-02-03 04:41:55','2025-02-15 15:13:18'),
(2416,2,'credit',NULL,87000.0000,NULL,'2025-02-03 11:57:54',106,54832,35921,NULL,NULL,NULL,'2025-02-03 04:57:54','2025-02-03 04:57:54'),
(2417,2,'debit',NULL,25467800.0000,NULL,'2025-02-03 11:58:00',1,48860,35922,NULL,NULL,NULL,'2025-02-03 04:58:40','2025-02-03 04:58:40'),
(2418,2,'credit',NULL,210000.0000,NULL,'2025-02-03 15:35:07',13,54857,35937,NULL,NULL,NULL,'2025-02-03 08:35:07','2025-02-03 08:35:07'),
(2419,2,'credit',NULL,391000.0000,NULL,'2025-02-03 17:29:28',19,54868,35944,NULL,NULL,NULL,'2025-02-03 10:29:28','2025-03-01 07:09:30'),
(2420,2,'debit',NULL,270000.0000,NULL,'2025-02-03 20:12:00',3,54891,35954,NULL,NULL,NULL,'2025-02-03 13:14:57','2025-02-03 13:14:57'),
(2421,2,'debit',NULL,958400.0000,NULL,'2025-02-04 08:55:00',1,51845,35961,NULL,NULL,NULL,'2025-02-04 01:55:44','2025-02-04 01:55:44'),
(2422,2,'debit',NULL,60806000.0000,NULL,'2025-02-04 09:02:00',1,54869,35962,NULL,NULL,NULL,'2025-02-04 02:03:10','2025-02-04 02:03:10'),
(2423,2,'credit',NULL,210000.0000,NULL,'2025-02-04 09:20:41',5,54907,35964,NULL,NULL,'2025-02-04 02:20:48','2025-02-04 02:20:41','2025-02-04 02:20:48'),
(2424,2,'credit',NULL,210000.0000,NULL,'2025-02-04 09:21:08',5,54908,35965,NULL,NULL,NULL,'2025-02-04 02:21:08','2025-02-04 02:21:08'),
(2425,2,'credit',NULL,140000.0000,NULL,'2025-02-04 09:21:28',5,54909,35966,NULL,NULL,NULL,'2025-02-04 02:21:28','2025-02-04 07:33:02'),
(2426,2,'credit',NULL,439000.0000,NULL,'2025-02-04 09:25:07',5,54910,35968,NULL,NULL,'2025-02-04 02:25:43','2025-02-04 02:25:07','2025-02-04 02:25:43'),
(2427,2,'credit',NULL,439000.0000,NULL,'2025-02-04 09:26:26',5,54912,35969,NULL,NULL,'2025-02-04 03:09:07','2025-02-04 02:26:26','2025-02-04 03:09:07'),
(2428,2,'credit',NULL,5748000.0000,NULL,'2025-02-04 09:45:58',5,54913,35970,NULL,NULL,'2025-02-04 04:06:49','2025-02-04 02:45:58','2025-02-04 04:06:49'),
(2429,2,'credit',NULL,439000.0000,NULL,'2025-02-04 10:09:34',5,54918,35975,NULL,NULL,'2025-02-04 03:10:18','2025-02-04 03:09:34','2025-02-04 03:10:18'),
(2430,2,'credit',NULL,519100.0000,NULL,'2025-02-04 10:12:24',5,54920,35977,NULL,NULL,NULL,'2025-02-04 03:12:24','2025-02-04 03:17:14'),
(2431,2,'credit',NULL,12100000.0000,NULL,'2025-02-04 11:08:05',106,54929,35983,NULL,NULL,NULL,'2025-02-04 04:08:05','2025-11-26 07:22:23'),
(2432,2,'credit',NULL,6100000.0000,NULL,'2025-02-04 11:08:30',5,54930,35984,NULL,NULL,'2025-02-04 04:09:52','2025-02-04 04:08:30','2025-02-04 04:09:52'),
(2433,2,'credit',NULL,5748000.0000,NULL,'2025-02-04 11:11:47',5,54931,35985,NULL,NULL,'2025-02-04 04:13:57','2025-02-04 04:11:47','2025-02-04 04:13:57'),
(2434,2,'credit',NULL,5748000.0000,NULL,'2025-02-04 11:14:20',5,54932,35986,NULL,NULL,'2025-02-04 04:16:57','2025-02-04 04:14:20','2025-02-04 04:16:57'),
(2435,2,'credit',NULL,5748000.0000,NULL,'2025-02-04 11:15:46',5,54933,35987,NULL,NULL,NULL,'2025-02-04 04:15:46','2025-02-04 04:15:46'),
(2436,2,'credit',NULL,245000.0000,NULL,'2025-02-04 11:43:18',6,54938,35991,NULL,NULL,NULL,'2025-02-04 04:43:18','2025-02-04 04:43:18'),
(2437,2,'credit',NULL,3284000.0000,NULL,'2025-02-04 12:11:36',6,54945,35994,NULL,NULL,NULL,'2025-02-04 05:11:36','2025-02-05 04:34:01'),
(2438,2,'credit',NULL,477000.0000,NULL,'2025-02-04 13:31:15',13,54951,35996,NULL,NULL,NULL,'2025-02-04 06:31:15','2025-02-04 06:31:15'),
(2439,2,'credit',NULL,2800000.0000,NULL,'2025-02-04 15:03:32',49,54856,36001,NULL,NULL,NULL,'2025-02-04 08:03:32','2025-02-04 08:03:32'),
(2440,2,'credit',NULL,0.0000,NULL,'2025-02-04 15:16:40',93,54795,36002,NULL,NULL,NULL,'2025-02-04 08:16:40','2025-02-09 14:38:58'),
(2441,2,'debit',NULL,6015000.0000,NULL,'2025-02-04 17:31:00',1,54953,36021,NULL,NULL,NULL,'2025-02-04 10:31:18','2025-02-04 10:31:18'),
(2442,2,'debit',NULL,7174000.0000,NULL,'2025-02-04 17:31:00',1,54403,36022,NULL,NULL,NULL,'2025-02-04 10:31:51','2025-02-04 10:31:51'),
(2443,2,'debit',NULL,111280.0000,NULL,'2025-02-04 17:35:00',1,54968,36023,NULL,NULL,NULL,'2025-02-04 10:35:39','2025-02-04 10:35:39'),
(2444,2,'credit',NULL,201700.0000,NULL,'2025-02-04 18:08:16',13,51801,36025,NULL,NULL,NULL,'2025-02-04 11:08:16','2025-02-04 11:08:16'),
(2445,2,'debit',NULL,13421200.0000,NULL,'2025-02-04 18:42:00',1,54952,36026,NULL,NULL,NULL,'2025-02-04 11:42:23','2025-02-04 11:42:23'),
(2446,2,'credit',NULL,259600.0000,NULL,'2025-02-04 18:44:45',3,39613,36027,NULL,NULL,NULL,'2025-02-04 11:44:45','2025-02-04 11:44:45'),
(2447,2,'debit',NULL,27195000.0000,NULL,'2025-02-04 18:46:00',1,54847,36028,NULL,NULL,NULL,'2025-02-04 11:46:35','2025-02-04 11:46:35'),
(2448,2,'debit',NULL,285000.0000,NULL,'2025-02-04 18:47:00',1,54980,36029,NULL,NULL,NULL,'2025-02-04 11:47:43','2025-02-04 11:47:43'),
(2449,2,'debit',NULL,800000.0000,NULL,'2025-02-04 18:48:00',1,54849,36030,NULL,NULL,NULL,'2025-02-04 11:48:15','2025-02-04 11:48:15'),
(2450,2,'debit',NULL,27897600.0000,NULL,'2025-02-04 19:00:00',1,54845,36031,NULL,NULL,NULL,'2025-02-04 12:00:14','2025-02-04 12:00:14'),
(2451,2,'debit',NULL,18180800.0000,NULL,'2025-02-04 19:15:00',1,54844,36032,NULL,NULL,NULL,'2025-02-04 12:15:46','2025-02-04 12:15:46'),
(2452,2,'debit',NULL,17401800.0000,NULL,'2025-02-04 19:45:00',1,54846,36037,NULL,NULL,NULL,'2025-02-04 12:45:41','2025-02-04 12:45:41'),
(2453,2,'debit',NULL,6362400.0000,NULL,'2025-02-04 20:01:00',1,54848,36038,NULL,NULL,NULL,'2025-02-04 13:01:21','2025-02-04 13:01:21'),
(2454,2,'credit',NULL,2550000.0000,NULL,'2025-02-04 21:06:56',13,54988,36042,NULL,NULL,NULL,'2025-02-04 14:06:56','2025-02-25 03:43:48'),
(2455,2,'debit',NULL,61902.0000,NULL,'2025-02-05 00:26:00',1,54925,36044,NULL,NULL,NULL,'2025-02-04 17:26:55','2025-02-04 17:26:55'),
(2456,2,'debit',NULL,190000.0000,NULL,'2025-02-05 00:28:00',1,54960,36045,NULL,NULL,NULL,'2025-02-04 17:28:24','2025-02-04 17:28:24'),
(2457,2,'debit',NULL,2101000.0000,NULL,'2025-02-05 00:29:00',1,52225,36046,NULL,NULL,NULL,'2025-02-04 17:29:27','2025-02-04 17:29:27'),
(2458,2,'debit',NULL,800000.0000,NULL,'2025-02-05 00:29:00',1,52250,36047,NULL,NULL,NULL,'2025-02-04 17:29:44','2025-02-04 17:29:44'),
(2459,2,'debit',NULL,28227900.0000,NULL,'2025-02-05 00:30:00',1,51678,36048,NULL,NULL,NULL,'2025-02-04 17:30:15','2025-02-04 17:30:15'),
(2460,2,'credit',NULL,95000.0000,NULL,'2025-02-05 12:51:33',5,55006,36061,NULL,NULL,NULL,'2025-02-05 05:51:33','2025-02-05 06:16:41'),
(2461,2,'credit',NULL,130000.0000,NULL,'2025-02-05 13:16:41',13,55006,36063,NULL,NULL,NULL,'2025-02-05 06:16:41','2025-02-05 06:16:41'),
(2462,2,'credit',NULL,415000.0000,NULL,'2025-02-05 14:28:10',5,55012,36066,NULL,NULL,NULL,'2025-02-05 07:28:10','2025-02-05 07:28:10'),
(2463,2,'credit',NULL,350000.0000,NULL,'2025-02-05 15:27:04',49,54331,36068,NULL,NULL,NULL,'2025-02-05 08:27:04','2025-02-05 08:27:04'),
(2464,2,'credit',NULL,1525000.0000,NULL,'2025-02-05 21:50:13',106,55039,36095,NULL,NULL,NULL,'2025-02-05 14:50:13','2025-02-05 14:50:13'),
(2465,2,'credit',NULL,70000.0000,NULL,'2025-02-06 15:58:01',6,55071,36130,NULL,NULL,NULL,'2025-02-06 08:58:01','2025-02-06 08:58:01'),
(2466,2,'credit',NULL,65000.0000,NULL,'2025-02-06 16:24:17',46,55074,36132,NULL,NULL,NULL,'2025-02-06 09:24:17','2025-02-06 09:24:17'),
(2467,2,'credit',NULL,15000.0000,NULL,'2025-02-06 21:38:58',13,55072,36147,NULL,NULL,NULL,'2025-02-06 14:38:58','2025-02-06 14:38:58'),
(2468,2,'credit',NULL,10000000.0000,NULL,'2025-02-07 10:10:39',5,51855,36158,NULL,NULL,NULL,'2025-02-07 03:10:39','2025-02-28 09:50:39'),
(2469,2,'credit',NULL,120000.0000,NULL,'2025-02-07 10:49:55',5,54939,36183,NULL,NULL,NULL,'2025-02-07 03:49:55','2025-02-07 04:10:50'),
(2470,2,'credit',NULL,495000.0000,NULL,'2025-02-07 10:56:23',49,55096,36185,NULL,NULL,NULL,'2025-02-07 03:56:23','2025-02-07 03:56:23'),
(2471,2,'credit',NULL,5000.0000,NULL,'2025-02-07 11:11:33',5,55107,36186,NULL,NULL,NULL,'2025-02-07 04:11:33','2025-02-07 04:11:33'),
(2472,2,'credit',NULL,1285000.0000,NULL,'2025-02-07 11:29:46',6,55111,36188,NULL,NULL,NULL,'2025-02-07 04:29:46','2025-02-07 04:29:46'),
(2473,2,'debit',NULL,155000.0000,NULL,'2025-02-07 13:58:00',3,55114,36190,NULL,NULL,NULL,'2025-02-07 07:03:37','2025-02-07 07:03:37'),
(2474,2,'credit',NULL,7720000.0000,NULL,'2025-02-07 14:06:56',49,55110,36191,NULL,NULL,NULL,'2025-02-07 07:06:56','2025-02-07 07:13:47'),
(2475,2,'credit',NULL,1009000.0000,NULL,'2025-02-07 17:42:03',3,55132,36201,NULL,NULL,NULL,'2025-02-07 10:42:03','2025-02-15 04:35:51'),
(2476,2,'credit',NULL,200000.0000,NULL,'2025-02-07 19:44:25',19,54870,36210,NULL,NULL,NULL,'2025-02-07 12:44:25','2025-05-16 10:54:20'),
(2477,2,'credit',NULL,120000.0000,NULL,'2025-02-08 08:31:29',49,55133,36223,NULL,NULL,NULL,'2025-02-08 01:31:29','2025-02-09 07:32:22'),
(2478,2,'credit',NULL,12100000.0000,NULL,'2025-02-08 09:35:38',106,54929,36225,NULL,NULL,NULL,'2025-02-08 02:35:38','2025-11-26 07:22:23'),
(2479,2,'credit',NULL,250000.0000,NULL,'2025-02-08 10:57:12',106,54944,36226,NULL,NULL,NULL,'2025-02-08 03:57:12','2025-02-08 03:57:12'),
(2480,2,'credit',NULL,298000.0000,NULL,'2025-02-08 10:57:45',106,55162,36227,NULL,NULL,NULL,'2025-02-08 03:57:45','2025-02-08 03:57:45'),
(2481,2,'credit',NULL,155000.0000,NULL,'2025-02-08 15:44:38',3,55190,36247,NULL,NULL,NULL,'2025-02-08 08:44:38','2025-02-15 05:14:55'),
(2482,2,'credit',NULL,250000.0000,NULL,'2025-02-08 17:36:46',93,55198,36252,NULL,NULL,NULL,'2025-02-08 10:36:46','2025-02-09 08:02:40'),
(2483,2,'debit',NULL,3600000.0000,NULL,'2025-02-09 10:53:00',1,55052,36272,NULL,NULL,NULL,'2025-02-09 03:53:40','2025-02-09 03:53:40'),
(2484,2,'credit',NULL,400000.0000,NULL,'2025-02-10 10:49:01',106,55266,36308,NULL,NULL,NULL,'2025-02-10 03:49:01','2025-02-10 03:49:01'),
(2485,2,'credit',NULL,196000.0000,NULL,'2025-02-10 12:17:37',49,55274,36313,NULL,NULL,NULL,'2025-02-10 05:17:37','2025-02-28 10:01:40'),
(2486,2,'credit',NULL,200000.0000,NULL,'2025-02-10 12:18:09',49,54835,36314,NULL,NULL,NULL,'2025-02-10 05:18:09','2025-02-10 05:18:09'),
(2487,2,'credit',NULL,979000.0000,NULL,'2025-02-10 12:42:04',19,55269,36317,NULL,NULL,NULL,'2025-02-10 05:42:04','2025-02-10 05:42:04'),
(2488,2,'credit',NULL,500000.0000,NULL,'2025-02-10 14:51:50',19,55288,36321,NULL,NULL,NULL,'2025-02-10 07:51:50','2025-02-10 07:51:50'),
(2489,2,'credit',NULL,146000.0000,NULL,'2025-02-10 15:35:06',5,55291,36324,NULL,NULL,NULL,'2025-02-10 08:35:06','2025-02-10 08:59:50'),
(2490,2,'credit',NULL,8000.0000,NULL,'2025-02-10 16:00:18',5,55295,36326,NULL,NULL,NULL,'2025-02-10 09:00:18','2025-02-10 09:00:18'),
(2491,2,'credit',NULL,520000.0000,NULL,'2025-02-11 09:10:36',19,55331,36353,NULL,NULL,NULL,'2025-02-11 02:10:36','2025-02-11 02:10:36'),
(2492,2,'credit',NULL,410000.0000,NULL,'2025-02-11 09:10:52',19,54871,36354,NULL,NULL,NULL,'2025-02-11 02:10:52','2025-02-11 02:10:52'),
(2493,2,'credit',NULL,640000.0000,NULL,'2025-02-11 09:58:12',19,55335,36356,NULL,NULL,NULL,'2025-02-11 02:58:12','2025-02-11 02:58:12'),
(2494,2,'credit',NULL,85000.0000,NULL,'2025-02-11 11:59:08',46,55326,36366,NULL,NULL,NULL,'2025-02-11 04:59:08','2025-02-11 04:59:08'),
(2495,2,'credit',NULL,3000000.0000,NULL,'2025-02-11 12:50:52',3,55346,36368,NULL,NULL,NULL,'2025-02-11 05:50:52','2025-02-12 05:13:06'),
(2496,2,'debit',NULL,3585000.0000,NULL,'2025-02-11 13:11:00',1,55303,36370,NULL,NULL,NULL,'2025-02-11 06:11:24','2025-02-11 06:11:24'),
(2497,2,'credit',NULL,500000.0000,NULL,'2025-02-11 13:14:08',5,55349,36371,NULL,NULL,NULL,'2025-02-11 06:14:08','2025-02-12 05:20:49'),
(2498,2,'debit',NULL,5090000.0000,NULL,'2025-02-11 13:14:00',1,54773,36372,NULL,NULL,'2025-02-14 01:53:01','2025-02-11 06:14:15','2025-02-14 01:53:01'),
(2499,2,'debit',NULL,505000.0000,NULL,'2025-02-11 13:34:00',1,55348,36374,NULL,NULL,NULL,'2025-02-11 06:34:39','2025-02-11 06:34:39'),
(2500,2,'credit',NULL,455000.0000,NULL,'2025-02-11 13:38:41',6,55279,36375,NULL,NULL,NULL,'2025-02-11 06:38:41','2025-02-11 06:38:41'),
(2501,2,'debit',NULL,11597400.0000,NULL,'2025-02-11 13:42:00',1,55313,36379,NULL,NULL,NULL,'2025-02-11 06:42:07','2025-02-11 06:42:07'),
(2502,2,'debit',NULL,220000.0000,NULL,'2025-02-11 13:43:00',1,55353,36380,NULL,NULL,NULL,'2025-02-11 06:43:19','2025-02-11 06:43:19'),
(2503,2,'debit',NULL,5895000.0000,NULL,'2025-02-11 13:45:00',1,55278,36381,NULL,NULL,NULL,'2025-02-11 06:45:24','2025-02-11 06:45:24'),
(2504,2,'debit',NULL,325300.0000,NULL,'2025-02-11 13:49:00',1,55268,36382,NULL,NULL,NULL,'2025-02-11 06:49:31','2025-02-11 06:49:31'),
(2505,2,'debit',NULL,54000.0000,NULL,'2025-02-11 13:51:00',1,55264,36383,NULL,NULL,NULL,'2025-02-11 06:51:24','2025-02-11 06:51:24'),
(2506,2,'debit',NULL,270300.0000,NULL,'2025-02-11 13:53:00',1,55228,36384,NULL,NULL,NULL,'2025-02-11 06:53:27','2025-02-11 06:53:27'),
(2507,2,'debit',NULL,142800.0000,NULL,'2025-02-11 13:54:00',1,55205,36385,NULL,NULL,NULL,'2025-02-11 06:54:08','2025-02-11 06:54:08'),
(2508,2,'debit',NULL,265000.0000,NULL,'2025-02-11 13:54:00',1,55154,36386,NULL,NULL,NULL,'2025-02-11 06:54:37','2025-02-11 06:54:37'),
(2509,2,'debit',NULL,525000.0000,NULL,'2025-02-11 13:55:00',1,55120,36387,NULL,NULL,NULL,'2025-02-11 06:55:03','2025-02-11 06:55:03'),
(2510,2,'debit',NULL,19604000.0000,NULL,'2025-02-11 14:01:00',1,54905,36388,NULL,NULL,NULL,'2025-02-11 07:01:59','2025-02-11 07:01:59'),
(2511,2,'debit',NULL,8266000.0000,NULL,'2025-02-11 14:19:00',1,54979,36392,NULL,NULL,NULL,'2025-02-11 07:19:18','2025-02-11 07:19:18'),
(2512,2,'debit',NULL,6464600.0000,NULL,'2025-02-11 14:35:00',1,50295,36393,NULL,NULL,NULL,'2025-02-11 07:35:16','2025-02-11 07:35:16'),
(2513,2,'debit',NULL,7672800.0000,NULL,'2025-02-11 14:38:00',1,54529,36395,NULL,NULL,NULL,'2025-02-11 07:38:20','2025-02-11 07:38:20'),
(2514,2,'debit',NULL,4794000.0000,NULL,'2025-02-11 14:58:00',1,54911,36398,NULL,NULL,NULL,'2025-02-11 07:58:16','2025-02-11 07:58:16'),
(2515,2,'credit',NULL,66000.0000,NULL,'2025-02-11 15:02:28',19,55370,36399,NULL,NULL,NULL,'2025-02-11 08:02:28','2025-02-11 08:02:28'),
(2516,2,'debit',NULL,2730000.0000,NULL,'2025-02-11 15:05:00',1,54898,36400,NULL,NULL,NULL,'2025-02-11 08:05:45','2025-02-11 08:05:45'),
(2517,2,'debit',NULL,13900000.0000,NULL,'2025-02-11 15:14:00',1,55095,36403,NULL,NULL,NULL,'2025-02-11 08:14:21','2025-02-11 08:14:21'),
(2518,2,'credit',NULL,14000.0000,NULL,'2025-02-11 15:56:30',6,55377,36406,NULL,NULL,NULL,'2025-02-11 08:56:30','2025-02-11 08:56:30'),
(2519,2,'credit',NULL,421000.0000,NULL,'2025-02-11 16:04:47',3,55368,36409,NULL,NULL,NULL,'2025-02-11 09:04:47','2025-02-15 05:17:44'),
(2520,2,'credit',NULL,171000.0000,NULL,'2025-02-11 16:36:33',3,55381,36413,NULL,NULL,NULL,'2025-02-11 09:36:33','2025-02-11 09:36:33'),
(2521,2,'credit',NULL,646000.0000,NULL,'2025-02-11 17:46:19',93,55387,36418,NULL,NULL,NULL,'2025-02-11 10:46:19','2025-03-01 06:26:47'),
(2522,2,'credit',NULL,150000.0000,NULL,'2025-02-11 20:57:16',5,55399,36433,NULL,NULL,NULL,'2025-02-11 13:57:16','2025-02-15 04:28:28'),
(2523,2,'credit',NULL,80000.0000,NULL,'2025-02-12 09:01:51',3,55379,36437,NULL,NULL,NULL,'2025-02-12 02:01:51','2025-02-12 02:01:51'),
(2524,2,'credit',NULL,4950000.0000,NULL,'2025-02-12 10:29:28',106,55426,36451,NULL,NULL,NULL,'2025-02-12 03:29:28','2025-02-12 03:44:10'),
(2525,2,'credit',NULL,83000.0000,NULL,'2025-02-12 11:23:28',46,55430,36455,NULL,NULL,NULL,'2025-02-12 04:23:28','2025-02-12 04:23:28'),
(2526,2,'credit',NULL,486000.0000,NULL,'2025-02-12 11:36:44',10,55434,36457,NULL,NULL,NULL,'2025-02-12 04:36:44','2025-02-12 04:36:44'),
(2527,2,'credit',NULL,150000.0000,NULL,'2025-02-12 12:06:35',3,55440,36459,NULL,NULL,NULL,'2025-02-12 05:06:35','2025-02-12 05:06:35'),
(2528,2,'credit',NULL,400000.0000,NULL,'2025-02-12 12:07:23',3,55349,36460,NULL,NULL,NULL,'2025-02-12 05:07:23','2025-02-12 05:07:23'),
(2529,2,'credit',NULL,140000.0000,NULL,'2025-02-12 12:08:12',106,55441,36461,NULL,NULL,NULL,'2025-02-12 05:08:12','2025-02-12 05:08:12'),
(2530,2,'credit',NULL,94000.0000,NULL,'2025-02-12 14:20:08',19,55453,36475,NULL,NULL,NULL,'2025-02-12 07:20:08','2025-02-12 07:20:08'),
(2531,2,'credit',NULL,390000.0000,NULL,'2025-02-13 09:12:23',49,55484,36497,NULL,NULL,NULL,'2025-02-13 02:12:23','2025-02-13 02:12:23'),
(2532,2,'debit',NULL,111000.0000,NULL,'2025-02-13 12:28:00',3,55504,36510,NULL,NULL,NULL,'2025-02-13 05:30:57','2025-02-13 05:30:57'),
(2533,2,'credit',NULL,200000.0000,NULL,'2025-02-13 14:55:08',106,55514,36520,NULL,NULL,NULL,'2025-02-13 08:03:45','2025-02-13 08:03:45'),
(2534,2,'credit',NULL,799000.0000,NULL,'2025-02-13 15:20:14',106,55517,36524,NULL,NULL,NULL,'2025-02-13 08:20:14','2025-02-13 08:20:14'),
(2535,2,'credit',NULL,150000.0000,NULL,'2025-02-13 16:46:00',19,55465,36530,NULL,NULL,NULL,'2025-02-13 09:46:00','2025-02-13 09:46:00'),
(2536,2,'debit',NULL,10944000.0000,NULL,'2025-02-14 09:00:00',1,54298,36548,NULL,NULL,NULL,'2025-02-14 02:00:45','2025-02-14 02:00:45'),
(2537,2,'debit',NULL,25617200.0000,NULL,'2025-02-14 09:17:00',1,54533,36549,NULL,NULL,NULL,'2025-02-14 02:17:17','2025-02-14 02:17:17'),
(2538,2,'debit',NULL,5122500.0000,NULL,'2025-02-14 09:18:00',1,54590,36550,NULL,NULL,NULL,'2025-02-14 02:18:24','2025-02-14 02:18:24'),
(2539,2,'debit',NULL,5396200.0000,NULL,'2025-02-14 09:19:00',1,54295,36551,NULL,NULL,NULL,'2025-02-14 02:19:20','2025-02-14 02:19:20'),
(2540,2,'debit',NULL,6302000.0000,NULL,'2025-02-14 09:20:00',1,54778,36552,NULL,NULL,NULL,'2025-02-14 02:20:15','2025-02-14 02:20:15'),
(2541,2,'debit',NULL,9028700.0000,NULL,'2025-02-14 09:24:00',1,54779,36553,NULL,NULL,NULL,'2025-02-14 02:24:48','2025-02-14 02:24:48'),
(2542,2,'debit',NULL,90402.0000,NULL,'2025-02-14 09:25:00',1,54481,36554,NULL,NULL,NULL,'2025-02-14 02:25:51','2025-02-14 02:25:51'),
(2543,2,'debit',NULL,2611500.0000,NULL,'2025-02-14 09:38:00',1,54774,36555,NULL,NULL,NULL,'2025-02-14 02:39:05','2025-02-14 02:39:05'),
(2544,2,'debit',NULL,205300.0000,NULL,'2025-02-14 09:44:00',1,54865,36557,NULL,NULL,NULL,'2025-02-14 02:44:28','2025-02-14 02:44:28'),
(2545,2,'debit',NULL,800000.0000,NULL,'2025-02-14 09:48:00',1,55432,36558,NULL,NULL,NULL,'2025-02-14 02:48:32','2025-02-14 02:48:32'),
(2546,2,'debit',NULL,800000.0000,NULL,'2025-02-14 09:49:00',1,55375,36559,NULL,NULL,NULL,'2025-02-14 02:49:07','2025-02-14 02:49:07'),
(2547,2,'debit',NULL,1135000.0000,NULL,'2025-02-14 09:50:00',1,55367,36561,NULL,NULL,NULL,'2025-02-14 02:50:20','2025-02-14 02:50:20'),
(2548,2,'debit',NULL,85000.0000,NULL,'2025-02-14 09:57:00',1,55384,36566,NULL,NULL,NULL,'2025-02-14 02:57:28','2025-02-14 02:57:28'),
(2549,2,'debit',NULL,5000.0000,NULL,'2025-02-14 14:03:00',1,54961,36576,NULL,NULL,NULL,'2025-02-14 07:03:43','2025-02-14 07:03:43'),
(2550,2,'debit',NULL,340000.0000,NULL,'2025-02-14 14:07:00',1,55091,36577,NULL,NULL,NULL,'2025-02-14 07:07:08','2025-02-14 07:07:08'),
(2551,2,'debit',NULL,17722000.0000,NULL,'2025-02-14 14:14:00',1,55215,36580,NULL,NULL,NULL,'2025-02-14 07:14:28','2025-02-14 07:14:28'),
(2552,2,'debit',NULL,930000.0000,NULL,'2025-02-14 14:17:00',1,55449,36581,NULL,NULL,NULL,'2025-02-14 07:17:12','2025-02-14 07:17:12'),
(2553,2,'debit',NULL,415100.0000,NULL,'2025-02-14 14:18:00',1,55301,36582,NULL,NULL,NULL,'2025-02-14 07:18:32','2025-02-14 07:18:32'),
(2554,2,'debit',NULL,12000.0000,NULL,'2025-02-14 14:19:00',1,55522,36583,NULL,NULL,NULL,'2025-02-14 07:19:05','2025-02-14 07:19:05'),
(2555,2,'debit',NULL,7313200.0000,NULL,'2025-02-14 14:55:00',1,55010,36584,NULL,NULL,'2025-02-17 14:36:41','2025-02-14 07:55:20','2025-02-17 14:36:41'),
(2556,2,'debit',NULL,3836400.0000,NULL,'2025-02-14 14:58:00',1,55391,36585,NULL,NULL,NULL,'2025-02-14 07:59:00','2025-02-14 07:59:00'),
(2557,2,'credit',NULL,200000.0000,NULL,'2025-02-14 20:26:59',5,55545,36606,NULL,NULL,NULL,'2025-02-14 13:26:59','2025-02-15 13:40:18'),
(2558,2,'credit',NULL,56900.0000,NULL,'2025-02-14 21:21:23',6,55605,36616,NULL,NULL,NULL,'2025-02-14 14:21:23','2025-02-14 14:21:23'),
(2559,2,'credit',NULL,200000.0000,NULL,'2025-02-15 10:58:13',49,55552,36626,NULL,NULL,NULL,'2025-02-15 03:58:13','2025-02-15 06:59:40'),
(2560,2,'credit',NULL,790000.0000,NULL,'2025-02-15 10:58:48',49,55616,36627,NULL,NULL,NULL,'2025-02-15 03:58:48','2025-02-15 03:58:48'),
(2561,2,'credit',NULL,170000.0000,NULL,'2025-02-15 11:35:56',3,55623,36635,NULL,NULL,NULL,'2025-02-15 04:35:56','2025-02-15 04:35:56'),
(2562,2,'credit',NULL,170000.0000,NULL,'2025-02-15 11:36:03',3,55624,36636,NULL,NULL,NULL,'2025-02-15 04:36:03','2025-02-15 04:36:03'),
(2563,2,'credit',NULL,62500.0000,NULL,'2025-02-15 12:15:00',3,55627,36640,NULL,NULL,NULL,'2025-02-15 05:15:00','2025-02-15 05:15:00'),
(2564,2,'credit',NULL,200000.0000,NULL,'2025-02-15 12:17:50',3,55628,36641,NULL,NULL,NULL,'2025-02-15 05:17:50','2025-02-15 05:47:57'),
(2565,2,'credit',NULL,200000.0000,NULL,'2025-02-15 14:37:19',19,55466,36650,NULL,NULL,NULL,'2025-02-15 07:37:19','2025-03-13 14:31:26'),
(2566,2,'debit',NULL,612600.0000,NULL,'2025-02-15 16:55:00',1,55575,36664,NULL,NULL,NULL,'2025-02-15 09:55:42','2025-02-15 09:55:42'),
(2567,2,'credit',NULL,1285000.0000,NULL,'2025-02-15 17:25:42',93,55655,36666,NULL,NULL,NULL,'2025-02-15 10:25:42','2025-03-01 08:34:51'),
(2568,2,'credit',NULL,380000.0000,NULL,'2025-02-15 17:29:45',93,53559,36667,NULL,NULL,NULL,'2025-02-15 10:29:45','2025-02-15 10:29:45'),
(2569,2,'credit',NULL,565000.0000,NULL,'2025-02-15 18:33:03',13,55661,36673,NULL,NULL,NULL,'2025-02-15 11:33:03','2025-02-15 11:33:03'),
(2570,2,'credit',NULL,15000.0000,NULL,'2025-02-15 18:33:29',13,55447,36674,NULL,NULL,NULL,'2025-02-15 11:33:29','2025-02-15 11:33:29'),
(2571,2,'credit',NULL,200000.0000,NULL,'2025-02-15 20:44:17',13,55608,36683,NULL,NULL,NULL,'2025-02-15 13:44:17','2025-07-21 10:15:30'),
(2572,2,'credit',NULL,550000.0000,NULL,'2025-02-15 18:15:44',13,54576,36671,NULL,NULL,NULL,'2025-02-15 15:13:18','2025-02-15 15:13:18'),
(2573,2,'credit',NULL,250000.0000,NULL,'2025-02-15 18:15:52',13,55657,36672,NULL,NULL,NULL,'2025-02-15 15:13:38','2025-02-15 15:13:38'),
(2574,2,'credit',NULL,1200000.0000,NULL,'2025-02-17 11:39:09',93,55738,36743,NULL,NULL,NULL,'2025-02-17 04:39:09','2025-02-17 04:39:09'),
(2575,2,'credit',NULL,167000.0000,NULL,'2025-02-17 12:36:13',49,55741,36748,NULL,NULL,NULL,'2025-02-17 05:36:13','2025-02-17 05:36:13'),
(2576,2,'credit',NULL,2000000.0000,NULL,'2025-02-17 13:24:41',106,55718,36752,NULL,NULL,NULL,'2025-02-17 06:24:41','2025-02-17 10:17:31'),
(2577,2,'credit',NULL,1882000.0000,NULL,'2025-02-17 14:42:14',3,54425,36754,NULL,NULL,NULL,'2025-02-17 07:42:14','2025-02-28 08:28:01'),
(2578,2,'credit',NULL,1661000.0000,NULL,'2025-02-17 17:08:47',3,55718,36759,NULL,NULL,NULL,'2025-02-17 10:08:48','2025-02-17 10:17:31'),
(2579,2,'credit',NULL,100000.0000,NULL,'2025-02-17 17:17:40',106,55763,36760,NULL,NULL,NULL,'2025-02-17 10:17:40','2025-02-17 10:17:40'),
(2580,2,'credit',NULL,1504000.0000,NULL,'2025-02-17 19:46:12',3,55750,36776,NULL,NULL,NULL,'2025-02-17 12:46:12','2025-02-17 12:46:12'),
(2581,2,'credit',NULL,650000.0000,NULL,'2025-02-17 20:43:58',46,55784,36784,NULL,NULL,NULL,'2025-02-17 13:43:58','2025-02-17 13:43:58'),
(2582,2,'debit',NULL,1914000.0000,NULL,'2025-02-17 21:20:00',1,55079,36788,NULL,NULL,NULL,'2025-02-17 14:20:36','2025-02-17 14:20:36'),
(2583,2,'debit',NULL,4473200.0000,NULL,'2025-02-17 21:33:00',1,55694,36789,NULL,NULL,NULL,'2025-02-17 14:33:25','2025-02-17 14:33:25'),
(2584,2,'debit',NULL,7194700.0000,NULL,'2025-02-17 21:40:00',1,55010,36790,NULL,NULL,NULL,'2025-02-17 14:40:38','2025-02-17 14:40:38'),
(2585,2,'debit',NULL,522200.0000,NULL,'2025-02-17 21:54:00',1,55752,36792,NULL,NULL,NULL,'2025-02-17 14:54:39','2025-02-17 14:54:39'),
(2586,2,'debit',NULL,800000.0000,NULL,'2025-02-17 21:54:00',1,55768,36793,NULL,NULL,NULL,'2025-02-17 14:54:55','2025-02-17 14:54:55'),
(2587,2,'debit',NULL,1600000.0000,NULL,'2025-02-17 21:55:00',1,55630,36794,NULL,NULL,NULL,'2025-02-17 14:55:24','2025-02-17 14:55:24'),
(2588,2,'debit',NULL,234000.0000,NULL,'2025-02-17 21:56:00',1,55704,36795,NULL,NULL,NULL,'2025-02-17 14:56:26','2025-02-17 14:56:26'),
(2589,2,'credit',NULL,150000.0000,NULL,'2025-02-18 11:01:01',13,55802,36804,NULL,NULL,NULL,'2025-02-18 04:01:01','2025-02-18 04:01:01'),
(2590,2,'credit',NULL,43000000.0000,NULL,'2025-02-18 14:23:52',5,55809,36813,NULL,NULL,NULL,'2025-02-18 07:23:52','2025-02-18 07:23:52'),
(2591,2,'credit',NULL,202000.0000,NULL,'2025-02-18 16:01:43',106,55822,36815,NULL,NULL,NULL,'2025-02-18 09:01:43','2025-02-28 08:21:54'),
(2592,2,'credit',NULL,104000.0000,NULL,'2025-02-18 18:38:42',49,55837,36825,NULL,NULL,NULL,'2025-02-18 11:38:42','2025-02-18 11:38:42'),
(2593,2,'credit',NULL,30000.0000,NULL,'2025-02-18 21:36:22',46,55849,36839,NULL,NULL,NULL,'2025-02-18 14:36:22','2025-02-18 14:36:22'),
(2594,2,'credit',NULL,80000.0000,NULL,'2025-02-18 21:05:41',49,55846,36835,NULL,NULL,NULL,'2025-02-18 14:44:54','2025-02-28 08:43:18'),
(2595,2,'debit',NULL,96000.0000,NULL,'2025-02-19 02:50:00',1,55815,36842,NULL,NULL,NULL,'2025-02-18 19:50:11','2025-02-18 19:50:11'),
(2596,2,'credit',NULL,17200000.0000,NULL,'2025-02-20 12:26:07',5,55903,36888,NULL,NULL,NULL,'2025-02-20 05:26:07','2025-02-20 05:26:07'),
(2597,2,'credit',NULL,195000.0000,NULL,'2025-02-20 15:28:41',5,55943,36892,NULL,NULL,NULL,'2025-02-20 08:28:41','2025-02-20 08:28:41'),
(2598,2,'credit',NULL,178500.0000,NULL,'2025-02-20 16:09:38',13,55952,36898,NULL,NULL,NULL,'2025-02-20 09:09:38','2025-02-20 09:09:38'),
(2599,2,'credit',NULL,80000.0000,NULL,'2025-02-20 16:11:12',13,55878,36899,NULL,NULL,NULL,'2025-02-20 09:11:12','2025-02-20 09:11:12'),
(2600,2,'credit',NULL,17200000.0000,NULL,'2025-02-20 17:14:17',5,55931,36903,NULL,NULL,NULL,'2025-02-20 10:14:17','2025-02-20 10:14:17'),
(2601,2,'credit',NULL,100000.0000,NULL,'2025-02-20 17:41:04',49,55961,36904,NULL,NULL,NULL,'2025-02-20 10:41:04','2025-02-20 10:41:04'),
(2602,2,'credit',NULL,1748000.0000,NULL,'2025-02-20 17:41:55',49,55960,36905,NULL,NULL,NULL,'2025-02-20 10:41:55','2025-02-28 08:13:06'),
(2603,2,'credit',NULL,100000.0000,NULL,'2025-02-20 17:50:01',106,55543,36906,NULL,NULL,NULL,'2025-02-20 10:50:01','2025-02-20 10:50:01'),
(2604,2,'credit',NULL,195000.0000,NULL,'2025-02-20 17:50:25',106,55964,36907,NULL,NULL,NULL,'2025-02-20 10:50:25','2025-02-20 10:50:25'),
(2605,2,'credit',NULL,49000.0000,NULL,'2025-02-20 20:40:20',106,55896,36912,NULL,NULL,NULL,'2025-02-20 13:40:20','2025-02-28 03:38:09'),
(2606,2,'credit',NULL,355000.0000,NULL,'2025-02-20 20:42:04',106,55968,36913,NULL,NULL,NULL,'2025-02-20 13:42:04','2025-02-28 08:25:23'),
(2607,2,'credit',NULL,272000.0000,NULL,'2025-02-21 08:50:08',19,55976,36920,NULL,NULL,NULL,'2025-02-21 01:50:08','2025-02-21 01:50:08'),
(2608,2,'credit',NULL,5799000.0000,NULL,'2025-02-21 10:29:00',19,55986,36928,NULL,NULL,NULL,'2025-02-21 03:31:01','2025-02-21 03:31:01'),
(2609,2,'credit',NULL,25800000.0000,NULL,'2025-02-21 14:01:33',5,55935,36937,NULL,NULL,NULL,'2025-02-21 07:01:33','2025-02-21 07:01:33'),
(2610,2,'credit',NULL,2499000.0000,NULL,'2025-02-21 14:30:33',49,55999,36939,NULL,NULL,NULL,'2025-02-21 07:30:33','2025-02-21 08:52:59'),
(2611,2,'credit',NULL,510000.0000,NULL,'2025-02-21 14:46:42',13,56002,36943,NULL,NULL,NULL,'2025-02-21 08:18:16','2025-02-21 08:18:16'),
(2612,2,'credit',NULL,639000.0000,NULL,'2025-02-21 15:19:45',49,56006,36946,NULL,NULL,'2025-04-26 08:19:24','2025-02-21 08:19:45','2025-04-26 08:19:24'),
(2613,2,'credit',NULL,3270000.0000,NULL,'2025-02-21 15:37:55',5,55105,36948,NULL,NULL,NULL,'2025-02-21 08:37:55','2025-02-21 08:37:55'),
(2614,2,'credit',NULL,460000.0000,NULL,'2025-02-21 15:45:38',5,56011,36949,NULL,NULL,NULL,'2025-02-21 08:45:38','2025-02-21 08:45:38'),
(2615,2,'credit',NULL,1542000.0000,NULL,'2025-02-21 16:06:57',13,55824,36954,NULL,NULL,NULL,'2025-02-21 10:03:04','2025-02-21 10:03:04'),
(2616,2,'credit',NULL,4950000.0000,NULL,'2025-02-21 17:31:33',6,56024,36961,NULL,NULL,NULL,'2025-02-21 10:31:33','2025-02-21 10:31:33'),
(2617,2,'credit',NULL,582000.0000,NULL,'2025-02-21 20:12:03',6,56036,36970,NULL,NULL,NULL,'2025-02-21 13:12:03','2025-02-21 13:12:03'),
(2618,2,'credit',NULL,5000000.0000,NULL,'2025-02-22 14:52:16',19,56064,36983,NULL,NULL,NULL,'2025-02-22 07:52:16','2025-04-03 13:50:03'),
(2619,2,'credit',NULL,370000.0000,NULL,'2025-02-22 17:12:30',13,56010,36991,NULL,NULL,NULL,'2025-02-22 10:12:30','2025-02-22 10:12:30'),
(2620,2,'credit',NULL,575000.0000,NULL,'2025-02-22 17:13:00',13,56078,36992,NULL,NULL,NULL,'2025-02-22 10:20:47','2025-02-22 10:20:47'),
(2621,2,'credit',NULL,210000.0000,NULL,'2025-02-22 17:23:48',6,56079,36994,NULL,NULL,NULL,'2025-02-22 10:23:48','2025-02-22 10:23:48'),
(2622,2,'credit',NULL,200000.0000,NULL,'2025-02-22 21:22:51',6,55561,37003,NULL,NULL,NULL,'2025-02-22 14:22:51','2025-02-22 14:22:51'),
(2623,2,'credit',NULL,790000.0000,NULL,'2025-02-22 21:23:22',6,56091,37004,NULL,NULL,NULL,'2025-02-22 14:23:22','2025-02-22 14:23:22'),
(2624,2,'credit',NULL,995000.0000,NULL,'2025-02-23 16:00:43',106,56111,37021,NULL,NULL,NULL,'2025-02-23 09:00:43','2025-02-23 09:01:49'),
(2625,2,'credit',NULL,85000.0000,NULL,'2025-02-23 16:02:08',106,56112,37022,NULL,NULL,NULL,'2025-02-23 09:02:08','2025-02-23 09:02:08'),
(2626,2,'credit',NULL,150000.0000,NULL,'2025-02-23 19:02:54',106,56124,37032,NULL,NULL,NULL,'2025-02-23 12:02:54','2025-02-23 12:02:54'),
(2627,2,'credit',NULL,17000.0000,NULL,'2025-02-24 09:01:03',3,56135,37043,NULL,NULL,NULL,'2025-02-24 02:01:03','2025-02-24 02:01:03'),
(2628,2,'credit',NULL,1000000.0000,NULL,'2025-02-24 11:49:31',3,56146,37054,NULL,NULL,NULL,'2025-02-24 04:49:31','2025-02-24 04:49:31'),
(2629,2,'credit',NULL,220500.0000,NULL,'2025-02-24 12:43:49',6,56147,37055,NULL,NULL,NULL,'2025-02-24 05:43:49','2025-02-24 05:43:49'),
(2630,2,'credit',NULL,200000.0000,NULL,'2025-02-24 14:11:08',93,56110,37058,NULL,NULL,NULL,'2025-02-24 07:11:08','2025-03-01 05:17:42'),
(2631,2,'debit',NULL,4960000.0000,NULL,'2025-02-25 09:38:00',1,55853,37093,NULL,NULL,NULL,'2025-02-25 02:38:22','2025-02-25 02:38:22'),
(2632,2,'credit',NULL,45000.0000,NULL,'2025-02-25 11:06:54',6,56221,37097,NULL,NULL,NULL,'2025-02-25 04:06:54','2025-02-25 04:06:54'),
(2633,2,'credit',NULL,105000.0000,NULL,'2025-02-25 14:59:13',19,56255,37117,NULL,NULL,NULL,'2025-02-25 07:59:13','2025-02-25 07:59:13'),
(2634,2,'credit',NULL,200000.0000,NULL,'2025-02-25 15:50:10',106,56227,37121,NULL,NULL,NULL,'2025-02-25 08:50:10','2025-02-25 08:50:10'),
(2635,2,'credit',NULL,24500000.0000,NULL,'2025-02-25 17:03:57',3,56186,37128,NULL,NULL,NULL,'2025-02-25 10:03:57','2025-07-16 08:04:07'),
(2636,2,'credit',NULL,200000.0000,NULL,'2025-02-25 21:57:24',106,56291,37150,NULL,NULL,NULL,'2025-02-25 14:57:24','2025-02-25 14:57:24'),
(2637,2,'credit',NULL,325000.0000,NULL,'2025-02-26 09:41:09',6,56294,37152,NULL,NULL,NULL,'2025-02-26 02:41:09','2025-03-01 08:48:09'),
(2638,2,'credit',NULL,234000.0000,NULL,'2025-02-26 14:40:18',5,56321,37168,NULL,NULL,NULL,'2025-02-26 07:40:18','2025-02-26 07:40:18'),
(2639,2,'debit',NULL,2804000.0000,NULL,'2025-02-27 08:23:00',1,56153,37194,NULL,NULL,NULL,'2025-02-27 01:23:28','2025-02-27 01:23:28'),
(2640,2,'credit',NULL,200000.0000,NULL,'2025-02-27 10:22:49',2,56322,37275,NULL,NULL,NULL,'2025-02-27 03:22:49','2025-03-01 04:54:36'),
(2641,2,'credit',NULL,780000.0000,NULL,'2025-02-27 16:26:48',19,56392,37371,NULL,NULL,NULL,'2025-02-27 09:26:48','2025-02-27 09:26:48'),
(2642,2,'credit',NULL,250000.0000,NULL,'2025-02-27 16:28:29',19,56061,37372,NULL,NULL,NULL,'2025-02-27 09:28:29','2025-02-27 09:30:11'),
(2643,2,'credit',NULL,200000.0000,NULL,'2025-02-27 16:44:58',3,56356,37374,NULL,NULL,NULL,'2025-02-27 09:44:58','2025-03-09 05:40:01'),
(2644,2,'credit',NULL,720000.0000,NULL,'2025-02-28 14:22:48',93,56432,37415,NULL,NULL,NULL,'2025-02-28 07:22:48','2025-02-28 07:29:37'),
(2645,2,'credit',NULL,220000.0000,NULL,'2025-02-28 14:24:37',93,55930,37416,NULL,NULL,NULL,'2025-02-28 07:24:37','2025-02-28 07:24:37'),
(2646,2,'credit',NULL,160000.0000,NULL,'2025-02-28 14:29:15',93,56433,37417,NULL,NULL,NULL,'2025-02-28 07:29:15','2025-02-28 07:29:15'),
(2647,2,'credit',NULL,250000.0000,NULL,'2025-02-28 15:13:13',3,56437,37420,NULL,NULL,NULL,'2025-02-28 08:13:13','2025-02-28 08:13:13'),
(2648,2,'credit',NULL,250000.0000,NULL,'2025-02-28 15:13:17',3,56438,37421,NULL,NULL,NULL,'2025-02-28 08:13:17','2025-02-28 08:13:17'),
(2649,2,'credit',NULL,40000.0000,NULL,'2025-02-28 15:21:58',3,56439,37423,NULL,NULL,NULL,'2025-02-28 08:21:58','2025-02-28 08:21:58'),
(2650,2,'credit',NULL,40000.0000,NULL,'2025-02-28 15:22:05',3,56440,37424,NULL,NULL,NULL,'2025-02-28 08:22:05','2025-02-28 08:22:05'),
(2651,2,'credit',NULL,80000.0000,NULL,'2025-02-28 15:25:28',3,56441,37426,NULL,NULL,NULL,'2025-02-28 08:25:28','2025-02-28 08:25:28'),
(2652,2,'credit',NULL,80000.0000,NULL,'2025-02-28 15:25:34',3,56442,37427,NULL,NULL,NULL,'2025-02-28 08:25:34','2025-02-28 08:25:34'),
(2653,2,'credit',NULL,525000.0000,NULL,'2025-02-28 15:28:07',3,56443,37429,NULL,NULL,NULL,'2025-02-28 08:28:07','2025-02-28 08:28:07'),
(2654,2,'credit',NULL,525000.0000,NULL,'2025-02-28 15:28:14',3,56444,37430,NULL,NULL,NULL,'2025-02-28 08:28:14','2025-02-28 08:28:14'),
(2655,2,'credit',NULL,40000.0000,NULL,'2025-02-28 15:43:25',3,56453,37443,NULL,NULL,NULL,'2025-02-28 08:43:25','2025-02-28 08:43:25'),
(2656,2,'credit',NULL,240000.0000,NULL,'2025-02-28 16:02:56',93,56454,37444,NULL,NULL,NULL,'2025-02-28 09:02:56','2025-02-28 09:02:56'),
(2657,2,'credit',NULL,629000.0000,NULL,'2025-03-01 11:06:31',3,56455,37471,NULL,NULL,NULL,'2025-03-01 04:06:31','2025-04-03 13:27:14'),
(2658,2,'credit',NULL,155000.0000,NULL,'2025-03-01 13:29:54',19,56531,37483,NULL,NULL,NULL,'2025-03-01 06:29:54','2025-03-01 06:29:54'),
(2659,2,'credit',NULL,155000.0000,NULL,'2025-03-01 13:30:51',19,56532,37484,NULL,NULL,NULL,'2025-03-01 06:30:51','2025-03-01 06:30:51'),
(2660,2,'credit',NULL,80000.0000,NULL,'2025-03-01 14:10:13',19,56542,37496,NULL,NULL,NULL,'2025-03-01 07:10:13','2025-03-01 07:10:13'),
(2661,2,'credit',NULL,80000.0000,NULL,'2025-03-01 14:10:52',19,56543,37497,NULL,NULL,NULL,'2025-03-01 07:10:52','2025-03-01 07:10:52'),
(2662,2,'credit',NULL,155000.0000,NULL,'2025-03-01 16:57:20',2,56562,37513,NULL,NULL,'2025-03-01 10:02:41','2025-03-01 09:57:20','2025-03-01 10:02:41'),
(2663,2,'credit',NULL,155000.0000,NULL,'2025-03-01 17:03:12',2,56565,37516,NULL,NULL,NULL,'2025-03-01 10:03:12','2025-03-01 10:03:12'),
(2664,2,'credit',NULL,67000.0000,NULL,'2025-03-01 17:14:00',19,56567,37518,NULL,NULL,NULL,'2025-03-01 10:14:43','2025-03-05 04:13:09'),
(2665,2,'credit',NULL,60000.0000,NULL,'2025-03-01 21:10:20',19,56129,37531,NULL,NULL,NULL,'2025-03-01 14:10:20','2025-03-01 14:11:16'),
(2666,2,'credit',NULL,1295000.0000,NULL,'2025-03-01 21:12:11',19,56578,37532,NULL,NULL,NULL,'2025-03-01 14:12:11','2025-03-05 04:11:56'),
(2667,2,'credit',NULL,5000000.0000,NULL,'2025-03-01 21:42:43',5,56580,37534,NULL,NULL,NULL,'2025-03-01 14:42:43','2025-03-06 05:04:19'),
(2668,2,'credit',NULL,565000.0000,NULL,'2025-03-02 09:28:07',49,56573,37544,NULL,NULL,NULL,'2025-03-02 02:28:07','2025-03-02 02:28:07'),
(2669,2,'credit',NULL,250000.0000,NULL,'2025-03-02 16:51:15',13,56589,37552,NULL,NULL,NULL,'2025-03-02 09:51:15','2025-03-02 09:51:15'),
(2670,2,'credit',NULL,147000.0000,NULL,'2025-03-03 09:06:38',19,56611,37573,NULL,NULL,NULL,'2025-03-03 02:06:38','2025-03-05 04:11:20'),
(2671,2,'credit',NULL,184000.0000,NULL,'2025-03-03 10:16:23',5,56191,37575,NULL,NULL,NULL,'2025-03-03 03:16:23','2025-04-03 13:39:43'),
(2672,2,'credit',NULL,580000.0000,NULL,'2025-03-03 11:25:05',19,56622,37577,NULL,NULL,NULL,'2025-03-03 04:25:05','2025-03-05 04:10:58'),
(2673,2,'credit',NULL,379000.0000,NULL,'2025-03-03 12:30:59',19,56632,37580,NULL,NULL,NULL,'2025-03-03 05:30:59','2025-03-05 04:10:35'),
(2674,2,'credit',NULL,372000.0000,NULL,'2025-03-03 13:21:54',106,56637,37583,NULL,NULL,NULL,'2025-03-03 06:21:54','2025-03-03 06:21:54'),
(2675,2,'credit',NULL,186000.0000,NULL,'2025-03-03 15:02:40',3,56645,37595,NULL,NULL,NULL,'2025-03-03 08:02:40','2025-03-03 08:02:40'),
(2676,2,'credit',NULL,49000.0000,NULL,'2025-03-03 15:21:00',19,56629,37600,NULL,NULL,NULL,'2025-03-03 08:21:06','2025-04-03 14:13:56'),
(2677,2,'credit',NULL,581500.0000,NULL,'2025-03-03 15:56:01',106,56652,37603,NULL,NULL,NULL,'2025-03-03 08:56:01','2025-03-03 08:56:01'),
(2678,2,'debit',NULL,1800280.0000,NULL,'2025-03-04 14:13:00',1,56177,37639,NULL,NULL,NULL,'2025-03-04 07:13:11','2025-03-04 07:13:11'),
(2679,2,'debit',NULL,11463900.0000,NULL,'2025-03-04 14:21:00',1,56572,37640,NULL,NULL,NULL,'2025-03-04 07:21:15','2025-03-04 07:21:15'),
(2680,2,'credit',NULL,159000.0000,NULL,'2025-03-04 14:56:30',6,56755,37643,NULL,NULL,NULL,'2025-03-04 07:56:30','2025-03-05 04:07:45'),
(2681,2,'credit',NULL,3462000.0000,NULL,'2025-03-04 15:27:08',5,55806,37644,NULL,NULL,NULL,'2025-03-04 08:27:08','2025-04-23 03:42:29'),
(2682,2,'credit',NULL,4696080.0000,NULL,'2025-03-04 15:30:03',5,51702,37645,NULL,NULL,NULL,'2025-03-04 08:30:03','2025-04-23 03:58:32'),
(2683,2,'credit',NULL,2595000.0000,NULL,'2025-03-04 17:15:45',46,56765,37662,NULL,NULL,NULL,'2025-03-04 10:15:45','2025-03-05 04:07:08'),
(2684,2,'credit',NULL,350000.0000,NULL,'2025-03-04 17:18:30',46,55115,37663,NULL,NULL,NULL,'2025-03-04 10:18:30','2025-03-04 10:41:50'),
(2685,2,'credit',NULL,169000.0000,NULL,'2025-03-04 17:20:28',46,56766,37664,NULL,NULL,NULL,'2025-03-04 10:20:28','2025-03-04 10:20:28'),
(2686,2,'credit',NULL,2500000.0000,NULL,'2025-03-05 09:05:21',5,56753,37678,NULL,NULL,NULL,'2025-03-05 02:05:21','2025-03-05 02:05:21'),
(2687,2,'credit',NULL,450000.0000,NULL,'2025-03-06 08:45:27',5,55898,37698,NULL,NULL,NULL,'2025-03-06 01:45:27','2025-03-06 01:45:27'),
(2688,2,'credit',NULL,6048000.0000,NULL,'2025-03-06 12:04:00',19,56580,37705,NULL,NULL,NULL,'2025-03-06 05:09:11','2025-03-06 05:09:11'),
(2689,2,'credit',NULL,44000.0000,NULL,'2025-03-06 20:20:03',3,56849,37724,NULL,NULL,NULL,'2025-03-06 13:20:03','2025-03-06 13:20:03'),
(2690,2,'credit',NULL,220000.0000,NULL,'2025-03-07 10:27:54',19,56643,37739,NULL,NULL,NULL,'2025-03-07 03:27:54','2025-03-07 03:27:54'),
(2691,2,'credit',NULL,15000.0000,NULL,'2025-03-07 13:46:41',3,56038,37747,NULL,NULL,NULL,'2025-03-07 06:46:41','2025-03-07 06:46:41'),
(2692,2,'credit',NULL,234000.0000,NULL,'2025-03-07 13:47:33',3,56869,37748,NULL,NULL,'2025-03-07 06:55:23','2025-03-07 06:47:33','2025-03-07 06:55:23'),
(2693,2,'credit',NULL,250000.0000,NULL,'2025-03-07 13:48:18',3,56037,37749,NULL,NULL,NULL,'2025-03-07 06:48:18','2025-03-07 06:48:18'),
(2694,2,'credit',NULL,165000.0000,NULL,'2025-03-08 10:43:27',106,56909,37777,NULL,NULL,NULL,'2025-03-08 03:43:27','2025-03-08 03:43:27'),
(2695,2,'credit',NULL,169000.0000,NULL,'2025-03-08 19:39:05',49,56811,37800,NULL,NULL,NULL,'2025-03-08 12:39:05','2025-03-10 05:44:46'),
(2696,2,'debit',NULL,3364000.0000,NULL,'2025-03-09 10:18:00',1,56881,37812,NULL,NULL,NULL,'2025-03-09 03:18:45','2025-03-09 03:18:45'),
(2697,2,'credit',NULL,725000.0000,NULL,'2025-03-09 12:07:00',13,56957,37813,NULL,NULL,NULL,'2025-03-09 05:07:00','2025-03-12 07:26:54'),
(2698,2,'credit',NULL,165000.0000,NULL,'2025-03-09 18:00:00',106,56972,37825,NULL,NULL,NULL,'2025-03-09 11:00:01','2025-03-09 11:00:01'),
(2699,2,'credit',NULL,49000.0000,NULL,'2025-03-10 12:45:02',3,57003,37856,NULL,NULL,NULL,'2025-03-10 05:45:02','2025-03-10 05:45:02'),
(2700,2,'credit',NULL,100000.0000,NULL,'2025-03-10 12:46:24',3,56910,37857,NULL,NULL,NULL,'2025-03-10 05:46:25','2025-03-10 10:46:54'),
(2701,2,'credit',NULL,200000.0000,NULL,'2025-03-10 15:03:40',106,56326,37861,NULL,NULL,NULL,'2025-03-10 08:03:40','2025-05-07 01:52:35'),
(2702,2,'credit',NULL,633000.0000,NULL,'2025-03-10 16:02:28',3,57016,37865,NULL,NULL,NULL,'2025-03-10 09:02:28','2025-04-03 13:00:52'),
(2703,2,'credit',NULL,1934000.0000,NULL,'2025-03-10 21:07:22',106,56836,37877,NULL,NULL,NULL,'2025-03-10 14:07:22','2025-03-10 14:12:50'),
(2704,2,'credit',NULL,343000.0000,NULL,'2025-03-10 21:09:12',106,57031,37878,NULL,NULL,NULL,'2025-03-10 14:09:12','2025-03-10 14:13:02'),
(2705,2,'credit',NULL,120000.0000,NULL,'2025-03-11 16:25:31',2,57041,37906,NULL,NULL,NULL,'2025-03-11 09:25:31','2025-03-11 10:04:08'),
(2706,2,'credit',NULL,120000.0000,NULL,'2025-03-11 17:24:25',106,56886,37910,NULL,NULL,NULL,'2025-03-11 10:24:25','2025-03-11 10:24:25'),
(2707,2,'credit',NULL,389000.0000,NULL,'2025-03-11 17:25:04',106,57082,37911,NULL,NULL,NULL,'2025-03-11 10:25:04','2025-03-11 10:25:04'),
(2708,2,'credit',NULL,1200000.0000,NULL,'2025-03-12 14:26:54',3,56957,37941,NULL,NULL,NULL,'2025-03-12 07:26:54','2025-03-12 07:26:54'),
(2709,2,'credit',NULL,120000.0000,NULL,'2025-03-12 15:03:33',13,57017,37943,NULL,NULL,NULL,'2025-03-12 08:03:33','2025-03-12 08:03:33'),
(2710,2,'debit',NULL,320000.0000,NULL,'2025-03-12 15:27:00',3,57134,37944,NULL,NULL,NULL,'2025-03-12 08:29:47','2025-03-12 08:29:47'),
(2711,2,'credit',NULL,69000.0000,NULL,'2025-03-12 17:25:31',6,57162,37965,NULL,NULL,NULL,'2025-03-12 10:25:59','2025-03-12 10:25:59'),
(2712,2,'credit',NULL,645000.0000,NULL,'2025-03-13 09:28:14',19,57178,37976,NULL,NULL,'2025-03-13 02:29:45','2025-03-13 02:28:14','2025-03-13 02:29:45'),
(2713,2,'credit',NULL,525000.0000,NULL,'2025-03-13 09:58:00',19,55094,37977,NULL,NULL,NULL,'2025-03-13 02:58:32','2025-03-13 02:58:32'),
(2714,2,'credit',NULL,120000.0000,NULL,'2025-03-13 09:58:00',19,54892,37978,NULL,NULL,NULL,'2025-03-13 02:58:50','2025-03-13 02:58:50'),
(2715,2,'credit',NULL,286000.0000,NULL,'2025-03-13 10:27:31',13,57185,37979,NULL,NULL,NULL,'2025-03-13 03:27:31','2025-03-13 03:27:31'),
(2716,2,'credit',NULL,6871000.0000,NULL,'2025-03-13 13:30:18',106,57206,37991,NULL,NULL,NULL,'2025-03-13 06:34:43','2025-03-13 09:54:06'),
(2717,2,'credit',NULL,5683000.0000,NULL,'2025-03-13 13:37:19',106,57207,37992,NULL,NULL,NULL,'2025-03-13 06:37:19','2025-04-15 06:51:56'),
(2718,2,'credit',NULL,30500000.0000,NULL,'2025-03-13 15:29:42',3,57226,38002,NULL,NULL,NULL,'2025-03-13 08:29:42','2025-03-13 08:29:42'),
(2719,2,'credit',NULL,850000.0000,NULL,'2025-03-13 21:31:26',6,55466,38011,NULL,NULL,NULL,'2025-03-13 14:31:26','2025-03-13 14:31:26'),
(2720,2,'credit',NULL,160000.0000,NULL,'2025-03-13 21:31:36',6,57252,38012,NULL,NULL,NULL,'2025-03-13 14:31:36','2025-03-13 14:31:36'),
(2721,2,'credit',NULL,8723000.0000,NULL,'2025-03-13 21:33:18',6,56064,38013,NULL,NULL,NULL,'2025-03-13 14:33:18','2025-04-03 13:50:03'),
(2722,2,'debit',NULL,26393000.0000,NULL,'2025-03-14 12:43:00',1,57268,38024,NULL,NULL,NULL,'2025-03-14 05:43:52','2025-03-14 05:43:52'),
(2723,2,'debit',NULL,45200000.0000,NULL,'2025-03-14 12:49:00',1,57188,38025,NULL,NULL,NULL,'2025-03-14 05:49:23','2025-03-14 05:49:23'),
(2724,2,'debit',NULL,2400000.0000,NULL,'2025-03-14 12:50:00',1,57120,38026,NULL,NULL,NULL,'2025-03-14 05:50:38','2025-03-14 05:50:38'),
(2725,2,'debit',NULL,1731000.0000,NULL,'2025-03-14 12:51:00',1,56929,38027,NULL,NULL,NULL,'2025-03-14 05:51:13','2025-03-14 05:51:13'),
(2726,2,'debit',NULL,11200000.0000,NULL,'2025-03-14 12:51:00',1,57182,38028,NULL,NULL,NULL,'2025-03-14 05:51:56','2025-03-14 05:51:56'),
(2727,2,'debit',NULL,32112100.0000,NULL,'2025-03-14 13:35:00',1,57058,38032,NULL,NULL,NULL,'2025-03-14 06:35:58','2025-03-14 06:35:58'),
(2728,2,'debit',NULL,1394600.0000,NULL,'2025-03-14 13:37:00',1,56835,38033,NULL,NULL,NULL,'2025-03-14 06:37:20','2025-03-14 06:37:20'),
(2729,2,'debit',NULL,13620400.0000,NULL,'2025-03-14 13:46:00',1,55011,38037,NULL,NULL,NULL,'2025-03-14 06:48:11','2025-03-14 06:48:11'),
(2730,2,'credit',NULL,380000.0000,NULL,'2025-03-15 10:46:05',3,57309,38052,NULL,NULL,NULL,'2025-03-15 03:46:05','2025-03-15 03:46:05'),
(2731,2,'credit',NULL,250000.0000,NULL,'2025-03-15 11:09:09',3,57313,38056,NULL,NULL,NULL,'2025-03-15 04:09:09','2025-03-15 04:09:09'),
(2732,2,'credit',NULL,465000.0000,NULL,'2025-03-15 14:00:31',6,57330,38065,NULL,NULL,NULL,'2025-03-15 07:00:31','2025-03-15 07:00:31'),
(2733,2,'credit',NULL,75000.0000,NULL,'2025-03-16 10:25:20',19,57370,38088,NULL,NULL,NULL,'2025-03-16 03:25:20','2025-03-16 03:25:20'),
(2734,2,'credit',NULL,650000.0000,NULL,'2025-03-16 15:02:30',106,57354,38107,NULL,NULL,NULL,'2025-03-16 08:02:30','2025-05-07 01:56:46'),
(2735,2,'credit',NULL,845000.0000,NULL,'2025-03-16 20:14:41',2,57392,38111,NULL,NULL,NULL,'2025-03-16 13:14:41','2025-03-16 13:14:41'),
(2736,2,'credit',NULL,150000.0000,NULL,'2025-03-16 20:26:20',2,57384,38114,NULL,NULL,NULL,'2025-03-16 13:26:20','2025-03-16 13:26:20'),
(2737,2,'credit',NULL,145000.0000,NULL,'2025-03-16 20:28:10',2,57394,38115,NULL,NULL,NULL,'2025-03-16 13:28:10','2025-03-16 13:28:10'),
(2738,2,'credit',NULL,314000.0000,NULL,'2025-03-17 10:49:24',106,57318,38125,NULL,NULL,NULL,'2025-03-17 03:49:24','2025-03-17 03:49:24'),
(2739,2,'credit',NULL,290000.0000,NULL,'2025-03-17 10:59:20',106,57139,38126,NULL,NULL,'2025-03-17 03:59:21','2025-03-17 03:59:20','2025-03-17 03:59:21'),
(2740,2,'credit',NULL,290000.0000,NULL,'2025-03-17 10:59:21',106,57139,38127,NULL,NULL,NULL,'2025-03-17 03:59:21','2025-03-17 03:59:21'),
(2741,2,'credit',NULL,420000.0000,NULL,'2025-03-17 11:39:29',6,57408,38131,NULL,NULL,NULL,'2025-03-17 04:39:29','2025-03-17 04:39:29'),
(2742,2,'credit',NULL,821500.0000,NULL,'2025-03-17 17:28:55',13,57420,38160,NULL,NULL,NULL,'2025-03-17 10:28:55','2025-03-17 10:28:55'),
(2743,2,'credit',NULL,200000.0000,NULL,'2025-03-18 11:28:43',19,56888,38177,NULL,NULL,NULL,'2025-03-18 04:28:43','2025-04-03 12:05:55'),
(2744,2,'credit',NULL,450000.0000,NULL,'2025-03-18 12:32:22',106,57468,38180,NULL,NULL,NULL,'2025-03-18 05:32:22','2025-03-18 05:32:22'),
(2745,2,'credit',NULL,645000.0000,NULL,'2025-03-18 15:00:23',49,57481,38189,NULL,NULL,NULL,'2025-03-18 08:00:23','2025-03-18 08:00:23'),
(2746,2,'credit',NULL,960000.0000,NULL,'2025-03-18 15:38:36',19,57479,38191,NULL,NULL,NULL,'2025-03-18 08:38:36','2025-03-18 08:38:36'),
(2747,2,'credit',NULL,645000.0000,NULL,'2025-03-19 12:48:25',6,57530,38228,NULL,NULL,'2025-03-19 06:03:39','2025-03-19 05:48:25','2025-03-19 06:03:39'),
(2748,2,'credit',NULL,1500000.0000,NULL,'2025-03-19 16:40:50',49,57497,38242,NULL,NULL,NULL,'2025-03-19 09:40:50','2025-04-03 12:31:34'),
(2749,2,'credit',NULL,185000.0000,NULL,'2025-03-19 18:02:59',3,57464,38244,NULL,NULL,NULL,'2025-03-19 11:02:59','2025-03-20 03:29:58'),
(2750,2,'credit',NULL,2037000.0000,NULL,'2025-03-20 11:11:51',6,57563,38262,NULL,NULL,NULL,'2025-03-20 04:11:51','2025-03-20 04:11:51'),
(2751,2,'credit',NULL,1252000.0000,NULL,'2025-03-20 21:46:19',49,57497,38289,NULL,NULL,NULL,'2025-03-20 14:46:19','2025-04-03 12:31:34'),
(2752,2,'credit',NULL,270000.0000,NULL,'2025-03-22 10:00:10',13,57626,38314,NULL,NULL,NULL,'2025-03-22 03:00:10','2025-03-22 03:00:10'),
(2753,2,'credit',NULL,140000.0000,NULL,'2025-03-22 10:40:24',6,57628,38315,NULL,NULL,NULL,'2025-03-22 03:40:24','2025-03-22 03:40:24'),
(2754,2,'credit',NULL,465000.0000,NULL,'2025-03-22 16:05:16',13,57470,38324,NULL,NULL,NULL,'2025-03-22 09:05:16','2025-03-22 09:05:16'),
(2755,2,'credit',NULL,895000.0000,NULL,'2025-03-23 12:47:41',6,57675,38351,NULL,NULL,NULL,'2025-03-23 05:47:41','2025-03-23 05:47:41'),
(2756,2,'credit',NULL,5000000.0000,NULL,'2025-03-25 09:59:56',3,57754,38402,NULL,NULL,NULL,'2025-03-25 02:59:56','2025-03-28 07:23:04'),
(2757,2,'credit',NULL,190000.0000,NULL,'2025-03-25 10:22:12',3,57756,38403,NULL,NULL,NULL,'2025-03-25 03:22:12','2025-03-25 03:22:12'),
(2758,2,'debit',NULL,2700000.0000,NULL,'2025-03-25 10:56:00',3,57757,38404,NULL,NULL,NULL,'2025-03-25 03:57:21','2025-03-25 03:57:21'),
(2759,2,'credit',NULL,280000.0000,NULL,'2025-03-25 13:53:58',19,57781,38411,NULL,NULL,NULL,'2025-03-25 06:53:58','2025-03-25 06:53:58'),
(2760,2,'credit',NULL,500000.0000,NULL,'2025-03-25 17:03:30',6,57797,38418,NULL,NULL,NULL,'2025-03-25 10:03:30','2025-03-27 09:36:18'),
(2761,2,'credit',NULL,200000.0000,NULL,'2025-03-25 18:10:14',19,57596,38422,NULL,NULL,NULL,'2025-03-25 11:10:14','2025-08-14 09:42:30'),
(2762,2,'credit',NULL,2500000.0000,NULL,'2025-03-26 12:32:39',1,57826,38438,NULL,NULL,NULL,'2025-03-26 05:32:39','2025-09-28 06:32:30'),
(2763,2,'credit',NULL,1904000.0000,NULL,'2025-03-26 13:21:21',106,57795,38446,NULL,NULL,NULL,'2025-03-26 06:21:21','2025-04-03 12:14:06'),
(2764,2,'credit',NULL,275000.0000,NULL,'2025-03-27 15:20:47',49,57717,38478,NULL,NULL,NULL,'2025-03-27 08:20:47','2025-03-27 08:20:47'),
(2765,2,'credit',NULL,280000.0000,NULL,'2025-03-28 09:49:17',3,57096,38496,NULL,NULL,'2025-03-29 11:21:24','2025-03-28 02:49:17','2025-03-29 11:21:24'),
(2766,2,'credit',NULL,202000.0000,NULL,'2025-03-28 14:21:06',6,57898,38504,NULL,NULL,NULL,'2025-03-28 07:21:06','2025-03-28 07:21:06'),
(2767,2,'credit',NULL,6750000.0000,NULL,'2025-03-28 14:23:04',3,57754,38505,NULL,NULL,NULL,'2025-03-28 07:23:04','2025-03-28 07:23:04'),
(2768,2,'credit',NULL,207000.0000,NULL,'2025-03-29 10:19:02',49,57924,38529,NULL,NULL,NULL,'2025-03-29 04:35:43','2025-03-29 04:35:43'),
(2769,2,'credit',NULL,366000.0000,NULL,'2025-03-29 11:56:27',46,57929,38533,NULL,NULL,NULL,'2025-03-29 04:56:27','2025-03-29 04:56:27'),
(2770,2,'credit',NULL,80000.0000,NULL,'2025-03-29 18:20:43',106,57944,38552,NULL,NULL,NULL,'2025-03-29 11:20:43','2025-04-03 14:35:47'),
(2771,2,'credit',NULL,200000.0000,NULL,'2025-03-12 08:59:07',13,57096,37923,NULL,NULL,NULL,'2025-03-29 11:21:24','2025-03-29 11:21:24'),
(2772,2,'debit',NULL,30153600.0000,NULL,'2025-03-30 13:32:00',1,57867,38557,NULL,NULL,NULL,'2025-03-30 06:32:12','2025-03-30 06:32:12'),
(2773,2,'debit',NULL,1100200.0000,NULL,'2025-04-03 09:50:00',1,57265,38576,NULL,NULL,NULL,'2025-04-03 02:50:35','2025-04-03 02:50:35'),
(2774,2,'debit',NULL,690000.0000,NULL,'2025-04-03 09:52:00',1,57487,38577,NULL,NULL,NULL,'2025-04-03 02:52:06','2025-04-03 02:52:06'),
(2775,2,'debit',NULL,130000.0000,NULL,'2025-04-03 09:52:00',1,57244,38579,NULL,NULL,NULL,'2025-04-03 02:52:31','2025-04-03 02:52:31'),
(2776,2,'debit',NULL,1251600.0000,NULL,'2025-04-03 10:05:00',1,57308,38582,NULL,NULL,NULL,'2025-04-03 03:05:59','2025-04-03 03:05:59'),
(2777,2,'debit',NULL,217000.0000,NULL,'2025-04-03 10:06:00',1,57225,38583,NULL,NULL,NULL,'2025-04-03 03:06:21','2025-04-03 03:06:21'),
(2778,2,'debit',NULL,66000.0000,NULL,'2025-04-03 10:06:00',1,57220,38584,NULL,NULL,NULL,'2025-04-03 03:06:49','2025-04-03 03:06:49'),
(2779,2,'debit',NULL,890000.0000,NULL,'2025-04-03 10:07:00',1,57213,38585,NULL,NULL,NULL,'2025-04-03 03:07:13','2025-04-03 03:07:13'),
(2780,2,'debit',NULL,340000.0000,NULL,'2025-04-03 10:08:00',1,57342,38586,NULL,NULL,NULL,'2025-04-03 03:08:08','2025-04-03 03:08:08'),
(2781,2,'credit',NULL,1045000.0000,NULL,'2025-04-03 11:45:20',6,57966,38588,NULL,NULL,NULL,'2025-04-03 04:45:20','2025-04-03 04:45:20'),
(2782,2,'credit',NULL,90000.0000,NULL,'2025-04-03 17:31:01',13,58014,38643,NULL,NULL,NULL,'2025-04-03 10:31:01','2025-04-03 10:31:01'),
(2783,2,'credit',NULL,342000.0000,NULL,'2025-04-03 18:26:59',19,58021,38648,NULL,NULL,NULL,'2025-04-03 11:26:59','2025-04-03 11:32:25'),
(2784,2,'credit',NULL,200000.0000,NULL,'2025-04-03 19:14:13',3,58027,38655,NULL,NULL,NULL,'2025-04-03 12:14:13','2025-04-03 12:14:13'),
(2785,2,'credit',NULL,200000.0000,NULL,'2025-04-03 19:14:19',3,58028,38656,NULL,NULL,NULL,'2025-04-03 12:14:19','2025-04-03 12:14:19'),
(2786,2,'credit',NULL,225000.0000,NULL,'2025-04-03 19:31:40',3,58038,38666,NULL,NULL,NULL,'2025-04-03 12:31:40','2025-04-03 12:31:40'),
(2787,2,'credit',NULL,225000.0000,NULL,'2025-04-03 19:31:46',3,58039,38667,NULL,NULL,NULL,'2025-04-03 12:31:46','2025-04-03 12:31:46'),
(2788,2,'credit',NULL,50000.0000,NULL,'2025-04-03 20:00:58',3,58050,38680,NULL,NULL,NULL,'2025-04-03 13:00:58','2025-04-03 13:00:58'),
(2789,2,'credit',NULL,50000.0000,NULL,'2025-04-03 20:01:03',3,58051,38681,NULL,NULL,NULL,'2025-04-03 13:01:03','2025-04-03 13:01:03'),
(2790,2,'credit',NULL,40000.0000,NULL,'2025-04-03 20:39:25',3,58068,38697,NULL,NULL,NULL,'2025-04-03 13:39:25','2025-04-03 13:39:25'),
(2791,2,'credit',NULL,40000.0000,NULL,'2025-04-03 20:39:37',3,58069,38698,NULL,NULL,NULL,'2025-04-03 13:39:37','2025-04-03 13:39:37'),
(2792,2,'credit',NULL,1060000.0000,NULL,'2025-04-03 20:51:27',19,58072,38704,NULL,NULL,NULL,'2025-04-03 13:51:27','2025-04-03 13:51:27'),
(2793,2,'credit',NULL,1060000.0000,NULL,'2025-04-03 20:52:28',19,58073,38705,NULL,NULL,NULL,'2025-04-03 13:52:28','2025-04-03 13:52:28'),
(2794,2,'credit',NULL,1060000.0000,NULL,'2025-04-03 20:53:02',19,58074,38706,NULL,NULL,NULL,'2025-04-03 13:53:02','2025-04-03 13:53:57'),
(2795,2,'debit',NULL,340000.0000,NULL,'2025-04-03 21:10:00',3,58081,38713,NULL,NULL,NULL,'2025-04-03 14:11:05','2025-04-03 14:11:05'),
(2796,2,'credit',NULL,20000.0000,NULL,'2025-04-03 21:14:34',19,58082,38715,NULL,NULL,NULL,'2025-04-03 14:14:34','2025-04-03 14:14:34'),
(2797,2,'credit',NULL,200000.0000,NULL,'2025-04-04 15:36:19',19,57930,38750,NULL,NULL,NULL,'2025-04-04 08:36:19','2025-05-07 02:06:45'),
(2798,2,'credit',NULL,440000.0000,NULL,'2025-04-04 17:03:55',2,58011,38753,NULL,NULL,NULL,'2025-04-04 10:03:55','2025-04-04 10:09:43'),
(2799,2,'credit',NULL,505000.0000,NULL,'2025-04-04 17:04:23',2,58126,38754,NULL,NULL,NULL,'2025-04-04 10:04:23','2025-04-29 12:39:09'),
(2800,2,'debit',NULL,838000.0000,NULL,'2025-04-05 09:08:00',1,57444,38773,NULL,NULL,NULL,'2025-04-05 02:08:22','2025-04-05 02:08:22'),
(2801,2,'debit',NULL,322800.0000,NULL,'2025-04-05 09:08:00',1,57396,38774,NULL,NULL,NULL,'2025-04-05 02:08:47','2025-04-05 02:08:47'),
(2802,2,'debit',NULL,2537000.0000,NULL,'2025-04-05 09:09:00',1,57489,38775,NULL,NULL,NULL,'2025-04-05 02:09:23','2025-04-05 02:09:23'),
(2803,2,'credit',NULL,200000.0000,NULL,'2025-04-05 10:33:42',6,58006,38778,NULL,NULL,NULL,'2025-04-05 03:33:42','2025-05-07 01:58:55'),
(2804,2,'credit',NULL,250000.0000,NULL,'2025-04-05 11:33:55',13,57807,38780,NULL,NULL,NULL,'2025-04-05 04:33:55','2025-04-19 05:17:10'),
(2805,2,'credit',NULL,2150000.0000,NULL,'2025-04-05 11:38:58',13,58148,38781,NULL,NULL,NULL,'2025-04-05 04:38:58','2025-04-05 04:38:58'),
(2806,2,'credit',NULL,595000.0000,NULL,'2025-04-05 16:30:11',13,58166,38790,NULL,NULL,NULL,'2025-04-05 09:30:11','2025-04-05 09:59:50'),
(2807,2,'credit',NULL,4860000.0000,NULL,'2025-04-05 20:25:33',49,58111,38804,NULL,NULL,NULL,'2025-04-05 13:25:33','2025-04-05 13:25:33'),
(2808,2,'credit',NULL,243000.0000,NULL,'2025-04-06 10:57:55',49,58197,38810,NULL,NULL,NULL,'2025-04-06 03:57:55','2025-04-06 03:57:55'),
(2809,2,'credit',NULL,200000.0000,NULL,'2025-04-06 19:00:33',19,58227,38830,NULL,NULL,NULL,'2025-04-06 12:00:33','2025-04-20 15:02:43'),
(2810,2,'credit',NULL,300000.0000,NULL,'2025-04-06 21:42:16',106,58141,38836,NULL,NULL,NULL,'2025-04-06 14:42:16','2025-04-06 14:42:16'),
(2811,2,'credit',NULL,400000.0000,NULL,'2025-04-06 21:43:04',106,58234,38837,NULL,NULL,NULL,'2025-04-06 14:43:04','2025-04-06 14:43:04'),
(2812,2,'credit',NULL,840000.0000,NULL,'2025-04-07 13:10:35',19,58252,38848,NULL,NULL,NULL,'2025-04-07 06:10:35','2025-04-07 06:10:35'),
(2813,2,'credit',NULL,120000.0000,NULL,'2025-04-07 13:56:58',19,57945,38849,NULL,NULL,NULL,'2025-04-07 06:56:58','2025-04-07 06:56:58'),
(2814,2,'credit',NULL,7000000.0000,NULL,'2025-04-07 14:50:42',19,58260,38853,NULL,NULL,NULL,'2025-04-07 07:50:42','2025-04-09 14:04:05'),
(2815,2,'credit',NULL,200000.0000,NULL,'2025-04-07 15:49:20',3,57852,38860,NULL,NULL,NULL,'2025-04-07 08:49:20','2025-05-22 08:42:13'),
(2816,2,'credit',NULL,89000.0000,NULL,'2025-04-07 17:01:08',49,58271,38871,NULL,NULL,NULL,'2025-04-07 10:01:08','2025-04-27 07:58:24'),
(2817,2,'credit',NULL,200000.0000,NULL,'2025-04-07 19:33:51',6,58242,38882,NULL,NULL,NULL,'2025-04-07 12:33:51','2025-07-21 10:40:13'),
(2818,2,'credit',NULL,200000.0000,NULL,'2025-04-07 20:42:27',6,58273,38884,NULL,NULL,NULL,'2025-04-07 13:42:27','2025-11-01 12:12:02'),
(2819,2,'credit',NULL,200000.0000,NULL,'2025-04-08 13:17:30',6,58210,38921,NULL,NULL,NULL,'2025-04-08 06:17:30','2025-04-08 12:26:02'),
(2820,2,'credit',NULL,200000.0000,NULL,'2025-04-08 15:20:35',6,58295,38925,NULL,NULL,NULL,'2025-04-08 08:20:35','2025-11-01 12:12:30'),
(2821,2,'credit',NULL,1207000.0000,NULL,'2025-04-08 15:54:45',13,58338,38929,NULL,NULL,NULL,'2025-04-08 08:54:45','2025-04-27 14:15:11'),
(2822,2,'credit',NULL,775000.0000,NULL,'2025-04-08 18:29:36',6,58210,38933,NULL,NULL,NULL,'2025-04-08 11:29:36','2025-04-08 12:26:02'),
(2823,2,'credit',NULL,200000.0000,NULL,'2025-04-09 08:58:47',3,57751,38952,NULL,NULL,NULL,'2025-04-09 01:58:47','2025-04-09 03:40:05'),
(2824,2,'credit',NULL,113000.0000,NULL,'2025-04-09 09:24:34',10,58369,38953,NULL,NULL,NULL,'2025-04-09 02:24:34','2025-04-09 02:24:34'),
(2825,2,'credit',NULL,120000.0000,NULL,'2025-04-09 10:48:42',19,58321,38958,NULL,NULL,NULL,'2025-04-09 03:48:42','2025-04-09 03:48:42'),
(2826,2,'credit',NULL,56000.0000,NULL,'2025-04-09 10:49:20',19,58376,38959,NULL,NULL,NULL,'2025-04-09 03:49:20','2025-04-09 03:49:20'),
(2827,2,'credit',NULL,570000.0000,NULL,'2025-04-09 14:24:24',6,58399,38971,NULL,NULL,NULL,'2025-04-09 07:24:24','2025-04-09 07:24:24'),
(2828,2,'credit',NULL,114000.0000,NULL,'2025-04-09 16:35:56',49,58413,38983,NULL,NULL,NULL,'2025-04-09 09:35:56','2025-04-09 09:53:45'),
(2829,2,'credit',NULL,4995000.0000,NULL,'2025-04-09 21:04:05',6,58260,39001,NULL,NULL,NULL,'2025-04-09 14:04:05','2025-04-09 14:04:05'),
(2830,2,'credit',NULL,605000.0000,NULL,'2025-04-10 11:39:27',13,58462,39020,NULL,NULL,NULL,'2025-04-10 04:39:27','2025-04-27 14:12:00'),
(2831,2,'credit',NULL,200000.0000,NULL,'2025-04-10 11:45:09',13,57594,39021,NULL,NULL,NULL,'2025-04-10 04:45:09','2025-05-07 01:57:05'),
(2832,2,'credit',NULL,6799000.0000,NULL,'2025-04-10 12:32:55',13,58468,39024,NULL,NULL,NULL,'2025-04-10 05:32:55','2025-04-10 08:34:09'),
(2833,2,'credit',NULL,1207000.0000,NULL,'2025-04-10 13:29:23',13,58472,39028,NULL,NULL,NULL,'2025-04-10 06:29:23','2025-04-29 10:40:42'),
(2834,2,'credit',NULL,240000.0000,NULL,'2025-04-10 13:32:03',6,58475,39029,NULL,NULL,NULL,'2025-04-10 06:32:03','2025-04-10 06:32:03'),
(2835,2,'credit',NULL,270000.0000,NULL,'2025-04-10 14:08:24',6,58477,39030,NULL,NULL,NULL,'2025-04-10 07:08:24','2025-04-14 03:54:25'),
(2836,2,'credit',NULL,863000.0000,NULL,'2025-04-10 17:01:44',10,58492,39037,NULL,NULL,NULL,'2025-04-10 10:01:44','2025-04-10 10:01:44'),
(2837,2,'credit',NULL,255500.0000,NULL,'2025-04-10 17:27:55',6,58493,39038,NULL,NULL,NULL,'2025-04-10 10:27:55','2025-04-10 10:28:44'),
(2838,2,'credit',NULL,5000000.0000,NULL,'2025-04-10 20:39:33',106,53703,39047,NULL,NULL,NULL,'2025-04-10 13:39:33','2025-04-17 01:25:30'),
(2839,2,'credit',NULL,105000.0000,NULL,'2025-04-11 09:18:23',6,58515,39058,NULL,NULL,NULL,'2025-04-11 02:18:23','2025-04-11 02:18:23'),
(2840,2,'credit',NULL,666000.0000,NULL,'2025-04-11 15:04:15',10,58544,39088,NULL,NULL,NULL,'2025-04-11 08:04:15','2025-04-11 08:04:15'),
(2841,2,'credit',NULL,340000.0000,NULL,'2025-04-11 15:10:48',10,58542,39089,NULL,NULL,NULL,'2025-04-11 08:10:48','2025-04-11 08:23:38'),
(2842,2,'credit',NULL,395000.0000,NULL,'2025-04-11 15:32:15',13,58548,39092,NULL,NULL,NULL,'2025-04-11 08:32:15','2025-04-11 08:32:15'),
(2843,2,'credit',NULL,454000.0000,NULL,'2025-04-11 15:42:25',13,58549,39093,NULL,NULL,NULL,'2025-04-11 08:42:25','2025-05-03 12:20:54'),
(2844,2,'credit',NULL,200000.0000,NULL,'2025-04-11 15:52:59',6,58527,39094,NULL,NULL,NULL,'2025-04-11 08:52:59','2025-05-07 01:58:29'),
(2845,2,'credit',NULL,91000.0000,NULL,'2025-04-12 16:50:58',3,58616,39135,NULL,NULL,NULL,'2025-04-12 09:50:58','2025-04-27 08:30:07'),
(2846,2,'credit',NULL,490000.0000,NULL,'2025-04-13 11:52:14',106,58606,39157,NULL,NULL,NULL,'2025-04-13 04:52:14','2025-04-13 04:52:14'),
(2847,2,'credit',NULL,895000.0000,NULL,'2025-04-13 11:52:24',106,58644,39158,NULL,NULL,NULL,'2025-04-13 04:52:24','2025-04-13 04:52:24'),
(2848,2,'debit',NULL,199000.0000,NULL,'2025-04-13 15:43:00',3,58655,39169,NULL,NULL,NULL,'2025-04-13 08:48:59','2025-04-13 08:48:59'),
(2849,2,'credit',NULL,182000.0000,NULL,'2025-04-13 15:52:56',6,58654,39170,NULL,NULL,NULL,'2025-04-13 08:52:56','2025-04-30 13:02:12'),
(2850,2,'credit',NULL,2582000.0000,NULL,'2025-04-14 08:48:37',6,58680,39202,NULL,NULL,NULL,'2025-04-14 01:48:37','2025-04-30 13:06:45'),
(2851,2,'credit',NULL,300000.0000,NULL,'2025-04-14 09:18:22',13,58668,39206,NULL,NULL,NULL,'2025-04-14 02:18:22','2025-04-14 02:18:22'),
(2852,2,'credit',NULL,850000.0000,NULL,'2025-04-14 10:10:34',13,58099,39209,NULL,NULL,NULL,'2025-04-14 03:10:34','2025-04-14 03:11:54'),
(2853,2,'credit',NULL,750000.0000,NULL,'2025-04-14 10:10:41',13,58688,39210,NULL,NULL,NULL,'2025-04-14 03:11:20','2025-04-14 03:11:20'),
(2854,2,'credit',NULL,1111000.0000,NULL,'2025-04-14 12:36:56',13,58695,39216,NULL,NULL,NULL,'2025-04-14 05:36:56','2025-04-14 05:36:56'),
(2855,2,'credit',NULL,255000.0000,NULL,'2025-04-14 14:26:11',19,58703,39232,NULL,NULL,NULL,'2025-04-14 07:26:11','2025-04-14 07:26:11'),
(2856,2,'credit',NULL,610000.0000,NULL,'2025-04-14 15:53:19',13,58578,39237,NULL,NULL,NULL,'2025-04-14 08:53:19','2025-04-14 08:53:19'),
(2857,2,'credit',NULL,570000.0000,NULL,'2025-04-14 15:53:43',13,58711,39238,NULL,NULL,NULL,'2025-04-14 08:53:43','2025-04-14 08:53:43'),
(2858,2,'credit',NULL,175000.0000,NULL,'2025-04-14 17:39:39',3,58726,39244,NULL,NULL,NULL,'2025-04-14 10:39:39','2025-04-14 10:39:39'),
(2859,2,'credit',NULL,12554000.0000,NULL,'2025-04-15 12:41:37',13,57207,39271,NULL,NULL,NULL,'2025-04-15 05:41:37','2025-04-15 06:51:56'),
(2860,2,'credit',NULL,6871000.0000,NULL,'2025-04-15 13:07:10',13,57207,39276,NULL,NULL,'2025-04-15 06:51:56','2025-04-15 06:07:10','2025-04-15 06:51:56'),
(2861,2,'debit',NULL,2436600.0000,NULL,'2025-04-15 18:27:00',1,58645,39299,NULL,NULL,NULL,'2025-04-15 11:27:48','2025-04-15 11:27:48'),
(2862,2,'debit',NULL,1752500.0000,NULL,'2025-04-15 18:29:00',1,58800,39301,NULL,NULL,NULL,'2025-04-15 11:29:58','2025-04-15 11:29:58'),
(2863,2,'debit',NULL,8420000.0000,NULL,'2025-04-15 18:33:00',1,58333,39304,NULL,NULL,NULL,'2025-04-15 11:33:26','2025-04-15 11:33:26'),
(2864,2,'debit',NULL,406150.0000,NULL,'2025-04-15 18:35:00',3,58588,39307,NULL,NULL,NULL,'2025-04-15 11:35:56','2025-04-15 11:35:56'),
(2865,2,'debit',NULL,6489200.0000,NULL,'2025-04-15 18:47:00',3,56073,39311,NULL,NULL,NULL,'2025-04-15 11:47:08','2025-04-15 11:47:08'),
(2866,2,'debit',NULL,31000.0000,NULL,'2025-04-15 18:47:00',3,56086,39312,NULL,NULL,NULL,'2025-04-15 11:47:30','2025-04-15 11:47:30'),
(2867,2,'debit',NULL,230000.0000,NULL,'2025-04-15 18:47:00',3,56103,39313,NULL,NULL,NULL,'2025-04-15 11:47:55','2025-04-15 11:47:55'),
(2868,2,'debit',NULL,5597855.0000,NULL,'2025-04-15 18:48:00',3,56192,39314,NULL,NULL,NULL,'2025-04-15 11:48:22','2025-04-15 11:48:22'),
(2869,2,'debit',NULL,49000.0000,NULL,'2025-04-15 18:48:00',3,56281,39315,NULL,NULL,NULL,'2025-04-15 11:48:42','2025-04-15 11:48:42'),
(2870,2,'debit',NULL,536500.0000,NULL,'2025-04-15 18:49:00',3,56300,39316,NULL,NULL,NULL,'2025-04-15 11:49:04','2025-04-15 11:49:04'),
(2871,2,'debit',NULL,295000.0000,NULL,'2025-04-15 18:49:00',3,56371,39318,NULL,NULL,NULL,'2025-04-15 11:49:48','2025-04-15 11:49:48'),
(2872,2,'debit',NULL,2924100.0000,NULL,'2025-04-15 18:50:00',3,56373,39319,NULL,NULL,NULL,'2025-04-15 11:50:14','2025-04-15 11:50:14'),
(2873,2,'debit',NULL,461616.0000,NULL,'2025-04-15 18:50:00',3,56374,39320,NULL,NULL,NULL,'2025-04-15 11:50:34','2025-04-15 11:50:34'),
(2874,2,'debit',NULL,2800000.0000,NULL,'2025-04-15 18:50:00',3,56464,39321,NULL,NULL,NULL,'2025-04-15 11:50:57','2025-04-15 11:50:57'),
(2875,2,'debit',NULL,134000.0000,NULL,'2025-04-15 18:51:00',3,56546,39322,NULL,NULL,NULL,'2025-04-15 11:51:20','2025-04-15 11:51:20'),
(2876,2,'debit',NULL,245000.0000,NULL,'2025-04-15 18:51:00',3,56544,39323,NULL,NULL,NULL,'2025-04-15 11:51:41','2025-04-15 11:51:41'),
(2877,2,'debit',NULL,751000.0000,NULL,'2025-04-15 18:52:00',3,56571,39324,NULL,NULL,NULL,'2025-04-15 11:52:29','2025-04-15 11:52:29'),
(2878,2,'debit',NULL,820000.0000,NULL,'2025-04-15 18:54:00',3,56576,39325,NULL,NULL,NULL,'2025-04-15 11:54:23','2025-04-15 11:54:23'),
(2879,2,'debit',NULL,921000.0000,NULL,'2025-04-15 18:54:00',3,58561,39326,NULL,NULL,NULL,'2025-04-15 11:54:40','2025-04-15 11:54:40'),
(2880,2,'debit',NULL,815200.0000,NULL,'2025-04-15 18:55:00',3,58476,39327,NULL,NULL,NULL,'2025-04-15 11:55:10','2025-04-15 11:55:10'),
(2881,2,'debit',NULL,349000.0000,NULL,'2025-04-15 18:55:00',3,58402,39328,NULL,NULL,NULL,'2025-04-15 11:55:58','2025-04-15 11:55:58'),
(2882,2,'debit',NULL,2655000.0000,NULL,'2025-04-15 18:56:00',3,58316,39330,NULL,NULL,NULL,'2025-04-15 11:57:03','2025-04-15 11:57:03'),
(2883,2,'debit',NULL,90500.0000,NULL,'2025-04-15 18:57:00',3,58307,39331,NULL,NULL,NULL,'2025-04-15 11:57:25','2025-04-15 11:57:25'),
(2884,2,'debit',NULL,550000.0000,NULL,'2025-04-15 18:58:00',3,58325,39333,NULL,NULL,NULL,'2025-04-15 11:58:09','2025-04-15 11:58:09'),
(2885,2,'debit',NULL,250000.0000,NULL,'2025-04-15 18:58:00',3,58229,39334,NULL,NULL,NULL,'2025-04-15 11:58:45','2025-04-15 11:58:45'),
(2886,2,'debit',NULL,205000.0000,NULL,'2025-04-15 18:58:00',3,58205,39335,NULL,NULL,NULL,'2025-04-15 11:59:03','2025-04-15 11:59:03'),
(2887,2,'debit',NULL,78000.0000,NULL,'2025-04-15 18:59:00',3,58204,39336,NULL,NULL,NULL,'2025-04-15 11:59:40','2025-04-15 11:59:40'),
(2888,2,'debit',NULL,276000.0000,NULL,'2025-04-15 19:02:00',19,58193,39337,NULL,NULL,NULL,'2025-04-15 12:02:12','2025-04-15 12:02:12'),
(2889,2,'debit',NULL,290900.0000,NULL,'2025-04-15 19:02:00',19,58180,39338,NULL,NULL,NULL,'2025-04-15 12:02:48','2025-04-15 12:02:48'),
(2890,2,'debit',NULL,1543500.0000,NULL,'2025-04-15 19:03:00',19,58152,39339,NULL,NULL,NULL,'2025-04-15 12:03:21','2025-04-15 12:03:21'),
(2891,2,'debit',NULL,425100.0000,NULL,'2025-04-15 19:07:00',19,58125,39340,NULL,NULL,NULL,'2025-04-15 12:07:16','2025-04-15 12:07:16'),
(2892,2,'debit',NULL,79798.0000,NULL,'2025-04-15 19:07:00',19,58041,39342,NULL,NULL,NULL,'2025-04-15 12:07:51','2025-04-15 12:07:51'),
(2893,2,'debit',NULL,860000.0000,NULL,'2025-04-15 19:08:00',19,57857,39343,NULL,NULL,NULL,'2025-04-15 12:08:22','2025-04-15 12:08:22'),
(2894,2,'debit',NULL,487000.0000,NULL,'2025-04-15 19:09:00',3,58164,39344,NULL,NULL,NULL,'2025-04-15 12:09:42','2025-04-15 12:09:42'),
(2895,2,'debit',NULL,2602100.0000,NULL,'2025-04-15 19:10:00',19,56630,39346,NULL,NULL,NULL,'2025-04-15 12:10:11','2025-04-15 12:10:11'),
(2896,2,'debit',NULL,880000.0000,NULL,'2025-04-15 19:10:00',3,57967,39347,NULL,NULL,NULL,'2025-04-15 12:10:15','2025-04-15 12:10:15'),
(2897,2,'debit',NULL,96000.0000,NULL,'2025-04-15 19:10:00',3,57939,39348,NULL,NULL,NULL,'2025-04-15 12:10:27','2025-04-15 12:10:27'),
(2898,2,'debit',NULL,11700000.0000,NULL,'2025-04-15 19:10:00',3,57897,39349,NULL,NULL,NULL,'2025-04-15 12:10:44','2025-04-15 12:10:44'),
(2899,2,'debit',NULL,305000.0000,NULL,'2025-04-15 19:10:00',3,57860,39350,NULL,NULL,NULL,'2025-04-15 12:11:01','2025-04-15 12:11:01'),
(2900,2,'debit',NULL,2092840.0000,NULL,'2025-04-15 19:11:00',19,56633,39351,NULL,NULL,NULL,'2025-04-15 12:11:12','2025-04-15 12:11:12'),
(2901,2,'debit',NULL,110000.0000,NULL,'2025-04-15 19:11:00',3,56791,39352,NULL,NULL,NULL,'2025-04-15 12:11:17','2025-04-15 12:11:17'),
(2902,2,'debit',NULL,64000.0000,NULL,'2025-04-15 19:11:00',19,56636,39353,NULL,NULL,NULL,'2025-04-15 12:11:39','2025-04-15 12:11:39'),
(2903,2,'debit',NULL,1002500.0000,NULL,'2025-04-15 19:12:00',19,56640,39354,NULL,NULL,NULL,'2025-04-15 12:12:38','2025-04-15 12:12:38'),
(2904,2,'debit',NULL,604000.0000,NULL,'2025-04-15 19:13:00',19,58162,39355,NULL,NULL,NULL,'2025-04-15 12:13:52','2025-04-15 12:13:52'),
(2905,2,'debit',NULL,191900.0000,NULL,'2025-04-15 19:14:00',19,57843,39356,NULL,NULL,NULL,'2025-04-15 12:14:18','2025-04-15 12:14:18'),
(2906,2,'debit',NULL,844400.0000,NULL,'2025-04-15 19:14:00',3,56707,39357,NULL,NULL,NULL,'2025-04-15 12:14:50','2025-04-15 12:14:50'),
(2907,2,'debit',NULL,1646000.0000,NULL,'2025-04-15 19:14:00',19,57802,39358,NULL,NULL,NULL,'2025-04-15 12:15:01','2025-04-15 12:15:01'),
(2908,2,'debit',NULL,187000.0000,NULL,'2025-04-15 19:15:00',3,56646,39360,NULL,NULL,NULL,'2025-04-15 12:15:33','2025-04-15 12:15:33'),
(2909,2,'debit',NULL,335000.0000,NULL,'2025-04-15 19:15:00',19,57724,39361,NULL,NULL,NULL,'2025-04-15 12:15:34','2025-04-15 12:15:34'),
(2910,2,'debit',NULL,168000.0000,NULL,'2025-04-15 19:15:00',3,56644,39362,NULL,NULL,NULL,'2025-04-15 12:15:56','2025-04-15 12:15:56'),
(2911,2,'debit',NULL,704000.0000,NULL,'2025-04-15 19:16:00',3,56746,39363,NULL,NULL,NULL,'2025-04-15 12:16:59','2025-04-15 12:16:59'),
(2912,2,'debit',NULL,50000.0000,NULL,'2025-04-15 19:20:00',3,57637,39364,NULL,NULL,NULL,'2025-04-15 12:20:07','2025-04-15 12:20:07'),
(2913,2,'debit',NULL,312500.0000,NULL,'2025-04-15 19:20:00',3,57601,39365,NULL,NULL,NULL,'2025-04-15 12:20:25','2025-04-15 12:20:25'),
(2914,2,'debit',NULL,1222000.0000,NULL,'2025-04-15 19:20:00',3,57528,39366,NULL,NULL,NULL,'2025-04-15 12:20:54','2025-04-15 12:20:54'),
(2915,2,'debit',NULL,85000.0000,NULL,'2025-04-15 19:21:00',3,57510,39367,NULL,NULL,NULL,'2025-04-15 12:22:02','2025-04-15 12:22:02'),
(2916,2,'debit',NULL,1210000.0000,NULL,'2025-04-15 19:24:00',3,57524,39369,NULL,NULL,NULL,'2025-04-15 12:24:07','2025-04-15 12:24:07'),
(2917,2,'debit',NULL,662400.0000,NULL,'2025-04-15 19:24:00',3,56874,39370,NULL,NULL,NULL,'2025-04-15 12:24:28','2025-04-15 12:24:28'),
(2918,2,'debit',NULL,230000.0000,NULL,'2025-04-15 19:24:00',3,56901,39371,NULL,NULL,NULL,'2025-04-15 12:25:03','2025-04-15 12:25:03'),
(2919,2,'debit',NULL,880000.0000,NULL,'2025-04-15 19:26:00',3,56798,39375,NULL,NULL,NULL,'2025-04-15 12:26:34','2025-04-15 12:26:34'),
(2920,2,'debit',NULL,253300.0000,NULL,'2025-04-15 19:26:00',3,56824,39376,NULL,NULL,NULL,'2025-04-15 12:26:49','2025-04-15 12:26:49'),
(2921,2,'debit',NULL,494300.0000,NULL,'2025-04-15 19:27:00',3,56837,39377,NULL,NULL,NULL,'2025-04-15 12:27:13','2025-04-15 12:27:13'),
(2922,2,'debit',NULL,430900.0000,NULL,'2025-04-15 19:27:00',3,57010,39378,NULL,NULL,NULL,'2025-04-15 12:27:31','2025-04-15 12:27:31'),
(2923,2,'debit',NULL,1565700.0000,NULL,'2025-04-15 19:29:00',3,57018,39379,NULL,NULL,NULL,'2025-04-15 12:29:06','2025-04-15 12:29:06'),
(2924,2,'debit',NULL,185000.0000,NULL,'2025-04-15 19:29:00',3,57138,39380,NULL,NULL,NULL,'2025-04-15 12:29:21','2025-04-15 12:29:21'),
(2925,2,'debit',NULL,205000.0000,NULL,'2025-04-15 19:29:00',3,57184,39381,NULL,NULL,NULL,'2025-04-15 12:29:39','2025-04-15 12:29:39'),
(2926,2,'debit',NULL,303000.0000,NULL,'2025-04-15 19:32:00',3,57245,39383,NULL,NULL,NULL,'2025-04-15 12:32:49','2025-04-15 12:32:49'),
(2927,2,'debit',NULL,165000.0000,NULL,'2025-04-15 19:33:00',3,57454,39384,NULL,NULL,NULL,'2025-04-15 12:33:10','2025-04-15 12:33:10'),
(2928,2,'debit',NULL,2711000.0000,NULL,'2025-04-15 19:45:00',3,55867,39388,NULL,NULL,NULL,'2025-04-15 12:45:03','2025-04-15 12:45:03'),
(2929,2,'debit',NULL,140000.0000,NULL,'2025-04-15 19:45:00',19,56764,39389,NULL,NULL,NULL,'2025-04-15 12:45:21','2025-04-15 12:45:21'),
(2930,2,'debit',NULL,56000.0000,NULL,'2025-04-15 19:46:00',19,55106,39390,NULL,NULL,NULL,'2025-04-15 12:46:51','2025-04-15 12:46:51'),
(2931,2,'debit',NULL,991200.0000,NULL,'2025-04-15 19:50:00',3,49569,39391,NULL,NULL,NULL,'2025-04-15 12:50:51','2025-04-15 12:50:51'),
(2932,2,'debit',NULL,26406000.0000,NULL,'2025-04-15 20:13:00',1,58779,39392,NULL,NULL,NULL,'2025-04-15 13:13:11','2025-04-15 13:13:11'),
(2933,2,'debit',NULL,7313000.0000,NULL,'2025-04-15 20:14:00',1,57171,39394,NULL,NULL,NULL,'2025-04-15 13:14:31','2025-04-15 13:14:31'),
(2934,2,'credit',NULL,129000.0000,NULL,'2025-04-15 21:32:19',19,58821,39404,NULL,NULL,'2025-04-16 07:21:58','2025-04-15 14:32:19','2025-04-16 07:21:58'),
(2935,2,'credit',NULL,157000.0000,NULL,'2025-04-16 11:23:41',13,58842,39417,NULL,NULL,NULL,'2025-04-16 04:23:41','2025-04-16 04:23:41'),
(2936,2,'credit',NULL,720000.0000,NULL,'2025-04-16 19:40:00',19,58873,39441,NULL,NULL,NULL,'2025-04-16 12:41:00','2025-04-30 12:47:35'),
(2937,2,'credit',NULL,441000.0000,NULL,'2025-04-16 20:48:00',19,58878,39448,NULL,NULL,NULL,'2025-04-16 13:48:33','2025-04-16 13:48:33'),
(2938,2,'credit',NULL,4345000.0000,NULL,'2025-04-17 08:25:30',13,53703,39456,NULL,NULL,NULL,'2025-04-17 01:25:30','2025-04-17 01:25:30'),
(2939,2,'credit',NULL,630000.0000,NULL,'2025-04-17 11:52:02',49,58903,39463,NULL,NULL,NULL,'2025-04-17 04:52:02','2025-04-17 04:52:02'),
(2940,2,'debit',NULL,968000.0000,NULL,'2025-04-17 15:08:00',3,58924,39474,NULL,NULL,NULL,'2025-04-17 08:09:12','2025-04-17 08:09:12'),
(2941,2,'credit',NULL,414000.0000,NULL,'2025-04-17 20:16:11',19,58945,39488,NULL,NULL,NULL,'2025-04-17 13:16:11','2025-04-17 13:16:11'),
(2942,2,'credit',NULL,470000.0000,NULL,'2025-04-17 20:22:20',19,58855,39489,NULL,NULL,NULL,'2025-04-17 13:22:20','2025-04-17 13:22:20'),
(2943,2,'credit',NULL,340000.0000,NULL,'2025-04-17 20:23:37',19,58948,39490,NULL,NULL,NULL,'2025-04-17 13:23:37','2025-04-17 13:23:37'),
(2944,2,'credit',NULL,120000.0000,NULL,'2025-04-17 21:26:49',3,58914,39496,NULL,NULL,NULL,'2025-04-17 14:26:49','2025-04-17 14:26:49'),
(2945,2,'credit',NULL,305000.0000,NULL,'2025-04-18 10:54:01',6,58969,39504,NULL,NULL,NULL,'2025-04-18 03:54:01','2025-04-18 03:54:01'),
(2946,2,'credit',NULL,120000.0000,NULL,'2025-04-18 11:45:41',2,58932,39505,NULL,NULL,NULL,'2025-04-18 04:45:41','2025-04-18 04:45:41'),
(2947,2,'credit',NULL,200000.0000,NULL,'2025-04-18 21:04:47',19,58991,39524,NULL,NULL,NULL,'2025-04-18 14:04:47','2025-05-07 02:01:56'),
(2948,2,'debit',NULL,276000.0000,NULL,'2025-04-19 17:35:00',19,59031,39548,NULL,NULL,NULL,'2025-04-19 10:36:55','2025-04-19 10:36:55'),
(2949,2,'credit',NULL,58000.0000,NULL,'2025-04-19 21:30:04',49,59026,39560,NULL,NULL,NULL,'2025-04-19 14:30:04','2025-04-27 07:23:52'),
(2950,2,'credit',NULL,714000.0000,NULL,'2025-04-20 16:00:00',19,59069,39577,NULL,NULL,NULL,'2025-04-20 09:00:37','2025-04-30 12:54:04'),
(2951,2,'credit',NULL,1886000.0000,NULL,'2025-04-20 17:21:17',106,59072,39578,NULL,NULL,NULL,'2025-04-20 10:21:17','2025-04-20 10:21:17'),
(2952,2,'credit',NULL,870000.0000,NULL,'2025-04-20 18:42:45',6,59077,39582,NULL,NULL,NULL,'2025-04-20 11:42:45','2025-04-20 11:42:45'),
(2953,2,'credit',NULL,280000.0000,NULL,'2025-04-20 18:48:27',6,58939,39585,NULL,NULL,NULL,'2025-04-20 11:48:27','2025-04-20 11:48:27'),
(2954,2,'debit',NULL,12142400.0000,NULL,'2025-04-21 09:23:00',1,58385,39602,NULL,NULL,NULL,'2025-04-21 02:23:15','2025-04-21 02:23:15'),
(2955,2,'debit',NULL,1087800.0000,NULL,'2025-04-21 09:26:00',1,58184,39603,NULL,NULL,NULL,'2025-04-21 02:26:24','2025-04-21 02:26:24'),
(2956,2,'debit',NULL,1864800.0000,NULL,'2025-04-21 09:31:00',1,58937,39604,NULL,NULL,NULL,'2025-04-21 02:31:35','2025-04-21 02:31:35'),
(2957,2,'credit',NULL,95000.0000,NULL,'2025-04-21 09:59:28',19,59109,39606,NULL,NULL,NULL,'2025-04-21 02:59:28','2025-04-21 02:59:28'),
(2958,2,'credit',NULL,55000.0000,NULL,'2025-04-21 08:25:00',19,59101,39599,NULL,NULL,NULL,'2025-04-21 05:50:56','2025-04-21 05:50:56'),
(2959,2,'credit',NULL,144000.0000,NULL,'2025-04-21 14:19:48',6,59133,39621,NULL,NULL,NULL,'2025-04-21 07:19:48','2025-04-21 07:19:48'),
(2960,2,'credit',NULL,150000.0000,NULL,'2025-04-21 14:48:12',106,58980,39623,NULL,NULL,NULL,'2025-04-21 07:48:12','2025-04-21 07:51:34'),
(2961,2,'credit',NULL,3506000.0000,NULL,'2025-04-21 19:30:08',13,56492,39635,NULL,NULL,NULL,'2025-04-21 12:30:08','2025-06-16 07:54:50'),
(2962,2,'credit',NULL,120000.0000,NULL,'2025-04-21 19:30:53',13,59152,39636,NULL,NULL,NULL,'2025-04-21 12:30:53','2025-04-21 12:30:53'),
(2963,2,'debit',NULL,130000.0000,NULL,'2025-04-22 13:06:00',3,59184,39660,NULL,NULL,NULL,'2025-04-22 06:07:40','2025-04-22 06:07:40'),
(2964,2,'credit',NULL,6970000.0000,NULL,'2025-04-22 14:01:43',3,53556,39664,NULL,NULL,NULL,'2025-04-22 07:01:43','2025-04-22 07:01:43'),
(2965,2,'credit',NULL,96000.0000,NULL,'2025-04-22 17:46:18',49,59216,39682,NULL,NULL,NULL,'2025-04-22 10:46:18','2025-04-22 10:46:18'),
(2966,2,'credit',NULL,301000.0000,NULL,'2025-04-22 17:54:56',6,59217,39683,NULL,NULL,NULL,'2025-04-22 10:54:56','2025-04-22 10:54:56'),
(2967,2,'credit',NULL,4259000.0000,NULL,'2025-04-22 18:17:39',13,59211,39684,NULL,NULL,NULL,'2025-04-22 11:17:39','2025-04-29 10:30:47'),
(2968,2,'debit',NULL,490000.0000,NULL,'2025-04-22 19:03:00',6,59227,39687,NULL,NULL,NULL,'2025-04-22 12:06:12','2025-04-22 12:06:12'),
(2969,2,'credit',NULL,4471000.0000,NULL,'2025-04-22 21:16:30',6,59023,39689,NULL,NULL,NULL,'2025-04-22 14:16:30','2025-04-29 08:23:29'),
(2970,2,'credit',NULL,48000.0000,NULL,'2025-04-23 08:37:52',106,59239,39693,NULL,NULL,NULL,'2025-04-23 01:37:52','2025-04-23 01:37:52'),
(2971,2,'credit',NULL,150000.0000,NULL,'2025-04-23 09:20:19',19,59242,39695,NULL,NULL,NULL,'2025-04-23 02:20:19','2025-04-23 02:20:19'),
(2972,2,'credit',NULL,287200.0000,NULL,'2025-04-23 15:12:00',19,59260,39709,NULL,NULL,NULL,'2025-04-23 08:12:56','2025-04-23 08:12:56'),
(2973,2,'debit',NULL,275000.0000,NULL,'2025-04-23 15:19:00',19,59263,39710,NULL,NULL,NULL,'2025-04-23 08:20:27','2025-04-23 08:20:27'),
(2974,2,'debit',NULL,122000.0000,NULL,'2025-04-23 16:33:00',3,59276,39718,NULL,NULL,NULL,'2025-04-23 09:36:43','2025-04-23 09:36:43'),
(2975,2,'credit',NULL,147000.0000,NULL,'2025-04-23 18:30:51',19,59290,39729,NULL,NULL,NULL,'2025-04-23 11:30:51','2025-04-23 11:30:51'),
(2976,2,'credit',NULL,2985000.0000,NULL,'2025-04-23 21:22:08',13,59304,39736,NULL,NULL,NULL,'2025-04-23 14:22:08','2025-05-03 08:27:14'),
(2977,2,'debit',NULL,617000.0000,NULL,'2025-04-24 14:59:00',3,59337,39765,NULL,NULL,NULL,'2025-04-24 08:03:31','2025-04-24 08:03:31'),
(2978,2,'credit',NULL,80000.0000,NULL,'2025-04-24 15:12:21',19,59294,39766,NULL,NULL,NULL,'2025-04-24 08:12:21','2025-04-24 08:12:21'),
(2979,2,'credit',NULL,751000.0000,NULL,'2025-04-24 16:29:12',3,59344,39768,NULL,NULL,NULL,'2025-04-24 09:29:12','2025-04-24 09:29:12'),
(2980,2,'credit',NULL,2830500.0000,NULL,'2025-04-24 19:17:43',49,59271,39774,NULL,NULL,NULL,'2025-04-24 12:17:43','2025-04-25 09:00:47'),
(2981,2,'credit',NULL,825000.0000,NULL,'2025-04-24 22:07:38',49,59036,39784,NULL,NULL,NULL,'2025-04-24 15:07:38','2025-04-24 15:07:38'),
(2982,2,'credit',NULL,7043125.0000,NULL,'2025-04-23 12:16:44',3,59247,39699,NULL,NULL,NULL,'2025-04-25 03:48:37','2025-05-26 14:02:17'),
(2983,2,'credit',NULL,180000.0000,NULL,'2025-04-25 10:49:44',106,59267,39787,NULL,NULL,NULL,'2025-04-25 03:49:44','2025-04-25 03:49:44'),
(2984,2,'credit',NULL,362500.0000,NULL,'2025-04-25 15:44:30',3,59384,39801,NULL,NULL,NULL,'2025-04-25 08:44:30','2025-04-25 08:44:30'),
(2985,2,'credit',NULL,362500.0000,NULL,'2025-04-25 15:44:34',3,59385,39802,NULL,NULL,NULL,'2025-04-25 08:44:34','2025-04-25 08:44:34'),
(2986,2,'credit',NULL,425000.0000,NULL,'2025-04-25 16:00:55',3,59386,39805,NULL,NULL,NULL,'2025-04-25 09:00:55','2025-04-25 09:00:55'),
(2987,2,'credit',NULL,425000.0000,NULL,'2025-04-25 16:01:00',3,59388,39806,NULL,NULL,NULL,'2025-04-25 09:01:00','2025-04-25 09:01:00'),
(2988,2,'debit',NULL,1893400.0000,NULL,'2025-04-26 10:43:00',1,59090,39823,NULL,NULL,NULL,'2025-04-26 03:43:16','2025-04-26 03:43:16'),
(2989,2,'credit',NULL,265000.0000,NULL,'2025-04-26 10:46:32',6,59410,39824,NULL,NULL,NULL,'2025-04-26 03:46:32','2025-04-26 03:46:32'),
(2990,2,'debit',NULL,1749300.0000,NULL,'2025-04-26 11:01:00',1,59086,39825,NULL,NULL,NULL,'2025-04-26 04:01:37','2025-04-26 04:01:37'),
(2991,2,'debit',NULL,1794900.0000,NULL,'2025-04-26 11:08:00',1,59061,39826,NULL,NULL,NULL,'2025-04-26 04:09:11','2025-04-26 04:09:11'),
(2992,2,'debit',NULL,4700300.0000,NULL,'2025-04-26 11:28:00',1,58954,39827,NULL,NULL,NULL,'2025-04-26 04:29:04','2025-04-26 04:29:04'),
(2993,2,'debit',NULL,1459000.0000,NULL,'2025-04-26 11:37:00',1,59409,39829,NULL,NULL,NULL,'2025-04-26 04:37:15','2025-04-26 04:37:15'),
(2994,2,'debit',NULL,15966000.0000,NULL,'2025-04-26 11:41:00',1,59198,39830,NULL,NULL,NULL,'2025-04-26 04:41:26','2025-04-26 04:41:26'),
(2995,2,'debit',NULL,331398.0000,NULL,'2025-04-26 11:44:00',1,59393,39831,NULL,NULL,NULL,'2025-04-26 04:44:29','2025-04-26 04:44:29'),
(2996,2,'debit',NULL,1100000.0000,NULL,'2025-04-26 12:34:00',3,59422,39835,NULL,NULL,NULL,'2025-04-26 05:35:14','2025-04-26 05:35:14'),
(2997,2,'credit',NULL,314000.0000,NULL,'2025-04-26 13:00:33',6,59423,39837,NULL,NULL,NULL,'2025-04-26 06:00:33','2025-04-26 06:00:33'),
(2998,2,'debit',NULL,977000.0000,NULL,'2025-04-26 14:58:00',3,59440,39848,NULL,NULL,NULL,'2025-04-26 08:05:24','2025-04-26 08:05:24'),
(2999,2,'credit',NULL,75000.0000,NULL,'2025-04-26 15:15:17',106,59443,39849,NULL,NULL,NULL,'2025-04-26 08:15:17','2025-04-26 08:15:17'),
(3000,2,'credit',NULL,66000.0000,NULL,'2025-04-26 17:26:38',6,59458,39855,NULL,NULL,NULL,'2025-04-26 10:26:38','2025-04-26 10:26:38'),
(3001,2,'credit',NULL,172000.0000,NULL,'2025-04-26 17:35:29',49,59459,39856,NULL,NULL,NULL,'2025-04-26 10:35:29','2025-04-26 10:35:29'),
(3002,2,'credit',NULL,2410000.0000,NULL,'2025-04-26 18:07:41',13,59387,39859,NULL,NULL,'2025-04-26 11:33:15','2025-04-26 11:07:41','2025-04-26 11:33:15'),
(3003,2,'debit',NULL,170000.0000,NULL,'2025-04-26 18:25:00',6,59460,39860,NULL,NULL,NULL,'2025-04-26 11:25:47','2025-04-26 11:25:47'),
(3004,2,'credit',NULL,2401000.0000,NULL,'2025-04-26 19:17:52',13,59387,39867,NULL,NULL,NULL,'2025-04-26 12:17:52','2025-04-29 08:26:08'),
(3005,2,'credit',NULL,250000.0000,NULL,'2025-04-26 20:19:40',49,59427,39871,NULL,NULL,NULL,'2025-04-26 13:19:40','2025-05-31 13:00:58'),
(3006,2,'credit',NULL,175000.0000,NULL,'2025-04-26 21:28:55',13,59471,39873,NULL,NULL,NULL,'2025-04-26 14:28:55','2025-04-27 14:04:19'),
(3007,2,'credit',NULL,3162000.0000,NULL,'2025-04-27 09:50:10',6,59023,39874,NULL,NULL,NULL,'2025-04-27 02:50:10','2025-04-29 08:23:29'),
(3008,2,'credit',NULL,226000.0000,NULL,'2025-04-27 13:10:21',13,59487,39879,NULL,NULL,NULL,'2025-04-27 06:10:21','2025-04-27 06:10:21'),
(3009,2,'credit',NULL,20000.0000,NULL,'2025-04-27 14:23:46',3,59491,39887,NULL,NULL,NULL,'2025-04-27 07:23:46','2025-04-27 07:23:46'),
(3010,2,'credit',NULL,40000.0000,NULL,'2025-04-27 14:58:29',3,59500,39895,NULL,NULL,NULL,'2025-04-27 07:58:29','2025-04-27 07:58:29'),
(3011,2,'credit',NULL,40000.0000,NULL,'2025-04-27 14:58:34',3,59501,39896,NULL,NULL,NULL,'2025-04-27 07:58:34','2025-04-27 07:58:34'),
(3012,2,'credit',NULL,164000.0000,NULL,'2025-04-27 15:55:32',13,59509,39905,NULL,NULL,NULL,'2025-04-27 08:55:32','2025-04-27 08:55:32'),
(3013,2,'credit',NULL,912500.0000,NULL,'2025-04-27 15:55:52',3,59510,39907,NULL,NULL,NULL,'2025-04-27 08:55:52','2025-04-27 08:55:52'),
(3014,2,'credit',NULL,912500.0000,NULL,'2025-04-27 15:55:58',3,59511,39908,NULL,NULL,NULL,'2025-04-27 08:55:58','2025-04-27 08:55:58'),
(3015,2,'credit',NULL,150000.0000,NULL,'2025-04-27 20:11:57',3,59329,39916,NULL,NULL,NULL,'2025-04-27 13:11:57','2025-04-30 02:18:06'),
(3016,2,'credit',NULL,40000.0000,NULL,'2025-04-27 21:04:29',3,59519,39920,NULL,NULL,NULL,'2025-04-27 14:04:29','2025-04-27 14:04:29'),
(3017,2,'credit',NULL,40000.0000,NULL,'2025-04-27 21:04:36',3,59520,39921,NULL,NULL,NULL,'2025-04-27 14:04:36','2025-04-27 14:04:36'),
(3018,2,'credit',NULL,175000.0000,NULL,'2025-04-27 21:09:06',3,59521,39922,NULL,NULL,NULL,'2025-04-27 14:09:06','2025-04-27 14:09:06'),
(3019,2,'credit',NULL,75000.0000,NULL,'2025-04-27 21:13:00',3,59523,39925,NULL,NULL,NULL,'2025-04-27 14:13:00','2025-04-27 14:13:00'),
(3020,2,'credit',NULL,75000.0000,NULL,'2025-04-27 21:13:19',3,59524,39926,NULL,NULL,NULL,'2025-04-27 14:13:19','2025-04-27 14:13:19'),
(3021,2,'credit',NULL,75000.0000,NULL,'2025-04-27 21:15:18',3,59525,39928,NULL,NULL,NULL,'2025-04-27 14:15:18','2025-04-27 14:15:18'),
(3022,2,'credit',NULL,75000.0000,NULL,'2025-04-27 21:15:25',3,59526,39929,NULL,NULL,NULL,'2025-04-27 14:15:25','2025-04-27 14:15:25'),
(3023,2,'credit',NULL,75000.0000,NULL,'2025-04-27 21:18:27',3,59527,39930,NULL,NULL,NULL,'2025-04-27 14:18:27','2025-04-27 14:18:27'),
(3024,2,'credit',NULL,75000.0000,NULL,'2025-04-27 21:18:49',3,59528,39931,NULL,NULL,NULL,'2025-04-27 14:18:49','2025-04-27 14:18:49'),
(3025,2,'credit',NULL,350000.0000,NULL,'2025-04-27 21:21:45',3,59529,39933,NULL,NULL,NULL,'2025-04-27 14:21:45','2025-04-27 14:21:45'),
(3026,2,'credit',NULL,350000.0000,NULL,'2025-04-27 21:21:51',3,59530,39934,NULL,NULL,NULL,'2025-04-27 14:21:51','2025-04-27 14:21:51'),
(3027,2,'credit',NULL,200000.0000,NULL,'2025-04-28 09:55:13',49,59476,39941,NULL,NULL,NULL,'2025-04-28 02:55:13','2025-05-03 03:42:49'),
(3028,2,'debit',NULL,73000.0000,NULL,'2025-04-28 14:59:00',49,59563,39949,NULL,NULL,NULL,'2025-04-28 08:16:37','2025-04-28 08:16:37'),
(3029,2,'credit',NULL,234000.0000,NULL,'2025-04-28 17:02:29',49,59573,39956,NULL,NULL,NULL,'2025-04-28 10:02:29','2025-04-28 10:02:29'),
(3030,2,'credit',NULL,15000.0000,NULL,'2025-04-28 17:02:42',49,59542,39957,NULL,NULL,NULL,'2025-04-28 10:02:42','2025-04-28 10:03:32'),
(3031,2,'credit',NULL,3007000.0000,NULL,'2025-04-28 17:52:38',106,59579,39961,NULL,NULL,NULL,'2025-04-28 10:52:38','2025-04-28 14:24:35'),
(3032,2,'credit',NULL,11000.0000,NULL,'2025-04-28 20:31:53',3,59592,39973,NULL,NULL,NULL,'2025-04-28 13:31:53','2025-04-28 13:31:53'),
(3033,2,'debit',NULL,5935500.0000,NULL,'2025-04-28 20:46:00',1,58183,39975,NULL,NULL,NULL,'2025-04-28 13:46:43','2025-04-28 13:46:43'),
(3034,2,'debit',NULL,9233000.0000,NULL,'2025-04-28 20:47:00',1,58185,39976,NULL,NULL,NULL,'2025-04-28 13:47:29','2025-04-28 13:47:29'),
(3035,2,'debit',NULL,13077000.0000,NULL,'2025-04-28 21:09:00',1,56628,39979,NULL,NULL,NULL,'2025-04-28 14:09:20','2025-04-28 14:09:20'),
(3036,2,'debit',NULL,1457400.0000,NULL,'2025-04-28 21:24:00',1,58182,39983,NULL,NULL,NULL,'2025-04-28 14:24:57','2025-04-28 14:24:57'),
(3037,2,'debit',NULL,600000.0000,NULL,'2025-04-28 21:36:00',3,57668,39985,NULL,NULL,NULL,'2025-04-28 14:36:39','2025-04-28 14:36:39'),
(3038,2,'debit',NULL,120000.0000,NULL,'2025-04-28 21:37:00',19,59464,39986,NULL,NULL,NULL,'2025-04-28 14:37:12','2025-04-28 14:37:12'),
(3039,2,'debit',NULL,85000.0000,NULL,'2025-04-28 21:37:00',3,58950,39988,NULL,NULL,NULL,'2025-04-28 14:37:50','2025-04-28 14:37:50'),
(3040,2,'debit',NULL,42900.0000,NULL,'2025-04-28 21:38:00',19,59457,39989,NULL,NULL,NULL,'2025-04-28 14:38:31','2025-04-28 14:38:31'),
(3041,2,'debit',NULL,364000.0000,NULL,'2025-04-28 21:38:00',3,58473,39990,NULL,NULL,NULL,'2025-04-28 14:38:33','2025-04-28 14:38:33'),
(3042,2,'debit',NULL,365000.0000,NULL,'2025-04-28 21:39:00',3,58814,39992,NULL,NULL,NULL,'2025-04-28 14:39:36','2025-04-28 14:39:36'),
(3043,2,'debit',NULL,445000.0000,NULL,'2025-04-28 21:39:00',3,58859,39993,NULL,NULL,NULL,'2025-04-28 14:40:11','2025-04-28 14:40:11'),
(3044,2,'debit',NULL,151000.0000,NULL,'2025-04-28 21:40:00',3,58888,39994,NULL,NULL,NULL,'2025-04-28 14:40:44','2025-04-28 14:40:44'),
(3045,2,'debit',NULL,340000.0000,NULL,'2025-04-28 21:40:00',3,58916,39995,NULL,NULL,NULL,'2025-04-28 14:41:03','2025-04-28 14:41:03'),
(3046,2,'debit',NULL,559000.0000,NULL,'2025-04-28 21:41:00',19,59448,39996,NULL,NULL,NULL,'2025-04-28 14:41:13','2025-04-28 14:41:13'),
(3047,2,'debit',NULL,118000.0000,NULL,'2025-04-28 21:41:00',19,59376,39998,NULL,NULL,NULL,'2025-04-28 14:41:58','2025-04-28 14:41:58'),
(3048,2,'debit',NULL,1280000.0000,NULL,'2025-04-28 21:42:00',19,59195,39999,NULL,NULL,NULL,'2025-04-28 14:42:30','2025-04-28 14:42:30'),
(3049,2,'debit',NULL,260000.0000,NULL,'2025-04-28 21:42:00',3,58965,40000,NULL,NULL,NULL,'2025-04-28 14:43:02','2025-04-28 14:43:02'),
(3050,2,'debit',NULL,339300.0000,NULL,'2025-04-28 21:43:00',19,59187,40001,NULL,NULL,NULL,'2025-04-28 14:43:15','2025-04-28 14:43:15'),
(3051,2,'debit',NULL,352000.0000,NULL,'2025-04-28 21:43:00',3,58984,40002,NULL,NULL,NULL,'2025-04-28 14:43:18','2025-04-28 14:43:18'),
(3052,2,'debit',NULL,80000.0000,NULL,'2025-04-28 21:43:00',19,59166,40003,NULL,NULL,NULL,'2025-04-28 14:43:37','2025-04-28 14:43:37'),
(3053,2,'debit',NULL,180000.0000,NULL,'2025-04-28 21:43:00',3,59027,40004,NULL,NULL,NULL,'2025-04-28 14:43:40','2025-04-28 14:43:40'),
(3054,2,'debit',NULL,60000.0000,NULL,'2025-04-28 21:43:00',19,59138,40005,NULL,NULL,NULL,'2025-04-28 14:43:59','2025-04-28 14:43:59'),
(3055,2,'debit',NULL,30900.0000,NULL,'2025-04-28 21:44:00',19,59032,40006,NULL,NULL,NULL,'2025-04-28 14:44:35','2025-04-28 14:44:35'),
(3056,2,'debit',NULL,704000.0000,NULL,'2025-04-28 21:45:00',19,57894,40007,NULL,NULL,NULL,'2025-04-28 14:46:04','2025-04-28 14:46:04'),
(3057,2,'debit',NULL,246000.0000,NULL,'2025-04-28 21:58:00',19,59597,40009,NULL,NULL,'2025-04-29 01:24:07','2025-04-28 14:58:32','2025-04-29 01:24:07'),
(3058,2,'debit',NULL,74000.0000,NULL,'2025-04-29 13:50:00',106,59621,40023,NULL,NULL,NULL,'2025-04-29 06:51:50','2025-04-29 06:51:50'),
(3059,2,'debit',NULL,1656000.0000,NULL,'2025-04-29 14:30:00',3,59625,40024,NULL,NULL,NULL,'2025-04-29 07:31:18','2025-04-29 07:31:18'),
(3060,2,'credit',NULL,127500.0000,NULL,'2025-04-29 14:47:52',6,59630,40027,NULL,NULL,NULL,'2025-04-29 07:47:52','2025-04-29 07:47:52'),
(3061,2,'credit',NULL,127500.0000,NULL,'2025-04-29 14:48:23',6,59631,40028,NULL,NULL,NULL,'2025-04-29 07:48:23','2025-04-29 07:48:23'),
(3062,2,'credit',NULL,614000.0000,NULL,'2025-04-29 15:15:53',6,59635,40032,NULL,NULL,NULL,'2025-04-29 08:15:53','2025-04-29 08:15:53'),
(3063,2,'credit',NULL,618000.0000,NULL,'2025-04-29 15:20:34',6,59636,40033,NULL,NULL,NULL,'2025-04-29 08:20:34','2025-04-29 08:20:34'),
(3064,2,'credit',NULL,618000.0000,NULL,'2025-04-29 15:23:03',6,59637,40034,NULL,NULL,NULL,'2025-04-29 08:23:03','2025-04-29 08:23:03'),
(3065,2,'debit',NULL,240000.0000,NULL,'2025-04-29 15:20:00',49,59638,40036,NULL,NULL,NULL,'2025-04-29 08:23:37','2025-04-29 08:23:37'),
(3066,2,'credit',NULL,1254000.0000,NULL,'2025-04-29 18:07:08',106,59663,40047,NULL,NULL,NULL,'2025-04-29 11:07:08','2025-04-29 11:07:08'),
(3067,2,'credit',NULL,140000.0000,NULL,'2025-04-29 21:30:29',6,59677,40054,NULL,NULL,NULL,'2025-04-29 14:30:29','2025-04-29 14:30:29'),
(3068,2,'credit',NULL,574000.0000,NULL,'2025-04-30 09:17:58',49,59681,40056,NULL,NULL,NULL,'2025-04-30 02:17:58','2025-04-30 02:17:58'),
(3069,2,'credit',NULL,1196500.0000,NULL,'2025-04-30 10:00:29',49,59684,40057,NULL,NULL,NULL,'2025-04-30 03:00:29','2025-04-30 03:00:29'),
(3070,2,'credit',NULL,40000.0000,NULL,'2025-04-30 14:00:29',19,59695,40074,NULL,NULL,NULL,'2025-04-30 07:00:29','2025-04-30 07:00:29'),
(3071,2,'credit',NULL,338000.0000,NULL,'2025-04-30 14:07:32',106,59694,40078,NULL,NULL,NULL,'2025-04-30 07:07:32','2025-04-30 07:07:32'),
(3072,2,'debit',NULL,2490000.0000,NULL,'2025-04-30 15:26:00',49,59709,40084,NULL,NULL,NULL,'2025-04-30 08:28:56','2025-04-30 08:28:56'),
(3073,2,'credit',NULL,48000.0000,NULL,'2025-04-30 15:37:47',49,59710,40085,NULL,NULL,NULL,'2025-04-30 08:37:47','2025-04-30 08:37:47'),
(3074,2,'credit',NULL,250000.0000,NULL,'2025-04-30 19:49:04',19,59743,40097,NULL,NULL,NULL,'2025-04-30 12:49:04','2025-04-30 12:49:04'),
(3075,2,'credit',NULL,250000.0000,NULL,'2025-04-30 19:50:16',19,59744,40098,NULL,NULL,NULL,'2025-04-30 12:50:16','2025-04-30 12:50:16'),
(3076,2,'credit',NULL,40000.0000,NULL,'2025-04-30 20:02:45',19,59747,40102,NULL,NULL,NULL,'2025-04-30 13:02:45','2025-04-30 13:02:45'),
(3077,2,'credit',NULL,40000.0000,NULL,'2025-04-30 20:03:10',19,59748,40103,NULL,NULL,NULL,'2025-04-30 13:03:10','2025-04-30 13:03:10'),
(3078,2,'credit',NULL,150000.0000,NULL,'2025-04-30 20:07:00',19,59749,40105,NULL,NULL,NULL,'2025-04-30 13:07:00','2025-04-30 13:07:00'),
(3079,2,'credit',NULL,700000.0000,NULL,'2025-04-30 20:56:13',19,59750,40107,NULL,NULL,NULL,'2025-04-30 13:56:13','2025-05-03 12:07:08'),
(3080,2,'credit',NULL,280000.0000,NULL,'2025-05-01 11:49:08',49,59773,40138,NULL,NULL,NULL,'2025-05-01 05:56:05','2025-05-01 05:56:05'),
(3081,2,'credit',NULL,10000.0000,NULL,'2025-05-01 14:51:51',19,59786,40151,NULL,NULL,NULL,'2025-05-01 07:51:51','2025-05-06 11:46:37'),
(3082,2,'credit',NULL,75000.0000,NULL,'2025-05-01 15:47:16',106,59774,40157,NULL,NULL,NULL,'2025-05-01 08:47:16','2025-05-01 08:47:16'),
(3083,2,'debit',NULL,74000.0000,NULL,'2025-05-01 15:48:00',106,59807,40161,NULL,NULL,NULL,'2025-05-01 10:03:44','2025-05-01 10:03:44'),
(3084,2,'debit',NULL,465000.0000,NULL,'2025-05-01 18:43:00',19,59815,40171,NULL,NULL,NULL,'2025-05-01 11:45:27','2025-05-01 11:45:27'),
(3085,2,'credit',NULL,490000.0000,NULL,'2025-05-01 19:26:36',106,59816,40172,NULL,NULL,'2025-05-18 10:26:23','2025-05-01 12:26:36','2025-05-18 10:26:23'),
(3086,2,'credit',NULL,280000.0000,NULL,'2025-05-01 20:16:59',106,59823,40182,NULL,NULL,NULL,'2025-05-01 13:16:59','2025-05-01 13:16:59'),
(3087,2,'credit',NULL,15000.0000,NULL,'2025-05-01 20:55:23',106,59674,40185,NULL,NULL,NULL,'2025-05-01 13:55:23','2025-05-01 13:55:23'),
(3088,2,'credit',NULL,234000.0000,NULL,'2025-05-01 20:55:44',106,59827,40186,NULL,NULL,NULL,'2025-05-01 13:55:44','2025-05-01 13:55:44'),
(3089,2,'credit',NULL,169000.0000,NULL,'2025-05-02 09:15:15',106,59833,40192,NULL,NULL,NULL,'2025-05-02 02:15:15','2025-05-02 02:15:15'),
(3090,2,'credit',NULL,7125000.0000,NULL,'2025-05-02 09:35:34',106,59829,40194,NULL,NULL,NULL,'2025-05-02 02:35:34','2025-05-02 02:35:34'),
(3091,2,'credit',NULL,350000.0000,NULL,'2025-05-02 12:24:52',106,59804,40200,NULL,NULL,NULL,'2025-05-02 05:24:52','2025-05-05 10:34:09'),
(3092,2,'credit',NULL,1050000.0000,NULL,'2025-05-02 15:04:41',13,59858,40214,NULL,NULL,NULL,'2025-05-02 08:04:41','2025-05-09 01:50:14'),
(3093,2,'debit',NULL,170000.0000,NULL,'2025-05-02 16:27:00',6,59872,40222,NULL,NULL,NULL,'2025-05-02 09:28:39','2025-05-02 09:28:39'),
(3094,2,'credit',NULL,150000.0000,NULL,'2025-05-02 16:32:15',6,59616,40224,NULL,NULL,NULL,'2025-05-02 09:32:15','2025-05-02 09:32:15'),
(3095,2,'credit',NULL,270000.0000,NULL,'2025-05-02 16:32:33',6,59874,40225,NULL,NULL,NULL,'2025-05-02 09:32:33','2025-05-07 11:16:44'),
(3096,2,'credit',NULL,1050000.0000,NULL,'2025-05-02 16:37:47',13,59858,40226,NULL,NULL,NULL,'2025-05-02 09:37:47','2025-05-09 01:50:14'),
(3097,2,'credit',NULL,50000.0000,NULL,'2025-05-02 17:22:03',13,59876,40229,NULL,NULL,NULL,'2025-05-02 10:22:03','2025-05-10 10:46:38'),
(3098,2,'credit',NULL,200000.0000,NULL,'2025-05-02 18:13:52',49,59611,40234,NULL,NULL,NULL,'2025-05-02 11:13:52','2025-05-07 01:59:07'),
(3099,2,'credit',NULL,25000.0000,NULL,'2025-05-02 18:22:40',106,59886,40235,NULL,NULL,NULL,'2025-05-02 11:24:09','2025-05-02 11:24:09'),
(3100,2,'debit',NULL,250000.0000,NULL,'2025-05-02 18:44:00',19,59888,40237,NULL,NULL,NULL,'2025-05-02 11:44:43','2025-05-02 11:44:43'),
(3101,2,'credit',NULL,66000.0000,NULL,'2025-05-02 21:16:40',19,59903,40250,NULL,NULL,NULL,'2025-05-02 14:16:40','2025-05-06 11:50:24'),
(3102,2,'credit',NULL,160000.0000,NULL,'2025-05-03 11:44:00',49,59717,40261,NULL,NULL,NULL,'2025-05-03 04:44:00','2025-05-03 04:44:00'),
(3103,2,'credit',NULL,200000.0000,NULL,'2025-05-03 12:41:02',6,59551,40265,NULL,NULL,NULL,'2025-05-03 05:41:02','2025-06-26 07:15:56'),
(3104,2,'credit',NULL,7043125.0000,NULL,'2025-05-03 13:55:43',3,59247,40270,NULL,NULL,'2025-05-03 06:58:21','2025-05-03 06:55:43','2025-05-03 06:58:21'),
(3105,2,'credit',NULL,6896875.0000,NULL,'2025-05-03 13:58:21',3,59247,40271,NULL,NULL,'2025-05-03 07:36:51','2025-05-03 06:58:21','2025-05-03 07:36:51'),
(3106,2,'credit',NULL,200000.0000,NULL,'2025-05-03 14:32:32',6,59664,40272,NULL,NULL,NULL,'2025-05-03 07:32:32','2025-05-03 07:32:32'),
(3107,2,'credit',NULL,7043125.0000,NULL,'2025-05-03 14:36:51',3,59247,40274,NULL,NULL,'2025-05-03 07:49:17','2025-05-03 07:36:51','2025-05-03 07:49:17'),
(3108,2,'debit',NULL,482000.0000,NULL,'2025-05-03 14:58:00',13,59936,40277,NULL,NULL,NULL,'2025-05-03 08:00:40','2025-05-03 08:00:40'),
(3109,2,'debit',NULL,380000.0000,NULL,'2025-05-03 15:36:00',49,59942,40279,NULL,NULL,NULL,'2025-05-03 08:40:00','2025-05-03 08:40:00'),
(3110,2,'debit',NULL,157000.0000,NULL,'2025-05-03 15:49:00',6,59944,40281,NULL,NULL,NULL,'2025-05-03 08:51:39','2025-05-03 08:51:39'),
(3111,2,'credit',NULL,590000.0000,NULL,'2025-05-03 15:54:24',3,59877,40283,NULL,NULL,NULL,'2025-05-03 08:54:24','2025-05-03 08:54:24'),
(3112,2,'credit',NULL,150000.0000,NULL,'2025-05-03 20:17:10',3,58628,40294,NULL,NULL,NULL,'2025-05-03 13:17:10','2025-05-03 13:17:10'),
(3113,2,'credit',NULL,537500.0000,NULL,'2025-05-03 20:18:24',3,59961,40295,NULL,NULL,NULL,'2025-05-03 13:18:24','2025-05-03 13:18:24'),
(3114,2,'debit',NULL,122500.0000,NULL,'2025-05-03 20:50:00',106,59966,40299,NULL,NULL,NULL,'2025-05-03 13:53:51','2025-05-03 13:53:51'),
(3115,2,'credit',NULL,880000.0000,NULL,'2025-05-03 21:42:03',106,59969,40305,NULL,NULL,NULL,'2025-05-03 14:42:03','2025-05-03 14:42:03'),
(3116,2,'debit',NULL,694500.0000,NULL,'2025-05-04 14:39:00',106,59990,40321,NULL,NULL,NULL,'2025-05-04 07:44:17','2025-05-04 07:44:17'),
(3117,2,'debit',NULL,23300000.0000,NULL,'2025-05-05 08:45:00',1,59976,40356,NULL,NULL,NULL,'2025-05-05 01:45:26','2025-05-05 01:45:26'),
(3118,2,'debit',NULL,2228600.0000,NULL,'2025-05-05 09:19:00',1,59088,40358,NULL,NULL,NULL,'2025-05-05 02:19:51','2025-05-05 02:19:51'),
(3119,2,'debit',NULL,6117000.0000,NULL,'2025-05-05 09:41:00',1,59087,40364,NULL,NULL,NULL,'2025-05-05 02:41:30','2025-05-05 02:41:30'),
(3120,2,'credit',NULL,600000.0000,NULL,'2025-05-05 11:34:31',3,59809,40385,NULL,NULL,NULL,'2025-05-05 04:34:31','2025-05-05 06:05:52'),
(3121,2,'credit',NULL,10000.0000,NULL,'2025-05-05 12:34:47',3,60035,40390,NULL,NULL,NULL,'2025-05-05 05:34:47','2025-05-09 01:55:45'),
(3122,2,'credit',NULL,506000.0000,NULL,'2025-05-05 13:06:14',106,60036,40392,NULL,NULL,NULL,'2025-05-05 06:06:14','2025-05-05 06:06:14'),
(3123,2,'debit',NULL,478500.0000,NULL,'2025-05-05 14:25:00',19,60045,40398,NULL,NULL,NULL,'2025-05-05 07:27:44','2025-05-05 07:27:44'),
(3124,2,'credit',NULL,7043125.0000,NULL,'2025-05-05 15:17:40',3,59247,40400,NULL,NULL,'2025-05-05 08:19:41','2025-05-05 08:17:40','2025-05-05 08:19:41'),
(3125,2,'credit',NULL,6896875.0000,NULL,'2025-05-05 15:19:41',3,59247,40401,NULL,NULL,'2025-05-05 08:38:19','2025-05-05 08:19:41','2025-05-05 08:38:19'),
(3126,2,'debit',NULL,146000.0000,NULL,'2025-05-05 15:36:00',19,60046,40403,NULL,NULL,NULL,'2025-05-05 08:36:10','2025-05-05 08:36:10'),
(3127,2,'credit',NULL,7043125.0000,NULL,'2025-05-05 15:38:19',3,59247,40405,NULL,NULL,'2025-05-07 05:22:01','2025-05-05 08:38:19','2025-05-07 05:22:01'),
(3128,2,'debit',NULL,559000.0000,NULL,'2025-05-05 16:57:00',3,60066,40409,NULL,NULL,NULL,'2025-05-05 09:59:15','2025-05-05 09:59:15'),
(3129,2,'credit',NULL,35000.0000,NULL,'2025-05-05 17:00:28',19,59957,40410,NULL,NULL,NULL,'2025-05-05 10:00:28','2025-05-05 10:00:28'),
(3130,2,'credit',NULL,500000.0000,NULL,'2025-05-05 17:30:42',13,60072,40414,NULL,NULL,NULL,'2025-05-05 10:33:54','2025-05-30 07:29:37'),
(3131,2,'credit',NULL,490000.0000,NULL,'2025-05-05 17:33:54',13,60072,40415,NULL,NULL,NULL,'2025-05-05 10:33:54','2025-05-30 07:29:37'),
(3132,2,'credit',NULL,728000.0000,NULL,'2025-05-06 09:04:03',3,60088,40431,NULL,NULL,NULL,'2025-05-06 02:04:03','2025-05-09 02:06:33'),
(3133,2,'credit',NULL,785000.0000,NULL,'2025-05-06 12:01:02',10,60103,40444,NULL,NULL,NULL,'2025-05-06 05:01:02','2025-05-09 02:08:09'),
(3134,2,'debit',NULL,404000.0000,NULL,'2025-05-06 14:42:00',49,60114,40454,NULL,NULL,NULL,'2025-05-06 07:45:14','2025-05-06 07:45:14'),
(3135,2,'credit',NULL,176000.0000,NULL,'2025-05-06 16:42:59',6,60125,40476,NULL,NULL,NULL,'2025-05-06 09:43:13','2025-05-31 11:46:41'),
(3136,2,'credit',NULL,325600.0000,NULL,'2025-05-06 17:16:08',3,58612,40478,NULL,NULL,NULL,'2025-05-06 10:16:08','2025-05-06 10:16:08'),
(3137,2,'credit',NULL,513000.0000,NULL,'2025-05-06 18:10:00',19,59231,40484,NULL,NULL,NULL,'2025-05-06 11:10:57','2025-05-06 11:10:57'),
(3138,2,'credit',NULL,400000.0000,NULL,'2025-05-06 18:13:09',49,60135,40485,NULL,NULL,NULL,'2025-05-06 11:13:09','2025-05-06 11:13:09'),
(3139,2,'credit',NULL,420000.0000,NULL,'2025-05-06 18:13:00',19,58613,40487,NULL,NULL,NULL,'2025-05-06 11:13:32','2025-05-06 11:13:32'),
(3140,2,'credit',NULL,48000.0000,NULL,'2025-05-06 18:14:00',19,55549,40488,NULL,NULL,NULL,'2025-05-06 11:14:16','2025-05-06 11:14:16'),
(3141,2,'debit',NULL,13347600.0000,NULL,'2025-05-06 19:39:00',1,59643,40495,NULL,NULL,NULL,'2025-05-06 12:39:24','2025-05-06 12:39:24'),
(3142,2,'debit',NULL,720700.0000,NULL,'2025-05-06 19:48:00',1,59587,40496,NULL,NULL,NULL,'2025-05-06 12:48:26','2025-05-06 12:48:26'),
(3143,2,'debit',NULL,4425100.0000,NULL,'2025-05-06 19:49:00',1,59091,40497,NULL,NULL,NULL,'2025-05-06 12:49:56','2025-05-06 12:49:56'),
(3144,2,'debit',NULL,477900.0000,NULL,'2025-05-06 19:52:00',1,59058,40498,NULL,NULL,NULL,'2025-05-06 12:52:05','2025-05-06 12:52:05'),
(3145,2,'debit',NULL,1767900.0000,NULL,'2025-05-06 19:56:00',1,59424,40499,NULL,NULL,NULL,'2025-05-06 12:56:48','2025-05-06 12:56:48'),
(3146,2,'debit',NULL,202600.0000,NULL,'2025-05-06 20:02:00',1,59722,40500,NULL,NULL,NULL,'2025-05-06 13:02:19','2025-05-06 13:02:19'),
(3147,2,'debit',NULL,10129200.0000,NULL,'2025-05-06 20:17:00',1,59646,40503,NULL,NULL,NULL,'2025-05-06 13:18:01','2025-05-06 13:18:01'),
(3148,2,'debit',NULL,260900.0000,NULL,'2025-05-06 20:24:00',1,60144,40506,NULL,NULL,NULL,'2025-05-06 13:24:34','2025-05-06 13:24:34'),
(3149,2,'debit',NULL,328600.0000,NULL,'2025-05-06 21:01:00',1,59987,40507,NULL,NULL,NULL,'2025-05-06 14:01:17','2025-05-06 14:01:17'),
(3150,2,'debit',NULL,355399.0000,NULL,'2025-05-06 21:09:00',1,56023,40509,NULL,NULL,NULL,'2025-05-06 14:09:19','2025-05-06 14:09:19'),
(3151,2,'debit',NULL,8293300.0000,NULL,'2025-05-06 21:15:00',1,59584,40511,NULL,NULL,NULL,'2025-05-06 14:16:01','2025-05-06 14:16:01'),
(3152,2,'debit',NULL,385700.0000,NULL,'2025-05-06 23:44:00',1,59564,40513,NULL,NULL,NULL,'2025-05-06 16:44:18','2025-05-06 16:44:18'),
(3153,2,'debit',NULL,199260.0000,NULL,'2025-05-06 23:47:00',1,59089,40514,NULL,NULL,NULL,'2025-05-06 16:47:39','2025-05-06 16:47:39'),
(3154,2,'debit',NULL,2459800.0000,NULL,'2025-05-06 23:48:00',1,59586,40515,NULL,NULL,NULL,'2025-05-06 16:48:12','2025-05-06 16:48:12'),
(3155,2,'debit',NULL,2250000.0000,NULL,'2025-05-06 23:52:00',1,59609,40516,NULL,NULL,NULL,'2025-05-06 16:52:20','2025-05-06 16:52:20'),
(3156,2,'credit',NULL,98000.0000,NULL,'2025-05-07 14:14:24',6,60180,40535,NULL,NULL,NULL,'2025-05-07 07:14:24','2025-05-31 11:43:11'),
(3157,2,'credit',NULL,280000.0000,NULL,'2025-05-07 14:30:12',49,60186,40538,NULL,NULL,NULL,'2025-05-07 07:30:12','2025-05-07 07:30:12'),
(3158,2,'credit',NULL,6896875.0000,NULL,'2025-05-07 14:51:42',3,59247,40540,NULL,NULL,'2025-05-07 08:38:07','2025-05-07 07:51:42','2025-05-07 08:38:07'),
(3159,2,'credit',NULL,7043125.0000,NULL,'2025-05-07 15:38:07',3,59247,40547,NULL,NULL,'2025-05-09 01:47:08','2025-05-07 08:38:07','2025-05-09 01:47:08'),
(3160,2,'debit',NULL,260000.0000,NULL,'2025-05-07 15:49:00',19,60198,40548,NULL,NULL,NULL,'2025-05-07 08:50:05','2025-05-07 08:50:05'),
(3161,2,'credit',NULL,190000.0000,NULL,'2025-05-07 16:29:23',19,59977,40550,NULL,NULL,NULL,'2025-05-07 09:29:23','2025-05-07 09:29:23'),
(3162,2,'credit',NULL,383000.0000,NULL,'2025-05-07 16:29:31',19,60205,40551,NULL,NULL,NULL,'2025-05-07 09:29:31','2025-05-07 09:29:31'),
(3163,2,'credit',NULL,727000.0000,NULL,'2025-05-07 17:17:54',106,60209,40558,NULL,NULL,NULL,'2025-05-07 10:17:54','2025-05-30 04:47:19'),
(3164,2,'credit',NULL,295000.0000,NULL,'2025-05-07 19:28:21',49,60126,40565,NULL,NULL,NULL,'2025-05-07 12:29:43','2025-05-07 12:29:43'),
(3165,2,'credit',NULL,25000.0000,NULL,'2025-05-08 12:22:53',106,60234,40576,NULL,NULL,NULL,'2025-05-08 05:22:53','2025-05-08 05:22:53'),
(3166,2,'credit',NULL,1000000.0000,NULL,'2025-05-08 16:47:58',106,60252,40595,NULL,NULL,NULL,'2025-05-08 09:47:58','2025-05-08 09:47:58'),
(3167,2,'credit',NULL,44000.0000,NULL,'2025-05-09 13:13:31',6,60288,40616,NULL,NULL,NULL,'2025-05-09 06:13:31','2025-05-09 06:13:31'),
(3168,2,'credit',NULL,2937000.0000,NULL,'2025-05-09 14:36:42',13,60292,40619,NULL,NULL,NULL,'2025-05-09 07:36:42','2025-05-09 07:36:42'),
(3169,2,'debit',NULL,11600000.0000,NULL,'2025-05-09 15:09:00',106,60295,40622,NULL,NULL,NULL,'2025-05-09 08:12:51','2025-05-09 08:12:51'),
(3170,2,'debit',NULL,10370000.0000,NULL,'2025-05-09 15:12:00',106,60296,40623,NULL,NULL,NULL,'2025-05-09 08:15:22','2025-05-09 08:15:22'),
(3171,2,'debit',NULL,1088100.0000,NULL,'2025-05-09 16:03:00',13,60302,40628,NULL,NULL,NULL,'2025-05-09 09:05:47','2025-05-09 09:05:47'),
(3172,2,'debit',NULL,2375000.0000,NULL,'2025-05-09 18:59:00',13,60321,40639,NULL,NULL,NULL,'2025-05-09 12:09:51','2025-05-21 05:49:19'),
(3173,2,'debit',NULL,93000.0000,NULL,'2025-05-10 15:23:00',106,60360,40665,NULL,NULL,NULL,'2025-05-10 08:24:58','2025-05-10 08:24:58'),
(3174,2,'debit',NULL,343000.0000,NULL,'2025-05-10 16:07:00',6,60364,40667,NULL,NULL,NULL,'2025-05-10 09:08:10','2025-05-10 09:08:10'),
(3175,2,'credit',NULL,611000.0000,NULL,'2025-05-10 16:41:10',3,60299,40670,NULL,NULL,NULL,'2025-05-10 09:41:10','2025-05-26 13:58:55'),
(3176,2,'credit',NULL,200000.0000,NULL,'2025-05-10 16:41:58',6,60311,40671,NULL,NULL,NULL,'2025-05-10 09:41:58','2025-05-31 02:58:35'),
(3177,2,'debit',NULL,6000000.0000,NULL,'2025-05-10 17:53:00',49,60373,40675,NULL,NULL,NULL,'2025-05-10 10:58:34','2025-05-10 10:58:34'),
(3178,2,'credit',NULL,1350000.0000,NULL,'2025-05-11 13:11:32',13,60389,40688,NULL,NULL,NULL,'2025-05-11 06:11:32','2025-05-11 06:11:32'),
(3179,2,'credit',NULL,200000.0000,NULL,'2025-05-11 14:58:46',13,59364,40696,NULL,NULL,NULL,'2025-05-11 07:58:46','2025-08-03 06:57:51'),
(3180,2,'credit',NULL,880000.0000,NULL,'2025-05-11 16:20:08',13,60401,40703,NULL,NULL,NULL,'2025-05-11 09:20:08','2025-05-29 14:48:34'),
(3181,2,'credit',NULL,2985000.0000,NULL,'2025-05-13 12:59:43',2,60491,40748,NULL,NULL,NULL,'2025-05-13 05:59:43','2025-11-12 08:39:18'),
(3182,2,'credit',NULL,285000.0000,NULL,'2025-05-13 13:40:02',19,60494,40752,NULL,NULL,NULL,'2025-05-13 06:40:02','2025-05-13 06:40:02'),
(3183,2,'credit',NULL,150000.0000,NULL,'2025-05-13 14:33:34',2,60503,40760,NULL,NULL,NULL,'2025-05-13 07:33:34','2025-05-13 07:33:34'),
(3184,2,'credit',NULL,200000.0000,NULL,'2025-05-13 15:23:11',19,60496,40765,NULL,NULL,NULL,'2025-05-13 08:23:11','2025-06-10 04:30:33'),
(3185,2,'debit',NULL,275000.0000,NULL,'2025-05-13 18:31:00',19,60530,40777,NULL,NULL,NULL,'2025-05-13 11:34:38','2025-05-13 11:34:38'),
(3186,2,'credit',NULL,6750625.0000,NULL,'2025-05-13 18:50:17',3,59247,40778,NULL,NULL,NULL,'2025-05-13 11:50:17','2025-05-26 14:02:17'),
(3187,2,'credit',NULL,146250.0000,NULL,'2025-05-13 18:50:17',3,59247,40779,NULL,NULL,NULL,'2025-05-13 11:50:17','2025-05-26 14:02:17'),
(3188,2,'debit',NULL,250000.0000,NULL,'2025-05-13 20:57:00',3,60547,40792,NULL,NULL,NULL,'2025-05-13 14:00:11','2025-05-13 14:00:11'),
(3189,2,'credit',NULL,36000.0000,NULL,'2025-05-13 22:08:55',3,60552,40797,NULL,NULL,NULL,'2025-05-13 15:09:16','2025-05-13 15:09:16'),
(3190,2,'credit',NULL,165000.0000,NULL,'2025-05-14 17:46:15',106,60580,40817,NULL,NULL,NULL,'2025-05-14 10:46:15','2025-05-14 10:46:15'),
(3191,2,'credit',NULL,588000.0000,NULL,'2025-05-14 18:07:04',106,60582,40818,NULL,NULL,NULL,'2025-05-14 11:07:04','2025-05-26 13:50:19'),
(3192,2,'debit',NULL,250000.0000,NULL,'2025-05-14 20:55:00',19,60593,40832,NULL,NULL,NULL,'2025-05-14 13:56:23','2025-05-14 13:56:23'),
(3193,2,'credit',NULL,225000.0000,NULL,'2025-05-15 14:51:10',2,60619,40859,NULL,NULL,NULL,'2025-05-15 07:51:10','2025-05-15 07:51:10'),
(3194,2,'credit',NULL,2000.0000,NULL,'2025-05-15 15:04:38',2,60621,40860,NULL,NULL,NULL,'2025-05-15 08:04:38','2025-05-15 08:04:38'),
(3195,2,'debit',NULL,230000.0000,NULL,'2025-05-15 15:04:00',13,60623,40862,NULL,NULL,NULL,'2025-05-15 08:15:11','2025-05-15 08:15:11'),
(3196,2,'credit',NULL,168000.0000,NULL,'2025-05-15 15:36:22',6,60626,40863,NULL,NULL,NULL,'2025-05-15 09:06:52','2025-05-31 11:52:28'),
(3197,2,'credit',NULL,40000.0000,NULL,'2025-05-15 16:39:47',49,60490,40866,NULL,NULL,NULL,'2025-05-15 09:39:48','2025-05-15 11:09:56'),
(3198,2,'credit',NULL,180000.0000,NULL,'2025-05-15 16:42:18',49,60630,40867,NULL,NULL,NULL,'2025-05-15 09:42:18','2025-05-15 09:42:18'),
(3199,2,'credit',NULL,154000.0000,NULL,'2025-05-16 10:25:02',6,60660,40886,NULL,NULL,NULL,'2025-05-16 03:25:02','2025-05-16 03:25:02'),
(3200,2,'credit',NULL,200000.0000,NULL,'2025-05-16 14:35:08',49,60656,40899,NULL,NULL,NULL,'2025-05-16 07:35:08','2025-06-01 12:07:10'),
(3201,2,'debit',NULL,73000.0000,NULL,'2025-05-16 18:20:00',49,60701,40909,NULL,NULL,NULL,'2025-05-16 11:32:28','2025-05-16 11:32:28'),
(3202,2,'credit',NULL,986000.0000,NULL,'2025-05-17 08:30:04',49,60313,40915,NULL,NULL,NULL,'2025-05-17 01:30:04','2025-05-26 11:47:58'),
(3203,2,'credit',NULL,1340500.0000,NULL,'2025-05-17 08:53:38',6,60708,40917,NULL,NULL,NULL,'2025-05-17 01:53:38','2025-05-31 12:15:04'),
(3204,2,'credit',NULL,298000.0000,NULL,'2025-05-17 11:10:20',6,60726,40920,NULL,NULL,NULL,'2025-05-17 04:10:20','2025-05-17 04:10:20'),
(3205,2,'debit',NULL,85000.0000,NULL,'2025-05-17 15:26:00',19,60739,40931,NULL,NULL,NULL,'2025-05-17 08:28:52','2025-05-17 08:28:52'),
(3206,2,'debit',NULL,83000.0000,NULL,'2025-05-17 15:30:00',19,60741,40932,NULL,NULL,NULL,'2025-05-17 08:31:14','2025-05-17 08:31:14'),
(3207,2,'credit',NULL,1213500.0000,NULL,'2025-05-17 16:09:05',6,60708,40935,NULL,NULL,NULL,'2025-05-17 09:09:05','2025-05-31 12:15:04'),
(3208,2,'credit',NULL,370000.0000,NULL,'2025-05-17 19:23:14',19,60765,40947,NULL,NULL,NULL,'2025-05-17 12:23:14','2025-05-17 12:23:14'),
(3209,2,'credit',NULL,350000.0000,NULL,'2025-05-17 21:16:14',19,60771,40949,NULL,NULL,NULL,'2025-05-17 14:16:14','2025-05-17 14:16:14'),
(3210,2,'credit',NULL,889000.0000,NULL,'2025-05-18 09:31:00',106,60738,40954,NULL,NULL,NULL,'2025-05-18 02:31:00','2025-05-18 02:32:32'),
(3211,2,'debit',NULL,36579200.0000,NULL,'2025-05-18 10:52:00',1,51833,40958,NULL,NULL,NULL,'2025-05-18 03:52:19','2025-05-18 03:52:19'),
(3212,2,'debit',NULL,59000.0000,NULL,'2025-05-18 11:01:00',1,51578,40959,NULL,NULL,NULL,'2025-05-18 04:01:27','2025-05-18 04:01:27'),
(3213,2,'credit',NULL,2000000.0000,NULL,'2025-05-18 13:13:07',3,60793,40970,NULL,NULL,NULL,'2025-05-18 06:13:07','2025-05-26 12:04:48'),
(3214,2,'debit',NULL,927000.0000,NULL,'2025-05-18 13:19:00',106,60795,40971,NULL,NULL,NULL,'2025-05-18 06:21:15','2025-05-18 06:21:15'),
(3215,2,'debit',NULL,101000.0000,NULL,'2025-05-18 15:16:00',106,60803,40979,NULL,NULL,NULL,'2025-05-18 08:29:08','2025-05-18 08:29:08'),
(3216,2,'debit',NULL,137000.0000,NULL,'2025-05-18 17:04:00',19,60808,40984,NULL,NULL,'2025-05-18 10:06:39','2025-05-18 10:06:01','2025-05-18 10:06:39'),
(3217,2,'debit',NULL,10030000.0000,NULL,'2025-05-19 01:22:00',1,59885,40993,NULL,NULL,NULL,'2025-05-18 18:22:51','2025-05-18 18:22:51'),
(3218,2,'credit',NULL,3000.0000,NULL,'2025-05-19 08:35:38',106,60676,40994,NULL,NULL,NULL,'2025-05-19 01:35:38','2025-05-19 01:44:25'),
(3219,2,'credit',NULL,3641000.0000,NULL,'2025-05-18 16:49:46',106,60676,40983,NULL,NULL,NULL,'2025-05-19 01:44:25','2025-05-19 01:44:25'),
(3220,2,'debit',NULL,1675000.0000,NULL,'2025-05-19 11:42:00',1,60672,41006,NULL,NULL,NULL,'2025-05-19 04:42:37','2025-05-19 04:42:37'),
(3221,2,'debit',NULL,1769400.0000,NULL,'2025-05-19 11:45:00',1,60674,41007,NULL,NULL,NULL,'2025-05-19 04:45:35','2025-05-19 04:45:35'),
(3222,2,'debit',NULL,1078000.0000,NULL,'2025-05-19 11:49:00',1,60304,41008,NULL,NULL,NULL,'2025-05-19 04:49:09','2025-05-19 04:49:09'),
(3223,2,'debit',NULL,1966000.0000,NULL,'2025-05-19 14:08:00',49,60845,41014,NULL,NULL,NULL,'2025-05-19 07:13:27','2025-05-19 07:13:27'),
(3224,2,'debit',NULL,220000.0000,NULL,'2025-05-19 15:52:00',106,60851,41017,NULL,NULL,NULL,'2025-05-19 08:53:36','2025-05-19 08:53:36'),
(3225,2,'credit',NULL,1600000.0000,NULL,'2025-05-19 16:39:14',3,60678,41021,NULL,NULL,NULL,'2025-05-19 09:39:14','2025-09-01 07:11:26'),
(3226,2,'credit',NULL,630000.0000,NULL,'2025-05-19 16:51:01',19,60857,41022,NULL,NULL,NULL,'2025-05-19 09:51:01','2025-05-31 12:13:05'),
(3227,2,'credit',NULL,100000.0000,NULL,'2025-05-19 21:24:23',13,60770,41031,NULL,NULL,NULL,'2025-05-19 14:24:23','2025-05-19 14:24:23'),
(3228,2,'credit',NULL,95000.0000,NULL,'2025-05-19 21:24:49',13,60877,41032,NULL,NULL,NULL,'2025-05-19 14:24:49','2025-05-19 14:24:49'),
(3229,2,'credit',NULL,146000.0000,NULL,'2025-05-20 09:35:02',106,60893,41041,NULL,NULL,NULL,'2025-05-20 02:35:02','2025-05-20 02:35:02'),
(3230,2,'debit',NULL,44800.0000,NULL,'2025-05-20 10:12:00',106,60896,41046,NULL,NULL,NULL,'2025-05-20 03:17:11','2025-05-20 03:17:11'),
(3231,2,'credit',NULL,0.0000,NULL,'2025-05-20 11:10:38',106,60849,41049,NULL,NULL,NULL,'2025-05-20 04:10:38','2025-09-12 07:28:49'),
(3232,2,'debit',NULL,4303000.0000,NULL,'2025-05-20 17:16:00',1,60223,41066,NULL,NULL,NULL,'2025-05-20 10:16:11','2025-05-20 10:16:11'),
(3233,2,'debit',NULL,5930000.0000,NULL,'2025-05-20 17:58:00',1,60858,41070,NULL,NULL,NULL,'2025-05-20 10:58:42','2025-05-20 10:58:42'),
(3234,2,'debit',NULL,4357000.0000,NULL,'2025-05-21 11:58:00',106,60953,41088,NULL,NULL,NULL,'2025-05-21 05:14:30','2025-05-21 06:09:59'),
(3235,2,'debit',NULL,165000.0000,NULL,'2025-05-21 12:52:00',1,60047,41091,NULL,NULL,NULL,'2025-05-21 05:52:20','2025-05-21 05:52:20'),
(3236,2,'debit',NULL,150000.0000,NULL,'2025-05-21 12:53:00',1,60579,41092,NULL,NULL,NULL,'2025-05-21 05:53:25','2025-05-21 05:53:25'),
(3237,2,'debit',NULL,345000.0000,NULL,'2025-05-21 12:53:00',1,60798,41093,NULL,NULL,NULL,'2025-05-21 05:53:52','2025-05-21 05:53:52'),
(3238,2,'debit',NULL,7956000.0000,NULL,'2025-05-21 13:08:00',1,60828,41096,NULL,NULL,'2025-06-02 08:18:57','2025-05-21 06:08:13','2025-06-02 08:18:57'),
(3239,2,'debit',NULL,7731100.0000,NULL,'2025-05-21 13:16:00',1,60174,41099,NULL,NULL,NULL,'2025-05-21 06:16:31','2025-05-21 06:16:31'),
(3240,2,'debit',NULL,2700000.0000,NULL,'2025-05-21 14:13:00',1,60271,41104,NULL,NULL,NULL,'2025-05-21 07:13:48','2025-05-21 07:13:48'),
(3241,2,'debit',NULL,1800000.0000,NULL,'2025-05-21 14:19:00',1,59856,41106,NULL,NULL,NULL,'2025-05-21 07:19:04','2025-05-21 07:19:04'),
(3242,2,'debit',NULL,83000.0000,NULL,'2025-05-21 14:20:00',1,59863,41107,NULL,NULL,NULL,'2025-05-21 07:20:52','2025-05-21 07:20:52'),
(3243,2,'debit',NULL,3713000.0000,NULL,'2025-05-21 14:22:00',1,59959,41108,NULL,NULL,NULL,'2025-05-21 07:22:32','2025-05-21 07:22:32'),
(3244,2,'debit',NULL,1589040.0000,NULL,'2025-05-21 14:22:00',1,58005,41109,NULL,NULL,NULL,'2025-05-21 07:22:54','2025-05-21 07:22:54'),
(3245,2,'debit',NULL,8493000.0000,NULL,'2025-05-21 14:23:00',1,59991,41110,NULL,NULL,NULL,'2025-05-21 07:23:20','2025-05-21 07:23:20'),
(3246,2,'debit',NULL,3346200.0000,NULL,'2025-05-21 14:23:00',1,60301,41111,NULL,NULL,NULL,'2025-05-21 07:23:46','2025-05-21 07:23:46'),
(3247,2,'debit',NULL,730000.0000,NULL,'2025-05-21 14:24:00',1,60612,41112,NULL,NULL,NULL,'2025-05-21 07:24:35','2025-05-21 07:24:35'),
(3248,2,'debit',NULL,414000.0000,NULL,'2025-05-21 14:25:00',1,60434,41113,NULL,NULL,NULL,'2025-05-21 07:25:03','2025-05-21 07:25:03'),
(3249,2,'debit',NULL,2850000.0000,NULL,'2025-05-21 14:25:00',1,60634,41114,NULL,NULL,NULL,'2025-05-21 07:25:24','2025-05-21 07:25:24'),
(3250,2,'debit',NULL,110000.0000,NULL,'2025-05-21 14:25:00',1,60892,41115,NULL,NULL,NULL,'2025-05-21 07:25:58','2025-05-21 07:25:58'),
(3251,2,'debit',NULL,159000.0000,NULL,'2025-05-21 14:26:00',1,60454,41116,NULL,NULL,NULL,'2025-05-21 07:26:27','2025-05-21 07:26:27'),
(3252,2,'debit',NULL,30000.0000,NULL,'2025-05-21 14:30:00',1,60458,41117,NULL,NULL,NULL,'2025-05-21 07:30:59','2025-05-21 07:30:59'),
(3253,2,'debit',NULL,486760.0000,NULL,'2025-05-21 14:31:00',1,56936,41118,NULL,NULL,NULL,'2025-05-21 07:31:11','2025-05-21 07:31:11'),
(3254,2,'debit',NULL,370000.0000,NULL,'2025-05-21 14:31:00',1,60745,41119,NULL,NULL,NULL,'2025-05-21 07:31:36','2025-05-21 07:31:36'),
(3255,2,'credit',NULL,376500.0000,NULL,'2025-05-21 14:33:45',19,60962,41120,NULL,NULL,NULL,'2025-05-21 07:33:45','2025-05-23 01:39:52'),
(3256,2,'credit',NULL,200000.0000,NULL,'2025-05-21 18:00:54',6,60951,41132,NULL,NULL,NULL,'2025-05-21 11:00:54','2025-05-31 02:59:28'),
(3257,2,'credit',NULL,80000.0000,NULL,'2025-05-21 19:11:12',13,60955,41138,NULL,NULL,NULL,'2025-05-21 12:11:12','2025-05-21 12:33:13'),
(3258,2,'credit',NULL,200000.0000,NULL,'2025-05-21 08:42:17',106,60866,41079,NULL,NULL,NULL,'2025-05-21 14:34:54','2025-06-01 11:55:36'),
(3259,2,'credit',NULL,250000.0000,NULL,'2025-05-21 12:44:08',106,60894,41090,NULL,NULL,NULL,'2025-05-22 02:48:47','2025-05-22 02:48:47'),
(3260,2,'credit',NULL,5869000.0000,NULL,'2025-05-22 11:34:08',3,61002,41160,NULL,NULL,NULL,'2025-05-22 04:34:08','2025-05-22 04:34:08'),
(3261,2,'credit',NULL,2011000.0000,NULL,'2025-05-22 17:34:42',19,61027,41176,NULL,NULL,NULL,'2025-05-22 10:34:42','2025-05-31 12:04:21'),
(3262,2,'debit',NULL,710000.0000,NULL,'2025-05-23 15:08:00',2,61076,41217,NULL,NULL,NULL,'2025-05-23 08:13:48','2025-05-23 08:13:48'),
(3263,2,'debit',NULL,215000.0000,NULL,'2025-05-23 15:32:00',2,61081,41221,NULL,NULL,NULL,'2025-05-23 08:33:18','2025-05-23 08:33:18'),
(3264,2,'debit',NULL,508000.0000,NULL,'2025-05-23 15:59:00',6,61083,41222,NULL,NULL,NULL,'2025-05-23 09:00:25','2025-05-23 09:00:25'),
(3265,2,'debit',NULL,250000.0000,NULL,'2025-05-24 10:44:00',106,61118,41250,NULL,NULL,NULL,'2025-05-24 03:45:12','2025-05-24 03:45:12'),
(3266,2,'debit',NULL,173000.0000,NULL,'2025-05-24 16:01:00',13,61145,41264,NULL,NULL,NULL,'2025-05-24 09:01:53','2025-05-24 09:01:53'),
(3267,2,'credit',NULL,155000.0000,NULL,'2025-05-24 21:26:16',13,61154,41270,NULL,NULL,NULL,'2025-05-24 14:26:16','2025-05-24 14:26:16'),
(3268,2,'credit',NULL,154000.0000,NULL,'2025-05-25 13:45:42',106,61194,41283,NULL,NULL,NULL,'2025-05-25 06:45:42','2025-05-25 06:45:42'),
(3269,2,'credit',NULL,1707000.0000,NULL,'2025-05-25 19:12:10',6,61201,41306,NULL,NULL,NULL,'2025-05-25 12:12:10','2025-05-31 12:10:10'),
(3270,2,'credit',NULL,200000.0000,NULL,'2025-05-25 19:33:45',106,61167,41307,NULL,NULL,NULL,'2025-05-25 12:33:45','2025-07-29 06:35:34'),
(3271,2,'credit',NULL,320000.0000,NULL,'2025-05-25 19:46:58',106,61159,41310,NULL,NULL,NULL,'2025-05-25 12:46:58','2025-05-25 13:50:03'),
(3272,2,'credit',NULL,482000.0000,NULL,'2025-05-25 20:50:17',106,61234,41317,NULL,NULL,NULL,'2025-05-25 13:50:17','2025-05-25 13:50:17'),
(3273,2,'credit',NULL,180000.0000,NULL,'2025-05-26 08:54:32',49,61084,41324,NULL,NULL,NULL,'2025-05-26 01:54:32','2025-05-26 13:12:06'),
(3274,2,'credit',NULL,367000.0000,NULL,'2025-05-26 09:29:51',6,61241,41326,NULL,NULL,NULL,'2025-05-26 02:29:51','2025-05-26 02:29:51'),
(3275,2,'credit',NULL,175000.0000,NULL,'2025-05-26 09:31:26',6,60925,41327,NULL,NULL,NULL,'2025-05-26 02:31:26','2025-05-26 02:31:26'),
(3276,2,'credit',NULL,669000.0000,NULL,'2025-05-26 11:20:17',13,61249,41332,NULL,NULL,NULL,'2025-05-26 04:20:17','2025-05-26 13:38:57'),
(3277,2,'credit',NULL,271000.0000,NULL,'2025-05-26 13:25:12',13,61262,41338,NULL,NULL,NULL,'2025-05-26 06:25:12','2025-05-29 07:54:32'),
(3278,2,'credit',NULL,246000.0000,NULL,'2025-05-26 15:13:10',6,61293,41350,NULL,NULL,NULL,'2025-05-26 08:13:10','2025-05-26 08:13:10'),
(3279,2,'debit',NULL,100000.0000,NULL,'2025-05-26 18:12:00',106,61310,41360,NULL,NULL,NULL,'2025-05-26 11:13:47','2025-05-26 11:13:47'),
(3280,2,'credit',NULL,87500.0000,NULL,'2025-05-26 18:48:06',3,61318,41367,NULL,NULL,NULL,'2025-05-26 11:48:06','2025-05-26 11:48:06'),
(3281,2,'credit',NULL,87500.0000,NULL,'2025-05-26 18:48:50',3,61319,41368,NULL,NULL,NULL,'2025-05-26 11:48:50','2025-05-26 11:48:50'),
(3282,2,'credit',NULL,775000.0000,NULL,'2025-05-26 19:04:15',3,61320,41369,NULL,NULL,NULL,'2025-05-26 12:04:15','2025-05-26 12:04:15'),
(3283,2,'credit',NULL,775000.0000,NULL,'2025-05-26 19:04:22',3,61321,41370,NULL,NULL,NULL,'2025-05-26 12:04:22','2025-05-26 12:04:22'),
(3284,2,'debit',NULL,710000.0000,NULL,'2025-05-26 19:09:00',106,61325,41373,NULL,NULL,NULL,'2025-05-26 12:10:40','2025-05-26 12:10:40'),
(3285,2,'credit',NULL,585000.0000,NULL,'2025-05-26 19:52:00',19,61331,41380,NULL,NULL,NULL,'2025-05-26 12:57:52','2025-05-26 12:57:52'),
(3286,2,'credit',NULL,87500.0000,NULL,'2025-05-26 20:39:08',3,61334,41385,NULL,NULL,NULL,'2025-05-26 13:39:08','2025-05-26 13:39:08'),
(3287,2,'credit',NULL,87500.0000,NULL,'2025-05-26 20:39:22',3,61335,41386,NULL,NULL,NULL,'2025-05-26 13:39:22','2025-05-26 13:39:22'),
(3288,2,'credit',NULL,87500.0000,NULL,'2025-05-26 20:50:25',3,61338,41391,NULL,NULL,NULL,'2025-05-26 13:50:25','2025-05-26 13:50:25'),
(3289,2,'credit',NULL,87500.0000,NULL,'2025-05-26 20:50:34',3,61339,41392,NULL,NULL,NULL,'2025-05-26 13:50:34','2025-05-26 13:50:34'),
(3290,2,'credit',NULL,120000.0000,NULL,'2025-05-26 20:58:04',3,61340,41393,NULL,NULL,NULL,'2025-05-26 13:58:04','2025-05-26 13:58:04'),
(3291,2,'credit',NULL,120000.0000,NULL,'2025-05-26 20:58:23',3,61341,41394,NULL,NULL,NULL,'2025-05-26 13:58:23','2025-05-26 13:58:23'),
(3292,2,'credit',NULL,1950000.0000,NULL,'2025-05-26 21:04:29',3,61342,41397,NULL,NULL,NULL,'2025-05-26 14:04:29','2025-05-26 14:04:29'),
(3293,2,'credit',NULL,1950000.0000,NULL,'2025-05-26 21:04:43',3,61343,41398,NULL,NULL,NULL,'2025-05-26 14:04:43','2025-05-26 14:04:43'),
(3294,2,'credit',NULL,1950000.0000,NULL,'2025-05-26 21:04:52',3,61344,41399,NULL,NULL,NULL,'2025-05-26 14:04:52','2025-05-26 14:04:52'),
(3295,2,'credit',NULL,402500.0000,NULL,'2025-05-26 21:40:56',3,61347,41401,NULL,NULL,NULL,'2025-05-26 14:40:56','2025-05-26 14:40:56'),
(3296,2,'credit',NULL,402500.0000,NULL,'2025-05-26 21:41:04',3,61348,41402,NULL,NULL,NULL,'2025-05-26 14:41:04','2025-05-26 14:41:04'),
(3297,2,'credit',NULL,1000000.0000,NULL,'2025-05-26 21:42:49',3,61349,41403,NULL,NULL,NULL,'2025-05-26 14:42:49','2025-05-26 14:42:49'),
(3298,2,'debit',NULL,3402256.0000,NULL,'2025-05-27 00:57:00',1,61136,41404,NULL,NULL,NULL,'2025-05-26 17:57:52','2025-05-26 17:57:52'),
(3299,2,'debit',NULL,11045142.0000,NULL,'2025-05-27 01:04:00',1,61107,41405,NULL,NULL,NULL,'2025-05-26 18:04:39','2025-06-04 12:20:16'),
(3300,2,'credit',NULL,2000000.0000,NULL,'2025-05-27 12:17:17',49,61362,41412,NULL,NULL,NULL,'2025-05-27 05:17:17','2025-06-19 12:57:11'),
(3301,2,'credit',NULL,7125000.0000,NULL,'2025-05-27 12:50:40',13,58704,41414,NULL,NULL,NULL,'2025-05-27 05:50:40','2025-05-27 05:50:40'),
(3302,2,'debit',NULL,1736000.0000,NULL,'2025-05-27 13:35:00',1,53682,41417,NULL,NULL,NULL,'2025-05-27 06:35:38','2025-05-27 06:35:38'),
(3303,2,'debit',NULL,645000.0000,NULL,'2025-05-27 13:36:00',1,58615,41418,NULL,NULL,NULL,'2025-05-27 06:36:30','2025-05-27 06:36:30'),
(3304,2,'debit',NULL,3658200.0000,NULL,'2025-05-27 13:39:00',1,60597,41420,NULL,NULL,NULL,'2025-05-27 06:39:30','2025-05-27 06:39:30'),
(3305,2,'debit',NULL,559000.0000,NULL,'2025-05-27 13:42:00',1,60627,41421,NULL,NULL,NULL,'2025-05-27 06:42:21','2025-05-27 06:42:21'),
(3306,2,'debit',NULL,482000.0000,NULL,'2025-05-27 13:42:00',1,59862,41422,NULL,NULL,NULL,'2025-05-27 06:42:34','2025-05-27 06:42:34'),
(3307,2,'debit',NULL,699000.0000,NULL,'2025-05-27 13:42:00',1,60074,41423,NULL,NULL,NULL,'2025-05-27 06:42:43','2025-05-27 06:42:43'),
(3308,2,'debit',NULL,315000.0000,NULL,'2025-05-27 13:42:00',1,60611,41424,NULL,NULL,NULL,'2025-05-27 06:42:54','2025-05-27 06:42:54'),
(3309,2,'debit',NULL,173000.0000,NULL,'2025-05-27 13:43:00',1,60809,41425,NULL,NULL,NULL,'2025-05-27 06:43:17','2025-05-27 06:43:17'),
(3310,2,'debit',NULL,33900.0000,NULL,'2025-05-27 13:44:00',1,60915,41426,NULL,NULL,NULL,'2025-05-27 06:44:25','2025-05-27 06:44:25'),
(3311,2,'debit',NULL,5285000.0000,NULL,'2025-05-27 13:44:00',1,61001,41427,NULL,NULL,NULL,'2025-05-27 06:44:34','2025-05-27 06:44:34'),
(3312,2,'debit',NULL,864000.0000,NULL,'2025-05-27 13:45:00',1,61014,41428,NULL,NULL,NULL,'2025-05-27 06:45:02','2025-05-27 06:45:02'),
(3313,2,'debit',NULL,190000.0000,NULL,'2025-05-27 13:45:00',1,61086,41429,NULL,NULL,NULL,'2025-05-27 06:45:26','2025-05-27 06:45:26'),
(3314,2,'debit',NULL,1206352.0000,NULL,'2025-05-27 13:45:00',1,60818,41430,NULL,NULL,NULL,'2025-05-27 06:45:59','2025-05-27 06:45:59'),
(3315,2,'credit',NULL,1000000.0000,NULL,'2025-05-26 11:53:37',13,61164,41333,NULL,NULL,NULL,'2025-05-27 07:43:30','2025-05-29 07:47:02'),
(3316,2,'credit',NULL,2398000.0000,NULL,'2025-05-27 14:43:30',3,61164,41433,NULL,NULL,NULL,'2025-05-27 07:43:30','2025-05-29 07:47:02'),
(3317,2,'debit',NULL,880000.0000,NULL,'2025-05-27 15:10:00',106,61379,41434,NULL,NULL,NULL,'2025-05-27 08:11:14','2025-05-27 08:11:14'),
(3318,2,'debit',NULL,3044916.0000,NULL,'2025-05-27 22:47:00',1,61211,41458,NULL,NULL,NULL,'2025-05-27 15:47:52','2025-05-27 15:47:52'),
(3319,2,'debit',NULL,12016800.0000,NULL,'2025-05-28 08:32:00',13,61421,41459,NULL,NULL,NULL,'2025-05-28 01:34:26','2025-05-28 01:34:26'),
(3320,2,'credit',NULL,160000.0000,NULL,'2025-05-28 10:03:07',13,61251,41465,NULL,NULL,NULL,'2025-05-28 03:03:07','2025-05-28 03:03:07'),
(3321,2,'credit',NULL,350000.0000,NULL,'2025-05-28 11:38:34',13,61358,41469,NULL,NULL,NULL,'2025-05-28 04:38:34','2025-05-28 04:38:34'),
(3322,2,'credit',NULL,102000.0000,NULL,'2025-05-28 11:38:53',13,61429,41470,NULL,NULL,NULL,'2025-05-28 04:38:53','2025-05-28 04:38:53'),
(3323,2,'credit',NULL,195000.0000,NULL,'2025-05-28 12:18:49',13,61433,41474,NULL,NULL,NULL,'2025-05-28 05:18:49','2025-05-28 05:18:49'),
(3324,2,'credit',NULL,5850000.0000,NULL,'2025-05-28 13:32:04',106,61436,41477,NULL,NULL,NULL,'2025-05-28 06:32:04','2025-05-28 06:32:04'),
(3325,2,'debit',NULL,730000.0000,NULL,'2025-05-28 14:14:00',106,61440,41480,NULL,NULL,NULL,'2025-05-28 07:19:37','2025-05-28 07:19:37'),
(3326,2,'credit',NULL,8677500.0000,NULL,'2025-05-28 15:57:26',13,61446,41486,NULL,NULL,NULL,'2025-05-28 08:57:26','2025-06-10 11:53:44'),
(3327,2,'credit',NULL,559000.0000,NULL,'2025-05-28 17:58:13',106,61463,41492,NULL,NULL,NULL,'2025-05-28 10:58:14','2025-05-28 11:13:05'),
(3328,2,'debit',NULL,730000.0000,NULL,'2025-05-28 18:28:00',106,61467,41494,NULL,NULL,NULL,'2025-05-28 11:32:13','2025-05-28 11:32:13'),
(3329,2,'credit',NULL,90000.0000,NULL,'2025-05-28 18:34:28',106,61468,41495,NULL,NULL,NULL,'2025-05-28 11:34:28','2025-05-28 11:34:28'),
(3330,2,'credit',NULL,760000.0000,NULL,'2025-05-28 18:40:27',106,61462,41496,NULL,NULL,NULL,'2025-05-28 11:40:27','2025-05-28 11:40:27'),
(3331,2,'credit',NULL,137000.0000,NULL,'2025-05-28 20:20:00',19,61474,41500,NULL,NULL,NULL,'2025-05-28 13:25:05','2025-05-28 13:25:05'),
(3332,2,'credit',NULL,92000.0000,NULL,'2025-05-28 21:00:49',19,61477,41501,NULL,NULL,NULL,'2025-05-28 14:00:49','2025-05-28 14:00:49'),
(3333,2,'debit',NULL,5016287.0000,NULL,'2025-05-29 11:12:00',13,61492,41506,NULL,NULL,NULL,'2025-05-29 04:13:51','2025-05-29 04:13:51'),
(3334,2,'debit',NULL,9973800.0000,NULL,'2025-05-29 11:14:00',13,61493,41507,NULL,NULL,NULL,'2025-05-29 04:19:09','2025-05-29 04:19:09'),
(3335,2,'debit',NULL,2457000.0000,NULL,'2025-05-29 11:44:00',13,61496,41509,NULL,NULL,'2025-06-23 09:36:50','2025-05-29 04:45:58','2025-06-23 09:36:50'),
(3336,2,'debit',NULL,3259220.0000,NULL,'2025-05-29 11:46:00',13,61497,41510,NULL,NULL,NULL,'2025-05-29 04:49:28','2025-06-19 17:07:13'),
(3337,2,'debit',NULL,2934000.0000,NULL,'2025-05-29 11:49:00',13,61498,41511,NULL,NULL,NULL,'2025-05-29 04:51:11','2025-05-29 04:51:11'),
(3338,2,'debit',NULL,13007200.0000,NULL,'2025-05-29 11:50:00',49,61499,41512,NULL,NULL,NULL,'2025-05-29 04:57:47','2025-05-29 04:57:47'),
(3339,2,'debit',NULL,1177000.0000,NULL,'2025-05-29 12:09:00',49,61500,41513,NULL,NULL,NULL,'2025-05-29 05:12:48','2025-05-29 05:12:48'),
(3340,2,'credit',NULL,120000.0000,NULL,'2025-05-29 12:55:47',13,61504,41514,NULL,NULL,NULL,'2025-05-29 05:55:47','2025-05-29 05:55:47'),
(3341,2,'credit',NULL,240000.0000,NULL,'2025-05-29 14:18:38',19,61511,41518,NULL,NULL,NULL,'2025-05-29 07:18:38','2025-05-29 07:18:38'),
(3342,2,'debit',NULL,272000.0000,NULL,'2025-05-29 14:27:00',3,61513,41519,NULL,NULL,NULL,'2025-05-29 07:29:19','2025-05-29 07:29:19'),
(3343,2,'credit',NULL,262500.0000,NULL,'2025-05-29 14:47:18',3,61516,41520,NULL,NULL,NULL,'2025-05-29 07:47:18','2025-05-29 07:47:18'),
(3344,2,'credit',NULL,262500.0000,NULL,'2025-05-29 14:47:26',3,61517,41521,NULL,NULL,NULL,'2025-05-29 07:47:26','2025-05-29 07:47:26'),
(3345,2,'credit',NULL,80000.0000,NULL,'2025-05-29 14:54:50',3,61520,41525,NULL,NULL,NULL,'2025-05-29 07:54:50','2025-05-29 07:54:50'),
(3346,2,'credit',NULL,80000.0000,NULL,'2025-05-29 14:55:04',3,61521,41526,NULL,NULL,NULL,'2025-05-29 07:55:04','2025-05-29 07:55:04'),
(3347,2,'credit',NULL,350000.0000,NULL,'2025-05-29 16:51:20',3,61359,41538,NULL,NULL,NULL,'2025-05-29 09:59:53','2025-05-29 09:59:53'),
(3348,2,'credit',NULL,250000.0000,NULL,'2025-05-29 19:25:56',19,61503,41540,NULL,NULL,NULL,'2025-05-29 12:25:56','2025-05-29 12:25:56'),
(3349,2,'credit',NULL,320000.0000,NULL,'2025-05-29 19:26:45',19,61535,41541,NULL,NULL,NULL,'2025-05-29 12:26:45','2025-05-29 12:26:45'),
(3350,2,'credit',NULL,50000.0000,NULL,'2025-05-29 21:48:41',3,61543,41551,NULL,NULL,NULL,'2025-05-29 14:48:41','2025-05-29 14:48:41'),
(3351,2,'credit',NULL,50000.0000,NULL,'2025-05-29 21:48:46',3,61544,41552,NULL,NULL,NULL,'2025-05-29 14:48:46','2025-05-29 14:48:46'),
(3352,2,'credit',NULL,80000.0000,NULL,'2025-05-30 11:47:25',3,61557,41562,NULL,NULL,NULL,'2025-05-30 04:47:25','2025-05-30 04:47:25'),
(3353,2,'credit',NULL,80000.0000,NULL,'2025-05-30 11:47:31',3,61558,41563,NULL,NULL,NULL,'2025-05-30 04:47:31','2025-05-30 04:47:31'),
(3354,2,'credit',NULL,1350000.0000,NULL,'2025-05-30 14:34:52',19,61575,41570,NULL,NULL,NULL,'2025-05-30 07:34:52','2025-05-30 07:34:52'),
(3355,2,'credit',NULL,4795000.0000,NULL,'2025-05-30 14:51:48',19,61576,41571,NULL,NULL,NULL,'2025-05-30 07:51:48','2025-05-30 07:51:48'),
(3356,2,'credit',NULL,275000.0000,NULL,'2025-05-30 15:50:14',49,61587,41576,NULL,NULL,NULL,'2025-05-30 08:50:14','2025-05-30 08:50:14'),
(3357,2,'credit',NULL,586000.0000,NULL,'2025-05-30 17:00:28',3,61590,41580,NULL,NULL,NULL,'2025-05-30 10:00:28','2025-05-30 10:00:28'),
(3358,2,'credit',NULL,171000.0000,NULL,'2025-05-30 20:06:48',13,61603,41589,NULL,NULL,NULL,'2025-05-30 13:06:48','2025-05-30 13:06:48'),
(3359,2,'credit',NULL,275000.0000,NULL,'2025-05-30 21:26:17',13,61607,41592,NULL,NULL,NULL,'2025-05-30 14:26:17','2025-05-30 14:26:17'),
(3360,2,'debit',NULL,730000.0000,NULL,'2025-05-31 09:22:00',106,61612,41595,NULL,NULL,NULL,'2025-05-31 02:23:16','2025-05-31 02:23:16'),
(3361,2,'credit',NULL,740000.0000,NULL,'2025-05-31 12:10:36',6,61623,41605,NULL,NULL,NULL,'2025-05-31 05:10:36','2025-05-31 05:10:36'),
(3362,2,'debit',NULL,925800.0000,NULL,'2025-05-31 12:27:00',13,61626,41606,NULL,NULL,NULL,'2025-05-31 05:29:47','2025-05-31 05:29:47'),
(3363,2,'debit',NULL,54000.0000,NULL,'2025-05-31 13:14:00',49,61630,41614,NULL,NULL,NULL,'2025-05-31 06:16:17','2025-05-31 06:16:17'),
(3364,2,'debit',NULL,59222.0000,NULL,'2025-05-31 13:40:00',19,61632,41617,NULL,NULL,NULL,'2025-05-31 06:42:48','2025-05-31 06:42:48'),
(3365,2,'credit',NULL,100000.0000,NULL,'2025-05-31 14:30:37',19,61635,41620,NULL,NULL,NULL,'2025-05-31 07:30:37','2025-05-31 07:30:37'),
(3366,2,'credit',NULL,80000.0000,NULL,'2025-05-31 15:07:00',6,61475,41622,NULL,NULL,NULL,'2025-05-31 08:07:00','2025-05-31 08:07:00'),
(3367,2,'credit',NULL,92500.0000,NULL,'2025-05-31 16:44:14',6,61645,41626,NULL,NULL,NULL,'2025-05-31 09:44:14','2025-05-31 09:44:14'),
(3368,2,'credit',NULL,106000.0000,NULL,'2025-05-31 16:53:08',106,61616,41627,NULL,NULL,NULL,'2025-05-31 09:53:08','2025-05-31 13:32:21'),
(3369,2,'credit',NULL,80000.0000,NULL,'2025-05-31 17:12:13',106,61625,41630,NULL,NULL,NULL,'2025-05-31 10:12:13','2025-05-31 10:12:13'),
(3370,2,'credit',NULL,395000.0000,NULL,'2025-05-31 17:12:32',106,61647,41631,NULL,NULL,NULL,'2025-05-31 10:12:32','2025-05-31 10:12:32'),
(3371,2,'credit',NULL,247000.0000,NULL,'2025-05-31 18:10:42',49,61650,41638,NULL,NULL,NULL,'2025-05-31 11:10:42','2025-05-31 11:10:42'),
(3372,2,'credit',NULL,40000.0000,NULL,'2025-05-31 18:44:02',19,61656,41641,NULL,NULL,NULL,'2025-05-31 11:44:02','2025-05-31 11:44:02'),
(3373,2,'credit',NULL,75000.0000,NULL,'2025-05-31 18:47:38',19,61659,41644,NULL,NULL,NULL,'2025-05-31 11:47:38','2025-05-31 11:47:38'),
(3374,2,'credit',NULL,20000.0000,NULL,'2025-05-31 18:52:51',19,61661,41646,NULL,NULL,NULL,'2025-05-31 11:52:51','2025-05-31 11:52:51'),
(3375,2,'credit',NULL,20000.0000,NULL,'2025-05-31 18:53:16',19,61662,41648,NULL,NULL,NULL,'2025-05-31 11:53:16','2025-05-31 11:57:00'),
(3376,2,'credit',NULL,455000.0000,NULL,'2025-05-31 19:02:28',19,61663,41649,NULL,NULL,NULL,'2025-05-31 12:02:28','2025-05-31 12:02:28'),
(3377,2,'credit',NULL,455000.0000,NULL,'2025-05-31 19:04:02',19,61664,41650,NULL,NULL,NULL,'2025-05-31 12:04:02','2025-05-31 12:04:02'),
(3378,2,'credit',NULL,262500.0000,NULL,'2025-05-31 19:08:32',19,61665,41651,NULL,NULL,NULL,'2025-05-31 12:08:32','2025-05-31 12:08:32'),
(3379,2,'credit',NULL,262500.0000,NULL,'2025-05-31 19:09:27',19,61666,41652,NULL,NULL,NULL,'2025-05-31 12:09:27','2025-05-31 12:09:27'),
(3380,2,'credit',NULL,87500.0000,NULL,'2025-05-31 19:12:12',19,61667,41654,NULL,NULL,NULL,'2025-05-31 12:12:12','2025-05-31 12:12:12'),
(3381,2,'credit',NULL,87500.0000,NULL,'2025-05-31 19:12:55',19,61668,41655,NULL,NULL,NULL,'2025-05-31 12:12:55','2025-05-31 12:12:55'),
(3382,2,'credit',NULL,100000.0000,NULL,'2025-05-31 19:14:55',19,61669,41656,NULL,NULL,NULL,'2025-05-31 12:14:55','2025-05-31 12:14:55'),
(3383,2,'credit',NULL,500000.0000,NULL,'2025-05-31 20:00:58',49,59427,41665,NULL,NULL,NULL,'2025-05-31 13:00:58','2025-05-31 13:00:58'),
(3384,2,'credit',NULL,56000.0000,NULL,'2025-05-31 20:32:30',3,61680,41672,NULL,NULL,NULL,'2025-05-31 13:32:30','2025-05-31 13:32:30'),
(3385,2,'credit',NULL,15000.0000,NULL,'2025-06-01 09:41:37',49,61509,41677,NULL,NULL,NULL,'2025-06-01 02:41:37','2025-06-01 02:41:37'),
(3386,2,'credit',NULL,390000.0000,NULL,'2025-06-01 09:41:46',49,61683,41678,NULL,NULL,NULL,'2025-06-01 02:41:46','2025-06-01 02:41:46'),
(3387,2,'credit',NULL,200000.0000,NULL,'2025-06-01 12:20:50',49,61554,41684,NULL,NULL,NULL,'2025-06-01 05:20:50','2025-06-18 09:51:37'),
(3388,2,'credit',NULL,140000.0000,NULL,'2025-06-01 15:17:49',19,61692,41688,NULL,NULL,NULL,'2025-06-01 08:17:49','2025-06-01 08:17:49'),
(3389,2,'credit',NULL,155000.0000,NULL,'2025-06-01 15:53:56',19,61695,41691,NULL,NULL,NULL,'2025-06-01 08:53:56','2025-06-01 08:53:56'),
(3390,2,'credit',NULL,25000.0000,NULL,'2025-06-01 21:04:52',6,61714,41715,NULL,NULL,NULL,'2025-06-01 14:04:52','2025-06-01 14:04:52'),
(3391,2,'credit',NULL,80000.0000,NULL,'2025-06-02 08:25:40',19,61437,41716,NULL,NULL,NULL,'2025-06-02 01:25:40','2025-06-02 01:25:40'),
(3392,2,'credit',NULL,495000.0000,NULL,'2025-06-02 08:26:14',19,61715,41717,NULL,NULL,NULL,'2025-06-02 01:26:14','2025-06-30 09:10:32'),
(3393,2,'credit',NULL,26000.0000,NULL,'2025-06-02 08:50:33',19,61716,41718,NULL,NULL,NULL,'2025-06-02 01:50:33','2025-06-30 09:10:18'),
(3394,2,'credit',NULL,195000.0000,NULL,'2025-06-02 08:52:40',19,61491,41719,NULL,NULL,NULL,'2025-06-02 01:52:40','2025-06-02 01:52:40'),
(3395,2,'credit',NULL,154000.0000,NULL,'2025-06-02 09:39:17',106,61718,41721,NULL,NULL,NULL,'2025-06-02 02:39:17','2025-06-29 09:24:50'),
(3396,2,'debit',NULL,8316000.0000,NULL,'2025-06-02 14:20:00',13,61737,41730,NULL,NULL,NULL,'2025-06-02 07:24:47','2025-06-02 07:24:47'),
(3397,2,'debit',NULL,730000.0000,NULL,'2025-06-02 15:07:00',106,61740,41734,NULL,NULL,NULL,'2025-06-02 08:08:50','2025-06-02 08:08:50'),
(3398,2,'debit',NULL,2400000.0000,NULL,'2025-06-02 16:12:00',19,61746,41738,NULL,NULL,NULL,'2025-06-02 09:13:24','2025-06-02 09:13:24'),
(3399,2,'debit',NULL,3443408.0000,NULL,'2025-06-02 19:18:00',13,61757,41754,NULL,NULL,NULL,'2025-06-02 12:19:24','2025-06-17 17:39:32'),
(3400,2,'credit',NULL,295000.0000,NULL,'2025-06-02 19:33:24',49,61753,41757,NULL,NULL,NULL,'2025-06-02 12:33:24','2025-06-03 02:00:51'),
(3401,2,'debit',NULL,11395600.0000,NULL,'2025-06-02 19:19:00',13,61762,41758,NULL,NULL,NULL,'2025-06-02 12:44:42','2025-06-02 12:44:42'),
(3402,2,'credit',NULL,55000.0000,NULL,'2025-06-02 21:02:08',49,61764,41761,NULL,NULL,NULL,'2025-06-02 14:02:08','2025-06-02 14:02:08'),
(3403,2,'debit',NULL,3984000.0000,NULL,'2025-06-02 23:47:00',1,61413,41764,NULL,NULL,NULL,'2025-06-02 16:47:52','2025-06-02 16:47:52'),
(3404,2,'credit',NULL,788000.0000,NULL,'2025-06-03 12:22:44',106,61787,41778,NULL,NULL,NULL,'2025-06-03 05:22:44','2025-06-03 05:37:50'),
(3405,2,'credit',NULL,320000.0000,NULL,'2025-06-03 14:11:34',106,61682,41783,NULL,NULL,NULL,'2025-06-03 07:11:34','2025-06-03 07:11:34'),
(3406,2,'credit',NULL,77000.0000,NULL,'2025-06-03 14:11:54',106,61795,41784,NULL,NULL,NULL,'2025-06-03 07:11:54','2025-06-03 07:11:54'),
(3407,2,'credit',NULL,195000.0000,NULL,'2025-06-03 19:24:24',9,61777,41803,NULL,NULL,NULL,'2025-06-03 12:24:24','2025-06-03 12:24:24'),
(3408,2,'credit',NULL,35000.0000,NULL,'2025-06-03 19:28:43',9,61816,41804,NULL,NULL,NULL,'2025-06-03 12:28:43','2025-06-03 12:28:43'),
(3409,2,'credit',NULL,220000.0000,NULL,'2025-06-04 12:41:25',19,61845,41826,NULL,NULL,NULL,'2025-06-04 05:41:25','2025-06-04 07:42:56'),
(3410,2,'credit',NULL,170000.0000,NULL,'2025-06-04 14:34:44',19,61845,41854,NULL,NULL,NULL,'2025-06-04 07:34:44','2025-06-04 07:42:56'),
(3411,2,'debit',NULL,513000.0000,NULL,'2025-06-04 14:38:00',106,61858,41856,NULL,NULL,NULL,'2025-06-04 08:00:33','2025-06-04 08:00:33'),
(3412,2,'debit',NULL,797000.0000,NULL,'2025-06-04 15:06:00',19,61860,41858,NULL,NULL,NULL,'2025-06-04 08:07:29','2025-06-04 08:07:29'),
(3413,2,'credit',NULL,1350000.0000,NULL,'2025-06-04 17:05:24',19,61869,41863,NULL,NULL,NULL,'2025-06-04 10:05:24','2025-06-30 06:03:05'),
(3414,2,'debit',NULL,9227000.0000,NULL,'2025-06-04 19:25:00',1,61460,41877,NULL,NULL,NULL,'2025-06-04 12:25:08','2025-06-04 12:25:08'),
(3415,2,'debit',NULL,453000.0000,NULL,'2025-06-05 08:31:00',106,61899,41890,NULL,NULL,NULL,'2025-06-05 01:36:37','2025-06-05 01:36:37'),
(3416,2,'debit',NULL,900000.0000,NULL,'2025-06-05 10:46:00',49,61906,41898,NULL,NULL,NULL,'2025-06-05 03:49:07','2025-06-05 03:49:07'),
(3417,2,'credit',NULL,2227100.0000,NULL,'2025-06-05 13:57:45',19,61927,41916,NULL,NULL,NULL,'2025-06-05 06:57:45','2025-06-05 07:19:06'),
(3418,2,'debit',NULL,243600.0000,NULL,'2025-06-05 14:25:00',49,61930,41919,NULL,NULL,NULL,'2025-06-05 07:26:08','2025-06-05 07:26:08'),
(3419,2,'credit',NULL,1424000.0000,NULL,'2025-06-05 15:09:35',19,61937,41923,NULL,NULL,NULL,'2025-06-05 08:09:35','2025-06-05 08:09:35'),
(3420,2,'credit',NULL,396000.0000,NULL,'2025-06-05 15:25:38',19,61939,41927,NULL,NULL,NULL,'2025-06-05 08:25:38','2025-06-05 08:25:38'),
(3421,2,'debit',NULL,207000.0000,NULL,'2025-06-05 15:48:00',3,61941,41930,NULL,NULL,NULL,'2025-06-05 08:49:55','2025-06-05 08:49:55'),
(3422,2,'credit',NULL,350000.0000,NULL,'2025-06-05 16:35:21',49,61687,41932,NULL,NULL,NULL,'2025-06-05 09:35:21','2025-06-05 09:35:21'),
(3423,2,'debit',NULL,402000.0000,NULL,'2025-06-05 16:39:00',13,61945,41935,NULL,NULL,NULL,'2025-06-05 09:40:02','2025-06-05 09:40:02'),
(3424,2,'credit',NULL,1500000.0000,NULL,'2025-06-07 10:01:05',106,61953,41941,NULL,NULL,NULL,'2025-06-07 03:01:05','2025-06-10 06:17:44'),
(3425,2,'debit',NULL,2400000.0000,NULL,'2025-06-07 13:00:00',106,61972,41969,NULL,NULL,NULL,'2025-06-07 06:01:38','2025-06-07 06:01:38'),
(3426,2,'credit',NULL,120000.0000,NULL,'2025-06-07 14:06:42',13,61873,41971,NULL,NULL,NULL,'2025-06-07 07:06:42','2025-06-07 08:02:05'),
(3427,2,'credit',NULL,500000.0000,NULL,'2025-06-07 14:07:27',49,61974,41972,NULL,NULL,NULL,'2025-06-07 07:07:27','2025-06-29 07:53:56'),
(3428,2,'credit',NULL,700000.0000,NULL,'2025-06-07 14:34:30',49,61872,41976,NULL,NULL,NULL,'2025-06-07 07:34:30','2025-06-16 09:31:00'),
(3429,2,'debit',NULL,1590500.0000,NULL,'2025-06-07 14:37:00',13,61979,41977,NULL,NULL,'2025-06-07 08:04:08','2025-06-07 07:44:37','2025-06-07 08:04:08'),
(3430,2,'debit',NULL,8722000.0000,NULL,'2025-06-07 14:45:00',13,61980,41978,NULL,NULL,'2025-06-07 08:04:13','2025-06-07 07:47:57','2025-06-07 08:04:13'),
(3431,2,'debit',NULL,2464600.0000,NULL,'2025-06-07 14:48:00',13,61981,41979,NULL,NULL,'2025-06-07 08:04:17','2025-06-07 07:50:26','2025-06-07 08:04:17'),
(3432,2,'credit',NULL,20000.0000,NULL,'2025-06-07 15:01:50',49,61982,41980,NULL,NULL,NULL,'2025-06-07 08:01:50','2025-06-07 08:01:50'),
(3433,2,'debit',NULL,2650000.0000,NULL,'2025-06-07 16:26:00',106,61987,41984,NULL,NULL,NULL,'2025-06-07 09:28:42','2025-06-07 09:28:42'),
(3434,2,'debit',NULL,559000.0000,NULL,'2025-06-07 16:29:00',106,61988,41985,NULL,NULL,NULL,'2025-06-07 09:29:49','2025-06-07 09:29:49'),
(3435,2,'debit',NULL,265000.0000,NULL,'2025-06-07 18:12:00',13,61996,41991,NULL,NULL,NULL,'2025-06-07 11:12:58','2025-06-07 11:12:58'),
(3436,2,'debit',NULL,442000.0000,NULL,'2025-06-08 09:33:00',13,62008,42002,NULL,NULL,NULL,'2025-06-08 02:36:01','2025-06-08 02:36:01'),
(3437,2,'credit',NULL,383000.0000,NULL,'2025-06-08 12:58:00',19,62017,42010,NULL,NULL,NULL,'2025-06-08 05:58:39','2025-06-08 05:58:39'),
(3438,2,'credit',NULL,160000.0000,NULL,'2025-06-08 21:52:15',106,62024,42031,NULL,NULL,NULL,'2025-06-08 14:52:15','2025-06-08 14:52:15'),
(3439,2,'credit',NULL,40000.0000,NULL,'2025-06-08 21:52:43',106,62043,42032,NULL,NULL,NULL,'2025-06-08 14:52:43','2025-06-08 14:52:43'),
(3440,2,'credit',NULL,3519400.0000,NULL,'2025-06-09 08:52:35',13,62044,42033,NULL,NULL,NULL,'2025-06-09 01:52:35','2025-06-09 01:52:35'),
(3441,2,'credit',NULL,5915000.0000,NULL,'2025-06-09 12:09:25',13,62056,42048,NULL,NULL,NULL,'2025-06-09 05:09:25','2025-06-09 05:19:07'),
(3442,2,'credit',NULL,200000.0000,NULL,'2025-06-09 13:40:12',3,61555,42057,NULL,NULL,NULL,'2025-06-09 06:40:12','2025-07-07 14:36:11'),
(3443,2,'debit',NULL,1118000.0000,NULL,'2025-06-09 13:50:00',106,62064,42058,NULL,NULL,NULL,'2025-06-09 06:51:03','2025-06-09 06:51:03'),
(3444,2,'debit',NULL,483100.0000,NULL,'2025-06-09 14:23:00',19,62069,42063,NULL,NULL,NULL,'2025-06-09 07:25:03','2025-06-09 07:25:03'),
(3445,2,'debit',NULL,998000.0000,NULL,'2025-06-09 14:45:00',19,62073,42066,NULL,NULL,NULL,'2025-06-09 07:46:39','2025-06-09 07:46:39'),
(3446,2,'credit',NULL,543000.0000,NULL,'2025-06-09 16:50:25',13,61974,42070,NULL,NULL,NULL,'2025-06-09 09:50:25','2025-06-29 07:53:56'),
(3447,2,'credit',NULL,14250000.0000,NULL,'2025-06-09 21:41:33',106,62086,42092,NULL,NULL,NULL,'2025-06-09 14:41:33','2025-06-09 14:41:33'),
(3448,2,'credit',NULL,630000.0000,NULL,'2025-06-10 11:30:33',19,60496,42103,NULL,NULL,NULL,'2025-06-10 04:30:33','2025-06-10 04:30:33'),
(3449,2,'credit',NULL,225000.0000,NULL,'2025-06-10 11:32:21',19,62122,42104,NULL,NULL,NULL,'2025-06-10 04:32:21','2025-06-10 04:32:21'),
(3450,2,'debit',NULL,425000.0000,NULL,'2025-06-10 11:54:00',13,62124,42106,NULL,NULL,NULL,'2025-06-10 04:54:59','2025-06-10 04:54:59'),
(3451,2,'debit',NULL,7590000.0000,NULL,'2025-06-10 13:38:00',13,62133,42115,NULL,NULL,NULL,'2025-06-10 06:43:52','2025-06-10 06:43:52'),
(3452,2,'credit',NULL,528000.0000,NULL,'2025-06-10 14:15:14',6,62127,42116,NULL,NULL,NULL,'2025-06-10 07:15:14','2025-06-10 07:15:14'),
(3453,2,'credit',NULL,3000000.0000,NULL,'2025-06-10 15:03:21',3,62135,42117,NULL,NULL,NULL,'2025-06-10 08:03:21','2025-06-10 14:52:41'),
(3454,2,'debit',NULL,900000.0000,NULL,'2025-06-10 15:08:00',106,62140,42118,NULL,NULL,NULL,'2025-06-10 08:10:21','2025-06-10 08:10:21'),
(3455,2,'debit',NULL,73000.0000,NULL,'2025-06-10 16:23:00',49,62153,42121,NULL,NULL,NULL,'2025-06-10 09:28:42','2025-06-10 09:28:42'),
(3456,2,'credit',NULL,8677500.0000,NULL,'2025-06-10 18:53:44',3,61446,42127,NULL,NULL,NULL,'2025-06-10 11:53:44','2025-06-10 11:53:44'),
(3457,2,'credit',NULL,420000.0000,NULL,'2025-06-10 19:50:53',3,62174,42136,NULL,NULL,NULL,'2025-06-10 12:51:07','2025-06-10 12:51:07'),
(3458,2,'credit',NULL,586000.0000,NULL,'2025-06-10 21:41:34',6,62181,42144,NULL,NULL,NULL,'2025-06-10 14:41:34','2025-06-10 14:41:34'),
(3459,2,'credit',NULL,200000.0000,NULL,'2025-06-10 21:41:49',6,62014,42145,NULL,NULL,NULL,'2025-06-10 14:41:49','2025-06-10 14:41:49'),
(3460,2,'credit',NULL,610000.0000,NULL,'2025-06-10 21:51:12',3,62152,42146,NULL,NULL,NULL,'2025-06-10 14:51:12','2025-06-10 14:51:12'),
(3461,2,'credit',NULL,6240000.0000,NULL,'2025-06-10 21:52:41',3,62135,42147,NULL,NULL,NULL,'2025-06-10 14:52:41','2025-06-10 14:52:41'),
(3462,2,'debit',NULL,5000000.0000,NULL,'2025-06-10 23:32:00',1,62074,42148,NULL,NULL,NULL,'2025-06-10 16:32:42','2025-06-10 16:32:42'),
(3463,2,'debit',NULL,23380900.0000,NULL,'2025-06-10 23:36:00',1,62062,42149,NULL,NULL,NULL,'2025-06-10 16:36:48','2025-06-10 16:36:48'),
(3464,2,'debit',NULL,8790000.0000,NULL,'2025-06-10 23:58:00',1,61611,42150,NULL,NULL,NULL,'2025-06-10 16:58:26','2025-06-10 16:58:26'),
(3465,2,'debit',NULL,25010000.0000,NULL,'2025-06-11 00:16:00',1,61010,42151,NULL,NULL,NULL,'2025-06-10 17:16:57','2025-06-10 17:16:57'),
(3466,2,'debit',NULL,2457000.0000,NULL,'2025-06-11 00:36:00',1,62026,42152,NULL,NULL,NULL,'2025-06-10 17:36:55','2025-06-10 17:36:55'),
(3467,2,'debit',NULL,47924800.0000,NULL,'2025-06-11 00:40:00',1,62090,42153,NULL,NULL,NULL,'2025-06-10 17:40:54','2025-06-10 17:40:54'),
(3468,2,'debit',NULL,246000.0000,NULL,'2025-06-11 09:06:00',3,62184,42155,NULL,NULL,NULL,'2025-06-11 02:08:32','2025-06-11 02:08:32'),
(3469,2,'debit',NULL,30000.0000,NULL,'2025-06-11 10:59:00',49,62196,42162,NULL,NULL,NULL,'2025-06-11 04:04:59','2025-06-11 04:04:59'),
(3470,2,'credit',NULL,80000.0000,NULL,'2025-06-11 16:36:01',19,62203,42182,NULL,NULL,NULL,'2025-06-11 09:36:01','2025-06-11 09:36:01'),
(3471,2,'credit',NULL,330000.0000,NULL,'2025-06-11 16:36:00',19,62232,42183,NULL,NULL,NULL,'2025-06-11 09:37:26','2025-06-11 09:37:26'),
(3472,2,'credit',NULL,120000.0000,NULL,'2025-06-11 17:24:39',6,62236,42185,NULL,NULL,NULL,'2025-06-11 10:24:39','2025-06-11 10:24:39'),
(3473,2,'credit',NULL,240000.0000,NULL,'2025-06-11 19:30:37',106,62178,42191,NULL,NULL,NULL,'2025-06-11 12:30:37','2025-06-11 12:30:37'),
(3474,2,'credit',NULL,140000.0000,NULL,'2025-06-11 19:30:51',106,62245,42192,NULL,NULL,NULL,'2025-06-11 12:30:51','2025-06-11 12:30:51'),
(3475,2,'debit',NULL,914080.0000,NULL,'2025-06-12 08:20:00',49,62246,42195,NULL,NULL,NULL,'2025-06-12 01:24:00','2025-06-12 01:24:00'),
(3476,2,'credit',NULL,612000.0000,NULL,'2025-06-12 16:16:36',19,62287,42228,NULL,NULL,NULL,'2025-06-12 09:16:36','2025-06-12 09:16:36'),
(3477,2,'debit',NULL,107000.0000,NULL,'2025-06-12 19:51:00',106,62307,42241,NULL,NULL,NULL,'2025-06-12 12:55:16','2025-06-12 12:55:16'),
(3478,2,'debit',NULL,6135000.0000,NULL,'2025-06-13 14:57:00',1,61920,42257,NULL,NULL,NULL,'2025-06-13 07:57:56','2025-06-13 07:57:56'),
(3479,2,'credit',NULL,200000.0000,NULL,'2025-06-13 16:46:38',19,62333,42259,NULL,NULL,NULL,'2025-06-13 09:46:38','2025-07-05 05:38:37'),
(3480,2,'credit',NULL,415000.0000,NULL,'2025-06-13 17:03:36',13,62115,42260,NULL,NULL,NULL,'2025-06-13 10:03:51','2025-06-13 10:03:51'),
(3481,2,'credit',NULL,335000.0000,NULL,'2025-06-13 21:08:25',6,62349,42273,NULL,NULL,NULL,'2025-06-13 14:08:25','2025-06-13 14:08:25'),
(3482,2,'credit',NULL,140000.0000,NULL,'2025-06-13 21:09:05',6,62306,42274,NULL,NULL,NULL,'2025-06-13 14:09:05','2025-06-13 14:09:05'),
(3483,2,'debit',NULL,68000.0000,NULL,'2025-06-14 11:16:00',19,62363,42282,NULL,NULL,NULL,'2025-06-14 04:16:50','2025-06-14 04:16:50'),
(3484,2,'debit',NULL,350000.0000,NULL,'2025-06-14 16:09:00',13,62378,42293,NULL,NULL,NULL,'2025-06-14 09:10:04','2025-06-14 09:10:04'),
(3485,2,'debit',NULL,416000.0000,NULL,'2025-06-15 09:18:00',106,62405,42323,NULL,NULL,NULL,'2025-06-15 02:23:02','2025-06-15 02:23:02'),
(3486,2,'debit',NULL,1590500.0000,NULL,'2025-06-15 11:14:00',1,62409,42327,NULL,NULL,NULL,'2025-06-15 04:14:59','2025-06-15 04:14:59'),
(3487,2,'debit',NULL,18075584.0000,NULL,'2025-06-15 12:22:00',1,61900,42332,NULL,NULL,NULL,'2025-06-15 05:22:04','2025-06-15 05:22:04'),
(3488,2,'debit',NULL,1228500.0000,NULL,'2025-06-15 13:04:00',1,61965,42335,NULL,NULL,NULL,'2025-06-15 06:04:19','2025-06-15 06:04:19'),
(3489,2,'debit',NULL,514500.0000,NULL,'2025-06-15 13:09:00',1,61962,42336,NULL,NULL,NULL,'2025-06-15 06:09:33','2025-06-15 06:09:33'),
(3490,2,'debit',NULL,9275000.0000,NULL,'2025-06-15 13:27:00',1,62258,42337,NULL,NULL,NULL,'2025-06-15 06:27:14','2025-06-25 04:16:54'),
(3491,2,'debit',NULL,904800.0000,NULL,'2025-06-15 13:28:00',1,62212,42338,NULL,NULL,NULL,'2025-06-15 06:28:14','2025-06-15 06:28:14'),
(3492,2,'debit',NULL,3468200.0000,NULL,'2025-06-15 13:28:00',1,61419,42339,NULL,NULL,NULL,'2025-06-15 06:28:37','2025-06-15 06:28:37'),
(3493,2,'debit',NULL,11242475.0000,NULL,'2025-06-15 13:28:00',1,61415,42340,NULL,NULL,NULL,'2025-06-15 06:28:56','2025-06-19 17:09:12'),
(3494,2,'debit',NULL,9435400.0000,NULL,'2025-06-15 13:29:00',1,61416,42341,NULL,NULL,NULL,'2025-06-15 06:29:10','2025-06-15 06:29:10'),
(3495,2,'debit',NULL,8642487.0000,NULL,'2025-06-15 13:30:00',1,61410,42342,NULL,NULL,NULL,'2025-06-15 06:30:03','2025-06-19 17:13:54'),
(3496,2,'debit',NULL,2863647.0000,NULL,'2025-06-15 13:30:00',1,61409,42343,NULL,NULL,NULL,'2025-06-15 06:30:26','2025-06-19 17:14:47'),
(3497,2,'debit',NULL,7442435.0000,NULL,'2025-06-15 13:31:00',1,61412,42344,NULL,NULL,NULL,'2025-06-15 06:31:39','2025-06-15 06:31:39'),
(3498,2,'debit',NULL,10579400.0000,NULL,'2025-06-15 13:32:00',1,62078,42345,NULL,NULL,NULL,'2025-06-15 06:32:27','2025-06-15 06:32:27'),
(3499,2,'debit',NULL,12001703.0000,NULL,'2025-06-15 13:33:00',1,61966,42346,NULL,NULL,NULL,'2025-06-15 06:33:30','2025-06-17 16:02:12'),
(3500,2,'debit',NULL,16581194.0000,NULL,'2025-06-15 13:33:00',1,61968,42347,NULL,NULL,NULL,'2025-06-15 06:33:53','2025-06-15 06:58:11'),
(3501,2,'credit',NULL,92000.0000,NULL,'2025-06-15 14:23:35',106,62423,42352,NULL,NULL,NULL,'2025-06-15 07:23:35','2025-06-15 08:50:56'),
(3502,2,'credit',NULL,100000.0000,NULL,'2025-06-15 14:25:54',3,62424,42353,NULL,NULL,NULL,'2025-06-15 07:25:54','2025-06-15 07:25:54'),
(3503,2,'credit',NULL,79000.0000,NULL,'2025-06-15 17:37:28',19,62437,42369,NULL,NULL,NULL,'2025-06-15 10:37:28','2025-06-15 10:37:28'),
(3504,2,'debit',NULL,50000.0000,NULL,'2025-06-15 17:45:00',1,62074,42370,NULL,NULL,NULL,'2025-06-15 10:45:25','2025-06-15 10:45:25'),
(3505,2,'credit',NULL,4000000.0000,NULL,'2025-06-15 21:34:07',19,61574,42376,NULL,NULL,NULL,'2025-06-15 14:34:07','2025-08-30 06:26:53'),
(3506,2,'credit',NULL,8167800.0000,NULL,'2025-06-16 08:51:48',106,62169,42378,NULL,NULL,NULL,'2025-06-16 01:51:48','2025-06-16 06:28:53'),
(3507,2,'credit',NULL,155000.0000,NULL,'2025-06-16 12:47:17',6,62477,42388,NULL,NULL,NULL,'2025-06-16 05:47:17','2025-06-16 05:47:17'),
(3508,2,'credit',NULL,40000.0000,NULL,'2025-06-16 12:47:55',6,62470,42389,NULL,NULL,NULL,'2025-06-16 05:47:55','2025-06-16 05:47:55'),
(3509,2,'credit',NULL,245000.0000,NULL,'2025-06-16 13:38:17',19,62482,42394,NULL,NULL,'2025-06-22 06:18:44','2025-06-16 06:38:17','2025-06-22 06:18:44'),
(3510,2,'debit',NULL,135000.0000,NULL,'2025-06-16 20:11:00',19,62517,42418,NULL,NULL,NULL,'2025-06-16 13:14:21','2025-06-16 13:14:21'),
(3511,2,'credit',NULL,856000.0000,NULL,'2025-06-17 12:21:58',106,62486,42438,NULL,NULL,NULL,'2025-06-17 05:21:58','2025-06-17 05:21:58'),
(3512,2,'debit',NULL,234000.0000,NULL,'2025-06-17 13:51:00',13,62575,42442,NULL,NULL,NULL,'2025-06-17 06:54:50','2025-06-17 06:54:50'),
(3513,2,'credit',NULL,93000.0000,NULL,'2025-06-17 15:37:31',19,62585,42445,NULL,NULL,NULL,'2025-06-17 08:37:31','2025-06-17 08:37:31'),
(3514,2,'debit',NULL,3316012.0000,NULL,'2025-06-17 22:44:00',1,61967,42472,NULL,NULL,NULL,'2025-06-17 15:45:00','2025-06-17 15:45:00'),
(3515,2,'debit',NULL,17684691.0000,NULL,'2025-06-17 23:10:00',1,61964,42473,NULL,NULL,NULL,'2025-06-17 16:10:10','2025-06-17 16:10:10'),
(3516,2,'debit',NULL,9977055.0000,NULL,'2025-06-17 23:30:00',1,61760,42474,NULL,NULL,NULL,'2025-06-17 16:30:28','2025-06-17 16:30:28'),
(3517,2,'debit',NULL,2683000.0000,NULL,'2025-06-18 00:38:00',1,62493,42475,NULL,NULL,NULL,'2025-06-17 17:38:04','2025-06-17 17:38:04'),
(3518,2,'debit',NULL,1204500.0000,NULL,'2025-06-18 09:21:00',1,62543,42478,NULL,NULL,NULL,'2025-06-18 02:21:16','2025-06-18 02:21:16'),
(3519,2,'debit',NULL,1075000.0000,NULL,'2025-06-18 09:44:00',1,61652,42481,NULL,NULL,NULL,'2025-06-18 02:44:47','2025-06-18 02:44:47'),
(3520,2,'debit',NULL,79200.0000,NULL,'2025-06-18 09:51:00',1,60056,42483,NULL,NULL,NULL,'2025-06-18 02:51:25','2025-06-18 02:51:25'),
(3521,2,'debit',NULL,398000.0000,NULL,'2025-06-18 09:53:00',1,60794,42484,NULL,NULL,NULL,'2025-06-18 02:53:04','2025-06-18 02:53:04'),
(3522,2,'debit',NULL,310000.0000,NULL,'2025-06-18 09:54:00',1,61447,42485,NULL,NULL,NULL,'2025-06-18 02:54:21','2025-06-18 02:54:21'),
(3523,2,'debit',NULL,205000.0000,NULL,'2025-06-18 09:55:00',1,61856,42486,NULL,NULL,NULL,'2025-06-18 02:55:48','2025-06-18 02:55:48'),
(3524,2,'debit',NULL,409100.0000,NULL,'2025-06-18 09:56:00',1,61929,42487,NULL,NULL,NULL,'2025-06-18 02:56:27','2025-06-18 02:56:27'),
(3525,2,'debit',NULL,393000.0000,NULL,'2025-06-18 09:56:00',1,61969,42488,NULL,NULL,NULL,'2025-06-18 02:56:37','2025-06-18 02:56:37'),
(3526,2,'debit',NULL,110000.0000,NULL,'2025-06-18 09:57:00',1,62005,42489,NULL,NULL,NULL,'2025-06-18 02:57:04','2025-06-18 02:57:04'),
(3527,2,'debit',NULL,275000.0000,NULL,'2025-06-18 09:58:00',1,58277,42490,NULL,NULL,NULL,'2025-06-18 02:58:04','2025-06-18 02:58:04'),
(3528,2,'credit',NULL,200000.0000,NULL,'2025-06-18 09:58:22',106,62596,42491,NULL,NULL,NULL,'2025-06-18 02:58:22','2025-06-20 08:37:41'),
(3529,2,'credit',NULL,96000.0000,NULL,'2025-06-18 13:08:10',106,62645,42501,NULL,NULL,NULL,'2025-06-18 06:08:10','2025-06-18 06:08:10'),
(3530,2,'credit',NULL,120000.0000,NULL,'2025-06-18 13:13:28',106,62394,42502,NULL,NULL,NULL,'2025-06-18 06:13:28','2025-06-18 06:13:28'),
(3531,2,'credit',NULL,350000.0000,NULL,'2025-06-18 15:55:54',6,60839,42513,NULL,NULL,NULL,'2025-06-18 08:55:54','2025-06-18 08:55:54'),
(3532,2,'debit',NULL,267000.0000,NULL,'2025-06-18 16:34:00',6,62663,42518,NULL,NULL,NULL,'2025-06-18 09:51:31','2025-06-18 09:51:31'),
(3533,2,'credit',NULL,58000.0000,NULL,'2025-06-18 16:54:42',49,62664,42520,NULL,NULL,NULL,'2025-06-18 09:54:42','2025-06-18 09:54:42'),
(3534,2,'credit',NULL,177000.0000,NULL,'2025-06-18 17:58:23',13,62667,42525,NULL,NULL,NULL,'2025-06-18 10:58:23','2025-06-18 10:58:23'),
(3535,2,'credit',NULL,200000.0000,NULL,'2025-06-19 10:42:11',106,62272,42542,NULL,NULL,NULL,'2025-06-19 03:42:11','2025-06-19 09:39:57'),
(3536,2,'credit',NULL,3094716.0000,NULL,'2025-06-19 10:45:22',3,62319,42543,NULL,NULL,NULL,'2025-06-19 03:45:22','2025-10-01 06:47:54'),
(3537,2,'credit',NULL,8067842.0000,NULL,'2025-06-19 12:35:54',3,62319,42552,NULL,NULL,'2025-06-19 05:37:17','2025-06-19 05:35:54','2025-06-19 05:37:17'),
(3538,2,'credit',NULL,8252002.0000,NULL,'2025-06-19 12:37:17',3,62319,42553,NULL,NULL,'2025-06-19 08:28:34','2025-06-19 05:37:17','2025-06-19 08:28:34'),
(3539,2,'debit',NULL,1260200.0000,NULL,'2025-06-19 13:12:00',3,62712,42562,NULL,NULL,NULL,'2025-06-19 06:46:58','2025-06-19 06:46:58'),
(3540,2,'debit',NULL,32819850.0000,NULL,'2025-06-19 14:05:00',1,61910,42563,NULL,NULL,NULL,'2025-06-19 07:05:41','2025-06-19 07:05:41'),
(3541,2,'credit',NULL,1140000.0000,NULL,'2025-06-19 15:13:44',13,62730,42566,NULL,NULL,NULL,'2025-06-19 08:13:44','2025-06-19 08:13:44'),
(3542,2,'debit',NULL,2236308.0000,NULL,'2025-06-19 15:57:00',13,62731,42567,NULL,NULL,NULL,'2025-06-19 09:16:20','2025-06-19 09:16:20'),
(3543,2,'debit',NULL,1278550.0000,NULL,'2025-06-19 17:15:00',19,62743,42571,NULL,NULL,NULL,'2025-06-19 10:19:58','2025-06-19 10:19:58'),
(3544,2,'debit',NULL,1538452.0000,NULL,'2025-06-20 00:07:00',1,61416,42581,NULL,NULL,NULL,'2025-06-19 17:08:04','2025-06-19 17:08:04'),
(3545,2,'debit',NULL,10816128.0000,NULL,'2025-06-20 00:08:00',1,62076,42582,NULL,NULL,NULL,'2025-06-19 17:08:33','2025-06-19 17:08:33'),
(3546,2,'debit',NULL,1600000.0000,NULL,'2025-06-20 00:08:00',1,62417,42583,NULL,NULL,NULL,'2025-06-19 17:08:40','2025-06-19 17:08:40'),
(3547,2,'debit',NULL,429000.0000,NULL,'2025-06-20 13:29:00',6,62773,42593,NULL,NULL,NULL,'2025-06-20 06:31:50','2025-06-20 06:31:50'),
(3548,2,'credit',NULL,11792000.0000,NULL,'2025-06-20 15:07:19',3,62582,42599,NULL,NULL,NULL,'2025-06-20 08:28:44','2025-06-20 11:33:38'),
(3549,2,'credit',NULL,185000.0000,NULL,'2025-06-20 15:37:36',13,62781,42601,NULL,NULL,NULL,'2025-06-20 08:37:36','2025-06-20 08:37:36'),
(3550,2,'credit',NULL,925000.0000,NULL,'2025-06-20 15:37:41',13,62596,42602,NULL,NULL,NULL,'2025-06-20 08:37:41','2025-06-20 08:37:41'),
(3551,2,'credit',NULL,200000.0000,NULL,'2025-06-20 15:42:14',6,62783,42604,NULL,NULL,NULL,'2025-06-20 08:42:14','2025-06-29 04:57:03'),
(3552,2,'credit',NULL,80000.0000,NULL,'2025-06-20 18:03:07',6,62696,42608,NULL,NULL,NULL,'2025-06-20 11:03:07','2025-06-28 10:43:33'),
(3553,2,'credit',NULL,542000.0000,NULL,'2025-06-21 09:03:04',6,62821,42628,NULL,NULL,NULL,'2025-06-21 02:03:04','2025-06-21 02:03:04'),
(3554,2,'credit',NULL,361000.0000,NULL,'2025-06-21 15:13:25',49,62846,42647,NULL,NULL,NULL,'2025-06-21 08:13:25','2025-06-21 08:13:25'),
(3555,2,'credit',NULL,477000.0000,NULL,'2025-06-21 16:35:44',6,62855,42651,NULL,NULL,NULL,'2025-06-21 09:35:44','2025-06-21 09:35:44'),
(3556,2,'credit',NULL,80000.0000,NULL,'2025-06-21 16:39:43',106,62537,42652,NULL,NULL,NULL,'2025-06-21 09:39:43','2025-06-21 09:39:43'),
(3557,2,'credit',NULL,250000.0000,NULL,'2025-06-21 19:43:06',49,62769,42656,NULL,NULL,NULL,'2025-06-21 12:43:06','2025-06-21 12:43:06'),
(3558,2,'credit',NULL,233500.0000,NULL,'2025-06-21 20:45:16',49,62639,42658,NULL,NULL,NULL,'2025-06-21 13:45:16','2025-06-29 08:16:16'),
(3559,2,'credit',NULL,250000.0000,NULL,'2025-06-21 21:56:59',6,62365,42662,NULL,NULL,NULL,'2025-06-21 14:56:59','2025-06-21 14:56:59'),
(3560,2,'credit',NULL,1995000.0000,NULL,'2025-06-21 21:59:34',6,62867,42663,NULL,NULL,NULL,'2025-06-21 14:59:34','2025-06-30 07:36:31'),
(3561,2,'credit',NULL,200000.0000,NULL,'2025-06-22 09:21:59',49,62863,42665,NULL,NULL,NULL,'2025-06-22 02:21:59','2025-07-09 13:53:23'),
(3562,2,'credit',NULL,200000.0000,NULL,'2025-06-22 09:30:34',49,62871,42668,NULL,NULL,NULL,'2025-06-22 02:30:34','2025-06-22 05:30:50'),
(3563,2,'credit',NULL,100000.0000,NULL,'2025-06-22 12:33:58',49,62876,42675,NULL,NULL,NULL,'2025-06-22 05:33:58','2025-06-29 08:34:48'),
(3564,2,'debit',NULL,62000.0000,NULL,'2025-06-22 13:30:00',13,62885,42680,NULL,NULL,NULL,'2025-06-22 06:42:45','2025-06-22 06:42:45'),
(3565,2,'debit',NULL,101900.0000,NULL,'2025-06-22 13:44:00',13,62891,42685,NULL,NULL,NULL,'2025-06-22 06:54:49','2025-06-22 06:54:49'),
(3566,2,'credit',NULL,80000.0000,NULL,'2025-06-22 15:21:14',106,62513,42691,NULL,NULL,NULL,'2025-06-22 08:21:14','2025-06-22 08:21:14'),
(3567,2,'debit',NULL,806320.0000,NULL,'2025-06-22 18:54:00',106,62908,42701,NULL,NULL,NULL,'2025-06-22 12:03:30','2025-06-22 12:03:30'),
(3568,2,'credit',NULL,110000.0000,NULL,'2025-06-23 09:29:28',49,62695,42712,NULL,NULL,NULL,'2025-06-23 02:29:28','2025-06-24 02:12:13'),
(3569,2,'debit',NULL,409000.0000,NULL,'2025-06-23 15:52:00',13,62961,42728,NULL,NULL,NULL,'2025-06-23 08:53:41','2025-06-23 08:53:41'),
(3570,2,'credit',NULL,2175000.0000,NULL,'2025-06-24 08:59:51',13,62986,42745,NULL,NULL,NULL,'2025-06-24 01:59:51','2025-06-24 01:59:51'),
(3571,2,'credit',NULL,390000.0000,NULL,'2025-06-24 09:11:49',49,62988,42748,NULL,NULL,NULL,'2025-06-24 02:11:49','2025-06-24 02:11:49'),
(3572,2,'debit',NULL,5635961.0000,NULL,'2025-06-24 10:16:00',13,62993,42751,NULL,NULL,NULL,'2025-06-24 03:17:50','2025-06-24 03:17:50'),
(3573,2,'credit',NULL,2190000.0000,NULL,'2025-06-24 11:13:05',49,62998,42756,NULL,NULL,NULL,'2025-06-24 04:13:05','2025-06-24 04:13:05'),
(3574,2,'debit',NULL,85000.0000,NULL,'2025-06-24 15:11:00',13,63021,42766,NULL,NULL,NULL,'2025-06-24 08:12:18','2025-06-24 08:12:18'),
(3575,2,'debit',NULL,258000.0000,NULL,'2025-06-24 15:07:00',49,63022,42767,NULL,NULL,NULL,'2025-06-24 08:13:19','2025-06-24 08:13:19'),
(3576,2,'credit',NULL,100000.0000,NULL,'2025-06-24 15:36:35',13,63023,42770,NULL,NULL,NULL,'2025-06-24 08:36:35','2025-07-19 06:32:34'),
(3577,2,'debit',NULL,1272400.0000,NULL,'2025-06-24 16:49:00',13,63034,42781,NULL,NULL,NULL,'2025-06-24 09:52:52','2025-06-24 09:52:52'),
(3578,2,'credit',NULL,145000.0000,NULL,'2025-06-24 19:30:16',106,63045,42790,NULL,NULL,NULL,'2025-06-24 12:30:16','2025-06-24 12:30:16'),
(3579,2,'debit',NULL,13747992.0000,NULL,'2025-06-25 01:51:00',1,61983,42800,NULL,NULL,NULL,'2025-06-24 18:51:38','2025-06-24 18:55:54'),
(3580,2,'debit',NULL,2384960.0000,NULL,'2025-06-25 01:54:00',1,62868,42801,NULL,NULL,NULL,'2025-06-24 18:54:53','2025-06-24 18:54:53'),
(3581,2,'debit',NULL,750700.0000,NULL,'2025-06-25 08:35:00',13,63053,42802,NULL,NULL,NULL,'2025-06-25 01:36:55','2025-06-25 01:36:55'),
(3582,2,'credit',NULL,92000.0000,NULL,'2025-06-25 09:04:28',13,63055,42803,NULL,NULL,NULL,'2025-06-25 02:04:28','2025-06-25 02:04:28'),
(3583,2,'debit',NULL,10567661.0000,NULL,'2025-06-25 10:35:00',1,62472,42806,NULL,NULL,NULL,'2025-06-25 03:35:32','2025-06-25 03:35:32'),
(3584,2,'debit',NULL,834220.0000,NULL,'2025-06-25 11:01:00',1,62954,42811,NULL,NULL,NULL,'2025-06-25 04:01:09','2025-06-25 04:01:09'),
(3585,2,'debit',NULL,3477000.0000,NULL,'2025-06-25 11:05:00',1,62955,42812,NULL,NULL,NULL,'2025-06-25 04:05:23','2025-06-25 04:05:23'),
(3586,2,'debit',NULL,3486671.0000,NULL,'2025-06-25 11:07:00',1,62956,42813,NULL,NULL,NULL,'2025-06-25 04:07:19','2025-06-25 04:07:19'),
(3587,2,'credit',NULL,495000.0000,NULL,'2025-06-25 12:24:18',13,63032,42817,NULL,NULL,NULL,'2025-06-25 05:24:18','2025-06-29 08:37:09'),
(3588,2,'credit',NULL,15000.0000,NULL,'2025-06-25 15:57:59',3,63084,42827,NULL,NULL,NULL,'2025-06-25 08:57:59','2025-06-25 08:57:59'),
(3589,2,'credit',NULL,2175000.0000,NULL,'2025-06-25 16:35:52',16,63089,42832,NULL,NULL,NULL,'2025-06-25 09:35:52','2025-06-25 09:35:52'),
(3590,2,'debit',NULL,1329200.0000,NULL,'2025-06-25 16:57:00',13,63092,42835,NULL,NULL,NULL,'2025-06-25 10:02:37','2025-06-25 10:02:37'),
(3591,2,'debit',NULL,98000.0000,NULL,'2025-06-26 08:27:00',49,63116,42853,NULL,NULL,NULL,'2025-06-26 01:28:22','2025-06-26 01:28:22'),
(3592,2,'debit',NULL,1268198.0000,NULL,'2025-06-26 15:02:00',13,63149,42871,NULL,NULL,NULL,'2025-06-26 08:06:07','2025-06-26 08:06:07'),
(3593,2,'debit',NULL,247000.0000,NULL,'2025-06-26 17:25:00',3,63159,42879,NULL,NULL,NULL,'2025-06-26 10:26:19','2025-06-26 10:26:19'),
(3594,2,'debit',NULL,121000.0000,NULL,'2025-06-26 17:33:00',106,63161,42881,NULL,NULL,NULL,'2025-06-26 10:40:00','2025-06-26 10:40:00'),
(3595,2,'debit',NULL,1260000.0000,NULL,'2025-06-26 17:53:00',3,63165,42886,NULL,NULL,NULL,'2025-06-26 11:08:59','2025-06-26 11:08:59'),
(3596,2,'credit',NULL,1000000.0000,NULL,'2025-06-26 18:43:54',106,63147,42887,NULL,NULL,'2025-06-28 04:17:14','2025-06-26 11:43:54','2025-06-28 04:17:14'),
(3597,2,'credit',NULL,500000.0000,NULL,'2025-06-26 18:44:39',106,63148,42888,NULL,NULL,'2025-06-28 04:17:23','2025-06-26 11:44:39','2025-06-28 04:17:23'),
(3598,2,'debit',NULL,312500.0000,NULL,'2025-06-26 19:02:00',3,63170,42890,NULL,NULL,NULL,'2025-06-26 12:04:08','2025-06-26 12:04:08'),
(3599,2,'credit',NULL,200000.0000,NULL,'2025-06-26 20:46:05',106,62835,42901,NULL,NULL,NULL,'2025-06-26 13:46:05','2025-06-26 13:46:05'),
(3600,2,'credit',NULL,740000.0000,NULL,'2025-06-26 20:47:30',106,63181,42902,NULL,NULL,NULL,'2025-06-26 13:47:30','2025-06-26 13:47:30'),
(3601,2,'credit',NULL,1000000.0000,NULL,'2025-06-28 10:11:32',13,63185,42905,NULL,NULL,NULL,'2025-06-28 03:11:32','2025-06-30 14:34:55'),
(3602,2,'credit',NULL,500000.0000,NULL,'2025-06-28 10:12:12',13,63184,42906,NULL,NULL,NULL,'2025-06-28 03:12:12','2025-06-30 14:34:30'),
(3603,2,'debit',NULL,834220.0000,NULL,'2025-06-28 10:14:00',49,63190,42907,NULL,NULL,NULL,'2025-06-28 03:18:10','2025-06-28 03:18:10'),
(3604,2,'debit',NULL,2331000.0000,NULL,'2025-06-28 10:23:00',13,63193,42910,NULL,NULL,'2025-08-05 07:12:51','2025-06-28 03:40:16','2025-08-05 07:12:51'),
(3605,2,'debit',NULL,8828900.0000,NULL,'2025-06-28 12:02:00',1,47614,42916,NULL,NULL,NULL,'2025-06-28 05:02:59','2025-06-28 05:02:59'),
(3606,2,'credit',NULL,3000000.0000,NULL,'2025-06-28 12:12:02',49,63200,42918,NULL,NULL,NULL,'2025-06-28 05:12:02','2025-06-28 06:06:16'),
(3607,2,'credit',NULL,315000.0000,NULL,'2025-06-28 13:35:51',13,63212,42922,NULL,NULL,NULL,'2025-06-28 06:35:51','2025-06-28 06:35:51'),
(3608,2,'credit',NULL,301000.0000,NULL,'2025-06-28 17:46:14',13,63224,42937,NULL,NULL,NULL,'2025-06-28 10:46:14','2025-06-29 08:48:43'),
(3609,2,'credit',NULL,197000.0000,NULL,'2025-06-28 19:15:04',19,63241,42945,NULL,NULL,NULL,'2025-06-28 12:15:04','2025-06-28 12:15:04'),
(3610,2,'debit',NULL,5000000.0000,NULL,'2025-06-28 21:38:00',49,63259,42951,NULL,NULL,NULL,'2025-06-28 14:39:19','2025-06-28 14:39:19'),
(3611,2,'credit',NULL,290000.0000,NULL,'2025-06-29 11:57:03',19,62783,42958,NULL,NULL,NULL,'2025-06-29 04:57:03','2025-06-29 04:57:03'),
(3612,2,'credit',NULL,120000.0000,NULL,'2025-06-28 18:04:13',19,63233,42939,NULL,NULL,NULL,'2025-06-29 05:00:27','2025-06-29 05:00:27'),
(3613,2,'credit',NULL,160000.0000,NULL,'2025-06-29 12:18:52',3,62950,42960,NULL,NULL,NULL,'2025-06-29 05:18:52','2025-06-29 05:18:52'),
(3614,2,'credit',NULL,185000.0000,NULL,'2025-06-29 12:19:24',3,63270,42961,NULL,NULL,NULL,'2025-06-29 05:19:24','2025-06-29 05:19:24'),
(3615,2,'debit',NULL,243000.0000,NULL,'2025-06-29 13:50:00',13,63275,42965,NULL,NULL,NULL,'2025-06-29 06:51:11','2025-06-29 06:51:11'),
(3616,2,'debit',NULL,378500.0000,NULL,'2025-06-29 13:56:00',13,63276,42966,NULL,NULL,NULL,'2025-06-29 06:58:15','2025-06-29 06:58:15'),
(3617,2,'credit',NULL,87500.0000,NULL,'2025-06-29 14:54:08',3,63282,42972,NULL,NULL,NULL,'2025-06-29 07:54:08','2025-06-29 07:54:08'),
(3618,2,'credit',NULL,87500.0000,NULL,'2025-06-29 14:54:20',3,63283,42973,NULL,NULL,NULL,'2025-06-29 07:54:20','2025-06-29 07:54:20'),
(3619,2,'credit',NULL,60000.0000,NULL,'2025-06-29 15:16:23',3,63289,42982,NULL,NULL,NULL,'2025-06-29 08:16:23','2025-06-29 08:16:23'),
(3620,2,'credit',NULL,60000.0000,NULL,'2025-06-29 15:16:28',3,63290,42983,NULL,NULL,NULL,'2025-06-29 08:16:28','2025-06-29 08:16:28'),
(3621,2,'credit',NULL,50000.0000,NULL,'2025-06-29 15:35:12',3,63294,42989,NULL,NULL,NULL,'2025-06-29 08:35:12','2025-06-29 08:35:12'),
(3622,2,'credit',NULL,205000.0000,NULL,'2025-06-29 15:37:23',3,63295,42991,NULL,NULL,NULL,'2025-06-29 08:37:23','2025-06-29 08:37:23'),
(3623,2,'credit',NULL,80000.0000,NULL,'2025-06-29 15:49:05',3,63297,42994,NULL,NULL,NULL,'2025-06-29 08:49:05','2025-06-29 08:49:05'),
(3624,2,'credit',NULL,80000.0000,NULL,'2025-06-29 15:49:22',3,63298,42995,NULL,NULL,NULL,'2025-06-29 08:49:22','2025-06-29 08:49:22'),
(3625,2,'credit',NULL,75000.0000,NULL,'2025-06-30 09:13:08',19,63329,43030,NULL,NULL,NULL,'2025-06-30 02:13:08','2025-06-30 02:13:08'),
(3626,2,'credit',NULL,75000.0000,NULL,'2025-06-30 09:13:42',19,63330,43031,NULL,NULL,NULL,'2025-06-30 02:13:42','2025-06-30 02:13:42'),
(3627,2,'debit',NULL,417000.0000,NULL,'2025-06-30 10:48:00',3,63345,43043,NULL,NULL,NULL,'2025-06-30 03:49:26','2025-06-30 03:49:26'),
(3628,2,'debit',NULL,102000.0000,NULL,'2025-06-30 12:08:00',3,63355,43048,NULL,NULL,NULL,'2025-06-30 05:14:35','2025-06-30 05:14:35'),
(3629,2,'debit',NULL,212500.0000,NULL,'2025-06-30 12:28:00',3,63357,43052,NULL,NULL,NULL,'2025-06-30 05:29:26','2025-06-30 05:29:26'),
(3630,2,'debit',NULL,492330.0000,NULL,'2025-06-30 14:47:00',3,63368,43058,NULL,NULL,NULL,'2025-06-30 07:49:47','2025-06-30 07:49:47'),
(3631,2,'credit',NULL,301000.0000,NULL,'2025-06-30 16:35:24',3,60602,43072,NULL,NULL,NULL,'2025-06-30 09:35:24','2025-06-30 09:35:24'),
(3632,2,'credit',NULL,100000.0000,NULL,'2025-06-30 17:31:35',6,63267,43075,NULL,NULL,NULL,'2025-06-30 10:31:35','2025-06-30 10:31:35'),
(3633,2,'credit',NULL,411000.0000,NULL,'2025-06-30 21:34:30',13,63184,43090,NULL,NULL,NULL,'2025-06-30 14:34:30','2025-06-30 14:34:30'),
(3634,2,'debit',NULL,1138000.0000,NULL,'2025-07-01 14:39:00',19,63438,43136,NULL,NULL,NULL,'2025-07-01 07:40:41','2025-07-01 07:40:41'),
(3635,2,'credit',NULL,5605000.0000,NULL,'2025-07-01 15:30:41',5,63444,43140,NULL,NULL,NULL,'2025-07-01 08:30:41','2025-07-01 10:14:35'),
(3636,2,'credit',NULL,80000.0000,NULL,'2025-07-01 17:17:29',106,63418,43146,NULL,NULL,NULL,'2025-07-01 10:17:29','2025-07-13 05:04:54'),
(3637,2,'debit',NULL,199000.0000,NULL,'2025-07-01 18:52:00',49,63456,43151,NULL,NULL,NULL,'2025-07-01 11:54:43','2025-07-01 11:54:43'),
(3638,2,'credit',NULL,114000.0000,NULL,'2025-07-01 19:34:17',6,63460,43156,NULL,NULL,NULL,'2025-07-01 12:34:17','2025-07-01 12:34:17'),
(3639,2,'credit',NULL,255000.0000,NULL,'2025-07-02 12:51:47',106,63506,43177,NULL,NULL,NULL,'2025-07-02 05:51:47','2025-07-02 05:51:47'),
(3640,2,'debit',NULL,100000.0000,NULL,'2025-07-02 13:35:00',13,63510,43178,NULL,NULL,NULL,'2025-07-02 06:43:55','2025-07-02 06:43:55'),
(3641,2,'credit',NULL,1840000.0000,NULL,'2025-07-02 15:04:09',13,63520,43186,NULL,NULL,NULL,'2025-07-02 08:04:09','2025-07-02 08:31:48'),
(3642,2,'debit',NULL,1556000.0000,NULL,'2025-07-02 15:13:00',13,63522,43188,NULL,NULL,NULL,'2025-07-02 08:13:48','2025-07-02 08:13:48'),
(3643,2,'debit',NULL,49000.0000,NULL,'2025-07-03 08:28:00',49,63558,43216,NULL,NULL,NULL,'2025-07-03 01:30:12','2025-07-03 01:30:12'),
(3644,2,'credit',NULL,100000.0000,NULL,'2025-07-03 12:25:16',106,62909,43226,NULL,NULL,NULL,'2025-07-03 05:25:16','2025-07-06 02:29:56'),
(3645,2,'credit',NULL,305400.0000,NULL,'2025-07-03 17:39:37',19,63594,43247,NULL,NULL,NULL,'2025-07-03 10:39:37','2025-08-01 07:27:48'),
(3646,2,'debit',NULL,449000.0000,NULL,'2025-07-03 21:55:00',13,63609,43259,NULL,NULL,NULL,'2025-07-03 14:57:20','2025-07-03 14:57:20'),
(3647,2,'credit',NULL,3628000.0000,NULL,'2025-07-04 08:57:00',19,63542,43267,NULL,NULL,NULL,'2025-07-04 01:58:17','2025-07-29 13:44:51'),
(3648,2,'credit',NULL,296000.0000,NULL,'2025-07-04 11:30:57',106,63624,43276,NULL,NULL,NULL,'2025-07-04 04:30:57','2025-07-04 04:30:57'),
(3649,2,'debit',NULL,402000.0000,NULL,'2025-07-04 17:49:00',49,63650,43289,NULL,NULL,NULL,'2025-07-04 10:50:37','2025-07-04 10:50:37'),
(3650,2,'debit',NULL,200000.0000,NULL,'2025-07-04 17:51:00',49,63651,43290,NULL,NULL,NULL,'2025-07-04 10:52:16','2025-07-04 10:52:16'),
(3651,2,'debit',NULL,594000.0000,NULL,'2025-07-04 18:25:00',6,63652,43291,NULL,NULL,NULL,'2025-07-04 11:30:01','2025-07-04 11:30:01'),
(3652,2,'debit',NULL,2260000.0000,NULL,'2025-07-04 20:13:00',13,63654,43295,NULL,NULL,NULL,'2025-07-04 13:17:17','2025-07-04 13:17:17'),
(3653,2,'credit',NULL,80000.0000,NULL,'2025-07-04 20:29:48',49,63543,43296,NULL,NULL,NULL,'2025-07-04 13:29:48','2025-07-04 13:29:48'),
(3654,2,'credit',NULL,150000.0000,NULL,'2025-07-04 21:44:08',49,63641,43298,NULL,NULL,NULL,'2025-07-04 14:44:08','2025-07-04 14:49:07'),
(3655,2,'debit',NULL,7144000.0000,NULL,'2025-07-05 13:38:00',49,63678,43315,NULL,NULL,NULL,'2025-07-05 06:43:06','2025-07-05 06:43:06'),
(3656,2,'debit',NULL,460000.0000,NULL,'2025-07-05 15:02:00',49,63687,43324,NULL,NULL,NULL,'2025-07-05 08:06:28','2025-07-05 08:06:28'),
(3657,2,'credit',NULL,2175000.0000,NULL,'2025-07-05 15:12:32',5,63688,43325,NULL,NULL,NULL,'2025-07-05 08:12:32','2025-07-06 08:34:19'),
(3658,2,'debit',NULL,30691200.0000,NULL,'2025-07-05 15:26:00',13,63689,43327,NULL,NULL,NULL,'2025-07-05 08:36:53','2025-07-05 08:36:53'),
(3659,2,'credit',NULL,1250000.0000,NULL,'2025-07-05 17:16:31',5,63700,43341,NULL,NULL,NULL,'2025-07-05 10:16:31','2025-07-05 10:30:17'),
(3660,2,'credit',NULL,150000.0000,NULL,'2025-07-05 17:16:46',5,62625,43342,NULL,NULL,NULL,'2025-07-05 10:16:46','2025-07-05 10:16:46'),
(3661,2,'debit',NULL,193900.0000,NULL,'2025-07-05 19:13:00',13,63708,43356,NULL,NULL,'2025-07-08 06:46:33','2025-07-05 12:17:17','2025-07-08 06:46:33'),
(3662,2,'credit',NULL,200000.0000,NULL,'2025-07-05 20:26:49',6,63598,43361,NULL,NULL,NULL,'2025-07-05 13:26:49','2025-07-26 13:49:19'),
(3663,2,'credit',NULL,1120000.0000,NULL,'2025-07-06 08:58:14',6,63547,43364,NULL,NULL,NULL,'2025-07-06 01:58:14','2025-08-01 03:34:03'),
(3664,2,'credit',NULL,50100.0000,NULL,'2025-07-06 09:24:36',106,61388,43365,NULL,NULL,NULL,'2025-07-06 02:24:36','2025-07-06 02:24:36'),
(3665,2,'credit',NULL,310000.0000,NULL,'2025-07-06 09:29:56',106,62909,43366,NULL,NULL,NULL,'2025-07-06 02:29:56','2025-07-06 02:29:56'),
(3666,2,'debit',NULL,670000.0000,NULL,'2025-07-07 10:39:00',13,63767,43408,NULL,NULL,NULL,'2025-07-07 03:41:38','2025-07-07 03:41:38'),
(3667,2,'credit',NULL,200000.0000,NULL,'2025-07-07 11:48:05',6,63779,43414,NULL,NULL,NULL,'2025-07-07 04:48:05','2025-08-01 07:08:33'),
(3668,2,'debit',NULL,235000.0000,NULL,'2025-07-07 18:37:00',19,63807,43444,NULL,NULL,NULL,'2025-07-07 11:38:23','2025-07-07 11:38:23'),
(3669,2,'debit',NULL,1817500.0000,NULL,'2025-07-08 09:25:00',106,63820,43462,NULL,NULL,NULL,'2025-07-08 02:29:17','2025-07-08 02:29:17'),
(3670,2,'credit',NULL,46000.0000,NULL,'2025-07-08 10:03:15',2,63823,43464,NULL,NULL,NULL,'2025-07-08 03:03:15','2025-07-08 03:03:15'),
(3671,2,'credit',NULL,72000.0000,NULL,'2025-07-08 11:21:20',6,63832,43475,NULL,NULL,'2025-07-08 04:21:50','2025-07-08 04:21:20','2025-07-08 04:21:50'),
(3672,2,'credit',NULL,72000.0000,NULL,'2025-07-08 11:23:28',6,63834,43477,NULL,NULL,NULL,'2025-07-08 04:23:28','2025-07-08 04:23:28'),
(3673,2,'credit',NULL,530000.0000,NULL,'2025-07-08 11:59:29',106,63842,43481,NULL,NULL,NULL,'2025-07-08 04:59:29','2025-07-08 04:59:29'),
(3674,2,'debit',NULL,82000.0000,NULL,'2025-07-08 13:07:00',49,63850,43488,NULL,NULL,NULL,'2025-07-08 06:09:39','2025-07-08 06:09:39'),
(3675,2,'debit',NULL,415000.0000,NULL,'2025-07-08 17:18:00',13,63871,43506,NULL,NULL,NULL,'2025-07-08 10:20:32','2025-07-08 10:20:32'),
(3676,2,'debit',NULL,7200000.0000,NULL,'2025-07-09 09:30:00',106,63889,43524,NULL,NULL,NULL,'2025-07-09 02:31:38','2025-07-09 02:31:38'),
(3677,2,'credit',NULL,36000.0000,NULL,'2025-07-09 11:37:21',106,63898,43528,NULL,NULL,NULL,'2025-07-09 04:37:38','2025-07-09 04:37:38'),
(3678,2,'debit',NULL,195000.0000,NULL,'2025-07-09 14:39:00',106,63919,43541,NULL,NULL,NULL,'2025-07-09 07:44:21','2025-07-09 07:44:21'),
(3679,2,'credit',NULL,2175000.0000,NULL,'2025-07-09 17:54:36',2,63927,43553,NULL,NULL,NULL,'2025-07-09 10:54:36','2025-07-09 10:54:36'),
(3680,2,'credit',NULL,198000.0000,NULL,'2025-07-09 18:37:00',19,63930,43557,NULL,NULL,NULL,'2025-07-09 14:21:22','2025-07-09 14:21:22'),
(3681,2,'credit',NULL,495000.0000,NULL,'2025-07-09 22:03:15',19,63886,43567,NULL,NULL,NULL,'2025-07-09 15:03:15','2025-07-09 15:03:15'),
(3682,2,'credit',NULL,49000.0000,NULL,'2025-07-09 22:03:36',19,63940,43568,NULL,NULL,NULL,'2025-07-09 15:03:36','2025-07-09 15:03:36'),
(3683,2,'credit',NULL,178000.0000,NULL,'2025-07-10 08:33:20',19,63944,43573,NULL,NULL,NULL,'2025-07-10 01:33:20','2025-07-10 01:33:20'),
(3684,2,'credit',NULL,370000.0000,NULL,'2025-07-10 16:28:02',49,62631,43592,NULL,NULL,NULL,'2025-07-10 09:30:36','2025-07-10 09:30:36'),
(3685,2,'credit',NULL,6000000.0000,NULL,'2025-07-10 19:01:57',19,63992,43600,NULL,NULL,NULL,'2025-07-10 12:01:57','2025-07-29 13:50:12'),
(3686,2,'debit',NULL,3408000.0000,NULL,'2025-07-11 10:16:00',6,64010,43608,NULL,NULL,NULL,'2025-07-11 03:18:38','2025-07-11 03:18:38'),
(3687,2,'credit',NULL,35000.0000,NULL,'2025-07-11 10:59:43',106,64011,43609,NULL,NULL,NULL,'2025-07-11 03:59:43','2025-07-11 03:59:43'),
(3688,2,'credit',NULL,365000.0000,NULL,'2025-07-11 11:15:05',49,64009,43610,NULL,NULL,NULL,'2025-07-11 04:15:05','2025-07-11 04:15:05'),
(3689,2,'credit',NULL,85000.0000,NULL,'2025-07-11 18:43:00',19,64047,43628,NULL,NULL,NULL,'2025-07-11 11:43:47','2025-07-11 11:43:47'),
(3690,2,'credit',NULL,752000.0000,NULL,'2025-07-12 11:20:51',6,64065,43642,NULL,NULL,NULL,'2025-07-12 04:20:51','2025-07-12 04:20:51'),
(3691,2,'credit',NULL,200000.0000,NULL,'2025-07-12 14:25:03',5,64013,43647,NULL,NULL,NULL,'2025-07-12 07:25:03','2025-07-29 04:00:59'),
(3692,2,'debit',NULL,415000.0000,NULL,'2025-07-12 14:29:00',13,64076,43648,NULL,NULL,NULL,'2025-07-12 07:30:34','2025-07-12 07:30:34'),
(3693,2,'debit',NULL,415000.0000,NULL,'2025-07-12 14:30:00',13,64077,43649,NULL,NULL,NULL,'2025-07-12 07:31:15','2025-07-12 07:31:15'),
(3694,2,'credit',NULL,2159000.0000,NULL,'2025-07-12 15:45:00',5,64062,43654,NULL,NULL,NULL,'2025-07-12 08:45:00','2025-07-26 05:56:56'),
(3695,2,'credit',NULL,645000.0000,NULL,'2025-07-12 16:14:03',49,63899,43655,NULL,NULL,NULL,'2025-07-12 09:14:03','2025-07-12 09:14:03'),
(3696,2,'credit',NULL,577000.0000,NULL,'2025-07-12 16:14:19',49,64084,43656,NULL,NULL,NULL,'2025-07-12 09:14:19','2025-07-12 09:14:19'),
(3697,2,'credit',NULL,475000.0000,NULL,'2025-07-12 20:43:14',6,64108,43674,NULL,NULL,NULL,'2025-07-12 13:43:14','2025-07-12 13:43:14'),
(3698,2,'credit',NULL,120000.0000,NULL,'2025-07-13 12:04:17',13,64121,43680,NULL,NULL,NULL,'2025-07-13 05:10:44','2025-07-31 02:22:09'),
(3699,2,'credit',NULL,1296000.0000,NULL,'2025-07-13 14:34:00',19,64127,43687,NULL,NULL,NULL,'2025-07-13 07:34:17','2025-07-13 07:34:17'),
(3700,2,'credit',NULL,270000.0000,NULL,'2025-07-13 16:22:55',19,64109,43689,NULL,NULL,NULL,'2025-07-13 09:22:55','2025-07-13 09:22:55'),
(3701,2,'credit',NULL,1113000.0000,NULL,'2025-07-14 11:58:14',5,64158,43721,NULL,NULL,NULL,'2025-07-14 04:58:14','2025-07-15 07:34:27'),
(3702,2,'debit',NULL,5250000.0000,NULL,'2025-07-14 12:21:00',13,64162,43723,NULL,NULL,NULL,'2025-07-14 05:23:10','2025-07-14 05:23:10'),
(3703,2,'credit',NULL,504600.0000,NULL,'2025-07-14 14:05:25',6,64160,43726,NULL,NULL,NULL,'2025-07-14 07:05:25','2025-07-14 07:05:25'),
(3704,2,'debit',NULL,390000.0000,NULL,'2025-07-15 10:51:00',19,64220,43754,NULL,NULL,NULL,'2025-07-15 03:51:48','2025-07-15 03:51:48'),
(3705,2,'credit',NULL,200000.0000,NULL,'2025-07-15 11:11:39',13,64113,43757,NULL,NULL,NULL,'2025-07-15 04:11:39','2025-07-24 08:32:30'),
(3706,2,'credit',NULL,612000.0000,NULL,'2025-07-15 11:21:48',13,64224,43758,NULL,NULL,NULL,'2025-07-15 04:21:48','2025-07-15 04:21:48'),
(3707,2,'credit',NULL,200000.0000,NULL,'2025-07-15 14:31:47',10,63499,43768,NULL,NULL,NULL,'2025-07-15 07:31:47','2025-08-02 08:39:30'),
(3708,2,'credit',NULL,620000.0000,NULL,'2025-07-15 14:33:14',106,64234,43769,NULL,NULL,NULL,'2025-07-15 07:33:14','2025-07-15 12:26:26'),
(3709,2,'credit',NULL,1113000.0000,NULL,'2025-07-15 14:34:27',5,64158,43770,NULL,NULL,NULL,'2025-07-15 07:34:27','2025-07-15 07:34:27'),
(3710,2,'credit',NULL,200000.0000,NULL,'2025-07-15 15:04:48',106,64060,43772,NULL,NULL,NULL,'2025-07-15 08:11:40','2025-07-15 09:06:48'),
(3711,2,'credit',NULL,3357100.0000,NULL,'2025-07-15 15:22:02',106,63479,43773,NULL,NULL,NULL,'2025-07-15 08:22:02','2025-07-15 08:30:18'),
(3712,2,'debit',NULL,375458.0000,NULL,'2025-07-15 16:06:00',13,64242,43779,NULL,NULL,NULL,'2025-07-15 09:08:55','2025-07-15 09:08:55'),
(3713,2,'debit',NULL,175214.0000,NULL,'2025-07-15 16:09:00',13,64243,43780,NULL,NULL,NULL,'2025-07-15 09:11:29','2025-07-15 09:11:29'),
(3714,2,'debit',NULL,269328.0000,NULL,'2025-07-15 16:12:00',13,64244,43781,NULL,NULL,NULL,'2025-07-15 09:15:35','2025-07-15 09:15:35'),
(3715,2,'debit',NULL,645000.0000,NULL,'2025-07-15 16:16:00',13,64245,43782,NULL,NULL,NULL,'2025-07-15 09:18:55','2025-07-15 09:18:55'),
(3716,2,'debit',NULL,1126000.0000,NULL,'2025-07-15 18:27:00',106,64254,43789,NULL,NULL,NULL,'2025-07-15 11:28:46','2025-07-15 11:28:46'),
(3717,2,'debit',NULL,2158928.0000,NULL,'2025-07-15 18:28:00',49,64255,43790,NULL,NULL,NULL,'2025-07-15 11:30:50','2025-07-15 11:30:50'),
(3718,2,'credit',NULL,295000.0000,NULL,'2025-07-15 19:47:52',106,64258,43797,NULL,NULL,NULL,'2025-07-15 12:52:04','2025-07-15 12:52:04'),
(3719,2,'credit',NULL,160000.0000,NULL,'2025-07-15 19:47:19',106,63739,43796,NULL,NULL,NULL,'2025-07-15 12:52:39','2025-07-15 12:52:39'),
(3720,2,'debit',NULL,211000.0000,NULL,'2025-07-15 20:04:00',49,64264,43801,NULL,NULL,NULL,'2025-07-15 13:13:47','2025-07-15 13:13:47'),
(3721,2,'debit',NULL,65000.0000,NULL,'2025-07-16 08:20:00',13,64267,43807,NULL,NULL,NULL,'2025-07-16 01:24:36','2025-07-16 01:24:36'),
(3722,2,'credit',NULL,120000.0000,NULL,'2025-07-16 08:52:42',13,64154,43808,NULL,NULL,NULL,'2025-07-16 01:52:42','2025-07-16 01:52:42'),
(3723,2,'credit',NULL,25616000.0000,NULL,'2025-07-16 10:36:52',5,64270,43812,NULL,NULL,NULL,'2025-07-16 03:36:52','2025-07-17 13:37:52'),
(3724,2,'credit',NULL,6149000.0000,NULL,'2025-07-16 12:14:46',19,64289,43824,NULL,NULL,NULL,'2025-07-16 05:14:46','2025-07-30 05:50:33'),
(3725,2,'credit',NULL,80000.0000,NULL,'2025-07-16 13:22:51',6,64237,43826,NULL,NULL,NULL,'2025-07-16 06:22:51','2025-07-16 06:22:51'),
(3726,2,'credit',NULL,71000.0000,NULL,'2025-07-16 13:23:28',6,64293,43827,NULL,NULL,NULL,'2025-07-16 06:23:28','2025-07-16 06:23:28'),
(3727,2,'credit',NULL,950000.0000,NULL,'2025-07-16 15:03:43',106,64302,43830,NULL,NULL,NULL,'2025-07-16 08:03:43','2025-07-17 03:32:24'),
(3728,2,'credit',NULL,120000.0000,NULL,'2025-07-16 16:59:17',13,64117,43839,NULL,NULL,NULL,'2025-07-16 09:59:17','2025-07-16 09:59:17'),
(3729,2,'credit',NULL,138000.0000,NULL,'2025-07-16 16:59:26',13,64311,43840,NULL,NULL,NULL,'2025-07-16 09:59:26','2025-07-16 09:59:26'),
(3730,2,'credit',NULL,40000.0000,NULL,'2025-07-16 16:59:59',13,64286,43841,NULL,NULL,NULL,'2025-07-16 09:59:59','2025-07-16 09:59:59'),
(3731,2,'credit',NULL,1560000.0000,NULL,'2025-07-16 18:34:25',106,64317,43849,NULL,NULL,NULL,'2025-07-16 11:34:25','2025-07-16 11:34:25'),
(3732,2,'credit',NULL,80000.0000,NULL,'2025-07-17 09:29:18',3,64116,43866,NULL,NULL,NULL,'2025-07-17 02:29:18','2025-07-17 03:33:16'),
(3733,2,'credit',NULL,13390000.0000,NULL,'2025-07-17 10:32:24',3,64302,43872,NULL,NULL,NULL,'2025-07-17 03:32:24','2025-07-17 03:32:24'),
(3734,2,'debit',NULL,310000.0000,NULL,'2025-07-17 14:59:00',19,64383,43887,NULL,NULL,NULL,'2025-07-17 08:00:38','2025-07-17 08:00:38'),
(3735,2,'credit',NULL,597000.0000,NULL,'2025-07-17 16:27:08',3,64389,43896,NULL,NULL,NULL,'2025-07-17 09:27:08','2025-07-17 09:37:31'),
(3736,2,'debit',NULL,472000.0000,NULL,'2025-07-17 16:31:00',19,64393,43897,NULL,NULL,NULL,'2025-07-17 09:32:13','2025-07-17 09:32:13'),
(3737,2,'credit',NULL,87500.0000,NULL,'2025-07-17 16:37:01',3,64395,43899,NULL,NULL,NULL,'2025-07-17 09:37:01','2025-07-17 09:37:01'),
(3738,2,'credit',NULL,87500.0000,NULL,'2025-07-17 16:37:21',3,64396,43900,NULL,NULL,NULL,'2025-07-17 09:37:21','2025-07-17 09:37:21'),
(3739,2,'debit',NULL,620000.0000,NULL,'2025-07-17 18:40:00',106,64407,43908,NULL,NULL,NULL,'2025-07-17 11:41:32','2025-07-17 11:41:32'),
(3740,2,'credit',NULL,450000.0000,NULL,'2025-07-17 19:16:44',6,64411,43909,NULL,NULL,NULL,'2025-07-17 12:16:44','2025-07-17 12:16:44'),
(3741,2,'credit',NULL,2226000.0000,NULL,'2025-07-17 19:17:12',6,64406,43910,NULL,NULL,NULL,'2025-07-17 12:17:12','2025-07-29 13:53:29'),
(3742,2,'credit',NULL,240661.0000,NULL,'2025-07-18 11:53:21',5,61522,43933,NULL,NULL,NULL,'2025-07-18 04:53:21','2025-08-01 08:29:19'),
(3743,2,'debit',NULL,2287998.0000,NULL,'2025-07-18 12:05:00',1,63616,43936,NULL,NULL,NULL,'2025-07-18 05:06:10','2025-07-18 05:06:10'),
(3744,2,'debit',NULL,11293961.0000,NULL,'2025-07-18 12:08:00',1,63094,43937,NULL,NULL,NULL,'2025-07-18 05:08:26','2025-07-18 05:08:26'),
(3745,2,'debit',NULL,23944440.0000,NULL,'2025-07-18 12:14:00',1,63421,43938,NULL,NULL,NULL,'2025-07-18 05:14:53','2025-07-18 05:14:53'),
(3746,2,'debit',NULL,4792447.0000,NULL,'2025-07-18 12:28:00',1,64287,43939,NULL,NULL,NULL,'2025-07-18 05:28:32','2025-07-18 05:28:32'),
(3747,2,'debit',NULL,4800000.0000,NULL,'2025-07-18 12:28:00',1,64288,43940,NULL,NULL,NULL,'2025-07-18 05:28:48','2025-07-18 05:28:48'),
(3748,2,'debit',NULL,475000.0000,NULL,'2025-07-18 13:24:00',1,62789,43942,NULL,NULL,NULL,'2025-07-18 06:24:30','2025-07-18 06:24:30'),
(3749,2,'debit',NULL,6936000.0000,NULL,'2025-07-18 13:28:00',1,63153,43943,NULL,NULL,NULL,'2025-07-18 06:29:01','2025-07-18 06:29:01'),
(3750,2,'debit',NULL,5619200.0000,NULL,'2025-07-18 13:40:00',1,63210,43944,NULL,NULL,NULL,'2025-07-18 06:40:48','2025-07-18 06:40:48'),
(3751,2,'debit',NULL,33900.0000,NULL,'2025-07-18 13:44:00',1,63487,43945,NULL,NULL,NULL,'2025-07-18 06:44:38','2025-07-18 06:44:38'),
(3752,2,'debit',NULL,3595000.0000,NULL,'2025-07-18 13:45:00',1,63661,43946,NULL,NULL,NULL,'2025-07-18 06:45:20','2025-07-18 06:45:20'),
(3753,2,'debit',NULL,752000.0000,NULL,'2025-07-18 13:44:00',106,64446,43947,NULL,NULL,NULL,'2025-07-18 06:47:04','2025-07-18 06:47:04'),
(3754,2,'debit',NULL,856000.0000,NULL,'2025-07-18 13:55:00',13,64447,43948,NULL,NULL,'2025-07-31 05:47:27','2025-07-18 06:57:49','2025-07-31 05:47:27'),
(3755,2,'credit',NULL,35000.0000,NULL,'2025-07-18 15:05:41',5,64453,43950,NULL,NULL,NULL,'2025-07-18 08:05:41','2025-07-18 08:05:41'),
(3756,2,'debit',NULL,253000.0000,NULL,'2025-07-18 15:08:00',13,64455,43951,NULL,NULL,NULL,'2025-07-18 08:09:47','2025-07-18 08:09:47'),
(3757,2,'debit',NULL,3353000.0000,NULL,'2025-07-18 15:51:00',13,64464,43955,NULL,NULL,NULL,'2025-07-18 08:59:55','2025-07-18 08:59:55'),
(3758,2,'credit',NULL,198000.0000,NULL,'2025-07-18 16:35:20',6,64468,43956,NULL,NULL,NULL,'2025-07-18 09:35:20','2025-07-18 09:35:20'),
(3759,2,'debit',NULL,4331700.0000,NULL,'2025-07-18 17:44:00',13,64479,43958,NULL,NULL,NULL,'2025-07-18 10:45:31','2025-07-18 10:45:31'),
(3760,2,'debit',NULL,274300.0000,NULL,'2025-07-19 09:30:00',19,64500,43977,NULL,NULL,NULL,'2025-07-19 02:32:30','2025-07-19 02:32:30'),
(3761,2,'debit',NULL,4135197.0000,NULL,'2025-07-19 13:05:00',13,64513,43986,NULL,NULL,NULL,'2025-07-19 06:06:25','2025-07-19 06:06:25'),
(3762,2,'debit',NULL,1017000.0000,NULL,'2025-07-19 15:29:00',19,64524,43992,NULL,NULL,NULL,'2025-07-19 08:32:42','2025-07-19 08:32:42'),
(3763,2,'debit',NULL,404000.0000,NULL,'2025-07-19 16:50:00',13,64531,43999,NULL,NULL,NULL,'2025-07-19 09:55:31','2025-07-19 09:55:31'),
(3764,2,'debit',NULL,9750000.0000,NULL,'2025-07-19 23:39:00',1,63808,44013,NULL,NULL,NULL,'2025-07-19 16:39:47','2025-07-19 16:39:47'),
(3765,2,'debit',NULL,2112936.0000,NULL,'2025-07-19 23:43:00',1,63955,44014,NULL,NULL,NULL,'2025-07-19 16:43:43','2025-07-19 16:43:43'),
(3766,2,'debit',NULL,6765557.0000,NULL,'2025-07-19 23:49:00',1,63082,44015,NULL,NULL,NULL,'2025-07-19 16:49:44','2025-07-19 16:49:44'),
(3767,2,'credit',NULL,107000.0000,NULL,'2025-07-21 15:32:38',6,64617,44062,NULL,NULL,NULL,'2025-07-21 08:32:38','2025-07-21 08:32:38'),
(3768,2,'credit',NULL,150000.0000,NULL,'2025-07-21 15:45:03',5,64618,44063,NULL,NULL,NULL,'2025-07-21 08:45:03','2025-07-26 14:41:17'),
(3769,2,'credit',NULL,67000.0000,NULL,'2025-07-21 16:10:25',5,64620,44065,NULL,NULL,'2025-07-21 09:11:33','2025-07-21 09:10:25','2025-07-21 09:11:33'),
(3770,2,'debit',NULL,105045.0000,NULL,'2025-07-21 18:54:00',19,64638,44079,NULL,NULL,NULL,'2025-07-21 11:59:33','2025-07-21 11:59:33'),
(3771,2,'credit',NULL,300000.0000,NULL,'2025-07-21 19:52:32',13,64613,44082,NULL,NULL,NULL,'2025-07-21 12:52:32','2025-07-21 12:52:32'),
(3772,2,'credit',NULL,6066000.0000,NULL,'2025-07-21 20:41:00',19,64647,44087,NULL,NULL,NULL,'2025-07-21 13:56:38','2025-07-24 01:17:33'),
(3773,2,'credit',NULL,200000.0000,NULL,'2025-07-21 21:06:24',19,64635,44090,NULL,NULL,NULL,'2025-07-21 14:06:24','2025-09-04 11:38:49'),
(3774,2,'credit',NULL,231000.0000,NULL,'2025-07-22 09:28:19',106,64363,44094,NULL,NULL,NULL,'2025-07-22 02:28:19','2025-07-22 02:28:19'),
(3775,2,'credit',NULL,16610000.0000,NULL,'2025-07-22 11:29:39',106,64665,44102,NULL,NULL,NULL,'2025-07-22 04:29:39','2025-07-25 14:46:04'),
(3776,2,'credit',NULL,360000.0000,NULL,'2025-07-22 13:57:36',13,64678,44115,NULL,NULL,NULL,'2025-07-22 06:57:36','2025-07-22 06:57:36'),
(3777,2,'credit',NULL,220000.0000,NULL,'2025-07-22 14:36:05',106,64662,44117,NULL,NULL,NULL,'2025-07-22 07:36:05','2025-07-22 07:36:05'),
(3778,2,'credit',NULL,120000.0000,NULL,'2025-07-22 16:42:40',49,62973,44126,NULL,NULL,NULL,'2025-07-22 09:42:40','2025-07-22 09:42:40'),
(3779,2,'debit',NULL,14330920.0000,NULL,'2025-07-22 17:39:00',13,64707,44132,NULL,NULL,NULL,'2025-07-22 10:43:29','2025-07-22 10:43:29'),
(3780,2,'debit',NULL,186000.0000,NULL,'2025-07-22 17:57:00',13,64708,44135,NULL,NULL,NULL,'2025-07-22 10:59:46','2025-07-22 10:59:46'),
(3781,2,'credit',NULL,200000.0000,NULL,'2025-07-23 12:53:51',6,64754,44164,NULL,NULL,NULL,'2025-07-23 05:53:51','2025-08-06 01:26:31'),
(3782,2,'debit',NULL,62000.0000,NULL,'2025-07-23 13:36:00',19,64756,44166,NULL,NULL,NULL,'2025-07-23 06:37:19','2025-07-23 06:37:19'),
(3783,2,'credit',NULL,540000.0000,NULL,'2025-07-23 17:14:00',13,64680,44176,NULL,NULL,NULL,'2025-07-23 10:14:00','2025-07-23 10:14:00'),
(3784,2,'debit',NULL,2540000.0000,NULL,'2025-07-23 18:22:00',106,64772,44179,NULL,NULL,NULL,'2025-07-23 11:23:56','2025-07-23 11:23:56'),
(3785,2,'credit',NULL,300000.0000,NULL,'2025-07-24 11:48:59',6,64535,44199,NULL,NULL,NULL,'2025-07-24 04:48:59','2025-08-31 04:19:42'),
(3786,2,'credit',NULL,476000.0000,NULL,'2025-07-24 13:32:30',5,64800,44208,NULL,NULL,NULL,'2025-07-24 06:32:30','2025-07-28 14:46:01'),
(3787,2,'credit',NULL,185000.0000,NULL,'2025-07-24 15:32:02',13,64812,44213,NULL,NULL,NULL,'2025-07-24 08:32:02','2025-07-24 08:32:02'),
(3788,2,'credit',NULL,1300000.0000,NULL,'2025-07-24 15:32:30',13,64113,44214,NULL,NULL,NULL,'2025-07-24 08:32:30','2025-07-24 08:32:30'),
(3789,2,'credit',NULL,478000.0000,NULL,'2025-07-24 15:49:23',6,64816,44215,NULL,NULL,NULL,'2025-07-24 08:49:23','2025-07-24 08:49:23'),
(3790,2,'credit',NULL,2175000.0000,NULL,'2025-07-24 15:58:05',13,64814,44216,NULL,NULL,NULL,'2025-07-24 08:58:05','2025-07-24 09:05:14'),
(3791,2,'credit',NULL,39397000.0000,NULL,'2025-07-24 16:33:26',5,64467,44217,NULL,NULL,NULL,'2025-07-24 09:33:26','2025-07-24 09:33:26'),
(3792,2,'credit',NULL,68000.0000,NULL,'2025-07-24 16:36:11',5,64589,44218,NULL,NULL,NULL,'2025-07-24 09:36:11','2025-07-24 09:36:11'),
(3793,2,'credit',NULL,29000.0000,NULL,'2025-07-24 16:44:19',5,64820,44219,NULL,NULL,NULL,'2025-07-24 09:44:19','2025-07-24 09:44:19'),
(3794,2,'debit',NULL,69000.0000,NULL,'2025-07-25 09:14:00',6,64847,44242,NULL,NULL,NULL,'2025-07-25 02:15:53','2025-07-25 02:15:53'),
(3795,2,'debit',NULL,66000.0000,NULL,'2025-07-25 16:33:00',3,64878,44257,NULL,NULL,NULL,'2025-07-25 09:37:17','2025-07-25 09:37:17'),
(3796,2,'debit',NULL,197000.0000,NULL,'2025-07-26 10:20:00',6,64907,44273,NULL,NULL,NULL,'2025-07-26 03:23:34','2025-07-26 03:23:34'),
(3797,2,'credit',NULL,618000.0000,NULL,'2025-07-26 11:39:25',49,64908,44278,NULL,NULL,NULL,'2025-07-26 04:39:25','2025-07-26 05:09:42'),
(3798,2,'credit',NULL,87500.0000,NULL,'2025-07-26 12:09:57',3,64920,44281,NULL,NULL,NULL,'2025-07-26 05:09:57','2025-07-26 05:09:57'),
(3799,2,'credit',NULL,87500.0000,NULL,'2025-07-26 12:10:13',3,64921,44282,NULL,NULL,NULL,'2025-07-26 05:10:13','2025-07-26 05:10:13'),
(3800,2,'debit',NULL,150000.0000,NULL,'2025-07-26 12:27:00',49,64922,44283,NULL,NULL,NULL,'2025-07-26 05:28:18','2025-07-26 05:28:18'),
(3801,2,'credit',NULL,200000.0000,NULL,'2025-07-26 12:57:01',3,64926,44289,NULL,NULL,NULL,'2025-07-26 05:57:01','2025-07-26 05:57:01'),
(3802,2,'credit',NULL,200000.0000,NULL,'2025-07-26 12:57:06',3,64927,44290,NULL,NULL,NULL,'2025-07-26 05:57:06','2025-07-26 05:57:06'),
(3803,2,'credit',NULL,10100000.0000,NULL,'2025-07-26 17:16:44',106,64948,44297,NULL,NULL,NULL,'2025-07-26 10:31:54','2025-07-26 12:44:56'),
(3804,2,'credit',NULL,1000000.0000,NULL,'2025-07-26 18:15:13',5,64954,44302,NULL,NULL,NULL,'2025-07-26 11:15:13','2025-07-26 11:15:13'),
(3805,2,'credit',NULL,200000.0000,NULL,'2025-07-26 18:19:11',5,64919,44304,NULL,NULL,NULL,'2025-07-26 11:19:11','2025-07-26 11:19:11'),
(3806,2,'credit',NULL,200000.0000,NULL,'2025-07-26 18:23:12',5,64918,44306,NULL,NULL,NULL,'2025-07-26 11:23:12','2025-07-26 11:23:12'),
(3807,2,'credit',NULL,395000.0000,NULL,'2025-07-26 18:24:09',5,64955,44307,NULL,NULL,NULL,'2025-07-26 11:24:09','2025-07-26 11:24:09'),
(3808,2,'credit',NULL,318000.0000,NULL,'2025-07-26 18:20:17',5,64618,44305,NULL,NULL,NULL,'2025-07-26 11:24:36','2025-07-26 14:41:17'),
(3809,2,'credit',NULL,44000.0000,NULL,'2025-07-26 19:00:48',5,64956,44308,NULL,NULL,NULL,'2025-07-26 12:00:48','2025-07-26 12:00:48'),
(3810,2,'debit',NULL,581000.0000,NULL,'2025-07-26 19:20:00',19,64957,44309,NULL,NULL,NULL,'2025-07-26 12:26:00','2025-07-26 12:26:00'),
(3811,2,'credit',NULL,200000.0000,NULL,'2025-07-26 21:49:54',19,64823,44317,NULL,NULL,NULL,'2025-07-26 14:49:54','2025-07-29 06:37:44'),
(3812,2,'debit',NULL,441000.0000,NULL,'2025-07-27 09:33:00',13,64961,44319,NULL,NULL,NULL,'2025-07-27 02:34:50','2025-07-27 02:34:50'),
(3813,2,'debit',NULL,239500.0000,NULL,'2025-07-27 11:44:00',19,64967,44324,NULL,NULL,NULL,'2025-07-27 04:45:49','2025-07-27 04:45:49'),
(3814,2,'debit',NULL,933600.0000,NULL,'2025-07-27 16:25:00',49,64983,44337,NULL,NULL,NULL,'2025-07-27 09:28:22','2025-07-27 09:28:22'),
(3815,2,'credit',NULL,10100000.0000,NULL,'2025-07-27 16:57:50',19,64987,44341,NULL,NULL,NULL,'2025-07-27 09:57:50','2025-07-27 09:57:50'),
(3816,2,'credit',NULL,0.0000,NULL,'2025-07-27 20:19:12',106,64950,44350,NULL,NULL,NULL,'2025-07-27 13:19:12','2025-11-30 08:51:26'),
(3817,2,'debit',NULL,755000.0000,NULL,'2025-07-28 10:08:00',13,65011,44358,NULL,NULL,NULL,'2025-07-28 03:11:00','2025-07-28 03:11:00'),
(3818,2,'credit',NULL,389000.0000,NULL,'2025-07-28 11:44:14',143,65019,44362,NULL,NULL,NULL,'2025-07-28 04:44:14','2025-07-28 04:44:14'),
(3819,2,'credit',NULL,300000.0000,NULL,'2025-07-28 11:45:13',143,64942,44363,NULL,NULL,NULL,'2025-07-28 04:45:13','2025-07-28 04:45:13'),
(3820,2,'credit',NULL,49000.0000,NULL,'2025-07-28 14:32:26',49,65031,44372,NULL,NULL,NULL,'2025-07-28 07:32:26','2025-07-28 07:32:26'),
(3821,2,'credit',NULL,100000.0000,NULL,'2025-07-28 14:36:17',19,64873,44373,NULL,NULL,NULL,'2025-07-28 07:36:17','2025-07-28 07:37:06'),
(3822,2,'debit',NULL,123000.0000,NULL,'2025-07-28 14:43:00',49,65036,44378,NULL,NULL,NULL,'2025-07-28 08:03:33','2025-07-28 08:03:33'),
(3823,2,'debit',NULL,210000.0000,NULL,'2025-07-28 15:57:00',49,65045,44384,NULL,NULL,NULL,'2025-07-28 09:00:53','2025-07-28 09:00:53'),
(3824,2,'credit',NULL,115000.0000,NULL,'2025-07-28 16:13:44',13,65048,44385,NULL,NULL,NULL,'2025-07-28 09:13:44','2025-07-28 09:13:44'),
(3825,2,'credit',NULL,200000.0000,NULL,'2025-07-28 17:23:29',6,65003,44391,NULL,NULL,NULL,'2025-07-28 10:23:29','2025-08-30 06:27:28'),
(3826,2,'credit',NULL,615000.0000,NULL,'2025-07-28 17:50:52',106,65049,44393,NULL,NULL,NULL,'2025-07-28 10:50:52','2025-08-01 08:43:29'),
(3827,2,'credit',NULL,476000.0000,NULL,'2025-07-28 19:06:15',106,64800,44396,NULL,NULL,NULL,'2025-07-28 12:06:15','2025-07-28 14:46:01'),
(3828,2,'credit',NULL,150000.0000,NULL,'2025-07-28 19:07:14',106,64539,44397,NULL,NULL,NULL,'2025-07-28 12:07:14','2025-07-28 12:07:14'),
(3829,2,'credit',NULL,1475000.0000,NULL,'2025-07-28 19:07:37',6,65030,44398,NULL,NULL,NULL,'2025-07-28 12:07:37','2025-07-28 14:36:12'),
(3830,2,'credit',NULL,140000.0000,NULL,'2025-07-28 19:59:37',106,65062,44403,NULL,NULL,NULL,'2025-07-28 12:59:37','2025-07-28 12:59:37'),
(3831,2,'credit',NULL,89000.0000,NULL,'2025-07-29 11:15:06',5,65076,44417,NULL,NULL,NULL,'2025-07-29 04:15:06','2025-07-29 04:15:06'),
(3832,2,'credit',NULL,185000.0000,NULL,'2025-07-29 13:49:14',6,65083,44424,NULL,NULL,NULL,'2025-07-29 06:49:14','2025-07-29 06:49:14'),
(3833,2,'credit',NULL,160000.0000,NULL,'2025-07-29 13:49:29',6,65000,44425,NULL,NULL,NULL,'2025-07-29 06:49:29','2025-07-29 06:49:29'),
(3834,2,'debit',NULL,185000.0000,NULL,'2025-07-29 14:38:00',49,65090,44427,NULL,NULL,NULL,'2025-07-29 07:39:53','2025-07-29 07:39:53'),
(3835,2,'debit',NULL,273000.0000,NULL,'2025-07-29 14:40:00',49,65091,44428,NULL,NULL,NULL,'2025-07-29 07:45:58','2025-07-29 07:45:58'),
(3836,2,'credit',NULL,1175000.0000,NULL,'2025-07-29 17:01:00',5,65104,44436,NULL,NULL,NULL,'2025-07-29 10:01:00','2025-08-01 08:40:20'),
(3837,2,'credit',NULL,300000.0000,NULL,'2025-07-29 20:41:13',6,65116,44447,NULL,NULL,NULL,'2025-07-29 13:41:13','2025-07-29 13:41:13'),
(3838,2,'credit',NULL,350000.0000,NULL,'2025-07-29 20:44:11',6,65117,44448,NULL,NULL,NULL,'2025-07-29 13:44:11','2025-07-29 13:44:11'),
(3839,2,'credit',NULL,350000.0000,NULL,'2025-07-29 20:44:36',6,65118,44449,NULL,NULL,NULL,'2025-07-29 13:44:36','2025-07-29 13:44:36'),
(3840,2,'credit',NULL,175000.0000,NULL,'2025-07-29 20:46:08',6,65121,44453,NULL,NULL,NULL,'2025-07-29 13:46:08','2025-07-29 13:46:08'),
(3841,2,'credit',NULL,250000.0000,NULL,'2025-07-29 20:49:50',6,65124,44458,NULL,NULL,NULL,'2025-07-29 13:49:50','2025-07-29 13:49:50'),
(3842,2,'credit',NULL,175000.0000,NULL,'2025-07-29 20:52:41',6,65126,44461,NULL,NULL,NULL,'2025-07-29 13:52:41','2025-07-29 13:52:41'),
(3843,2,'credit',NULL,175000.0000,NULL,'2025-07-29 20:53:09',6,65127,44462,NULL,NULL,NULL,'2025-07-29 13:53:09','2025-07-29 13:53:09'),
(3844,2,'credit',NULL,310000.0000,NULL,'2025-07-29 21:31:47',106,65132,44470,NULL,NULL,NULL,'2025-07-29 14:39:46','2025-07-29 14:39:46'),
(3845,2,'credit',NULL,156500.0000,NULL,'2025-07-30 09:17:28',19,65135,44473,NULL,NULL,NULL,'2025-07-30 02:17:28','2025-07-30 02:17:28'),
(3846,2,'credit',NULL,275000.0000,NULL,'2025-07-30 09:31:30',19,64931,44474,NULL,NULL,NULL,'2025-07-30 02:31:30','2025-07-30 03:54:03'),
(3847,2,'credit',NULL,569000.0000,NULL,'2025-07-30 09:57:41',5,65138,44478,NULL,NULL,NULL,'2025-07-30 02:57:41','2025-07-30 02:57:41'),
(3848,2,'credit',NULL,222000.0000,NULL,'2025-07-30 09:42:28',5,65136,44476,NULL,NULL,NULL,'2025-07-30 02:58:28','2025-07-30 02:58:28'),
(3849,2,'credit',NULL,275000.0000,NULL,'2025-07-30 10:54:34',19,65143,44479,NULL,NULL,NULL,'2025-07-30 03:54:34','2025-07-30 03:54:34'),
(3850,2,'credit',NULL,50000.0000,NULL,'2025-07-30 11:42:40',5,65148,44482,NULL,NULL,NULL,'2025-07-30 04:42:40','2025-07-30 04:42:55'),
(3851,2,'credit',NULL,45000.0000,NULL,'2025-07-30 11:43:19',5,65149,44483,NULL,NULL,NULL,'2025-07-30 04:43:19','2025-07-30 04:43:19'),
(3852,2,'credit',NULL,100000.0000,NULL,'2025-07-30 12:50:15',19,65153,44485,NULL,NULL,NULL,'2025-07-30 05:50:15','2025-07-30 05:50:15'),
(3853,2,'credit',NULL,218000.0000,NULL,'2025-07-30 17:32:58',106,65170,44494,NULL,NULL,NULL,'2025-07-30 10:32:58','2025-07-30 10:32:58'),
(3854,2,'credit',NULL,54000.0000,NULL,'2025-07-30 19:11:18',106,65181,44497,NULL,NULL,NULL,'2025-07-30 12:11:18','2025-07-30 12:11:18'),
(3855,2,'credit',NULL,120000.0000,NULL,'2025-07-30 21:03:42',6,64999,44503,NULL,NULL,NULL,'2025-07-30 14:03:42','2025-07-30 14:03:42'),
(3856,2,'credit',NULL,295000.0000,NULL,'2025-07-30 21:03:52',6,65190,44504,NULL,NULL,NULL,'2025-07-30 14:03:52','2025-07-30 14:03:52'),
(3857,2,'credit',NULL,18000.0000,NULL,'2025-07-30 21:16:13',106,65191,44505,NULL,NULL,NULL,'2025-07-30 14:16:13','2025-07-30 14:16:13'),
(3858,2,'credit',NULL,300000.0000,NULL,'2025-07-31 09:42:51',19,65206,44522,NULL,NULL,NULL,'2025-07-31 02:42:51','2025-07-31 02:42:51'),
(3859,2,'credit',NULL,1106000.0000,NULL,'2025-07-31 10:44:19',5,65208,44523,NULL,NULL,NULL,'2025-07-31 03:44:19','2025-07-31 13:48:53'),
(3860,2,'credit',NULL,168200.0000,NULL,'2025-07-31 13:43:30',19,65218,44531,NULL,NULL,NULL,'2025-07-31 06:43:30','2025-07-31 06:43:30'),
(3861,2,'credit',NULL,218000.0000,NULL,'2025-07-31 14:20:30',19,65222,44535,NULL,NULL,NULL,'2025-07-31 07:20:30','2025-07-31 07:20:30'),
(3862,2,'credit',NULL,130000.0000,NULL,'2025-07-31 16:28:37',19,65228,44538,NULL,NULL,NULL,'2025-07-31 09:28:37','2025-07-31 09:28:37'),
(3863,2,'credit',NULL,379000.0000,NULL,'2025-07-31 17:01:16',5,65230,44540,NULL,NULL,NULL,'2025-07-31 10:01:16','2025-07-31 10:09:06'),
(3864,2,'credit',NULL,280000.0000,NULL,'2025-07-31 17:01:30',5,64798,44541,NULL,NULL,NULL,'2025-07-31 10:01:30','2025-07-31 10:01:30'),
(3865,2,'debit',NULL,370000.0000,NULL,'2025-07-31 19:15:00',106,65235,44546,NULL,NULL,NULL,'2025-07-31 12:16:27','2025-07-31 12:16:27'),
(3866,2,'debit',NULL,1200000.0000,NULL,'2025-07-31 19:16:00',106,65236,44547,NULL,NULL,NULL,'2025-07-31 12:23:23','2025-07-31 12:23:23'),
(3867,2,'credit',NULL,100000.0000,NULL,'2025-07-31 20:49:06',3,65209,44551,NULL,NULL,NULL,'2025-07-31 13:49:06','2025-07-31 13:49:06'),
(3868,2,'credit',NULL,290000.0000,NULL,'2025-07-31 20:50:20',49,63991,44552,NULL,NULL,NULL,'2025-07-31 13:50:20','2025-07-31 13:50:20'),
(3869,2,'credit',NULL,550000.0000,NULL,'2025-07-31 20:50:23',49,65245,44553,NULL,NULL,NULL,'2025-07-31 13:50:23','2025-07-31 13:50:23'),
(3870,2,'credit',NULL,200000.0000,NULL,'2025-07-31 20:56:24',19,65247,44555,NULL,NULL,NULL,'2025-07-31 13:56:24','2025-07-31 14:00:05'),
(3871,2,'credit',NULL,5696000.0000,NULL,'2025-08-01 09:05:49',19,65250,44562,NULL,NULL,NULL,'2025-08-01 02:05:49','2025-08-01 02:05:49'),
(3872,2,'debit',NULL,193000.0000,NULL,'2025-08-01 09:30:00',19,65252,44563,NULL,NULL,NULL,'2025-08-01 02:33:03','2025-08-01 02:33:03'),
(3873,2,'debit',NULL,59000.0000,NULL,'2025-08-01 10:18:00',19,65254,44565,NULL,NULL,NULL,'2025-08-01 03:20:47','2025-08-01 03:20:47'),
(3874,2,'credit',NULL,80000.0000,NULL,'2025-08-01 11:10:26',19,65006,44569,NULL,NULL,NULL,'2025-08-01 04:10:26','2025-08-01 04:10:26'),
(3875,2,'credit',NULL,40000.0000,NULL,'2025-08-01 15:28:47',5,65274,44596,NULL,NULL,NULL,'2025-08-01 08:28:47','2025-08-01 08:47:23'),
(3876,2,'credit',NULL,40000.0000,NULL,'2025-08-01 15:29:11',5,65275,44597,NULL,NULL,NULL,'2025-08-01 08:29:11','2025-08-01 08:47:04'),
(3877,2,'debit',NULL,391900.0000,NULL,'2025-08-01 15:30:00',13,65278,44601,NULL,NULL,NULL,'2025-08-01 08:32:51','2025-08-01 08:32:51'),
(3878,2,'credit',NULL,262500.0000,NULL,'2025-08-01 15:39:10',5,65283,44606,NULL,NULL,NULL,'2025-08-01 08:40:32','2025-08-01 08:44:01'),
(3879,2,'credit',NULL,262500.0000,NULL,'2025-08-01 15:38:32',5,65282,44605,NULL,NULL,NULL,'2025-08-01 08:40:45','2025-08-01 08:44:14'),
(3880,2,'credit',NULL,80000.0000,NULL,'2025-08-01 15:43:18',5,65286,44608,NULL,NULL,NULL,'2025-08-01 08:43:18','2025-08-01 08:43:18'),
(3881,2,'credit',NULL,907000.0000,NULL,'2025-08-01 16:49:36',5,65291,44612,NULL,NULL,NULL,'2025-08-01 09:49:36','2025-08-31 07:49:11'),
(3882,2,'debit',NULL,900000.0000,NULL,'2025-08-01 16:49:00',13,65294,44613,NULL,NULL,NULL,'2025-08-01 09:50:43','2025-08-01 09:50:43'),
(3883,2,'credit',NULL,500000.0000,NULL,'2025-08-01 16:52:37',13,65295,44614,NULL,NULL,NULL,'2025-08-01 09:52:37','2025-08-02 03:29:32'),
(3884,2,'debit',NULL,110000.0000,NULL,'2025-08-01 17:54:00',49,65303,44620,NULL,NULL,NULL,'2025-08-01 10:56:20','2025-08-01 10:56:20'),
(3885,2,'credit',NULL,500000.0000,NULL,'2025-08-02 10:29:32',13,65295,44627,NULL,NULL,NULL,'2025-08-02 03:29:32','2025-08-02 03:29:32'),
(3886,2,'debit',NULL,1346800.0000,NULL,'2025-08-02 11:23:00',13,65330,44629,NULL,NULL,NULL,'2025-08-02 04:25:09','2025-08-02 04:25:09'),
(3887,2,'credit',NULL,208000.0000,NULL,'2025-08-02 12:28:03',5,65332,44652,NULL,NULL,NULL,'2025-08-02 05:28:03','2025-08-02 10:03:53'),
(3888,2,'debit',NULL,74400.0000,NULL,'2025-08-02 14:54:00',106,65344,44659,NULL,NULL,NULL,'2025-08-02 08:01:02','2025-08-02 08:01:02'),
(3889,2,'debit',NULL,180500.0000,NULL,'2025-08-02 16:24:00',19,65353,44666,NULL,NULL,NULL,'2025-08-02 09:27:51','2025-08-02 09:27:51'),
(3890,2,'credit',NULL,650000.0000,NULL,'2025-08-02 16:39:35',13,65340,44668,NULL,NULL,NULL,'2025-08-02 09:39:35','2025-08-02 09:39:35'),
(3891,2,'credit',NULL,5270000.0000,NULL,'2025-08-02 20:28:16',6,65110,44672,NULL,NULL,NULL,'2025-08-02 13:28:16','2025-08-31 04:57:16'),
(3892,2,'debit',NULL,124700.0000,NULL,'2025-08-03 14:43:00',6,65375,44686,NULL,NULL,NULL,'2025-08-03 07:45:33','2025-08-03 07:45:33'),
(3893,2,'debit',NULL,465000.0000,NULL,'2025-08-03 15:37:00',19,65377,44687,NULL,NULL,NULL,'2025-08-03 08:41:18','2025-08-03 08:41:18'),
(3894,2,'credit',NULL,150000.0000,NULL,'2025-08-03 17:26:38',19,64802,44691,NULL,NULL,NULL,'2025-08-03 10:26:38','2025-08-03 10:26:38'),
(3895,2,'credit',NULL,934000.0000,NULL,'2025-08-03 17:28:35',19,65388,44692,NULL,NULL,NULL,'2025-08-03 10:28:35','2025-09-01 07:29:58'),
(3896,2,'credit',NULL,200000.0000,NULL,'2025-08-04 10:35:04',6,65320,44703,NULL,NULL,NULL,'2025-08-04 03:35:04','2025-08-30 06:27:45'),
(3897,2,'credit',NULL,150000.0000,NULL,'2025-08-04 14:22:25',6,65425,44717,NULL,NULL,NULL,'2025-08-04 07:22:25','2025-08-06 01:43:58'),
(3898,2,'credit',NULL,1000000.0000,NULL,'2025-08-04 14:35:58',6,64189,44718,NULL,NULL,NULL,'2025-08-04 07:35:58','2025-08-30 05:33:39'),
(3899,2,'credit',NULL,200000.0000,NULL,'2025-08-04 15:18:38',6,64305,44721,NULL,NULL,NULL,'2025-08-04 08:18:38','2025-11-04 10:59:22'),
(3900,2,'credit',NULL,5600000.0000,NULL,'2025-08-04 16:57:06',5,65445,44725,NULL,NULL,NULL,'2025-08-04 10:12:43','2025-08-04 10:12:43'),
(3901,2,'credit',NULL,135000.0000,NULL,'2025-08-05 10:36:15',49,65256,44752,NULL,NULL,NULL,'2025-08-05 03:36:15','2025-08-05 03:36:15'),
(3902,2,'credit',NULL,333000.0000,NULL,'2025-08-05 10:36:24',49,65471,44753,NULL,NULL,NULL,'2025-08-05 03:36:24','2025-08-05 03:36:24'),
(3903,2,'debit',NULL,4915000.0000,NULL,'2025-08-05 13:47:00',1,64295,44759,NULL,NULL,NULL,'2025-08-05 06:47:57','2025-08-05 06:47:57'),
(3904,2,'debit',NULL,5400000.0000,NULL,'2025-08-05 13:59:00',1,64615,44760,NULL,NULL,NULL,'2025-08-05 06:59:10','2025-08-05 06:59:10'),
(3905,2,'debit',NULL,17175000.0000,NULL,'2025-08-05 14:03:00',1,64581,44761,NULL,NULL,NULL,'2025-08-05 07:03:09','2025-08-05 07:03:09'),
(3906,2,'debit',NULL,2535000.0000,NULL,'2025-08-05 14:11:00',1,64466,44762,NULL,NULL,NULL,'2025-08-05 07:11:34','2025-08-05 07:11:34'),
(3907,2,'debit',NULL,2330916.0000,NULL,'2025-08-05 14:12:00',1,63193,44763,NULL,NULL,NULL,'2025-08-05 07:13:00','2025-08-05 07:13:00'),
(3908,2,'debit',NULL,10789900.0000,NULL,'2025-08-05 14:15:00',1,64297,44764,NULL,NULL,NULL,'2025-08-05 07:15:50','2025-08-05 07:15:50'),
(3909,2,'debit',NULL,1426660.0000,NULL,'2025-08-05 14:18:00',1,64866,44765,NULL,NULL,NULL,'2025-08-05 07:18:40','2025-08-05 07:18:40'),
(3910,2,'debit',NULL,100667000.0000,NULL,'2025-08-05 14:25:00',1,64824,44766,NULL,NULL,NULL,'2025-08-05 07:26:00','2025-08-05 07:26:00'),
(3911,2,'debit',NULL,40065000.0000,NULL,'2025-08-05 14:53:00',1,63067,44767,NULL,NULL,NULL,'2025-08-05 07:54:02','2025-08-05 07:54:02'),
(3912,2,'debit',NULL,4950015.0000,NULL,'2025-08-05 15:22:00',1,64717,44768,NULL,NULL,NULL,'2025-08-05 08:22:41','2025-08-05 08:22:41'),
(3913,2,'debit',NULL,151900.0000,NULL,'2025-08-05 19:24:00',13,65505,44780,NULL,NULL,NULL,'2025-08-05 12:25:18','2025-08-05 12:25:18'),
(3914,2,'credit',NULL,33000.0000,NULL,'2025-08-05 20:53:05',13,65510,44786,NULL,NULL,NULL,'2025-08-05 13:53:05','2025-08-05 13:53:05'),
(3915,2,'debit',NULL,11344000.0000,NULL,'2025-08-05 21:41:00',13,65511,44788,NULL,NULL,'2025-09-20 02:34:39','2025-08-05 14:44:06','2025-09-20 02:34:39'),
(3916,2,'debit',NULL,9715049.0000,NULL,'2025-08-05 21:44:00',13,65512,44789,NULL,NULL,NULL,'2025-08-05 14:49:22','2025-08-05 14:49:22'),
(3917,2,'debit',NULL,11404057.0000,NULL,'2025-08-06 13:12:00',13,65535,44810,NULL,NULL,NULL,'2025-08-06 06:17:15','2025-08-18 15:15:16'),
(3918,2,'debit',NULL,190000.0000,NULL,'2025-08-06 14:28:00',13,65546,44813,NULL,NULL,NULL,'2025-08-06 07:29:36','2025-08-06 07:29:36'),
(3919,2,'credit',NULL,300000.0000,NULL,'2025-08-06 14:48:44',6,64305,44815,NULL,NULL,NULL,'2025-08-06 07:48:44','2025-11-04 10:59:22'),
(3920,2,'credit',NULL,120000.0000,NULL,'2025-08-06 15:15:16',6,65128,44818,NULL,NULL,NULL,'2025-08-06 08:15:16','2025-08-06 08:15:16'),
(3921,2,'credit',NULL,345000.0000,NULL,'2025-08-06 15:15:43',6,65553,44819,NULL,NULL,NULL,'2025-08-06 08:15:43','2025-08-06 08:15:43'),
(3922,2,'debit',NULL,11479500.0000,NULL,'2025-08-06 15:51:00',13,65557,44823,NULL,NULL,NULL,'2025-08-06 08:55:05','2025-08-06 08:55:05'),
(3923,2,'credit',NULL,250000.0000,NULL,'2025-08-06 20:09:25',13,65572,44839,NULL,NULL,NULL,'2025-08-06 13:09:25','2025-08-09 07:25:49'),
(3924,2,'debit',NULL,238000.0000,NULL,'2025-08-06 20:18:00',13,65579,44841,NULL,NULL,NULL,'2025-08-06 13:19:43','2025-08-06 13:19:43'),
(3925,2,'credit',NULL,1270000.0000,NULL,'2025-08-07 09:25:36',49,65105,44856,NULL,NULL,'2025-08-07 02:25:46','2025-08-07 02:25:36','2025-08-07 02:25:46'),
(3926,2,'credit',NULL,1270000.0000,NULL,'2025-08-07 09:25:46',49,65105,44857,NULL,NULL,NULL,'2025-08-07 02:25:46','2025-08-07 09:05:38'),
(3927,2,'credit',NULL,80000.0000,NULL,'2025-08-07 11:06:24',6,65539,44866,NULL,NULL,NULL,'2025-08-07 04:06:24','2025-08-07 04:06:24'),
(3928,2,'credit',NULL,3765000.0000,NULL,'2025-08-07 11:33:48',106,65598,44867,NULL,NULL,NULL,'2025-08-07 04:33:48','2025-08-07 04:33:48'),
(3929,2,'credit',NULL,200000.0000,NULL,'2025-08-07 16:53:34',106,65569,44879,NULL,NULL,NULL,'2025-08-07 09:53:34','2025-08-18 11:09:31'),
(3930,2,'debit',NULL,483132.0000,NULL,'2025-08-07 19:09:00',19,65637,44886,NULL,NULL,'2025-09-22 07:45:46','2025-08-07 12:11:02','2025-09-22 07:45:46'),
(3931,2,'credit',NULL,190000.0000,NULL,'2025-08-07 20:26:27',5,65632,44893,NULL,NULL,NULL,'2025-08-07 13:26:27','2025-08-31 07:57:48'),
(3932,2,'credit',NULL,1000000.0000,NULL,'2025-08-07 21:46:00',19,65629,44897,NULL,NULL,NULL,'2025-08-07 14:46:38','2025-08-30 05:47:43'),
(3933,2,'debit',NULL,620325.0000,NULL,'2025-08-08 12:34:00',19,65669,44909,NULL,NULL,NULL,'2025-08-08 05:35:39','2025-08-26 06:42:52'),
(3934,2,'credit',NULL,1312000.0000,NULL,'2025-08-08 13:09:00',19,65656,44913,NULL,NULL,NULL,'2025-08-08 06:09:40','2025-08-08 06:09:40'),
(3935,2,'debit',NULL,2192000.0000,NULL,'2025-08-08 13:24:00',19,65676,44916,NULL,NULL,NULL,'2025-08-08 06:25:58','2025-08-08 06:25:58'),
(3936,2,'credit',NULL,152000.0000,NULL,'2025-08-08 13:56:46',106,65655,44919,NULL,NULL,NULL,'2025-08-08 06:56:46','2025-08-08 06:56:46'),
(3937,2,'debit',NULL,1180000.0000,NULL,'2025-08-08 15:14:00',49,65682,44924,NULL,NULL,NULL,'2025-08-08 08:19:44','2025-08-08 08:19:44'),
(3938,2,'debit',NULL,2480000.0000,NULL,'2025-08-08 19:45:00',19,65705,44942,NULL,NULL,NULL,'2025-08-08 12:46:22','2025-08-08 12:46:22'),
(3939,2,'credit',NULL,6408000.0000,NULL,'2025-08-08 19:49:00',19,65660,44943,NULL,NULL,NULL,'2025-08-08 12:49:00','2025-08-08 12:49:00'),
(3940,2,'credit',NULL,200000.0000,NULL,'2025-08-09 11:26:42',49,65537,44955,NULL,NULL,NULL,'2025-08-09 04:26:42','2025-08-09 05:53:48'),
(3941,2,'credit',NULL,2427000.0000,NULL,'2025-08-09 12:53:52',49,65726,44959,NULL,NULL,NULL,'2025-08-09 05:53:52','2025-08-09 05:53:52'),
(3942,2,'debit',NULL,151900.0000,NULL,'2025-08-09 14:12:00',19,65730,44962,NULL,NULL,NULL,'2025-08-09 07:14:48','2025-08-09 07:14:48'),
(3943,2,'debit',NULL,778200.0000,NULL,'2025-08-09 14:24:00',13,65731,44963,NULL,NULL,NULL,'2025-08-09 07:25:19','2025-08-09 07:25:19'),
(3944,2,'credit',NULL,500000.0000,NULL,'2025-08-09 14:25:49',143,65572,44964,NULL,NULL,NULL,'2025-08-09 07:25:49','2025-08-09 07:25:49'),
(3945,2,'credit',NULL,2000000.0000,NULL,'2025-08-09 14:29:00',19,64189,44965,NULL,NULL,NULL,'2025-08-09 07:29:37','2025-08-30 05:33:39'),
(3946,2,'debit',NULL,546642.0000,NULL,'2025-08-09 14:30:00',5,65732,44966,NULL,NULL,NULL,'2025-08-09 07:31:51','2025-08-09 07:31:51'),
(3947,2,'debit',NULL,182214.0000,NULL,'2025-08-09 14:33:00',5,65733,44967,NULL,NULL,NULL,'2025-08-09 07:33:52','2025-08-09 07:33:52'),
(3948,2,'credit',NULL,102000.0000,NULL,'2025-08-09 14:56:29',19,65738,44968,NULL,NULL,NULL,'2025-08-09 07:56:30','2025-08-09 07:56:30'),
(3949,2,'debit',NULL,602500.0000,NULL,'2025-08-09 16:06:00',1,65596,44972,NULL,NULL,NULL,'2025-08-09 09:06:26','2025-08-09 09:06:26'),
(3950,2,'credit',NULL,240000.0000,NULL,'2025-08-09 16:50:03',10,65606,44975,NULL,NULL,NULL,'2025-08-09 09:50:03','2025-08-09 09:50:03'),
(3951,2,'credit',NULL,1525000.0000,NULL,'2025-08-09 16:50:14',10,65748,44976,NULL,NULL,NULL,'2025-08-09 09:50:14','2025-08-09 09:50:14'),
(3952,2,'debit',NULL,177155000.0000,NULL,'2025-08-09 16:51:00',1,65747,44977,NULL,NULL,NULL,'2025-08-09 09:52:01','2025-08-09 09:52:01'),
(3953,2,'debit',NULL,135000.0000,NULL,'2025-08-09 18:14:00',19,65758,44984,NULL,NULL,NULL,'2025-08-09 11:17:10','2025-08-09 11:17:10'),
(3954,2,'debit',NULL,164000.0000,NULL,'2025-08-09 18:17:00',19,65759,44985,NULL,NULL,NULL,'2025-08-09 11:17:54','2025-08-09 11:17:54'),
(3955,2,'credit',NULL,2000000.0000,NULL,'2025-08-09 18:22:29',19,65750,44986,NULL,NULL,NULL,'2025-08-09 11:22:29','2025-08-30 05:54:25'),
(3956,2,'credit',NULL,200000.0000,NULL,'2025-08-09 21:53:41',13,65756,44990,NULL,NULL,NULL,'2025-08-09 14:53:41','2025-10-28 12:02:24'),
(3957,2,'debit',NULL,8592420.0000,NULL,'2025-08-10 21:47:00',49,65802,45022,NULL,NULL,NULL,'2025-08-10 14:56:45','2025-08-10 14:56:45'),
(3958,2,'credit',NULL,656000.0000,NULL,'2025-08-11 10:07:00',19,65812,45025,NULL,NULL,NULL,'2025-08-11 03:07:40','2025-08-11 03:07:40'),
(3959,2,'credit',NULL,972000.0000,NULL,'2025-08-11 12:40:08',5,65821,45028,NULL,NULL,NULL,'2025-08-11 05:40:08','2025-08-11 05:40:08'),
(3960,2,'debit',NULL,110000.0000,NULL,'2025-08-11 13:54:00',19,65829,45035,NULL,NULL,NULL,'2025-08-11 06:54:37','2025-08-11 06:54:37'),
(3961,2,'credit',NULL,1648000.0000,NULL,'2025-08-11 14:18:00',6,65629,45037,NULL,NULL,NULL,'2025-08-11 07:18:03','2025-08-30 05:47:43'),
(3962,2,'debit',NULL,9951300.0000,NULL,'2025-08-11 15:33:00',49,65838,45042,NULL,NULL,NULL,'2025-08-11 08:35:00','2025-08-11 08:35:00'),
(3963,2,'credit',NULL,227000.0000,NULL,'2025-08-11 18:11:15',49,65859,45057,NULL,NULL,NULL,'2025-08-11 11:11:15','2025-08-11 14:45:11'),
(3964,2,'debit',NULL,1783000.0000,NULL,'2025-08-12 09:36:00',13,65877,45071,NULL,NULL,'2025-08-15 03:58:05','2025-08-12 02:39:50','2025-08-15 03:58:05'),
(3965,2,'debit',NULL,87000.0000,NULL,'2025-08-12 11:53:00',19,65885,45075,NULL,NULL,NULL,'2025-08-12 04:54:31','2025-08-12 04:54:31'),
(3966,2,'credit',NULL,750000.0000,NULL,'2025-08-12 13:50:36',106,65893,45080,NULL,NULL,NULL,'2025-08-12 06:50:36','2025-08-12 06:50:36'),
(3967,2,'credit',NULL,756000.0000,NULL,'2025-08-12 16:30:28',13,65903,45089,NULL,NULL,NULL,'2025-08-12 09:30:28','2025-08-12 09:30:28'),
(3968,2,'credit',NULL,9060000.0000,NULL,'2025-08-12 16:35:20',106,65902,45091,NULL,NULL,NULL,'2025-08-12 09:35:20','2025-08-18 08:21:46'),
(3969,2,'debit',NULL,1060000.0000,NULL,'2025-08-12 17:06:00',5,65909,45094,NULL,NULL,NULL,'2025-08-12 10:07:22','2025-08-12 10:07:22'),
(3970,2,'debit',NULL,845000.0000,NULL,'2025-08-13 13:46:00',106,65959,45124,NULL,NULL,NULL,'2025-08-13 06:47:15','2025-08-13 06:47:15'),
(3971,2,'debit',NULL,496800.0000,NULL,'2025-08-13 16:55:00',19,65972,45128,NULL,NULL,NULL,'2025-08-13 09:57:58','2025-08-13 09:57:58'),
(3972,2,'credit',NULL,300000.0000,NULL,'2025-08-13 17:23:52',5,65868,45131,NULL,NULL,NULL,'2025-08-13 10:23:52','2025-08-13 10:23:52'),
(3973,2,'credit',NULL,45000.0000,NULL,'2025-08-13 20:37:08',106,65981,45140,NULL,NULL,NULL,'2025-08-13 13:37:08','2025-08-13 13:37:08'),
(3974,2,'credit',NULL,1560000.0000,NULL,'2025-08-14 11:01:39',13,65612,45153,NULL,NULL,NULL,'2025-08-14 04:01:39','2025-08-14 04:02:13'),
(3975,2,'debit',NULL,151900.0000,NULL,'2025-08-14 12:25:00',13,65999,45157,NULL,NULL,NULL,'2025-08-14 05:26:36','2025-08-14 05:26:36'),
(3976,2,'credit',NULL,1990000.0000,NULL,'2025-08-14 14:59:57',49,66015,45166,NULL,NULL,NULL,'2025-08-14 07:59:57','2025-08-14 07:59:57'),
(3977,2,'debit',NULL,415000.0000,NULL,'2025-08-14 15:00:00',49,66016,45167,NULL,NULL,NULL,'2025-08-14 08:01:27','2025-08-14 08:01:27'),
(3978,2,'debit',NULL,145000.0000,NULL,'2025-08-14 15:34:00',19,66018,45178,NULL,NULL,NULL,'2025-08-14 08:36:45','2025-08-14 08:36:45'),
(3979,2,'credit',NULL,534000.0000,NULL,'2025-08-14 20:15:13',19,66028,45189,NULL,NULL,NULL,'2025-08-14 13:15:13','2025-08-14 13:19:03'),
(3980,2,'debit',NULL,1321000.0000,NULL,'2025-08-15 08:31:00',13,66032,45194,NULL,NULL,NULL,'2025-08-15 01:32:54','2025-08-15 01:32:54'),
(3981,2,'debit',NULL,144000.0000,NULL,'2025-08-15 08:41:00',5,66033,45195,NULL,NULL,NULL,'2025-08-15 01:41:50','2025-08-15 01:41:50'),
(3982,2,'debit',NULL,5218000.0000,NULL,'2025-08-15 09:01:00',5,66036,45196,NULL,NULL,NULL,'2025-08-15 02:04:07','2025-08-18 15:38:04'),
(3983,2,'debit',NULL,118000.0000,NULL,'2025-08-15 10:38:00',5,66045,45207,NULL,NULL,NULL,'2025-08-15 03:39:11','2025-08-15 03:39:11'),
(3984,2,'credit',NULL,80000.0000,NULL,'2025-08-15 11:34:50',13,65948,45208,NULL,NULL,NULL,'2025-08-15 04:34:50','2025-08-15 04:34:50'),
(3985,2,'debit',NULL,901200.0000,NULL,'2025-08-16 10:37:00',19,66092,45239,NULL,NULL,NULL,'2025-08-16 03:38:50','2025-08-16 03:38:50'),
(3986,2,'credit',NULL,275000.0000,NULL,'2025-08-16 13:44:43',13,66102,45243,NULL,NULL,NULL,'2025-08-16 06:44:43','2025-08-16 06:44:43'),
(3987,2,'debit',NULL,170000.0000,NULL,'2025-08-16 13:44:00',106,66103,45244,NULL,NULL,NULL,'2025-08-16 06:47:05','2025-08-16 06:47:05'),
(3988,2,'credit',NULL,650000.0000,NULL,'2025-08-16 13:50:23',106,66079,45245,NULL,NULL,NULL,'2025-08-16 06:50:23','2025-08-20 11:31:48'),
(3989,2,'credit',NULL,69000.0000,NULL,'2025-08-16 14:26:00',6,66104,45246,NULL,NULL,NULL,'2025-08-16 07:26:56','2025-08-16 07:27:57'),
(3990,2,'debit',NULL,3809500.0000,NULL,'2025-08-16 14:31:00',5,66105,45247,NULL,NULL,NULL,'2025-08-16 07:34:33','2025-08-16 07:34:33'),
(3991,2,'credit',NULL,45000.0000,NULL,'2025-08-16 15:33:38',13,63237,45249,NULL,NULL,NULL,'2025-08-16 08:33:38','2025-08-17 02:34:48'),
(3992,2,'credit',NULL,60000.0000,NULL,'2025-08-16 18:09:37',106,66114,45257,NULL,NULL,NULL,'2025-08-16 11:09:37','2025-08-16 14:56:23'),
(3993,2,'debit',NULL,65000.0000,NULL,'2025-08-16 19:55:00',13,66118,45259,NULL,NULL,NULL,'2025-08-16 12:55:57','2025-08-16 12:55:57'),
(3994,2,'credit',NULL,615000.0000,NULL,'2025-08-17 09:34:50',49,66123,45265,NULL,NULL,NULL,'2025-08-17 02:34:50','2025-08-17 02:34:50'),
(3995,2,'credit',NULL,1000000.0000,NULL,'2025-08-17 13:06:28',106,66116,45272,NULL,NULL,NULL,'2025-08-17 06:06:28','2025-11-06 11:48:37'),
(3996,2,'credit',NULL,6855000.0000,NULL,'2025-08-17 19:57:41',9,65790,45292,NULL,NULL,NULL,'2025-08-17 12:57:41','2025-11-26 07:35:35'),
(3997,2,'credit',NULL,225000.0000,NULL,'2025-08-18 08:32:26',49,66151,45296,NULL,NULL,NULL,'2025-08-18 01:32:26','2025-08-18 01:32:26'),
(3998,2,'debit',NULL,381900.0000,NULL,'2025-08-18 13:06:00',5,66161,45300,NULL,NULL,NULL,'2025-08-18 06:07:31','2025-08-18 06:07:31'),
(3999,2,'debit',NULL,5358640.0000,NULL,'2025-08-18 14:40:00',5,66168,45306,NULL,NULL,NULL,'2025-08-18 07:42:03','2025-08-18 07:42:03'),
(4000,2,'credit',NULL,312000.0000,NULL,'2025-08-18 15:10:15',106,65902,45307,NULL,NULL,NULL,'2025-08-18 08:10:15','2025-08-18 08:21:46'),
(4001,2,'credit',NULL,460000.0000,NULL,'2025-08-18 15:19:22',106,66046,45308,NULL,NULL,NULL,'2025-08-18 08:19:22','2025-08-19 01:30:17'),
(4002,2,'debit',NULL,6876300.0000,NULL,'2025-08-18 17:03:00',13,66185,45321,NULL,NULL,NULL,'2025-08-18 10:08:20','2025-08-18 10:08:20'),
(4003,2,'debit',NULL,279000.0000,NULL,'2025-08-18 17:13:00',19,66186,45322,NULL,NULL,NULL,'2025-08-18 10:14:52','2025-08-18 10:14:52'),
(4004,2,'credit',NULL,292000.0000,NULL,'2025-08-18 17:43:01',19,66187,45323,NULL,NULL,NULL,'2025-08-18 10:43:01','2025-08-18 10:43:01'),
(4005,2,'credit',NULL,378000.0000,NULL,'2025-08-18 17:44:00',19,66044,45324,NULL,NULL,NULL,'2025-08-18 10:44:31','2025-08-18 10:44:31'),
(4006,2,'credit',NULL,84000.0000,NULL,'2025-08-18 19:34:17',5,66195,45327,NULL,NULL,NULL,'2025-08-18 12:34:17','2025-08-18 12:47:09'),
(4007,2,'credit',NULL,984000.0000,NULL,'2025-08-18 21:09:00',19,66191,45333,NULL,NULL,NULL,'2025-08-18 14:09:42','2025-08-18 14:09:42'),
(4008,2,'debit',NULL,11712800.0000,NULL,'2025-08-18 22:08:00',1,65872,45337,NULL,NULL,NULL,'2025-08-18 15:08:15','2025-08-18 15:08:15'),
(4009,2,'debit',NULL,7193838.0000,NULL,'2025-08-18 22:19:00',1,66193,45338,NULL,NULL,NULL,'2025-08-18 15:19:07','2025-08-18 15:19:07'),
(4010,2,'debit',NULL,11232000.0000,NULL,'2025-08-18 22:25:00',1,66154,45339,NULL,NULL,NULL,'2025-08-18 15:26:00','2025-08-18 15:26:00'),
(4011,2,'debit',NULL,94000.0000,NULL,'2025-08-18 22:38:00',1,65963,45341,NULL,NULL,NULL,'2025-08-18 15:38:35','2025-08-18 15:38:35'),
(4012,2,'debit',NULL,883700.0000,NULL,'2025-08-18 22:46:00',1,65873,45342,NULL,NULL,NULL,'2025-08-18 15:46:32','2025-08-18 15:46:32'),
(4013,2,'debit',NULL,860321.0000,NULL,'2025-08-18 23:01:00',1,65874,45343,NULL,NULL,NULL,'2025-08-18 16:01:22','2025-08-18 16:01:22'),
(4014,2,'credit',NULL,1645000.0000,NULL,'2025-08-19 09:04:25',106,60678,45347,NULL,NULL,NULL,'2025-08-19 02:04:25','2025-09-01 07:11:26'),
(4015,2,'debit',NULL,4573380.0000,NULL,'2025-08-19 12:31:00',49,66219,45369,NULL,NULL,NULL,'2025-08-19 05:34:20','2025-09-06 06:13:39'),
(4016,2,'debit',NULL,6951800.0000,NULL,'2025-08-19 12:34:00',49,66220,45370,NULL,NULL,NULL,'2025-08-19 05:51:41','2025-08-19 05:51:41'),
(4017,2,'debit',NULL,848100.0000,NULL,'2025-08-19 12:52:00',49,66221,45371,NULL,NULL,NULL,'2025-08-19 05:54:04','2025-08-19 05:54:04'),
(4018,2,'debit',NULL,117000.0000,NULL,'2025-08-19 17:15:00',106,66230,45377,NULL,NULL,NULL,'2025-08-19 10:16:42','2025-08-19 10:16:42'),
(4019,2,'credit',NULL,120000.0000,NULL,'2025-08-19 17:37:41',5,64819,45379,NULL,NULL,NULL,'2025-08-19 10:37:41','2025-08-19 10:37:41'),
(4020,2,'credit',NULL,195000.0000,NULL,'2025-08-19 17:39:22',5,66232,45380,NULL,NULL,NULL,'2025-08-19 10:39:40','2025-08-19 10:39:40'),
(4021,2,'debit',NULL,4552790.0000,NULL,'2025-08-19 18:49:00',19,66233,45383,NULL,NULL,NULL,'2025-08-19 11:59:19','2025-08-19 11:59:19'),
(4022,2,'debit',NULL,448200.0000,NULL,'2025-08-19 18:59:00',19,66234,45384,NULL,NULL,NULL,'2025-08-19 12:02:08','2025-08-19 12:02:08'),
(4023,2,'debit',NULL,1869900.0000,NULL,'2025-08-19 19:15:00',13,66238,45385,NULL,NULL,NULL,'2025-08-19 12:18:58','2025-08-26 01:03:04'),
(4024,2,'debit',NULL,19986804.0000,NULL,'2025-08-19 20:14:00',1,65725,45389,NULL,NULL,NULL,'2025-08-19 13:14:43','2025-08-19 13:14:43'),
(4025,2,'credit',NULL,1000000.0000,NULL,'2025-08-21 10:08:14',6,66304,45439,NULL,NULL,NULL,'2025-08-21 03:08:14','2025-08-21 08:15:55'),
(4026,2,'credit',NULL,338000.0000,NULL,'2025-08-21 13:25:56',19,66326,45452,NULL,NULL,NULL,'2025-08-21 06:25:56','2025-08-21 06:25:56'),
(4027,2,'debit',NULL,1021000.0000,NULL,'2025-08-21 16:45:00',49,66345,45468,NULL,NULL,NULL,'2025-08-21 09:49:00','2025-08-21 09:49:00'),
(4028,2,'credit',NULL,200000.0000,NULL,'2025-08-21 17:09:37',19,66331,45469,NULL,NULL,NULL,'2025-08-21 10:09:37','2025-08-30 06:28:26'),
(4029,2,'credit',NULL,4449000.0000,NULL,'2025-08-21 18:26:03',19,66354,45471,NULL,NULL,NULL,'2025-08-21 11:26:03','2025-08-21 11:26:03'),
(4030,2,'credit',NULL,4312000.0000,NULL,'2025-08-21 18:52:44',5,66355,45472,NULL,NULL,NULL,'2025-08-21 11:52:44','2025-08-21 11:52:44'),
(4031,2,'debit',NULL,192000.0000,NULL,'2025-08-22 08:32:00',49,66371,45488,NULL,NULL,NULL,'2025-08-22 01:35:45','2025-08-22 01:35:45'),
(4032,2,'credit',NULL,150000.0000,NULL,'2025-08-22 09:50:20',49,66353,45491,NULL,NULL,NULL,'2025-08-22 02:50:20','2025-08-22 14:44:06'),
(4033,2,'debit',NULL,477500.0000,NULL,'2025-08-22 14:04:00',49,66391,45496,NULL,NULL,NULL,'2025-08-22 07:05:23','2025-08-22 07:05:23'),
(4034,2,'debit',NULL,3800000.0000,NULL,'2025-08-22 14:06:00',49,66392,45497,NULL,NULL,NULL,'2025-08-22 07:07:57','2025-08-22 07:07:57'),
(4035,2,'debit',NULL,173050.0000,NULL,'2025-08-22 15:12:00',5,66398,45502,NULL,NULL,NULL,'2025-08-22 08:15:24','2025-08-22 08:15:24'),
(4036,2,'credit',NULL,620000.0000,NULL,'2025-08-22 15:17:06',19,66399,45504,NULL,NULL,NULL,'2025-08-22 08:17:06','2025-08-22 08:17:06'),
(4037,2,'credit',NULL,147000.0000,NULL,'2025-08-22 16:41:19',106,66406,45509,NULL,NULL,NULL,'2025-08-22 09:41:19','2025-08-22 09:41:19'),
(4038,2,'debit',NULL,25000.0000,NULL,'2025-08-22 18:08:00',19,66410,45511,NULL,NULL,NULL,'2025-08-22 11:11:08','2025-08-22 11:11:08'),
(4039,2,'debit',NULL,336000.0000,NULL,'2025-08-22 18:33:00',13,66414,45514,NULL,NULL,NULL,'2025-08-22 11:34:25','2025-08-22 11:34:25'),
(4040,2,'credit',NULL,10000.0000,NULL,'2025-08-22 20:41:11',143,66419,45519,NULL,NULL,NULL,'2025-08-22 13:41:11','2025-08-22 13:41:11'),
(4041,2,'credit',NULL,672000.0000,NULL,'2025-08-22 20:42:29',5,66421,45521,NULL,NULL,NULL,'2025-08-22 13:42:29','2025-08-22 13:42:29'),
(4042,2,'debit',NULL,89900.0000,NULL,'2025-08-23 11:45:00',49,66440,45531,NULL,NULL,NULL,'2025-08-23 04:57:08','2025-08-23 04:57:08'),
(4043,2,'credit',NULL,200000.0000,NULL,'2025-08-23 12:52:45',106,66409,45534,NULL,NULL,NULL,'2025-08-23 05:52:45','2025-08-31 09:49:24'),
(4044,2,'debit',NULL,4480000.0000,NULL,'2025-08-23 13:10:00',13,66445,45536,NULL,NULL,NULL,'2025-08-23 06:13:50','2025-08-23 06:13:50'),
(4045,2,'credit',NULL,210000.0000,NULL,'2025-08-23 13:23:06',5,66310,45537,NULL,NULL,NULL,'2025-08-23 06:23:06','2025-08-23 11:12:26'),
(4046,2,'credit',NULL,200000.0000,NULL,'2025-08-23 14:39:42',13,66444,45541,NULL,NULL,NULL,'2025-08-23 07:39:42','2025-09-02 03:56:56'),
(4047,2,'debit',NULL,150000.0000,NULL,'2025-08-23 14:38:00',6,66452,45542,NULL,NULL,NULL,'2025-08-23 07:39:46','2025-08-23 07:39:46'),
(4048,2,'debit',NULL,120000.0000,NULL,'2025-08-23 16:19:00',49,66460,45547,NULL,NULL,NULL,'2025-08-23 09:20:03','2025-08-23 09:20:03'),
(4049,2,'debit',NULL,7563000.0000,NULL,'2025-08-23 18:29:00',13,66465,45550,NULL,NULL,NULL,'2025-08-23 11:31:51','2025-08-23 11:31:51'),
(4050,2,'credit',NULL,186000.0000,NULL,'2025-08-23 19:47:37',13,66468,45553,NULL,NULL,NULL,'2025-08-23 12:47:37','2025-08-23 12:47:37'),
(4051,2,'credit',NULL,195000.0000,NULL,'2025-08-23 19:47:55',13,66278,45554,NULL,NULL,NULL,'2025-08-23 12:47:55','2025-08-23 12:47:55'),
(4052,2,'credit',NULL,325000.0000,NULL,'2025-08-23 20:03:17',13,66469,45555,NULL,NULL,NULL,'2025-08-23 13:03:17','2025-08-23 13:03:17'),
(4053,2,'credit',NULL,941000.0000,NULL,'2025-08-24 08:20:41',19,64535,45557,NULL,NULL,NULL,'2025-08-24 01:20:41','2025-08-31 04:19:42'),
(4054,2,'credit',NULL,447000.0000,NULL,'2025-08-24 11:07:39',19,66484,45566,NULL,NULL,NULL,'2025-08-24 04:07:39','2025-08-24 04:07:39'),
(4055,2,'credit',NULL,359000.0000,NULL,'2025-08-24 19:49:47',6,66507,45578,NULL,NULL,NULL,'2025-08-24 12:54:16','2025-08-24 12:54:16'),
(4056,2,'credit',NULL,565000.0000,NULL,'2025-08-24 21:13:27',6,66511,45581,NULL,NULL,NULL,'2025-08-24 14:13:27','2025-08-24 14:13:27'),
(4057,2,'credit',NULL,91000.0000,NULL,'2025-08-24 21:49:39',49,66513,45584,NULL,NULL,NULL,'2025-08-24 14:49:39','2025-08-24 14:49:39'),
(4058,2,'credit',NULL,169000.0000,NULL,'2025-08-25 09:11:15',19,66515,45586,NULL,NULL,NULL,'2025-08-25 02:11:15','2025-08-25 02:11:15'),
(4059,2,'credit',NULL,145000.0000,NULL,'2025-08-25 09:12:03',143,66516,45587,NULL,NULL,NULL,'2025-08-25 02:12:03','2025-08-26 07:04:21'),
(4060,2,'credit',NULL,114300.0000,NULL,'2025-08-25 10:00:55',19,66520,45590,NULL,NULL,NULL,'2025-08-25 03:00:55','2025-08-25 03:00:55'),
(4061,2,'credit',NULL,56000.0000,NULL,'2025-08-25 13:38:36',106,66533,45594,NULL,NULL,NULL,'2025-08-25 06:38:36','2025-08-25 06:38:36'),
(4062,2,'credit',NULL,945000.0000,NULL,'2025-08-25 14:29:10',106,65714,45596,NULL,NULL,NULL,'2025-08-25 07:29:10','2025-08-25 11:38:35'),
(4063,2,'credit',NULL,45000.0000,NULL,'2025-08-25 14:47:32',6,66496,45598,NULL,NULL,NULL,'2025-08-25 07:47:32','2025-08-25 07:47:32'),
(4064,2,'credit',NULL,55000.0000,NULL,'2025-08-25 14:47:52',6,66536,45599,NULL,NULL,NULL,'2025-08-25 07:47:52','2025-08-25 07:47:52'),
(4065,2,'credit',NULL,922000.0000,NULL,'2025-08-25 18:39:00',106,66549,45604,NULL,NULL,NULL,'2025-08-25 11:39:00','2025-08-25 11:39:00'),
(4066,2,'credit',NULL,235000.0000,NULL,'2025-08-26 09:26:55',5,66562,45609,NULL,NULL,NULL,'2025-08-26 02:26:55','2025-08-26 07:03:37'),
(4067,2,'credit',NULL,120000.0000,NULL,'2025-08-26 10:16:14',5,65720,45612,NULL,NULL,NULL,'2025-08-26 03:16:14','2025-08-28 03:06:15'),
(4068,2,'credit',NULL,100000.0000,NULL,'2025-08-26 11:56:32',143,66567,45615,NULL,NULL,NULL,'2025-08-26 04:56:32','2025-08-26 04:56:32'),
(4069,2,'debit',NULL,3110866.0000,NULL,'2025-08-26 13:18:00',1,66581,45624,NULL,NULL,NULL,'2025-08-26 06:18:24','2025-08-26 06:18:24'),
(4070,2,'debit',NULL,7556688.0000,NULL,'2025-08-26 13:19:00',1,66579,45625,NULL,NULL,NULL,'2025-08-26 06:19:53','2025-08-26 06:19:53'),
(4071,2,'credit',NULL,45000.0000,NULL,'2025-08-26 13:21:40',5,66543,45626,NULL,NULL,NULL,'2025-08-26 06:21:40','2025-08-26 06:21:40'),
(4072,2,'debit',NULL,222000.0000,NULL,'2025-08-26 13:30:00',106,66586,45627,NULL,NULL,NULL,'2025-08-26 06:31:21','2025-08-26 06:31:21'),
(4073,2,'credit',NULL,200000.0000,NULL,'2025-08-26 16:45:45',5,66456,45630,NULL,NULL,NULL,'2025-08-26 09:45:45','2025-10-31 05:07:56'),
(4074,2,'debit',NULL,101000.0000,NULL,'2025-08-26 18:18:00',49,66613,45636,NULL,NULL,NULL,'2025-08-26 11:19:36','2025-08-26 11:19:36'),
(4075,2,'credit',NULL,39700.0000,NULL,'2025-08-26 18:33:12',49,66614,45637,NULL,NULL,NULL,'2025-08-26 11:33:12','2025-08-26 11:33:12'),
(4076,2,'credit',NULL,1450500.0000,NULL,'2025-08-26 20:13:29',106,66618,45640,NULL,NULL,NULL,'2025-08-26 13:13:29','2025-08-26 13:13:29'),
(4077,2,'credit',NULL,538000.0000,NULL,'2025-08-27 10:54:04',13,66646,45650,NULL,NULL,NULL,'2025-08-27 03:54:04','2025-08-27 03:54:04'),
(4078,2,'debit',NULL,205300.0000,NULL,'2025-08-27 11:41:00',19,66657,45658,NULL,NULL,NULL,'2025-08-27 04:43:34','2025-08-27 04:43:34'),
(4079,2,'credit',NULL,80000.0000,NULL,'2025-08-27 12:01:55',19,66526,45659,NULL,NULL,NULL,'2025-08-27 05:01:55','2025-08-27 05:01:55'),
(4080,2,'credit',NULL,300000.0000,NULL,'2025-08-27 12:11:38',19,66574,45660,NULL,NULL,NULL,'2025-08-27 05:11:38','2025-08-27 05:14:13'),
(4081,2,'credit',NULL,473000.0000,NULL,'2025-08-27 12:13:05',19,66658,45661,NULL,NULL,NULL,'2025-08-27 05:13:05','2025-08-27 05:15:17'),
(4082,2,'credit',NULL,300000.0000,NULL,'2025-08-27 12:17:33',19,66573,45662,NULL,NULL,NULL,'2025-08-27 05:17:33','2025-08-27 05:17:33'),
(4083,2,'credit',NULL,451000.0000,NULL,'2025-08-27 12:18:50',19,66659,45663,NULL,NULL,NULL,'2025-08-27 05:18:50','2025-08-27 05:18:50'),
(4084,2,'credit',NULL,80000.0000,NULL,'2025-08-27 12:22:28',19,66527,45664,NULL,NULL,NULL,'2025-08-27 05:22:28','2025-08-27 05:22:28'),
(4085,2,'credit',NULL,180000.0000,NULL,'2025-08-27 14:53:39',19,22683,45671,NULL,NULL,NULL,'2025-08-27 07:53:39','2025-08-27 07:53:39'),
(4086,2,'credit',NULL,983000.0000,NULL,'2025-08-27 14:55:00',19,66674,45672,NULL,NULL,NULL,'2025-08-27 07:55:00','2025-08-27 07:55:00'),
(4087,2,'credit',NULL,59000.0000,NULL,'2025-08-27 17:32:08',106,66686,45683,NULL,NULL,NULL,'2025-08-27 10:32:08','2025-08-27 10:32:08'),
(4088,2,'credit',NULL,35000.0000,NULL,'2025-08-27 17:35:43',19,66672,45685,NULL,NULL,NULL,'2025-08-27 10:35:43','2025-08-27 10:35:43'),
(4089,2,'credit',NULL,120000.0000,NULL,'2025-08-27 21:28:06',19,66201,45695,NULL,NULL,NULL,'2025-08-27 14:28:06','2025-08-27 14:28:06'),
(4090,2,'credit',NULL,150000.0000,NULL,'2025-08-27 21:28:33',5,66655,45696,NULL,NULL,NULL,'2025-08-27 14:28:33','2025-08-27 14:28:33'),
(4091,2,'credit',NULL,190000.0000,NULL,'2025-08-28 08:46:19',143,66706,45699,NULL,NULL,NULL,'2025-08-28 01:46:19','2025-08-28 01:46:19'),
(4092,2,'credit',NULL,980000.0000,NULL,'2025-08-28 08:48:39',5,66451,45700,NULL,NULL,NULL,'2025-08-28 01:48:39','2025-08-31 07:53:04'),
(4093,2,'credit',NULL,1308000.0000,NULL,'2025-08-28 10:18:31',13,66713,45701,NULL,NULL,NULL,'2025-08-28 03:18:31','2025-08-31 07:43:57'),
(4094,2,'credit',NULL,330000.0000,NULL,'2025-08-28 11:00:12',5,66488,45703,NULL,NULL,NULL,'2025-08-28 04:00:12','2025-08-30 10:43:16'),
(4095,2,'debit',NULL,840000.0000,NULL,'2025-08-28 14:42:00',13,66729,45713,NULL,NULL,NULL,'2025-08-28 07:43:16','2025-08-28 07:43:16'),
(4096,2,'credit',NULL,56000.0000,NULL,'2025-08-28 14:46:15',13,66730,45714,NULL,NULL,NULL,'2025-08-28 07:46:15','2025-08-28 07:46:15'),
(4097,2,'credit',NULL,450000.0000,NULL,'2025-08-28 15:43:46',10,66707,45720,NULL,NULL,NULL,'2025-08-28 08:43:46','2025-08-28 08:43:46'),
(4098,2,'credit',NULL,232000.0000,NULL,'2025-08-28 16:31:19',6,66739,45724,NULL,NULL,NULL,'2025-08-28 09:31:19','2025-08-28 09:31:19'),
(4099,2,'credit',NULL,63000.0000,NULL,'2025-08-28 16:39:44',143,66741,45725,NULL,NULL,NULL,'2025-08-28 09:39:44','2025-08-28 09:39:44'),
(4100,2,'credit',NULL,325000.0000,NULL,'2025-08-28 17:12:53',106,66713,45726,NULL,NULL,'2025-08-28 13:21:10','2025-08-28 10:12:53','2025-08-28 13:21:10'),
(4101,2,'debit',NULL,18177394.0000,NULL,'2025-08-28 17:46:00',49,66748,45729,NULL,NULL,NULL,'2025-08-28 11:32:00','2025-09-02 12:54:53'),
(4102,2,'credit',NULL,286000.0000,NULL,'2025-08-28 19:59:22',6,66754,45734,NULL,NULL,NULL,'2025-08-28 12:59:22','2025-08-28 12:59:22'),
(4103,2,'credit',NULL,120000.0000,NULL,'2025-08-28 20:00:06',6,66755,45735,NULL,NULL,NULL,'2025-08-28 13:00:06','2025-08-28 13:00:06'),
(4104,2,'credit',NULL,1046000.0000,NULL,'2025-08-28 20:21:35',106,66756,45736,NULL,NULL,NULL,'2025-08-28 13:21:35','2025-08-28 13:21:35'),
(4105,2,'credit',NULL,691000.0000,NULL,'2025-08-28 20:43:32',6,66759,45740,NULL,NULL,NULL,'2025-08-28 13:43:32','2025-08-28 13:43:32'),
(4106,2,'credit',NULL,385000.0000,NULL,'2025-08-28 21:24:24',49,66760,45741,NULL,NULL,NULL,'2025-08-28 14:24:24','2025-08-28 14:24:24'),
(4107,2,'debit',NULL,63000.0000,NULL,'2025-08-28 21:34:00',49,66761,45742,NULL,NULL,NULL,'2025-08-28 14:35:06','2025-08-28 14:35:06'),
(4108,2,'credit',NULL,500000.0000,NULL,'2025-08-29 09:48:28',143,66718,45746,NULL,NULL,NULL,'2025-08-29 02:48:28','2025-08-29 02:48:28'),
(4109,2,'credit',NULL,345000.0000,NULL,'2025-08-29 09:48:39',143,66766,45747,NULL,NULL,NULL,'2025-08-29 02:48:39','2025-08-29 02:48:39'),
(4110,2,'credit',NULL,285000.0000,NULL,'2025-08-29 10:25:13',143,66768,45749,NULL,NULL,NULL,'2025-08-29 03:25:13','2025-08-29 03:25:13'),
(4111,2,'debit',NULL,5097670.0000,NULL,'2025-08-29 10:29:00',1,66715,45750,NULL,NULL,NULL,'2025-08-29 03:29:50','2025-08-29 03:29:50'),
(4112,2,'debit',NULL,5933700.0000,NULL,'2025-08-29 10:36:00',13,66769,45751,NULL,NULL,NULL,'2025-08-29 03:37:55','2025-08-29 03:37:55'),
(4113,2,'credit',NULL,80000.0000,NULL,'2025-08-29 14:24:27',106,66603,45754,NULL,NULL,NULL,'2025-08-29 07:24:27','2025-08-29 07:24:27'),
(4114,2,'credit',NULL,160000.0000,NULL,'2025-08-29 14:32:29',5,66740,45755,NULL,NULL,NULL,'2025-08-29 07:32:29','2025-08-29 07:32:29'),
(4115,2,'credit',NULL,175000.0000,NULL,'2025-08-29 14:33:13',5,66775,45756,NULL,NULL,NULL,'2025-08-29 07:33:13','2025-08-29 07:33:13'),
(4116,2,'credit',NULL,275000.0000,NULL,'2025-08-29 15:19:43',13,66778,45758,NULL,NULL,NULL,'2025-08-29 08:19:43','2025-08-29 08:19:43'),
(4117,2,'credit',NULL,795000.0000,NULL,'2025-08-29 16:23:58',143,66787,45762,NULL,NULL,NULL,'2025-08-29 09:23:58','2025-08-29 09:32:19'),
(4118,2,'credit',NULL,1140000.0000,NULL,'2025-08-29 16:50:10',13,66789,45764,NULL,NULL,NULL,'2025-08-29 09:50:10','2025-08-29 09:50:10'),
(4119,2,'credit',NULL,120000.0000,NULL,'2025-08-29 19:25:14',106,66774,45768,NULL,NULL,NULL,'2025-08-29 12:25:14','2025-08-29 12:25:14'),
(4120,2,'credit',NULL,155000.0000,NULL,'2025-08-29 19:54:01',106,66786,45769,NULL,NULL,NULL,'2025-08-29 12:54:01','2025-08-29 12:54:01'),
(4121,2,'credit',NULL,501000.0000,NULL,'2025-08-29 20:09:01',6,66804,45770,NULL,NULL,NULL,'2025-08-29 13:09:01','2025-08-29 13:09:01'),
(4122,2,'credit',NULL,235500.0000,NULL,'2025-08-29 21:17:28',106,66727,45771,NULL,NULL,NULL,'2025-08-29 14:17:28','2025-08-29 14:17:28'),
(4123,2,'credit',NULL,102000.0000,NULL,'2025-08-29 21:18:01',106,66635,45772,NULL,NULL,NULL,'2025-08-29 14:18:01','2025-08-29 14:18:01'),
(4124,2,'credit',NULL,36000.0000,NULL,'2025-08-29 22:02:15',106,66810,45775,NULL,NULL,NULL,'2025-08-29 15:02:15','2025-08-29 15:02:15'),
(4125,2,'credit',NULL,280000.0000,NULL,'2025-08-29 22:04:55',106,66620,45776,NULL,NULL,NULL,'2025-08-29 15:04:55','2025-08-29 15:04:55'),
(4126,2,'credit',NULL,477000.0000,NULL,'2025-08-29 22:05:07',106,66811,45777,NULL,NULL,NULL,'2025-08-29 15:05:07','2025-08-29 15:05:07'),
(4127,2,'debit',NULL,743700.0000,NULL,'2025-08-30 09:56:00',13,66816,45778,NULL,NULL,'2025-09-20 02:53:57','2025-08-30 02:57:56','2025-09-20 02:53:57'),
(4128,2,'debit',NULL,897820.0000,NULL,'2025-08-30 10:35:00',13,66822,45781,NULL,NULL,NULL,'2025-08-30 04:08:36','2025-08-30 04:08:36'),
(4129,2,'credit',NULL,301665.0000,NULL,'2025-08-30 12:32:32',19,66829,45787,NULL,NULL,NULL,'2025-08-30 05:32:32','2025-08-30 05:32:32'),
(4130,2,'credit',NULL,301665.0000,NULL,'2025-08-30 12:32:47',19,66830,45788,NULL,NULL,NULL,'2025-08-30 05:32:47','2025-08-30 05:32:47'),
(4131,2,'credit',NULL,301665.0000,NULL,'2025-08-30 12:33:03',19,66831,45789,NULL,NULL,NULL,'2025-08-30 05:33:03','2025-08-30 05:33:03'),
(4132,2,'credit',NULL,500000.0000,NULL,'2025-08-30 12:43:44',13,66834,45794,NULL,NULL,NULL,'2025-08-30 05:43:44','2025-08-31 06:47:33'),
(4133,2,'credit',NULL,1230000.0000,NULL,'2025-08-30 12:43:44',13,66834,45795,NULL,NULL,NULL,'2025-08-30 05:43:44','2025-08-31 06:47:33'),
(4134,2,'credit',NULL,250000.0000,NULL,'2025-08-30 12:44:00',13,66279,45796,NULL,NULL,NULL,'2025-08-30 05:44:00','2025-08-30 05:44:00'),
(4135,2,'credit',NULL,350000.0000,NULL,'2025-08-30 12:46:58',19,66835,45797,NULL,NULL,NULL,'2025-08-30 05:46:58','2025-08-30 05:46:58'),
(4136,2,'credit',NULL,350000.0000,NULL,'2025-08-30 12:47:11',19,66836,45798,NULL,NULL,NULL,'2025-08-30 05:47:11','2025-08-30 05:47:11'),
(4137,2,'credit',NULL,375000.0000,NULL,'2025-08-30 12:54:35',19,66837,45801,NULL,NULL,NULL,'2025-08-30 05:54:35','2025-08-30 05:54:35'),
(4138,2,'credit',NULL,375000.0000,NULL,'2025-08-30 12:54:45',19,66838,45802,NULL,NULL,NULL,'2025-08-30 05:54:45','2025-08-30 05:54:45'),
(4139,2,'credit',NULL,181000.0000,NULL,'2025-08-30 13:06:48',19,66839,45803,NULL,NULL,NULL,'2025-08-30 06:06:48','2025-08-30 06:06:48'),
(4140,2,'credit',NULL,233000.0000,NULL,'2025-08-30 15:59:12',106,66854,45811,NULL,NULL,NULL,'2025-08-30 08:59:56','2025-08-30 08:59:56'),
(4141,2,'credit',NULL,90000.0000,NULL,'2025-08-30 17:21:57',6,66859,45815,NULL,NULL,NULL,'2025-08-30 10:21:57','2025-08-30 10:21:57'),
(4142,2,'credit',NULL,55000.0000,NULL,'2025-08-30 17:43:35',106,66861,45816,NULL,NULL,NULL,'2025-08-30 10:43:35','2025-08-30 10:43:35'),
(4143,2,'debit',NULL,65000.0000,NULL,'2025-08-30 18:23:00',106,66864,45819,NULL,NULL,NULL,'2025-08-30 11:24:18','2025-08-30 11:24:18'),
(4144,2,'credit',NULL,100000.0000,NULL,'2025-08-30 20:06:18',6,66799,45820,NULL,NULL,NULL,'2025-08-30 13:06:18','2025-08-30 13:06:18'),
(4145,2,'credit',NULL,122000.0000,NULL,'2025-08-30 20:06:26',6,66866,45821,NULL,NULL,NULL,'2025-08-30 13:06:26','2025-08-30 13:06:26'),
(4146,2,'credit',NULL,1050000.0000,NULL,'2025-08-31 10:29:22',6,66878,45831,NULL,NULL,NULL,'2025-08-31 03:29:22','2025-08-31 03:29:22'),
(4147,2,'credit',NULL,1050000.0000,NULL,'2025-08-31 10:34:38',6,66879,45832,NULL,NULL,NULL,'2025-08-31 03:34:38','2025-08-31 03:34:38'),
(4148,2,'credit',NULL,200000.0000,NULL,'2025-08-31 10:38:00',6,66880,45834,NULL,NULL,NULL,'2025-08-31 03:38:00','2025-08-31 03:38:00'),
(4149,2,'credit',NULL,160000.0000,NULL,'2025-08-31 11:32:49',13,66782,45839,NULL,NULL,NULL,'2025-08-31 04:32:49','2025-08-31 04:32:49'),
(4150,2,'credit',NULL,241000.0000,NULL,'2025-08-31 11:35:18',13,66883,45840,NULL,NULL,NULL,'2025-08-31 04:35:18','2025-08-31 04:35:18'),
(4151,2,'credit',NULL,1360000.0000,NULL,'2025-08-31 11:50:47',106,66885,45841,NULL,NULL,NULL,'2025-08-31 04:50:47','2025-08-31 04:50:47'),
(4152,2,'credit',NULL,50000.0000,NULL,'2025-08-31 12:08:03',6,66886,45843,NULL,NULL,NULL,'2025-08-31 05:08:03','2025-08-31 05:08:03'),
(4153,2,'credit',NULL,425000.0000,NULL,'2025-08-31 13:01:59',6,66865,45844,NULL,NULL,NULL,'2025-08-31 06:01:59','2025-08-31 06:01:59'),
(4154,2,'debit',NULL,984980.0000,NULL,'2025-08-31 13:41:00',5,66891,45845,NULL,NULL,NULL,'2025-08-31 06:45:40','2025-08-31 06:45:40'),
(4155,2,'credit',NULL,60000.0000,NULL,'2025-08-31 14:20:43',19,66808,45847,NULL,NULL,NULL,'2025-08-31 07:20:43','2025-08-31 07:20:43'),
(4156,2,'credit',NULL,87000.0000,NULL,'2025-08-31 14:20:56',19,66893,45848,NULL,NULL,NULL,'2025-08-31 07:20:56','2025-08-31 07:20:56'),
(4157,2,'credit',NULL,175000.0000,NULL,'2025-08-31 14:42:46',5,66895,45850,NULL,NULL,NULL,'2025-08-31 07:42:46','2025-08-31 07:43:34'),
(4158,2,'credit',NULL,175000.0000,NULL,'2025-08-31 14:43:22',5,66896,45851,NULL,NULL,NULL,'2025-08-31 07:43:22','2025-08-31 07:43:22'),
(4159,2,'debit',NULL,100000.0000,NULL,'2025-08-31 14:43:00',13,66897,45852,NULL,NULL,NULL,'2025-08-31 07:44:41','2025-08-31 07:44:41'),
(4160,2,'debit',NULL,68000.0000,NULL,'2025-08-31 14:49:00',13,66901,45855,NULL,NULL,NULL,'2025-08-31 07:50:30','2025-08-31 07:50:30'),
(4161,2,'credit',NULL,175000.0000,NULL,'2025-08-31 14:52:20',5,66902,45856,NULL,NULL,NULL,'2025-08-31 07:52:20','2025-08-31 07:52:20'),
(4162,2,'credit',NULL,175000.0000,NULL,'2025-08-31 14:52:32',5,66903,45857,NULL,NULL,NULL,'2025-08-31 07:52:32','2025-08-31 07:52:32'),
(4163,2,'debit',NULL,471000.0000,NULL,'2025-08-31 14:53:00',19,66904,45859,NULL,NULL,NULL,'2025-08-31 07:55:10','2025-08-31 07:55:10'),
(4164,2,'credit',NULL,60000.0000,NULL,'2025-08-31 14:57:09',5,66905,45860,NULL,NULL,NULL,'2025-08-31 07:57:09','2025-08-31 07:57:09'),
(4165,2,'credit',NULL,60000.0000,NULL,'2025-08-31 14:57:23',5,66906,45861,NULL,NULL,NULL,'2025-08-31 07:57:23','2025-08-31 07:57:23'),
(4166,2,'debit',NULL,51900.0000,NULL,'2025-08-31 15:53:00',13,66910,45864,NULL,NULL,NULL,'2025-08-31 08:56:15','2025-08-31 08:56:15'),
(4167,2,'credit',NULL,350000.0000,NULL,'2025-08-31 17:28:38',143,66848,45870,NULL,NULL,NULL,'2025-08-31 10:28:38','2025-08-31 10:28:38'),
(4168,2,'credit',NULL,100000.0000,NULL,'2025-08-31 20:17:52',143,66853,45873,NULL,NULL,NULL,'2025-08-31 13:17:52','2025-08-31 13:17:52'),
(4169,2,'credit',NULL,120000.0000,NULL,'2025-09-01 09:54:32',13,66388,45902,NULL,NULL,NULL,'2025-09-01 02:54:32','2025-09-01 02:54:32'),
(4170,2,'debit',NULL,35753036.0000,NULL,'2025-09-01 12:37:00',1,66239,45910,NULL,NULL,NULL,'2025-09-01 05:37:43','2025-09-01 05:37:43'),
(4171,2,'credit',NULL,93000.0000,NULL,'2025-09-01 13:17:11',5,66934,45916,NULL,NULL,NULL,'2025-09-01 06:17:11','2025-09-02 11:46:40'),
(4172,2,'credit',NULL,1413000.0000,NULL,'2025-09-01 13:51:00',19,66936,45918,NULL,NULL,NULL,'2025-09-01 06:51:47','2025-09-28 12:47:13'),
(4173,2,'credit',NULL,2895000.0000,NULL,'2025-09-01 14:11:05',5,66941,45919,NULL,NULL,NULL,'2025-09-01 07:11:05','2025-09-01 07:14:37'),
(4174,2,'debit',NULL,579000.0000,NULL,'2025-09-01 15:15:00',13,66948,45926,NULL,NULL,NULL,'2025-09-01 08:20:46','2025-09-01 08:20:46'),
(4175,2,'credit',NULL,362000.0000,NULL,'2025-09-01 16:39:18',106,66938,45932,NULL,NULL,NULL,'2025-09-01 09:39:18','2025-09-01 09:43:11'),
(4176,2,'credit',NULL,320000.0000,NULL,'2025-09-01 16:42:46',106,66949,45933,NULL,NULL,NULL,'2025-09-01 09:42:46','2025-09-01 09:42:46'),
(4177,2,'credit',NULL,200000.0000,NULL,'2025-09-01 17:45:58',5,66704,45940,NULL,NULL,NULL,'2025-09-01 10:45:58','2025-09-20 06:14:34'),
(4178,2,'credit',NULL,200000.0000,NULL,'2025-09-01 19:14:29',5,66805,45945,NULL,NULL,NULL,'2025-09-01 12:14:29','2025-09-01 12:16:31'),
(4179,2,'credit',NULL,752000.0000,NULL,'2025-09-01 19:15:38',5,66962,45946,NULL,NULL,NULL,'2025-09-01 12:15:38','2025-09-28 07:06:23'),
(4180,2,'credit',NULL,330000.0000,NULL,'2025-09-01 20:04:41',143,66966,45955,NULL,NULL,'2025-09-01 13:07:29','2025-09-01 13:04:41','2025-09-01 13:07:29'),
(4181,2,'credit',NULL,330000.0000,NULL,'2025-09-01 20:10:54',143,66967,45956,NULL,NULL,NULL,'2025-09-01 13:10:54','2025-09-01 13:10:54'),
(4182,2,'credit',NULL,175000.0000,NULL,'2025-09-01 20:38:19',5,66963,45957,NULL,NULL,NULL,'2025-09-01 13:38:19','2025-09-01 13:38:19'),
(4183,2,'credit',NULL,9280000.0000,NULL,'2025-09-01 21:02:05',5,66970,45958,NULL,NULL,NULL,'2025-09-01 14:02:05','2025-09-02 11:49:04'),
(4184,2,'credit',NULL,200000.0000,NULL,'2025-09-01 21:17:39',5,66924,45959,NULL,NULL,NULL,'2025-09-01 14:17:39','2025-10-05 06:10:19'),
(4185,2,'debit',NULL,25521892.0000,NULL,'2025-09-02 08:29:00',13,66972,45961,NULL,NULL,NULL,'2025-09-02 01:35:06','2025-09-11 13:05:21'),
(4186,2,'credit',NULL,2175000.0000,NULL,'2025-09-02 10:12:18',6,66982,45968,NULL,NULL,NULL,'2025-09-02 03:12:18','2025-10-02 02:29:17'),
(4187,2,'credit',NULL,900000.0000,NULL,'2025-09-02 10:56:56',106,66444,45970,NULL,NULL,NULL,'2025-09-02 03:56:56','2025-09-02 03:56:56'),
(4188,2,'credit',NULL,500000.0000,NULL,'2025-09-02 11:28:29',6,64305,45971,NULL,NULL,NULL,'2025-09-02 04:28:29','2025-11-04 10:59:22'),
(4189,2,'credit',NULL,1675000.0000,NULL,'2025-09-02 11:54:49',106,66986,45972,NULL,NULL,NULL,'2025-09-02 04:54:49','2025-09-02 04:54:49'),
(4190,2,'debit',NULL,75000.0000,NULL,'2025-09-02 13:15:00',5,66992,45975,NULL,NULL,NULL,'2025-09-02 06:16:23','2025-09-02 06:16:23'),
(4191,2,'credit',NULL,200000.0000,NULL,'2025-09-02 13:33:35',19,66968,45976,NULL,NULL,NULL,'2025-09-02 06:33:35','2025-10-12 13:28:39'),
(4192,2,'credit',NULL,100000.0000,NULL,'2025-09-02 16:17:18',13,66979,45983,NULL,NULL,NULL,'2025-09-02 09:17:18','2025-09-02 09:17:18'),
(4193,2,'credit',NULL,120000.0000,NULL,'2025-09-02 17:53:03',143,67005,45986,NULL,NULL,NULL,'2025-09-02 10:53:03','2025-09-02 10:53:03'),
(4194,2,'credit',NULL,10890000.0000,NULL,'2025-09-02 18:47:57',19,67009,45992,NULL,NULL,NULL,'2025-09-02 11:47:57','2025-09-02 11:48:48'),
(4195,2,'credit',NULL,6250000.0000,NULL,'2025-09-02 20:39:25',143,67016,45996,NULL,NULL,NULL,'2025-09-02 13:39:25','2025-09-02 14:21:39'),
(4196,2,'credit',NULL,80000.0000,NULL,'2025-09-02 21:12:16',143,66953,45998,NULL,NULL,NULL,'2025-09-02 14:12:16','2025-09-02 14:12:16'),
(4197,2,'credit',NULL,2175000.0000,NULL,'2025-09-03 08:42:06',49,67022,45999,NULL,NULL,NULL,'2025-09-03 01:42:06','2025-09-03 01:42:06'),
(4198,2,'debit',NULL,28262200.0000,NULL,'2025-09-03 10:12:00',1,66747,46004,NULL,NULL,NULL,'2025-09-03 03:12:42','2025-09-03 03:12:42'),
(4199,2,'credit',NULL,160000.0000,NULL,'2025-09-03 10:24:29',49,66956,46005,NULL,NULL,NULL,'2025-09-03 03:24:29','2025-09-03 03:24:29'),
(4200,2,'debit',NULL,17519562.0000,NULL,'2025-09-03 13:08:00',1,66336,46015,NULL,NULL,NULL,'2025-09-03 06:09:51','2025-09-03 06:09:51'),
(4201,2,'credit',NULL,76400000.0000,NULL,'2025-09-03 14:08:00',19,67045,46016,NULL,NULL,NULL,'2025-09-03 07:08:12','2025-09-03 07:08:12'),
(4202,2,'credit',NULL,200000.0000,NULL,'2025-09-03 14:52:35',5,67046,46017,NULL,NULL,NULL,'2025-09-03 07:52:35','2025-10-05 06:10:32'),
(4203,2,'credit',NULL,503500.0000,NULL,'2025-09-03 17:06:59',5,66914,46020,NULL,NULL,NULL,'2025-09-03 10:06:59','2025-09-08 01:39:27'),
(4204,2,'credit',NULL,150000.0000,NULL,'2025-09-03 18:20:30',143,66545,46021,NULL,NULL,NULL,'2025-09-03 11:20:30','2025-09-03 11:20:30'),
(4205,2,'credit',NULL,378000.0000,NULL,'2025-09-03 18:22:06',143,67055,46022,NULL,NULL,NULL,'2025-09-03 11:22:06','2025-09-03 11:22:06'),
(4206,2,'credit',NULL,59000.0000,NULL,'2025-09-03 19:47:44',143,67065,46032,NULL,NULL,NULL,'2025-09-03 12:47:44','2025-09-03 12:47:44'),
(4207,2,'credit',NULL,1186000.0000,NULL,'2025-09-03 20:32:58',19,67067,46038,NULL,NULL,NULL,'2025-09-03 13:32:59','2025-09-28 12:55:48'),
(4208,2,'debit',NULL,2400000.0000,NULL,'2025-09-04 08:16:00',49,67081,46044,NULL,NULL,NULL,'2025-09-04 01:17:36','2025-09-04 01:17:36'),
(4209,2,'credit',NULL,170000.0000,NULL,'2025-09-04 11:22:50',6,67093,46054,NULL,NULL,NULL,'2025-09-04 04:22:50','2025-09-28 13:06:30'),
(4210,2,'debit',NULL,2105000.0000,NULL,'2025-09-04 16:30:00',106,67117,46073,NULL,NULL,NULL,'2025-09-04 09:34:11','2025-09-04 09:34:11'),
(4211,2,'credit',NULL,150000.0000,NULL,'2025-09-04 18:34:08',143,67075,46081,NULL,NULL,NULL,'2025-09-04 11:34:08','2025-09-04 11:34:08'),
(4212,2,'credit',NULL,359000.0000,NULL,'2025-09-04 18:34:29',143,67125,46082,NULL,NULL,NULL,'2025-09-04 11:34:29','2025-09-04 11:34:29'),
(4213,2,'credit',NULL,255000.0000,NULL,'2025-09-06 08:42:36',13,67006,46095,NULL,NULL,NULL,'2025-09-06 01:42:36','2025-09-06 01:42:36'),
(4214,2,'credit',NULL,2095000.0000,NULL,'2025-09-06 09:48:02',13,67144,46098,NULL,NULL,NULL,'2025-09-06 02:48:02','2025-09-06 02:48:02'),
(4215,2,'credit',NULL,1560000.0000,NULL,'2025-09-06 10:14:24',6,67149,46102,NULL,NULL,NULL,'2025-09-06 03:14:24','2025-09-06 03:14:24'),
(4216,2,'credit',NULL,2545000.0000,NULL,'2025-09-06 11:44:14',49,67152,46104,NULL,NULL,NULL,'2025-09-06 04:44:14','2025-09-07 08:35:33'),
(4217,2,'credit',NULL,635000.0000,NULL,'2025-09-06 11:49:39',13,67155,46105,NULL,NULL,NULL,'2025-09-06 04:49:39','2025-10-02 04:06:52'),
(4218,2,'debit',NULL,447000.0000,NULL,'2025-09-06 12:50:00',49,67162,46111,NULL,NULL,NULL,'2025-09-06 05:52:29','2025-09-06 05:52:29'),
(4219,2,'debit',NULL,225000.0000,NULL,'2025-09-06 13:20:00',19,67164,46113,NULL,NULL,NULL,'2025-09-06 06:22:22','2025-09-06 06:22:22'),
(4220,2,'credit',NULL,185000.0000,NULL,'2025-09-06 13:32:00',5,66636,46114,NULL,NULL,NULL,'2025-09-06 06:32:00','2025-09-06 06:32:00'),
(4221,2,'debit',NULL,460000.0000,NULL,'2025-09-06 15:05:00',13,67171,46115,NULL,NULL,NULL,'2025-09-06 08:08:40','2025-09-06 08:08:40'),
(4222,2,'debit',NULL,6318110.0000,NULL,'2025-09-06 15:28:00',5,67172,46116,NULL,NULL,'2025-09-06 08:33:47','2025-09-06 08:31:20','2025-09-06 08:33:47'),
(4223,2,'credit',NULL,232000.0000,NULL,'2025-09-06 15:34:57',49,67173,46117,NULL,NULL,NULL,'2025-09-06 08:34:57','2025-09-06 08:34:57'),
(4224,2,'debit',NULL,185000.0000,NULL,'2025-09-06 16:39:00',6,67181,46120,NULL,NULL,NULL,'2025-09-06 09:40:08','2025-09-06 09:40:08'),
(4225,2,'debit',NULL,6675000.0000,NULL,'2025-09-06 17:10:00',13,67186,46123,NULL,NULL,NULL,'2025-09-06 10:11:27','2025-09-06 10:11:27'),
(4226,2,'credit',NULL,200000.0000,NULL,'2025-09-08 08:15:16',19,67121,46167,NULL,NULL,NULL,'2025-09-08 01:15:17','2025-09-28 02:18:13'),
(4227,2,'credit',NULL,200000.0000,NULL,'2025-09-08 13:50:35',13,67196,46187,NULL,NULL,NULL,'2025-09-08 06:50:35','2025-09-25 09:02:18'),
(4228,2,'credit',NULL,8064158.0000,NULL,'2025-09-08 15:11:38',5,62319,46191,NULL,NULL,'2025-10-01 06:44:54','2025-09-08 08:11:38','2025-10-01 06:44:54'),
(4229,2,'credit',NULL,1420000.0000,NULL,'2025-09-08 19:43:02',49,67274,46205,NULL,NULL,NULL,'2025-09-08 12:43:02','2025-09-09 07:10:09'),
(4230,2,'credit',NULL,590000.0000,NULL,'2025-09-08 20:44:20',13,67260,46210,NULL,NULL,NULL,'2025-09-08 13:44:20','2025-09-08 13:44:20'),
(4231,2,'credit',NULL,650000.0000,NULL,'2025-09-09 10:18:15',10,66158,46215,NULL,NULL,NULL,'2025-09-09 03:18:15','2025-09-09 03:18:15'),
(4232,2,'debit',NULL,820600.0000,NULL,'2025-09-09 12:17:00',19,67299,46227,NULL,NULL,NULL,'2025-09-09 05:22:56','2025-09-09 05:22:56'),
(4233,2,'debit',NULL,1107000.0000,NULL,'2025-09-09 13:46:00',13,67304,46230,NULL,NULL,NULL,'2025-09-09 06:47:25','2025-09-09 06:47:25'),
(4234,2,'debit',NULL,665000.0000,NULL,'2025-09-09 20:23:00',6,67340,46265,NULL,NULL,NULL,'2025-09-09 13:25:19','2025-09-09 13:25:19'),
(4235,2,'debit',NULL,149000.0000,NULL,'2025-09-10 14:44:00',13,67371,46287,NULL,NULL,NULL,'2025-09-10 07:45:41','2025-09-10 07:45:41'),
(4236,2,'credit',NULL,272000.0000,NULL,'2025-09-10 15:37:20',49,67373,46290,NULL,NULL,NULL,'2025-09-10 08:37:20','2025-10-01 08:25:38'),
(4237,2,'credit',NULL,21000.0000,NULL,'2025-09-10 17:27:03',6,67378,46296,NULL,NULL,NULL,'2025-09-10 10:27:03','2025-09-10 10:27:03'),
(4238,2,'credit',NULL,1000000.0000,NULL,'2025-09-11 11:04:53',5,66387,46300,NULL,NULL,NULL,'2025-09-11 04:04:53','2025-09-30 06:18:58'),
(4239,2,'debit',NULL,326900.0000,NULL,'2025-09-11 11:14:00',5,67390,46301,NULL,NULL,NULL,'2025-09-11 04:15:56','2025-09-11 04:15:56'),
(4240,2,'debit',NULL,3518266.0000,NULL,'2025-09-11 19:46:00',1,66153,46318,NULL,NULL,NULL,'2025-09-11 12:46:56','2025-09-11 12:46:56'),
(4241,2,'credit',NULL,920000.0000,NULL,'2025-09-13 08:53:16',143,67448,46346,NULL,NULL,NULL,'2025-09-13 01:53:16','2025-09-13 01:53:16'),
(4242,2,'debit',NULL,549300.0000,NULL,'2025-09-13 16:12:00',13,67479,46365,NULL,NULL,NULL,'2025-09-13 09:13:39','2025-09-13 09:13:39'),
(4243,2,'debit',NULL,114000.0000,NULL,'2025-09-13 16:14:00',13,67480,46366,NULL,NULL,NULL,'2025-09-13 09:15:22','2025-09-13 09:15:22'),
(4244,2,'debit',NULL,60000.0000,NULL,'2025-09-13 16:23:00',143,67481,46367,NULL,NULL,NULL,'2025-09-13 09:25:18','2025-09-13 09:25:18'),
(4245,2,'debit',NULL,290000.0000,NULL,'2025-09-13 17:30:00',106,67484,46370,NULL,NULL,NULL,'2025-09-13 10:32:03','2025-09-13 10:32:03'),
(4246,2,'credit',NULL,200000.0000,NULL,'2025-09-13 20:03:51',6,67432,46376,NULL,NULL,NULL,'2025-09-13 13:03:51','2025-10-29 05:32:23'),
(4247,2,'debit',NULL,452298.0000,NULL,'2025-09-14 13:13:00',19,67507,46390,NULL,NULL,NULL,'2025-09-14 06:15:36','2025-09-14 06:15:36'),
(4248,2,'credit',NULL,450000.0000,NULL,'2025-09-14 14:56:42',106,67451,46395,NULL,NULL,NULL,'2025-09-14 07:56:42','2025-09-21 06:33:09'),
(4249,2,'credit',NULL,200000.0000,NULL,'2025-09-14 14:59:37',49,67453,46396,NULL,NULL,NULL,'2025-09-14 07:59:37','2025-09-20 13:36:49'),
(4250,2,'credit',NULL,95000.0000,NULL,'2025-09-14 20:44:21',106,67054,46404,NULL,NULL,NULL,'2025-09-14 13:44:21','2025-09-14 13:44:21'),
(4251,2,'credit',NULL,200000.0000,NULL,'2025-09-15 08:27:33',13,67418,46410,NULL,NULL,NULL,'2025-09-15 01:27:33','2025-09-28 02:07:58'),
(4252,2,'debit',NULL,296000.0000,NULL,'2025-09-15 10:22:00',49,67537,46416,NULL,NULL,NULL,'2025-09-15 03:24:13','2025-09-15 03:24:13'),
(4253,2,'credit',NULL,520000.0000,NULL,'2025-09-15 14:46:20',106,67556,46432,NULL,NULL,NULL,'2025-09-15 07:46:20','2025-09-15 07:46:20'),
(4254,2,'credit',NULL,1120500.0000,NULL,'2025-09-15 14:51:28',49,67550,46434,NULL,NULL,NULL,'2025-09-15 07:51:28','2025-09-16 02:27:23'),
(4255,2,'debit',NULL,148000.0000,NULL,'2025-09-15 15:14:00',5,67563,46436,NULL,NULL,NULL,'2025-09-15 08:14:45','2025-09-15 08:14:45'),
(4256,2,'debit',NULL,385000.0000,NULL,'2025-09-15 15:21:00',106,67565,46438,NULL,NULL,NULL,'2025-09-15 08:26:55','2025-09-15 08:26:55'),
(4257,2,'credit',NULL,1500000.0000,NULL,'2025-09-15 20:45:25',5,56509,46454,NULL,NULL,NULL,'2025-09-15 13:45:25','2025-10-01 11:01:59'),
(4258,2,'credit',NULL,40000.0000,NULL,'2025-09-16 09:27:39',13,64101,46463,NULL,NULL,NULL,'2025-09-16 02:27:39','2025-09-16 02:27:39'),
(4259,2,'credit',NULL,3000000.0000,NULL,'2025-09-16 09:37:29',13,67169,46464,NULL,NULL,NULL,'2025-09-16 02:37:29','2025-09-20 05:23:34'),
(4260,2,'credit',NULL,916000.0000,NULL,'2025-09-16 12:02:21',49,64030,46472,NULL,NULL,NULL,'2025-09-16 05:02:21','2025-09-16 05:02:21'),
(4261,2,'credit',NULL,2821000.0000,NULL,'2025-09-16 08:53:05',13,56509,46460,NULL,NULL,NULL,'2025-09-16 05:30:59','2025-10-01 11:01:59'),
(4262,2,'debit',NULL,690000.0000,NULL,'2025-09-16 13:43:00',5,67607,46475,NULL,NULL,NULL,'2025-09-16 06:45:09','2025-09-16 06:45:09'),
(4263,2,'credit',NULL,500000.0000,NULL,'2025-09-16 13:45:48',5,67608,46476,NULL,NULL,NULL,'2025-09-16 06:45:48','2025-09-16 06:45:48'),
(4264,2,'debit',NULL,627500.0000,NULL,'2025-09-16 15:17:00',49,67618,46480,NULL,NULL,NULL,'2025-09-16 08:20:52','2025-09-16 08:20:52'),
(4265,2,'credit',NULL,1573000.0000,NULL,'2025-09-16 19:35:29',5,67626,46486,NULL,NULL,NULL,'2025-09-16 12:35:29','2025-09-16 14:34:08'),
(4266,2,'debit',NULL,348000.0000,NULL,'2025-09-17 13:38:00',5,67651,46500,NULL,NULL,NULL,'2025-09-17 06:39:38','2025-09-17 06:39:38'),
(4267,2,'debit',NULL,2700000.0000,NULL,'2025-09-17 14:10:00',5,67654,46501,NULL,NULL,NULL,'2025-09-17 07:11:13','2025-09-17 07:11:13'),
(4268,2,'debit',NULL,990000.0000,NULL,'2025-09-17 14:11:00',5,67655,46502,NULL,NULL,NULL,'2025-09-17 07:12:12','2025-09-17 07:12:12'),
(4269,2,'credit',NULL,80000.0000,NULL,'2025-09-18 10:00:15',13,67658,46522,NULL,NULL,NULL,'2025-09-18 03:00:15','2025-09-18 03:31:24'),
(4270,2,'debit',NULL,924000.0000,NULL,'2025-09-18 11:26:00',13,67683,46523,NULL,NULL,NULL,'2025-09-18 04:27:02','2025-09-18 04:27:02'),
(4271,2,'debit',NULL,420000.0000,NULL,'2025-09-18 11:23:00',106,67684,46524,NULL,NULL,NULL,'2025-09-18 04:27:17','2025-09-18 04:27:17'),
(4272,2,'credit',NULL,582000.0000,NULL,'2025-09-18 11:32:46',13,67682,46525,NULL,NULL,NULL,'2025-09-18 04:32:46','2025-10-01 11:06:50'),
(4273,2,'credit',NULL,195000.0000,NULL,'2025-09-18 15:45:11',49,67693,46537,NULL,NULL,NULL,'2025-09-18 08:45:11','2025-09-18 08:45:11'),
(4274,2,'credit',NULL,120000.0000,NULL,'2025-09-18 15:45:46',49,67554,46538,NULL,NULL,NULL,'2025-09-18 08:45:46','2025-09-30 04:23:45'),
(4275,2,'debit',NULL,100000.0000,NULL,'2025-09-18 15:45:00',106,67705,46539,NULL,NULL,NULL,'2025-09-18 08:46:32','2025-09-18 08:46:32'),
(4276,2,'debit',NULL,428000.0000,NULL,'2025-09-18 15:47:00',106,67706,46540,NULL,NULL,NULL,'2025-09-18 08:47:46','2025-09-18 08:47:46'),
(4277,2,'credit',NULL,120000.0000,NULL,'2025-09-18 15:51:24',49,67553,46541,NULL,NULL,NULL,'2025-09-18 08:51:24','2025-09-30 04:24:21'),
(4278,2,'credit',NULL,11170000.0000,NULL,'2025-09-18 16:11:41',106,67711,46545,NULL,NULL,NULL,'2025-09-18 09:11:41','2025-09-21 03:53:35'),
(4279,2,'debit',NULL,325000.0000,NULL,'2025-09-18 17:32:00',13,67721,46553,NULL,NULL,NULL,'2025-09-18 10:35:42','2025-09-18 10:35:42'),
(4280,2,'credit',NULL,1261000.0000,NULL,'2025-09-18 18:40:14',49,67710,46558,NULL,NULL,'2025-09-19 09:44:19','2025-09-18 11:40:14','2025-09-19 09:44:19'),
(4281,2,'debit',NULL,800000.0000,NULL,'2025-09-19 09:45:00',49,67745,46572,NULL,NULL,NULL,'2025-09-19 02:45:55','2025-09-19 02:45:55'),
(4282,2,'debit',NULL,428000.0000,NULL,'2025-09-19 11:00:00',13,67749,46574,NULL,NULL,NULL,'2025-09-19 04:03:38','2025-09-19 04:03:38'),
(4283,2,'debit',NULL,64300.0000,NULL,'2025-09-19 14:09:00',19,67755,46579,NULL,NULL,NULL,'2025-09-19 07:11:10','2025-09-19 07:11:10'),
(4284,2,'debit',NULL,335000.0000,NULL,'2025-09-19 15:43:00',49,67761,46583,NULL,NULL,NULL,'2025-09-19 08:51:07','2025-09-19 08:51:07'),
(4285,2,'credit',NULL,132000.0000,NULL,'2025-09-19 17:19:19',5,67762,46585,NULL,NULL,NULL,'2025-09-19 10:19:19','2025-09-19 10:19:19'),
(4286,2,'credit',NULL,5906000.0000,NULL,'2025-09-19 17:45:30',19,67751,46586,NULL,NULL,NULL,'2025-09-19 10:45:30','2025-09-19 10:45:30'),
(4287,2,'credit',NULL,1261000.0000,NULL,'2025-09-19 19:06:30',5,67774,46591,NULL,NULL,NULL,'2025-09-19 12:06:30','2025-10-01 11:12:29'),
(4288,2,'credit',NULL,2400000.0000,NULL,'2025-09-20 11:14:32',49,67792,46606,NULL,NULL,NULL,'2025-09-20 04:14:32','2025-10-02 04:06:28'),
(4289,2,'credit',NULL,2860000.0000,NULL,'2025-09-20 11:43:27',49,67169,46611,NULL,NULL,NULL,'2025-09-20 04:43:27','2025-09-20 05:23:34'),
(4290,2,'credit',NULL,532000.0000,NULL,'2025-09-20 11:43:53',49,67599,46612,NULL,NULL,NULL,'2025-09-20 04:43:53','2025-09-20 04:43:53'),
(4291,2,'credit',NULL,220000.0000,NULL,'2025-09-20 13:37:29',143,67642,46616,NULL,NULL,NULL,'2025-09-20 06:37:29','2025-09-20 07:50:26'),
(4292,2,'credit',NULL,699000.0000,NULL,'2025-09-20 14:49:50',143,67805,46617,NULL,NULL,NULL,'2025-09-20 07:49:50','2025-09-20 07:49:50'),
(4293,2,'credit',NULL,75000.0000,NULL,'2025-09-20 15:01:27',5,67807,46620,NULL,NULL,NULL,'2025-09-20 08:01:27','2025-09-20 08:01:27'),
(4294,2,'debit',NULL,125000.0000,NULL,'2025-09-20 15:50:00',19,67810,46621,NULL,NULL,NULL,'2025-09-20 08:51:02','2025-09-20 08:51:02'),
(4295,2,'debit',NULL,57000.0000,NULL,'2025-09-20 15:52:00',19,67811,46622,NULL,NULL,NULL,'2025-09-20 08:55:44','2025-09-20 08:55:44'),
(4296,2,'credit',NULL,1500000.0000,NULL,'2025-09-20 16:14:52',49,67809,46623,NULL,NULL,NULL,'2025-09-20 09:14:52','2025-10-22 02:58:46'),
(4297,2,'debit',NULL,58000.0000,NULL,'2025-09-20 17:15:00',5,67816,46624,NULL,NULL,NULL,'2025-09-20 10:16:18','2025-09-20 10:16:18'),
(4298,2,'credit',NULL,1140000.0000,NULL,'2025-09-20 18:54:18',5,67822,46627,NULL,NULL,NULL,'2025-09-20 11:54:18','2025-09-20 11:54:18'),
(4299,2,'debit',NULL,27019000.0000,NULL,'2025-09-20 20:07:00',19,67826,46631,NULL,NULL,NULL,'2025-09-20 13:09:58','2025-09-20 13:09:58'),
(4300,2,'credit',NULL,200000.0000,NULL,'2025-09-20 20:36:18',5,67829,46635,NULL,NULL,NULL,'2025-09-20 13:36:18','2025-09-20 13:36:18'),
(4301,2,'credit',NULL,207000.0000,NULL,'2025-09-20 20:43:34',5,67830,46638,NULL,NULL,NULL,'2025-09-20 13:43:34','2025-09-20 13:43:34'),
(4302,2,'credit',NULL,480000.0000,NULL,'2025-09-20 20:47:21',5,67502,46639,NULL,NULL,NULL,'2025-09-20 13:47:21','2025-09-20 13:47:21'),
(4303,2,'credit',NULL,895000.0000,NULL,'2025-09-21 12:34:22',6,67840,46648,NULL,NULL,NULL,'2025-09-21 05:34:22','2025-09-21 05:34:22'),
(4304,2,'credit',NULL,1200000.0000,NULL,'2025-09-21 12:41:15',106,67843,46650,NULL,NULL,NULL,'2025-09-21 05:41:15','2025-09-21 05:47:43'),
(4305,2,'credit',NULL,3125000.0000,NULL,'2025-09-05 15:45:00',6,57826,46653,NULL,NULL,NULL,'2025-09-21 08:45:03','2025-09-28 06:32:30'),
(4306,2,'credit',NULL,150000.0000,NULL,'2025-09-21 19:13:41',49,67833,46666,NULL,NULL,NULL,'2025-09-21 12:13:41','2025-09-21 12:13:41'),
(4307,2,'credit',NULL,20000.0000,NULL,'2025-09-21 19:15:15',49,67854,46667,NULL,NULL,NULL,'2025-09-21 12:15:15','2025-09-21 12:15:15'),
(4308,2,'credit',NULL,80000.0000,NULL,'2025-09-22 08:37:38',5,67656,46675,NULL,NULL,NULL,'2025-09-22 01:37:38','2025-09-22 01:37:38'),
(4309,2,'debit',NULL,85000.0000,NULL,'2025-09-22 11:15:00',19,67870,46682,NULL,NULL,NULL,'2025-09-22 04:16:02','2025-09-22 04:16:02'),
(4310,2,'debit',NULL,100000.0000,NULL,'2025-09-22 13:42:00',106,67887,46693,NULL,NULL,NULL,'2025-09-22 06:43:55','2025-09-22 06:43:55'),
(4311,2,'credit',NULL,104000.0000,NULL,'2025-09-22 14:33:09',6,67698,46697,NULL,NULL,NULL,'2025-09-22 07:33:09','2025-09-22 07:37:08'),
(4312,2,'debit',NULL,101100.0000,NULL,'2025-09-22 14:46:00',13,67890,46699,NULL,NULL,NULL,'2025-09-22 07:57:48','2025-09-22 07:57:48'),
(4313,2,'debit',NULL,1872500.0000,NULL,'2025-09-22 14:56:00',5,67892,46700,NULL,NULL,NULL,'2025-09-22 07:59:33','2025-09-22 07:59:33'),
(4314,2,'debit',NULL,300000.0000,NULL,'2025-09-22 15:34:00',49,67899,46704,NULL,NULL,NULL,'2025-09-22 08:35:16','2025-09-22 08:35:16'),
(4315,2,'credit',NULL,1000000.0000,NULL,'2025-09-22 16:13:04',49,67905,46709,NULL,NULL,NULL,'2025-09-22 09:13:04','2025-09-22 09:13:04'),
(4316,2,'credit',NULL,600000.0000,NULL,'2025-09-22 17:35:05',106,67911,46713,NULL,NULL,NULL,'2025-09-22 10:35:05','2025-09-29 12:41:19'),
(4317,2,'credit',NULL,2140000.0000,NULL,'2025-09-22 18:12:52',13,67908,46716,NULL,NULL,NULL,'2025-09-22 11:12:52','2025-09-22 11:12:52'),
(4318,2,'credit',NULL,120000.0000,NULL,'2025-09-22 18:13:17',13,67898,46717,NULL,NULL,NULL,'2025-09-22 11:13:17','2025-09-22 11:13:17'),
(4319,2,'credit',NULL,175000.0000,NULL,'2025-09-22 18:40:00',106,67863,46718,NULL,NULL,NULL,'2025-09-22 11:40:00','2025-09-22 11:40:00'),
(4320,2,'credit',NULL,6990000.0000,NULL,'2025-09-22 18:40:38',13,67857,46719,NULL,NULL,NULL,'2025-09-22 11:40:38','2025-09-25 09:52:33'),
(4321,2,'credit',NULL,50000.0000,NULL,'2025-09-22 20:38:46',6,67921,46723,NULL,NULL,NULL,'2025-09-22 13:38:46','2025-09-22 13:38:46'),
(4322,2,'debit',NULL,610000.0000,NULL,'2025-09-23 09:37:00',19,67925,46727,NULL,NULL,NULL,'2025-09-23 02:38:05','2025-09-23 02:38:05'),
(4323,2,'credit',NULL,2275000.0000,NULL,'2025-09-23 10:21:44',5,67927,46731,NULL,NULL,NULL,'2025-09-23 03:21:44','2025-09-23 03:21:44'),
(4324,2,'credit',NULL,650000.0000,NULL,'2025-09-23 11:57:14',19,67941,46738,NULL,NULL,NULL,'2025-09-23 04:57:14','2025-09-23 04:57:14'),
(4325,2,'debit',NULL,50000.0000,NULL,'2025-09-23 14:59:00',13,67954,46747,NULL,NULL,NULL,'2025-09-23 08:00:06','2025-09-23 08:00:06'),
(4326,2,'credit',NULL,181000.0000,NULL,'2025-09-23 15:45:07',49,67960,46750,NULL,NULL,NULL,'2025-09-23 08:45:07','2025-10-01 11:19:48'),
(4327,2,'debit',NULL,510000.0000,NULL,'2025-09-23 16:49:00',5,67965,46755,NULL,NULL,NULL,'2025-09-23 09:50:26','2025-09-23 09:50:26'),
(4328,2,'debit',NULL,145000.0000,NULL,'2025-09-23 16:50:00',5,67966,46756,NULL,NULL,NULL,'2025-09-23 09:51:01','2025-09-23 09:51:01'),
(4329,2,'credit',NULL,100000.0000,NULL,'2025-09-23 18:00:52',49,67932,46760,NULL,NULL,NULL,'2025-09-23 11:00:52','2025-09-25 02:01:40'),
(4330,2,'debit',NULL,4403000.0000,NULL,'2025-09-23 18:24:00',49,67971,46761,NULL,NULL,NULL,'2025-09-23 11:27:18','2025-09-23 11:27:18'),
(4331,2,'credit',NULL,150000.0000,NULL,'2025-09-24 08:53:51',146,67987,46776,NULL,NULL,NULL,'2025-09-24 01:53:51','2025-09-25 01:45:16'),
(4332,2,'credit',NULL,200000.0000,NULL,'2025-09-24 09:05:00',19,67918,46777,NULL,NULL,NULL,'2025-09-24 02:05:50','2025-09-24 06:02:20'),
(4333,2,'debit',NULL,136666.0000,NULL,'2025-09-24 09:53:00',19,67991,46781,NULL,NULL,NULL,'2025-09-24 02:56:50','2025-09-24 02:56:50'),
(4334,2,'debit',NULL,241000.0000,NULL,'2025-09-24 10:12:00',19,67995,46783,NULL,NULL,NULL,'2025-09-24 03:22:41','2025-09-24 03:22:41'),
(4335,2,'debit',NULL,229000.0000,NULL,'2025-09-24 11:02:00',5,68002,46786,NULL,NULL,NULL,'2025-09-24 04:03:53','2025-09-24 04:03:53'),
(4336,2,'debit',NULL,40800.0000,NULL,'2025-09-24 12:34:00',19,68012,46795,NULL,NULL,NULL,'2025-09-24 05:35:17','2025-09-24 05:35:17'),
(4337,2,'credit',NULL,1000000.0000,NULL,'2025-09-24 12:54:22',5,68011,46796,NULL,NULL,NULL,'2025-09-24 05:54:22','2025-09-24 14:43:31'),
(4338,2,'debit',NULL,636000.0000,NULL,'2025-09-24 13:55:00',106,68021,46801,NULL,NULL,NULL,'2025-09-24 06:56:50','2025-09-24 06:56:50'),
(4339,2,'credit',NULL,2491000.0000,NULL,'2025-09-24 13:45:58',13,67809,46800,NULL,NULL,NULL,'2025-09-24 07:24:49','2025-10-22 02:58:46'),
(4340,2,'credit',NULL,2924000.0000,NULL,'2025-09-24 14:48:14',5,67792,46802,NULL,NULL,NULL,'2025-09-24 07:48:14','2025-10-02 04:06:28'),
(4341,2,'debit',NULL,860000.0000,NULL,'2025-09-24 14:49:00',5,68025,46803,NULL,NULL,NULL,'2025-09-24 07:51:11','2025-09-24 07:51:11'),
(4342,2,'debit',NULL,294000.0000,NULL,'2025-09-24 14:51:00',5,68026,46804,NULL,NULL,NULL,'2025-09-24 07:51:54','2025-09-24 07:51:54'),
(4343,2,'credit',NULL,200000.0000,NULL,'2025-09-24 15:24:06',13,68010,46806,NULL,NULL,NULL,'2025-09-24 08:24:06','2025-10-31 05:07:24'),
(4344,2,'credit',NULL,450000.0000,NULL,'2025-09-24 15:29:44',5,68015,46807,NULL,NULL,NULL,'2025-09-24 08:29:44','2025-09-24 08:29:44'),
(4345,2,'debit',NULL,100000.0000,NULL,'2025-09-24 15:31:00',13,68029,46808,NULL,NULL,NULL,'2025-09-24 08:31:46','2025-09-24 08:31:46'),
(4346,2,'debit',NULL,856000.0000,NULL,'2025-09-24 20:12:00',106,68050,46826,NULL,NULL,NULL,'2025-09-24 13:14:02','2025-09-24 13:14:02'),
(4347,2,'credit',NULL,65000.0000,NULL,'2025-09-24 20:39:59',6,68053,46827,NULL,NULL,NULL,'2025-09-24 13:39:59','2025-09-24 13:39:59'),
(4348,2,'credit',NULL,816000.0000,NULL,'2025-09-24 21:17:51',13,68011,46829,NULL,NULL,NULL,'2025-09-24 14:17:51','2025-09-24 14:43:31'),
(4349,2,'credit',NULL,100000.0000,NULL,'2025-09-25 09:01:33',49,68058,46833,NULL,NULL,NULL,'2025-09-25 02:01:33','2025-09-25 02:01:33'),
(4350,2,'debit',NULL,400000.0000,NULL,'2025-09-25 09:03:00',49,68059,46837,NULL,NULL,NULL,'2025-09-25 02:05:57','2025-09-25 02:05:57'),
(4351,2,'credit',NULL,80000.0000,NULL,'2025-09-25 10:43:36',5,68064,46843,NULL,NULL,NULL,'2025-09-25 03:43:36','2025-09-25 03:43:36'),
(4352,2,'debit',NULL,75000.0000,NULL,'2025-09-25 14:36:00',143,68082,46849,NULL,NULL,NULL,'2025-09-25 07:39:17','2025-09-25 07:39:17'),
(4353,2,'credit',NULL,200000.0000,NULL,'2025-09-25 14:51:14',6,68083,46850,NULL,NULL,NULL,'2025-09-25 07:51:14','2025-09-30 08:02:35'),
(4354,2,'credit',NULL,331000.0000,NULL,'2025-09-25 16:02:15',106,68086,46852,NULL,NULL,NULL,'2025-09-25 09:02:15','2025-09-25 09:02:15'),
(4355,2,'credit',NULL,850000.0000,NULL,'2025-09-25 16:02:18',106,67196,46853,NULL,NULL,NULL,'2025-09-25 09:02:18','2025-09-25 09:02:18'),
(4356,2,'credit',NULL,1600000.0000,NULL,'2025-09-25 16:34:51',19,68091,46859,NULL,NULL,NULL,'2025-09-25 09:34:51','2025-10-06 06:24:39'),
(4357,2,'credit',NULL,6990000.0000,NULL,'2025-09-25 16:52:33',49,67857,46860,NULL,NULL,NULL,'2025-09-25 09:52:33','2025-09-25 09:52:33'),
(4358,2,'credit',NULL,140000.0000,NULL,'2025-09-25 19:11:54',13,68098,46866,NULL,NULL,NULL,'2025-09-25 12:11:54','2025-09-25 12:11:54'),
(4359,2,'credit',NULL,450000.0000,NULL,'2025-09-25 19:12:11',13,67969,46867,NULL,NULL,NULL,'2025-09-25 12:12:11','2025-10-01 06:08:08'),
(4360,2,'debit',NULL,8539298.0000,NULL,'2025-09-26 09:26:00',5,68105,46873,NULL,NULL,NULL,'2025-09-26 02:59:08','2025-09-26 02:59:08'),
(4361,2,'credit',NULL,175000.0000,NULL,'2025-09-26 10:49:47',5,68106,46874,NULL,NULL,NULL,'2025-09-26 03:49:47','2025-09-26 03:49:47'),
(4362,2,'credit',NULL,714000.0000,NULL,'2025-09-26 12:38:22',19,66194,46878,NULL,NULL,NULL,'2025-09-26 05:38:22','2025-09-26 05:38:22'),
(4363,2,'debit',NULL,260718.0000,NULL,'2025-09-26 13:37:00',13,68118,46881,NULL,NULL,'2025-10-05 11:09:47','2025-09-26 06:38:43','2025-10-05 11:09:47'),
(4364,2,'debit',NULL,102282.0000,NULL,'2025-09-26 14:26:00',13,68121,46884,NULL,NULL,NULL,'2025-09-26 07:27:05','2025-09-26 07:27:05'),
(4365,2,'debit',NULL,295000.0000,NULL,'2025-09-26 15:22:00',49,68123,46887,NULL,NULL,NULL,'2025-09-26 08:23:24','2025-09-26 08:23:24'),
(4366,2,'credit',NULL,525000.0000,NULL,'2025-09-26 16:23:43',146,67688,46889,NULL,NULL,NULL,'2025-09-26 09:23:43','2025-09-26 09:23:43'),
(4367,2,'credit',NULL,15000.0000,NULL,'2025-09-26 17:12:53',146,68132,46896,NULL,NULL,NULL,'2025-09-26 10:12:53','2025-09-27 04:15:45'),
(4368,2,'credit',NULL,380000.0000,NULL,'2025-09-26 17:44:57',13,68134,46897,NULL,NULL,NULL,'2025-09-26 10:44:57','2025-09-26 10:44:57'),
(4369,2,'credit',NULL,150000.0000,NULL,'2025-09-26 17:45:11',13,67776,46898,NULL,NULL,NULL,'2025-09-26 10:45:11','2025-09-26 10:45:11'),
(4370,2,'debit',NULL,495000.0000,NULL,'2025-09-26 20:46:00',13,68143,46906,NULL,NULL,NULL,'2025-09-26 13:47:56','2025-09-26 13:47:56'),
(4371,2,'credit',NULL,122000.0000,NULL,'2025-09-27 11:17:39',146,68158,46916,NULL,NULL,NULL,'2025-09-27 04:17:39','2025-09-27 04:17:39'),
(4372,2,'credit',NULL,525000.0000,NULL,'2025-09-27 11:22:15',146,68159,46917,NULL,NULL,NULL,'2025-09-27 04:22:15','2025-09-27 04:22:15'),
(4373,2,'credit',NULL,647000.0000,NULL,'2025-09-27 12:16:12',5,68160,46918,NULL,NULL,NULL,'2025-09-27 05:16:12','2025-10-01 11:31:00'),
(4374,2,'credit',NULL,200000.0000,NULL,'2025-09-27 14:25:09',49,68033,46925,NULL,NULL,NULL,'2025-09-27 07:25:09','2025-10-22 03:37:43'),
(4375,2,'debit',NULL,3885000.0000,NULL,'2025-09-27 14:46:00',5,68173,46928,NULL,NULL,NULL,'2025-09-27 07:47:37','2025-09-27 07:47:37'),
(4376,2,'credit',NULL,200000.0000,NULL,'2025-09-27 18:43:13',6,68099,46935,NULL,NULL,NULL,'2025-09-27 11:43:13','2025-11-02 13:34:12'),
(4377,2,'credit',NULL,84000.0000,NULL,'2025-09-28 10:15:15',6,67846,46942,NULL,NULL,NULL,'2025-09-28 03:15:15','2025-09-28 03:15:15'),
(4378,2,'credit',NULL,881000.0000,NULL,'2025-09-28 13:01:13',13,64099,46947,NULL,NULL,NULL,'2025-09-28 06:01:13','2025-09-28 06:01:13'),
(4379,2,'credit',NULL,4000000.0000,NULL,'2025-09-22 13:32:00',19,57826,46951,NULL,NULL,NULL,'2025-09-28 06:32:30','2025-09-28 06:35:52'),
(4380,2,'debit',NULL,57000.0000,NULL,'2025-09-28 14:36:00',5,68216,46952,NULL,NULL,NULL,'2025-09-28 07:37:24','2025-09-28 07:37:24'),
(4381,2,'debit',NULL,470000.0000,NULL,'2025-09-28 14:45:00',13,68217,46953,NULL,NULL,NULL,'2025-09-28 07:46:55','2025-09-28 07:46:55'),
(4382,2,'credit',NULL,312500.0000,NULL,'2025-09-28 19:48:19',19,68239,46964,NULL,NULL,NULL,'2025-09-28 12:48:19','2025-09-28 14:49:38'),
(4383,2,'credit',NULL,788000.0000,NULL,'2025-09-28 19:50:55',19,68241,46967,NULL,NULL,NULL,'2025-09-28 12:50:55','2025-09-28 12:51:19'),
(4384,2,'credit',NULL,255000.0000,NULL,'2025-09-28 19:57:13',19,68242,46968,NULL,NULL,NULL,'2025-09-28 12:57:13','2025-09-28 12:57:13'),
(4385,2,'credit',NULL,255000.0000,NULL,'2025-09-28 19:57:56',19,68243,46969,NULL,NULL,NULL,'2025-09-28 12:57:56','2025-09-28 12:57:56'),
(4386,2,'credit',NULL,40000.0000,NULL,'2025-09-28 20:09:41',19,68246,46974,NULL,NULL,NULL,'2025-09-28 13:09:41','2025-09-28 13:09:41'),
(4387,2,'credit',NULL,40000.0000,NULL,'2025-09-28 20:10:39',19,68247,46975,NULL,NULL,NULL,'2025-09-28 13:10:39','2025-09-28 13:10:39'),
(4388,2,'credit',NULL,0.0000,NULL,'2025-09-28 20:21:35',5,68228,46976,NULL,NULL,NULL,'2025-09-28 13:21:35','2025-09-30 02:14:40'),
(4389,2,'credit',NULL,500000.0000,NULL,'2025-09-29 09:38:00',106,68260,46988,NULL,NULL,NULL,'2025-09-29 02:38:00','2025-09-30 09:29:40'),
(4390,2,'debit',NULL,9789060.0000,NULL,'2025-09-29 13:11:00',13,68276,47001,NULL,NULL,NULL,'2025-09-29 06:15:36','2025-09-29 06:15:36'),
(4391,2,'credit',NULL,230000.0000,NULL,'2025-09-29 18:24:56',143,68299,47022,NULL,NULL,NULL,'2025-09-29 11:25:46','2025-09-29 11:25:46'),
(4392,2,'debit',NULL,882000.0000,NULL,'2025-09-30 09:04:00',106,68312,47036,NULL,NULL,NULL,'2025-09-30 02:05:37','2025-09-30 02:05:37'),
(4393,2,'credit',NULL,50000.0000,NULL,'2025-09-30 09:15:49',49,68313,47037,NULL,NULL,NULL,'2025-09-30 02:15:49','2025-09-30 05:47:49'),
(4394,2,'debit',NULL,110000.0000,NULL,'2025-09-30 10:31:00',106,68322,47043,NULL,NULL,'2025-09-30 08:11:18','2025-09-30 03:32:28','2025-09-30 08:11:18'),
(4395,2,'credit',NULL,1280000.0000,NULL,'2025-09-30 13:19:32',5,68333,47049,NULL,NULL,NULL,'2025-09-30 06:19:32','2025-09-30 06:19:32'),
(4396,2,'debit',NULL,770000.0000,NULL,'2025-09-30 13:20:00',5,68334,47050,NULL,NULL,NULL,'2025-09-30 06:21:40','2025-09-30 06:21:40'),
(4397,2,'credit',NULL,2034000.0000,NULL,'2025-09-30 14:25:00',13,NULL,47052,NULL,NULL,NULL,'2025-09-30 07:26:06','2025-09-30 07:26:06'),
(4398,2,'credit',NULL,4000000.0000,NULL,'2025-09-30 14:52:44',5,68338,47058,NULL,NULL,NULL,'2025-09-30 07:52:44','2025-10-08 12:49:56'),
(4399,2,'credit',NULL,125000.0000,NULL,'2025-09-30 15:01:22',19,68022,47059,NULL,NULL,NULL,'2025-09-30 08:01:22','2025-09-30 08:01:22'),
(4400,2,'credit',NULL,330000.0000,NULL,'2025-09-30 15:02:04',19,68083,47060,NULL,NULL,NULL,'2025-09-30 08:02:04','2025-09-30 08:02:35'),
(4401,2,'debit',NULL,980000.0000,NULL,'2025-09-30 15:45:00',13,68342,47063,NULL,NULL,NULL,'2025-09-30 08:46:25','2025-09-30 08:46:25'),
(4402,2,'debit',NULL,65000.0000,NULL,'2025-09-30 15:46:00',5,68343,47064,NULL,NULL,NULL,'2025-09-30 08:46:50','2025-09-30 08:46:50'),
(4403,2,'credit',NULL,495000.0000,NULL,'2025-09-30 16:29:40',106,68260,47067,NULL,NULL,NULL,'2025-09-30 09:29:40','2025-09-30 09:29:40'),
(4404,2,'credit',NULL,134000.0000,NULL,'2025-09-30 18:03:41',13,68360,47071,NULL,NULL,NULL,'2025-09-30 11:03:41','2025-10-01 11:35:01'),
(4405,2,'credit',NULL,34000.0000,NULL,'2025-09-30 18:53:48',19,68364,47074,NULL,NULL,NULL,'2025-09-30 11:53:48','2025-09-30 11:53:48'),
(4406,2,'credit',NULL,1250000.0000,NULL,'2025-09-30 19:09:44',13,68340,47076,NULL,NULL,NULL,'2025-09-30 12:09:44','2025-09-30 12:09:44'),
(4407,2,'credit',NULL,410000.0000,NULL,'2025-10-01 09:25:14',49,67485,47086,NULL,NULL,NULL,'2025-10-01 02:25:14','2025-10-01 02:25:14'),
(4408,2,'credit',NULL,390000.0000,NULL,'2025-10-01 09:25:33',49,67379,47087,NULL,NULL,NULL,'2025-10-01 02:25:33','2025-10-01 02:25:33'),
(4409,2,'credit',NULL,2700000.0000,NULL,'2025-10-01 12:20:32',106,68380,47105,NULL,NULL,NULL,'2025-10-01 05:24:16','2025-11-01 09:28:24'),
(4410,2,'credit',NULL,201000.0000,NULL,'2025-10-01 12:51:55',6,68382,47108,NULL,NULL,NULL,'2025-10-01 05:51:55','2025-10-04 05:28:07'),
(4411,2,'credit',NULL,7032000.0000,NULL,'2025-10-01 13:51:27',5,68385,47113,NULL,NULL,NULL,'2025-10-01 06:51:27','2025-10-01 06:51:27'),
(4412,2,'credit',NULL,3094716.0000,NULL,'2025-10-01 13:54:22',5,68386,47114,NULL,NULL,NULL,'2025-10-01 06:54:22','2025-10-01 06:56:44'),
(4413,2,'credit',NULL,1208997.0000,NULL,'2025-10-01 14:06:18',5,68388,47117,NULL,NULL,NULL,'2025-10-01 07:06:18','2025-10-01 07:06:18'),
(4414,2,'credit',NULL,1208997.0000,NULL,'2025-10-01 14:07:17',5,68389,47118,NULL,NULL,NULL,'2025-10-01 07:07:17','2025-10-01 07:07:17'),
(4415,2,'credit',NULL,1208997.0000,NULL,'2025-10-01 14:07:53',5,68390,47120,NULL,NULL,NULL,'2025-10-01 07:07:53','2025-10-01 07:07:53'),
(4416,2,'credit',NULL,150000.0000,NULL,'2025-10-01 14:19:31',13,68318,47122,NULL,NULL,NULL,'2025-10-01 07:19:31','2025-10-11 09:16:33'),
(4417,2,'debit',NULL,316000.0000,NULL,'2025-10-01 15:15:00',5,68393,47124,NULL,NULL,NULL,'2025-10-01 08:15:30','2025-10-01 08:15:30'),
(4418,2,'credit',NULL,75000.0000,NULL,'2025-10-01 15:20:25',5,68394,47125,NULL,NULL,NULL,'2025-10-01 08:20:25','2025-10-01 08:20:25'),
(4419,2,'credit',NULL,75000.0000,NULL,'2025-10-01 15:21:03',5,68395,47126,NULL,NULL,NULL,'2025-10-01 08:21:03','2025-10-01 08:21:03'),
(4420,2,'credit',NULL,50000.0000,NULL,'2025-10-01 15:24:02',5,68396,47128,NULL,NULL,NULL,'2025-10-01 08:24:02','2025-10-01 08:24:14'),
(4421,2,'credit',NULL,50000.0000,NULL,'2025-10-01 15:25:09',5,68397,47129,NULL,NULL,NULL,'2025-10-01 08:25:09','2025-10-01 08:25:09'),
(4422,2,'credit',NULL,525000.0000,NULL,'2025-10-01 17:56:56',5,68404,47135,NULL,NULL,NULL,'2025-10-01 10:56:56','2025-10-01 10:59:12'),
(4423,2,'credit',NULL,525000.0000,NULL,'2025-10-01 17:58:55',5,68405,47136,NULL,NULL,NULL,'2025-10-01 10:58:55','2025-10-01 10:58:55'),
(4424,2,'credit',NULL,102500.0000,NULL,'2025-10-01 18:05:38',5,68406,47138,NULL,NULL,NULL,'2025-10-01 11:05:38','2025-10-01 11:05:38'),
(4425,2,'credit',NULL,102500.0000,NULL,'2025-10-01 18:06:21',5,68407,47139,NULL,NULL,NULL,'2025-10-01 11:06:21','2025-10-01 11:07:27'),
(4426,2,'credit',NULL,187500.0000,NULL,'2025-10-01 18:11:01',5,68409,47142,NULL,NULL,NULL,'2025-10-01 11:11:01','2025-10-01 11:13:22'),
(4427,2,'credit',NULL,187500.0000,NULL,'2025-10-01 18:11:53',5,68410,47143,NULL,NULL,NULL,'2025-10-01 11:11:53','2025-10-01 11:13:00'),
(4428,2,'credit',NULL,87500.0000,NULL,'2025-10-01 18:20:25',5,68411,47144,NULL,NULL,NULL,'2025-10-01 11:20:25','2025-10-01 11:20:25'),
(4429,2,'credit',NULL,400000.0000,NULL,'2025-10-01 18:24:38',5,68412,47145,NULL,NULL,NULL,'2025-10-01 11:24:38','2025-10-01 11:26:20'),
(4430,2,'credit',NULL,400000.0000,NULL,'2025-10-01 18:25:01',5,68413,47146,NULL,NULL,NULL,'2025-10-01 11:25:01','2025-10-01 11:26:00'),
(4431,2,'credit',NULL,87500.0000,NULL,'2025-10-01 18:29:58',5,68415,47149,NULL,NULL,NULL,'2025-10-01 11:29:58','2025-10-01 11:29:58'),
(4432,2,'credit',NULL,87500.0000,NULL,'2025-10-01 18:30:35',5,68416,47150,NULL,NULL,NULL,'2025-10-01 11:30:35','2025-10-01 11:30:35'),
(4433,2,'credit',NULL,649000.0000,NULL,'2025-10-01 18:33:04',13,68420,47154,NULL,NULL,NULL,'2025-10-01 11:33:04','2025-10-01 11:33:04'),
(4434,2,'debit',NULL,963900.0000,NULL,'2025-10-01 19:32:00',19,68428,47160,NULL,NULL,NULL,'2025-10-01 12:33:51','2025-10-01 12:33:51'),
(4435,2,'credit',NULL,304000.0000,NULL,'2025-10-01 19:49:51',13,68429,47161,NULL,NULL,NULL,'2025-10-01 12:49:51','2025-10-01 12:49:51'),
(4436,2,'credit',NULL,195000.0000,NULL,'2025-10-01 19:50:48',13,68291,47162,NULL,NULL,NULL,'2025-10-01 12:50:48','2025-10-01 12:50:48'),
(4437,2,'debit',NULL,265000.0000,NULL,'2025-10-01 20:08:00',19,68430,47164,NULL,NULL,NULL,'2025-10-01 13:09:42','2025-10-01 13:09:42'),
(4438,2,'debit',NULL,3647750.0000,NULL,'2025-10-02 10:36:00',13,68442,47172,NULL,NULL,NULL,'2025-10-02 03:41:43','2025-10-02 03:41:43'),
(4439,2,'credit',NULL,12000000.0000,NULL,'2025-10-02 11:58:00',13,NULL,47177,NULL,NULL,NULL,'2025-10-02 04:59:24','2025-10-02 04:59:24'),
(4440,2,'credit',NULL,921000.0000,NULL,'2025-10-02 14:40:54',19,68455,47185,NULL,NULL,NULL,'2025-10-02 07:40:54','2025-10-30 07:19:55'),
(4441,2,'credit',NULL,381100.0000,NULL,'2025-10-02 15:21:17',5,68213,47186,NULL,NULL,NULL,'2025-10-02 08:21:17','2025-10-02 08:21:17'),
(4442,2,'debit',NULL,2820000.0000,NULL,'2025-10-02 17:29:00',5,68478,47196,NULL,NULL,NULL,'2025-10-02 10:31:50','2025-10-02 10:31:50'),
(4443,2,'credit',NULL,240000.0000,NULL,'2025-10-02 17:57:17',5,68479,47197,NULL,NULL,NULL,'2025-10-02 10:57:17','2025-10-03 13:31:24'),
(4444,2,'credit',NULL,62000.0000,NULL,'2025-10-03 11:25:52',106,68506,47229,NULL,NULL,NULL,'2025-10-03 04:25:52','2025-10-03 04:25:52'),
(4445,2,'debit',NULL,8063055.0000,NULL,'2025-10-03 15:33:00',146,68518,47236,NULL,NULL,NULL,'2025-10-03 08:41:39','2025-10-03 08:41:39'),
(4446,2,'debit',NULL,1175000.0000,NULL,'2025-10-03 15:42:00',106,68519,47237,NULL,NULL,NULL,'2025-10-03 08:43:21','2025-10-03 08:43:21'),
(4447,2,'debit',NULL,480000.0000,NULL,'2025-10-03 15:43:00',106,68520,47238,NULL,NULL,NULL,'2025-10-03 08:44:21','2025-10-03 08:44:21'),
(4448,2,'debit',NULL,197361.0000,NULL,'2025-10-03 15:49:00',13,68522,47239,NULL,NULL,NULL,'2025-10-03 08:52:54','2025-10-03 08:52:54'),
(4449,2,'debit',NULL,327639.0000,NULL,'2025-10-03 15:52:00',13,68523,47240,NULL,NULL,NULL,'2025-10-03 08:54:02','2025-10-03 08:54:02'),
(4450,2,'credit',NULL,1391000.0000,NULL,'2025-10-03 16:25:00',13,NULL,47242,NULL,NULL,NULL,'2025-10-03 09:25:38','2025-10-03 09:25:38'),
(4451,2,'credit',NULL,80000.0000,NULL,'2025-10-03 19:03:51',5,68483,47251,NULL,NULL,NULL,'2025-10-03 12:04:50','2025-10-03 12:04:50'),
(4452,2,'credit',NULL,200000.0000,NULL,'2025-10-03 20:42:03',19,68489,47262,NULL,NULL,NULL,'2025-10-03 13:42:03','2025-10-12 13:27:22'),
(4453,2,'credit',NULL,4195000.0000,NULL,'2025-10-03 21:04:44',146,68534,47263,NULL,NULL,NULL,'2025-10-03 14:04:44','2025-10-03 14:05:08'),
(4454,2,'debit',NULL,100300.0000,NULL,'2025-10-04 11:41:00',6,68546,47268,NULL,NULL,NULL,'2025-10-04 04:42:24','2025-10-04 04:42:24'),
(4455,2,'debit',NULL,50600.0000,NULL,'2025-10-04 13:31:00',5,68559,47274,NULL,NULL,NULL,'2025-10-04 06:34:51','2025-10-04 06:34:51'),
(4456,2,'debit',NULL,245000.0000,NULL,'2025-10-04 16:10:00',13,68569,47277,NULL,NULL,NULL,'2025-10-04 09:10:50','2025-10-04 09:10:50'),
(4457,2,'debit',NULL,488000.0000,NULL,'2025-10-04 16:10:00',13,68570,47278,NULL,NULL,NULL,'2025-10-04 09:11:38','2025-10-04 09:11:38'),
(4458,2,'debit',NULL,124000.0000,NULL,'2025-10-04 16:11:00',13,68571,47279,NULL,NULL,NULL,'2025-10-04 09:12:20','2025-10-04 09:12:20'),
(4459,2,'credit',NULL,8099000.0000,NULL,'2025-10-04 16:16:23',49,68573,47281,NULL,NULL,NULL,'2025-10-04 09:16:23','2025-10-04 09:16:23'),
(4460,2,'credit',NULL,452000.0000,NULL,'2025-10-04 17:23:47',143,68577,47282,NULL,NULL,NULL,'2025-10-04 10:23:47','2025-10-04 10:23:47'),
(4461,2,'credit',NULL,895000.0000,NULL,'2025-10-04 17:24:33',143,68484,47283,NULL,NULL,NULL,'2025-10-04 10:24:33','2025-10-04 10:55:53'),
(4462,2,'credit',NULL,290000.0000,NULL,'2025-10-05 09:17:58',5,68596,47292,NULL,NULL,NULL,'2025-10-05 02:17:58','2025-10-05 02:17:58'),
(4463,2,'credit',NULL,200000.0000,NULL,'2025-10-05 14:47:51',49,68044,47300,NULL,NULL,NULL,'2025-10-05 07:47:51','2025-11-20 01:35:41'),
(4464,2,'debit',NULL,800000.0000,NULL,'2025-10-05 15:00:00',5,68617,47301,NULL,NULL,NULL,'2025-10-05 08:02:02','2025-10-05 08:02:02'),
(4465,2,'credit',NULL,1500000.0000,NULL,'2025-10-05 17:52:23',49,68627,47308,NULL,NULL,NULL,'2025-10-05 10:52:23','2025-10-07 09:27:41'),
(4466,2,'credit',NULL,5700000.0000,NULL,'2025-10-05 21:13:49',143,68637,47314,NULL,NULL,NULL,'2025-10-05 14:13:49','2025-10-05 14:20:23'),
(4467,2,'debit',NULL,510000.0000,NULL,'2025-10-06 08:58:00',19,68639,47316,NULL,NULL,NULL,'2025-10-06 02:00:47','2025-10-06 02:00:47'),
(4468,2,'debit',NULL,11889120.0000,NULL,'2025-10-06 13:16:00',13,68655,47322,NULL,NULL,'2025-10-16 08:11:29','2025-10-06 06:21:25','2025-10-16 08:11:29'),
(4469,2,'credit',NULL,80000.0000,NULL,'2025-10-06 13:43:20',13,68372,47325,NULL,NULL,NULL,'2025-10-06 06:43:20','2025-10-06 06:43:20'),
(4470,2,'debit',NULL,2520000.0000,NULL,'2025-10-06 13:51:00',49,68656,47326,NULL,NULL,NULL,'2025-10-06 06:51:50','2025-10-06 06:51:50'),
(4471,2,'credit',NULL,150000.0000,NULL,'2025-10-06 15:05:21',49,67852,47331,NULL,NULL,NULL,'2025-10-06 08:05:21','2025-10-06 08:05:21'),
(4472,2,'credit',NULL,160000.0000,NULL,'2025-10-06 16:07:53',5,68645,47337,NULL,NULL,NULL,'2025-10-06 09:07:53','2025-10-06 09:14:51'),
(4473,2,'credit',NULL,194000.0000,NULL,'2025-10-06 16:15:49',5,68675,47338,NULL,NULL,NULL,'2025-10-06 09:15:49','2025-10-06 09:15:49'),
(4474,2,'debit',NULL,124000.0000,NULL,'2025-10-06 16:59:00',5,68679,47340,NULL,NULL,NULL,'2025-10-06 10:00:14','2025-10-06 10:00:14'),
(4475,2,'credit',NULL,200000.0000,NULL,'2025-10-06 21:37:59',6,68658,47359,NULL,NULL,NULL,'2025-10-06 14:37:59','2025-10-29 05:33:00'),
(4476,2,'credit',NULL,110000.0000,NULL,'2025-10-06 21:45:31',49,68664,47360,NULL,NULL,NULL,'2025-10-06 14:45:31','2025-10-25 07:39:14'),
(4477,2,'debit',NULL,971600.0000,NULL,'2025-10-06 21:54:00',13,68699,47362,NULL,NULL,NULL,'2025-10-06 14:56:02','2025-10-06 14:56:02'),
(4478,2,'debit',NULL,740000.0000,NULL,'2025-10-07 11:48:00',5,68712,47372,NULL,NULL,NULL,'2025-10-07 04:50:54','2025-10-07 04:50:54'),
(4479,2,'credit',NULL,1040000.0000,NULL,'2025-10-07 12:53:48',19,68717,47374,NULL,NULL,NULL,'2025-10-07 05:53:48','2025-10-07 05:53:48'),
(4480,2,'credit',NULL,200000.0000,NULL,'2025-10-07 12:59:53',19,68706,47376,NULL,NULL,NULL,'2025-10-07 05:59:53','2025-10-29 05:33:17'),
(4481,2,'credit',NULL,285000.0000,NULL,'2025-10-07 13:40:43',49,67610,47378,NULL,NULL,NULL,'2025-10-07 06:40:43','2025-10-07 10:06:33'),
(4482,2,'debit',NULL,390000.0000,NULL,'2025-10-07 14:20:00',6,68722,47380,NULL,NULL,NULL,'2025-10-07 07:21:41','2025-10-07 07:21:41'),
(4483,2,'credit',NULL,127000.0000,NULL,'2025-10-07 17:07:48',146,68735,47386,NULL,NULL,NULL,'2025-10-07 10:07:48','2025-10-07 10:07:48'),
(4484,2,'credit',NULL,4494000.0000,NULL,'2025-10-07 18:17:00',13,NULL,47387,NULL,NULL,NULL,'2025-10-07 11:18:16','2025-10-07 11:18:16'),
(4485,2,'credit',NULL,1270000.0000,NULL,'2025-10-08 14:02:35',106,68564,47402,NULL,NULL,NULL,'2025-10-08 07:02:35','2025-10-08 07:02:35'),
(4486,2,'debit',NULL,650000.0000,NULL,'2025-10-08 15:49:00',106,68773,47405,NULL,NULL,NULL,'2025-10-08 08:50:29','2025-10-08 08:50:29'),
(4487,2,'debit',NULL,418000.0000,NULL,'2025-10-08 15:50:00',106,68774,47406,NULL,NULL,NULL,'2025-10-08 08:52:19','2025-10-08 08:52:19'),
(4488,2,'debit',NULL,310000.0000,NULL,'2025-10-08 15:53:00',143,68775,47407,NULL,NULL,NULL,'2025-10-08 08:57:34','2025-10-08 08:57:34'),
(4489,2,'credit',NULL,3042000.0000,NULL,'2025-10-08 18:10:55',49,68785,47418,NULL,NULL,NULL,'2025-10-08 11:10:55','2025-10-13 12:27:46'),
(4490,2,'credit',NULL,3042000.0000,NULL,'2025-10-08 18:10:57',49,68786,47419,NULL,NULL,NULL,'2025-10-08 11:10:57','2025-10-13 12:28:17'),
(4491,2,'credit',NULL,4200000.0000,NULL,'2025-10-08 19:49:56',106,68338,47425,NULL,NULL,NULL,'2025-10-08 12:49:56','2025-10-08 12:49:56'),
(4492,2,'credit',NULL,220000.0000,NULL,'2025-10-08 21:45:03',143,68737,47430,NULL,NULL,NULL,'2025-10-08 14:45:03','2025-10-08 14:45:03'),
(4493,2,'credit',NULL,313000.0000,NULL,'2025-10-08 21:45:20',143,68798,47431,NULL,NULL,NULL,'2025-10-08 14:45:20','2025-10-08 14:45:20'),
(4494,2,'credit',NULL,200000.0000,NULL,'2025-10-09 08:26:47',5,68783,47432,NULL,NULL,NULL,'2025-10-09 01:26:47','2025-12-03 09:56:52'),
(4495,2,'credit',NULL,120000.0000,NULL,'2025-10-09 09:37:07',143,68707,47435,NULL,NULL,NULL,'2025-10-09 02:37:07','2025-10-09 02:37:07'),
(4496,2,'credit',NULL,5000.0000,NULL,'2025-10-09 10:10:00',19,68807,47442,NULL,NULL,NULL,'2025-10-09 03:10:19','2025-10-09 03:10:19'),
(4497,2,'credit',NULL,549000.0000,NULL,'2025-10-09 10:10:00',19,68806,47443,NULL,NULL,NULL,'2025-10-09 03:10:43','2025-10-09 03:10:43'),
(4498,2,'credit',NULL,565000.0000,NULL,'2025-10-09 10:11:00',19,68461,47444,NULL,NULL,NULL,'2025-10-09 03:11:06','2025-10-09 03:11:06'),
(4499,2,'credit',NULL,245000.0000,NULL,'2025-10-09 10:11:00',19,68460,47445,NULL,NULL,NULL,'2025-10-09 03:11:26','2025-10-09 03:11:26'),
(4500,2,'credit',NULL,128000.0000,NULL,'2025-10-09 10:39:23',143,68812,47446,NULL,NULL,NULL,'2025-10-09 03:39:23','2025-10-09 03:39:23'),
(4501,2,'debit',NULL,440000.0000,NULL,'2025-10-09 15:04:00',13,68830,47461,NULL,NULL,NULL,'2025-10-09 08:07:35','2025-10-09 08:07:35'),
(4502,2,'debit',NULL,63000.0000,NULL,'2025-10-09 15:34:00',5,68835,47462,NULL,NULL,NULL,'2025-10-09 08:35:47','2025-10-09 08:35:47'),
(4503,2,'debit',NULL,1040000.0000,NULL,'2025-10-09 15:38:00',5,68837,47463,NULL,NULL,NULL,'2025-10-09 08:40:54','2025-10-09 08:40:54'),
(4504,2,'debit',NULL,338000.0000,NULL,'2025-10-09 15:52:00',49,68838,47464,NULL,NULL,NULL,'2025-10-09 08:53:15','2025-10-09 08:53:15'),
(4505,2,'credit',NULL,48000.0000,NULL,'2025-10-09 19:58:39',106,68848,47472,NULL,NULL,NULL,'2025-10-09 12:58:39','2025-10-09 12:58:39'),
(4506,2,'credit',NULL,120000.0000,NULL,'2025-10-09 20:04:15',6,68824,47474,NULL,NULL,NULL,'2025-10-09 13:04:15','2025-10-09 13:04:15'),
(4507,2,'debit',NULL,528000.0000,NULL,'2025-10-10 11:41:00',19,68862,47486,NULL,NULL,NULL,'2025-10-10 04:42:47','2025-10-10 04:42:47'),
(4508,2,'debit',NULL,510000.0000,NULL,'2025-10-10 15:52:00',106,68873,47492,NULL,NULL,NULL,'2025-10-10 08:52:57','2025-10-10 08:52:57'),
(4509,2,'credit',NULL,37000.0000,NULL,'2025-10-10 19:58:18',13,68881,47499,NULL,NULL,NULL,'2025-10-10 12:58:18','2025-10-10 12:58:18'),
(4510,2,'credit',NULL,4000000.0000,NULL,'2025-10-11 08:25:51',5,67120,47503,NULL,NULL,NULL,'2025-10-11 01:25:51','2025-10-11 01:25:51'),
(4511,2,'debit',NULL,249000.0000,NULL,'2025-10-11 08:51:00',5,68887,47504,NULL,NULL,NULL,'2025-10-11 01:52:49','2025-10-11 01:52:49'),
(4512,2,'credit',NULL,130000.0000,NULL,'2025-10-11 09:55:45',5,68894,47510,NULL,NULL,NULL,'2025-10-11 02:55:45','2025-10-11 02:55:45'),
(4513,2,'credit',NULL,4000000.0000,NULL,'2025-10-11 11:14:59',5,68893,47512,NULL,NULL,NULL,'2025-10-11 04:14:59','2025-10-28 11:21:05'),
(4514,2,'credit',NULL,495000.0000,NULL,'2025-10-11 15:53:33',10,68919,47522,NULL,NULL,'2025-10-11 09:18:46','2025-10-11 08:53:33','2025-10-11 09:18:46'),
(4515,2,'credit',NULL,359000.0000,NULL,'2025-10-11 16:00:24',146,68918,47523,NULL,NULL,NULL,'2025-10-11 09:00:24','2025-10-25 07:51:50'),
(4516,2,'credit',NULL,245000.0000,NULL,'2025-10-11 16:21:20',10,68920,47524,NULL,NULL,NULL,'2025-10-11 09:21:20','2025-10-11 09:23:33'),
(4517,2,'credit',NULL,250000.0000,NULL,'2025-10-11 16:22:57',10,68920,47525,NULL,NULL,NULL,'2025-10-11 09:22:57','2025-10-11 09:23:33'),
(4518,2,'credit',NULL,5239000.0000,NULL,'2025-10-12 13:00:15',146,68893,47542,NULL,NULL,NULL,'2025-10-12 06:00:15','2025-10-28 11:21:05'),
(4519,2,'debit',NULL,1323610.0000,NULL,'2025-10-12 20:43:00',19,68974,47564,NULL,NULL,NULL,'2025-10-12 14:28:31','2025-10-12 14:28:31'),
(4520,2,'debit',NULL,1654254.0000,NULL,'2025-10-12 21:28:00',19,68975,47565,NULL,NULL,NULL,'2025-10-12 14:29:41','2025-10-12 14:29:41'),
(4521,2,'debit',NULL,434790.0000,NULL,'2025-10-12 21:29:00',19,68976,47566,NULL,NULL,NULL,'2025-10-12 14:30:41','2025-10-12 14:30:41'),
(4522,2,'debit',NULL,330000.0000,NULL,'2025-10-12 21:37:00',19,68977,47569,NULL,NULL,NULL,'2025-10-12 14:41:30','2025-10-12 14:41:30'),
(4523,2,'debit',NULL,383000.0000,NULL,'2025-10-13 09:05:00',49,68984,47572,NULL,NULL,NULL,'2025-10-13 02:06:35','2025-10-13 02:06:35'),
(4524,2,'debit',NULL,69400.0000,NULL,'2025-10-13 13:08:00',5,69006,47598,NULL,NULL,NULL,'2025-10-13 06:11:25','2025-10-13 06:11:25'),
(4525,2,'credit',NULL,297000.0000,NULL,'2025-10-13 13:15:49',6,69005,47600,NULL,NULL,'2025-10-30 06:52:04','2025-10-13 06:15:49','2025-10-30 06:52:04'),
(4526,2,'credit',NULL,275000.0000,NULL,'2025-10-13 15:17:25',5,69021,47608,NULL,NULL,NULL,'2025-10-13 08:17:25','2025-10-13 08:17:25'),
(4527,2,'debit',NULL,58300.0000,NULL,'2025-10-13 16:38:00',6,69028,47613,NULL,NULL,NULL,'2025-10-13 09:40:01','2025-10-13 09:40:01'),
(4528,2,'credit',NULL,147000.0000,NULL,'2025-10-13 17:01:25',6,69015,47617,NULL,NULL,NULL,'2025-10-13 10:01:25','2025-10-13 10:31:41'),
(4529,2,'credit',NULL,25000.0000,NULL,'2025-10-13 16:37:21',49,69027,47612,NULL,NULL,NULL,'2025-10-13 10:37:33','2025-10-13 10:37:33'),
(4530,2,'debit',NULL,532500.0000,NULL,'2025-10-13 19:12:00',5,69042,47625,NULL,NULL,NULL,'2025-10-13 12:14:08','2025-10-13 12:14:08'),
(4531,2,'debit',NULL,158000.0000,NULL,'2025-10-13 19:14:00',5,69043,47626,NULL,NULL,NULL,'2025-10-13 12:15:10','2025-10-13 12:15:10'),
(4532,2,'debit',NULL,840000.0000,NULL,'2025-10-13 19:20:00',5,69045,47627,NULL,NULL,NULL,'2025-10-13 12:21:21','2025-10-13 12:21:21'),
(4533,2,'debit',NULL,1400000.0000,NULL,'2025-10-13 19:21:00',5,69046,47628,NULL,NULL,NULL,'2025-10-13 12:22:27','2025-10-13 12:22:27'),
(4534,2,'debit',NULL,5463996.0000,NULL,'2025-10-13 19:28:00',5,69047,47629,NULL,NULL,NULL,'2025-10-13 12:31:43','2025-10-13 12:31:43'),
(4535,2,'debit',NULL,5365000.0000,NULL,'2025-10-13 19:40:00',5,69050,47631,NULL,NULL,NULL,'2025-10-13 12:47:50','2025-10-13 12:47:50'),
(4536,2,'debit',NULL,365500.0000,NULL,'2025-10-13 21:09:00',5,69058,47637,NULL,NULL,NULL,'2025-10-13 14:11:54','2025-10-13 14:11:54'),
(4537,2,'credit',NULL,3188000.0000,NULL,'2025-10-14 09:27:36',13,68955,47645,NULL,NULL,NULL,'2025-10-14 02:27:36','2025-11-01 07:44:25'),
(4538,2,'debit',NULL,35000.0000,NULL,'2025-10-14 11:07:00',106,69085,47648,NULL,NULL,NULL,'2025-10-14 04:09:26','2025-10-14 04:09:26'),
(4539,2,'credit',NULL,1205000.0000,NULL,'2025-10-14 12:06:45',49,69075,47651,NULL,NULL,NULL,'2025-10-14 05:06:45','2025-10-14 05:06:45'),
(4540,2,'debit',NULL,180000.0000,NULL,'2025-10-14 16:52:00',49,69177,47662,NULL,NULL,NULL,'2025-10-14 09:53:22','2025-10-14 09:53:22'),
(4541,2,'credit',NULL,200000.0000,NULL,'2025-10-14 16:56:12',49,69169,47664,NULL,NULL,NULL,'2025-10-14 09:56:12','2025-10-31 07:22:19'),
(4542,2,'debit',NULL,900000.0000,NULL,'2025-10-14 17:37:00',146,69184,47668,NULL,NULL,NULL,'2025-10-14 10:41:10','2025-10-14 10:41:10'),
(4543,2,'debit',NULL,700000.0000,NULL,'2025-10-14 17:42:00',146,69185,47669,NULL,NULL,NULL,'2025-10-14 10:44:00','2025-10-14 10:44:00'),
(4544,2,'credit',NULL,4410000.0000,NULL,'2025-10-15 08:35:42',106,69200,47682,NULL,NULL,NULL,'2025-10-15 01:35:42','2025-10-15 01:35:42'),
(4545,2,'credit',NULL,3953000.0000,NULL,'2025-10-15 09:05:28',106,69122,47684,NULL,NULL,NULL,'2025-10-15 02:05:28','2025-10-25 07:58:15'),
(4546,2,'debit',NULL,510000.0000,NULL,'2025-10-15 09:39:00',106,69209,47687,NULL,NULL,NULL,'2025-10-15 02:40:06','2025-10-15 02:40:06'),
(4547,2,'debit',NULL,575000.0000,NULL,'2025-10-15 13:02:00',19,69227,47699,NULL,NULL,NULL,'2025-10-15 06:04:00','2025-10-15 06:04:00'),
(4548,2,'debit',NULL,95000.0000,NULL,'2025-10-15 14:28:00',106,69233,47705,NULL,NULL,NULL,'2025-10-15 07:32:10','2025-10-15 07:32:10'),
(4549,2,'debit',NULL,75000.0000,NULL,'2025-10-15 15:13:00',106,69240,47707,NULL,NULL,NULL,'2025-10-15 08:15:43','2025-10-15 08:15:43'),
(4550,2,'credit',NULL,259000.0000,NULL,'2025-10-15 15:16:10',19,69239,47708,NULL,NULL,NULL,'2025-10-15 08:16:10','2025-10-30 06:49:39'),
(4551,2,'credit',NULL,75000.0000,NULL,'2025-10-15 15:53:25',106,69241,47709,NULL,NULL,NULL,'2025-10-15 08:53:25','2025-10-15 08:53:25'),
(4552,2,'credit',NULL,618000.0000,NULL,'2025-10-15 16:17:02',19,69242,47710,NULL,NULL,NULL,'2025-10-15 09:17:02','2025-10-30 06:46:28'),
(4553,2,'credit',NULL,175000.0000,NULL,'2025-10-15 16:52:13',13,69245,47712,NULL,NULL,NULL,'2025-10-15 09:52:13','2025-10-16 14:16:55'),
(4554,2,'credit',NULL,3000000.0000,NULL,'2025-10-15 19:20:46',5,69259,47721,NULL,NULL,NULL,'2025-10-15 12:20:46','2025-10-18 03:31:50'),
(4555,2,'debit',NULL,117000.0000,NULL,'2025-10-15 19:43:00',19,69261,47722,NULL,NULL,NULL,'2025-10-15 12:45:35','2025-10-15 12:45:35'),
(4556,2,'debit',NULL,1530000.0000,NULL,'2025-10-15 20:55:00',5,69266,47727,NULL,NULL,NULL,'2025-10-15 13:57:02','2025-10-15 13:57:02'),
(4557,2,'credit',NULL,400000.0000,NULL,'2025-10-15 21:04:18',5,69267,47728,NULL,NULL,NULL,'2025-10-15 14:04:18','2025-10-24 04:43:47'),
(4558,2,'debit',NULL,11405000.0000,NULL,'2025-10-16 08:28:00',13,69269,47730,NULL,NULL,NULL,'2025-10-16 01:37:08','2025-10-16 01:37:08'),
(4559,2,'credit',NULL,200000.0000,NULL,'2025-10-16 10:34:54',106,69270,47731,NULL,NULL,NULL,'2025-10-16 03:34:54','2025-10-31 07:19:39'),
(4560,2,'debit',NULL,11860000.0000,NULL,'2025-10-16 12:01:00',13,69279,47740,NULL,NULL,'2025-10-20 08:38:24','2025-10-16 05:04:03','2025-10-20 08:38:24'),
(4561,2,'credit',NULL,175000.0000,NULL,'2025-10-16 12:56:45',49,69285,47744,NULL,NULL,NULL,'2025-10-16 05:56:45','2025-10-16 05:56:45'),
(4562,2,'debit',NULL,10925000.0000,NULL,'2025-10-16 17:04:00',13,69301,47751,NULL,NULL,NULL,'2025-10-16 10:06:55','2025-10-16 10:06:55'),
(4563,2,'credit',NULL,200000.0000,NULL,'2025-10-16 18:32:19',5,69302,47758,NULL,NULL,NULL,'2025-10-16 11:32:19','2025-11-16 05:09:41'),
(4564,2,'debit',NULL,135000.0000,NULL,'2025-10-16 19:35:00',146,69309,47760,NULL,NULL,NULL,'2025-10-16 12:39:59','2025-10-16 12:39:59'),
(4565,2,'debit',NULL,176000.0000,NULL,'2025-10-17 10:14:00',6,69321,47769,NULL,NULL,NULL,'2025-10-17 03:16:07','2025-10-17 03:16:07'),
(4566,2,'debit',NULL,175000.0000,NULL,'2025-10-17 12:00:00',13,69332,47771,NULL,NULL,NULL,'2025-10-17 05:01:20','2025-10-17 05:01:20'),
(4567,2,'credit',NULL,200000.0000,NULL,'2025-10-17 13:44:01',19,69319,47773,NULL,NULL,NULL,'2025-10-17 06:44:01','2025-10-29 05:34:09'),
(4568,2,'debit',NULL,63079.0000,NULL,'2025-10-17 13:53:00',146,69336,47779,NULL,NULL,NULL,'2025-10-17 07:00:45','2025-10-17 07:00:45'),
(4569,2,'debit',NULL,125157.0000,NULL,'2025-10-17 14:00:00',146,69337,47780,NULL,NULL,NULL,'2025-10-17 07:03:12','2025-10-17 07:03:12'),
(4570,2,'debit',NULL,610764.0000,NULL,'2025-10-17 14:03:00',146,69338,47781,NULL,NULL,NULL,'2025-10-17 07:09:47','2025-10-17 07:09:47'),
(4571,2,'credit',NULL,789000.0000,NULL,'2025-10-17 14:58:33',13,69341,47783,NULL,NULL,NULL,'2025-10-17 07:58:33','2025-10-17 09:53:17'),
(4572,2,'credit',NULL,309000.0000,NULL,'2025-10-17 15:16:03',19,69344,47784,NULL,NULL,NULL,'2025-10-17 08:16:03','2025-10-17 08:16:03'),
(4573,2,'debit',NULL,1120000.0000,NULL,'2025-10-17 16:02:00',13,69348,47786,NULL,NULL,NULL,'2025-10-17 09:02:57','2025-10-17 09:02:57'),
(4574,2,'credit',NULL,11200000.0000,NULL,'2025-10-17 16:16:38',13,69316,47787,NULL,NULL,NULL,'2025-10-17 09:16:38','2025-10-17 09:16:38'),
(4575,2,'credit',NULL,438000.0000,NULL,'2025-10-17 16:54:35',49,69355,47790,NULL,NULL,NULL,'2025-10-17 09:54:35','2025-10-17 09:54:35'),
(4576,2,'debit',NULL,1950000.0000,NULL,'2025-10-18 08:46:00',13,69364,47803,NULL,NULL,NULL,'2025-10-18 01:50:49','2025-10-18 01:50:49'),
(4577,2,'credit',NULL,2110000.0000,NULL,'2025-10-18 10:31:50',49,69259,47808,NULL,NULL,NULL,'2025-10-18 03:31:50','2025-10-18 03:31:50'),
(4578,2,'credit',NULL,395000.0000,NULL,'2025-10-18 13:24:58',5,69384,47815,NULL,NULL,NULL,'2025-10-18 06:24:58','2025-10-18 06:24:58'),
(4579,2,'debit',NULL,4800000.0000,NULL,'2025-10-18 14:02:00',5,69391,47816,NULL,NULL,NULL,'2025-10-18 07:04:43','2025-10-18 07:04:43'),
(4580,2,'credit',NULL,610000.0000,NULL,'2025-10-18 15:03:03',13,69399,47823,NULL,NULL,NULL,'2025-10-18 08:03:03','2025-10-18 08:03:03'),
(4581,2,'credit',NULL,189000.0000,NULL,'2025-10-18 15:05:55',146,69389,47825,NULL,NULL,NULL,'2025-10-18 08:05:55','2025-10-18 09:27:34'),
(4582,2,'credit',NULL,2451000.0000,NULL,'2025-10-18 15:06:48',146,69398,47826,NULL,NULL,NULL,'2025-10-18 08:06:48','2025-10-18 08:06:48'),
(4583,2,'debit',NULL,510000.0000,NULL,'2025-10-18 15:23:00',13,69401,47829,NULL,NULL,NULL,'2025-10-18 08:24:27','2025-10-18 08:24:27'),
(4584,2,'credit',NULL,81000.0000,NULL,'2025-10-18 16:32:02',49,69396,47831,NULL,NULL,NULL,'2025-10-18 09:32:02','2025-10-18 10:17:54'),
(4585,2,'debit',NULL,615000.0000,NULL,'2025-10-18 17:11:00',5,69410,47834,NULL,NULL,NULL,'2025-10-18 10:12:08','2025-10-18 10:12:08'),
(4586,2,'credit',NULL,625000.0000,NULL,'2025-10-19 15:03:42',19,69445,47876,NULL,NULL,NULL,'2025-10-19 08:03:42','2025-10-19 08:03:42'),
(4587,2,'credit',NULL,200000.0000,NULL,'2025-10-19 15:18:51',106,69432,47878,NULL,NULL,NULL,'2025-10-19 08:18:51','2025-10-31 07:25:36'),
(4588,2,'debit',NULL,97000.0000,NULL,'2025-10-19 15:34:00',19,69449,47880,NULL,NULL,NULL,'2025-10-19 08:35:16','2025-10-19 08:35:16'),
(4589,2,'credit',NULL,100000.0000,NULL,'2025-10-19 19:42:33',13,69191,47890,NULL,NULL,NULL,'2025-10-19 12:42:33','2025-10-19 12:42:33'),
(4590,2,'debit',NULL,2014000.0000,NULL,'2025-10-20 09:44:00',146,69477,47903,NULL,NULL,NULL,'2025-10-20 02:49:35','2025-10-20 02:49:35'),
(4591,2,'credit',NULL,292000.0000,NULL,'2025-10-20 11:10:47',49,69485,47908,NULL,NULL,NULL,'2025-10-20 04:10:47','2025-10-20 04:52:06'),
(4592,2,'credit',NULL,90000.0000,NULL,'2025-10-20 11:15:32',49,69470,47909,NULL,NULL,NULL,'2025-10-20 04:15:32','2025-10-20 04:31:14'),
(4593,2,'credit',NULL,90000.0000,NULL,'2025-10-20 11:16:36',49,69487,47910,NULL,NULL,NULL,'2025-10-20 04:16:36','2025-10-20 04:29:57'),
(4594,2,'debit',NULL,180000.0000,NULL,'2025-10-20 11:31:00',49,69491,47912,NULL,NULL,NULL,'2025-10-20 04:32:21','2025-10-20 04:32:21'),
(4595,2,'debit',NULL,1030000.0000,NULL,'2025-10-20 12:12:00',19,69492,47914,NULL,NULL,NULL,'2025-10-20 05:13:31','2025-10-20 05:13:31'),
(4596,2,'credit',NULL,295000.0000,NULL,'2025-10-20 13:21:50',106,69498,47916,NULL,NULL,NULL,'2025-10-20 06:21:50','2025-10-20 06:21:50'),
(4597,2,'debit',NULL,55000.0000,NULL,'2025-10-20 13:47:00',106,69501,47918,NULL,NULL,NULL,'2025-10-20 06:49:14','2025-10-20 06:49:14'),
(4598,2,'credit',NULL,7890000.0000,NULL,'2025-10-20 16:08:04',6,69512,47920,NULL,NULL,NULL,'2025-10-20 09:08:04','2025-10-20 09:08:04'),
(4599,2,'debit',NULL,1525000.0000,NULL,'2025-10-20 17:51:00',13,69518,47926,NULL,NULL,NULL,'2025-10-20 10:53:22','2025-10-20 10:53:22'),
(4600,2,'credit',NULL,117600.0000,NULL,'2025-10-20 19:03:00',13,69351,47930,NULL,NULL,NULL,'2025-10-20 12:03:00','2025-10-21 03:17:15'),
(4601,2,'credit',NULL,120000.0000,NULL,'2025-10-21 15:18:43',19,69388,47952,NULL,NULL,NULL,'2025-10-21 08:18:43','2025-10-21 08:18:43'),
(4602,2,'credit',NULL,600000.0000,NULL,'2025-10-21 15:20:34',19,69387,47953,NULL,NULL,NULL,'2025-10-21 08:20:34','2025-10-21 08:20:34'),
(4603,2,'credit',NULL,435000.0000,NULL,'2025-10-21 15:21:34',19,69560,47954,NULL,NULL,NULL,'2025-10-21 08:21:34','2025-10-21 08:21:34'),
(4604,2,'debit',NULL,361000.0000,NULL,'2025-10-21 16:20:00',5,69568,47958,NULL,NULL,NULL,'2025-10-21 09:21:44','2025-10-21 09:21:44'),
(4605,2,'debit',NULL,95000.0000,NULL,'2025-10-21 16:09:00',146,69569,47959,NULL,NULL,NULL,'2025-10-21 09:21:46','2025-10-21 09:21:46'),
(4606,2,'debit',NULL,402000.0000,NULL,'2025-10-21 16:34:00',146,69571,47961,NULL,NULL,NULL,'2025-10-21 09:39:22','2025-10-21 09:39:22'),
(4607,2,'debit',NULL,334000.0000,NULL,'2025-10-21 19:06:00',106,69579,47965,NULL,NULL,NULL,'2025-10-21 12:06:55','2025-10-21 12:06:55'),
(4608,2,'credit',NULL,2784000.0000,NULL,'2025-10-22 09:29:19',19,69516,47970,NULL,NULL,NULL,'2025-10-22 02:29:19','2025-10-30 08:22:43'),
(4609,2,'credit',NULL,262500.0000,NULL,'2025-10-22 09:32:51',19,69493,47973,NULL,NULL,NULL,'2025-10-22 02:32:51','2025-10-22 02:32:51'),
(4610,2,'credit',NULL,262500.0000,NULL,'2025-10-22 09:39:37',19,69595,47974,NULL,NULL,NULL,'2025-10-22 02:39:37','2025-10-22 02:39:37'),
(4611,2,'credit',NULL,650000.0000,NULL,'2025-10-22 10:37:43',5,68033,47978,NULL,NULL,NULL,'2025-10-22 03:37:43','2025-10-22 03:37:43'),
(4612,2,'debit',NULL,580000.0000,NULL,'2025-10-22 13:06:00',146,69609,47980,NULL,NULL,NULL,'2025-10-22 06:09:24','2025-10-22 06:09:24'),
(4613,2,'debit',NULL,124800.0000,NULL,'2025-10-22 13:28:00',13,69612,47983,NULL,NULL,NULL,'2025-10-22 06:38:52','2025-10-22 06:38:52'),
(4614,2,'credit',NULL,120000.0000,NULL,'2025-10-22 14:00:23',13,69511,47984,NULL,NULL,NULL,'2025-10-22 07:00:23','2025-10-22 07:00:23'),
(4615,2,'debit',NULL,497000.0000,NULL,'2025-10-22 14:19:00',146,69616,47985,NULL,NULL,NULL,'2025-10-22 07:22:00','2025-10-22 07:22:00'),
(4616,2,'debit',NULL,305000.0000,NULL,'2025-10-22 16:05:00',49,69627,47996,NULL,NULL,'2025-10-26 05:53:21','2025-10-22 09:12:51','2025-10-26 05:53:21'),
(4617,2,'credit',NULL,111000.0000,NULL,'2025-10-22 18:04:29',6,69633,47999,NULL,NULL,NULL,'2025-10-22 11:04:29','2025-10-22 11:04:29'),
(4618,2,'credit',NULL,200000.0000,NULL,'2025-10-22 18:41:08',6,69637,48005,NULL,NULL,NULL,'2025-10-22 11:41:08','2025-10-24 01:20:02'),
(4619,2,'credit',NULL,21000.0000,NULL,'2025-10-23 10:29:38',5,69662,48026,NULL,NULL,NULL,'2025-10-23 03:29:38','2025-10-23 03:29:38'),
(4620,2,'debit',NULL,2220000.0000,NULL,'2025-10-23 12:13:00',19,69670,48033,NULL,NULL,NULL,'2025-10-23 05:14:53','2025-10-23 05:14:53'),
(4621,2,'credit',NULL,95000.0000,NULL,'2025-10-23 13:51:10',106,69679,48041,NULL,NULL,NULL,'2025-10-23 06:51:10','2025-10-23 06:51:10'),
(4622,2,'debit',NULL,1124000.0000,NULL,'2025-10-23 15:20:00',5,69685,48045,NULL,NULL,NULL,'2025-10-23 08:21:04','2025-10-23 08:21:04'),
(4623,2,'debit',NULL,41900.0000,NULL,'2025-10-23 17:10:00',146,69688,48046,NULL,NULL,NULL,'2025-10-23 10:14:51','2025-10-23 10:14:51'),
(4624,2,'debit',NULL,209000.0000,NULL,'2025-10-23 19:13:00',13,69693,48050,NULL,NULL,NULL,'2025-10-23 12:14:12','2025-10-23 12:14:12'),
(4625,2,'credit',NULL,374000.0000,NULL,'2025-10-23 19:24:27',106,69687,48051,NULL,NULL,NULL,'2025-10-23 12:24:27','2025-10-23 12:24:27'),
(4626,2,'credit',NULL,200000.0000,NULL,'2025-10-24 13:51:34',6,69686,48071,NULL,NULL,NULL,'2025-10-24 06:51:34','2025-10-29 05:34:25'),
(4627,2,'credit',NULL,2990000.0000,NULL,'2025-10-24 17:22:10',6,69740,48077,NULL,NULL,NULL,'2025-10-24 10:22:10','2025-10-24 10:25:45'),
(4628,2,'credit',NULL,3781000.0000,NULL,'2025-10-24 20:37:33',6,69746,48088,NULL,NULL,NULL,'2025-10-24 13:37:33','2025-10-24 13:37:33'),
(4629,2,'debit',NULL,1460000.0000,NULL,'2025-10-25 10:26:00',5,69762,48099,NULL,NULL,NULL,'2025-10-25 03:29:35','2025-10-25 03:29:35'),
(4630,2,'debit',NULL,16336500.0000,NULL,'2025-10-25 10:31:00',5,69763,48100,NULL,NULL,NULL,'2025-10-25 03:35:09','2025-10-25 03:35:09'),
(4631,2,'credit',NULL,230000.0000,NULL,'2025-10-25 12:42:34',143,69649,48104,NULL,NULL,NULL,'2025-10-25 05:42:34','2025-10-25 05:42:34'),
(4632,2,'credit',NULL,237000.0000,NULL,'2025-10-25 12:42:53',143,69770,48105,NULL,NULL,NULL,'2025-10-25 05:42:53','2025-10-25 05:42:53'),
(4633,2,'debit',NULL,40000.0000,NULL,'2025-10-25 14:26:00',106,69787,48108,NULL,NULL,NULL,'2025-10-25 07:27:12','2025-10-25 07:27:12'),
(4634,2,'debit',NULL,240000.0000,NULL,'2025-10-25 14:26:00',146,69788,48109,NULL,NULL,NULL,'2025-10-25 07:30:03','2025-10-25 07:30:03'),
(4635,2,'credit',NULL,40000.0000,NULL,'2025-10-25 14:37:05',5,69790,48112,NULL,NULL,NULL,'2025-10-25 07:37:05','2025-10-25 07:37:05'),
(4636,2,'credit',NULL,120000.0000,NULL,'2025-10-25 14:50:47',5,69796,48120,NULL,NULL,NULL,'2025-10-25 07:50:47','2025-10-25 07:50:47'),
(4637,2,'credit',NULL,120000.0000,NULL,'2025-10-25 14:51:32',5,69797,48121,NULL,NULL,NULL,'2025-10-25 07:51:32','2025-10-25 07:51:32'),
(4638,2,'credit',NULL,500000.0000,NULL,'2025-10-25 14:56:37',5,69798,48123,NULL,NULL,NULL,'2025-10-25 07:56:37','2025-10-25 07:56:37'),
(4639,2,'credit',NULL,500000.0000,NULL,'2025-10-25 14:57:46',5,69799,48124,NULL,NULL,NULL,'2025-10-25 07:57:46','2025-10-25 07:57:46'),
(4640,2,'debit',NULL,75000.0000,NULL,'2025-10-25 19:59:00',6,69828,48137,NULL,NULL,NULL,'2025-10-25 13:13:07','2025-10-25 13:13:07'),
(4641,2,'debit',NULL,146500.0000,NULL,'2025-10-25 21:05:00',106,69831,48141,NULL,NULL,NULL,'2025-10-25 14:06:23','2025-10-25 14:06:23'),
(4642,2,'credit',NULL,46000.0000,NULL,'2025-10-26 10:23:14',6,69840,48151,NULL,NULL,NULL,'2025-10-26 03:23:14','2025-10-26 03:23:14'),
(4643,2,'credit',NULL,75000.0000,NULL,'2025-10-26 11:59:03',49,69848,48158,NULL,NULL,NULL,'2025-10-26 04:59:03','2025-10-26 04:59:03'),
(4644,2,'credit',NULL,4127500.0000,NULL,'2025-10-26 15:34:03',49,69849,48168,NULL,NULL,NULL,'2025-10-26 08:34:03','2025-10-29 02:21:39'),
(4645,2,'debit',NULL,40000.0000,NULL,'2025-10-26 16:51:00',49,69862,48171,NULL,NULL,NULL,'2025-10-26 09:51:29','2025-10-26 09:51:29'),
(4646,2,'debit',NULL,431400.0000,NULL,'2025-10-26 18:25:00',146,69869,48176,NULL,NULL,NULL,'2025-10-26 11:28:55','2025-10-26 11:28:55'),
(4647,2,'credit',NULL,85000.0000,NULL,'2025-10-26 18:31:12',5,69870,48177,NULL,NULL,NULL,'2025-10-26 11:31:12','2025-10-26 11:31:12'),
(4648,2,'credit',NULL,250000.0000,NULL,'2025-10-27 12:14:27',106,69884,48188,NULL,NULL,NULL,'2025-10-27 05:14:27','2025-10-29 03:11:21'),
(4649,2,'credit',NULL,117000.0000,NULL,'2025-10-27 12:53:42',106,69896,48194,NULL,NULL,NULL,'2025-10-27 05:53:42','2025-10-27 05:53:42'),
(4650,2,'credit',NULL,200000.0000,NULL,'2025-10-27 13:26:25',5,69890,48195,NULL,NULL,NULL,'2025-10-27 06:26:25','2025-10-31 07:20:28'),
(4651,2,'debit',NULL,7881600.0000,NULL,'2025-10-27 13:54:00',19,69898,48196,NULL,NULL,NULL,'2025-10-27 07:00:10','2025-10-27 07:00:10'),
(4652,2,'debit',NULL,1061900.0000,NULL,'2025-10-27 14:03:00',19,69900,48197,NULL,NULL,NULL,'2025-10-27 07:06:57','2025-10-27 07:06:57'),
(4653,2,'debit',NULL,100000.0000,NULL,'2025-10-27 14:06:00',106,69901,48198,NULL,NULL,NULL,'2025-10-27 07:07:08','2025-10-27 07:07:08'),
(4654,2,'credit',NULL,123000.0000,NULL,'2025-10-27 15:18:44',5,69730,48201,NULL,NULL,NULL,'2025-10-27 08:18:44','2025-10-27 08:22:18'),
(4655,2,'credit',NULL,40000.0000,NULL,'2025-10-27 15:22:02',5,69906,48203,NULL,NULL,NULL,'2025-10-27 08:22:02','2025-10-27 08:22:02'),
(4656,2,'credit',NULL,34000.0000,NULL,'2025-10-27 15:23:25',5,69902,48204,NULL,NULL,NULL,'2025-10-27 08:23:25','2025-10-27 08:23:25'),
(4657,2,'debit',NULL,146500.0000,NULL,'2025-10-27 15:36:00',5,69908,48205,NULL,NULL,NULL,'2025-10-27 08:37:08','2025-10-27 08:37:08'),
(4658,2,'credit',NULL,40000.0000,NULL,'2025-10-27 15:45:06',5,69909,48206,NULL,NULL,NULL,'2025-10-27 08:45:06','2025-10-27 08:45:06'),
(4659,2,'debit',NULL,170000.0000,NULL,'2025-10-27 19:26:00',146,69928,48215,NULL,NULL,NULL,'2025-10-27 12:28:26','2025-10-27 12:28:26'),
(4660,2,'debit',NULL,909000.0000,NULL,'2025-10-27 19:35:00',5,69930,48217,NULL,NULL,NULL,'2025-10-27 12:38:13','2025-10-27 12:38:13'),
(4661,2,'debit',NULL,894702.0000,NULL,'2025-10-27 19:38:00',5,69931,48218,NULL,NULL,NULL,'2025-10-27 12:39:51','2025-10-27 12:39:51'),
(4662,2,'debit',NULL,41900.0000,NULL,'2025-10-27 21:30:00',19,69936,48225,NULL,NULL,NULL,'2025-10-27 14:31:40','2025-10-27 14:31:40'),
(4663,2,'credit',NULL,4380000.0000,NULL,'2025-10-28 09:07:16',106,69940,48228,NULL,NULL,NULL,'2025-10-28 02:07:16','2025-10-28 02:07:16'),
(4664,2,'credit',NULL,700000.0000,NULL,'2025-10-28 09:19:19',106,69642,48229,NULL,NULL,NULL,'2025-10-28 02:19:19','2025-10-31 07:21:40'),
(4665,2,'credit',NULL,2800000.0000,NULL,'2025-10-28 11:01:06',106,69942,48233,NULL,NULL,NULL,'2025-10-28 04:01:06','2025-10-28 04:01:06'),
(4666,2,'debit',NULL,130000.0000,NULL,'2025-10-28 13:09:00',106,69958,48245,NULL,NULL,NULL,'2025-10-28 06:10:40','2025-10-28 06:10:40'),
(4667,2,'credit',NULL,700000.0000,NULL,'2025-10-28 13:43:23',49,69954,48248,NULL,NULL,NULL,'2025-10-28 06:43:23','2025-10-28 06:43:23'),
(4668,2,'credit',NULL,112000.0000,NULL,'2025-10-28 14:11:12',5,69966,48251,NULL,NULL,NULL,'2025-10-28 07:11:12','2025-10-28 07:11:12'),
(4669,2,'credit',NULL,2000000.0000,NULL,'2025-10-28 15:23:30',5,69963,48252,NULL,NULL,NULL,'2025-10-28 08:23:30','2025-10-28 14:40:48'),
(4670,2,'debit',NULL,9299000.0000,NULL,'2025-10-28 15:34:00',49,69972,48253,NULL,NULL,NULL,'2025-10-28 08:37:43','2025-10-28 08:37:43'),
(4671,2,'debit',NULL,175000.0000,NULL,'2025-10-28 15:40:00',106,69974,48255,NULL,NULL,NULL,'2025-10-28 08:41:51','2025-10-28 08:41:51'),
(4672,2,'credit',NULL,295000.0000,NULL,'2025-10-28 17:39:41',5,69981,48261,NULL,NULL,NULL,'2025-10-28 10:39:41','2025-10-28 10:39:41'),
(4673,2,'debit',NULL,269400.0000,NULL,'2025-10-28 18:09:00',5,69983,48263,NULL,NULL,NULL,'2025-10-28 11:11:15','2025-10-28 11:11:15'),
(4674,2,'credit',NULL,360000.0000,NULL,'2025-10-28 18:20:10',5,69985,48265,NULL,NULL,NULL,'2025-10-28 11:20:10','2025-10-28 11:20:46'),
(4675,2,'debit',NULL,850000.0000,NULL,'2025-10-28 21:28:00',19,69996,48274,NULL,NULL,NULL,'2025-10-28 14:29:39','2025-10-28 14:29:39'),
(4676,2,'credit',NULL,4000000.0000,NULL,'2025-10-28 21:35:14',5,69963,48275,NULL,NULL,NULL,'2025-10-28 14:35:14','2025-10-28 14:40:48'),
(4677,2,'credit',NULL,211000.0000,NULL,'2025-10-28 21:41:11',5,69997,48277,NULL,NULL,NULL,'2025-10-28 14:41:11','2025-10-28 14:41:11'),
(4678,2,'credit',NULL,218000.0000,NULL,'2025-10-29 10:11:32',106,70002,48281,NULL,NULL,NULL,'2025-10-29 03:11:32','2025-10-29 03:11:32'),
(4679,2,'credit',NULL,345000.0000,NULL,'2025-10-29 10:27:59',106,70005,48282,NULL,NULL,NULL,'2025-10-29 03:27:59','2025-10-29 03:27:59'),
(4680,2,'credit',NULL,4150000.0000,NULL,'2025-10-29 11:22:32',6,70008,48284,NULL,NULL,NULL,'2025-10-29 04:22:32','2025-10-29 04:22:32'),
(4681,2,'debit',NULL,488000.0000,NULL,'2025-10-29 15:27:00',19,70017,48291,NULL,NULL,NULL,'2025-10-29 08:28:46','2025-10-29 08:28:46'),
(4682,2,'debit',NULL,4487520.0000,NULL,'2025-10-29 18:09:00',19,70024,48297,NULL,NULL,NULL,'2025-10-29 11:12:58','2025-10-29 11:12:58'),
(4683,2,'debit',NULL,6564615.0000,NULL,'2025-10-29 18:23:00',19,70025,48298,NULL,NULL,NULL,'2025-10-29 11:29:39','2025-10-29 11:29:39'),
(4684,2,'debit',NULL,101208750.0000,NULL,'2025-10-29 20:19:00',5,70031,48304,NULL,NULL,'2025-11-14 13:06:06','2025-10-29 13:23:08','2025-11-14 13:06:06'),
(4685,2,'credit',NULL,285000.0000,NULL,'2025-10-30 11:02:27',6,70050,48316,NULL,NULL,NULL,'2025-10-30 04:02:27','2025-10-30 04:02:27'),
(4686,2,'debit',NULL,1275000.0000,NULL,'2025-10-30 11:27:00',13,70051,48317,NULL,NULL,NULL,'2025-10-30 04:32:08','2025-10-30 04:32:08'),
(4687,2,'credit',NULL,325000.0000,NULL,'2025-10-30 12:30:01',13,70056,48320,NULL,NULL,NULL,'2025-10-30 05:30:01','2025-10-30 05:30:01'),
(4688,2,'credit',NULL,87500.0000,NULL,'2025-10-30 13:45:32',19,70066,48328,NULL,NULL,NULL,'2025-10-30 06:45:32','2025-10-30 06:45:32'),
(4689,2,'credit',NULL,87500.0000,NULL,'2025-10-30 13:46:18',19,70067,48329,NULL,NULL,NULL,'2025-10-30 06:46:18','2025-10-30 06:46:18'),
(4690,2,'credit',NULL,80000.0000,NULL,'2025-10-30 13:48:28',19,70068,48331,NULL,NULL,NULL,'2025-10-30 06:48:28','2025-10-30 06:48:28'),
(4691,2,'credit',NULL,80000.0000,NULL,'2025-10-30 13:49:10',19,70069,48332,NULL,NULL,NULL,'2025-10-30 06:49:10','2025-10-30 06:49:10'),
(4692,2,'credit',NULL,75000.0000,NULL,'2025-10-30 13:51:19',19,70070,48333,NULL,NULL,NULL,'2025-10-30 06:51:19','2025-10-30 06:51:19'),
(4693,2,'credit',NULL,75000.0000,NULL,'2025-10-30 13:51:52',19,70072,48335,NULL,NULL,NULL,'2025-10-30 06:51:52','2025-10-30 06:51:52'),
(4694,2,'credit',NULL,410000.0000,NULL,'2025-10-30 13:56:23',19,70075,48337,NULL,NULL,NULL,'2025-10-30 06:56:23','2025-10-30 06:56:23'),
(4695,2,'credit',NULL,410000.0000,NULL,'2025-10-30 13:57:18',19,70076,48338,NULL,NULL,NULL,'2025-10-30 06:57:18','2025-10-30 06:57:18'),
(4696,2,'credit',NULL,262500.0000,NULL,'2025-10-30 14:18:59',19,70081,48344,NULL,NULL,NULL,'2025-10-30 07:18:59','2025-10-30 07:18:59'),
(4697,2,'credit',NULL,262500.0000,NULL,'2025-10-30 14:19:38',19,70082,48345,NULL,NULL,NULL,'2025-10-30 07:19:38','2025-10-30 07:19:38'),
(4698,2,'debit',NULL,935100.0000,NULL,'2025-10-30 17:55:00',5,70103,48362,NULL,NULL,NULL,'2025-10-30 10:56:40','2025-10-30 10:56:40'),
(4699,2,'debit',NULL,76000.0000,NULL,'2025-10-30 18:31:00',146,70105,48363,NULL,NULL,NULL,'2025-10-30 11:36:22','2025-10-30 11:36:22'),
(4700,2,'debit',NULL,1045200.0000,NULL,'2025-10-30 21:07:00',5,70119,48376,NULL,NULL,NULL,'2025-10-30 14:08:03','2025-10-30 14:08:03'),
(4701,2,'credit',NULL,50000.0000,NULL,'2025-10-31 14:17:20',49,70137,48390,NULL,NULL,NULL,'2025-10-31 07:17:20','2025-10-31 14:12:48'),
(4702,2,'debit',NULL,65000.0000,NULL,'2025-10-31 14:48:00',49,70145,48391,NULL,NULL,NULL,'2025-10-31 07:48:42','2025-10-31 07:48:42'),
(4703,2,'credit',NULL,3504000.0000,NULL,'2025-10-31 14:53:57',49,70142,48395,NULL,NULL,NULL,'2025-10-31 07:53:57','2025-10-31 09:18:42'),
(4704,2,'credit',NULL,1168000.0000,NULL,'2025-10-31 16:18:42',13,70142,48400,NULL,NULL,NULL,'2025-10-31 09:18:42','2025-10-31 09:18:42'),
(4705,2,'debit',NULL,1732000.0000,NULL,'2025-10-31 21:10:00',49,70172,48414,NULL,NULL,NULL,'2025-10-31 14:14:44','2025-10-31 14:14:44'),
(4706,2,'credit',NULL,2706000.0000,NULL,'2025-11-01 10:07:27',49,70130,48419,NULL,NULL,NULL,'2025-11-01 03:07:27','2025-11-02 07:38:56'),
(4707,2,'credit',NULL,421800.0000,NULL,'2025-11-01 13:33:26',146,68563,48429,NULL,NULL,NULL,'2025-11-01 06:33:26','2025-11-04 07:04:16'),
(4708,2,'credit',NULL,222000.0000,NULL,'2025-11-01 13:46:58',146,68562,48431,NULL,NULL,NULL,'2025-11-01 06:46:58','2025-11-04 07:05:27'),
(4709,2,'credit',NULL,388500.0000,NULL,'2025-11-01 13:56:54',146,68560,48432,NULL,NULL,NULL,'2025-11-01 06:56:54','2025-11-04 07:05:50'),
(4710,2,'credit',NULL,61050.0000,NULL,'2025-11-01 14:08:07',146,70196,48434,NULL,NULL,NULL,'2025-11-01 07:08:08','2025-11-01 11:20:36'),
(4711,2,'debit',NULL,114000.0000,NULL,'2025-11-01 14:27:00',49,70207,48436,NULL,NULL,NULL,'2025-11-01 07:41:49','2025-11-01 07:41:49'),
(4712,2,'credit',NULL,180000.0000,NULL,'2025-11-01 14:44:14',5,70208,48437,NULL,NULL,NULL,'2025-11-01 07:44:14','2025-11-01 07:44:14'),
(4713,2,'credit',NULL,745920.0000,NULL,'2025-11-01 15:04:12',146,70195,48438,NULL,NULL,NULL,'2025-11-01 08:04:12','2025-11-01 11:20:51'),
(4714,2,'credit',NULL,100000.0000,NULL,'2025-11-01 15:44:54',49,70164,48442,NULL,NULL,NULL,'2025-11-01 08:44:54','2025-12-01 06:10:42'),
(4715,2,'credit',NULL,119000.0000,NULL,'2025-11-01 17:16:33',143,70255,48448,NULL,NULL,NULL,'2025-11-01 10:16:33','2025-11-01 10:16:33'),
(4716,2,'credit',NULL,198000.0000,NULL,'2025-11-01 09:45:13',143,70179,48418,NULL,NULL,NULL,'2025-11-01 10:17:59','2025-11-01 10:17:59'),
(4717,2,'debit',NULL,170000.0000,NULL,'2025-11-01 18:10:00',5,70259,48452,NULL,NULL,NULL,'2025-11-01 11:11:31','2025-11-01 11:11:31'),
(4718,2,'credit',NULL,230000.0000,NULL,'2025-11-01 19:50:39',146,69877,48466,NULL,NULL,NULL,'2025-11-01 12:50:39','2025-11-01 12:54:53'),
(4719,2,'credit',NULL,22000.0000,NULL,'2025-11-01 19:51:21',146,70264,48467,NULL,NULL,NULL,'2025-11-01 12:51:21','2025-11-01 12:51:21'),
(4720,2,'debit',NULL,476190.0000,NULL,'2025-11-01 20:42:00',19,70272,48469,NULL,NULL,NULL,'2025-11-01 13:45:30','2025-11-01 13:45:30'),
(4721,2,'debit',NULL,388500.0000,NULL,'2025-11-01 20:47:00',19,70273,48470,NULL,NULL,NULL,'2025-11-01 13:48:13','2025-11-01 13:48:13'),
(4722,2,'debit',NULL,333000.0000,NULL,'2025-11-01 20:48:00',19,70274,48471,NULL,NULL,NULL,'2025-11-01 13:49:13','2025-11-01 13:49:13'),
(4723,2,'debit',NULL,1393790.0000,NULL,'2025-11-01 20:50:00',19,70276,48473,NULL,NULL,NULL,'2025-11-01 13:51:34','2025-11-01 13:51:34'),
(4724,2,'credit',NULL,420000.0000,NULL,'2025-11-01 20:55:03',5,70251,48476,NULL,NULL,NULL,'2025-11-01 13:55:03','2025-11-01 13:55:03'),
(4725,2,'credit',NULL,215000.0000,NULL,'2025-11-01 20:56:01',5,70279,48477,NULL,NULL,NULL,'2025-11-01 13:56:01','2025-11-01 13:56:01'),
(4726,2,'debit',NULL,721505.0000,NULL,'2025-11-02 10:37:00',5,70291,48485,NULL,NULL,NULL,'2025-11-02 04:11:26','2025-11-02 04:11:26'),
(4727,2,'debit',NULL,95495.0000,NULL,'2025-11-02 11:11:00',5,70292,48486,NULL,NULL,NULL,'2025-11-02 04:15:12','2025-11-02 04:15:12'),
(4728,2,'credit',NULL,435000.0000,NULL,'2025-11-02 14:37:15',5,70306,48494,NULL,NULL,NULL,'2025-11-02 07:37:15','2025-11-02 07:38:32'),
(4729,2,'credit',NULL,435000.0000,NULL,'2025-11-02 14:38:14',5,70138,48495,NULL,NULL,NULL,'2025-11-02 07:38:14','2025-11-02 07:38:14'),
(4730,2,'credit',NULL,700000.0000,NULL,'2025-11-02 19:41:37',49,70313,48503,NULL,NULL,NULL,'2025-11-02 12:41:37','2025-11-02 12:41:37'),
(4731,2,'credit',NULL,200000.0000,NULL,'2025-11-02 20:32:13',19,70309,48506,NULL,NULL,NULL,'2025-11-02 13:32:13','2025-11-14 10:35:30'),
(4732,2,'credit',NULL,367000.0000,NULL,'2025-11-03 18:47:09',146,70368,48570,NULL,NULL,NULL,'2025-11-03 11:47:09','2025-11-08 10:21:36'),
(4733,2,'credit',NULL,150000.0000,NULL,'2025-11-04 09:06:23',5,70324,48580,NULL,NULL,NULL,'2025-11-04 02:06:23','2025-11-10 14:37:56'),
(4734,2,'debit',NULL,290000.0000,NULL,'2025-11-04 10:07:00',5,70380,48583,NULL,NULL,NULL,'2025-11-04 03:08:08','2025-11-04 03:08:08'),
(4735,2,'credit',NULL,350000.0000,NULL,'2025-11-04 10:55:09',19,69760,48585,NULL,NULL,'2025-11-21 07:21:20','2025-11-04 03:55:09','2025-11-21 07:21:20'),
(4736,2,'debit',NULL,3400000.0000,NULL,'2025-11-04 11:40:00',5,70387,48590,NULL,NULL,NULL,'2025-11-04 04:45:30','2025-11-04 04:45:30'),
(4737,2,'debit',NULL,9594050.0000,NULL,'2025-11-04 14:21:00',19,70392,48596,NULL,NULL,NULL,'2025-11-04 07:22:38','2025-11-04 07:22:38'),
(4738,2,'credit',NULL,395000.0000,NULL,'2025-11-04 15:52:24',10,70350,48601,NULL,NULL,NULL,'2025-11-04 08:52:24','2025-11-04 08:52:24'),
(4739,2,'credit',NULL,390000.0000,NULL,'2025-11-04 15:54:50',10,70402,48603,NULL,NULL,NULL,'2025-11-04 08:54:50','2025-12-02 08:29:58'),
(4740,2,'credit',NULL,500000.0000,NULL,'2025-11-04 17:59:22',6,64305,48608,NULL,NULL,NULL,'2025-11-04 10:59:22','2025-11-04 10:59:22'),
(4741,2,'debit',NULL,89644.0000,NULL,'2025-11-04 19:20:00',6,70412,48611,NULL,NULL,NULL,'2025-11-04 12:22:24','2025-11-04 12:22:24'),
(4742,2,'debit',NULL,945500.0000,NULL,'2025-11-04 19:22:00',6,70413,48612,NULL,NULL,NULL,'2025-11-04 12:23:17','2025-11-04 12:23:17'),
(4743,2,'debit',NULL,1370650.0000,NULL,'2025-11-05 08:16:00',19,70424,48622,NULL,NULL,NULL,'2025-11-05 01:18:05','2025-11-05 01:18:05'),
(4744,2,'credit',NULL,3100000.0000,NULL,'2025-11-05 14:15:42',6,70470,48638,NULL,NULL,NULL,'2025-11-05 07:15:42','2025-11-05 07:15:42'),
(4745,2,'debit',NULL,410000.0000,NULL,'2025-11-05 15:06:00',5,70481,48647,NULL,NULL,NULL,'2025-11-05 08:08:35','2025-11-05 08:08:35'),
(4746,2,'credit',NULL,1800000.0000,NULL,'2025-11-05 16:26:23',5,70488,48651,NULL,NULL,NULL,'2025-11-05 09:26:23','2025-11-05 09:26:23'),
(4747,2,'credit',NULL,82000.0000,NULL,'2025-11-05 18:31:56',6,70472,48653,NULL,NULL,NULL,'2025-11-05 11:31:56','2025-11-05 11:31:56'),
(4748,2,'credit',NULL,80000.0000,NULL,'2025-11-05 18:32:52',6,70493,48654,NULL,NULL,NULL,'2025-11-05 11:32:52','2025-11-05 11:32:52'),
(4749,2,'credit',NULL,335000.0000,NULL,'2025-11-05 18:33:42',6,70458,48655,NULL,NULL,NULL,'2025-11-05 11:33:42','2025-11-05 11:33:42'),
(4750,2,'credit',NULL,251000.0000,NULL,'2025-11-05 20:46:51',6,70505,48664,NULL,NULL,NULL,'2025-11-05 13:46:51','2025-11-05 13:46:51'),
(4751,2,'credit',NULL,305000.0000,NULL,'2025-11-05 20:50:31',146,70414,48665,NULL,NULL,NULL,'2025-11-05 13:50:31','2025-11-05 13:54:22'),
(4752,2,'credit',NULL,150000.0000,NULL,'2025-11-06 13:04:51',146,70514,48682,NULL,NULL,NULL,'2025-11-06 06:04:51','2025-11-06 06:04:51'),
(4753,2,'credit',NULL,586000.0000,NULL,'2025-11-06 13:18:03',19,70525,48685,NULL,NULL,NULL,'2025-11-06 06:18:03','2025-11-06 06:18:03'),
(4754,2,'debit',NULL,23550000.0000,NULL,'2025-11-06 18:07:00',146,70545,48695,NULL,NULL,NULL,'2025-11-06 11:12:13','2025-11-06 11:12:13'),
(4755,2,'debit',NULL,213500.0000,NULL,'2025-11-06 18:13:00',146,70546,48696,NULL,NULL,NULL,'2025-11-06 11:14:38','2025-11-06 11:14:38'),
(4756,2,'credit',NULL,739000.0000,NULL,'2025-11-06 18:48:37',49,66116,48699,NULL,NULL,NULL,'2025-11-06 11:48:37','2025-11-06 11:48:37'),
(4757,2,'credit',NULL,1434000.0000,NULL,'2025-11-06 18:52:01',49,70485,48700,NULL,NULL,NULL,'2025-11-06 11:52:01','2025-11-08 07:03:02'),
(4758,2,'credit',NULL,200000.0000,NULL,'2025-11-06 21:04:34',6,70543,48703,NULL,NULL,NULL,'2025-11-06 14:04:34','2025-11-06 14:04:34'),
(4759,2,'credit',NULL,200000.0000,NULL,'2025-11-06 21:35:42',49,70542,48705,NULL,NULL,NULL,'2025-11-06 14:35:42','2025-12-01 06:10:07'),
(4760,2,'debit',NULL,2048200.0000,NULL,'2025-11-07 11:12:00',146,70564,48712,NULL,NULL,NULL,'2025-11-07 04:14:45','2025-11-07 04:14:45'),
(4761,2,'debit',NULL,102000000.0000,NULL,'2025-11-07 11:17:00',146,70568,48715,NULL,NULL,NULL,'2025-11-07 04:36:15','2025-11-07 04:36:15'),
(4762,2,'debit',NULL,231000.0000,NULL,'2025-11-07 11:44:00',19,70570,48716,NULL,NULL,NULL,'2025-11-07 04:45:18','2025-11-07 04:45:18'),
(4763,2,'debit',NULL,400000.0000,NULL,'2025-11-07 11:45:00',19,70571,48717,NULL,NULL,NULL,'2025-11-07 04:48:06','2025-11-07 04:48:06'),
(4764,2,'debit',NULL,4800000.0000,NULL,'2025-11-07 15:33:00',19,70587,48733,NULL,NULL,NULL,'2025-11-07 08:39:01','2025-11-07 08:39:01'),
(4765,2,'debit',NULL,457000.0000,NULL,'2025-11-07 15:49:00',49,70592,48736,NULL,NULL,NULL,'2025-11-07 09:29:07','2025-11-07 09:29:07'),
(4766,2,'credit',NULL,2744000.0000,NULL,'2025-11-07 21:01:09',6,70609,48753,NULL,NULL,NULL,'2025-11-07 14:01:09','2025-11-07 14:01:09'),
(4767,2,'credit',NULL,250000.0000,NULL,'2025-11-08 13:58:59',5,70449,48769,NULL,NULL,NULL,'2025-11-08 06:58:59','2025-11-09 03:01:26'),
(4768,2,'credit',NULL,250000.0000,NULL,'2025-11-08 14:00:45',5,70635,48770,NULL,NULL,NULL,'2025-11-08 07:00:45','2025-11-08 09:03:44'),
(4769,2,'debit',NULL,1868500.0000,NULL,'2025-11-08 16:00:00',49,70649,48777,NULL,NULL,NULL,'2025-11-08 09:04:47','2025-11-08 09:04:47'),
(4770,2,'credit',NULL,4488000.0000,NULL,'2025-11-08 17:09:21',6,70654,48783,NULL,NULL,NULL,'2025-11-08 10:09:21','2025-11-08 10:09:21'),
(4771,2,'credit',NULL,367000.0000,NULL,'2025-11-08 17:21:36',146,70368,48786,NULL,NULL,NULL,'2025-11-08 10:21:36','2025-11-08 10:21:36'),
(4772,2,'debit',NULL,675000.0000,NULL,'2025-11-08 18:18:00',106,70664,48791,NULL,NULL,NULL,'2025-11-08 11:20:21','2025-11-08 11:20:21'),
(4773,2,'credit',NULL,1436000.0000,NULL,'2025-11-08 18:35:24',5,70646,48793,NULL,NULL,NULL,'2025-11-08 11:35:24','2025-11-08 11:35:24'),
(4774,2,'debit',NULL,9280000.0000,NULL,'2025-11-08 18:28:00',106,70668,48795,NULL,NULL,NULL,'2025-11-08 11:48:43','2025-11-08 15:54:34'),
(4775,2,'credit',NULL,895000.0000,NULL,'2025-11-09 10:26:19',143,70678,48805,NULL,NULL,NULL,'2025-11-09 03:26:19','2025-11-09 03:26:19'),
(4776,2,'credit',NULL,200000.0000,NULL,'2025-11-09 18:50:09',146,70679,48822,NULL,NULL,NULL,'2025-11-09 11:50:09','2025-11-29 13:15:47'),
(4777,2,'credit',NULL,502000.0000,NULL,'2025-11-09 20:10:17',146,70363,48825,NULL,NULL,NULL,'2025-11-09 13:10:17','2025-11-10 08:15:23'),
(4778,2,'credit',NULL,250000.0000,NULL,'2025-11-09 20:10:43',146,68879,48826,NULL,NULL,NULL,'2025-11-09 13:10:43','2025-11-09 14:44:17'),
(4779,2,'credit',NULL,450000.0000,NULL,'2025-11-09 20:11:08',146,69235,48827,NULL,NULL,NULL,'2025-11-09 13:11:08','2025-11-09 14:49:02'),
(4780,2,'credit',NULL,295000.0000,NULL,'2025-11-09 20:11:27',146,70563,48828,NULL,NULL,NULL,'2025-11-09 13:11:27','2025-11-09 14:44:46'),
(4781,2,'debit',NULL,231000.0000,NULL,'2025-11-10 12:53:00',49,70719,48846,NULL,NULL,NULL,'2025-11-10 05:56:08','2025-11-10 05:56:08'),
(4782,2,'debit',NULL,266500.0000,NULL,'2025-11-10 12:56:00',49,70720,48847,NULL,NULL,NULL,'2025-11-10 05:57:04','2025-11-10 05:57:04'),
(4783,2,'credit',NULL,200000.0000,NULL,'2025-11-10 13:07:36',49,70707,48848,NULL,NULL,NULL,'2025-11-10 06:07:36','2025-11-18 03:17:57'),
(4784,2,'debit',NULL,285000.0000,NULL,'2025-11-10 14:14:00',5,70725,48849,NULL,NULL,NULL,'2025-11-10 07:16:24','2025-11-10 07:16:24'),
(4785,2,'credit',NULL,200000.0000,NULL,'2025-11-10 18:48:14',106,70733,48864,NULL,NULL,NULL,'2025-11-10 11:48:14','2025-11-10 11:48:14'),
(4786,2,'credit',NULL,200000.0000,NULL,'2025-11-11 08:34:34',6,70701,48873,NULL,NULL,NULL,'2025-11-11 01:34:34','2025-11-11 01:34:34'),
(4787,2,'credit',NULL,2319000.0000,NULL,'2025-11-11 09:21:19',146,70765,48877,NULL,NULL,NULL,'2025-11-11 02:21:19','2025-11-11 02:21:19'),
(4788,2,'debit',NULL,280000.0000,NULL,'2025-11-11 14:46:00',5,70788,48890,NULL,NULL,NULL,'2025-11-11 07:49:04','2025-11-11 07:49:04'),
(4789,2,'credit',NULL,120000.0000,NULL,'2025-11-11 15:38:22',106,70755,48896,NULL,NULL,NULL,'2025-11-11 08:38:22','2025-11-11 09:28:32'),
(4790,2,'debit',NULL,3900000.0000,NULL,'2025-11-11 16:01:00',5,70797,48898,NULL,NULL,NULL,'2025-11-11 09:03:25','2025-11-11 09:03:25'),
(4791,2,'credit',NULL,599000.0000,NULL,'2025-11-11 16:29:15',146,70799,48900,NULL,NULL,NULL,'2025-11-11 09:29:15','2025-11-11 09:29:15'),
(4792,2,'debit',NULL,240000.0000,NULL,'2025-11-11 16:44:00',146,70800,48901,NULL,NULL,NULL,'2025-11-11 09:49:05','2025-11-11 09:49:05'),
(4793,2,'credit',NULL,642000.0000,NULL,'2025-11-11 17:24:03',5,70802,48903,NULL,NULL,NULL,'2025-11-11 10:24:03','2025-11-11 10:24:03'),
(4794,2,'credit',NULL,240000.0000,NULL,'2025-11-11 18:20:13',5,70549,48905,NULL,NULL,NULL,'2025-11-11 11:20:13','2025-11-15 14:00:38'),
(4795,2,'debit',NULL,2091000.0000,NULL,'2025-11-11 19:11:00',106,70810,48907,NULL,NULL,NULL,'2025-11-11 12:11:34','2025-11-11 12:11:34'),
(4796,2,'debit',NULL,28000.0000,NULL,'2025-11-12 09:09:00',6,70834,48923,NULL,NULL,NULL,'2025-11-12 02:11:17','2025-11-12 02:11:17'),
(4797,2,'debit',NULL,3100000.0000,NULL,'2025-11-12 10:48:00',49,70842,48924,NULL,NULL,NULL,'2025-11-12 03:48:37','2025-11-12 03:48:37'),
(4798,2,'debit',NULL,117000.0000,NULL,'2025-11-12 11:37:00',49,70846,48926,NULL,NULL,NULL,'2025-11-12 04:37:58','2025-11-12 04:37:58'),
(4799,2,'debit',NULL,130000.0000,NULL,'2025-11-12 14:04:00',5,70858,48934,NULL,NULL,NULL,'2025-11-12 07:06:05','2025-11-12 07:06:05'),
(4800,2,'debit',NULL,50000.0000,NULL,'2025-11-12 15:18:00',49,70861,48937,NULL,NULL,NULL,'2025-11-12 08:20:03','2025-11-12 08:20:03'),
(4801,2,'debit',NULL,7343000.0000,NULL,'2025-11-12 16:06:00',49,70871,48941,NULL,NULL,NULL,'2025-11-12 09:08:01','2025-11-12 09:08:01'),
(4802,2,'debit',NULL,1578650.0000,NULL,'2025-11-12 16:28:00',49,70874,48942,NULL,NULL,NULL,'2025-11-12 09:29:52','2025-11-12 09:29:52'),
(4803,2,'credit',NULL,200000.0000,NULL,'2025-11-12 17:20:30',106,70854,48947,NULL,NULL,NULL,'2025-11-12 10:20:30','2025-11-12 10:20:30'),
(4804,2,'debit',NULL,55000.0000,NULL,'2025-11-12 17:33:00',19,70878,48948,NULL,NULL,NULL,'2025-11-12 10:37:51','2025-11-12 10:37:51'),
(4805,2,'credit',NULL,88000.0000,NULL,'2025-11-12 17:48:07',5,70699,48952,NULL,NULL,'2025-11-12 10:51:39','2025-11-12 10:48:07','2025-11-12 10:51:39'),
(4806,2,'credit',NULL,8000.0000,NULL,'2025-11-12 17:50:27',5,70882,48954,NULL,NULL,NULL,'2025-11-12 10:50:27','2025-11-12 10:50:27'),
(4807,2,'credit',NULL,40000.0000,NULL,'2025-11-12 17:41:15',5,70699,48949,NULL,NULL,NULL,'2025-11-12 10:51:39','2025-11-12 10:53:01'),
(4808,2,'credit',NULL,40000.0000,NULL,'2025-11-12 17:52:44',5,70883,48955,NULL,NULL,NULL,'2025-11-12 10:52:44','2025-11-12 10:52:44'),
(4809,2,'credit',NULL,200000.0000,NULL,'2025-11-13 12:44:24',49,59256,48988,NULL,NULL,NULL,'2025-11-13 05:44:24','2025-12-01 06:10:59'),
(4810,2,'debit',NULL,322500.0000,NULL,'2025-11-13 13:58:00',106,70924,48993,NULL,NULL,'2025-11-20 02:39:10','2025-11-13 07:04:10','2025-11-20 02:39:10'),
(4811,2,'debit',NULL,195000.0000,NULL,'2025-11-13 15:18:00',106,70928,48998,NULL,NULL,'2025-11-15 06:40:28','2025-11-13 08:20:36','2025-11-15 06:40:28'),
(4812,2,'debit',NULL,825000.0000,NULL,'2025-11-13 15:20:00',106,70929,48999,NULL,NULL,NULL,'2025-11-13 08:21:18','2025-11-13 08:21:18'),
(4813,2,'credit',NULL,190000.0000,NULL,'2025-11-14 13:32:33',5,70969,49020,NULL,NULL,NULL,'2025-11-14 06:32:33','2025-11-14 06:32:33'),
(4814,2,'debit',NULL,335000.0000,NULL,'2025-11-14 14:17:00',5,70975,49027,NULL,NULL,NULL,'2025-11-14 07:17:49','2025-11-14 07:17:49'),
(4815,2,'credit',NULL,87500.0000,NULL,'2025-11-14 14:56:21',5,70379,49029,NULL,NULL,NULL,'2025-11-14 07:56:21','2025-11-20 08:32:29'),
(4816,2,'credit',NULL,185000.0000,NULL,'2025-11-14 15:07:54',49,70980,49030,NULL,NULL,NULL,'2025-11-14 08:07:54','2025-11-14 08:07:54'),
(4817,2,'credit',NULL,463000.0000,NULL,'2025-11-14 16:40:28',49,70962,49036,NULL,NULL,NULL,'2025-11-14 09:40:28','2025-11-14 14:20:02'),
(4818,2,'credit',NULL,450000.0000,NULL,'2025-11-14 17:35:30',19,70309,49039,NULL,NULL,NULL,'2025-11-14 10:35:30','2025-11-14 10:35:30'),
(4819,2,'debit',NULL,18000.0000,NULL,'2025-11-14 18:17:00',19,70995,49045,NULL,NULL,NULL,'2025-11-14 11:18:17','2025-11-14 11:18:17'),
(4820,2,'credit',NULL,992000.0000,NULL,'2025-11-14 20:50:52',19,71011,49057,NULL,NULL,NULL,'2025-11-14 13:50:52','2025-11-14 13:50:52'),
(4821,2,'credit',NULL,300000.0000,NULL,'2025-11-14 21:05:59',5,70979,49061,NULL,NULL,NULL,'2025-11-14 14:05:59','2025-11-14 14:05:59'),
(4822,2,'credit',NULL,388000.0000,NULL,'2025-11-14 21:07:32',5,71015,49062,NULL,NULL,NULL,'2025-11-14 14:07:32','2025-11-14 14:07:32'),
(4823,2,'credit',NULL,187500.0000,NULL,'2025-11-14 21:20:36',5,70850,49065,NULL,NULL,NULL,'2025-11-14 14:20:36','2025-11-14 14:20:36'),
(4824,2,'credit',NULL,187500.0000,NULL,'2025-11-14 21:21:34',5,71019,49066,NULL,NULL,NULL,'2025-11-14 14:21:34','2025-11-14 14:21:34'),
(4825,2,'debit',NULL,1885800.0000,NULL,'2025-11-15 09:21:00',143,71022,49069,NULL,NULL,NULL,'2025-11-15 02:25:09','2025-11-15 02:25:09'),
(4826,2,'debit',NULL,100000.0000,NULL,'2025-11-15 10:30:00',146,71026,49071,NULL,NULL,NULL,'2025-11-15 03:31:03','2025-11-15 03:31:03'),
(4827,2,'debit',NULL,60000.0000,NULL,'2025-11-15 15:46:00',49,71049,49084,NULL,NULL,NULL,'2025-11-15 08:48:02','2025-11-15 08:48:02'),
(4828,2,'debit',NULL,3520000.0000,NULL,'2025-11-15 18:11:00',5,71063,49093,NULL,NULL,NULL,'2025-11-15 11:17:14','2025-11-15 11:17:14'),
(4829,2,'credit',NULL,180000.0000,NULL,'2025-11-15 21:00:11',5,71067,49098,NULL,NULL,NULL,'2025-11-15 14:00:11','2025-11-15 14:00:11'),
(4830,2,'debit',NULL,139000.0000,NULL,'2025-11-16 08:29:00',19,71072,49104,NULL,NULL,NULL,'2025-11-16 01:35:28','2025-11-16 01:35:28'),
(4831,2,'debit',NULL,516000.0000,NULL,'2025-11-16 11:07:00',19,71076,49106,NULL,NULL,NULL,'2025-11-16 04:08:38','2025-11-16 04:08:38'),
(4832,2,'debit',NULL,57000.0000,NULL,'2025-11-17 12:35:00',19,71119,49134,NULL,NULL,NULL,'2025-11-17 05:35:34','2025-11-17 05:35:34'),
(4833,2,'debit',NULL,7528300.0000,NULL,'2025-11-17 12:35:00',19,71120,49135,NULL,NULL,NULL,'2025-11-17 05:36:35','2025-11-17 05:36:35'),
(4834,2,'credit',NULL,2070000.0000,NULL,'2025-11-17 15:08:43',49,71123,49143,NULL,NULL,NULL,'2025-11-17 08:08:43','2025-11-17 08:08:43'),
(4835,2,'debit',NULL,293000.0000,NULL,'2025-11-17 15:09:00',49,71134,49144,NULL,NULL,NULL,'2025-11-17 08:12:34','2025-11-17 08:12:34'),
(4836,2,'debit',NULL,1800000.0000,NULL,'2025-11-17 15:14:00',49,71137,49147,NULL,NULL,NULL,'2025-11-17 08:25:03','2025-11-17 08:25:03'),
(4837,2,'credit',NULL,147000.0000,NULL,'2025-11-17 16:41:23',49,71122,49152,NULL,NULL,NULL,'2025-11-17 09:41:23','2025-11-17 09:41:23'),
(4838,2,'debit',NULL,285000.0000,NULL,'2025-11-17 17:11:00',146,71145,49156,NULL,NULL,NULL,'2025-11-17 10:13:55','2025-11-17 10:13:55'),
(4839,2,'debit',NULL,30448000.0000,NULL,'2025-11-17 17:45:00',5,71156,49164,NULL,NULL,NULL,'2025-11-17 11:01:28','2025-11-17 11:01:28'),
(4840,2,'debit',NULL,2020600.0000,NULL,'2025-11-17 18:06:00',5,71157,49165,NULL,NULL,NULL,'2025-11-17 11:12:44','2025-11-17 11:12:44'),
(4841,2,'debit',NULL,2900000.0000,NULL,'2025-11-17 18:34:00',5,71160,49166,NULL,NULL,NULL,'2025-11-17 11:36:43','2025-11-17 11:36:43'),
(4842,2,'credit',NULL,290000.0000,NULL,'2025-11-17 21:35:49',5,65851,49177,NULL,NULL,NULL,'2025-11-17 14:35:49','2025-11-17 14:35:49'),
(4843,2,'credit',NULL,55000.0000,NULL,'2025-11-17 21:36:26',5,71175,49178,NULL,NULL,NULL,'2025-11-17 14:36:26','2025-11-17 14:36:26'),
(4844,2,'credit',NULL,550000.0000,NULL,'2025-11-18 08:33:17',49,70707,49184,NULL,NULL,NULL,'2025-11-18 01:33:17','2025-11-18 03:17:57'),
(4845,2,'credit',NULL,268000.0000,NULL,'2025-11-18 08:37:38',49,71180,49185,NULL,NULL,NULL,'2025-11-18 01:37:38','2025-11-18 01:37:38'),
(4846,2,'debit',NULL,213500.0000,NULL,'2025-11-18 12:15:00',146,71195,49191,NULL,NULL,NULL,'2025-11-18 05:39:14','2025-11-18 05:39:14'),
(4847,2,'credit',NULL,545000.0000,NULL,'2025-11-18 15:44:00',143,71080,49207,NULL,NULL,NULL,'2025-11-18 08:44:00','2025-11-18 08:44:00'),
(4848,2,'credit',NULL,120000.0000,NULL,'2025-11-18 17:03:46',49,71155,49213,NULL,NULL,NULL,'2025-11-18 10:03:46','2025-11-18 10:03:46'),
(4849,2,'credit',NULL,340000.0000,NULL,'2025-11-18 19:59:35',6,71237,49222,NULL,NULL,NULL,'2025-11-18 12:59:35','2025-11-18 12:59:35'),
(4850,2,'credit',NULL,200000.0000,NULL,'2025-11-18 21:14:34',5,71115,49226,NULL,NULL,NULL,'2025-11-18 14:14:34','2025-12-01 06:09:26'),
(4851,2,'credit',NULL,62000.0000,NULL,'2025-11-19 12:48:26',106,71264,49247,NULL,NULL,NULL,'2025-11-19 05:48:26','2025-11-19 05:48:26'),
(4852,2,'credit',NULL,643000.0000,NULL,'2025-11-19 13:49:47',143,71272,49252,NULL,NULL,NULL,'2025-11-19 06:49:47','2025-11-19 06:49:47'),
(4853,2,'debit',NULL,58000.0000,NULL,'2025-11-19 14:27:00',19,71276,49257,NULL,NULL,NULL,'2025-11-19 07:28:40','2025-11-19 07:28:40'),
(4854,2,'credit',NULL,7170500.0000,NULL,'2025-11-19 14:51:35',49,71253,49259,NULL,NULL,NULL,'2025-11-19 07:51:35','2025-11-21 11:03:57'),
(4855,2,'credit',NULL,643000.0000,NULL,'2025-11-19 15:37:32',49,71287,49263,NULL,NULL,'2025-11-19 09:49:33','2025-11-19 08:37:33','2025-11-19 09:49:33'),
(4856,2,'debit',NULL,4464000.0000,NULL,'2025-11-19 16:06:00',49,71291,49264,NULL,NULL,NULL,'2025-11-19 09:08:41','2025-11-19 09:08:41'),
(4857,2,'credit',NULL,6590000.0000,NULL,'2025-11-19 16:48:12',49,71295,49265,NULL,NULL,NULL,'2025-11-19 10:51:07','2025-11-20 06:48:48'),
(4858,2,'debit',NULL,9950000.0000,NULL,'2025-11-20 08:38:00',146,71318,49274,NULL,NULL,NULL,'2025-11-20 01:44:03','2025-11-20 01:44:03'),
(4859,2,'credit',NULL,330000.0000,NULL,'2025-11-20 08:45:11',106,71285,49275,NULL,NULL,NULL,'2025-11-20 01:45:11','2025-11-20 01:45:11'),
(4860,2,'credit',NULL,127000.0000,NULL,'2025-11-20 08:46:11',106,71319,49276,NULL,NULL,NULL,'2025-11-20 01:46:11','2025-11-20 01:46:11'),
(4861,2,'debit',NULL,18000000.0000,NULL,'2025-11-20 11:20:00',146,71330,49281,NULL,NULL,NULL,'2025-11-20 04:29:08','2025-11-20 04:29:08'),
(4862,2,'credit',NULL,624000.0000,NULL,'2025-11-20 11:37:34',19,71331,49282,NULL,NULL,NULL,'2025-11-20 04:37:34','2025-11-20 04:37:34'),
(4863,2,'debit',NULL,415000.0000,NULL,'2025-11-20 13:43:00',5,71337,49287,NULL,NULL,NULL,'2025-11-20 06:44:17','2025-11-20 06:44:17'),
(4864,2,'credit',NULL,670000.0000,NULL,'2025-11-20 15:32:42',5,71349,49294,NULL,NULL,NULL,'2025-11-20 08:32:42','2025-11-20 08:32:42'),
(4865,2,'credit',NULL,87500.0000,NULL,'2025-11-20 15:33:49',5,71350,49295,NULL,NULL,NULL,'2025-11-20 08:33:49','2025-11-20 08:33:49'),
(4866,2,'debit',NULL,600000.0000,NULL,'2025-11-20 18:29:00',5,71373,49305,NULL,NULL,NULL,'2025-11-20 11:32:23','2025-11-20 11:32:23'),
(4867,2,'debit',NULL,1175202.0000,NULL,'2025-11-20 19:21:00',5,71377,49306,NULL,NULL,NULL,'2025-11-20 12:23:44','2025-11-20 12:23:44'),
(4868,2,'debit',NULL,27975000.0000,NULL,'2025-11-20 19:52:00',5,71380,49307,NULL,NULL,NULL,'2025-11-20 12:58:40','2025-11-20 12:58:40'),
(4869,2,'credit',NULL,4193000.0000,NULL,'2025-11-20 21:15:15',6,71162,49313,NULL,NULL,NULL,'2025-11-20 14:15:15','2025-11-30 07:18:38'),
(4870,2,'debit',NULL,239900.0000,NULL,'2025-11-21 08:43:00',19,71388,49315,NULL,NULL,NULL,'2025-11-21 01:45:24','2025-11-21 01:45:24'),
(4871,2,'credit',NULL,350000.0000,NULL,'2025-11-21 14:24:42',19,71405,49331,NULL,NULL,NULL,'2025-11-21 07:24:42','2025-11-21 07:24:42'),
(4872,2,'debit',NULL,4140000.0000,NULL,'2025-11-21 15:07:00',19,71407,49333,NULL,NULL,'2025-11-21 08:15:09','2025-11-21 08:12:25','2025-11-21 08:15:09'),
(4873,2,'debit',NULL,414000.0000,NULL,'2025-11-21 15:15:00',19,71408,49334,NULL,NULL,NULL,'2025-11-21 08:16:36','2025-11-21 08:16:36'),
(4874,2,'credit',NULL,62000.0000,NULL,'2025-11-21 15:34:37',19,71414,49335,NULL,NULL,NULL,'2025-11-21 08:34:37','2025-11-21 08:34:37'),
(4875,2,'credit',NULL,7170500.0000,NULL,'2025-11-21 17:26:00',5,71253,49340,NULL,NULL,'2025-11-21 11:03:36','2025-11-21 10:26:00','2025-11-21 11:03:36'),
(4876,2,'credit',NULL,6730500.0000,NULL,'2025-11-21 18:03:36',5,71253,49342,NULL,NULL,NULL,'2025-11-21 11:03:57','2025-11-21 11:03:57'),
(4877,2,'credit',NULL,440000.0000,NULL,'2025-11-21 18:04:07',5,71340,49343,NULL,NULL,NULL,'2025-11-21 11:04:07','2025-11-21 11:04:07'),
(4878,2,'credit',NULL,200000.0000,NULL,'2025-11-21 20:15:40',19,71433,49349,NULL,NULL,NULL,'2025-11-21 13:15:40','2025-11-21 13:51:38'),
(4879,2,'credit',NULL,2100000.0000,NULL,'2025-11-21 21:04:26',5,71432,49355,NULL,NULL,NULL,'2025-11-21 14:04:26','2025-11-24 08:54:35'),
(4880,2,'credit','deposit',4005142987.0000,NULL,'2025-11-21 21:36:00',1,NULL,NULL,NULL,'Penyesuaian Saldo',NULL,'2025-11-21 14:36:45','2025-11-21 14:36:45'),
(4881,3,'credit','opening_balance',592970.0000,NULL,'2025-11-21 21:38:00',1,NULL,NULL,NULL,NULL,NULL,'2025-11-21 14:38:00','2025-11-21 14:38:00'),
(4882,2,'debit',NULL,480000.0000,NULL,'2025-11-22 09:34:00',5,71448,49361,NULL,NULL,NULL,'2025-11-22 02:36:15','2025-11-22 02:36:15'),
(4883,2,'credit',NULL,175000.0000,NULL,'2025-11-22 10:15:20',106,71452,49365,NULL,NULL,NULL,'2025-11-22 03:15:20','2025-11-22 08:42:57'),
(4884,2,'debit',NULL,1427000.0000,NULL,'2025-11-22 10:22:00',6,71454,49366,NULL,NULL,NULL,'2025-11-22 03:23:50','2025-11-22 03:23:50'),
(4885,2,'credit',NULL,22000.0000,NULL,'2025-11-22 10:25:21',106,71451,49367,NULL,NULL,NULL,'2025-11-22 03:25:21','2025-11-22 03:25:21'),
(4886,2,'credit',NULL,178000.0000,NULL,'2025-11-22 10:25:21',106,71451,49368,NULL,NULL,NULL,'2025-11-22 03:25:21','2025-11-22 03:25:21'),
(4887,2,'debit',NULL,328000.0000,NULL,'2025-11-22 10:32:00',106,71457,49372,NULL,NULL,NULL,'2025-11-22 03:54:38','2025-11-22 03:54:38'),
(4888,2,'debit',NULL,935000.0000,NULL,'2025-11-22 10:58:00',5,71459,49374,NULL,NULL,NULL,'2025-11-22 03:59:48','2025-11-22 03:59:48'),
(4889,2,'debit',NULL,525000.0000,NULL,'2025-11-22 11:20:00',5,71461,49376,NULL,NULL,NULL,'2025-11-22 04:22:11','2025-11-22 04:22:11'),
(4890,2,'credit',NULL,100000.0000,NULL,'2025-11-22 13:05:28',6,71480,49387,NULL,NULL,NULL,'2025-11-22 06:05:28','2025-11-23 04:32:04'),
(4891,2,'debit',NULL,1275000.0000,NULL,'2025-11-22 13:12:00',6,71482,49389,NULL,NULL,NULL,'2025-11-22 06:13:44','2025-11-22 06:13:44'),
(4892,2,'debit',NULL,10560000.0000,NULL,'2025-11-22 13:15:00',49,71483,49390,NULL,NULL,NULL,'2025-11-22 06:17:58','2025-11-22 06:17:58'),
(4893,2,'credit',NULL,361000.0000,NULL,'2025-11-22 14:42:50',106,71486,49392,NULL,NULL,NULL,'2025-11-22 07:42:50','2025-11-22 07:42:50'),
(4894,2,'credit',NULL,200000.0000,NULL,'2025-11-22 15:03:56',143,71485,49395,NULL,NULL,NULL,'2025-11-22 08:03:56','2025-11-30 03:18:02'),
(4895,2,'credit',NULL,467000.0000,NULL,'2025-11-22 19:24:09',49,71513,49408,NULL,NULL,NULL,'2025-11-22 12:24:09','2025-11-23 05:16:05'),
(4896,2,'credit',NULL,304000.0000,NULL,'2025-11-23 11:31:57',49,71551,49419,NULL,NULL,NULL,'2025-11-23 04:31:57','2025-11-23 04:31:57'),
(4897,2,'credit',NULL,83000.0000,NULL,'2025-11-23 20:39:19',19,71582,49447,NULL,NULL,'2025-11-23 13:43:20','2025-11-23 13:39:19','2025-11-23 13:43:20'),
(4898,2,'credit',NULL,329000.0000,NULL,'2025-11-23 20:43:20',19,71582,49448,NULL,NULL,NULL,'2025-11-23 13:43:20','2025-11-23 13:43:20'),
(4899,2,'credit',NULL,100000.0000,NULL,'2025-11-24 08:50:58',49,71467,49452,NULL,NULL,NULL,'2025-11-24 01:50:58','2025-11-24 02:49:40'),
(4900,2,'debit',NULL,100000.0000,NULL,'2025-11-24 11:12:00',146,71594,49460,NULL,NULL,NULL,'2025-11-24 04:13:28','2025-11-24 04:13:28'),
(4901,2,'debit',NULL,3286040.0000,NULL,'2025-11-24 11:26:00',49,71598,49463,NULL,NULL,NULL,'2025-11-24 04:31:05','2025-11-24 04:31:05'),
(4902,2,'credit',NULL,3118000.0000,NULL,'2025-11-24 11:40:35',143,70970,49464,NULL,NULL,NULL,'2025-11-24 04:40:35','2025-11-30 08:12:43'),
(4903,2,'debit',NULL,125200.0000,NULL,'2025-11-24 12:42:00',146,71607,49468,NULL,NULL,NULL,'2025-11-24 05:44:17','2025-11-24 05:44:17'),
(4904,2,'debit',NULL,719088.0000,NULL,'2025-11-24 12:59:00',49,71610,49471,NULL,NULL,NULL,'2025-11-24 06:12:59','2025-11-24 06:12:59'),
(4905,2,'debit',NULL,213500.0000,NULL,'2025-11-24 13:29:00',49,71612,49472,NULL,NULL,NULL,'2025-11-24 06:30:30','2025-11-24 06:30:30'),
(4906,2,'debit',NULL,77000.0000,NULL,'2025-11-24 15:22:00',146,71620,49483,NULL,NULL,NULL,'2025-11-24 08:23:59','2025-11-24 08:23:59'),
(4907,2,'debit',NULL,14786342.0000,NULL,'2025-11-24 16:47:00',146,71630,49490,NULL,NULL,NULL,'2025-11-24 09:58:23','2025-12-03 05:03:59'),
(4908,2,'credit',NULL,649000.0000,NULL,'2025-11-24 10:31:07',143,71592,49458,NULL,NULL,NULL,'2025-11-24 10:20:17','2025-11-24 10:20:17'),
(4909,2,'credit',NULL,4065000.0000,NULL,'2025-11-24 19:49:39',106,71639,49498,NULL,NULL,NULL,'2025-11-24 12:49:39','2025-11-24 12:49:39'),
(4910,2,'debit',NULL,200000.0000,NULL,'2025-11-25 08:52:00',1,71625,49503,NULL,NULL,NULL,'2025-11-25 01:52:27','2025-11-25 01:52:27'),
(4911,2,'credit',NULL,114000.0000,NULL,'2025-11-25 09:43:07',49,71649,49505,NULL,NULL,NULL,'2025-11-25 02:43:07','2025-11-25 02:43:07'),
(4912,2,'debit',NULL,3810000.0000,NULL,'2025-11-25 13:01:00',106,71660,49511,NULL,NULL,NULL,'2025-11-25 06:02:06','2025-11-25 06:02:06'),
(4913,2,'debit',NULL,406000.0000,NULL,'2025-11-25 15:12:00',5,71665,49517,NULL,NULL,NULL,'2025-11-25 08:13:32','2025-11-25 08:13:32'),
(4914,2,'credit',NULL,80000.0000,NULL,'2025-11-25 16:07:32',2,71658,49519,NULL,NULL,NULL,'2025-11-25 09:07:32','2025-11-25 09:27:36'),
(4915,2,'credit',NULL,597500.0000,NULL,'2025-11-25 19:41:32',19,71698,49530,NULL,NULL,NULL,'2025-11-25 12:41:32','2025-11-25 12:41:32'),
(4916,2,'credit',NULL,200000.0000,NULL,'2025-11-26 09:35:35',143,71706,49536,NULL,NULL,NULL,'2025-11-26 02:35:35','2025-11-26 02:35:35'),
(4917,3,'credit',NULL,748000.0000,NULL,'2025-11-26 13:49:27',106,71602,49546,NULL,NULL,NULL,'2025-11-26 06:49:27','2025-11-26 06:49:27'),
(4918,2,'credit',NULL,300000.0000,NULL,'2025-11-26 17:54:24',106,71683,49556,NULL,NULL,NULL,'2025-11-26 10:54:24','2025-11-26 10:54:24'),
(4919,2,'debit',NULL,2900000.0000,NULL,'2025-11-26 19:21:00',5,71751,49560,NULL,NULL,NULL,'2025-11-26 12:24:00','2025-11-26 12:24:00'),
(4920,2,'debit',NULL,470000.0000,NULL,'2025-11-26 19:47:00',106,71753,49561,NULL,NULL,NULL,'2025-11-26 12:48:28','2025-11-26 12:48:28'),
(4921,2,'credit',NULL,1550000.0000,NULL,'2025-11-26 20:11:20',19,71757,49566,NULL,NULL,NULL,'2025-11-26 13:11:20','2025-11-26 13:11:20'),
(4922,2,'credit',NULL,200000.0000,NULL,'2025-11-26 21:54:47',5,71758,49577,NULL,NULL,NULL,'2025-11-26 14:54:47','2025-11-29 08:45:29'),
(4923,2,'debit',NULL,180000.0000,NULL,'2025-11-27 18:45:00',19,71813,49608,NULL,NULL,NULL,'2025-11-27 11:50:06','2025-11-27 11:50:06'),
(4924,2,'credit',NULL,400000.0000,NULL,'2025-11-27 20:13:57',5,71818,49610,NULL,NULL,NULL,'2025-11-27 13:13:57','2025-11-28 11:56:53'),
(4925,2,'credit',NULL,1000000.0000,NULL,'2025-11-28 08:27:19',143,71661,49614,NULL,NULL,NULL,'2025-11-28 01:27:20','2025-12-01 07:12:12'),
(4926,3,'credit',NULL,465000.0000,NULL,'2025-11-28 10:57:34',49,71790,49626,NULL,NULL,NULL,'2025-11-28 03:57:34','2025-11-28 06:20:00'),
(4927,2,'credit',NULL,295000.0000,NULL,'2025-11-28 13:46:44',2,71833,49628,NULL,NULL,NULL,'2025-11-28 06:46:44','2025-11-28 06:46:44'),
(4928,2,'debit',NULL,5699874.0000,NULL,'2025-11-28 14:13:00',49,71838,49631,NULL,NULL,NULL,'2025-11-28 07:25:46','2025-11-28 07:25:46'),
(4929,2,'credit',NULL,1500000.0000,NULL,'2025-11-28 15:59:19',6,71085,49636,NULL,NULL,NULL,'2025-11-28 08:59:19','2025-12-01 11:02:34'),
(4930,2,'debit',NULL,1440000.0000,NULL,'2025-11-28 16:13:00',6,71860,49637,NULL,NULL,NULL,'2025-11-28 09:15:20','2025-11-28 09:15:20'),
(4931,2,'debit',NULL,105000.0000,NULL,'2025-11-28 18:02:00',19,71873,49643,NULL,NULL,NULL,'2025-11-28 11:03:51','2025-11-28 11:03:51'),
(4932,2,'credit',NULL,500000.0000,NULL,'2025-11-28 18:56:53',5,71818,49645,NULL,NULL,NULL,'2025-11-28 11:56:53','2025-11-28 11:56:53'),
(4933,2,'credit',NULL,450000.0000,NULL,'2025-11-28 19:54:03',5,71035,49650,NULL,NULL,NULL,'2025-11-28 12:54:03','2025-11-28 12:54:03'),
(4934,2,'credit',NULL,80000.0000,NULL,'2025-11-28 19:54:41',5,71323,49651,NULL,NULL,NULL,'2025-11-28 12:54:41','2025-11-28 12:54:41'),
(4935,2,'credit',NULL,200000.0000,NULL,'2025-11-28 21:53:07',5,71878,49658,NULL,NULL,NULL,'2025-11-28 14:53:07','2025-12-01 06:08:06'),
(4936,2,'credit',NULL,1500000.0000,NULL,'2025-11-29 08:15:55',6,71780,49659,NULL,NULL,NULL,'2025-11-29 01:15:55','2025-12-01 08:30:04'),
(4937,2,'credit',NULL,200000.0000,NULL,'2025-11-29 11:55:49',49,71906,49665,NULL,NULL,NULL,'2025-11-29 04:55:49','2025-12-01 06:57:10'),
(4938,2,'credit',NULL,1000000.0000,NULL,'2025-11-29 13:44:17',5,71912,49668,NULL,NULL,NULL,'2025-11-29 06:44:17','2025-12-01 06:06:43'),
(4939,2,'debit',NULL,111000.0000,NULL,'2025-11-29 14:19:00',5,71915,49669,NULL,NULL,NULL,'2025-11-29 07:20:32','2025-11-29 07:20:32'),
(4940,2,'credit',NULL,975000.0000,NULL,'2025-11-29 15:45:31',49,70597,49672,NULL,NULL,NULL,'2025-11-29 08:45:31','2025-12-01 11:42:57'),
(4941,2,'credit',NULL,1882000.0000,NULL,'2025-11-29 16:52:13',6,71085,49676,NULL,NULL,NULL,'2025-11-29 09:52:13','2025-12-01 11:02:34'),
(4942,2,'credit',NULL,1000000.0000,NULL,'2025-11-29 17:54:12',143,71830,49680,NULL,NULL,NULL,'2025-11-29 10:54:12','2025-12-02 08:22:04'),
(4943,2,'debit',NULL,219000.0000,NULL,'2025-11-29 19:11:00',5,71931,49682,NULL,NULL,NULL,'2025-11-29 12:12:45','2025-11-29 12:12:45'),
(4944,2,'debit',NULL,7242000.0000,NULL,'2025-11-29 19:14:00',5,71932,49683,NULL,NULL,NULL,'2025-11-29 12:17:59','2025-12-03 05:02:52'),
(4945,2,'debit',NULL,5292150.0000,NULL,'2025-11-29 19:22:00',5,71933,49684,NULL,NULL,NULL,'2025-11-29 12:28:12','2025-11-29 12:28:12'),
(4946,2,'credit',NULL,300000.0000,NULL,'2025-11-29 19:53:49',5,71935,49685,NULL,NULL,NULL,'2025-11-29 12:55:34','2025-11-29 12:55:34'),
(4947,2,'debit',NULL,671410.0000,NULL,'2025-11-30 08:28:00',19,71939,49691,NULL,NULL,NULL,'2025-11-30 01:30:07','2025-11-30 01:30:07'),
(4948,2,'credit',NULL,200000.0000,NULL,'2025-11-30 13:00:23',6,71951,49696,NULL,NULL,NULL,'2025-11-30 06:00:23','2025-11-30 06:00:23'),
(4949,2,'credit',NULL,2000000.0000,NULL,'2025-11-30 14:05:29',49,71948,49700,NULL,NULL,NULL,'2025-11-30 07:05:29','2025-12-03 11:48:38'),
(4950,2,'credit',NULL,400000.0000,NULL,'2025-11-30 14:20:09',19,71962,49703,NULL,NULL,NULL,'2025-11-30 07:20:09','2025-11-30 07:20:09'),
(4951,2,'credit',NULL,400000.0000,NULL,'2025-11-30 14:20:25',19,71963,49704,NULL,NULL,NULL,'2025-11-30 07:20:25','2025-11-30 07:20:25'),
(4952,2,'credit',NULL,100000.0000,NULL,'2025-11-30 14:26:12',6,71967,49709,NULL,NULL,NULL,'2025-11-30 07:26:12','2025-11-30 07:26:12'),
(4953,2,'credit',NULL,295000.0000,NULL,'2025-11-30 15:03:08',5,70896,49716,NULL,NULL,NULL,'2025-11-30 08:03:08','2025-11-30 08:03:08'),
(4954,2,'debit',NULL,24600.0000,NULL,'2025-11-30 15:28:00',19,71976,49722,NULL,NULL,NULL,'2025-11-30 08:29:35','2025-11-30 08:29:35'),
(4955,2,'credit',NULL,60000.0000,NULL,'2025-11-30 16:03:58',143,71981,49726,NULL,NULL,NULL,'2025-11-30 09:03:58','2025-11-30 09:03:58'),
(4956,2,'credit',NULL,2500000.0000,NULL,'2025-11-30 19:58:02',49,71946,49741,NULL,NULL,NULL,'2025-11-30 12:58:02','2025-12-01 06:05:50'),
(4957,2,'credit',NULL,720000.0000,NULL,'2025-12-01 12:11:00',19,72000,49770,NULL,NULL,NULL,'2025-12-01 05:11:30','2025-12-01 06:24:07'),
(4958,2,'debit',NULL,489000.0000,NULL,'2025-12-01 13:29:00',49,72017,49771,NULL,NULL,NULL,'2025-12-01 06:45:05','2025-12-01 06:45:05'),
(4959,2,'credit',NULL,597000.0000,NULL,'2025-12-01 14:12:12',143,71661,49772,NULL,NULL,NULL,'2025-12-01 07:12:12','2025-12-01 07:12:12'),
(4960,2,'debit',NULL,690000.0000,NULL,'2025-12-01 14:32:00',143,72020,49775,NULL,NULL,NULL,'2025-12-01 07:38:04','2025-12-01 07:38:04'),
(4961,2,'credit',NULL,156000.0000,NULL,'2025-12-01 15:33:44',5,72018,49778,NULL,NULL,NULL,'2025-12-01 08:33:44','2025-12-01 08:33:44'),
(4962,2,'credit',NULL,89000.0000,NULL,'2025-12-01 17:04:54',106,72040,49783,NULL,NULL,NULL,'2025-12-01 10:04:54','2025-12-01 10:04:54'),
(4963,2,'credit',NULL,975000.0000,NULL,'2025-12-01 18:46:55',5,72048,49788,NULL,NULL,NULL,'2025-12-01 11:46:55','2025-12-01 11:46:55'),
(4964,3,'debit',NULL,130000.0000,NULL,'2025-12-01 19:57:00',5,72069,49790,NULL,NULL,NULL,'2025-12-01 12:58:02','2025-12-01 12:58:02'),
(4965,2,'credit',NULL,178000.0000,NULL,'2025-12-02 10:04:04',106,72086,49805,NULL,NULL,NULL,'2025-12-02 03:04:04','2025-12-02 03:04:04'),
(4966,2,'credit',NULL,385000.0000,NULL,'2025-12-02 11:29:44',106,72093,49811,NULL,NULL,NULL,'2025-12-02 04:29:44','2025-12-02 04:29:44'),
(4967,2,'credit',NULL,1083000.0000,NULL,'2025-12-02 15:27:57',6,72117,49827,NULL,NULL,NULL,'2025-12-02 08:27:57','2025-12-02 08:27:57'),
(4968,2,'credit',NULL,1083000.0000,NULL,'2025-12-02 15:29:11',6,72119,49828,NULL,NULL,NULL,'2025-12-02 08:29:11','2025-12-02 08:29:11'),
(4969,2,'credit',NULL,1083000.0000,NULL,'2025-12-02 15:30:26',6,72120,49829,NULL,NULL,NULL,'2025-12-02 08:30:26','2025-12-02 08:30:26'),
(4970,2,'credit',NULL,481000.0000,NULL,'2025-12-02 15:33:48',6,72121,49830,NULL,NULL,NULL,'2025-12-02 08:33:48','2025-12-02 08:33:48'),
(4971,2,'debit',NULL,220000.0000,NULL,'2025-12-02 17:06:00',106,72134,49833,NULL,NULL,NULL,'2025-12-02 10:07:58','2025-12-02 10:07:58'),
(4972,2,'credit',NULL,200000.0000,NULL,'2025-12-02 18:11:29',49,68206,49838,NULL,NULL,NULL,'2025-12-02 11:11:29','2025-12-02 14:23:52'),
(4973,2,'debit',NULL,5449000.0000,NULL,'2025-12-02 18:34:00',49,72140,49840,NULL,NULL,NULL,'2025-12-02 11:36:16','2025-12-02 11:36:16'),
(4974,2,'credit',NULL,136500.0000,NULL,'2025-12-03 09:23:35',106,72061,49852,NULL,NULL,NULL,'2025-12-03 02:23:35','2025-12-03 02:23:35'),
(4975,3,'credit',NULL,351000.0000,NULL,'2025-12-03 11:16:12',106,72128,49856,NULL,NULL,NULL,'2025-12-03 04:16:12','2025-12-03 04:16:12'),
(4976,2,'debit',NULL,8080814.0000,NULL,'2025-12-03 11:41:00',19,71821,49857,NULL,NULL,NULL,'2025-12-03 04:41:23','2025-12-03 04:41:23'),
(4977,2,'credit',NULL,84000.0000,NULL,'2025-12-03 11:45:38',106,72164,49858,NULL,NULL,NULL,'2025-12-03 04:45:38','2025-12-03 06:29:34'),
(4978,2,'debit',NULL,9765000.0000,NULL,'2025-12-03 12:04:00',19,71834,49860,NULL,NULL,NULL,'2025-12-03 05:04:28','2025-12-03 05:04:28'),
(4979,2,'debit',NULL,1393410.0000,NULL,'2025-12-03 12:30:00',19,72163,49862,NULL,NULL,NULL,'2025-12-03 05:30:46','2025-12-03 05:30:46'),
(4980,2,'debit',NULL,1161000.0000,NULL,'2025-12-03 12:41:00',19,72166,49863,NULL,NULL,NULL,'2025-12-03 05:41:22','2025-12-03 05:41:22'),
(4981,2,'debit',NULL,2172643.0000,NULL,'2025-12-03 12:41:00',19,72162,49864,NULL,NULL,NULL,'2025-12-03 05:42:02','2025-12-03 05:42:02'),
(4982,2,'credit',NULL,386000.0000,NULL,'2025-12-03 13:29:34',106,72164,49870,NULL,NULL,NULL,'2025-12-03 06:29:34','2025-12-03 06:29:34'),
(4983,2,'debit',NULL,2310000.0000,NULL,'2025-12-03 14:04:00',5,72175,49874,NULL,NULL,NULL,'2025-12-03 07:06:44','2025-12-03 07:06:44'),
(4984,2,'debit',NULL,570000.0000,NULL,'2025-12-03 14:48:00',19,72009,49880,NULL,NULL,NULL,'2025-12-03 07:48:41','2025-12-03 07:48:41'),
(4985,2,'debit',NULL,40000.0000,NULL,'2025-12-03 14:49:00',19,71862,49881,NULL,NULL,NULL,'2025-12-03 07:49:59','2025-12-03 07:49:59'),
(4986,2,'debit',NULL,891000.0000,NULL,'2025-12-03 14:51:00',19,71797,49882,NULL,NULL,NULL,'2025-12-03 07:51:11','2025-12-03 07:51:11'),
(4987,2,'debit',NULL,1200001.0000,NULL,'2025-12-03 14:51:00',19,71624,49883,NULL,NULL,NULL,'2025-12-03 07:51:45','2025-12-03 07:51:45'),
(4988,2,'debit',NULL,7255450.0000,NULL,'2025-12-03 14:51:00',19,71336,49884,NULL,NULL,NULL,'2025-12-03 07:52:03','2025-12-03 07:52:03'),
(4989,2,'debit',NULL,7821901.0000,NULL,'2025-12-03 14:52:00',19,71317,49885,NULL,NULL,NULL,'2025-12-03 07:52:24','2025-12-03 07:52:24'),
(4990,2,'debit',NULL,5636571.0000,NULL,'2025-12-03 14:52:00',19,71316,49886,NULL,NULL,NULL,'2025-12-03 07:52:43','2025-12-03 07:52:43'),
(4991,2,'debit',NULL,1130975.0000,NULL,'2025-12-03 14:52:00',19,71309,49887,NULL,NULL,NULL,'2025-12-03 07:53:05','2025-12-03 07:53:05'),
(4992,2,'debit',NULL,21834500.0000,NULL,'2025-12-03 14:53:00',19,70956,49888,NULL,NULL,NULL,'2025-12-03 07:53:34','2025-12-03 07:53:34'),
(4993,2,'debit',NULL,5229296.0000,NULL,'2025-12-03 14:53:00',19,70949,49889,NULL,NULL,NULL,'2025-12-03 07:53:57','2025-12-03 07:53:57'),
(4994,2,'debit',NULL,260000.0000,NULL,'2025-12-03 14:54:00',19,70873,49890,NULL,NULL,NULL,'2025-12-03 07:54:16','2025-12-03 07:54:16'),
(4995,2,'debit',NULL,20306016.0000,NULL,'2025-12-03 14:54:00',19,70851,49891,NULL,NULL,NULL,'2025-12-03 07:54:42','2025-12-03 07:54:42'),
(4996,2,'debit',NULL,53000.0000,NULL,'2025-12-03 14:55:00',19,70836,49892,NULL,NULL,NULL,'2025-12-03 07:55:13','2025-12-03 07:55:13'),
(4997,2,'debit',NULL,12569760.0000,NULL,'2025-12-03 14:55:00',19,70795,49893,NULL,NULL,NULL,'2025-12-03 07:55:29','2025-12-03 07:55:29'),
(4998,2,'debit',NULL,1945502.0000,NULL,'2025-12-03 14:55:00',19,70786,49894,NULL,NULL,NULL,'2025-12-03 07:55:58','2025-12-03 07:55:58'),
(4999,2,'debit',NULL,8740350.0000,NULL,'2025-12-03 14:57:00',19,70763,49895,NULL,NULL,NULL,'2025-12-03 07:57:29','2025-12-03 07:57:29'),
(5000,2,'debit',NULL,18915500.0000,NULL,'2025-12-03 14:57:00',19,70695,49896,NULL,NULL,NULL,'2025-12-03 07:57:51','2025-12-03 07:57:51'),
(5001,2,'debit',NULL,763000.0000,NULL,'2025-12-03 14:58:00',19,70670,49897,NULL,NULL,NULL,'2025-12-03 07:58:09','2025-12-03 07:58:09'),
(5002,2,'debit',NULL,146630.0000,NULL,'2025-12-03 14:58:00',19,70375,49898,NULL,NULL,NULL,'2025-12-03 07:58:27','2025-12-03 07:58:27'),
(5003,2,'debit',NULL,310000.0000,NULL,'2025-12-03 14:58:00',19,70360,49899,NULL,NULL,NULL,'2025-12-03 07:58:44','2025-12-03 07:58:44'),
(5004,2,'debit',NULL,205000.0000,NULL,'2025-12-03 14:58:00',19,70299,49900,NULL,NULL,NULL,'2025-12-03 07:59:06','2025-12-03 07:59:06'),
(5005,2,'debit',NULL,400000.0000,NULL,'2025-12-03 15:01:00',19,57561,49901,NULL,NULL,NULL,'2025-12-03 08:01:53','2025-12-03 08:01:53'),
(5006,2,'debit',NULL,227400.0000,NULL,'2025-12-03 15:03:00',19,62903,49902,NULL,NULL,NULL,'2025-12-03 08:03:40','2025-12-03 08:03:40'),
(5007,2,'debit',NULL,360000.0000,NULL,'2025-12-03 15:04:00',19,63040,49903,NULL,NULL,NULL,'2025-12-03 08:04:58','2025-12-03 08:04:58'),
(5008,2,'debit',NULL,409100.0000,NULL,'2025-12-03 15:05:00',19,63217,49904,NULL,NULL,NULL,'2025-12-03 08:05:29','2025-12-03 08:05:29'),
(5009,2,'debit',NULL,177500.0000,NULL,'2025-12-03 15:06:00',19,63269,49905,NULL,NULL,NULL,'2025-12-03 08:06:17','2025-12-03 08:06:17'),
(5010,2,'debit',NULL,800000.0000,NULL,'2025-12-03 15:07:00',19,63672,49906,NULL,NULL,NULL,'2025-12-03 08:07:19','2025-12-03 08:07:19'),
(5011,2,'debit',NULL,134100.0000,NULL,'2025-12-03 15:07:00',19,63694,49907,NULL,NULL,NULL,'2025-12-03 08:07:52','2025-12-03 08:07:52'),
(5012,2,'debit',NULL,402300.0000,NULL,'2025-12-03 15:08:00',19,63804,49908,NULL,NULL,NULL,'2025-12-03 08:08:25','2025-12-03 08:08:25'),
(5013,2,'debit',NULL,4100000.0000,NULL,'2025-12-03 15:08:00',19,63864,49909,NULL,NULL,NULL,'2025-12-03 08:09:00','2025-12-03 08:09:00'),
(5014,2,'debit',NULL,156900.0000,NULL,'2025-12-03 15:09:00',19,63951,49910,NULL,NULL,NULL,'2025-12-03 08:09:34','2025-12-03 08:09:34'),
(5015,2,'debit',NULL,136900.0000,NULL,'2025-12-03 15:10:00',19,63952,49911,NULL,NULL,NULL,'2025-12-03 08:10:14','2025-12-03 08:10:14'),
(5016,2,'debit',NULL,9222000.0000,NULL,'2025-12-03 15:10:00',19,63976,49912,NULL,NULL,NULL,'2025-12-03 08:11:15','2025-12-03 08:11:15'),
(5017,2,'debit',NULL,341900.0000,NULL,'2025-12-03 15:13:00',19,63977,49913,NULL,NULL,NULL,'2025-12-03 08:13:14','2025-12-03 08:13:14'),
(5018,2,'debit',NULL,71823.0000,NULL,'2025-12-03 15:13:00',19,64015,49914,NULL,NULL,NULL,'2025-12-03 08:13:52','2025-12-03 08:13:52'),
(5019,2,'debit',NULL,62076.0000,NULL,'2025-12-03 15:14:00',19,64016,49915,NULL,NULL,NULL,'2025-12-03 08:14:42','2025-12-03 08:14:42'),
(5020,2,'debit',NULL,335000.0000,NULL,'2025-12-03 15:15:00',19,64152,49916,NULL,NULL,NULL,'2025-12-03 08:16:08','2025-12-03 08:16:08'),
(5021,2,'debit',NULL,20000.0000,NULL,'2025-12-03 15:16:00',19,64153,49917,NULL,NULL,NULL,'2025-12-03 08:16:51','2025-12-03 08:16:51'),
(5022,2,'debit',NULL,529000.0000,NULL,'2025-12-03 15:17:00',19,64182,49918,NULL,NULL,NULL,'2025-12-03 08:17:49','2025-12-03 08:17:49'),
(5023,2,'debit',NULL,175214.0000,NULL,'2025-12-03 15:18:00',19,64204,49919,NULL,NULL,NULL,'2025-12-03 08:18:42','2025-12-03 08:18:42'),
(5024,2,'debit',NULL,124000.0000,NULL,'2025-12-03 15:19:00',19,64211,49920,NULL,NULL,NULL,'2025-12-03 08:19:12','2025-12-03 08:19:12'),
(5025,2,'debit',NULL,845680.0000,NULL,'2025-12-03 15:19:00',19,64238,49921,NULL,NULL,NULL,'2025-12-03 08:19:52','2025-12-03 08:19:52'),
(5026,2,'debit',NULL,180000.0000,NULL,'2025-12-03 15:20:00',19,64266,49922,NULL,NULL,NULL,'2025-12-03 08:20:30','2025-12-03 08:20:30'),
(5027,2,'debit',NULL,3780000.0000,NULL,'2025-12-03 15:20:00',19,64301,49923,NULL,NULL,NULL,'2025-12-03 08:21:01','2025-12-03 08:21:01'),
(5028,2,'debit',NULL,1048000.0000,NULL,'2025-12-03 15:21:00',19,64306,49924,NULL,NULL,NULL,'2025-12-03 08:21:37','2025-12-03 08:21:37'),
(5029,2,'debit',NULL,1098000.0000,NULL,'2025-12-03 15:22:00',19,64408,49925,NULL,NULL,NULL,'2025-12-03 08:22:15','2025-12-03 08:22:15'),
(5030,2,'debit',NULL,124000.0000,NULL,'2025-12-03 15:23:00',19,64426,49926,NULL,NULL,NULL,'2025-12-03 08:23:05','2025-12-03 08:23:05'),
(5031,2,'debit',NULL,170000.0000,NULL,'2025-12-03 15:23:00',19,64428,49927,NULL,NULL,NULL,'2025-12-03 08:23:47','2025-12-03 08:23:47'),
(5032,2,'debit',NULL,498141.0000,NULL,'2025-12-03 15:24:00',19,64435,49928,NULL,NULL,NULL,'2025-12-03 08:24:20','2025-12-03 08:24:20'),
(5033,2,'debit',NULL,864500.0000,NULL,'2025-12-03 15:24:00',19,64436,49929,NULL,NULL,NULL,'2025-12-03 08:24:52','2025-12-03 08:24:52'),
(5034,2,'debit',NULL,241004.0000,NULL,'2025-12-03 15:25:00',19,64514,49930,NULL,NULL,NULL,'2025-12-03 08:25:24','2025-12-03 08:25:24'),
(5035,2,'debit',NULL,220000.0000,NULL,'2025-12-03 15:25:00',19,64519,49931,NULL,NULL,NULL,'2025-12-03 08:25:57','2025-12-03 08:25:57'),
(5036,2,'debit',NULL,130000.0000,NULL,'2025-12-03 15:26:00',19,64528,49932,NULL,NULL,NULL,'2025-12-03 08:26:25','2025-12-03 08:26:25'),
(5037,2,'debit',NULL,14459976.0000,NULL,'2025-12-03 15:26:00',19,64559,49933,NULL,NULL,NULL,'2025-12-03 08:27:03','2025-12-03 08:27:03'),
(5038,2,'debit',NULL,100000.0000,NULL,'2025-12-03 15:27:00',19,64655,49934,NULL,NULL,NULL,'2025-12-03 08:27:30','2025-12-03 08:27:30'),
(5039,2,'debit',NULL,169000.0000,NULL,'2025-12-03 15:28:00',19,64682,49935,NULL,NULL,NULL,'2025-12-03 08:28:18','2025-12-03 08:28:18'),
(5040,2,'debit',NULL,892000.0000,NULL,'2025-12-03 15:28:00',19,64718,49936,NULL,NULL,NULL,'2025-12-03 08:28:48','2025-12-03 08:28:48'),
(5041,2,'debit',NULL,112000.0000,NULL,'2025-12-03 15:29:00',19,64719,49937,NULL,NULL,NULL,'2025-12-03 08:29:18','2025-12-03 08:29:18'),
(5042,2,'debit',NULL,272000.0000,NULL,'2025-12-03 15:29:00',19,64720,49938,NULL,NULL,NULL,'2025-12-03 08:29:44','2025-12-03 08:29:44'),
(5043,2,'debit',NULL,1300000.0000,NULL,'2025-12-03 15:30:00',19,64722,49939,NULL,NULL,NULL,'2025-12-03 08:30:07','2025-12-03 08:30:07'),
(5044,2,'debit',NULL,427000.0000,NULL,'2025-12-03 15:30:00',19,64774,49940,NULL,NULL,NULL,'2025-12-03 08:30:37','2025-12-03 08:30:37'),
(5045,2,'debit',NULL,185000.0000,NULL,'2025-12-03 15:31:00',19,64826,49941,NULL,NULL,NULL,'2025-12-03 08:31:27','2025-12-03 08:31:27'),
(5046,2,'debit',NULL,525000.0000,NULL,'2025-12-03 15:31:00',19,65010,49942,NULL,NULL,NULL,'2025-12-03 08:31:57','2025-12-03 08:31:57'),
(5047,2,'debit',NULL,155000.0000,NULL,'2025-12-03 15:32:00',19,65015,49943,NULL,NULL,NULL,'2025-12-03 08:32:26','2025-12-03 08:32:26'),
(5048,2,'debit',NULL,1128958.0000,NULL,'2025-12-03 15:27:00',5,72180,49944,NULL,NULL,NULL,'2025-12-03 08:32:39','2025-12-03 08:32:39'),
(5049,2,'debit',NULL,779325.0000,NULL,'2025-12-03 15:32:00',19,65158,49945,NULL,NULL,NULL,'2025-12-03 08:32:57','2025-12-03 08:32:57'),
(5050,2,'debit',NULL,275300.0000,NULL,'2025-12-03 15:33:00',19,65376,49946,NULL,NULL,NULL,'2025-12-03 08:33:27','2025-12-03 08:33:27'),
(5051,2,'debit',NULL,10500.0000,NULL,'2025-12-03 15:33:00',19,65378,49947,NULL,NULL,NULL,'2025-12-03 08:34:00','2025-12-03 08:34:00'),
(5052,2,'debit',NULL,933900.0000,NULL,'2025-12-03 15:34:00',19,65454,49948,NULL,NULL,NULL,'2025-12-03 08:34:36','2025-12-03 08:34:36'),
(5053,2,'debit',NULL,1174300.0000,NULL,'2025-12-03 15:35:00',19,65477,49949,NULL,NULL,NULL,'2025-12-03 08:35:10','2025-12-03 08:35:10'),
(5054,2,'debit',NULL,300000.0000,NULL,'2025-12-03 15:35:00',19,65486,49950,NULL,NULL,NULL,'2025-12-03 08:35:34','2025-12-03 08:35:34'),
(5055,2,'debit',NULL,9811098.0000,NULL,'2025-12-03 15:35:00',19,65697,49951,NULL,NULL,NULL,'2025-12-03 08:36:02','2025-12-03 08:36:02'),
(5056,2,'debit',NULL,810000.0000,NULL,'2025-12-03 15:36:00',19,65698,49952,NULL,NULL,NULL,'2025-12-03 08:36:29','2025-12-03 08:36:29'),
(5057,2,'debit',NULL,890000.0000,NULL,'2025-12-03 15:36:00',19,66101,49953,NULL,NULL,NULL,'2025-12-03 08:36:58','2025-12-03 08:36:58'),
(5058,2,'debit',NULL,3164000.0000,NULL,'2025-12-03 15:37:00',19,66318,49954,NULL,NULL,NULL,'2025-12-03 08:37:36','2025-12-03 08:37:36'),
(5059,2,'debit',NULL,772200.0000,NULL,'2025-12-03 15:38:00',19,66431,49955,NULL,NULL,NULL,'2025-12-03 08:38:27','2025-12-03 08:38:27'),
(5060,2,'debit',NULL,5700000.0000,NULL,'2025-12-03 15:38:00',19,66500,49957,NULL,NULL,NULL,'2025-12-03 08:39:05','2025-12-03 08:39:05'),
(5061,2,'debit',NULL,529000.0000,NULL,'2025-12-03 15:39:00',19,66538,49958,NULL,NULL,NULL,'2025-12-03 08:39:36','2025-12-03 08:39:36'),
(5062,2,'debit',NULL,11165850.0000,NULL,'2025-12-03 15:40:00',19,66594,49959,NULL,NULL,NULL,'2025-12-03 08:40:14','2025-12-03 08:40:14'),
(5063,2,'debit',NULL,2326404.0000,NULL,'2025-12-03 15:40:00',19,66666,49960,NULL,NULL,NULL,'2025-12-03 08:40:53','2025-12-03 08:40:53'),
(5064,2,'debit',NULL,470000.0000,NULL,'2025-12-03 15:41:00',19,66793,49961,NULL,NULL,NULL,'2025-12-03 08:41:38','2025-12-03 08:41:38'),
(5065,2,'debit',NULL,90000.0000,NULL,'2025-12-03 15:41:00',19,66890,49962,NULL,NULL,NULL,'2025-12-03 08:42:04','2025-12-03 08:42:04'),
(5066,2,'debit',NULL,31744000.0000,NULL,'2025-12-03 15:42:00',19,67041,49963,NULL,NULL,NULL,'2025-12-03 08:43:03','2025-12-03 08:43:03'),
(5067,2,'debit',NULL,41103750.0000,NULL,'2025-12-03 15:43:00',19,67044,49964,NULL,NULL,NULL,'2025-12-03 08:43:45','2025-12-03 08:43:45'),
(5068,2,'debit',NULL,4211500.0000,NULL,'2025-12-03 15:44:00',19,67167,49965,NULL,NULL,NULL,'2025-12-03 08:44:11','2025-12-03 08:44:11'),
(5069,2,'debit',NULL,2370000.0000,NULL,'2025-12-03 15:44:00',19,67170,49966,NULL,NULL,NULL,'2025-12-03 08:44:41','2025-12-03 08:44:41'),
(5070,2,'debit',NULL,11716461.0000,NULL,'2025-12-03 15:45:00',19,67245,49967,NULL,NULL,NULL,'2025-12-03 08:45:08','2025-12-03 08:45:08'),
(5071,2,'debit',NULL,9329150.0000,NULL,'2025-12-03 15:45:00',19,67841,49968,NULL,NULL,NULL,'2025-12-03 08:46:08','2025-12-03 08:46:08'),
(5072,2,'debit',NULL,13064756.0000,NULL,'2025-12-03 15:46:00',19,67873,49969,NULL,NULL,NULL,'2025-12-03 08:46:47','2025-12-03 08:46:47'),
(5073,2,'debit',NULL,132000.0000,NULL,'2025-12-03 15:47:00',19,67964,49970,NULL,NULL,NULL,'2025-12-03 08:47:13','2025-12-03 08:47:13'),
(5074,2,'debit',NULL,65000.0000,NULL,'2025-12-03 15:47:00',19,68017,49971,NULL,NULL,NULL,'2025-12-03 08:47:43','2025-12-03 08:47:43'),
(5075,2,'debit',NULL,870000.0000,NULL,'2025-12-03 15:48:00',19,68073,49972,NULL,NULL,NULL,'2025-12-03 08:48:23','2025-12-03 08:48:23'),
(5076,2,'debit',NULL,177000.0000,NULL,'2025-12-03 15:48:00',19,68074,49973,NULL,NULL,NULL,'2025-12-03 08:48:54','2025-12-03 08:48:54'),
(5077,2,'debit',NULL,798202.0000,NULL,'2025-12-03 15:49:00',19,68078,49974,NULL,NULL,NULL,'2025-12-03 08:49:26','2025-12-03 08:49:26'),
(5078,2,'debit',NULL,14536513.0000,NULL,'2025-12-03 15:49:00',19,68166,49975,NULL,NULL,NULL,'2025-12-03 08:49:55','2025-12-03 08:49:55'),
(5079,2,'debit',NULL,7830000.0000,NULL,'2025-12-03 15:50:00',19,68356,49976,NULL,NULL,NULL,'2025-12-03 08:50:28','2025-12-03 08:50:28'),
(5080,2,'debit',NULL,120000.0000,NULL,'2025-12-03 15:50:00',19,68716,49977,NULL,NULL,NULL,'2025-12-03 08:51:00','2025-12-03 08:51:00'),
(5081,2,'debit',NULL,27649500.0000,NULL,'2025-12-03 15:51:00',19,68766,49978,NULL,NULL,NULL,'2025-12-03 08:51:29','2025-12-03 08:51:29'),
(5082,2,'debit',NULL,4511640.0000,NULL,'2025-12-03 15:51:00',19,68866,49979,NULL,NULL,NULL,'2025-12-03 08:52:02','2025-12-03 08:52:02'),
(5083,2,'debit',NULL,10886595.0000,NULL,'2025-12-03 15:52:00',19,69002,49980,NULL,NULL,NULL,'2025-12-03 08:52:38','2025-12-03 08:52:38'),
(5084,2,'debit',NULL,410000.0000,NULL,'2025-12-03 15:53:00',19,69038,49981,NULL,NULL,NULL,'2025-12-03 08:53:18','2025-12-03 08:53:18'),
(5085,2,'debit',NULL,320000.0000,NULL,'2025-12-03 15:53:00',19,69328,49982,NULL,NULL,NULL,'2025-12-03 08:53:46','2025-12-03 08:53:46'),
(5086,2,'debit',NULL,39419000.0000,NULL,'2025-12-03 15:54:00',19,69504,49983,NULL,NULL,NULL,'2025-12-03 08:54:20','2025-12-03 08:54:20'),
(5087,2,'debit',NULL,11397950.0000,NULL,'2025-12-03 15:54:00',19,69538,49984,NULL,NULL,NULL,'2025-12-03 08:54:54','2025-12-03 08:54:54'),
(5088,2,'debit',NULL,7328000.0000,NULL,'2025-12-03 15:55:00',19,69635,49985,NULL,NULL,NULL,'2025-12-03 08:55:30','2025-12-03 08:55:30'),
(5089,2,'debit',NULL,16639985.0000,NULL,'2025-12-03 15:56:00',19,69659,49986,NULL,NULL,NULL,'2025-12-03 08:56:12','2025-12-03 08:56:12'),
(5090,2,'debit',NULL,1038500.0000,NULL,'2025-12-03 15:56:00',19,69808,49987,NULL,NULL,NULL,'2025-12-03 08:56:44','2025-12-03 08:56:44'),
(5091,2,'debit',NULL,838899.0000,NULL,'2025-12-03 15:57:00',19,69809,49988,NULL,NULL,NULL,'2025-12-03 08:57:30','2025-12-03 08:57:30'),
(5092,2,'debit',NULL,1061900.0000,NULL,'2025-12-03 15:58:00',19,69810,49989,NULL,NULL,NULL,'2025-12-03 08:58:12','2025-12-03 08:58:12'),
(5093,2,'debit',NULL,830800.0000,NULL,'2025-12-03 15:58:00',19,69811,49990,NULL,NULL,NULL,'2025-12-03 08:58:50','2025-12-03 08:58:50'),
(5094,2,'debit',NULL,828996.0000,NULL,'2025-12-03 15:59:00',19,69818,49991,NULL,NULL,NULL,'2025-12-03 08:59:36','2025-12-03 08:59:36'),
(5095,2,'debit',NULL,757500.0000,NULL,'2025-12-03 15:59:00',19,69962,49992,NULL,NULL,NULL,'2025-12-03 09:00:04','2025-12-03 09:00:04'),
(5096,2,'debit',NULL,230000.0000,NULL,'2025-12-03 16:00:00',19,70093,49993,NULL,NULL,NULL,'2025-12-03 09:00:33','2025-12-03 09:00:33'),
(5097,2,'debit',NULL,1307540.0000,NULL,'2025-12-03 16:01:00',19,70205,49994,NULL,NULL,NULL,'2025-12-03 09:01:11','2025-12-03 09:01:11'),
(5098,2,'debit',NULL,1423820.0000,NULL,'2025-12-03 16:02:00',19,72182,49995,NULL,NULL,NULL,'2025-12-03 09:02:43','2025-12-03 09:02:43'),
(5099,2,'debit',NULL,18287500.0000,NULL,'2025-12-03 16:03:00',19,67581,49996,NULL,NULL,NULL,'2025-12-03 09:03:38','2025-12-03 09:03:38'),
(5100,2,'debit',NULL,10712320.0000,NULL,'2025-12-03 16:06:00',19,64166,49997,NULL,NULL,NULL,'2025-12-03 09:06:33','2025-12-03 09:06:33'),
(5101,2,'credit',NULL,6080000.0000,NULL,'2025-12-03 17:39:43',143,72194,50003,NULL,NULL,NULL,'2025-12-03 10:45:02','2025-12-03 10:45:02'),
(5102,2,'credit',NULL,200000.0000,NULL,'2025-12-03 18:20:56',5,72146,50005,NULL,NULL,NULL,'2025-12-03 11:20:56','2025-12-03 11:20:56'),
(5103,2,'debit',NULL,459000.0000,NULL,'2025-12-03 18:30:00',146,72201,50008,NULL,NULL,NULL,'2025-12-03 11:41:48','2025-12-03 11:41:48'),
(5104,2,'credit',NULL,360000.0000,NULL,'2025-12-03 20:08:54',146,71745,50010,NULL,NULL,NULL,'2025-12-03 13:08:54','2025-12-03 13:14:34'),
(5105,2,'credit',NULL,916000.0000,NULL,'2025-12-03 20:16:38',146,72208,50013,NULL,NULL,NULL,'2025-12-03 13:16:38','2025-12-03 13:16:38'),
(5106,2,'credit',NULL,200000.0000,NULL,'2025-12-03 21:52:35',146,72193,50016,NULL,NULL,NULL,'2025-12-03 14:52:35','2025-12-03 14:52:35'),
(5107,2,'credit',NULL,5313000.0000,NULL,'2025-12-03 21:51:53',143,72215,50015,NULL,NULL,NULL,'2025-12-03 14:55:56','2025-12-03 14:55:56'),
(5108,2,'credit',NULL,237000.0000,NULL,'2025-12-04 16:55:13',19,72237,50035,NULL,NULL,NULL,'2025-12-04 16:55:13','2025-12-04 16:55:13'),
(5109,2,'debit',NULL,63000.0000,NULL,'2025-12-04 16:55:00',19,72239,50037,NULL,NULL,NULL,'2025-12-04 16:57:10','2025-12-04 16:57:10'),
(5110,2,'debit',NULL,580000.0000,NULL,'2025-12-04 17:30:00',106,72245,50043,NULL,NULL,NULL,'2025-12-04 17:31:23','2025-12-04 17:31:23'),
(5111,2,'debit',NULL,7750000.0000,NULL,'2025-12-04 17:52:00',146,72247,50046,NULL,NULL,NULL,'2025-12-04 17:56:44','2025-12-04 17:56:44'),
(5112,2,'credit',NULL,905000.0000,NULL,'2025-12-04 21:31:11',49,72004,50056,NULL,NULL,NULL,'2025-12-04 21:31:11','2025-12-04 21:31:11');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `account_types` VALUES
(2,'Bank Convensional',NULL,1,'2025-11-21 14:34:40','2025-11-21 14:34:40'),
(3,'Bank Online',NULL,1,'2025-11-21 14:34:54','2025-11-21 14:34:54');
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `accounting_account_types` VALUES
(1,'accounts_receivable',NULL,NULL,'asset','sub_type',NULL,NULL,0,NULL,NULL),
(2,'current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(3,'cash_and_cash_equivalents',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(4,'fixed_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(5,'non_current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(6,'accounts_payable',NULL,NULL,'liability','sub_type',NULL,NULL,0,NULL,NULL),
(7,'credit_card',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(8,'current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(9,'non_current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(10,'owners_equity',NULL,NULL,'equity','sub_type',NULL,NULL,1,NULL,NULL),
(11,'income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),
(12,'other_income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),
(13,'cost_of_sale',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(14,'expenses',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(15,'other_expense',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(16,'accounts_receivable',NULL,NULL,NULL,'detail_type',1,'',1,NULL,NULL),
(17,'allowance_for_bad_debts',NULL,NULL,NULL,'detail_type',2,'allowance_for_bad_debts_desc',1,NULL,NULL),
(18,'assets_available_for_sale',NULL,NULL,NULL,'detail_type',2,'assets_available_for_sale_desc',1,NULL,NULL),
(19,'development_costs',NULL,NULL,NULL,'detail_type',2,'development_costs_desc',1,NULL,NULL),
(20,'employee_cash_advances',NULL,NULL,NULL,'detail_type',2,'employee_cash_advances_desc',1,NULL,NULL),
(21,'inventory',NULL,NULL,NULL,'detail_type',2,'inventory_desc',1,NULL,NULL),
(22,'investments_-_other',NULL,NULL,NULL,'detail_type',2,'investments_-_other_desc',1,NULL,NULL),
(23,'loans_to_officers',NULL,NULL,NULL,'detail_type',2,'loans_to_officers_desc',1,NULL,NULL),
(24,'loans_to_others',NULL,NULL,NULL,'detail_type',2,'loans_to_others_desc',1,NULL,NULL),
(25,'loans_to_shareholders',NULL,NULL,NULL,'detail_type',2,'loans_to_shareholders_desc',1,NULL,NULL),
(26,'other_current_assets',NULL,NULL,NULL,'detail_type',2,'other_current_assets_desc',1,NULL,NULL),
(27,'prepaid_expenses',NULL,NULL,NULL,'detail_type',2,'prepaid_expenses_desc',1,NULL,NULL),
(28,'retainage',NULL,NULL,NULL,'detail_type',2,'retainage_desc',1,NULL,NULL),
(29,'undeposited_funds',NULL,NULL,NULL,'detail_type',2,'undeposited_funds_desc',1,NULL,NULL),
(30,'bank',NULL,NULL,NULL,'detail_type',3,'bank_desc',1,NULL,NULL),
(31,'cash_and_cash_equivalents',NULL,NULL,NULL,'detail_type',3,'cash_and_cash_equivalents_desc',1,NULL,NULL),
(32,'cash_on_hand',NULL,NULL,NULL,'detail_type',3,'cash_on_hand_desc',1,NULL,NULL),
(33,'client_trust_account',NULL,NULL,NULL,'detail_type',3,'client_trust_account_desc',1,NULL,NULL),
(34,'money_market',NULL,NULL,NULL,'detail_type',3,'money_market_desc',1,NULL,NULL),
(35,'rents_held_in_trust',NULL,NULL,NULL,'detail_type',3,'rents_held_in_trust_desc',1,NULL,NULL),
(36,'savings',NULL,NULL,NULL,'detail_type',3,'savings_desc',1,NULL,NULL),
(37,'accumulated_depletion',NULL,NULL,NULL,'detail_type',4,'accumulated_depletion_desc',1,NULL,NULL),
(38,'accumulated_depreciation_on_property,_plant_and_equipment',NULL,NULL,NULL,'detail_type',4,'accumulated_depreciation_on_property,_plant_and_equipment_desc',1,NULL,NULL),
(39,'buildings',NULL,NULL,NULL,'detail_type',4,'buildings_desc',1,NULL,NULL),
(40,'depletable_assets',NULL,NULL,NULL,'detail_type',4,'depletable_assets_desc',1,NULL,NULL),
(41,'furniture_and_fixtures',NULL,NULL,NULL,'detail_type',4,'furniture_and_fixtures_desc',1,NULL,NULL),
(42,'land',NULL,NULL,NULL,'detail_type',4,'land_desc',1,NULL,NULL),
(43,'leasehold_improvements',NULL,NULL,NULL,'detail_type',4,'leasehold_improvements_desc',1,NULL,NULL),
(44,'machinery_and_equipment',NULL,NULL,NULL,'detail_type',4,'machinery_and_equipment_desc',1,NULL,NULL),
(45,'other_fixed_assets',NULL,NULL,NULL,'detail_type',4,'other_fixed_assets_desc',1,NULL,NULL),
(46,'vehicles',NULL,NULL,NULL,'detail_type',4,'vehicles_desc',1,NULL,NULL),
(47,'accumulated_amortisation_of_non-current_assets',NULL,NULL,NULL,'detail_type',5,'accumulated_amortisation_of_non-current_assets_desc',1,NULL,NULL),
(48,'assets_held_for_sale',NULL,NULL,NULL,'detail_type',5,'assets_held_for_sale_desc',1,NULL,NULL),
(49,'deferred_tax',NULL,NULL,NULL,'detail_type',5,'deferred_tax_desc',1,NULL,NULL),
(50,'goodwill',NULL,NULL,NULL,'detail_type',5,'goodwill_desc',1,NULL,NULL),
(51,'intangible_assets',NULL,NULL,NULL,'detail_type',5,'intangible_assets_desc',1,NULL,NULL),
(52,'lease_buyout',NULL,NULL,NULL,'detail_type',5,'lease_buyout_desc',1,NULL,NULL),
(53,'licences',NULL,NULL,NULL,'detail_type',5,'licences_desc',1,NULL,NULL),
(54,'long-term_investments',NULL,NULL,NULL,'detail_type',5,'long-term_investments_desc',1,NULL,NULL),
(55,'organisational_costs',NULL,NULL,NULL,'detail_type',5,'organisational_costs_desc',1,NULL,NULL),
(56,'other_non-current_assets',NULL,NULL,NULL,'detail_type',5,'other_non-current_assets_desc',1,NULL,NULL),
(57,'security_deposits',NULL,NULL,NULL,'detail_type',5,'security_deposits_desc',1,NULL,NULL),
(58,'accounts_payable_(a/p)',NULL,NULL,NULL,'detail_type',6,'accounts_payable_(a/p)_desc',1,NULL,NULL),
(59,'credit_card',NULL,NULL,NULL,'detail_type',7,'credit_card_desc',1,NULL,NULL),
(60,'accrued_liabilities',NULL,NULL,NULL,'detail_type',8,'accrued_liabilities_desc',1,NULL,NULL),
(61,'client_trust_accounts_-_liabilities',NULL,NULL,NULL,'detail_type',8,'client_trust_accounts_-_liabilities_desc',1,NULL,NULL),
(62,'current_tax_liability',NULL,NULL,NULL,'detail_type',8,'current_tax_liability_desc',1,NULL,NULL),
(63,'current_portion_of_obligations_under_finance_leases',NULL,NULL,NULL,'detail_type',8,'current_portion_of_obligations_under_finance_leases_desc',1,NULL,NULL),
(64,'dividends_payable',NULL,NULL,NULL,'detail_type',8,'dividends_payable_desc',1,NULL,NULL),
(65,'income_tax_payable',NULL,NULL,NULL,'detail_type',8,'income_tax_payable_desc',1,NULL,NULL),
(66,'insurance_payable',NULL,NULL,NULL,'detail_type',8,'insurance_payable_desc',1,NULL,NULL),
(67,'line_of_credit',NULL,NULL,NULL,'detail_type',8,'line_of_credit_desc',1,NULL,NULL),
(68,'loan_payable',NULL,NULL,NULL,'detail_type',8,'loan_payable_desc',1,NULL,NULL),
(69,'other_current_liabilities',NULL,NULL,NULL,'detail_type',8,'other_current_liabilities_desc',1,NULL,NULL),
(70,'payroll_clearing',NULL,NULL,NULL,'detail_type',8,'payroll_clearing_desc',1,NULL,NULL),
(71,'payroll_liabilities',NULL,NULL,NULL,'detail_type',8,'payroll_liabilities_desc',1,NULL,NULL),
(72,'prepaid_expenses_payable',NULL,NULL,NULL,'detail_type',8,'prepaid_expenses_payable_desc',1,NULL,NULL),
(73,'rents_in_trust_-_liability',NULL,NULL,NULL,'detail_type',8,'rents_in_trust_-_liability_desc',1,NULL,NULL),
(74,'sales_and_service_tax_payable',NULL,NULL,NULL,'detail_type',8,'sales_and_service_tax_payable_desc',1,NULL,NULL),
(75,'accrued_holiday_payable',NULL,NULL,NULL,'detail_type',9,'accrued_holiday_payable_desc',1,NULL,NULL),
(76,'accrued_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'accrued_non-current_liabilities_desc',1,NULL,NULL),
(77,'liabilities_related_to_assets_held_for_sale',NULL,NULL,NULL,'detail_type',9,'liabilities_related_to_assets_held_for_sale_desc',1,NULL,NULL),
(78,'long-term_debt',NULL,NULL,NULL,'detail_type',9,'long-term_debt_desc',1,NULL,NULL),
(79,'notes_payable',NULL,NULL,NULL,'detail_type',9,'notes_payable_desc',1,NULL,NULL),
(80,'other_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'other_non-current_liabilities_desc',1,NULL,NULL),
(81,'shareholder_notes_payable',NULL,NULL,NULL,'detail_type',9,'shareholder_notes_payable_desc',1,NULL,NULL),
(82,'accumulated_adjustment',NULL,NULL,NULL,'detail_type',10,'accumulated_adjustment_desc',1,NULL,NULL),
(83,'dividend_disbursed',NULL,NULL,NULL,'detail_type',10,'dividend_disbursed_desc',1,NULL,NULL),
(84,'equity_in_earnings_of_subsidiaries',NULL,NULL,NULL,'detail_type',10,'equity_in_earnings_of_subsidiaries_desc',1,NULL,NULL),
(85,'opening_balance_equity',NULL,NULL,NULL,'detail_type',10,'opening_balance_equity_desc',1,NULL,NULL),
(86,'ordinary_shares',NULL,NULL,NULL,'detail_type',10,'ordinary_shares_desc',1,NULL,NULL),
(87,'other_comprehensive_income',NULL,NULL,NULL,'detail_type',10,'other_comprehensive_income_desc',1,NULL,NULL),
(88,'owner\'s_equity',NULL,NULL,NULL,'detail_type',10,'owner\'s_equity_desc',1,NULL,NULL),
(89,'paid-in_capital_or_surplus',NULL,NULL,NULL,'detail_type',10,'paid-in_capital_or_surplus_desc',1,NULL,NULL),
(90,'partner_contributions',NULL,NULL,NULL,'detail_type',10,'partner_contributions_desc',1,NULL,NULL),
(91,'partner_distributions',NULL,NULL,NULL,'detail_type',10,'partner_distributions_desc',1,NULL,NULL),
(92,'partner\'s_equity',NULL,NULL,NULL,'detail_type',10,'partner\'s_equity_desc',1,NULL,NULL),
(93,'preferred_shares',NULL,NULL,NULL,'detail_type',10,'preferred_shares_desc',1,NULL,NULL),
(94,'retained_earnings',NULL,NULL,NULL,'detail_type',10,'retained_earnings_desc',1,NULL,NULL),
(95,'share_capital',NULL,NULL,NULL,'detail_type',10,'share_capital_desc',1,NULL,NULL),
(96,'treasury_shares',NULL,NULL,NULL,'detail_type',10,'treasury_shares_desc',1,NULL,NULL),
(97,'discounts/refunds_given',NULL,NULL,NULL,'detail_type',11,'discounts/refunds_given_desc',1,NULL,NULL),
(98,'non-profit_income',NULL,NULL,NULL,'detail_type',11,'non-profit_income_desc',1,NULL,NULL),
(99,'other_primary_income',NULL,NULL,NULL,'detail_type',11,'other_primary_income_desc',1,NULL,NULL),
(100,'revenue_-_general',NULL,NULL,NULL,'detail_type',11,'revenue_-_general_desc',1,NULL,NULL),
(101,'sales_-_retail',NULL,NULL,NULL,'detail_type',11,'sales_-_retail_desc',1,NULL,NULL),
(102,'sales_-_wholesale',NULL,NULL,NULL,'detail_type',11,'sales_-_wholesale_desc',1,NULL,NULL),
(103,'sales_of_product_income',NULL,NULL,NULL,'detail_type',11,'sales_of_product_income_desc',1,NULL,NULL),
(104,'service/fee_income',NULL,NULL,NULL,'detail_type',11,'service/fee_income_desc',1,NULL,NULL),
(105,'unapplied_cash_payment_income',NULL,NULL,NULL,'detail_type',11,'unapplied_cash_payment_income_desc',1,NULL,NULL),
(106,'dividend_income',NULL,NULL,NULL,'detail_type',12,'dividend_income_desc',1,NULL,NULL),
(107,'interest_earned',NULL,NULL,NULL,'detail_type',12,'interest_earned_desc',1,NULL,NULL),
(108,'loss_on_disposal_of_assets',NULL,NULL,NULL,'detail_type',12,'loss_on_disposal_of_assets_desc',1,NULL,NULL),
(109,'other_investment_income',NULL,NULL,NULL,'detail_type',12,'other_investment_income_desc',1,NULL,NULL),
(110,'other_miscellaneous_income',NULL,NULL,NULL,'detail_type',12,'other_miscellaneous_income_desc',1,NULL,NULL),
(111,'other_operating_income',NULL,NULL,NULL,'detail_type',12,'other_operating_income_desc',1,NULL,NULL),
(112,'tax-exempt_interest',NULL,NULL,NULL,'detail_type',12,'tax-exempt_interest_desc',1,NULL,NULL),
(113,'unrealised_loss_on_securities,_net_of_tax',NULL,NULL,NULL,'detail_type',12,'unrealised_loss_on_securities,_net_of_tax_desc',1,NULL,NULL),
(114,'cost_of_labour_-_cos',NULL,NULL,NULL,'detail_type',13,'cost_of_labour_-_cos_desc',1,NULL,NULL),
(115,'equipment_rental_-_cos',NULL,NULL,NULL,'detail_type',13,'equipment_rental_-_cos_desc',1,NULL,NULL),
(116,'freight_and_delivery_-_cos',NULL,NULL,NULL,'detail_type',13,'freight_and_delivery_-_cos_desc',1,NULL,NULL),
(117,'other_costs_of_sales_-_cos',NULL,NULL,NULL,'detail_type',13,'other_costs_of_sales_-_cos_desc',1,NULL,NULL),
(118,'supplies_and_materials_-_cos',NULL,NULL,NULL,'detail_type',13,'supplies_and_materials_-_cos_desc',1,NULL,NULL),
(119,'advertising/promotional',NULL,NULL,NULL,'detail_type',14,'advertising/promotional_desc',1,NULL,NULL),
(120,'amortisation_expense',NULL,NULL,NULL,'detail_type',14,'amortisation_expense_desc',1,NULL,NULL),
(121,'auto',NULL,NULL,NULL,'detail_type',14,'auto_desc',1,NULL,NULL),
(122,'bad_debts',NULL,NULL,NULL,'detail_type',14,'bad_debts_desc',1,NULL,NULL),
(123,'bank_charges',NULL,NULL,NULL,'detail_type',14,'bank_charges_desc',1,NULL,NULL),
(124,'charitable_contributions',NULL,NULL,NULL,'detail_type',14,'charitable_contributions_desc',1,NULL,NULL),
(125,'commissions_and_fees',NULL,NULL,NULL,'detail_type',14,'commissions_and_fees_desc',1,NULL,NULL),
(126,'cost_of_labour',NULL,NULL,NULL,'detail_type',14,'cost_of_labour_desc',1,NULL,NULL),
(127,'dues_and_subscriptions',NULL,NULL,NULL,'detail_type',14,'dues_and_subscriptions_desc',1,NULL,NULL),
(128,'equipment_rental',NULL,NULL,NULL,'detail_type',14,'equipment_rental_desc',1,NULL,NULL),
(129,'finance_costs',NULL,NULL,NULL,'detail_type',14,'finance_costs_desc',1,NULL,NULL),
(130,'income_tax_expense',NULL,NULL,NULL,'detail_type',14,'income_tax_expense_desc',1,NULL,NULL),
(131,'insurance',NULL,NULL,NULL,'detail_type',14,'insurance_desc',1,NULL,NULL),
(132,'interest_paid',NULL,NULL,NULL,'detail_type',14,'interest_paid_desc',1,NULL,NULL),
(133,'legal_and_professional_fees',NULL,NULL,NULL,'detail_type',14,'legal_and_professional_fees_desc',1,NULL,NULL),
(134,'loss_on_discontinued_operations,_net_of_tax',NULL,NULL,NULL,'detail_type',14,'loss_on_discontinued_operations,_net_of_tax_desc',1,NULL,NULL),
(135,'management_compensation',NULL,NULL,NULL,'detail_type',14,'management_compensation_desc',1,NULL,NULL),
(136,'meals_and_entertainment',NULL,NULL,NULL,'detail_type',14,'meals_and_entertainment_desc',1,NULL,NULL),
(137,'office/general_administrative_expenses',NULL,NULL,NULL,'detail_type',14,'office/general_administrative_expenses_desc',1,NULL,NULL),
(138,'other_miscellaneous_service_cost',NULL,NULL,NULL,'detail_type',14,'other_miscellaneous_service_cost_desc',1,NULL,NULL),
(139,'other_selling_expenses',NULL,NULL,NULL,'detail_type',14,'other_selling_expenses_desc',1,NULL,NULL),
(140,'payroll_expenses',NULL,NULL,NULL,'detail_type',14,'payroll_expenses_desc',1,NULL,NULL),
(141,'rent_or_lease_of_buildings',NULL,NULL,NULL,'detail_type',14,'rent_or_lease_of_buildings_desc',1,NULL,NULL),
(142,'repair_and_maintenance',NULL,NULL,NULL,'detail_type',14,'repair_and_maintenance_desc',1,NULL,NULL),
(143,'shipping_and_delivery_expense',NULL,NULL,NULL,'detail_type',14,'shipping_and_delivery_expense_desc',1,NULL,NULL),
(144,'supplies_and_materials',NULL,NULL,NULL,'detail_type',14,'supplies_and_materials_desc',1,NULL,NULL),
(145,'taxes_paid',NULL,NULL,NULL,'detail_type',14,'taxes_paid_desc',1,NULL,NULL),
(146,'travel_expenses_-_general_and_admin_expenses',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_general_and_admin_expenses_desc',1,NULL,NULL),
(147,'travel_expenses_-_selling_expense',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_selling_expense_desc',1,NULL,NULL),
(148,'unapplied_cash_bill_payment_expense',NULL,NULL,NULL,'detail_type',14,'unapplied_cash_bill_payment_expense_desc',1,NULL,NULL),
(149,'utilities',NULL,NULL,NULL,'detail_type',14,'utilities_desc',1,NULL,NULL),
(150,'amortisation',NULL,NULL,NULL,'detail_type',15,'amortisation_desc',1,NULL,NULL),
(151,'depreciation',NULL,NULL,NULL,'detail_type',15,'depreciation_desc',1,NULL,NULL),
(152,'exchange_gain_or_loss',NULL,NULL,NULL,'detail_type',15,'exchange_gain_or_loss_desc',1,NULL,NULL),
(153,'other_expense',NULL,NULL,NULL,'detail_type',15,'other_expense_desc',1,NULL,NULL),
(154,'penalties_and_settlements',NULL,NULL,NULL,'detail_type',15,'penalties_and_settlements_desc',1,NULL,NULL);
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `accounts` VALUES
(1,1,'Dedy Priadi','0400831178','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,NULL,1,1,NULL,'2023-06-06 08:27:03','2024-05-15 15:15:27'),
(2,1,'Bank BNI A/n Dedy Priadi','0400831178','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',2,NULL,1,0,NULL,'2024-05-15 15:30:23','2025-11-21 14:38:19'),
(3,1,'Shopee Pay','085173070949','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,1,0,NULL,'2025-11-21 14:38:00','2025-11-21 14:38:00'),
(4,1,'Dana','085173070949','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,1,0,NULL,'2025-11-21 14:43:11','2025-11-21 14:43:11');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
commit;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=222892 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `activity_log` VALUES
(1,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-17 17:09:00','2023-07-17 17:09:00'),
(2,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-17 17:09:00','2023-07-17 17:09:00'),
(3,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 03:14:00','2023-07-18 03:14:00'),
(4,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 05:27:00','2023-07-18 05:27:00'),
(5,'default','added',7007,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 05:29:00','2023-07-18 05:29:00'),
(6,'default','added',7008,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 05:31:00','2023-07-18 05:31:00'),
(7,'default','added',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":672000}}',NULL,'2023-07-18 05:39:00','2023-07-18 05:39:00'),
(8,'default','added',1692,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30000}}',NULL,'2023-07-18 05:44:00','2023-07-18 05:44:00'),
(9,'default','edited',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":197000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"672000.0000\"}}',NULL,'2023-07-18 06:01:00','2023-07-18 06:01:00'),
(10,'default','sell_deleted',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1691,\"invoice_no\":\"CCM-MTP-2023-00001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"197000.0000\"}}',NULL,'2023-07-18 06:03:00','2023-07-18 06:03:00'),
(11,'default','added',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":197000}}',NULL,'2023-07-18 06:03:00','2023-07-18 06:03:00'),
(12,'default','added',1694,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325000}}',NULL,'2023-07-18 06:04:00','2023-07-18 06:04:00'),
(13,'default','edited',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"197000.0000\"}}',NULL,'2023-07-18 06:40:00','2023-07-18 06:40:00'),
(14,'default','sell_deleted',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1693,\"invoice_no\":\"CCM-MTP-2023-00003\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2023-07-18 06:41:00','2023-07-18 06:41:00'),
(15,'default','edited',1694,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":422000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"325000.0000\"}}',NULL,'2023-07-18 06:41:00','2023-07-18 06:41:00'),
(16,'default','added',1695,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2023-07-18 06:42:00','2023-07-18 06:42:00'),
(17,'default','sell_deleted',1694,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1694,\"invoice_no\":\"CCM-MTP-2023-00004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"422000.0000\"}}',NULL,'2023-07-18 06:48:00','2023-07-18 06:48:00'),
(18,'default','sell_deleted',1695,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1695,\"invoice_no\":\"CCM-MTP-2023-00005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2023-07-18 06:48:00','2023-07-18 06:48:00'),
(19,'default','added',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97000}}',NULL,'2023-07-18 06:48:00','2023-07-18 06:48:00'),
(20,'default','added',1697,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":575000}}',NULL,'2023-07-18 06:48:00','2023-07-18 06:48:00'),
(21,'default','edited',1697,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"575000.0000\"}}',NULL,'2023-07-18 06:49:00','2023-07-18 06:49:00'),
(22,'default','sell_deleted',1697,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1697,\"invoice_no\":\"CCM-MTP-2023-00007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"425000.0000\"}}',NULL,'2023-07-18 06:49:00','2023-07-18 06:49:00'),
(23,'default','added',1698,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425000}}',NULL,'2023-07-18 06:50:00','2023-07-18 06:50:00'),
(24,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-18 07:03:00','2023-07-18 07:03:00'),
(25,'default','added',7009,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 07:18:00','2023-07-18 07:18:00'),
(26,'default','added',1700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25000}}',NULL,'2023-07-18 07:18:00','2023-07-18 07:18:00'),
(27,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 08:41:00','2023-07-18 08:41:00'),
(28,'default','added',1701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-19 08:34:00','2023-07-19 08:34:00'),
(29,'default','added',7010,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 08:34:00','2023-07-19 08:34:00'),
(30,'default','edited',1701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-19 08:34:00','2023-07-19 08:34:00'),
(31,'default','added',1703,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":93000}}',NULL,'2023-07-19 08:39:00','2023-07-19 08:39:00'),
(32,'default','edited',1701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-19 10:51:00','2023-07-19 10:51:00'),
(33,'default','edited',1701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-19 10:55:00','2023-07-19 10:55:00'),
(34,'default','edited',1701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-19 10:56:00','2023-07-19 10:56:00'),
(35,'default','added',1705,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195000}}',NULL,'2023-07-19 10:59:00','2023-07-19 10:59:00'),
(36,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 13:08:00','2023-07-19 13:08:00'),
(37,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 15:23:00','2023-07-19 15:23:00'),
(38,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-20 06:49:00','2023-07-20 06:49:00'),
(39,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-20 06:49:00','2023-07-20 06:49:00'),
(40,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-21 08:39:00','2023-07-21 08:39:00'),
(41,'default','added',7011,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-21 12:12:00','2023-07-21 12:12:00'),
(42,'default','added',1708,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":436000}}',NULL,'2023-07-21 12:12:00','2023-07-21 12:12:00'),
(43,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-22 02:17:00','2023-07-22 02:17:00'),
(44,'default','added',7012,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-22 02:20:00','2023-07-22 02:20:00'),
(45,'default','added',1709,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-22 02:55:00','2023-07-22 02:55:00'),
(46,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-22 04:28:00','2023-07-22 04:28:00'),
(47,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-22 06:20:00','2023-07-22 06:20:00'),
(48,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-22 15:00:00','2023-07-22 15:00:00'),
(49,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-24 05:11:00','2023-07-24 05:11:00'),
(50,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-24 05:57:00','2023-07-24 05:57:00'),
(51,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-24 06:12:00','2023-07-24 06:12:00'),
(52,'default','added',1710,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-07-24 06:20:00','2023-07-24 06:20:00'),
(53,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-24 06:22:00','2023-07-24 06:22:00'),
(54,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-24 06:24:00','2023-07-24 06:24:00'),
(55,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-24 06:28:00','2023-07-24 06:28:00'),
(56,'default','logout',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-24 07:05:00','2023-07-24 07:05:00'),
(57,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2023-07-24 07:05:00','2023-07-24 07:05:00'),
(58,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-24 07:32:00','2023-07-24 07:32:00'),
(59,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-24 13:40:00','2023-07-24 13:40:00'),
(60,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-25 02:08:00','2023-07-25 02:08:00'),
(61,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-25 02:43:00','2023-07-25 02:43:00'),
(62,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-25 03:22:00','2023-07-25 03:22:00'),
(63,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-26 02:33:00','2023-07-26 02:33:00'),
(64,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-26 17:04:00','2023-07-26 17:04:00'),
(65,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-27 01:18:00','2023-07-27 01:18:00'),
(66,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-27 01:20:00','2023-07-27 01:20:00'),
(67,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-27 01:31:00','2023-07-27 01:31:00'),
(68,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-27 01:33:00','2023-07-27 01:33:00'),
(69,'default','added',1711,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18000}}',NULL,'2023-07-27 01:39:00','2023-07-27 01:39:00'),
(70,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 01:48:00','2023-07-27 01:48:00'),
(71,'default','added',7013,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-27 01:57:00','2023-07-27 01:57:00'),
(72,'default','added',1712,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11720000}}',NULL,'2023-07-27 02:20:00','2023-07-27 02:20:00'),
(73,'default','added',1713,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34117000}}',NULL,'2023-07-27 02:25:00','2023-07-27 02:25:00'),
(74,'default','added',1714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29322000}}',NULL,'2023-07-27 02:29:00','2023-07-27 02:29:00'),
(75,'default','added',1715,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13438000}}',NULL,'2023-07-27 02:33:00','2023-07-27 02:33:00'),
(76,'default','added',1716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4694500}}',NULL,'2023-07-27 02:50:00','2023-07-27 02:50:00'),
(77,'default','added',7014,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-27 02:59:00','2023-07-27 02:59:00'),
(78,'default','added',1718,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-27 03:04:00','2023-07-27 03:04:00'),
(79,'default','added',1719,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7498000}}',NULL,'2023-07-27 03:12:00','2023-07-27 03:12:00'),
(80,'default','added',1722,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1103000}}',NULL,'2023-07-27 03:16:00','2023-07-27 03:16:00'),
(81,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-27 06:16:00','2023-07-27 06:16:00'),
(82,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 06:50:00','2023-07-27 06:50:00'),
(83,'default','status_changed',1701,'App\\Transaction',NULL,NULL,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-27 06:51:00','2023-07-27 06:51:00'),
(84,'default','status_changed',1709,'App\\Transaction',NULL,NULL,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-27 06:52:00','2023-07-27 06:52:00'),
(85,'default','added',7015,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 06:58:00','2023-07-27 06:58:00'),
(86,'default','added',1723,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-27 07:01:00','2023-07-27 07:01:00'),
(87,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 07:41:00','2023-07-27 07:41:00'),
(88,'default','added',1724,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-27 07:48:00','2023-07-27 07:48:00'),
(89,'default','added',7016,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 07:50:00','2023-07-27 07:50:00'),
(90,'default','edited',1724,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-27 07:53:00','2023-07-27 07:53:00'),
(91,'default','edited',1724,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-27 07:55:00','2023-07-27 07:55:00'),
(92,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-27 10:25:00','2023-07-27 10:25:00'),
(93,'default','added',1725,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70000}}',NULL,'2023-07-27 10:30:00','2023-07-27 10:30:00'),
(94,'default','added',1726,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":415000}}',NULL,'2023-07-27 10:32:00','2023-07-27 10:32:00'),
(95,'default','added',1727,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":176000}}',NULL,'2023-07-27 10:33:00','2023-07-27 10:33:00'),
(96,'default','added',1728,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16000}}',NULL,'2023-07-27 10:33:00','2023-07-27 10:33:00'),
(97,'default','added',1729,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":349000}}',NULL,'2023-07-27 10:36:00','2023-07-27 10:36:00'),
(98,'default','added',1730,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3472000}}',NULL,'2023-07-27 10:37:00','2023-07-27 10:37:00'),
(99,'default','added',1731,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":845000}}',NULL,'2023-07-27 10:37:00','2023-07-27 10:37:00'),
(100,'default','added',1732,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":288000}}',NULL,'2023-07-27 10:38:00','2023-07-27 10:38:00'),
(101,'default','added',1733,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59000}}',NULL,'2023-07-27 10:38:00','2023-07-27 10:38:00'),
(102,'default','added',1734,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1544000}}',NULL,'2023-07-27 10:39:00','2023-07-27 10:39:00'),
(103,'default','added',1735,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":138000}}',NULL,'2023-07-27 10:40:00','2023-07-27 10:40:00'),
(104,'default','added',1736,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1190000}}',NULL,'2023-07-27 10:41:00','2023-07-27 10:41:00'),
(105,'default','added',1737,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":530000}}',NULL,'2023-07-27 10:41:00','2023-07-27 10:41:00'),
(106,'default','added',1738,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21000}}',NULL,'2023-07-27 10:42:00','2023-07-27 10:42:00'),
(107,'default','added',1739,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":107000}}',NULL,'2023-07-27 10:42:00','2023-07-27 10:42:00'),
(108,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 01:17:00','2023-07-28 01:17:00'),
(109,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 01:19:00','2023-07-28 01:19:00'),
(110,'default','added',1740,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-28 01:38:00','2023-07-28 01:38:00'),
(111,'default','added',1741,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-28 01:40:00','2023-07-28 01:40:00'),
(112,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 01:51:00','2023-07-28 01:51:00'),
(113,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 01:51:00','2023-07-28 01:51:00'),
(114,'default','added',1742,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-28 01:55:00','2023-07-28 01:55:00'),
(115,'default','edited',1742,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}',NULL,'2023-07-28 01:56:00','2023-07-28 01:56:00'),
(116,'default','added',7017,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 01:59:00','2023-07-28 01:59:00'),
(117,'default','added',1743,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":489000}}',NULL,'2023-07-28 02:01:00','2023-07-28 02:01:00'),
(118,'default','added',7018,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 02:28:00','2023-07-28 02:28:00'),
(119,'default','added',1744,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3680000}}',NULL,'2023-07-28 02:30:00','2023-07-28 02:30:00'),
(120,'default','added',7019,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 03:19:00','2023-07-28 03:19:00'),
(121,'default','added',1745,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 03:21:00','2023-07-28 03:21:00'),
(122,'default','added',7020,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 03:25:00','2023-07-28 03:25:00'),
(123,'default','edited',1745,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 03:46:00','2023-07-28 03:46:00'),
(124,'default','added',7021,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 04:32:00','2023-07-28 04:32:00'),
(125,'default','added',1746,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95000}}',NULL,'2023-07-28 04:35:00','2023-07-28 04:35:00'),
(126,'default','edited',1718,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 05:00:00','2023-07-28 05:00:00'),
(127,'default','edited',1719,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7498000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7498000.0000\"}}',NULL,'2023-07-28 05:14:00','2023-07-28 05:14:00'),
(128,'default','edited',1715,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13438000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13438000.0000\"}}',NULL,'2023-07-28 05:15:00','2023-07-28 05:15:00'),
(129,'default','edited',1713,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34117000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"34117000.0000\"}}',NULL,'2023-07-28 05:17:00','2023-07-28 05:17:00'),
(130,'default','edited',1712,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11720000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11720000.0000\"}}',NULL,'2023-07-28 05:18:00','2023-07-28 05:18:00'),
(131,'default','edited',1714,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29322000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"29322000.0000\"}}',NULL,'2023-07-28 05:18:00','2023-07-28 05:18:00'),
(132,'default','edited',1716,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4694500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4694500.0000\"}}',NULL,'2023-07-28 05:19:00','2023-07-28 05:19:00'),
(133,'default','edited',1722,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1103000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1103000.0000\"}}',NULL,'2023-07-28 05:20:00','2023-07-28 05:20:00'),
(134,'default','edited',6363,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-28 05:38:00','2023-07-28 05:38:00'),
(135,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 06:07:00','2023-07-28 06:07:00'),
(136,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 06:07:00','2023-07-28 06:07:00'),
(137,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-28 06:17:00','2023-07-28 06:17:00'),
(138,'default','added',7022,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 06:20:00','2023-07-28 06:20:00'),
(139,'default','added',1762,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155000}}',NULL,'2023-07-28 06:21:00','2023-07-28 06:21:00'),
(140,'default','added',7023,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 06:34:00','2023-07-28 06:34:00'),
(141,'default','added',1766,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26000}}',NULL,'2023-07-28 06:34:00','2023-07-28 06:34:00'),
(142,'default','edited',1766,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"26000.0000\"}}',NULL,'2023-07-28 06:35:00','2023-07-28 06:35:00'),
(143,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 06:47:00','2023-07-28 06:47:00'),
(144,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 06:47:00','2023-07-28 06:47:00'),
(145,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 06:48:00','2023-07-28 06:48:00'),
(146,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 06:50:00','2023-07-28 06:50:00'),
(147,'default','added',1767,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50000}}',NULL,'2023-07-28 06:55:00','2023-07-28 06:55:00'),
(148,'default','added',7024,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 07:21:00','2023-07-28 07:21:00'),
(149,'default','added',7025,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 07:21:00','2023-07-28 07:21:00'),
(150,'default','added',7026,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 07:24:00','2023-07-28 07:24:00'),
(151,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 07:59:00','2023-07-28 07:59:00'),
(152,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-28 07:59:00','2023-07-28 07:59:00'),
(153,'default','added',1768,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 08:01:00','2023-07-28 08:01:00'),
(154,'default','added',1769,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 08:01:00','2023-07-28 08:01:00'),
(155,'default','added',1770,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 08:03:00','2023-07-28 08:03:00'),
(156,'default','added',1772,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 08:05:00','2023-07-28 08:05:00'),
(157,'default','added',7027,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 08:06:00','2023-07-28 08:06:00'),
(158,'default','added',1773,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 08:07:00','2023-07-28 08:07:00'),
(159,'default','sell_deleted',1769,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1769,\"invoice_no\":\"WTC-LU-2023-00102\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 08:10:00','2023-07-28 08:10:00'),
(160,'default','edited',7026,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 08:11:00','2023-07-28 08:11:00'),
(161,'default','edited',7027,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 08:13:00','2023-07-28 08:13:00'),
(162,'default','added',7028,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 08:19:00','2023-07-28 08:19:00'),
(163,'default','added',1777,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":487000}}',NULL,'2023-07-28 08:19:00','2023-07-28 08:19:00'),
(164,'default','edited',3711,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 08:26:00','2023-07-28 08:26:00'),
(165,'default','added',1783,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 08:30:00','2023-07-28 08:30:00'),
(166,'default','added',7029,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 08:42:00','2023-07-28 08:42:00'),
(167,'default','edited',7029,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 08:43:00','2023-07-28 08:43:00'),
(168,'default','added',1787,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":402000}}',NULL,'2023-07-28 08:44:00','2023-07-28 08:44:00'),
(169,'default','added',7030,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 08:46:00','2023-07-28 08:46:00'),
(170,'default','added',1788,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":281000}}',NULL,'2023-07-28 08:47:00','2023-07-28 08:47:00'),
(171,'default','added',1789,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425000}}',NULL,'2023-07-28 08:47:00','2023-07-28 08:47:00'),
(172,'default','edited',1788,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":281000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"281000.0000\"}}',NULL,'2023-07-28 08:53:00','2023-07-28 08:53:00'),
(173,'default','edited',1788,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":281000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"281000.0000\"}}',NULL,'2023-07-28 09:06:00','2023-07-28 09:06:00'),
(174,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-28 09:10:00','2023-07-28 09:10:00'),
(175,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 09:11:00','2023-07-28 09:11:00'),
(176,'default','added',7031,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 09:11:00','2023-07-28 09:11:00'),
(177,'default','added',1793,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425000}}',NULL,'2023-07-28 09:15:00','2023-07-28 09:15:00'),
(178,'default','edited',1773,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 09:32:00','2023-07-28 09:32:00'),
(179,'default','edited',1768,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 09:33:00','2023-07-28 09:33:00'),
(180,'default','edited',1724,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 09:35:00','2023-07-28 09:35:00'),
(181,'default','edited',2042,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 09:43:00','2023-07-28 09:43:00'),
(182,'default','edited',6363,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 09:58:00','2023-07-28 09:58:00'),
(183,'default','added',1796,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":217000}}',NULL,'2023-07-28 10:12:00','2023-07-28 10:12:00'),
(184,'default','added',1799,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14849000}}',NULL,'2023-07-28 10:27:00','2023-07-28 10:27:00'),
(185,'default','edited',1787,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":402000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"402000.0000\"}}',NULL,'2023-07-28 10:28:00','2023-07-28 10:28:00'),
(186,'default','edited',1789,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"425000.0000\"}}',NULL,'2023-07-28 10:28:00','2023-07-28 10:28:00'),
(187,'default','added',1800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 11:13:00','2023-07-28 11:13:00'),
(188,'default','added',7032,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 11:21:00','2023-07-28 11:21:00'),
(189,'default','added',1801,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 11:22:00','2023-07-28 11:22:00'),
(190,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-28 11:30:00','2023-07-28 11:30:00'),
(191,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 11:31:00','2023-07-28 11:31:00'),
(192,'default','added',1802,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 11:34:00','2023-07-28 11:34:00'),
(193,'default','status_changed',1745,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":null,\"updated_status\":\"Proses Service\"}',NULL,'2023-07-28 11:35:00','2023-07-28 11:35:00'),
(194,'default','status_changed',1772,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":null,\"updated_status\":\"Proses Service\"}',NULL,'2023-07-28 11:35:00','2023-07-28 11:35:00'),
(195,'default','edited',1773,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 11:36:00','2023-07-28 11:36:00'),
(196,'default','added',1803,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49000}}',NULL,'2023-07-28 11:47:00','2023-07-28 11:47:00'),
(197,'default','added',7033,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 11:56:00','2023-07-28 11:56:00'),
(198,'default','added',1804,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":138000}}',NULL,'2023-07-28 11:56:00','2023-07-28 11:56:00'),
(199,'default','added',1807,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":465000}}',NULL,'2023-07-28 12:01:00','2023-07-28 12:01:00'),
(200,'default','added',1808,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":185000}}',NULL,'2023-07-28 12:08:00','2023-07-28 12:08:00'),
(201,'default','added',1809,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":487000}}',NULL,'2023-07-28 12:08:00','2023-07-28 12:08:00'),
(202,'default','added',1810,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21000}}',NULL,'2023-07-28 12:08:00','2023-07-28 12:08:00'),
(203,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 12:10:00','2023-07-28 12:10:00'),
(204,'default','edited',1799,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14849000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14849000.0000\"}}',NULL,'2023-07-28 12:11:00','2023-07-28 12:11:00'),
(205,'default','payment_edited',1799,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14849000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14849000.0000\"}}',NULL,'2023-07-28 12:12:00','2023-07-28 12:12:00'),
(206,'default','added',7034,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 12:33:00','2023-07-28 12:33:00'),
(207,'default','added',1811,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":536000}}',NULL,'2023-07-28 12:33:00','2023-07-28 12:33:00'),
(208,'default','added',7035,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 12:38:00','2023-07-28 12:38:00'),
(209,'default','added',1812,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-28 12:40:00','2023-07-28 12:40:00'),
(210,'default','edited',1812,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 12:41:00','2023-07-28 12:41:00'),
(211,'default','added',7036,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 12:56:00','2023-07-28 12:56:00'),
(212,'default','edited',7036,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 13:02:00','2023-07-28 13:02:00'),
(213,'default','edited',7036,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 13:02:00','2023-07-28 13:02:00'),
(214,'default','edited',7036,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 13:11:00','2023-07-28 13:11:00'),
(215,'default','added',1813,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":369000}}',NULL,'2023-07-28 13:11:00','2023-07-28 13:11:00'),
(216,'default','sell_deleted',1809,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1809,\"invoice_no\":\"WTC-LU-2023-00121\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"487000.0000\"}}',NULL,'2023-07-28 13:20:00','2023-07-28 13:20:00'),
(217,'default','added',1815,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":105000}}',NULL,'2023-07-28 13:43:00','2023-07-28 13:43:00'),
(218,'default','sell_deleted',1767,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1767,\"invoice_no\":\"WTC-LU-2023-00100\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50000.0000\"}}',NULL,'2023-07-28 14:08:00','2023-07-28 14:08:00'),
(219,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 14:17:00','2023-07-28 14:17:00'),
(220,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 14:17:00','2023-07-28 14:17:00'),
(221,'default','added',7037,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-28 14:21:00','2023-07-28 14:21:00'),
(222,'default','added',1816,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195000}}',NULL,'2023-07-28 14:27:00','2023-07-28 14:27:00'),
(223,'default','edited',1808,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"185000.0000\"}}',NULL,'2023-07-28 14:44:00','2023-07-28 14:44:00'),
(224,'default','payment_edited',1808,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"370000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"370000.0000\"}}',NULL,'2023-07-28 14:50:00','2023-07-28 14:50:00'),
(225,'default','status_changed',1816,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-28 14:52:00','2023-07-28 14:52:00'),
(226,'default','edited',1812,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-28 14:56:00','2023-07-28 14:56:00'),
(227,'default','status_changed',1812,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-28 14:56:00','2023-07-28 14:56:00'),
(228,'default','edited',1804,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":138000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"138000.0000\"}}',NULL,'2023-07-28 15:05:00','2023-07-28 15:05:00'),
(229,'default','added',1817,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000}}',NULL,'2023-07-28 15:19:00','2023-07-28 15:19:00'),
(230,'default','added',1818,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120000}}',NULL,'2023-07-28 15:20:00','2023-07-28 15:20:00'),
(231,'default','added',1819,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000}}',NULL,'2023-07-28 15:21:00','2023-07-28 15:21:00'),
(232,'default','added',1820,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200000}}',NULL,'2023-07-28 15:22:00','2023-07-28 15:22:00'),
(233,'default','added',1821,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50000}}',NULL,'2023-07-28 15:23:00','2023-07-28 15:23:00'),
(234,'default','added',1822,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250000}}',NULL,'2023-07-28 15:24:00','2023-07-28 15:24:00'),
(235,'default','added',1823,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-28 15:26:00','2023-07-28 15:26:00'),
(236,'default','edited',1823,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}',NULL,'2023-07-28 15:26:00','2023-07-28 15:26:00'),
(237,'default','added',1824,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-28 15:26:00','2023-07-28 15:26:00'),
(238,'default','added',1825,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-28 15:27:00','2023-07-28 15:27:00'),
(239,'default','added',1826,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-28 15:27:00','2023-07-28 15:27:00'),
(240,'default','edited',1788,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":281000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"281000.0000\"}}',NULL,'2023-07-28 16:10:00','2023-07-28 16:10:00'),
(241,'default','status_changed',1817,'App\\Transaction',NULL,NULL,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-28 18:31:00','2023-07-28 18:31:00'),
(242,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 01:07:00','2023-07-29 01:07:00'),
(243,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 01:07:00','2023-07-29 01:07:00'),
(244,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 01:24:00','2023-07-29 01:24:00'),
(245,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 01:25:00','2023-07-29 01:25:00'),
(246,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 01:27:00','2023-07-29 01:27:00'),
(247,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 01:33:00','2023-07-29 01:33:00'),
(248,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 01:37:00','2023-07-29 01:37:00'),
(249,'default','added',1832,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-07-29 02:22:00','2023-07-29 02:22:00'),
(250,'default','edited',1801,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 02:25:00','2023-07-29 02:25:00'),
(251,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 02:50:00','2023-07-29 02:50:00'),
(252,'default','edited',1802,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 03:02:00','2023-07-29 03:02:00'),
(253,'default','edited',1802,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200000.0000\"}}',NULL,'2023-07-29 03:11:00','2023-07-29 03:11:00'),
(254,'default','edited',1802,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":650000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200000.0000\"}}',NULL,'2023-07-29 03:18:00','2023-07-29 03:18:00'),
(255,'default','login',7,'App\\User',NULL,1,7,'App\\User','[]',NULL,'2023-07-29 03:26:00','2023-07-29 03:26:00'),
(256,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-29 03:28:00','2023-07-29 03:28:00'),
(257,'default','login',14,'App\\User',NULL,1,14,'App\\User','[]',NULL,'2023-07-29 03:28:00','2023-07-29 03:28:00'),
(258,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-29 03:28:00','2023-07-29 03:28:00'),
(259,'default','added',1835,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-07-29 03:33:00','2023-07-29 03:33:00'),
(260,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-29 03:35:00','2023-07-29 03:35:00'),
(261,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-29 03:36:00','2023-07-29 03:36:00'),
(262,'default','status_changed',1718,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Tidak acc Replace speaker\",\"updated_status\":\"Cancel Oleh Customer\"}',NULL,'2023-07-29 03:43:00','2023-07-29 03:43:00'),
(263,'default','status_changed',1723,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Program Ulang Win 10 std\",\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-29 03:44:00','2023-07-29 03:44:00'),
(264,'default','status_changed',1770,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Sudah selesai perbaikan hasil\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-29 03:46:00','2023-07-29 03:46:00'),
(265,'default','status_changed',1772,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Proses pembersihan catridge\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 03:46:00','2023-07-29 03:46:00'),
(266,'default','status_changed',1800,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Masih tahap Quality Control\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 03:47:00','2023-07-29 03:47:00'),
(267,'default','status_changed',1745,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Sensor carriage bermasalah, proses bongkar untuk di cobakan pembersihan\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 03:47:00','2023-07-29 03:47:00'),
(268,'default','edited',1768,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 04:03:00','2023-07-29 04:03:00'),
(269,'default','edited',1770,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":40000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 04:11:00','2023-07-29 04:11:00'),
(270,'default','added',7038,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 04:15:00','2023-07-29 04:15:00'),
(271,'default','added',1837,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30000}}',NULL,'2023-07-29 04:15:00','2023-07-29 04:15:00'),
(272,'default','status_changed',1772,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Acckan ganti catridge hitam & warna , type Hp 682\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 04:21:00','2023-07-29 04:21:00'),
(273,'default','status_changed',1783,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Di Solusikan promul win8 oleh bahrullah malam tadi\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 04:27:00','2023-07-29 04:27:00'),
(274,'default','added',1838,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-07-29 04:28:00','2023-07-29 04:28:00'),
(275,'default','edited',1800,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 04:28:00','2023-07-29 04:28:00'),
(276,'default','edited',1385,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 04:55:00','2023-07-29 04:55:00'),
(277,'default','status_changed',1783,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Acc promul win 10\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 04:55:00','2023-07-29 04:55:00'),
(278,'default','added',1844,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":369000}}',NULL,'2023-07-29 05:00:00','2023-07-29 05:00:00'),
(279,'default','added',1846,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-07-29 05:07:00','2023-07-29 05:07:00'),
(280,'default','added',1849,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":685000}}',NULL,'2023-07-29 05:07:00','2023-07-29 05:07:00'),
(281,'default','added',1850,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-07-29 05:09:00','2023-07-29 05:09:00'),
(282,'default','added',1852,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18000}}',NULL,'2023-07-29 05:14:00','2023-07-29 05:14:00'),
(283,'default','added',7039,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-29 05:19:00','2023-07-29 05:19:00'),
(284,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 05:25:00','2023-07-29 05:25:00'),
(285,'default','added',1854,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":226500}}',NULL,'2023-07-29 05:27:00','2023-07-29 05:27:00'),
(286,'default','added',7040,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 05:31:00','2023-07-29 05:31:00'),
(287,'default','added',1855,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":440000}}',NULL,'2023-07-29 05:35:00','2023-07-29 05:35:00'),
(288,'default','deleted',8,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Henru \",\"id\":8}',NULL,'2023-07-29 05:37:00','2023-07-29 05:37:00'),
(289,'default','added',24,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Priadi Dedy \"}',NULL,'2023-07-29 05:39:00','2023-07-29 05:39:00'),
(290,'default','login',24,'App\\User',NULL,1,24,'App\\User','[]',NULL,'2023-07-29 05:40:00','2023-07-29 05:40:00'),
(291,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-29 05:46:00','2023-07-29 05:46:00'),
(292,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-29 05:46:00','2023-07-29 05:46:00'),
(293,'default','edited',24,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Priadi Dedy \"}',NULL,'2023-07-29 05:52:00','2023-07-29 05:52:00'),
(294,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-29 05:53:00','2023-07-29 05:53:00'),
(295,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-29 05:53:00','2023-07-29 05:53:00'),
(296,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 06:07:00','2023-07-29 06:07:00'),
(297,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 06:07:00','2023-07-29 06:07:00'),
(298,'default','deleted',24,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Priadi Dedy \",\"id\":24}',NULL,'2023-07-29 06:13:00','2023-07-29 06:13:00'),
(299,'default','edited',1,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Dedy Priadi\"}',NULL,'2023-07-29 06:14:00','2023-07-29 06:14:00'),
(300,'default','added',1856,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 06:18:00','2023-07-29 06:18:00'),
(301,'default','edited',1770,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":40000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"40000.0000\"}}',NULL,'2023-07-29 06:28:00','2023-07-29 06:28:00'),
(302,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 06:31:00','2023-07-29 06:31:00'),
(303,'default','added',7041,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-29 06:42:00','2023-07-29 06:42:00'),
(304,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 06:43:00','2023-07-29 06:43:00'),
(305,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 06:43:00','2023-07-29 06:43:00'),
(306,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 06:44:00','2023-07-29 06:44:00'),
(307,'default','added',1857,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":10349000}}',NULL,'2023-07-29 06:47:00','2023-07-29 06:47:00'),
(308,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 06:48:00','2023-07-29 06:48:00'),
(309,'default','added',1858,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 06:51:00','2023-07-29 06:51:00'),
(310,'default','added',1859,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 06:54:00','2023-07-29 06:54:00'),
(311,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 06:56:00','2023-07-29 06:56:00'),
(312,'default','edited',1857,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":15669000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"10349000.0000\"}}',NULL,'2023-07-29 06:56:00','2023-07-29 06:56:00'),
(313,'default','status_changed',1858,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":\"Tunggu ACC Replace Keyboard\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 07:11:00','2023-07-29 07:11:00'),
(314,'default','edited',1856,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 07:12:00','2023-07-29 07:12:00'),
(315,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 07:21:00','2023-07-29 07:21:00'),
(316,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 07:22:00','2023-07-29 07:22:00'),
(317,'default','added',7042,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 07:23:00','2023-07-29 07:23:00'),
(318,'default','added',1860,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280000}}',NULL,'2023-07-29 07:24:00','2023-07-29 07:24:00'),
(319,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 07:26:00','2023-07-29 07:26:00'),
(320,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 07:33:00','2023-07-29 07:33:00'),
(321,'default','added',7043,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 07:35:00','2023-07-29 07:35:00'),
(322,'default','login',10,'App\\User',NULL,1,10,'App\\User','[]',NULL,'2023-07-29 07:36:00','2023-07-29 07:36:00'),
(323,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-29 07:45:00','2023-07-29 07:45:00'),
(324,'default','login',10,'App\\User',NULL,1,10,'App\\User','[]',NULL,'2023-07-29 07:47:00','2023-07-29 07:47:00'),
(325,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 07:54:00','2023-07-29 07:54:00'),
(326,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 07:57:00','2023-07-29 07:57:00'),
(327,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 08:04:00','2023-07-29 08:04:00'),
(328,'default','edited',1801,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 08:18:00','2023-07-29 08:18:00'),
(329,'default','added',1862,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195000}}',NULL,'2023-07-29 08:23:00','2023-07-29 08:23:00'),
(330,'default','added',1863,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14000}}',NULL,'2023-07-29 08:24:00','2023-07-29 08:24:00'),
(331,'default','edited',1856,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 08:24:00','2023-07-29 08:24:00'),
(332,'default','added',1864,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":205000}}',NULL,'2023-07-29 08:25:00','2023-07-29 08:25:00'),
(333,'default','edited',1856,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 08:25:00','2023-07-29 08:25:00'),
(334,'default','added',1866,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-07-29 08:27:00','2023-07-29 08:27:00'),
(335,'default','edited',1832,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"final\"},\"old\":{\"status\":\"in_transit\"}}',NULL,'2023-07-29 08:27:00','2023-07-29 08:27:00'),
(336,'default','added',1868,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-07-29 08:28:00','2023-07-29 08:28:00'),
(337,'default','added',25,'App\\User',NULL,1,1,'App\\User','{\"name\":\" corner \"}',NULL,'2023-07-29 08:30:00','2023-07-29 08:30:00'),
(338,'default','added',1870,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2023-07-29 08:31:00','2023-07-29 08:31:00'),
(339,'default','added',7044,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 08:31:00','2023-07-29 08:31:00'),
(340,'default','login',25,'App\\User',NULL,1,25,'App\\User','[]',NULL,'2023-07-29 08:32:00','2023-07-29 08:32:00'),
(341,'default','added',1871,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-07-29 08:32:00','2023-07-29 08:32:00'),
(342,'default','added',1873,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 08:33:00','2023-07-29 08:33:00'),
(343,'default','added',1874,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46500}}',NULL,'2023-07-29 08:36:00','2023-07-29 08:36:00'),
(344,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 08:40:00','2023-07-29 08:40:00'),
(345,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 08:41:00','2023-07-29 08:41:00'),
(346,'default','added',1877,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":228000}}',NULL,'2023-07-29 08:45:00','2023-07-29 08:45:00'),
(347,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 08:47:00','2023-07-29 08:47:00'),
(348,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 08:47:00','2023-07-29 08:47:00'),
(349,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 08:50:00','2023-07-29 08:50:00'),
(350,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 08:50:00','2023-07-29 08:50:00'),
(351,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 08:50:00','2023-07-29 08:50:00'),
(352,'default','added',1878,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":174000}}',NULL,'2023-07-29 09:01:00','2023-07-29 09:01:00'),
(353,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 09:02:00','2023-07-29 09:02:00'),
(354,'default','status_changed',1873,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"tunggu Acc Biaya Pasang\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 09:02:00','2023-07-29 09:02:00'),
(355,'default','added',7045,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 09:03:00','2023-07-29 09:03:00'),
(356,'default','added',1879,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 09:04:00','2023-07-29 09:04:00'),
(357,'default','edited',1801,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 09:07:00','2023-07-29 09:07:00'),
(358,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 09:07:00','2023-07-29 09:07:00'),
(359,'default','edited',1801,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-29 09:08:00','2023-07-29 09:08:00'),
(360,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 09:14:00','2023-07-29 09:14:00'),
(361,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 09:15:00','2023-07-29 09:15:00'),
(362,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 09:15:00','2023-07-29 09:15:00'),
(363,'default','added',1883,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2023-07-29 09:34:00','2023-07-29 09:34:00'),
(364,'default','po_deleted',1883,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1883,\"ref_no\":\"2023\\/0003\"}',NULL,'2023-07-29 09:35:00','2023-07-29 09:35:00'),
(365,'default','added',1884,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":72250000}}',NULL,'2023-07-29 09:40:00','2023-07-29 09:40:00'),
(366,'default','added',7046,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 09:41:00','2023-07-29 09:41:00'),
(367,'default','payment_edited',1884,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"72250000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"72250000.0000\"}}',NULL,'2023-07-29 09:43:00','2023-07-29 09:43:00'),
(368,'default','status_changed',1873,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Replace Baterai ,Hanya Jasa Pasang (Baterai Dari Customer)\\r\\n#Yadha\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-29 09:43:00','2023-07-29 09:43:00'),
(369,'default','status_changed',1873,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Replace Baterai BP 150.000 ,Hanya Jasa Pasang (Baterai Dari Customer) #Yadha\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-29 09:45:00','2023-07-29 09:45:00'),
(370,'default','added',1885,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":8490000}}',NULL,'2023-07-29 09:45:00','2023-07-29 09:45:00'),
(371,'default','added',7047,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 09:47:00','2023-07-29 09:47:00'),
(372,'default','added',1886,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":11150000}}',NULL,'2023-07-29 09:49:00','2023-07-29 09:49:00'),
(373,'default','edited',1884,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":69120000},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"72250000.0000\"}}',NULL,'2023-07-29 09:51:00','2023-07-29 09:51:00'),
(374,'default','payment_edited',1884,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"69120000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"69120000.0000\"}}',NULL,'2023-07-29 09:52:00','2023-07-29 09:52:00'),
(375,'default','edited',1885,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":7496000},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"8490000.0000\"}}',NULL,'2023-07-29 09:57:00','2023-07-29 09:57:00'),
(376,'default','payment_edited',1885,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"7496000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"7496000.0000\"}}',NULL,'2023-07-29 09:58:00','2023-07-29 09:58:00'),
(377,'default','edited',1886,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":9070000},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"11150000.0000\"}}',NULL,'2023-07-29 09:59:00','2023-07-29 09:59:00'),
(378,'default','added',7048,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:00:00','2023-07-29 10:00:00'),
(379,'default','payment_edited',1886,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"9070000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"9070000.0000\"}}',NULL,'2023-07-29 10:00:00','2023-07-29 10:00:00'),
(380,'default','login',10,'App\\User',NULL,1,10,'App\\User','[]',NULL,'2023-07-29 10:02:00','2023-07-29 10:02:00'),
(381,'default','added',1887,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480000}}',NULL,'2023-07-29 10:04:00','2023-07-29 10:04:00'),
(382,'default','status_changed',1856,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Pengecekkan PSU,maubdi cobakan pakai PSU lain\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 10:05:00','2023-07-29 10:05:00'),
(383,'default','sell_deleted',1887,'App\\Transaction',NULL,1,5,'App\\User','{\"id\":1887,\"invoice_no\":\"WTC-LU-2023-00151\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"480000.0000\"}}',NULL,'2023-07-29 10:06:00','2023-07-29 10:06:00'),
(384,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:09:00','2023-07-29 10:09:00'),
(385,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 10:10:00','2023-07-29 10:10:00'),
(386,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 10:10:00','2023-07-29 10:10:00'),
(387,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:10:00','2023-07-29 10:10:00'),
(388,'default','edited',7048,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 10:11:00','2023-07-29 10:11:00'),
(389,'default','added',1888,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1105000}}',NULL,'2023-07-29 10:12:00','2023-07-29 10:12:00'),
(390,'default','added',7049,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:14:00','2023-07-29 10:14:00'),
(391,'default','added',1889,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":745000}}',NULL,'2023-07-29 10:16:00','2023-07-29 10:16:00'),
(392,'default','status_changed',1783,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Promul win 10 std.\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-29 10:16:00','2023-07-29 10:16:00'),
(393,'default','added',1890,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:16:00','2023-07-29 10:16:00'),
(394,'default','edited',1196,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 10:23:00','2023-07-29 10:23:00'),
(395,'default','added',1891,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":711000}}',NULL,'2023-07-29 10:24:00','2023-07-29 10:24:00'),
(396,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 10:24:00','2023-07-29 10:24:00'),
(397,'default','edited',1801,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-29 10:25:00','2023-07-29 10:25:00'),
(398,'default','added',7050,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:26:00','2023-07-29 10:26:00'),
(399,'default','edited',1801,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-29 10:28:00','2023-07-29 10:28:00'),
(400,'default','added',1892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":405000}}',NULL,'2023-07-29 10:32:00','2023-07-29 10:32:00'),
(401,'default','edited',1892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":405000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"405000.0000\"}}',NULL,'2023-07-29 10:33:00','2023-07-29 10:33:00'),
(402,'default','edited',1892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"405000.0000\"}}',NULL,'2023-07-29 10:38:00','2023-07-29 10:38:00'),
(403,'default','added',1893,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":205000}}',NULL,'2023-07-29 10:39:00','2023-07-29 10:39:00'),
(404,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-29 10:42:00','2023-07-29 10:42:00'),
(405,'default','payment_edited',1892,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200000.0000\"}}',NULL,'2023-07-29 10:48:00','2023-07-29 10:48:00'),
(406,'default','payment_deleted',182,'App\\TransactionPayment',NULL,1,1,'App\\User','{\"id\":182,\"ref_no\":\"SP2023\\/0176\"}',NULL,'2023-07-29 10:48:00','2023-07-29 10:48:00'),
(407,'default','payment_edited',1892,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200000.0000\"}}',NULL,'2023-07-29 10:48:00','2023-07-29 10:48:00'),
(408,'default','payment_edited',1892,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200000.0000\"}}',NULL,'2023-07-29 10:49:00','2023-07-29 10:49:00'),
(409,'default','payment_deleted',183,'App\\TransactionPayment',NULL,1,1,'App\\User','{\"id\":183,\"ref_no\":\"SP2023\\/0177\"}',NULL,'2023-07-29 10:49:00','2023-07-29 10:49:00'),
(410,'default','added',7051,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:49:00','2023-07-29 10:49:00'),
(411,'default','payment_edited',1892,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200000.0000\"}}',NULL,'2023-07-29 10:49:00','2023-07-29 10:49:00'),
(412,'default','added',7052,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 10:50:00','2023-07-29 10:50:00'),
(413,'default','added',1895,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":365000}}',NULL,'2023-07-29 10:50:00','2023-07-29 10:50:00'),
(414,'default','added',1896,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":540000}}',NULL,'2023-07-29 10:50:00','2023-07-29 10:50:00'),
(415,'default','added',1897,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44500}}',NULL,'2023-07-29 10:51:00','2023-07-29 10:51:00'),
(416,'default','sell_deleted',1837,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":1837,\"invoice_no\":\"WTC-LU-2023-00134\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30000.0000\"}}',NULL,'2023-07-29 10:57:00','2023-07-29 10:57:00'),
(417,'default','edited',1196,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 11:13:00','2023-07-29 11:13:00'),
(418,'default','added',7053,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 11:19:00','2023-07-29 11:19:00'),
(419,'default','added',1898,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24000}}',NULL,'2023-07-29 11:21:00','2023-07-29 11:21:00'),
(420,'default','added',7054,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 11:26:00','2023-07-29 11:26:00'),
(421,'default','sell_deleted',1896,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1896,\"invoice_no\":\"WTC-LU-2023-00158\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"540000.0000\"}}',NULL,'2023-07-29 11:27:00','2023-07-29 11:27:00'),
(422,'default','added',1899,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 11:27:00','2023-07-29 11:27:00'),
(423,'default','added',1900,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 11:31:00','2023-07-29 11:31:00'),
(424,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-29 11:33:00','2023-07-29 11:33:00'),
(425,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 11:33:00','2023-07-29 11:33:00'),
(426,'default','added',1901,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000}}',NULL,'2023-07-29 11:37:00','2023-07-29 11:37:00'),
(427,'default','added',1902,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-29 11:39:00','2023-07-29 11:39:00'),
(428,'default','added',1903,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":540000}}',NULL,'2023-07-29 11:43:00','2023-07-29 11:43:00'),
(429,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 11:44:00','2023-07-29 11:44:00'),
(430,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 11:44:00','2023-07-29 11:44:00'),
(431,'default','sell_deleted',1903,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1903,\"invoice_no\":\"WTC-LU-2023-00164\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"540000.0000\"}}',NULL,'2023-07-29 11:45:00','2023-07-29 11:45:00'),
(432,'default','sell_deleted',1900,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1900,\"invoice_no\":\"WTC-LU-2023-00162\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 11:46:00','2023-07-29 11:46:00'),
(433,'default','edited',1899,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-29 11:47:00','2023-07-29 11:47:00'),
(434,'default','status_changed',1859,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Untuk keyboard nya aman aja kdd yg lengket, dan mau aja di picik berataan. Untuk satu tots yang pacul sudah di pasangkan dan aman.\\r\\nTapi rada longgar, ini di konfirmasikan ke user nya. Kalo sdin mau rep keyboard\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 11:50:00','2023-07-29 11:50:00'),
(435,'default','status_changed',1858,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":null,\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 11:50:00','2023-07-29 11:50:00'),
(436,'default','added',1904,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-29 11:54:00','2023-07-29 11:54:00'),
(437,'default','added',7055,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 12:12:00','2023-07-29 12:12:00'),
(438,'default','added',1905,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350000}}',NULL,'2023-07-29 12:13:00','2023-07-29 12:13:00'),
(439,'default','added',7056,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 12:14:00','2023-07-29 12:14:00'),
(440,'default','added',1906,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":725000}}',NULL,'2023-07-29 12:14:00','2023-07-29 12:14:00'),
(441,'default','added',7057,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 12:16:00','2023-07-29 12:16:00'),
(442,'default','added',1907,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":715000}}',NULL,'2023-07-29 12:18:00','2023-07-29 12:18:00'),
(443,'default','added',7058,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 13:37:00','2023-07-29 13:37:00'),
(444,'default','added',1908,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2195000}}',NULL,'2023-07-29 13:39:00','2023-07-29 13:39:00'),
(445,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-29 13:41:00','2023-07-29 13:41:00'),
(446,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 13:42:00','2023-07-29 13:42:00'),
(447,'default','edited',1908,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2201000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2195000.0000\"}}',NULL,'2023-07-29 13:49:00','2023-07-29 13:49:00'),
(448,'default','added',7059,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 13:57:00','2023-07-29 13:57:00'),
(449,'default','added',1910,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":85000}}',NULL,'2023-07-29 13:57:00','2023-07-29 13:57:00'),
(450,'default','added',1911,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29000}}',NULL,'2023-07-29 14:02:00','2023-07-29 14:02:00'),
(451,'default','edited',1908,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2201000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2201000.0000\"}}',NULL,'2023-07-29 14:12:00','2023-07-29 14:12:00'),
(452,'default','edited',1908,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2201000.0000\"}}',NULL,'2023-07-29 14:12:00','2023-07-29 14:12:00'),
(453,'default','payment_edited',1908,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2195000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2195000.0000\"}}',NULL,'2023-07-29 14:13:00','2023-07-29 14:13:00'),
(454,'default','payment_deleted',203,'App\\TransactionPayment',NULL,1,17,'App\\User','{\"id\":203,\"ref_no\":\"SP2023\\/0197\"}',NULL,'2023-07-29 14:13:00','2023-07-29 14:13:00'),
(455,'default','payment_edited',1908,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2195000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2195000.0000\"}}',NULL,'2023-07-29 14:13:00','2023-07-29 14:13:00'),
(456,'default','sell_deleted',1908,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1908,\"invoice_no\":\"WTC-LU-2023-00168\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2195000.0000\"}}',NULL,'2023-07-29 14:13:00','2023-07-29 14:13:00'),
(457,'default','added',1912,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2201000}}',NULL,'2023-07-29 14:14:00','2023-07-29 14:14:00'),
(458,'default','edited',1912,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2201000.0000\"}}',NULL,'2023-07-29 14:15:00','2023-07-29 14:15:00'),
(459,'default','added',1913,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95000}}',NULL,'2023-07-29 14:27:00','2023-07-29 14:27:00'),
(460,'default','added',1914,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-29 14:31:00','2023-07-29 14:31:00'),
(461,'default','status_changed',1858,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Sudah selesai ganti keyboard, tpi setelah di QC laptop sidin overheat dan mau di acc kan rep pasta, masih menunggu info acc rep pasta dari sidin.\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 14:40:00','2023-07-29 14:40:00'),
(462,'default','status_changed',1802,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu acc service mobo\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 14:40:00','2023-07-29 14:40:00'),
(463,'default','status_changed',1856,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Sudah di cobakan ganti psu, masih nihil.mau di cobakan pakai mobo pembanding\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 14:41:00','2023-07-29 14:41:00'),
(464,'default','status_changed',1802,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":null,\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 14:46:00','2023-07-29 14:46:00'),
(465,'default','status_changed',1879,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":\"Tunggu ACC Service Motherboard 750k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 14:46:00','2023-07-29 14:46:00'),
(466,'default','status_changed',1858,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":null,\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 14:46:00','2023-07-29 14:46:00'),
(467,'default','status_changed',1859,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu acc rep key\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 14:47:00','2023-07-29 14:47:00'),
(468,'default','status_changed',1899,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Sudah di cobakan power ink lewat laptop, masih nihil. Di cobakan sedot bagian ches, dan pembuangan\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 14:49:00','2023-07-29 14:49:00'),
(469,'default','status_changed',1914,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Sudah di cobakan cleaning lewat printer, masih nihil. Di cobakan power ink lewat laptop dan sedot chis\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-29 14:49:00','2023-07-29 14:49:00'),
(470,'default','added',7060,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 14:52:00','2023-07-29 14:52:00'),
(471,'default','added',1915,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300000}}',NULL,'2023-07-29 14:53:00','2023-07-29 14:53:00'),
(472,'default','status_changed',1768,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu acc rep 2 crt\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-29 14:54:00','2023-07-29 14:54:00'),
(473,'default','sell_deleted',1862,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1862,\"invoice_no\":\"WTC-LU-2023-00144\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"195000.0000\"}}',NULL,'2023-07-29 14:56:00','2023-07-29 14:56:00'),
(474,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-29 15:07:00','2023-07-29 15:07:00'),
(475,'default','edited',1801,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-29 16:01:00','2023-07-29 16:01:00'),
(476,'default','edited',1801,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-29 16:10:00','2023-07-29 16:10:00'),
(477,'default','edited',1801,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-29 16:12:00','2023-07-29 16:12:00'),
(478,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 01:23:00','2023-07-30 01:23:00'),
(479,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 01:53:00','2023-07-30 01:53:00'),
(480,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 01:58:00','2023-07-30 01:58:00'),
(481,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-30 02:05:00','2023-07-30 02:05:00'),
(482,'default','status_changed',1800,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Tunggu Acc Replace Fan Processor\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 02:06:00','2023-07-30 02:06:00'),
(483,'default','added',7061,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 02:30:00','2023-07-30 02:30:00'),
(484,'default','added',1919,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5491000}}',NULL,'2023-07-30 02:31:00','2023-07-30 02:31:00'),
(485,'default','added',1920,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":70000}}',NULL,'2023-07-30 03:12:00','2023-07-30 03:12:00'),
(486,'default','status_changed',1899,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu service head\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 03:19:00','2023-07-30 03:19:00'),
(487,'default','edited',1920,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"70000.0000\"}}',NULL,'2023-07-30 03:20:00','2023-07-30 03:20:00'),
(488,'default','status_changed',1914,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Menunggu acc user buka segel\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 03:22:00','2023-07-30 03:22:00'),
(489,'default','status_changed',1914,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User ACC Buka Segel Printer\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 03:23:00','2023-07-30 03:23:00'),
(490,'default','added',1921,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30000}}',NULL,'2023-07-30 03:24:00','2023-07-30 03:24:00'),
(491,'default','status_changed',1879,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User Cancel Tidak ACC Servis Motherboard\",\"updated_status\":\"Cancel Oleh Customer\"}',NULL,'2023-07-30 03:24:00','2023-07-30 03:24:00'),
(492,'default','status_changed',1802,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User ACC Service Motherboard Dp 200.000,- Tanggal 29 Juli 2023\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 03:26:00','2023-07-30 03:26:00'),
(493,'default','status_changed',1858,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"User acc rep pasta cleaning. Sudah di rep pasta.\\r\\nSisa Qc\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 03:29:00','2023-07-30 03:29:00'),
(494,'default','status_changed',1800,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User Sudah Acc Pergantian Fan Processor Biaya Pasang Rp. 80.000,-\\r\\nFan Intel Original Rp. 50.000,- (Alfia)\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 03:29:00','2023-07-30 03:29:00'),
(495,'default','added',7062,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 03:42:00','2023-07-30 03:42:00'),
(496,'default','added',1922,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":388000}}',NULL,'2023-07-30 03:43:00','2023-07-30 03:43:00'),
(497,'default','added',7063,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 03:47:00','2023-07-30 03:47:00'),
(498,'default','added',1923,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350000}}',NULL,'2023-07-30 03:47:00','2023-07-30 03:47:00'),
(499,'default','added',1924,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 04:23:00','2023-07-30 04:23:00'),
(500,'default','added',1925,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155000}}',NULL,'2023-07-30 04:23:00','2023-07-30 04:23:00'),
(501,'default','added',7064,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 04:27:00','2023-07-30 04:27:00'),
(502,'default','added',1926,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":540000}}',NULL,'2023-07-30 04:28:00','2023-07-30 04:28:00'),
(503,'default','added',7065,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 04:30:00','2023-07-30 04:30:00'),
(504,'default','added',1927,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 04:32:00','2023-07-30 04:32:00'),
(505,'default','status_changed',1927,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Tunggu Acc perbaikan Hasil\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 04:40:00','2023-07-30 04:40:00'),
(506,'default','added',7066,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 04:42:00','2023-07-30 04:42:00'),
(507,'default','added',1928,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":232000}}',NULL,'2023-07-30 04:42:00','2023-07-30 04:42:00'),
(508,'default','added',7067,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 04:47:00','2023-07-30 04:47:00'),
(509,'default','added',1929,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26000}}',NULL,'2023-07-30 04:48:00','2023-07-30 04:48:00'),
(510,'default','status_changed',1924,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Tunggu Acc reset software\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 04:48:00','2023-07-30 04:48:00'),
(511,'default','added',7068,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 05:03:00','2023-07-30 05:03:00'),
(512,'default','added',1930,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50000}}',NULL,'2023-07-30 05:04:00','2023-07-30 05:04:00'),
(513,'default','added',1931,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 05:04:00','2023-07-30 05:04:00'),
(514,'default','status_changed',1924,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User ACC Servis Reset Software Rp. 80.000,- + Kuras Pembuangan Rp. 80.000,-\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 05:11:00','2023-07-30 05:11:00'),
(515,'default','status_changed',1914,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Sudah di sedot cis. Sisa penurunan tinta. Hasil biru nya sdh keluar.\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 05:17:00','2023-07-30 05:17:00'),
(516,'default','edited',1920,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"40000.0000\"}}',NULL,'2023-07-30 05:23:00','2023-07-30 05:23:00'),
(517,'default','added',1932,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-30 05:25:00','2023-07-30 05:25:00'),
(518,'default','edited',1873,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 05:28:00','2023-07-30 05:28:00'),
(519,'default','status_changed',1899,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User Acc Service Head Biaya Rp. 195.000,-\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 05:42:00','2023-07-30 05:42:00'),
(520,'default','edited',1928,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":232000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"232000.0000\"}}',NULL,'2023-07-30 05:54:00','2023-07-30 05:54:00'),
(521,'default','status_changed',1899,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Proses service head, di lanjutkan setelah istirahat\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 05:55:00','2023-07-30 05:55:00'),
(522,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 06:10:00','2023-07-30 06:10:00'),
(523,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 06:11:00','2023-07-30 06:11:00'),
(524,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 06:11:00','2023-07-30 06:11:00'),
(525,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 06:12:00','2023-07-30 06:12:00'),
(526,'default','status_changed',1931,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu acc rep keyboard, Rep Hdd, promul win,  rep pasta cleaning, dan batrai cmos\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 06:12:00','2023-07-30 06:12:00'),
(527,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 06:13:00','2023-07-30 06:13:00'),
(528,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 06:13:00','2023-07-30 06:13:00'),
(529,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 06:18:00','2023-07-30 06:18:00'),
(530,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-30 06:19:00','2023-07-30 06:19:00'),
(531,'default','status_changed',1879,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":\"Cancel Service Motherboard\",\"updated_status\":\"Sudah Di Jemput (Cancel Oleh Customer)\"}',NULL,'2023-07-30 06:25:00','2023-07-30 06:25:00'),
(532,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 06:25:00','2023-07-30 06:25:00'),
(533,'default','added',1933,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140000}}',NULL,'2023-07-30 06:48:00','2023-07-30 06:48:00'),
(534,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 06:51:00','2023-07-30 06:51:00'),
(535,'default','added',7069,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 06:52:00','2023-07-30 06:52:00'),
(536,'default','added',1934,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":145000}}',NULL,'2023-07-30 06:53:00','2023-07-30 06:53:00'),
(537,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 06:59:00','2023-07-30 06:59:00'),
(538,'default','added',1935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 07:10:00','2023-07-30 07:10:00'),
(539,'default','edited',1873,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150000.0000\"}}',NULL,'2023-07-30 07:18:00','2023-07-30 07:18:00'),
(540,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 07:19:00','2023-07-30 07:19:00'),
(541,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 07:19:00','2023-07-30 07:19:00'),
(542,'default','added',1936,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":540000}}',NULL,'2023-07-30 07:46:00','2023-07-30 07:46:00'),
(543,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 08:00:00','2023-07-30 08:00:00'),
(544,'default','added',7070,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 08:01:00','2023-07-30 08:01:00'),
(545,'default','added',1937,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 08:02:00','2023-07-30 08:02:00'),
(546,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-30 08:08:00','2023-07-30 08:08:00'),
(547,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-30 08:10:00','2023-07-30 08:10:00'),
(548,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-30 08:10:00','2023-07-30 08:10:00'),
(549,'default','status_changed',1859,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User Acc Service Keyboard Aja Biaya Rp. 40.000,-\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 08:17:00','2023-07-30 08:17:00'),
(550,'default','status_changed',1768,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User Acc Replace Kedua Cartridge, Cartridge nya masih di perjalanan ya\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 08:20:00','2023-07-30 08:20:00'),
(551,'default','status_changed',1927,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User Acc Perbaikan Hasil Dengan Biaya Rp. 15.000,-\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 08:21:00','2023-07-30 08:21:00'),
(552,'default','status_changed',1931,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Admin Done info ke user untuk solusi perbaikan\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 08:22:00','2023-07-30 08:22:00'),
(553,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 08:24:00','2023-07-30 08:24:00'),
(554,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 08:24:00','2023-07-30 08:24:00'),
(555,'default','status_changed',1772,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Admin Done info ke User untuk solusi perbaikan Replace kedua Cartridge dengan Harga \\r\\n- Black Rp. 158.000,-\\r\\n- Colour Rp. 158.000,-\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 08:27:00','2023-07-30 08:27:00'),
(556,'default','added',1938,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-07-30 08:27:00','2023-07-30 08:27:00'),
(557,'default','status_changed',1859,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Sudah selesai. Solusi service keyboard 40k\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 08:32:00','2023-07-30 08:32:00'),
(558,'default','status_changed',1768,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu acc rep 2 crt\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 08:33:00','2023-07-30 08:33:00'),
(559,'default','status_changed',1802,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Sisa rakit, dan QC.\\r\\nUsernya Acc kemaren tgl 30 juli. Dan acc reguler\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 08:36:00','2023-07-30 08:36:00'),
(560,'default','added',1940,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29000}}',NULL,'2023-07-30 08:41:00','2023-07-30 08:41:00'),
(561,'default','edited',2931,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 08:56:00','2023-07-30 08:56:00'),
(562,'default','edited',2931,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 08:57:00','2023-07-30 08:57:00'),
(563,'default','edited',2931,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 08:57:00','2023-07-30 08:57:00'),
(564,'default','edited',2931,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 08:57:00','2023-07-30 08:57:00'),
(565,'default','edited',2931,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 08:57:00','2023-07-30 08:57:00'),
(566,'default','added',1941,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97000}}',NULL,'2023-07-30 08:58:00','2023-07-30 08:58:00'),
(567,'default','added',1942,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":226000}}',NULL,'2023-07-30 09:00:00','2023-07-30 09:00:00'),
(568,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-30 09:01:00','2023-07-30 09:01:00'),
(569,'default','status_changed',1924,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Sudah selesai reset software dan kuras pembuangan\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 09:02:00','2023-07-30 09:02:00'),
(570,'default','status_changed',1927,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Sudah selesai perbaikan hasil, untuk solusinya di reffil cartridge\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 09:04:00','2023-07-30 09:04:00'),
(571,'default','status_changed',1859,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Admin Done info ke User bahwa selesai servis\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 09:10:00','2023-07-30 09:10:00'),
(572,'default','status_changed',1924,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Admin Done info ke User selesai Service\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 09:11:00','2023-07-30 09:11:00'),
(573,'default','status_changed',1914,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"80K power ink flusink\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 09:14:00','2023-07-30 09:14:00'),
(574,'default','edited',1783,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 09:17:00','2023-07-30 09:17:00'),
(575,'default','login',10,'App\\User',NULL,1,10,'App\\User','[]',NULL,'2023-07-30 09:18:00','2023-07-30 09:18:00'),
(576,'default','edited',1924,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 09:19:00','2023-07-30 09:19:00'),
(577,'default','edited',1859,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":40000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 09:20:00','2023-07-30 09:20:00'),
(578,'default','edited',1927,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 09:22:00','2023-07-30 09:22:00'),
(579,'default','status_changed',1800,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Revisi Solusi perbaikan Menggunakan Fan Processor Alseye TBF 100 RGB Rp. 115.000,- Sebab menggunakan Fan intel Original Bikin PC mati mati. Done info ke user\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 09:27:00','2023-07-30 09:27:00'),
(580,'default','added',1943,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-30 09:54:00','2023-07-30 09:54:00'),
(581,'default','added',7071,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 09:59:00','2023-07-30 09:59:00'),
(582,'default','added',1944,'App\\Transaction',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 10:04:00','2023-07-30 10:04:00'),
(583,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-30 10:06:00','2023-07-30 10:06:00'),
(584,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-30 10:07:00','2023-07-30 10:07:00'),
(585,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-30 10:07:00','2023-07-30 10:07:00'),
(586,'default','status_changed',1935,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Acc Program Ulang WIndows 10 standrt\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 10:09:00','2023-07-30 10:09:00'),
(587,'default','status_changed',1745,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Tunggu acc replace sensor carriage\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 10:10:00','2023-07-30 10:10:00'),
(588,'default','status_changed',1937,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Solusi program ulang Windows 10\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-30 10:11:00','2023-07-30 10:11:00'),
(589,'default','added',7072,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 10:25:00','2023-07-30 10:25:00'),
(590,'default','added',1945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":115000}}',NULL,'2023-07-30 10:27:00','2023-07-30 10:27:00'),
(591,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 10:30:00','2023-07-30 10:30:00'),
(592,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 10:30:00','2023-07-30 10:30:00'),
(593,'default','status_changed',1931,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Tidak acc perbaikan, mau di jemput dlu\",\"updated_status\":\"Cancel Oleh Customer\"}',NULL,'2023-07-30 10:34:00','2023-07-30 10:34:00'),
(594,'default','edited',1931,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 10:34:00','2023-07-30 10:34:00'),
(595,'default','status_changed',1800,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Done Replace Fan, sisa di Qc\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 10:43:00','2023-07-30 10:43:00'),
(596,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 10:48:00','2023-07-30 10:48:00'),
(597,'default','added',7073,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 10:51:00','2023-07-30 10:51:00'),
(598,'default','edited',1914,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 10:52:00','2023-07-30 10:52:00'),
(599,'default','added',1946,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120000}}',NULL,'2023-07-30 10:58:00','2023-07-30 10:58:00'),
(600,'default','edited',1924,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-30 11:00:00','2023-07-30 11:00:00'),
(601,'default','edited',1924,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-07-30 11:01:00','2023-07-30 11:01:00'),
(602,'default','status_changed',1931,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput (Cancel Oleh Customer)\"}',NULL,'2023-07-30 11:03:00','2023-07-30 11:03:00'),
(603,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 11:06:00','2023-07-30 11:06:00'),
(604,'default','added',1947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45000}}',NULL,'2023-07-30 11:08:00','2023-07-30 11:08:00'),
(605,'default','status_changed',1768,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 11:14:00','2023-07-30 11:14:00'),
(606,'default','added',7074,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 11:21:00','2023-07-30 11:21:00'),
(607,'default','added',1948,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30000}}',NULL,'2023-07-30 11:22:00','2023-07-30 11:22:00'),
(608,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 11:27:00','2023-07-30 11:27:00'),
(609,'default','added',7075,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 11:30:00','2023-07-30 11:30:00'),
(610,'default','added',1949,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":569000}}',NULL,'2023-07-30 11:33:00','2023-07-30 11:33:00'),
(611,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 11:37:00','2023-07-30 11:37:00'),
(612,'default','added',1950,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-07-30 11:52:00','2023-07-30 11:52:00'),
(613,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-30 11:56:00','2023-07-30 11:56:00'),
(614,'default','edited',1937,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 11:56:00','2023-07-30 11:56:00'),
(615,'default','status_changed',1937,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Done promul win 10 std\\r\\nKeyboard di cek aman aja min\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 12:18:00','2023-07-30 12:18:00'),
(616,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 12:20:00','2023-07-30 12:20:00'),
(617,'default','added',1952,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 12:24:00','2023-07-30 12:24:00'),
(618,'default','added',1953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":430000}}',NULL,'2023-07-30 12:25:00','2023-07-30 12:25:00'),
(619,'default','edited',1953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"430000.0000\"}}',NULL,'2023-07-30 12:28:00','2023-07-30 12:28:00'),
(620,'default','edited',1783,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 12:33:00','2023-07-30 12:33:00'),
(621,'default','edited',1783,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 12:36:00','2023-07-30 12:36:00'),
(622,'default','edited',1783,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 12:38:00','2023-07-30 12:38:00'),
(623,'default','sell_deleted',1949,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1949,\"invoice_no\":\"WTC-LU-2023-00200\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"569000.0000\"}}',NULL,'2023-07-30 12:40:00','2023-07-30 12:40:00'),
(624,'default','edited',1953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"430000.0000\"}}',NULL,'2023-07-30 12:40:00','2023-07-30 12:40:00'),
(625,'default','edited',1783,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 12:41:00','2023-07-30 12:41:00'),
(626,'default','added',1954,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000}}',NULL,'2023-07-30 12:45:00','2023-07-30 12:45:00'),
(627,'default','edited',1954,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 12:46:00','2023-07-30 12:46:00'),
(628,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 12:51:00','2023-07-30 12:51:00'),
(629,'default','edited',1954,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 12:52:00','2023-07-30 12:52:00'),
(630,'default','edited',1954,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 12:54:00','2023-07-30 12:54:00'),
(631,'default','edited',1937,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 12:55:00','2023-07-30 12:55:00'),
(632,'default','added',1955,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":170000}}',NULL,'2023-07-30 13:02:00','2023-07-30 13:02:00'),
(633,'default','status_changed',1952,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Proses Minta SN office 2013 di admin\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 13:03:00','2023-07-30 13:03:00'),
(634,'default','added',1956,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 13:26:00','2023-07-30 13:26:00'),
(635,'default','edited',1955,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"170000.0000\"}}',NULL,'2023-07-30 13:27:00','2023-07-30 13:27:00'),
(636,'default','edited',1955,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"170000.0000\"}}',NULL,'2023-07-30 13:27:00','2023-07-30 13:27:00'),
(637,'default','status_changed',1952,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Aktivasi office 2013 original\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-30 13:30:00','2023-07-30 13:30:00'),
(638,'default','status_changed',1956,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Proses perbaikan hasil warna kuning\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 13:31:00','2023-07-30 13:31:00'),
(639,'default','edited',1952,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":150000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 13:34:00','2023-07-30 13:34:00'),
(640,'default','added',7076,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-30 13:44:00','2023-07-30 13:44:00'),
(641,'default','added',1957,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":228000}}',NULL,'2023-07-30 13:44:00','2023-07-30 13:44:00'),
(642,'default','edited',1957,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":228000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"228000.0000\"}}',NULL,'2023-07-30 13:46:00','2023-07-30 13:46:00'),
(643,'default','edited',1937,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"80000.0000\"}}',NULL,'2023-07-30 13:52:00','2023-07-30 13:52:00'),
(644,'default','status_changed',1937,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-30 13:53:00','2023-07-30 13:53:00'),
(645,'default','status_changed',1955,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":\"Sudah Bayar Lunas\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 13:55:00','2023-07-30 13:55:00'),
(646,'default','added',1958,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 14:03:00','2023-07-30 14:03:00'),
(647,'default','added',7077,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 14:16:00','2023-07-30 14:16:00'),
(648,'default','added',1959,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32000}}',NULL,'2023-07-30 14:17:00','2023-07-30 14:17:00'),
(649,'default','edited',1952,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"150000.0000\"}}',NULL,'2023-07-30 14:23:00','2023-07-30 14:23:00'),
(650,'default','added',1960,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-30 14:27:00','2023-07-30 14:27:00'),
(651,'default','status_changed',1958,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Tunggu Acc Replace Keyboard BP 80K\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-30 14:36:00','2023-07-30 14:36:00'),
(652,'default','added',1961,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-30 14:40:00','2023-07-30 14:40:00'),
(653,'default','edited',1958,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-30 14:59:00','2023-07-30 14:59:00'),
(654,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-30 15:00:00','2023-07-30 15:00:00'),
(655,'default','payment_edited',1953,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"350000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"350000.0000\"}}',NULL,'2023-07-30 17:46:00','2023-07-30 17:46:00'),
(656,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 01:19:00','2023-07-31 01:19:00'),
(657,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 01:22:00','2023-07-31 01:22:00'),
(658,'default','edited',1935,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 01:25:00','2023-07-31 01:25:00'),
(659,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 01:33:00','2023-07-31 01:33:00'),
(660,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 01:33:00','2023-07-31 01:33:00'),
(661,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 01:33:00','2023-07-31 01:33:00'),
(662,'default','added',1962,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-07-31 01:44:00','2023-07-31 01:44:00'),
(663,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 01:56:00','2023-07-31 01:56:00'),
(664,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 02:02:00','2023-07-31 02:02:00'),
(665,'default','added',7078,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 02:02:00','2023-07-31 02:02:00'),
(666,'default','added',1964,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39000}}',NULL,'2023-07-31 02:03:00','2023-07-31 02:03:00'),
(667,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 02:06:00','2023-07-31 02:06:00'),
(668,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 02:09:00','2023-07-31 02:09:00'),
(669,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 02:10:00','2023-07-31 02:10:00'),
(670,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 02:11:00','2023-07-31 02:11:00'),
(671,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 02:11:00','2023-07-31 02:11:00'),
(672,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 02:39:00','2023-07-31 02:39:00'),
(673,'default','edited',4134,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 02:40:00','2023-07-31 02:40:00'),
(674,'default','added',1965,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110000}}',NULL,'2023-07-31 02:43:00','2023-07-31 02:43:00'),
(675,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 02:45:00','2023-07-31 02:45:00'),
(676,'default','added',1966,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":677000}}',NULL,'2023-07-31 02:45:00','2023-07-31 02:45:00'),
(677,'default','login',25,'App\\User',NULL,1,25,'App\\User','[]',NULL,'2023-07-31 03:10:00','2023-07-31 03:10:00'),
(678,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 03:14:00','2023-07-31 03:14:00'),
(679,'default','status_changed',1952,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Admin Done info selesai Servis dengan Biaya Install office 2013 Origina Rp. 150.000,-\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 03:17:00','2023-07-31 03:17:00'),
(680,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 03:17:00','2023-07-31 03:17:00'),
(681,'default','edited',1952,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":150000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 03:18:00','2023-07-31 03:18:00'),
(682,'default','edited',1770,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":120000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"40000.0000\"}}',NULL,'2023-07-31 03:23:00','2023-07-31 03:23:00'),
(683,'default','status_changed',1958,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Done info User selesai Servis dengan Biaya Pasang Keyboard Rp. 80.000,- \\r\\nkeyboard Toshiba C800D Rp. 155.000,- (Marketing Melda)\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 03:25:00','2023-07-31 03:25:00'),
(684,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 03:26:00','2023-07-31 03:26:00'),
(685,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 03:27:00','2023-07-31 03:27:00'),
(686,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-31 03:27:00','2023-07-31 03:27:00'),
(687,'default','status_changed',1800,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Done Replace Fan dan PC sudah normal\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 03:29:00','2023-07-31 03:29:00'),
(688,'default','status_changed',1772,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":\"User ACC Pergantian Kedua Cartridge 682 Hitam Dan Warna (Marketing Alfia)\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 03:29:00','2023-07-31 03:29:00'),
(689,'default','edited',1958,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":235000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 03:30:00','2023-07-31 03:30:00'),
(690,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 03:31:00','2023-07-31 03:31:00'),
(691,'default','edited',1800,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 03:31:00','2023-07-31 03:31:00'),
(692,'default','edited',1958,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":235000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"235000.0000\"}}',NULL,'2023-07-31 03:32:00','2023-07-31 03:32:00'),
(693,'default','status_changed',1800,'App\\Transaction',NULL,NULL,17,'App\\User','{\"update_note\":\"Marketing Fan Processor (Alfia)\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 03:33:00','2023-07-31 03:33:00'),
(694,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-31 03:35:00','2023-07-31 03:35:00'),
(695,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 03:47:00','2023-07-31 03:47:00'),
(696,'default','shipping_edited',1944,'App\\Transaction',NULL,1,1,'App\\User','{\"update_note\":null}',NULL,'2023-07-31 03:49:00','2023-07-31 03:49:00'),
(697,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 03:51:00','2023-07-31 03:51:00'),
(698,'default','po_deleted',1944,'App\\Transaction',NULL,1,5,'App\\User','{\"id\":1944,\"ref_no\":\"2023\\/0005\"}',NULL,'2023-07-31 03:52:00','2023-07-31 03:52:00'),
(699,'default','added',1968,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1370000}}',NULL,'2023-07-31 03:53:00','2023-07-31 03:53:00'),
(700,'default','added',7079,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 03:57:00','2023-07-31 03:57:00'),
(701,'default','added',1969,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":0}}',NULL,'2023-07-31 03:59:00','2023-07-31 03:59:00'),
(702,'default','status_changed',1955,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Proyektor Sudah di kembalikan\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 04:04:00','2023-07-31 04:04:00'),
(703,'default','status_changed',1956,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Hasil sudah aman, Dan sudah di infokan ke user selesai \\r\\nClaim Garansi\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 04:05:00','2023-07-31 04:05:00'),
(704,'default','added',7080,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 04:06:00','2023-07-31 04:06:00'),
(705,'default','added',1970,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":456000}}',NULL,'2023-07-31 04:06:00','2023-07-31 04:06:00'),
(706,'default','added',7081,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 04:09:00','2023-07-31 04:09:00'),
(707,'default','added',1971,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140000}}',NULL,'2023-07-31 04:10:00','2023-07-31 04:10:00'),
(708,'default','status_changed',1745,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User ACC \\r\\nReplace Sensor Carriage Epson Rp. 215.000,- (Indent)\\r\\nBiaya Pasang Rp. 120.000,-\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 04:11:00','2023-07-31 04:11:00'),
(709,'default','added',1972,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140000}}',NULL,'2023-07-31 04:11:00','2023-07-31 04:11:00'),
(710,'default','sell_deleted',1972,'App\\Transaction',NULL,1,17,'App\\User','{\"id\":1972,\"invoice_no\":\"WTC-LU-2023-00215\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"140000.0000\"}}',NULL,'2023-07-31 04:12:00','2023-07-31 04:12:00'),
(711,'default','added',7082,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 04:19:00','2023-07-31 04:19:00'),
(712,'default','added',7083,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 04:19:00','2023-07-31 04:19:00'),
(713,'default','added',1973,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":891000}}',NULL,'2023-07-31 04:20:00','2023-07-31 04:20:00'),
(714,'default','added',1974,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32000}}',NULL,'2023-07-31 04:20:00','2023-07-31 04:20:00'),
(715,'default','added',1975,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 05:07:00','2023-07-31 05:07:00'),
(716,'default','added',1976,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 05:31:00','2023-07-31 05:31:00'),
(717,'default','added',1977,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-07-31 05:35:00','2023-07-31 05:35:00'),
(718,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 05:36:00','2023-07-31 05:36:00'),
(719,'default','payment_edited',1953,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"350000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"350000.0000\"}}',NULL,'2023-07-31 05:50:00','2023-07-31 05:50:00'),
(720,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-07-31 06:01:00','2023-07-31 06:01:00'),
(721,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 06:02:00','2023-07-31 06:02:00'),
(722,'default','added',1979,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-31 06:04:00','2023-07-31 06:04:00'),
(723,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 06:12:00','2023-07-31 06:12:00'),
(724,'default','added',7084,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 06:16:00','2023-07-31 06:16:00'),
(725,'default','added',1980,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2023-07-31 06:17:00','2023-07-31 06:17:00'),
(726,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 06:18:00','2023-07-31 06:18:00'),
(727,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 06:18:00','2023-07-31 06:18:00'),
(728,'default','added',1981,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-07-31 06:19:00','2023-07-31 06:19:00'),
(729,'default','edited',1980,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2023-07-31 06:20:00','2023-07-31 06:20:00'),
(730,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 06:20:00','2023-07-31 06:20:00'),
(731,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 06:20:00','2023-07-31 06:20:00'),
(732,'default','edited',1859,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"40000.0000\"}}',NULL,'2023-07-31 06:22:00','2023-07-31 06:22:00'),
(733,'default','added',1982,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":185000}}',NULL,'2023-07-31 06:24:00','2023-07-31 06:24:00'),
(734,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 06:27:00','2023-07-31 06:27:00'),
(735,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-31 06:30:00','2023-07-31 06:30:00'),
(736,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 06:31:00','2023-07-31 06:31:00'),
(737,'default','status_changed',1961,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Proses QC setelah update driver wifi\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 06:32:00','2023-07-31 06:32:00'),
(738,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 06:44:00','2023-07-31 06:44:00'),
(739,'default','added',1983,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 06:47:00','2023-07-31 06:47:00'),
(740,'default','added',7085,'App\\Contact',NULL,1,25,'App\\User','[]',NULL,'2023-07-31 06:47:00','2023-07-31 06:47:00'),
(741,'default','status_changed',1955,'App\\Transaction',NULL,NULL,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-31 06:51:00','2023-07-31 06:51:00'),
(742,'default','added',7086,'App\\Contact',NULL,1,25,'App\\User','[]',NULL,'2023-07-31 06:55:00','2023-07-31 06:55:00'),
(743,'default','edited',1968,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1378000},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1370000.0000\"}}',NULL,'2023-07-31 06:55:00','2023-07-31 06:55:00'),
(744,'default','edited',1968,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1378000},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1378000.0000\"}}',NULL,'2023-07-31 06:56:00','2023-07-31 06:56:00'),
(745,'default','payment_edited',1968,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"1378000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1378000.0000\"}}',NULL,'2023-07-31 06:56:00','2023-07-31 06:56:00'),
(746,'default','added',1984,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 06:57:00','2023-07-31 06:57:00'),
(747,'default','added',1985,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 06:59:00','2023-07-31 06:59:00'),
(748,'default','sell_deleted',1984,'App\\Transaction',NULL,1,25,'App\\User','{\"id\":1984,\"invoice_no\":\"CCM-MTP-2023-00018\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 07:02:00','2023-07-31 07:02:00'),
(749,'default','edited',1800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"195000.0000\"}}',NULL,'2023-07-31 07:02:00','2023-07-31 07:02:00'),
(750,'default','added',1986,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-07-31 07:03:00','2023-07-31 07:03:00'),
(751,'default','added',7087,'App\\Contact',NULL,1,25,'App\\User','[]',NULL,'2023-07-31 07:05:00','2023-07-31 07:05:00'),
(752,'default','status_changed',1961,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Tunggu ACC Dicobakan Promul Wind 10 Std (Pernah Original Bln 3) ,Karena Ada Kendala Bluescreen Juga\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 07:05:00','2023-07-31 07:05:00'),
(753,'default','contact_deleted',7085,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-31 07:06:00','2023-07-31 07:06:00'),
(754,'default','edited',7086,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-31 07:06:00','2023-07-31 07:06:00'),
(755,'default','edited',1985,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 07:10:00','2023-07-31 07:10:00'),
(756,'default','added',1988,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170000}}',NULL,'2023-07-31 07:13:00','2023-07-31 07:13:00'),
(757,'default','edited',1976,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 07:13:00','2023-07-31 07:13:00'),
(758,'default','sell_deleted',1955,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":1955,\"invoice_no\":\"WTC-LU-2023-00204\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"170000.0000\"}}',NULL,'2023-07-31 07:14:00','2023-07-31 07:14:00'),
(759,'default','edited',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6153000},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 07:15:00','2023-07-31 07:15:00'),
(760,'default','payment_edited',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"6153000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"6153000.0000\"}}',NULL,'2023-07-31 07:15:00','2023-07-31 07:15:00'),
(761,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 07:20:00','2023-07-31 07:20:00'),
(762,'default','edited',25,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Dwiky \"}',NULL,'2023-07-31 07:25:00','2023-07-31 07:25:00'),
(763,'default','status_changed',1961,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"User Acc Dicobakan Program Ulang Windows 10 Standart\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 07:31:00','2023-07-31 07:31:00'),
(764,'default','added',1989,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-31 07:39:00','2023-07-31 07:39:00'),
(765,'default','status_changed',1772,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Replace catridge 682 hitam & warna. Sdh di test OK bisa di jemput\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 07:41:00','2023-07-31 07:41:00'),
(766,'default','added',1990,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000}}',NULL,'2023-07-31 07:42:00','2023-07-31 07:42:00'),
(767,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 07:43:00','2023-07-31 07:43:00'),
(768,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 07:44:00','2023-07-31 07:44:00'),
(769,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-31 07:44:00','2023-07-31 07:44:00'),
(770,'default','status_changed',1975,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Tunggu Acc setting bios dengan biaya 50ribu\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 07:45:00','2023-07-31 07:45:00'),
(771,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 07:46:00','2023-07-31 07:46:00'),
(772,'default','status_changed',1975,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Tunggu Acc Setting Bios Biaya @50.000\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 07:46:00','2023-07-31 07:46:00'),
(773,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 07:52:00','2023-07-31 07:52:00'),
(774,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 07:52:00','2023-07-31 07:52:00'),
(775,'default','added',7088,'App\\Contact',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 07:53:00','2023-07-31 07:53:00'),
(776,'default','added',1991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-07-31 07:59:00','2023-07-31 07:59:00'),
(777,'default','added',7089,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 08:00:00','2023-07-31 08:00:00'),
(778,'default','added',1993,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":5515000}}',NULL,'2023-07-31 08:00:00','2023-07-31 08:00:00'),
(779,'default','added',1994,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39000}}',NULL,'2023-07-31 08:01:00','2023-07-31 08:01:00'),
(780,'default','sell_deleted',1976,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1976,\"invoice_no\":\"WTC-LU-2023-00219\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:08:00','2023-07-31 08:08:00'),
(781,'default','status_changed',1952,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"3YB8N-RJ2QP-P8G2C-7CMQT-6F2DD\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 08:10:00','2023-07-31 08:10:00'),
(782,'default','edited',1952,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"150000.0000\"}}',NULL,'2023-07-31 08:10:00','2023-07-31 08:10:00'),
(783,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 08:11:00','2023-07-31 08:11:00'),
(784,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 08:11:00','2023-07-31 08:11:00'),
(785,'default','login',25,'App\\User',NULL,1,25,'App\\User','[]',NULL,'2023-07-31 08:12:00','2023-07-31 08:12:00'),
(786,'default','added',1995,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 08:13:00','2023-07-31 08:13:00'),
(787,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 08:15:00','2023-07-31 08:15:00'),
(788,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 08:15:00','2023-07-31 08:15:00'),
(789,'default','edited',1985,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:15:00','2023-07-31 08:15:00'),
(790,'default','added',7090,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 08:24:00','2023-07-31 08:24:00'),
(791,'default','added',1996,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 08:25:00','2023-07-31 08:25:00'),
(792,'default','added',1997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 08:27:00','2023-07-31 08:27:00'),
(793,'default','status_changed',1975,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"User Acc Setting Bios @50.000\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 08:27:00','2023-07-31 08:27:00'),
(794,'default','status_changed',1983,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Masih belum menemukan kendala sulit narik kertas, untuk hasil sdh aman di perbaiki\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 08:28:00','2023-07-31 08:28:00'),
(795,'default','added',7091,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 08:30:00','2023-07-31 08:30:00'),
(796,'default','added',1998,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 08:31:00','2023-07-31 08:31:00'),
(797,'default','added',7092,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 08:33:00','2023-07-31 08:33:00'),
(798,'default','added',1999,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110000}}',NULL,'2023-07-31 08:34:00','2023-07-31 08:34:00'),
(799,'default','added',2000,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-07-31 08:36:00','2023-07-31 08:36:00'),
(800,'default','added',7093,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 08:36:00','2023-07-31 08:36:00'),
(801,'default','added',2001,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":518000}}',NULL,'2023-07-31 08:41:00','2023-07-31 08:41:00'),
(802,'default','added',2002,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":7999600}}',NULL,'2023-07-31 08:43:00','2023-07-31 08:43:00'),
(803,'default','edited',1997,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:46:00','2023-07-31 08:46:00'),
(804,'default','edited',1996,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:46:00','2023-07-31 08:46:00'),
(805,'default','edited',1996,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:48:00','2023-07-31 08:48:00'),
(806,'default','edited',1996,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:48:00','2023-07-31 08:48:00'),
(807,'default','edited',1997,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:49:00','2023-07-31 08:49:00'),
(808,'default','edited',1997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:51:00','2023-07-31 08:51:00'),
(809,'default','edited',1997,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 08:53:00','2023-07-31 08:53:00'),
(810,'default','edited',1800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"195000.0000\"}}',NULL,'2023-07-31 09:00:00','2023-07-31 09:00:00'),
(811,'default','edited',1800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"195000.0000\"}}',NULL,'2023-07-31 09:01:00','2023-07-31 09:01:00'),
(812,'default','added',2003,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":115000}}',NULL,'2023-07-31 09:02:00','2023-07-31 09:02:00'),
(813,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 09:04:00','2023-07-31 09:04:00'),
(814,'default','status_changed',1996,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Ada benda nyangkut, proses bongkar\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 09:05:00','2023-07-31 09:05:00'),
(815,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 09:06:00','2023-07-31 09:06:00'),
(816,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 09:06:00','2023-07-31 09:06:00'),
(817,'default','added',2004,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":629000}}',NULL,'2023-07-31 09:07:00','2023-07-31 09:07:00'),
(818,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 09:12:00','2023-07-31 09:12:00'),
(819,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 09:13:00','2023-07-31 09:13:00'),
(820,'default','added',7094,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 09:14:00','2023-07-31 09:14:00'),
(821,'default','added',2005,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120000}}',NULL,'2023-07-31 09:14:00','2023-07-31 09:14:00'),
(822,'default','added',2006,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 09:35:00','2023-07-31 09:35:00'),
(823,'default','added',7095,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 09:43:00','2023-07-31 09:43:00'),
(824,'default','added',2007,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 09:44:00','2023-07-31 09:44:00'),
(825,'default','added',2008,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 09:46:00','2023-07-31 09:46:00'),
(826,'default','login',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 09:59:00','2023-07-31 09:59:00'),
(827,'default','added',2009,'App\\Transaction',NULL,1,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":983000}}',NULL,'2023-07-31 10:01:00','2023-07-31 10:01:00'),
(828,'default','payment_edited',1796,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"217000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"217000.0000\"}}',NULL,'2023-07-31 10:04:00','2023-07-31 10:04:00'),
(829,'default','payment_edited',1889,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"745000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"745000.0000\"}}',NULL,'2023-07-31 10:04:00','2023-07-31 10:04:00'),
(830,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 10:05:00','2023-07-31 10:05:00'),
(831,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 10:05:00','2023-07-31 10:05:00'),
(832,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 10:11:00','2023-07-31 10:11:00'),
(833,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 10:19:00','2023-07-31 10:19:00'),
(834,'default','status_changed',1961,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Tunggu acc Promul win10 std\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 10:25:00','2023-07-31 10:25:00'),
(835,'default','status_changed',1996,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Servis paperjammed 80k\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 10:26:00','2023-07-31 10:26:00'),
(836,'default','added',2010,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":199000}}',NULL,'2023-07-31 10:26:00','2023-07-31 10:26:00'),
(837,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-07-31 10:27:00','2023-07-31 10:27:00'),
(838,'default','status_changed',1995,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Masih di carikan solusi\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 10:28:00','2023-07-31 10:28:00'),
(839,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 10:28:00','2023-07-31 10:28:00'),
(840,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 10:28:00','2023-07-31 10:28:00'),
(841,'default','status_changed',1996,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Tunggu Acc Service Paperjamed @80k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 10:32:00','2023-07-31 10:32:00'),
(842,'default','logout',17,'App\\User',NULL,1,17,'App\\User','[]',NULL,'2023-07-31 10:33:00','2023-07-31 10:33:00'),
(843,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-07-31 10:33:00','2023-07-31 10:33:00'),
(844,'default','status_changed',1995,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Tunggu Acc service Mobo dengan biaya 650ribu\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 10:33:00','2023-07-31 10:33:00'),
(845,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 10:33:00','2023-07-31 10:33:00'),
(846,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-07-31 10:33:00','2023-07-31 10:33:00'),
(847,'default','status_changed',1995,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"tunggu Acc Mobo Reg. 650rb\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 10:37:00','2023-07-31 10:37:00'),
(848,'default','status_changed',1996,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Acc Paperjamed @80k + Tunggu Acc Perbaikan Hasil @40k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 10:37:00','2023-07-31 10:37:00'),
(849,'default','edited',1997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 10:38:00','2023-07-31 10:38:00'),
(850,'default','status_changed',1975,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Setting Bios @50k\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 10:40:00','2023-07-31 10:40:00'),
(851,'default','status_changed',1975,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Sudah selesai dan Qc, sudah bisa dijemput\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 10:40:00','2023-07-31 10:40:00'),
(852,'default','status_changed',1952,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-31 10:46:00','2023-07-31 10:46:00'),
(853,'default','status_changed',1998,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Untuk Saat ini aman, tapi di coba QC dulu, takutnya kambuhan\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 10:53:00','2023-07-31 10:53:00'),
(854,'default','status_changed',2008,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Tunggu ACC Replace LCD 12.5 40pin  Kuping Kiri Kanan \\r\\nBP 100K\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 10:53:00','2023-07-31 10:53:00'),
(855,'default','status_changed',2007,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Tunggu Acc bongkar segel\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 10:54:00','2023-07-31 10:54:00'),
(856,'default','status_changed',1997,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Dicobakan Refiil Catridge\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 10:55:00','2023-07-31 10:55:00'),
(857,'default','status_changed',2007,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Done Info Minta Acc Buka Segel\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 10:56:00','2023-07-31 10:56:00'),
(858,'default','status_changed',1800,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":null,\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-07-31 10:58:00','2023-07-31 10:58:00'),
(859,'default','status_changed',2008,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"LCD Dicarikan admin\\r\\n12.5inc 40Pin Braket Kiri Kanan\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 11:07:00','2023-07-31 11:07:00'),
(860,'default','status_changed',1997,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Solusi Refill Catridge  2Pcs : RP. 30.000\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 11:09:00','2023-07-31 11:09:00'),
(861,'default','logout',7,'App\\User',NULL,1,7,'App\\User','[]',NULL,'2023-07-31 11:15:00','2023-07-31 11:15:00'),
(862,'default','login',7,'App\\User',NULL,1,7,'App\\User','[]',NULL,'2023-07-31 11:15:00','2023-07-31 11:15:00'),
(863,'default','status_changed',1997,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Tunggu Acc User Refill 2 Crt @30k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 11:16:00','2023-07-31 11:16:00'),
(864,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 11:22:00','2023-07-31 11:22:00'),
(865,'default','added',7096,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 11:22:00','2023-07-31 11:22:00'),
(866,'default','added',2011,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":727500}}',NULL,'2023-07-31 11:26:00','2023-07-31 11:26:00'),
(867,'default','status_changed',1996,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"User Acc Service Paperjamed Dan Perbaikan Hasil @120k\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 11:26:00','2023-07-31 11:26:00'),
(868,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 11:27:00','2023-07-31 11:27:00'),
(869,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 11:31:00','2023-07-31 11:31:00'),
(870,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 11:31:00','2023-07-31 11:31:00'),
(871,'default','sell_deleted',2004,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":2004,\"invoice_no\":\"WTC-LU-2023-00235\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"629000.0000\"}}',NULL,'2023-07-31 11:37:00','2023-07-31 11:37:00'),
(872,'default','sell_deleted',2001,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":2001,\"invoice_no\":\"WTC-LU-2023-00233\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"518000.0000\"}}',NULL,'2023-07-31 11:38:00','2023-07-31 11:38:00'),
(873,'default','status_changed',2007,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Kabel Head & sensor carriage putus.\\r\\nSolusi ganti kabel fleksible head + sensor carriage Bp 120k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 12:03:00','2023-07-31 12:03:00'),
(874,'default','added',2012,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13000}}',NULL,'2023-07-31 12:19:00','2023-07-31 12:19:00'),
(875,'default','added',2013,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38000}}',NULL,'2023-07-31 12:20:00','2023-07-31 12:20:00'),
(876,'default','edited',2012,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13000.0000\"}}',NULL,'2023-07-31 12:21:00','2023-07-31 12:21:00'),
(877,'default','edited',1997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":30000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 12:31:00','2023-07-31 12:31:00'),
(878,'default','added',7097,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 12:38:00','2023-07-31 12:38:00'),
(879,'default','added',2014,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110000}}',NULL,'2023-07-31 12:39:00','2023-07-31 12:39:00'),
(880,'default','status_changed',1996,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Done servis paperjammed 80k & perbaikan hasil 40k\\r\\nSdh di test ok & bisa di jemput\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-07-31 12:41:00','2023-07-31 12:41:00'),
(881,'default','edited',1996,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":120000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 12:45:00','2023-07-31 12:45:00'),
(882,'default','edited',1975,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":50000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 12:47:00','2023-07-31 12:47:00'),
(883,'default','status_changed',1983,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Done Info Tunggu Acc Cleaning @40.000\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-07-31 12:48:00','2023-07-31 12:48:00'),
(884,'default','status_changed',1983,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"User Acc Biaya Cleaning @40k\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 12:54:00','2023-07-31 12:54:00'),
(885,'default','edited',885,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-31 13:13:00','2023-07-31 13:13:00'),
(886,'default','edited',2002,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7773640},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"7999600.0000\"}}',NULL,'2023-07-31 13:17:00','2023-07-31 13:17:00'),
(887,'default','payment_edited',2002,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"7773640.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"7773640.0000\"}}',NULL,'2023-07-31 13:17:00','2023-07-31 13:17:00'),
(888,'default','edited',885,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-31 13:18:00','2023-07-31 13:18:00'),
(889,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 13:18:00','2023-07-31 13:18:00'),
(890,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 13:19:00','2023-07-31 13:19:00'),
(891,'default','added',2015,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-31 13:21:00','2023-07-31 13:21:00'),
(892,'default','edited',2015,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-31 13:25:00','2023-07-31 13:25:00'),
(893,'default','status_changed',2006,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Proses pengecekkan bagia PSU, lampu indikator normal. Tp di cek multi tester voltase tidak stabil\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 13:43:00','2023-07-31 13:43:00'),
(894,'default','status_changed',2015,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Install office 2019\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 13:44:00','2023-07-31 13:44:00'),
(895,'default','added',2016,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155000}}',NULL,'2023-07-31 13:45:00','2023-07-31 13:45:00'),
(896,'default','edited',1958,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"235000.0000\"}}',NULL,'2023-07-31 13:46:00','2023-07-31 13:46:00'),
(897,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 13:49:00','2023-07-31 13:49:00'),
(898,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 13:51:00','2023-07-31 13:51:00'),
(899,'default','added',2017,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25000}}',NULL,'2023-07-31 13:56:00','2023-07-31 13:56:00'),
(900,'default','status_changed',2015,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Minta Tambahan Waktu Untuk Progress Pengecekkan nya\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 14:13:00','2023-07-31 14:13:00'),
(901,'default','status_changed',2006,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Minta Tambahan Waktu Untuk Progress Pengecekkan nya\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 14:19:00','2023-07-31 14:19:00'),
(902,'default','status_changed',2015,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Progress Install nya Masih Loading Setengah\",\"updated_status\":\"Proses Service\"}',NULL,'2023-07-31 14:21:00','2023-07-31 14:21:00'),
(903,'default','added',7098,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 14:27:00','2023-07-31 14:27:00'),
(904,'default','added',2018,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82000}}',NULL,'2023-07-31 14:28:00','2023-07-31 14:28:00'),
(905,'default','edited',1996,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"120000.0000\"}}',NULL,'2023-07-31 14:53:00','2023-07-31 14:53:00'),
(906,'default','edited',1997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"30000.0000\"}}',NULL,'2023-07-31 14:54:00','2023-07-31 14:54:00'),
(907,'default','edited',1975,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"50000.0000\"}}',NULL,'2023-07-31 14:54:00','2023-07-31 14:54:00'),
(908,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-07-31 15:17:00','2023-07-31 15:17:00'),
(909,'default','edited',1859,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"40000.0000\"}}',NULL,'2023-07-31 15:20:00','2023-07-31 15:20:00'),
(910,'default','edited',25,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Dwiky Corner \"}',NULL,'2023-07-31 18:41:00','2023-07-31 18:41:00'),
(911,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 00:54:00','2023-08-01 00:54:00'),
(912,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 01:17:00','2023-08-01 01:17:00'),
(913,'default','edited',1975,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 01:20:00','2023-08-01 01:20:00'),
(914,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 02:11:00','2023-08-01 02:11:00'),
(915,'default','added',7099,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 02:13:00','2023-08-01 02:13:00'),
(916,'default','added',2019,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60000}}',NULL,'2023-08-01 02:14:00','2023-08-01 02:14:00'),
(917,'default','added',7100,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 02:54:00','2023-08-01 02:54:00'),
(918,'default','added',2020,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46000}}',NULL,'2023-08-01 02:55:00','2023-08-01 02:55:00'),
(919,'default','payment_edited',1979,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-08-01 03:08:00','2023-08-01 03:08:00'),
(920,'default','added',2021,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32000}}',NULL,'2023-08-01 03:38:00','2023-08-01 03:38:00'),
(921,'default','login',25,'App\\User',NULL,1,25,'App\\User','[]',NULL,'2023-08-01 03:41:00','2023-08-01 03:41:00'),
(922,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 03:44:00','2023-08-01 03:44:00'),
(923,'default','added',7101,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 03:48:00','2023-08-01 03:48:00'),
(924,'default','added',2022,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 03:48:00','2023-08-01 03:48:00'),
(925,'default','added',2023,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195000}}',NULL,'2023-08-01 03:51:00','2023-08-01 03:51:00'),
(926,'default','added',7102,'App\\Contact',NULL,1,25,'App\\User','[]',NULL,'2023-08-01 04:28:00','2023-08-01 04:28:00'),
(927,'default','added',2027,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 04:32:00','2023-08-01 04:32:00'),
(928,'default','added',2028,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 04:37:00','2023-08-01 04:37:00'),
(929,'default','edited',12,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Rifky \"}',NULL,'2023-08-01 04:47:00','2023-08-01 04:47:00'),
(930,'default','login',12,'App\\User',NULL,1,12,'App\\User','[]',NULL,'2023-08-01 04:48:00','2023-08-01 04:48:00'),
(931,'default','edited',12,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Rifky \"}',NULL,'2023-08-01 04:56:00','2023-08-01 04:56:00'),
(932,'default','status_changed',2028,'App\\Transaction',NULL,NULL,12,'App\\User','{\"update_note\":\"Tunggu acc untuk dapodiknya versi sma\\/smk\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 04:58:00','2023-08-01 04:58:00'),
(933,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 04:59:00','2023-08-01 04:59:00'),
(934,'default','added',2029,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000}}',NULL,'2023-08-01 05:01:00','2023-08-01 05:01:00'),
(935,'default','edited',2028,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 05:03:00','2023-08-01 05:03:00'),
(936,'default','added',7103,'App\\Contact',NULL,1,25,'App\\User','[]',NULL,'2023-08-01 05:13:00','2023-08-01 05:13:00'),
(937,'default','added',7104,'App\\Contact',NULL,1,25,'App\\User','[]',NULL,'2023-08-01 05:15:00','2023-08-01 05:15:00'),
(938,'default','added',2030,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 05:17:00','2023-08-01 05:17:00'),
(939,'default','edited',2030,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 05:19:00','2023-08-01 05:19:00'),
(940,'default','edited',2028,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 05:25:00','2023-08-01 05:25:00'),
(941,'default','status_changed',2028,'App\\Transaction',NULL,NULL,12,'App\\User','{\"update_note\":\"Selesai Install Aplikasi Dapodik Versi 2024 SMA dan Setting Windows Update\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-08-01 05:30:00','2023-08-01 05:30:00'),
(942,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 06:02:00','2023-08-01 06:02:00'),
(943,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 06:07:00','2023-08-01 06:07:00'),
(944,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 06:07:00','2023-08-01 06:07:00'),
(945,'default','status_changed',2022,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Blink eror done, sisa perbaikan hasil.\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 06:08:00','2023-08-01 06:08:00'),
(946,'default','status_changed',2027,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu acc rep Storege dan Keyboard\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 06:09:00','2023-08-01 06:09:00'),
(947,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-08-01 06:11:00','2023-08-01 06:11:00'),
(948,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 06:12:00','2023-08-01 06:12:00'),
(949,'default','added',7105,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 06:13:00','2023-08-01 06:13:00'),
(950,'default','edited',7105,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 06:14:00','2023-08-01 06:14:00'),
(951,'default','added',2038,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46000}}',NULL,'2023-08-01 06:15:00','2023-08-01 06:15:00'),
(952,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 06:20:00','2023-08-01 06:20:00'),
(953,'default','added',2039,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":147000}}',NULL,'2023-08-01 06:21:00','2023-08-01 06:21:00'),
(954,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 06:21:00','2023-08-01 06:21:00'),
(955,'default','status_changed',2007,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User ACC Replace Sensor Carriage Rp. 150.000,-\\r\\nBiaya Pasang Sensor Carriage Rp. 120.000,-\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 06:36:00','2023-08-01 06:36:00'),
(956,'default','added',2041,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":691000}}',NULL,'2023-08-01 06:37:00','2023-08-01 06:37:00'),
(957,'default','status_changed',2028,'App\\Transaction',NULL,NULL,12,'App\\User','{\"update_note\":\"Sudah selesai dan sudah dijemput, biaya install dapodik 35rb + setting windows update 15rb. Bantu bikinkan nota keluarnya\\ud83d\\ude4f\\ud83c\\udffb\",\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-08-01 06:40:00','2023-08-01 06:40:00'),
(958,'default','edited',7105,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 06:40:00','2023-08-01 06:40:00'),
(959,'default','edited',7105,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 06:41:00','2023-08-01 06:41:00'),
(960,'default','contact_deleted',1613,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 06:41:00','2023-08-01 06:41:00'),
(961,'default','edited',7086,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 06:42:00','2023-08-01 06:42:00'),
(962,'default','edited',7086,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 06:42:00','2023-08-01 06:42:00'),
(963,'default','contact_deleted',7102,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 06:43:00','2023-08-01 06:43:00'),
(964,'default','contact_deleted',7103,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 06:43:00','2023-08-01 06:43:00'),
(965,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-08-01 06:56:00','2023-08-01 06:56:00'),
(966,'default','added',2049,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100000}}',NULL,'2023-08-01 06:56:00','2023-08-01 06:56:00'),
(967,'default','status_changed',2006,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Solusi replace PSU, untuk hasil warna juga bermasalah, solusi ganti catridge warna type Hp 680\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 06:58:00','2023-08-01 06:58:00'),
(968,'default','added',2050,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-08-01 06:59:00','2023-08-01 06:59:00'),
(969,'default','status_changed',2015,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Office 2019 tidak support, solusi install office 2013\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-08-01 06:59:00','2023-08-01 06:59:00'),
(970,'default','edited',1996,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":120000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 07:01:00','2023-08-01 07:01:00'),
(971,'default','edited',1997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":30000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 07:03:00','2023-08-01 07:03:00'),
(972,'default','login',19,'App\\User',NULL,1,19,'App\\User','[]',NULL,'2023-08-01 07:04:00','2023-08-01 07:04:00'),
(973,'default','status_changed',1983,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Tunggu Acc Replace Roller Harga @175k + Bp @120k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 07:10:00','2023-08-01 07:10:00'),
(974,'default','sell_deleted',2049,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":2049,\"invoice_no\":\"WTC-LU-2023-00260\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100000.0000\"}}',NULL,'2023-08-01 07:11:00','2023-08-01 07:11:00'),
(975,'default','status_changed',1983,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Done Info\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 07:13:00','2023-08-01 07:13:00'),
(976,'default','added',7106,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 07:13:00','2023-08-01 07:13:00'),
(977,'default','added',2058,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32000}}',NULL,'2023-08-01 07:14:00','2023-08-01 07:14:00'),
(978,'default','added',7107,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 07:15:00','2023-08-01 07:15:00'),
(979,'default','added',2059,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32000}}',NULL,'2023-08-01 07:15:00','2023-08-01 07:15:00'),
(980,'default','added',2060,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":174000}}',NULL,'2023-08-01 07:19:00','2023-08-01 07:19:00'),
(981,'default','status_changed',1998,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Posisi Keyboard Aman Aja tidak ada Trouble\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-08-01 07:32:00','2023-08-01 07:32:00'),
(982,'default','added',2062,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":46000}}',NULL,'2023-08-01 07:43:00','2023-08-01 07:43:00'),
(983,'default','edited',2015,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 07:47:00','2023-08-01 07:47:00'),
(984,'default','status_changed',1983,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Acc Replace Roller + Cleaning\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 07:50:00','2023-08-01 07:50:00'),
(985,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 07:51:00','2023-08-01 07:51:00'),
(986,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 07:51:00','2023-08-01 07:51:00'),
(987,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 07:53:00','2023-08-01 07:53:00'),
(988,'default','added',2063,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":305000}}',NULL,'2023-08-01 07:53:00','2023-08-01 07:53:00'),
(989,'default','status_changed',1995,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Masih Di Read Saja Sama User Nya\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 07:55:00','2023-08-01 07:55:00'),
(990,'default','status_changed',2022,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Done Info Tunggu Acc Service Paperjamed @120k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 07:59:00','2023-08-01 07:59:00'),
(991,'default','added',7108,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 08:08:00','2023-08-01 08:08:00'),
(992,'default','added',2065,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 08:10:00','2023-08-01 08:10:00'),
(993,'default','added',2066,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 08:17:00','2023-08-01 08:17:00'),
(994,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 08:21:00','2023-08-01 08:21:00'),
(995,'default','added',2067,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50000}}',NULL,'2023-08-01 08:28:00','2023-08-01 08:28:00'),
(996,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 08:29:00','2023-08-01 08:29:00'),
(997,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 08:30:00','2023-08-01 08:30:00'),
(998,'default','added',2068,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":484000}}',NULL,'2023-08-01 08:35:00','2023-08-01 08:35:00'),
(999,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 08:36:00','2023-08-01 08:36:00'),
(1000,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 08:37:00','2023-08-01 08:37:00'),
(1001,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-08-01 08:41:00','2023-08-01 08:41:00'),
(1002,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 08:47:00','2023-08-01 08:47:00'),
(1003,'default','status_changed',1995,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User Tidak ACC Perbaikan Motherboard\",\"updated_status\":\"Sudah Di Jemput (Cancel Oleh Customer)\"}',NULL,'2023-08-01 08:49:00','2023-08-01 08:49:00'),
(1004,'default','added',2069,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89000}}',NULL,'2023-08-01 08:49:00','2023-08-01 08:49:00'),
(1005,'default','added',2070,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-08-01 08:53:00','2023-08-01 08:53:00'),
(1006,'default','added',7109,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 08:53:00','2023-08-01 08:53:00'),
(1007,'default','added',2072,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64000}}',NULL,'2023-08-01 08:54:00','2023-08-01 08:54:00'),
(1008,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 08:55:00','2023-08-01 08:55:00'),
(1009,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 08:55:00','2023-08-01 08:55:00'),
(1010,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 08:56:00','2023-08-01 08:56:00'),
(1011,'default','status_changed',2022,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Acc Service Paperjamed @120k\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 08:56:00','2023-08-01 08:56:00'),
(1012,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 09:03:00','2023-08-01 09:03:00'),
(1013,'default','added',2073,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-08-01 09:04:00','2023-08-01 09:04:00'),
(1014,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-08-01 09:05:00','2023-08-01 09:05:00'),
(1015,'default','status_changed',2066,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Solusi servis motherboard. Acckan 750k reguler min\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 09:06:00','2023-08-01 09:06:00'),
(1016,'default','status_changed',2065,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Masih dalam tahap Quality Control\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 09:07:00','2023-08-01 09:07:00'),
(1017,'default','status_changed',1983,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Replace roller Bp120k & perbaikan hasil 40k\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-08-01 09:07:00','2023-08-01 09:07:00'),
(1018,'default','edited',2059,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"32000.0000\"}}',NULL,'2023-08-01 09:09:00','2023-08-01 09:09:00'),
(1019,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 09:12:00','2023-08-01 09:12:00'),
(1020,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 09:16:00','2023-08-01 09:16:00'),
(1021,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 09:18:00','2023-08-01 09:18:00'),
(1022,'default','status_changed',2066,'App\\Transaction',NULL,NULL,13,'App\\User','{\"update_note\":\"Done Info Acc ke User Service Mobo 750.000\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 09:21:00','2023-08-01 09:21:00'),
(1023,'default','added',7110,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 09:22:00','2023-08-01 09:22:00'),
(1024,'default','status_changed',2022,'App\\Transaction',NULL,NULL,10,'App\\User','{\"update_note\":\"Tunggu acc perbaikan hasil, power ink 80K\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 09:24:00','2023-08-01 09:24:00'),
(1025,'default','added',2076,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":37000}}',NULL,'2023-08-01 09:36:00','2023-08-01 09:36:00'),
(1026,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 09:49:00','2023-08-01 09:49:00'),
(1027,'default','added',7111,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-08-01 09:50:00','2023-08-01 09:50:00'),
(1028,'default','added',2078,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200000}}',NULL,'2023-08-01 09:52:00','2023-08-01 09:52:00'),
(1029,'default','added',2079,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":104000}}',NULL,'2023-08-01 09:54:00','2023-08-01 09:54:00'),
(1030,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 09:54:00','2023-08-01 09:54:00'),
(1031,'default','added',2080,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-08-01 10:01:00','2023-08-01 10:01:00'),
(1032,'default','added',2081,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-08-01 10:02:00','2023-08-01 10:02:00'),
(1033,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 10:18:00','2023-08-01 10:18:00'),
(1034,'default','status_changed',2022,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Done Info Tunggu Acc Power Ink Flushing @80k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 10:21:00','2023-08-01 10:21:00'),
(1035,'default','added',2082,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32000}}',NULL,'2023-08-01 10:39:00','2023-08-01 10:39:00'),
(1036,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 10:39:00','2023-08-01 10:39:00'),
(1037,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 10:51:00','2023-08-01 10:51:00'),
(1038,'default','added',2083,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-08-01 10:52:00','2023-08-01 10:52:00'),
(1039,'default','edited',2015,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"25000.0000\"}}',NULL,'2023-08-01 10:54:00','2023-08-01 10:54:00'),
(1040,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 10:55:00','2023-08-01 10:55:00'),
(1041,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 10:58:00','2023-08-01 10:58:00'),
(1042,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 10:58:00','2023-08-01 10:58:00'),
(1043,'default','login',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 10:58:00','2023-08-01 10:58:00'),
(1044,'default','added',7112,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 11:28:00','2023-08-01 11:28:00'),
(1045,'default','added',7113,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 11:29:00','2023-08-01 11:29:00'),
(1046,'default','added',2085,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":194000}}',NULL,'2023-08-01 11:29:00','2023-08-01 11:29:00'),
(1047,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 11:31:00','2023-08-01 11:31:00'),
(1048,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 11:31:00','2023-08-01 11:31:00'),
(1049,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 11:31:00','2023-08-01 11:31:00'),
(1050,'default','added',7114,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 11:31:00','2023-08-01 11:31:00'),
(1051,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 11:32:00','2023-08-01 11:32:00'),
(1052,'default','added',2086,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64000}}',NULL,'2023-08-01 11:32:00','2023-08-01 11:32:00'),
(1053,'default','added',2087,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120000}}',NULL,'2023-08-01 11:34:00','2023-08-01 11:34:00'),
(1054,'default','added',2088,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120000}}',NULL,'2023-08-01 11:35:00','2023-08-01 11:35:00'),
(1055,'default','added',2089,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":199000}}',NULL,'2023-08-01 11:44:00','2023-08-01 11:44:00'),
(1056,'default','added',7115,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 11:55:00','2023-08-01 11:55:00'),
(1057,'default','added',2091,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4988300}}',NULL,'2023-08-01 12:01:00','2023-08-01 12:01:00'),
(1058,'default','edited',2091,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4988300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4988300.0000\"}}',NULL,'2023-08-01 12:03:00','2023-08-01 12:03:00'),
(1059,'default','status_changed',2006,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Done Info User\\r\\nTunggu Acc Rep PSU Bp 80k + Rep Cartridge Warna 680 (Stock Crt Dri Bjb) hrga @145k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 12:14:00','2023-08-01 12:14:00'),
(1060,'default','added',2092,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 12:16:00','2023-08-01 12:16:00'),
(1061,'default','edited',1983,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 12:17:00','2023-08-01 12:17:00'),
(1062,'default','sell_deleted',2023,'App\\Transaction',NULL,1,5,'App\\User','{\"id\":2023,\"invoice_no\":\"WTC-LU-2023-00254\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"195000.0000\"}}',NULL,'2023-08-01 12:26:00','2023-08-01 12:26:00'),
(1063,'default','sell_deleted',2062,'App\\Transaction',NULL,1,5,'App\\User','{\"id\":2062,\"invoice_no\":\"WTC-LU-2023-00264\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"46000.0000\"}}',NULL,'2023-08-01 12:26:00','2023-08-01 12:26:00'),
(1064,'default','added',7116,'App\\Contact',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 12:29:00','2023-08-01 12:29:00'),
(1065,'default','added',2093,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 12:30:00','2023-08-01 12:30:00'),
(1066,'default','status_changed',2006,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"User Acc Rep PSU Dan Rep Crt \\r\\nPSU Indent Tokped 3-4 Hari\\r\\ncrt tunggu dri bjb\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 12:36:00','2023-08-01 12:36:00'),
(1067,'default','added',2094,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":43000}}',NULL,'2023-08-01 12:44:00','2023-08-01 12:44:00'),
(1068,'default','added',7117,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 12:44:00','2023-08-01 12:44:00'),
(1069,'default','added',2095,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":323000}}',NULL,'2023-08-01 12:47:00','2023-08-01 12:47:00'),
(1070,'default','edited',2083,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"in_transit\"},\"old\":{\"status\":\"pending\"}}',NULL,'2023-08-01 12:47:00','2023-08-01 12:47:00'),
(1071,'default','edited',2070,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"in_transit\"},\"old\":{\"status\":\"in_transit\"}}',NULL,'2023-08-01 12:48:00','2023-08-01 12:48:00'),
(1072,'default','edited',2050,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"status\":\"in_transit\"},\"old\":{\"status\":\"in_transit\"}}',NULL,'2023-08-01 12:48:00','2023-08-01 12:48:00'),
(1073,'default','added',2096,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37000}}',NULL,'2023-08-01 12:54:00','2023-08-01 12:54:00'),
(1074,'default','sell_deleted',2094,'App\\Transaction',NULL,1,5,'App\\User','{\"id\":2094,\"invoice_no\":\"WTC-LU-2023-00283\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"43000.0000\"}}',NULL,'2023-08-01 12:58:00','2023-08-01 12:58:00'),
(1075,'default','added',2097,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40000}}',NULL,'2023-08-01 13:00:00','2023-08-01 13:00:00'),
(1076,'default','sell_deleted',2089,'App\\Transaction',NULL,1,5,'App\\User','{\"id\":2089,\"invoice_no\":\"WTC-LU-2023-00279\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"199000.0000\"}}',NULL,'2023-08-01 13:04:00','2023-08-01 13:04:00'),
(1077,'default','edited',2066,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":750000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 13:15:00','2023-08-01 13:15:00'),
(1078,'default','edited',2066,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"750000.0000\"}}',NULL,'2023-08-01 13:18:00','2023-08-01 13:18:00'),
(1079,'default','status_changed',2066,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Acc Service Motherboard Reguler \\r\\nDp 200rb TF Via DANA\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 13:21:00','2023-08-01 13:21:00'),
(1080,'default','edited',2066,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":750000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 13:22:00','2023-08-01 13:22:00'),
(1081,'default','added',2098,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-01 13:27:00','2023-08-01 13:27:00'),
(1082,'default','status_changed',2022,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Service Paperjamed @120k + Power Ink Flushing @80k\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-08-01 13:27:00','2023-08-01 13:27:00'),
(1083,'default','status_changed',2027,'App\\Transaction',NULL,NULL,3,'App\\User','{\"update_note\":\"Masih Menunggu Info Dari User Nya\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 13:28:00','2023-08-01 13:28:00'),
(1084,'default','login',7,'App\\User',NULL,1,7,'App\\User','[]',NULL,'2023-08-01 14:05:00','2023-08-01 14:05:00'),
(1085,'default','added',2099,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":0}}',NULL,'2023-08-01 14:10:00','2023-08-01 14:10:00'),
(1086,'default','edited',2022,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-01 14:26:00','2023-08-01 14:26:00'),
(1087,'default','login',11,'App\\User',NULL,1,11,'App\\User','[]',NULL,'2023-08-01 14:34:00','2023-08-01 14:34:00'),
(1088,'default','status_changed',2098,'App\\Transaction',NULL,NULL,7,'App\\User','{\"update_note\":\"Tunggu Acc Service Mobo Printer 250Ribu Reguler\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 14:35:00','2023-08-01 14:35:00'),
(1089,'default','status_changed',2065,'App\\Transaction',NULL,NULL,11,'App\\User','{\"update_note\":\"Tunggu Acc service Mobo Rp.650.000\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 14:36:00','2023-08-01 14:36:00'),
(1090,'default','status_changed',2065,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Done info ke user Tunggu Acc Servis Motherboard\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 14:39:00','2023-08-01 14:39:00'),
(1091,'default','status_changed',2098,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Done info ke user, Tunggu Acc service motherboard\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 14:42:00','2023-08-01 14:42:00'),
(1092,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-08-01 14:47:00','2023-08-01 14:47:00'),
(1093,'default','status_changed',2092,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Acckan perbaikan hasil ink flushing 80k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 14:48:00','2023-08-01 14:48:00'),
(1094,'default','status_changed',2093,'App\\Transaction',NULL,NULL,2,'App\\User','{\"update_note\":\"Paperjammed roller bermasalah, masih di proses bongkar\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 14:48:00','2023-08-01 14:48:00'),
(1095,'default','status_changed',2092,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Done Info ke user, Tunggu ACC Power Ink Flusing 80k Dan Cleaning Printer 40k\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-01 14:51:00','2023-08-01 14:51:00'),
(1096,'default','status_changed',2092,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"User ACC Perbaikan\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 14:53:00','2023-08-01 14:53:00'),
(1097,'default','status_changed',2093,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Done info minta tambahan waktu ke user\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-01 14:55:00','2023-08-01 14:55:00'),
(1098,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-01 14:56:00','2023-08-01 14:56:00'),
(1099,'default','logout',23,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-01 14:59:00','2023-08-01 14:59:00'),
(1100,'default','login',14,'App\\User',NULL,1,14,'App\\User','[]',NULL,'2023-08-02 01:05:00','2023-08-02 01:05:00'),
(1101,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-02 01:13:00','2023-08-02 01:13:00'),
(1102,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 01:14:00','2023-08-02 01:14:00'),
(1103,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 01:15:00','2023-08-02 01:15:00'),
(1104,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 01:30:00','2023-08-02 01:30:00'),
(1105,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 01:30:00','2023-08-02 01:30:00'),
(1106,'default','added',7118,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 01:41:00','2023-08-02 01:41:00'),
(1107,'default','added',2100,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65000}}',NULL,'2023-08-02 01:41:00','2023-08-02 01:41:00'),
(1108,'default','added',2101,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-02 01:55:00','2023-08-02 01:55:00'),
(1109,'default','edited',2101,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-02 01:58:00','2023-08-02 01:58:00'),
(1110,'default','edited',1983,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"160000.0000\"}}',NULL,'2023-08-02 02:03:00','2023-08-02 02:03:00'),
(1111,'default','added',2103,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175000}}',NULL,'2023-08-02 02:06:00','2023-08-02 02:06:00'),
(1112,'default','edited',1983,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-08-02 02:12:00','2023-08-02 02:12:00'),
(1113,'default','edited',1983,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-08-02 02:16:00','2023-08-02 02:16:00'),
(1114,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2023-08-02 02:17:00','2023-08-02 02:17:00'),
(1115,'default','edited',2101,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"195000.0000\"}}',NULL,'2023-08-02 02:20:00','2023-08-02 02:20:00'),
(1116,'default','added',7119,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 02:27:00','2023-08-02 02:27:00'),
(1117,'default','added',2104,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":859000}}',NULL,'2023-08-02 02:28:00','2023-08-02 02:28:00'),
(1118,'default','edited',2050,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"status\":\"final\"},\"old\":{\"status\":\"in_transit\"}}',NULL,'2023-08-02 02:29:00','2023-08-02 02:29:00'),
(1119,'default','login',25,'App\\User',NULL,1,25,'App\\User','[]',NULL,'2023-08-02 02:31:00','2023-08-02 02:31:00'),
(1120,'default','status_changed',1856,'App\\Transaction',NULL,NULL,14,'App\\User','{\"update_note\":null,\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-02 02:31:00','2023-08-02 02:31:00'),
(1121,'default','status_changed',1961,'App\\Transaction',NULL,NULL,14,'App\\User','{\"update_note\":\"tunggu acc ganti mobo,bp 120k\\r\\n(mobo indent)\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-02 02:33:00','2023-08-02 02:33:00'),
(1122,'default','edited',2070,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"status\":\"in_transit\"},\"old\":{\"status\":\"in_transit\"}}',NULL,'2023-08-02 02:34:00','2023-08-02 02:34:00'),
(1123,'default','edited',2070,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"status\":\"final\"},\"old\":{\"status\":\"in_transit\"}}',NULL,'2023-08-02 02:34:00','2023-08-02 02:34:00'),
(1124,'default','edited',2083,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"status\":\"final\"},\"old\":{\"status\":\"in_transit\"}}',NULL,'2023-08-02 02:35:00','2023-08-02 02:35:00'),
(1125,'default','status_changed',1856,'App\\Transaction',NULL,NULL,14,'App\\User','{\"update_note\":\"tunggu acc ganti mobo ,bp 120k\\r\\n(mobo indent)\",\"updated_status\":\"Menunggu Konfirmasi Customer\"}',NULL,'2023-08-02 02:38:00','2023-08-02 02:38:00'),
(1126,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-08-02 02:39:00','2023-08-02 02:39:00'),
(1127,'default','added',2106,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35000}}',NULL,'2023-08-02 02:56:00','2023-08-02 02:56:00'),
(1128,'default','edited',1983,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160000.0000\"}}',NULL,'2023-08-02 03:10:00','2023-08-02 03:10:00'),
(1129,'default','edited',2101,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"195000.0000\"}}',NULL,'2023-08-02 03:14:00','2023-08-02 03:14:00'),
(1130,'default','status_changed',2106,'App\\Transaction',NULL,NULL,12,'App\\User','{\"update_note\":\"Sudah selesai, sudah dijemput namun usernya salah kasih nomer\",\"updated_status\":\"Sudah Di Jemput\"}',NULL,'2023-08-02 03:14:00','2023-08-02 03:14:00'),
(1131,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 03:17:00','2023-08-02 03:17:00'),
(1132,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 03:17:00','2023-08-02 03:17:00'),
(1133,'default','edited',2101,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"195000.0000\"}}',NULL,'2023-08-02 03:20:00','2023-08-02 03:20:00'),
(1134,'default','edited',2101,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"195000.0000\"}}',NULL,'2023-08-02 03:21:00','2023-08-02 03:21:00'),
(1135,'default','edited',2101,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":195000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-08-02 03:22:00','2023-08-02 03:22:00'),
(1136,'default','edited',2101,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"195000.0000\"}}',NULL,'2023-08-02 03:24:00','2023-08-02 03:24:00'),
(1137,'default','status_changed',2101,'App\\Transaction',NULL,NULL,5,'App\\User','{\"update_note\":\"Solusi Perbaikan Servis Head Rp. 195.000,-\",\"updated_status\":\"Sudah Di Service\"}',NULL,'2023-08-02 03:24:00','2023-08-02 03:24:00'),
(1138,'default','added',2111,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80000}}',NULL,'2023-08-02 03:44:00','2023-08-02 03:44:00'),
(1139,'default','added',2112,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":147000}}',NULL,'2023-08-02 03:45:00','2023-08-02 03:45:00'),
(1140,'default','added',7120,'App\\Contact',NULL,1,25,'App\\User','[]',NULL,'2023-08-02 04:29:00','2023-08-02 04:29:00'),
(1141,'default','added',2116,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":504000}}',NULL,'2023-08-02 04:30:00','2023-08-02 04:30:00'),
(1142,'default','added',2117,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110000}}',NULL,'2023-08-02 04:31:00','2023-08-02 04:31:00'),
(1143,'default','added',2118,'App\\Transaction',NULL,1,25,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-08-02 04:31:00','2023-08-02 04:31:00'),
(1144,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-08-02 05:05:00','2023-08-02 05:05:00'),
(1145,'default','added',7121,'App\\Contact',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 05:10:00','2023-08-02 05:10:00'),
(1146,'default','added',2119,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600000}}',NULL,'2023-08-02 05:11:00','2023-08-02 05:11:00'),
(1147,'default','login',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 05:16:00','2023-08-02 05:16:00'),
(1148,'default','added',2120,'App\\Transaction',NULL,1,5,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-08-02 05:23:00','2023-08-02 05:23:00'),
(1149,'default','status_changed',2118,'App\\Transaction',NULL,NULL,12,'App\\User','{\"update_note\":\"Ghost, driver, dan aktivasi\",\"updated_status\":\"Proses Service\"}',NULL,'2023-08-02 05:36:00','2023-08-02 05:36:00'),
(1150,'default','added',2122,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":516000}}',NULL,'2023-08-02 05:38:00','2023-08-02 05:38:00'),
(1151,'default','added',2123,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30000}}',NULL,'2023-08-02 05:39:00','2023-08-02 05:39:00'),
(1152,'default','added',2124,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":269000}}',NULL,'2023-08-02 06:17:00','2023-08-02 06:17:00'),
(1153,'default','edited',2124,'App\\Transaction',NULL,1,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"269000.0000\"}}',NULL,'2023-08-02 06:22:00','2023-08-02 06:22:00'),
(1154,'default','logout',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2023-08-02 06:27:00','2023-08-02 06:27:00'),
(1155,'default','logout',13,'App\\User',NULL,1,13,'App\\User','[]',NULL,'2023-08-02 06:27:00','2023-08-02 06:27:00'),
