@inject('request', 'Illuminate\Http\Request')
<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ in_array(session()->get('user.language', config('app.locale')), config('constants.langs_rtl')) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') - {{ Session::get('business.name') }}</title>

    @include('layouts.partials.css')

    {{-- Tambahkan CSS sidebar mobile overlay --}}
    <style>
        /* Sidebar default desktop sudah pakai .sidebar-collapse */

        /* Mobile overlay sidebar */
        @media (max-width: 768px) {
            body.sidebar-mobile-open .wrapper {
                overflow: hidden;
            }
            
            body.sidebar-mobile-open .main-sidebar {
                position: fixed;
                top: 0; left: 0;
                height: 100%;
                width: 250px; /* sesuaikan sesuai lebar sidebar */
                background: #222d32; /* warna sidebar */
                z-index: 1050;
                transform: translateX(0);
                transition: transform 0.3s ease;
            }
            
            .main-sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }
            
            /* overlay background */
            .sidebar-overlay {
                position: fixed;
                top: 0; left: 0; right: 0; bottom: 0;
                background: rgba(0,0,0,0.5);
                z-index: 1040;
                display: none;
            }
            
            body.sidebar-mobile-open .sidebar-overlay {
                display: block;
            }
        }
    </style>

    @yield('css')
</head>

<body class="hold-transition skin-{{ session('business.theme_color', 'blue-light') }} sidebar-mini">

    <div class="wrapper">
        <!-- Vue app mount -->
        <div id="app"></div>

        @include('crm::layouts.header')
        @include('crm::layouts.sidebar')

        <!-- Content Wrapper -->
        <div class="content-wrapper">

            <!-- Currency fields -->
            <input type="hidden" id="__code" value="{{ session('currency')['code'] }}">
            <input type="hidden" id="__symbol" value="{{ session('currency')['symbol'] }}">
            <input type="hidden" id="__thousand" value="{{ session('currency')['thousand_separator'] }}">
            <input type="hidden" id="__decimal" value="{{ session('currency')['decimal_separator'] }}">
            <input type="hidden" id="__symbol_placement" value="{{ session('business.currency_symbol_placement') }}">
            <input type="hidden" id="__precision" value="{{ session('business.currency_precision', 2) }}">
            <input type="hidden" id="__quantity_precision" value="{{ session('business.quantity_precision', 2) }}">

            @if (session('status'))
                <input type="hidden" id="status_span" data-status="{{ session('status.success') }}" data-msg="{{ session('status.msg') }}">
            @endif

            @yield('content')

            <div class='scrolltop no-print'>
                <div class='scroll icon'><i class="fas fa-angle-up"></i></div>
            </div>

            @if(config('constants.iraqi_selling_price_adjustment'))
                <input type="hidden" id="iraqi_selling_price_adjustment">
            @endif

            <!-- Invoice Print Section -->
            <section class="invoice print_section" id="receipt_section"></section>
        </div>

        @include('layouts.partials.footer')

        <!-- Audio Feedback -->
        <audio id="success-audio">
            <source src="{{ asset('/audio/success.ogg?v=' . $asset_v) }}" type="audio/ogg">
            <source src="{{ asset('/audio/success.mp3?v=' . $asset_v) }}" type="audio/mpeg">
        </audio>
        <audio id="error-audio">
            <source src="{{ asset('/audio/error.ogg?v=' . $asset_v) }}" type="audio/ogg">
            <source src="{{ asset('/audio/error.mp3?v=' . $asset_v) }}" type="audio/mpeg">
        </audio>
        <audio id="warning-audio">
            <source src="{{ asset('/audio/warning.ogg?v=' . $asset_v) }}" type="audio/ogg">
            <source src="{{ asset('/audio/warning.mp3?v=' . $asset_v) }}" type="audio/mpeg">
        </audio>
    </div>

    {{-- Overlay sidebar mobile --}}
    <div class="sidebar-overlay"></div>

    @include('layouts.partials.javascripts')

    <!-- Sidebar state persistence and mobile toggle -->
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var body = document.body;
            var toggleBtn = document.querySelector('.sidebar-toggle');
            var storageKey = "upos_sidebar_state";
            var sidebarOverlay = document.querySelector('.sidebar-overlay');

            // Fungsi untuk desktop toggle dengan simpan state
            function setSidebarState(collapsed) {
                if (collapsed) {
                    body.classList.add("sidebar-collapse");
                    localStorage.setItem(storageKey, "collapsed");
                } else {
                    body.classList.remove("sidebar-collapse");
                    localStorage.setItem(storageKey, "expanded");
                }
            }

            // Cek ukuran layar apakah mobile
            function isMobile() {
                return window.innerWidth <= 768;
            }

            // Restore state sidebar desktop dari localStorage
            var saved = localStorage.getItem(storageKey);
            if (saved === "collapsed") {
                body.classList.add("sidebar-collapse");
            } else {
                body.classList.remove("sidebar-collapse");
            }

            if (toggleBtn) {
                toggleBtn.addEventListener("click", function (e) {
                    e.preventDefault();

                    if (isMobile()) {
                        // Untuk mobile, toggle class sidebar-mobile-open
                        if (body.classList.contains("sidebar-mobile-open")) {
                            body.classList.remove("sidebar-mobile-open");
                        } else {
                            body.classList.add("sidebar-mobile-open");
                        }
                    } else {
                        // Desktop toggle dengan simpan state
                        var isCollapsed = body.classList.contains("sidebar-collapse");
                        setSidebarState(!isCollapsed);
                    }
                });
            }

            // Klik overlay untuk tutup sidebar mobile
            if (sidebarOverlay) {
                sidebarOverlay.addEventListener("click", function () {
                    body.classList.remove("sidebar-mobile-open");
                });
            }

            // Tutup sidebar mobile kalau resize ke desktop
            window.addEventListener('resize', function () {
                if (!isMobile()) {
                    body.classList.remove("sidebar-mobile-open");
                }
            });
        });
    </script>

    <div class="modal fade view_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</body>
</html>
