<?php

namespace Modules\Repair\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Spatie\Activitylog\Models\Activity;

class CustomerRepairStatusController extends Controller
{
    /**
     * Show the input form for checking repair status.
     */
    public function index()
    {
        return view('repair::customer_repair.index');
    }

    /**
     * Handle POST search based on invoice number.
     */
    public function postRepairStatus(Request $request)
    {
        $invoice_no = $request->input('search_number');

        if (empty($invoice_no)) {
            return response()->json([
                'success' => false,
                'msg' => __('Nomor faktur wajib diisi.'),
            ]);
        }

        // Ambil transaksi berdasarkan invoice_no
        $transaction = DB::table('transactions')
            ->where('invoice_no', $invoice_no)
            ->first();

        if (!$transaction) {
            return response()->json([
                'success' => false,
                'msg' => __('Faktur tidak ditemukan.'),
            ]);
        }

        // Ambil device model berdasarkan repair_model_id dari transaksi
        $deviceModel = DB::table('repair_device_models')
                         ->where('id', $transaction->repair_model_id)
                         ->first();
                         
        
        // Ambil waiter berdasarkan res_waiter_id dari transaksi
        $resWaiter = DB::table('users')
        ->where('id', $transaction->res_waiter_id)
        ->first();
                         
                // Ambil data repair status dari tabel repair_statuses
        $repairStatus = DB::table('repair_statuses')
            ->where('id', $transaction->repair_status_id)
            ->first();

        // Ambil log aktivitas berdasarkan subject_id = transaksi id
        $activity_logs = Activity::where('subject_id', $transaction->id)
            ->orderBy('created_at', 'desc')
            ->get();

        // Mengirim data transaction, deviceModel, dan activity_logs ke view
        $repair_html = view('repair::customer_repair.repair_details')
            ->with(compact('transaction', 'deviceModel', 'repairStatus', 'activity_logs', 'resWaiter'))
            ->render();


        return response()->json([
            'success' => true,
            'msg' => __('lang_v1.success'),
            'repair_html' => $repair_html,
        ]);
    }
}
