@extends('repair::layouts.repair_status')
@section('title', __('repair::lang.repair_status'))
@section('content')
<div class="row">
    <div class="col-md-4"></div>
    <div class="col-md-4">
        <div class="tw-p-5 md:tw-p-6 tw-mb-4 tw-rounded-2xl tw-bg-white tw-shadow-sm tw-ring-1 tw-ring-gray-200">
            <div class="tw-flex tw-flex-col tw-gap-4">
                <div class="tw-text-center">
                    <h1 class="tw-text-lg md:tw-text-xl tw-font-semibold tw-text-[#1e1e1e]">
                        {{ __('repair::lang.repair_status') }}
                    </h1>
                    <h2 class="tw-text-sm tw-font-medium tw-text-gray-500">
                        @lang('Masukkan Nomor Invoice Untuk Melihat Status & Progress Servis')
                    </h2>
                </div>
                <form method="POST"
                    action="{{ action([\Modules\Repair\Http\Controllers\CustomerRepairStatusController::class, 'postRepairStatus']) }}"
                    id="check_repair_status">
                    {{ csrf_field() }}

                    <label class="tw-dw-form-control">
                        <input type="text" name="search_number"
                            class="tw-border tw-border-[#D1D5DA] tw-outline-none tw-h-12 tw-w-full tw-bg-transparent tw-rounded-lg tw-px-3 tw-font-medium tw-text-black placeholder:tw-text-gray-500"
                            required
                            placeholder="Contoh: WTC-MTP-2022-XXXXX">
                    </label>

                    <button type="submit"
                        class="ladda-button tw-bg-gradient-to-r tw-from-indigo-500 tw-to-blue-500 tw-h-12 tw-rounded-xl tw-text-sm md:tw-text-base tw-text-white tw-font-semibold tw-w-full mt-2 hover:tw-from-indigo-600 hover:tw-to-blue-600 focus:tw-outline-none focus:tw-ring-2 focus:tw-ring-blue-500 focus:tw-ring-offset-2 active:tw-from-indigo-700 active:tw-to-blue-700">
                        @lang('Cari')
                    </button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-4"></div>

    <div class="col-md-12 col-xs-12">
        <div class="tw-rounded-2xl">
            <div class="tw-p-6 repair_status_details"></div>
        </div>
    </div>
</div>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $(document).on('submit', 'form#check_repair_status', function(e) {
            e.preventDefault();
            var data = $(this).serialize();
            var url = $(this).attr('action');
            var ladda = Ladda.create(document.querySelector('.ladda-button'));
            ladda.start();
            $.ajax({
                method: 'POST',
                url: url,
                dataType: 'json',
                data: data,
                success: function(result) {
                    ladda.stop();
                    if (result.success) {
                        $(".repair_status_details").html(result.repair_html);
                        toastr.success(result.msg);
                    } else {
                        $(".repair_status_details").html('');
                        toastr.error(result.msg);
                    }
                }
            });
        });
    });
</script>
@endsection
