<div class="col-md-12">
    <div class="box box-solid">
        <div class="box-header with-border">
            <h2 class="box-title">
                <i class="fas fa-wrench"></i>
                {{ $transaction->invoice_no ?? '-' }}
            </h2>
        </div>
        <div class="box-body">
            <!-- Tanggal Masuk & Defect -->
            <div class="row">
                <div class="row">
                    <div class="col-md-6">
                        <strong>{{ __('Tanggal Masuk') }}: </strong>
                        {{ \Carbon\Carbon::parse($transaction->created_at)->translatedFormat('l, d F Y, H:i') }}
                    </div>
                <div class="col-md-6">
                    <strong>@lang('repair::lang.serial_no'): </strong>  
                    {{ $transaction->repair_serial_no ?? '-' }}

                </div>
            </div>

            <!-- Model & Current Repair Status -->
            <div class="row mt-10">
                <div class="col-md-6">
                    <strong>@lang('repair::lang.model'): </strong> 
                    {{ $deviceModel->name ?? '-' }}
                </div>
                <div class="col-md-6">
                     <strong>@lang('repair::lang.defect'): </strong>
                    {{ !empty($transaction->repair_defects) ? json_decode($transaction->repair_defects)[0]->value : '-' }}
                </div>
            </div>

            <!-- Serial No & Waiter -->
            <div class="row mt-10">
                <div class="col-md-6">
                    <strong>{{ __('repair::lang.current_repair_status') }}: </strong>
                    <span class="label" style="background-color: {{ $repairStatus->color ?? '#ccc' }};"> 
                        {{ $repairStatus->name ?? '-' }} 
                    </span>
                </div>
                <div class="col-md-6">
                    <strong>{{ __('repair::lang.waiter') }}: </strong>
                    {{ $resWaiter ? $resWaiter->first_name : '-' }}
                </div>
            </div>

            <!-- Activities -->
            <div class="row mt-10">
                <div class="col-md-12">
                    <strong><span>{{ __('repair::lang.activities') }}:</span></strong>
                    @includeIf('repair::customer_repair.repair_activities', ['activities' => $activity_logs])
                </div>
            </div>
        </div>
    </div>
</div>
