<div class="modal-dialog modal-xl" role="document">
  <div class="modal-content">
    @include('purchase.partials.show_details')
<div class="modal-footer">
    <button type="button" class="tw-dw-btn tw-dw-btn-info tw-text-white no-print" id="copy-purchase-details-btn">
      <i class="fa fa-copy"></i> Copy
    </button>
  
    <button type="button" class="tw-dw-btn tw-dw-btn-primary tw-text-white no-print" aria-label="Print" 
      onclick="$(this).closest('div.modal-content').printThis();"><i class="fa fa-print"></i> @lang( 'messages.print' )
    </button>
  
    <button type="button" class="tw-dw-btn tw-dw-btn-neutral tw-text-white no-print" data-dismiss="modal">@lang( 'messages.close' )</button>
</div>
  </div>
</div>

<script type="text/javascript">
	$(document).ready(function(){
		var element = $('div.modal-xl');
		__currency_convert_recursively(element);

		// --- FUNGSI UNTUK TOMBOL COPY BARU ---
		$('body').on('click', '#copy-purchase-details-btn', function() {
			let btn = $(this);
			let modalContent = btn.closest('div.modal-content');
			
			// 1. Definisikan Header
			let clipboardText = "```\n";
			
            // [MODIFIKASI] Tambah satu baris kosong (\n) setelah header
			clipboardText += "Produk | Harga Modal | SKU | Harga Jual | Qty Pembelian | Harga Reseller\n\n";

			// 2. Temukan tabel
			let productTable = modalContent.find('table.bg-gray').first(); 

			// 3. Loop setiap baris (tr) di dalam tbody tabel
			productTable.find('tbody tr').each(function() {
				let row = $(this);

				// 4. Ekstrak data menggunakan class
				let produk = row.find('.copy-target-produk').text().trim().replace(/\s+/g, ' '); 
				let hargaModal = row.find('.copy-target-modal span.display_currency').first().text().trim(); 
				let sku = row.find('.copy-target-sku').text().trim().replace(/\s+/g, ' ');
				let hargaJual = row.find('.copy-target-jual span.display_currency').first().text().trim();
				
				// [MODIFIKASI] Ambil Qty beserta satuan (Unit, Pcs, dll.)
                // ----------------------------------------------------
                // Ambil angka qty, cth: "20"
				let qty_num = row.find('.copy-target-qty span.display_currency').first().text().trim();
                // Ambil semua teks di dalam sel qty, cth: "20 Unit (10 Pcs)"
				let qty_full_text = row.find('.copy-target-qty').text().trim().replace(/\s+/g, ' ');
                // Ambil kata pertama setelah angka qty (ini adalah satuannya)
				let qty_unit = qty_full_text.replace(qty_num, '').trim().split(' ')[0]; 
                // Gabungkan, cth: "20 Unit"
				let qty = qty_num + ' ' + qty_unit;
                // ----------------------------------------------------

				let hargaReseller = row.find('.copy-target-reseller span.display_currency').first().text().trim();

				// 5. Gabungkan data
				if (produk) {
                    // [MODIFIKASI] Tambah satu baris kosong (\n) setelah setiap data
					clipboardText += `${produk} | ${hargaModal} | ${sku} | ${hargaJual} | ${qty} | ${hargaReseller}\n\n`;
				}
			});

			// 6. Tutup format backtick
			clipboardText += "```";

			// 7. Copy ke clipboard
			navigator.clipboard.writeText(clipboardText).then(function() {
				// Beri feedback ke user
				let originalHtml = btn.html();
				btn.html('<i class="fa fa-check"></i> Ter-copy!');
				btn.prop('disabled', true);
				setTimeout(function() {
					btn.html('<i class="fa fa-copy"></i> Copy');
					btn.prop('disabled', false);
				}, 2000);
			}, function(err) {
				console.error('Gagal menyalin: ', err);
				alert('Gagal menyalin ke clipboard.');
			});
		});
	});
</script>