@extends('layouts.app')
@section('title', __('lang_v1.product_sell_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('lang_v1.product_sell_report')}}</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'getStockReport']), 'method' => 'get', 'id' => 'product_sell_report_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                    {!! Form::label('search_product', __('lang_v1.search_product') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-search"></i>
                            </span>
                            <input type="hidden" value="" id="variation_id">
                            {!! Form::text('search_product', null, ['class' => 'form-control', 'id' => 'search_product', 'placeholder' => __('lang_v1.search_product_placeholder'), 'autofocus']); !!}
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-user"></i>
                            </span>
                            {!! Form::select('customer_id', $customers, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required', 'style' => 'width:100%']); !!}
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('psr_customer_group_id', __( 'lang_v1.customer_group_name' ) . ':') !!}
                        {!! Form::select('psr_customer_group_id', $customer_group, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'psr_customer_group_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location').':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-map-marker"></i>
                            </span>
                            {!! Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required', 'style' => 'width:100%']); !!}
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_id', __('product.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'psr_filter_category_id', 'placeholder' => __('lang_v1.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('brand_id', __('product.brand') . ':') !!}
                        {!! Form::select('brand_id', $brands, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'psr_filter_brand_id', 'placeholder' => __('lang_v1.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_sr_date_filter', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_sr_date_filter', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    {!! Form::label('product_sr_start_time', __('lang_v1.time_range') . ':') !!}
                    @php
                        $startDay = Carbon::now()->startOfDay();
                        $endDay   = $startDay->copy()->endOfDay();
                    @endphp
                    <div class="form-group">
                        {!! Form::text('start_time', @format_time($startDay), ['style' => __('lang_v1.select_a_date_range'), 'class' => 'form-control width-50 f-left', 'id' => 'product_sr_start_time']); !!}
                        {!! Form::text('end_time', @format_time($endDay), ['class' => 'form-control width-50 f-left', 'id' => 'product_sr_end_time']); !!}
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#psr_detailed_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-list" aria-hidden="true"></i> @lang('lang_v1.detailed')</a>
                    </li>
                    <li>
                        <a href="#psr_detailed_with_purchase_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-list" aria-hidden="true"></i> @lang('lang_v1.detailed_with_purchase')</a>
                    </li>
                    <li>
                        <a href="#psr_grouped_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-bars" aria-hidden="true"></i> @lang('lang_v1.grouped')</a>
                    </li>
                    <li>
                        <a href="#psr_by_cat_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-bars" aria-hidden="true"></i> @lang('lang_v1.by_category')</a>
                    </li>
                    <li>
                        <a href="#psr_by_brand_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-bars" aria-hidden="true"></i> @lang('lang_v1.by_brand')</a>
                    </li>
                    <li>
                        <a href="#psr_reordering_point_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-bars" aria-hidden="true"></i> Reordering Point</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="psr_detailed_tab">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" 
                            id="product_sell_report_table">
                                <thead>
                                    <tr>
                                        <th>@lang('sale.product')</th>
                                        <th>@lang('product.sku')</th>
                                        <th id="psr_product_custom_field1">{{$product_custom_field1}}</th>
                                        <th id="psr_product_custom_field2">{{$product_custom_field2}}</th>
                                        <th>@lang('sale.customer_name')</th>
                                        <th>@lang('lang_v1.contact_id')</th>
                                        <th>@lang('sale.invoice_no')</th>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('sale.qty')</th>
                                        <th>@lang('sale.unit_price')</th>
                                        <th>@lang('sale.discount')</th>
                                        <th>@lang('sale.tax')</th>
                                        <th>@lang('sale.price_inc_tax')</th>
                                        <th>@lang('sale.total')</th>
                                        <th>@lang('lang_v1.payment_method')</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr class="bg-gray font-17 footer-total text-center">
                                        <td colspan="8"><strong>@lang('sale.total'):</strong></td>
                                        <td id="footer_total_sold"></td>
                                        <td></td>
                                        <td></td>
                                        <td id="footer_tax"></td>
                                        <td></td>
                                        <td><span class="display_currency" id="footer_subtotal" data-currency_symbol ="true"></span></td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane" id="psr_detailed_with_purchase_tab">
                        <div class="table-responsive">
                            @if(session('business.enable_lot_number'))
                                <input type="hidden" id="lot_enabled">
                            @endif
                            <table class="table table-bordered table-striped" 
                            id="product_sell_report_with_purchase_table" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('sale.product')</th>
                                        <th>@lang('product.sku')</th>
                                        <th>@lang('sale.customer_name')</th>
                                        <th>@lang('sale.invoice_no')</th>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('lang_v1.purchase_ref_no')</th>
                                        <th>@lang('lang_v1.lot_number')</th>
                                        <th>@lang('lang_v1.supplier_name')</th>
                                        <th>@lang('sale.qty')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>

                    <div class="tab-pane" id="psr_grouped_tab">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped"
                            id="product_sell_grouped_report_table" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('sale.product')</th>
                                        <th>@lang('product.sku')</th>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('report.current_stock')</th>
                                        <th>@lang('report.total_unit_sold')</th>
                                        
                                        <th>Total Harga Modal</th> 
                                        
                                        <th>@lang('sale.total')</th> </tr>
                                </thead>
                                <tfoot>
                                    <tr class="bg-gray font-17 footer-total text-center">
                                        <td colspan="4"><strong>@lang('sale.total'):</strong></td>
                                        
                                        <td id="footer_total_grouped_sold"></td>
                    
                                        <td><span class="display_currency" id="footer_grouped_purchase_price" data-currency_symbol ="true"></span></td>
                    
                                        <td><span class="display_currency" id="footer_grouped_subtotal" data-currency_symbol ="true"></span></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    @include('report.partials.product_sell_report_by_category')

                    @include('report.partials.product_sell_report_by_brand')
                <div class="tab-pane" id="psr_reordering_point_tab">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped"
                            id="product_sell_reordering_point_table" style="width: 100%;">
<thead>
    <tr>
        <th>@lang('sale.product')</th>
        <th>@lang('product.sku')</th>
        <th>Stok Saat Ini</th>
        <th>@lang('report.total_unit_sold')</th>
        <th>Total Modal</th> 
        <th>Total Omset</th>
        <th>Total Margin</th>
        <th>Avg Modal</th>
        <th>Avg Omset</th>
        <th>Rekomendasi Beli</th>
        <th>Anggaran</th> </tr>
</thead>
<tfoot>
    <tr class="bg-gray font-17 footer-total text-center">
        <td colspan="3"><strong>@lang('sale.total'):</strong></td>
        <td id="footer_total_reordering_sold"></td>
        <td><span class="display_currency" id="footer_reordering_modal" data-currency_symbol ="true"></span></td>
        <td><span class="display_currency" id="footer_reordering_omset" data-currency_symbol ="true"></span></td>
        <td><span class="display_currency" id="footer_reordering_margin" data-currency_symbol ="true"></span></td>
        <td id="footer_reordering_avg_modal_percent"></td> 
        <td></td> <td id="footer_reordering_rekomendasi"></td> <td><span class="display_currency" id="footer_reordering_anggaran" data-currency_symbol="true"></span></td> </tr>
</tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade view_register" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>

@endsection
@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
    <script type="text/javascript">
        $(
        '#product_sell_report_form #location_id, #product_sell_report_form #customer_id, #psr_filter_brand_id, #psr_filter_category_id, #psr_customer_group_id'
    ).change(function() {
        $('.nav-tabs li.active').find('a[data-toggle="tab"]').trigger('shown.bs.tab');
    });
        $(document).ready( function() {

            // --- SET DEFAULT DATE RANGE (LAST 90 DAYS) ---
            var start = moment().subtract(89, 'days'); // 90 hari terakhir (termasuk hari ini)
            var end = moment();
            
            // Cek jika daterangepicker sudah di-bind dan variabel format tanggal ada
            if ($('#product_sr_date_filter').length > 0 && typeof moment_date_format !== 'undefined') {
                
                // Pastikan daterangepicker sudah ada
                if ($('#product_sr_date_filter').data('daterangepicker')) {
                    // Set tanggal di daterangepicker
                    $('#product_sr_date_filter').data('daterangepicker').setStartDate(start);
                    $('#product_sr_date_filter').data('daterangepicker').setEndDate(end);

                    // Update nilai teks di input box
                    var start_date_formatted = start.format(moment_date_format);
                    var end_date_formatted = end.format(moment_date_format);
                    $('#product_sr_date_filter').val(start_date_formatted + ' ~ ' + end_date_formatted);
                }
            }
            // --- END DEFAULT DATE RANGE ---


            $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
                var target = $(e.target).attr('href');
                
                // --- TAB: BY CATEGORY ---
                if ( target == '#psr_by_cat_tab') {
                    if(typeof product_sell_report_by_category_datatable == 'undefined') {
                        product_sell_report_by_category_datatable = $('table#product_sell_report_by_category').DataTable({
                                processing: true,
                                serverSide: true,
                                fixedHeader:false,
                                ajax: {
                                    url: '/reports/product-sell-grouped-by',
                                    data: function(d) {
                                        var start = '';
                                        var end = '';
                                        var start_time = $('#product_sr_start_time').val();
                                        var end_time = $('#product_sr_end_time').val();
                                        if ($('#product_sr_date_filter').val()) {
                                            start = $('input#product_sr_date_filter')
                                                .data('daterangepicker')
                                                .startDate.format('YYYY-MM-DD');
                                            end = $('input#product_sr_date_filter')
                                                .data('daterangepicker')
                                                .endDate.format('YYYY-MM-DD');

                                            start = moment(start + " " + start_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
                                            end = moment(end + " " + end_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
                                        }
                                        d.start_date = start;
                                        d.end_date = end;
                                        d.group_by = 'category';
                                        d.category_id = $('select#psr_filter_category_id').val();
                                        d.brand_id = $('select#psr_filter_brand_id').val();
                                        d.customer_id = $('select#customer_id').val();
                                        d.location_id = $('select#location_id').val();
                                        d.customer_group_id = $('#psr_customer_group_id').val();
                                    },
                                },
                                columns: [
                                    { data: 'category_name', name: 'cat.name' },
                                    { data: 'current_stock', name: 'current_stock', searchable: false, orderable: false },
                                    { data: 'total_qty_sold', name: 'total_qty_sold', searchable: false },
                                    { data: 'subtotal', name: 'subtotal', searchable: false },
                                ],
                                fnDrawCallback: function(oSettings) {
                                    $('#footer_psr_by_cat_total_sell').text(
                                        sum_table_col($('#product_sell_report_by_category'), 'row_subtotal')
                                    );
                                    $('#footer_psr_by_cat_total_sold').html(
                                        __sum_stock($('#product_sell_report_by_category'), 'sell_qty')
                                    );

                                    $('#footer_psr_by_cat_total_stock').html(
                                        __sum_stock($('#product_sell_report_by_category'), 'current_stock')
                                    );
                                    __currency_convert_recursively($('#product_sell_report_by_category'));
                                },
                            });
                        } else {
                            product_sell_report_by_category_datatable.ajax.reload();
                        }
                // --- TAB: BY BRAND ---
                } else if ( target == '#psr_by_brand_tab') {
                    if(typeof product_sell_report_by_brand_datatable == 'undefined') {
                        product_sell_report_by_brand_datatable = $('table#product_sell_report_by_brand').DataTable({
                                processing: true,
                                serverSide: true,
                                fixedHeader:false,
                                ajax: {
                                    url: '/reports/product-sell-grouped-by',
                                    data: function(d) {
                                        var start = '';
                                        var end = '';
                                        var start_time = $('#product_sr_start_time').val();
                                        var end_time = $('#product_sr_end_time').val();
                                        if ($('#product_sr_date_filter').val()) {
                                            start = $('input#product_sr_date_filter')
                                                .data('daterangepicker')
                                                .startDate.format('YYYY-MM-DD');
                                            end = $('input#product_sr_date_filter')
                                                .data('daterangepicker')
                                                .endDate.format('YYYY-MM-DD');

                                            start = moment(start + " " + start_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
                                            end = moment(end + " " + end_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
                                        }
                                        d.start_date = start;
                                        d.end_date = end;
                                        d.group_by = 'brand';
                                        d.category_id = $('select#psr_filter_category_id').val();
                                        d.brand_id = $('select#psr_filter_brand_id').val();
                                        d.customer_id = $('select#customer_id').val();
                                        d.location_id = $('select#location_id').val();
                                        d.customer_group_id = $('#psr_customer_group_id').val();
                                    },
                                },
                                columns: [
                                    { data: 'brand_name', name: 'b.name' },
                                    { data: 'current_stock', name: 'current_stock', searchable: false, orderable: false },
                                    { data: 'total_qty_sold', name: 'total_qty_sold', searchable: false },
                                    { data: 'subtotal', name: 'subtotal', searchable: false },
                                ],
                                fnDrawCallback: function(oSettings) {
                                    $('#footer_psr_by_brand_total_sell').text(
                                        sum_table_col($('#product_sell_report_by_brand'), 'row_subtotal')
                                    );
                                    $('#footer_psr_by_brand_total_sold').html(
                                        __sum_stock($('#product_sell_report_by_brand'), 'sell_qty')
                                    );

                                    $('#footer_psr_by_cat_total_stock').html(
                                        __sum_stock($('#product_sell_report_by_brand'), 'current_stock')
                                    );
                                    __currency_convert_recursively($('#product_sell_report_by_brand'));
                                },
                            });
                        } else {
                            product_sell_report_by_brand_datatable.ajax.reload();
                        }
                    }
                    
                    // --- TAB: REORDERING POINT ---
                    else if ( target == '#psr_reordering_point_tab') {
                        if(typeof product_sell_reordering_point_datatable == 'undefined') {
                            product_sell_reordering_point_datatable = $('table#product_sell_reordering_point_table').DataTable({
                                    processing: true,
                                    serverSide: true,
                                    fixedHeader:false,
                                    order: [[ 2, 'asc' ]], // Default sort by "Stok Saat Ini" (index 2) ASC

                                    // --- TAMBAHAN UNTUK TOMBOL ---
                                    dom: 'lBfrtip', // Menambahkan container Tombol (B)
                                    buttons: [
                                        {
                                            text: '<i class="fa fa-copy"></i> Copy Data Purchase',
                                            className: 'btn-success',
                                            action: function ( e, dt, node, config ) {
                                                var textToCopy = '```\n\n'; // Mulai dengan backticks dan spasi
                                                var hasData = false;

                                                // Loop semua baris yang ada di tabel (setelah filter)
                                                dt.rows({ search: 'applied' }).nodes().each(function(tr, i) {
                                                    var $tds = $(tr).find('td');
                                                    
                                                    // Ambil nilai data asli dari span (Kolom Rekomendasi Beli adalah index 9)
                                                    var rec_span = $($tds[9]).find('span.rekomendasi_beli');
                                                    var rec_val = rec_span.length ? rec_span.data('orig-value') : 0;

                                                    // Hanya salin jika rekomendasi > 0
                                                    if (rec_val && parseFloat(rec_val) > 0) {
                                                        hasData = true;
                                                        var productName = $($tds[0]).text().trim(); // Index 0: Produk
                                                        var sku = $($tds[1]).text().trim();         // Index 1: SKU
                                                        var currentStock = $($tds[2]).text().trim();  // Index 2: Stok
                                                        
                                                        // --- PERUBAHAN DI SINI ---
                                                        var avgModal = $($tds[7]).text().trim();     // Index 7: Avg Modal
                                                        // --- AKHIR PERUBAHAN ---

                                                        var recommendation = $($tds[9]).text().trim(); // Index 9: Rekomendasi
                                                        var budget = $($tds[10]).text().trim(); // Index 10: Anggaran

                                                        textToCopy += productName + '\n';
                                                        textToCopy += 'SKU: ' + sku + '\n';
                                                        textToCopy += 'Stok: ' + currentStock + '\n';
                                                        
                                                        // --- PERUBAHAN DI SINI ---
                                                        textToCopy += 'Avg Modal: ' + avgModal + '\n';
                                                        // --- AKHIR PERUBAHAN ---
                                                        
                                                        textToCopy += 'Rekomendasi Beli: ' + recommendation + '\n';
                                                        textToCopy += 'Anggaran: ' + budget + '\n';
                                                        
                                                        textToCopy += '\n'; // Spasi 1 baris kosong
                                                    }
                                                });

                                                textToCopy += '```'; // Tutup dengan backticks

                                                if (!hasData) {
                                                    toastr.info('Tidak ada data rekomendasi (di atas 0) untuk disalin.');
                                                    return;
                                                }

                                                // Salin ke clipboard
                                                navigator.clipboard.writeText(textToCopy).then(function() {
                                                    toastr.success('Data rekomendasi (lebih dari 0) disalin ke clipboard!');
                                                }, function(err) {
                                                    toastr.error('Gagal menyalin data: ', err);
                                                });
                                            }
                                        }
                                    ],
                                    // --- AKHIR TAMBAHAN TOMBOL ---

                                    ajax: {
                                        url: '/reports/product-reordering-report', 
                                        data: function(d) {
                                            var start = '';
                                            var end = '';
                                            var start_time = $('#product_sr_start_time').val();
                                            var end_time = $('#product_sr_end_time').val();
                                            if ($('#product_sr_date_filter').val()) {
                                                start = $('input#product_sr_date_filter')
                                                    .data('daterangepicker')
                                                    .startDate.format('YYYY-MM-DD');
                                                end = $('input#product_sr_date_filter')
                                                    .data('daterangepicker')
                                                    .endDate.format('YYYY-MM-DD');

                                                start = moment(start + " " + start_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
                                                end = moment(end + " " + end_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
                                            }
                                            d.start_date = start;
                                            d.end_date = end;
                                            d.variation_id = $('#variation_id').val();
                                            d.customer_id = $('select#customer_id').val();
                                            d.location_id = $('select#location_id').val();
                                            d.category_id = $('select#psr_filter_category_id').val();
                                            d.brand_id = $('select#psr_filter_brand_id').val();
                                            d.customer_group_id = $('#psr_customer_group_id').val();
                                        },
                                    },
                                    columns: [
                                        { data: 'product_name', name: 'p.name' },
                                        { data: 'sub_sku', name: 'v.sub_sku' },
                                        { data: 'current_stock', name: 'current_stock', searchable: false },
                                        { data: 'total_qty_sold', name: 'total_qty_sold', searchable: false },
                                        { data: 'total_modal', name: 'total_modal', searchable: false, orderable: false }, // Dihitung di PHP
                                        { data: 'total_omset', name: 'total_omset', searchable: false },
                                        { data: 'total_margin', name: 'total_margin', searchable: false },
                                        { data: 'avg_modal', name: 'avg_modal_raw', searchable: false }, // Sort by SQL raw
                                        { data: 'avg_omset', name: 'avg_omset', searchable: false, orderable: false }, // Dihitung di PHP
                                        { data: 'rekomendasi_beli', name: 'rekomendasi_beli_raw', searchable: false }, // Sort by SQL raw
                                        { data: 'anggaran', name: 'anggaran_raw', searchable: false } // Sort by SQL raw
                                    ],
                                    fnDrawCallback: function(oSettings) {
                                        
                                        $('#footer_total_reordering_sold').html(
                                            __sum_stock($('#product_sell_reordering_point_table'), 'sell_qty')
                                        );

                                        var total_modal = sum_table_col($('#product_sell_reordering_point_table'), 'total_modal');
                                        var total_omset = sum_table_col($('#product_sell_reordering_point_table'), 'total_omset');
                                        var total_margin = sum_table_col($('#product_sell_reordering_point_table'), 'total_margin');

                                        $('#footer_reordering_modal').text(total_modal);
                                        $('#footer_reordering_omset').text(total_omset);
                                        $('#footer_reordering_margin').text(total_margin);

                                        var avg_modal_percent = 0;
                                        if (total_modal != 0) {
                                            avg_modal_percent = (total_margin / total_modal) * 100;
                                        }
                                        $('#footer_reordering_avg_modal_percent').html(__number_f(avg_modal_percent) + ' %');

                                        // --- TAMBAHAN FOOTER BARU ---
                                        $('#footer_reordering_rekomendasi').html(
                                            __sum_stock($('#product_sell_reordering_point_table'), 'rekomendasi_beli')
                                        );
                                        // Targetkan span 'footer_reordering_anggaran' dan isi dengan hasil sum_table_col
                                        $('#footer_reordering_anggaran').text( 
                                            sum_table_col($('#product_sell_reordering_point_table'), 'anggaran') 
                                        );
                                        // --- AKHIR TAMBAHAN FOOTER ---

                                        __currency_convert_recursively($('#product_sell_reordering_point_table'));
                                    },
                                });
                        } else {
                            product_sell_reordering_point_datatable.ajax.reload();
                        }
                    }
                    // --- AKHIR TAB: REORDERING POINT ---
            });

            // --- TRIGGER TAB AKTIF SAAT PERTAMA KALI LOAD (PENTING!) ---
            $('.nav-tabs li.active').find('a[data-toggle="tab"]').trigger('shown.bs.tab');

        });
    </script>
@endsection