@extends('layouts.app')
@section('title', __('report.profit_loss'))

@section('content')

    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('report.profit_loss')
        </h1>
    </section>

    <section class="content">
        <div class="print_section">
            <h2>{{ session()->get('business.name') }} - @lang('report.profit_loss')</h2>
        </div>

        <div class="row no-print">
            <div class="col-md-3 col-md-offset-7 col-xs-6">
                <div class="input-group">
                    <span class="input-group-addon bg-light-blue"><i class="fa fa-map-marker"></i></span>
                    <select class="form-control select2" id="profit_loss_location_filter">
                        @foreach ($business_locations as $key => $value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-2 col-xs-6">
                <div class="form-group pull-right">
                    <div class="input-group">
                        <button type="button" class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm" id="profit_loss_date_filter">
                            <span>
                                <i class="fa fa-calendar"></i> {{ __('messages.filter_by_date') }}
                            </span>
                            <i class="fa fa-caret-down"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div id="pl_data_div">
            </div>
        </div>


        <div class="row no-print">
            <div class="col-sm-12 tw-mb-2">
                <button class="tw-dw-btn tw-dw-btn-primary tw-text-white pull-right" aria-label="Print"
                    onclick="window.print();">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="icon icon-tabler icons-tabler-outline icon-tabler-printer">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <path d="M17 17h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2" />
                        <path d="M17 9v-4a2 2 0 0 0 -2 -2h-6a2 2 0 0 0 -2 2v4" />
                        <path d="M7 13m0 2a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2z" />
                    </svg> @lang('messages.print')
                </button>
            </div>
        </div>
        <div class="row no-print">
            <div class="col-md-12">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#profit_by_products" data-toggle="tab" aria-expanded="true"><i class="fa fa-cubes"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_products')</a>
                        </li>

                        <li>
                            <a href="#profit_by_categories" data-toggle="tab" aria-expanded="true"><i class="fa fa-tags"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_categories')</a>
                        </li>

                        <li>
                            <a href="#profit_by_brands" data-toggle="tab" aria-expanded="true"><i class="fas fa-gem"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_brands')</a>
                        </li>

                        <li>
                            <a href="#profit_by_locations" data-toggle="tab" aria-expanded="true"><i
                                    class="fa fa-map-marker" aria-hidden="true"></i> @lang('lang_v1.profit_by_locations')</a>
                        </li>

                        <li>
                            <a href="#profit_by_invoice" data-toggle="tab" aria-expanded="true"><i class="fa fa-file-alt"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_invoice')</a>
                        </li>

                        <li>
                            <a href="#profit_by_date" data-toggle="tab" aria-expanded="true"><i class="fa fa-calendar"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_date')</a>
                        </li>
                        <li>
                            <a href="#profit_by_customer" data-toggle="tab" aria-expanded="true"><i class="fa fa-user"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_customer')</a>
                        </li>
                        <li>
                            <a href="#profit_by_day" data-toggle="tab" aria-expanded="true"><i class="fa fa-calendar"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_day')</a>
                        </li>
                        <li>
                            <a href="#profit_by_service_staff" data-toggle="tab" aria-expanded="true"><i class="fa fa-user-secret"
                                    aria-hidden="true"></i> @lang('lang_v1.profit_by_service_staff')</a>
                        </li>
                        
                        {{-- TAB BARU - Tabel Peringkat Staf --}}
                        <li>
                            <a href="#service_staff_chart" data-toggle="tab" aria-expanded="true"><i class="fas fa-trophy"
                                    aria-hidden="true"></i> @lang('lang_v1.staff_rank_table')</a>
                        </li>
                        {{-- AKHIR TAB BARU --}}

                        <li>
                                <a href="#profit_chart" data-toggle="tab" aria-expanded="true"><i class="fas fa-chart-line"
                                        aria-hidden="true"></i> @lang('lang_v1.profit_chart')</a>
                        </li>
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="profit_by_products">
                            @include('report.partials.profit_by_products')
                        </div>

                        <div class="tab-pane" id="profit_by_categories">
                            @include('report.partials.profit_by_categories')
                        </div>

                        <div class="tab-pane" id="profit_by_brands">
                            @include('report.partials.profit_by_brands')
                        </div>

                        <div class="tab-pane" id="profit_by_locations">
                            @include('report.partials.profit_by_locations')
                        </div>

                        <div class="tab-pane" id="profit_by_invoice">
                            @include('report.partials.profit_by_invoice')
                        </div>

                        <div class="tab-pane" id="profit_by_date">
                            @include('report.partials.profit_by_date')
                        </div>

                        <div class="tab-pane" id="profit_by_customer">
                            @include('report.partials.profit_by_customer')
                        </div>
                        <div class="tab-pane" id="profit_by_service_staff">
                            @include('report.partials.profit_by_service_staff')
                        </div>

                        {{-- KONTEN TAB BARU - Tabel Peringkat Staf --}}
                        <div class="tab-pane" id="service_staff_chart">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="staff_rank_table"> 
                                    <thead>
                                        <tr>
                                            <th>@lang('lang_v1.rank')</th>
                                            <th>@lang('lang_v1.jan')</th>
                                            <th>@lang('lang_v1.feb')</th>
                                            <th>@lang('lang_v1.mar')</th>
                                            <th>@lang('lang_v1.apr')</th>
                                            <th>@lang('lang_v1.may')</th>
                                            <th>@lang('lang_v1.jun')</th>
                                            <th>@lang('lang_v1.jul')</th>
                                            <th>@lang('lang_v1.aug')</th>
                                            <th>@lang('lang_v1.sep')</th>
                                            <th>@lang('lang_v1.oct')</th>
                                            <th>@lang('lang_v1.nov')</th>
                                            <th>@lang('lang_v1.dec')</th>
                                        </tr>
                                    </thead>
                                    <tfoot class="bg-gray font-17 footer-total">
                                        <tr>
                                            <th>@lang('sale.total'):</th>
                                            <td></td> {{-- Jan --}}
                                            <td></td> {{-- Feb --}}
                                            <td></td> {{-- Mar --}}
                                            <td></td> {{-- Apr --}}
                                            <td></td> {{-- May --}}
                                            <td></td> {{-- Jun --}}
                                            <td></td> {{-- Jul --}}
                                            <td></td> {{-- Aug --}}
                                            <td></td> {{-- Sep --}}
                                            <td></td> {{-- Oct --}}
                                            <td></td> {{-- Nov --}}
                                            <td></td> {{-- Dec --}}
                                        </tr>
                                    </tfoot>
                                    <tbody> 
                                        {{-- biarkan tbody kosong, DataTables akan mengisinya --}}
                                    </tbody> 
                                </table>
                            </div>
                        </div>
                        {{-- AKHIR KONTEN TAB BARU --}}

                        <div class="tab-pane" id="profit_chart">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="box box-primary">
                                            <div class="box-body">
                                                <canvas id="profitLossChart" style="min-height: 300px;"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <div class="tab-pane" id="profit_by_day">

                        </div>
                    </div>
                </div>
            </div>
        </div>


    </section>
    @stop
@section('javascript')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.1/chart.min.js"></script>
    
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>

    <script type="text/javascript">
        /* global $, Chart, __currency_trans_from_en, sum_table_col, __currency_convert_recursively */
        $(document).ready(function() {
            // --- DEKLARASI SEMUA VARIABEL TABEL ---
            var profit_by_products_table,
                profit_by_categories_datatable,
                profit_by_brands_datatable,
                profit_by_locations_datatable,
                profit_by_invoice_datatable,
                profit_by_date_datatable,
                profit_by_customers_table,
                profit_by_service_staffs_table,
                profit_by_days_table,
                staff_rank_table, // <-- Variabel untuk tabel peringkat baru
                profit_loss_chart_instance;
            // ---------------------------------------

            profit_by_products_table = $('#profit_by_products_table').DataTable({
                processing: true,
                serverSide: true,
                fixedHeader: false,
                "ajax": {
                    "url": "/reports/get-profit/product",
                    "data": function(d) {
                        d.start_date = $('#profit_loss_date_filter')
                            .data('daterangepicker')
                            .startDate.format('YYYY-MM-DD');
                        d.end_date = $('#profit_loss_date_filter')
                            .data('daterangepicker')
                            .endDate.format('YYYY-MM-DD');
                        d.location_id = $('#profit_loss_location_filter').val();
                    }
                },
                columns: [{
                        data: 'product',
                        name: 'product'
                    },
                    {
                        data: 'gross_profit',
                        "searchable": false
                    },
                ],
                footerCallback: function(row, data, start, end, display) {
                    var total_profit = 0;
                    for (var r in data) {
                        total_profit += $(data[r].gross_profit).data('orig-value') ?
                            parseFloat($(data[r].gross_profit).data('orig-value')) : 0;
                    }

                    $('#profit_by_products_table .footer_total').html(__currency_trans_from_en(
                        total_profit));
                }
            });

            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                var target = $(e.target).attr('href');
                if (target == '#profit_by_categories') {
                    if (typeof profit_by_categories_datatable == 'undefined') {
                        profit_by_categories_datatable = $('#profit_by_categories_table').DataTable({
                            processing: true,
                            serverSide: true,
                            fixedHeader: false,
                            "ajax": {
                                "url": "/reports/get-profit/category",
                                "data": function(d) {
                                    d.start_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .startDate.format('YYYY-MM-DD');
                                    d.end_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .endDate.format('YYYY-MM-DD');
                                    d.location_id = $('#profit_loss_location_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'category',
                                    name: 'C.name'
                                },
                                {
                                    data: 'gross_profit',
                                    "searchable": false
                                },
                            ],
                            footerCallback: function(row, data, start, end, display) {
                                var total_profit = 0;
                                for (var r in data) {
                                    total_profit += $(data[r].gross_profit).data('orig-value') ?
                                        parseFloat($(data[r].gross_profit).data('orig-value')) :
                                        0;
                                }

                                $('#profit_by_categories_table .footer_total').html(
                                    __currency_trans_from_en(total_profit));
                            },
                        });
                    } else {
                        profit_by_categories_datatable.ajax.reload();
                    }
                } else if (target == '#profit_by_brands') {
                    if (typeof profit_by_brands_datatable == 'undefined') {
                        profit_by_brands_datatable = $('#profit_by_brands_table').DataTable({
                            processing: true,
                            serverSide: true,
                            fixedHeader: false,
                            "ajax": {
                                "url": "/reports/get-profit/brand",
                                "data": function(d) {
                                    d.start_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .startDate.format('YYYY-MM-DD');
                                    d.end_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .endDate.format('YYYY-MM-DD');
                                    d.location_id = $('#profit_loss_location_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'brand',
                                    name: 'B.name'
                                },
                                {
                                    data: 'gross_profit',
                                    "searchable": false
                                },
                            ],
                            footerCallback: function(row, data, start, end, display) {
                                var total_profit = 0;
                                for (var r in data) {
                                    total_profit += $(data[r].gross_profit).data('orig-value') ?
                                        parseFloat($(data[r].gross_profit).data('orig-value')) :
                                        0;
                                }

                                $('#profit_by_brands_table .footer_total').html(
                                    __currency_trans_from_en(total_profit));
                            },
                        });
                    } else {
                        profit_by_brands_datatable.ajax.reload();
                    }
                } else if (target == '#profit_by_locations') {
                    if (typeof profit_by_locations_datatable == 'undefined') {
                        profit_by_locations_datatable = $('#profit_by_locations_table').DataTable({
                            processing: true,
                            serverSide: true,
                            fixedHeader: false,
                            "ajax": {
                                "url": "/reports/get-profit/location",
                                "data": function(d) {
                                    d.start_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .startDate.format('YYYY-MM-DD');
                                    d.end_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .endDate.format('YYYY-MM-DD');
                                    d.location_id = $('#profit_loss_location_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'location',
                                    name: 'L.name'
                                },
                                {
                                    data: 'gross_profit',
                                    "searchable": false
                                },
                            ],
                            footerCallback: function(row, data, start, end, display) {
                                var total_profit = 0;
                                for (var r in data) {
                                    total_profit += $(data[r].gross_profit).data('orig-value') ?
                                        parseFloat($(data[r].gross_profit).data('orig-value')) :
                                        0;
                                }

                                $('#profit_by_locations_table .footer_total').html(
                                    __currency_trans_from_en(total_profit));
                            },
                        });
                    } else {
                        profit_by_locations_datatable.ajax.reload();
                    }

                } else if (target == '#profit_by_invoice') {
                    if (typeof profit_by_invoice_datatable == 'undefined') {
                        profit_by_invoice_datatable = $('#profit_by_invoice_table').DataTable({
                            processing: true,
                            serverSide: true,
                            fixedHeader: false,
                            "ajax": {
                                "url": "/reports/get-profit/invoice",
                                "data": function(d) {
                                    d.start_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .startDate.format('YYYY-MM-DD');
                                    d.end_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .endDate.format('YYYY-MM-DD');
                                    d.location_id = $('#profit_loss_location_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'invoice_no',
                                    name: 'sale.invoice_no'
                                },
                                {
                                    data: 'service_staff_name',
                                    name: 'users.first_name'
                                },
                                {
                                    data: 'gross_profit',
                                    "searchable": false
                                }
                            ],
                            footerCallback: function(row, data, start, end, display) {
                                var total_profit = 0;
                                for (var r in data) {
                                    total_profit += $(data[r].gross_profit).data('orig-value') ?
                                        parseFloat($(data[r].gross_profit).data('orig-value')) :
                                        0;
                                }

                                $('#profit_by_invoice_table .footer_total').html(
                                    __currency_trans_from_en(total_profit));
                            },
                        });
                    } else {
                        profit_by_invoice_datatable.ajax.reload();
                    }

                } else if (target == '#profit_by_date') {
                    if (typeof profit_by_date_datatable == 'undefined') {
                        profit_by_date_datatable = $('#profit_by_date_table').DataTable({
                            processing: true,
                            serverSide: true,
                            fixedHeader: false,
                            "ajax": {
                                "url": "/reports/get-profit/date",
                                "data": function(d) {
                                    d.start_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .startDate.format('YYYY-MM-DD');
                                    d.end_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .endDate.format('YYYY-MM-DD');
                                    d.location_id = $('#profit_loss_location_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'transaction_date',
                                    name: 'sale.transaction_date'
                                },
                                {
                                    data: 'gross_profit',
                                    "searchable": false
                                },
                            ],
                            footerCallback: function(row, data, start, end, display) {
                                var total_profit = 0;
                                for (var r in data) {
                                    total_profit += $(data[r].gross_profit).data('orig-value') ?
                                        parseFloat($(data[r].gross_profit).data('orig-value')) :
                                        0;
                                }

                                $('#profit_by_date_table .footer_total').html(
                                    __currency_trans_from_en(total_profit));
                            },
                        });
                    } else {
                        profit_by_date_datatable.ajax.reload();
                    }
                } else if (target == '#profit_by_customer') {
                    if (typeof profit_by_customers_table == 'undefined') {
                        profit_by_customers_table = $('#profit_by_customer_table').DataTable({
                            processing: true,
                            serverSide: true,
                            fixedHeader: false,
                            "ajax": {
                                "url": "/reports/get-profit/customer",
                                "data": function(d) {
                                    d.start_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .startDate.format('YYYY-MM-DD');
                                    d.end_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .endDate.format('YYYY-MM-DD');
                                    d.location_id = $('#profit_loss_location_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'customer',
                                    name: 'CU.name'
                                },
                                {
                                    data: 'gross_profit',
                                    "searchable": false
                                },
                            ],
                            footerCallback: function(row, data, start, end, display) {
                                var total_profit = 0;
                                for (var r in data) {
                                    total_profit += $(data[r].gross_profit).data('orig-value') ?
                                        parseFloat($(data[r].gross_profit).data('orig-value')) :
                                        0;
                                }

                                $('#profit_by_customer_table .footer_total').html(
                                    __currency_trans_from_en(total_profit));
                            },
                        });
                    } else {
                        profit_by_customers_table.ajax.reload();
                    }
                } else if (target == '#profit_by_service_staff') {
                    if (typeof profit_by_service_staffs_table == 'undefined') {

                        profit_by_service_staffs_table = $('#profit_by_service_staff_table').DataTable({
                            processing: true,
                            serverSide: true,
                            fixedHeader: false,
                            "ajax": {
                                "url": "/reports/get-profit/service_staff",
                                "data": function(d) {
                                    d.start_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .startDate.format('YYYY-MM-DD');
                                    d.end_date = $('#profit_loss_date_filter')
                                        .data('daterangepicker')
                                        .endDate.format('YYYY-MM-DD');
                                    d.location_id = $('#profit_loss_location_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'staff_name',
                                    name: 'U.first_name' // Nama staf akan di-bold oleh Controller
                                },
                                {
                                    data: 'gross_profit',
                                    "searchable": false
                                },
                            ],
                            footerCallback: function(row, data, start, end, display) {
                                var total_profit = 0;
                                for (var r in data) {
                                    total_profit += $(data[r].gross_profit).data('orig-value') ?
                                        parseFloat($(data[r].gross_profit).data('orig-value')) :
                                        0;
                                }

                                $('#profit_by_service_staff_table .footer_total').html(
                                    __currency_trans_from_en(total_profit));
                            },
                        });
                    } else {
                        profit_by_service_staffs_table.ajax.reload();
                    }
                } else if (target == '#profit_by_day') {
                    var start_date = $('#profit_loss_date_filter')
                        .data('daterangepicker')
                        .startDate.format('YYYY-MM-DD');

                    var end_date = $('#profit_loss_date_filter')
                        .data('daterangepicker')
                        .endDate.format('YYYY-MM-DD');
                    var location_id = $('#profit_loss_location_filter').val();

                    var url = '/reports/get-profit/day?start_date=' + start_date + '&end_date=' + end_date +
                        '&location_id=' + location_id;
                    $.ajax({
                        url: url,
                        dataType: 'html',
                        success: function(result) {
                            $('#profit_by_day').html(result);
                            profit_by_days_table = $('#profit_by_day_table').DataTable({
                                "searching": false,
                                'paging': false,
                                'ordering': false,
                            });
                            var total_profit = sum_table_col($('#profit_by_day_table'),
                                'gross-profit');
                            $('#profit_by_day_table .footer_total').text(total_profit);
                            __currency_convert_recursively($('#profit_by_day_table'));
                        },
                    });

                // ================= VVV BLOK BARU UNTUK TABEL PERINGKAT STAF VVV =================
                } else if (target == '#service_staff_chart') {
                    
                    // 1. Hancurkan tabel lama jika ada (untuk refresh data)
                    if ($.fn.DataTable.isDataTable('#staff_rank_table')) {
                        staff_rank_table.destroy();
                        $('#staff_rank_table tbody').empty(); // Kosongkan body
                    }

                    // 2. Tampilkan loader (opsional tapi disarankan)
                    $('#staff_rank_table tbody').html(
                        '<tr><td colspan="13" class="text-center"><i class="fa fa-refresh fa-spin"></i> Loading...</td></tr>'
                    );

                    // 3. Ambil data mentah dari endpoint baru kita
                    var location_id = $('#profit_loss_location_filter').val();
                    $.ajax({
                        url: "/reports/get-service-staff-monthly-data", // Endpoint baru
                        dataType: 'json',
                        data: { location_id: location_id },
                        success: function(all_data) {
                            
                            // 4. Proses data di JavaScript untuk diputar (pivot)
                            let dataByMonth = {};
                            let maxRank = 0;
                            for (let m = 1; m <= 12; m++) {
                                dataByMonth[m] = [];
                            }

                            // Kelompokkan data per bulan
                            all_data.forEach(item => {
                                // Hanya tambahkan jika profit > 0
                                if (item.total_gross_profit > 0) {
                                    dataByMonth[item.month].push({
                                        name: item.staff_name,
                                        profit: parseFloat(item.total_gross_profit)
                                    });
                                }
                            });

                            // Sortir setiap bulan & cari jumlah rank terbanyak
                            for (let m = 1; m <= 12; m++) {
                                dataByMonth[m].sort((a, b) => b.profit - a.profit); // Sort descending
                                if (dataByMonth[m].length > maxRank) {
                                    maxRank = dataByMonth[m].length;
                                }
                            }

                            // 5. Bangun data untuk DataTables
                            let tableData = [];
                            for (let r = 0; r < maxRank; r++) { // 'r' adalah rank (index 0 = Rank 1)
                                let rowData = {
                                    rank: r + 1,
                                    1: dataByMonth[1][r] || null, // data Jan, rank 'r'
                                    2: dataByMonth[2][r] || null, // data Feb, rank 'r'
                                    3: dataByMonth[3][r] || null,
                                    4: dataByMonth[4][r] || null,
                                    5: dataByMonth[5][r] || null,
                                    6: dataByMonth[6][r] || null,
                                    7: dataByMonth[7][r] || null,
                                    8: dataByMonth[8][r] || null,
                                    9: dataByMonth[9][r] || null,
                                    10: dataByMonth[10][r] || null,
                                    11: dataByMonth[11][r] || null,
                                    12: dataByMonth[12][r] || null
                                };
                                tableData.push(rowData);
                            }

                            // 6. Inisialisasi DataTables (Client-Side)
                            staff_rank_table = $('#staff_rank_table').DataTable({
                                data: tableData, // Data dari JS, bukan server
                                destroy: true, // Pastikan tabel lama dihancurkan
                                paging: false,   // Tampilkan semua rank
                                info: false,
                                searching: false,
                                ordering: true,  // Izinkan sorting
                                order: [],       // Urutan default (berdasarkan Rank)
                                columns: [
                                    { data: 'rank', orderable: false }, // Kolom Rank
                                    { data: '1' }, { data: '2' }, { data: '3' },
                                    { data: '4' }, { data: '5' }, { data: '6' },
                                    { data: '7' }, { data: '8' }, { data: '9' },
                                    { data: '10' }, { data: '11' }, { data: '12' }
                                ],
                                columnDefs: [
                                    {
                                        // Target semua kolom bulan (index 1 s/d 12)
                                        targets: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12], 
                                        render: function(data, type, row) {
                                            // 'data' adalah objek {name, profit} atau null
                                            
                                            // Untuk sorting (order), gunakan nilai profit mentah
                                            if (type === 'order') {
                                                return data ? data.profit : 0;
                                            }
                                            
                                            // Untuk tampilan (display)
                                            if (data) {
                                                // Format baru: <strong>Nama</strong> <br> Profit
                                                return `<strong>${data.name}</strong> <br> ${__currency_trans_from_en(data.profit)}`; 
                                            }
                                            
                                            return ''; // Kembalikan string kosong jika data null
                                        }
                                    }
                                ],
                                footerCallback: function(tfoot, data, start, end, display) {
                                    var api = this.api();

                                    // Iterasi 12 bulan (kolom 1 s/d 12)
                                    for (let m = 1; m <= 12; m++) {
                                        
                                        // Ambil semua data untuk kolom ini
                                        let colData = api.column(m).data(); 

                                        // Hitung total profit
                                        let total = colData.reduce(function (a, b) {
                                            // 'b' adalah data sel: {name, profit} or null
                                            return a + (b ? b.profit : 0);
                                        }, 0);

                                        // Update footer (tfoot) di kolom yang sesuai
                                        $(api.column(m).footer()).html(__currency_trans_from_en(total));
                                    }
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            console.error("Error fetching service staff pivot data: " + error);
                            // Tampilkan error di tabel
                            $('#staff_rank_table tbody').html(
                                '<tr><td colspan="13" class="text-center text-danger">Gagal memuat data.</td></tr>'
                            );
                        }
                    });
                // ================= ^^^ AKHIR BLOK BARU ^^^ =================

                } else if (target == '#profit_chart') {

                    var location_id = $('#profit_loss_location_filter').val();
                    // Tambahkan timestamp unik untuk cache-busting
                    var url = '/reports/get-profit-chart-data?location_id=' + location_id + '&v=' + new Date().getTime();

                    $.ajax({
                        url: url,
                        dataType: 'json',
                        success: function(data) {

                            if (profit_loss_chart_instance) {
                                profit_loss_chart_instance.destroy();
                            }

                            var ctx = document.getElementById('profitLossChart').getContext('2d');
                            
                            profit_loss_chart_instance = new Chart(ctx, {
                                type: 'line', 
                                data: {
                                    labels: data.labels, 
                                    datasets: [
                                        {
                                            label: 'Omzet',
                                            data: data.omzet_data, 
                                            borderColor: 'rgba(54, 162, 235, 1)', 
                                            backgroundColor: 'rgba(54, 162, 235, 0.2)',
                                            borderWidth: 2,
                                            tension: 0.1
                                        },
                                        {
                                            label: 'Gross Profit',
                                            data: data.gross_profit_data,
                                            borderColor: 'rgba(75, 192, 192, 1)', 
                                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                                            borderWidth: 2,
                                            tension: 0.1
                                        },
                                        {
                                            label: 'Net Profit',
                                            data: data.net_profit_data,
                                            borderColor: 'rgba(153, 255, 153, 1)', 
                                            backgroundColor: 'rgba(153, 255, 153, 0.2)',
                                            borderWidth: 2,
                                            tension: 0.1
                                        },
                                        {
                                            label: 'COGS',
                                            data: data.cogs_data,
                                            borderColor: 'rgba(255, 99, 132, 1)', 
                                            backgroundColor: 'rgba(255, 99, 132, 0.2)',
                                            borderWidth: 2,
                                            tension: 0.1
                                        },
                                        {
                                            label: 'Biaya',
                                            data: data.biaya_data,
                                            borderColor: 'rgba(255, 206, 86, 1)', 
                                            backgroundColor: 'rgba(255, 206, 86, 0.2)',
                                            borderWidth: 2,
                                            tension: 0.1
                                        }
                                    ]
                                },
                                options: {
                                    responsive: true,
                                    maintainAspectRatio: false,
                                    scales: {
                                        y: {
                                            beginAtZero: true,
                                            ticks: {
                                                callback: function(value, index, values) {
                                                    return __currency_trans_from_en(value, true);
                                                }
                                            }
                                        }
                                    }
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            console.error("Error fetching chart data: " + error);
                        }
                    });

                } else if (target == '#profit_by_products') {
                    profit_by_products_table.ajax.reload();
                }
            });
        });
    </script>

@endsection