
<?php $__env->startSection('title', __('assetmanagement::lang.assets')); ?>
<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('assetmanagement::layouts.nav')) echo $__env->make('assetmanagement::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content no-print">
        <div class="row">
            <div class="col-md-4">
                <?php $__env->startComponent('components.static', [
                    'svg_bg' => 'tw-bg-cyan-400',
                    'svg_text' => 'tw-text-white',
                    'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-package-import"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 21l-8 -4.5v-9l8 -4.5l8 4.5v4.5" /><path d="M12 12l8 -4.5" /><path d="M12 12v9" /><path d="M12 12l-8 -4.5" /><path d="M22 18h-7" /><path d="M18 15l-3 3l3 3" /></svg>',
                ]); ?>
                    <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                        <?php echo e(__('assetmanagement::lang.total_assets_allocated_to_you'), false); ?>

                    </p>
                    <p class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                        <?php echo e(number_format($total_assets_allocated, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>

                    </p>
                <?php echo $__env->renderComponent(); ?>
            </div>

            <div class="col-md-4">
                <?php $__env->startComponent('components.widget', [
                    'class' => '',
                    'title' => __('assetmanagement::lang.expired_or_expiring_in_one_month'),
                ]); ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('product.category'); ?></th>
                                <th><?php echo app('translator')->get('assetmanagement::lang.total_assets_allocated_to_you'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $asset_allocation_by_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($asset->category, false); ?></td>
                                    <td><?php echo e(number_format($asset->total_quantity_allocated, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if(count($asset_allocation_by_category) == 0): ?>
                                <tr>
                                    <td colspan="2" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>

        <?php if($is_admin): ?>
            <hr>
            <div class="row">
                <div class="col-md-4">
                    <?php $__env->startComponent('components.static', [
                        'svg_bg' => 'tw-bg-cyan-400',
                    'svg_text' => 'tw-text-white',
                        'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-package-import"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 21l-8 -4.5v-9l8 -4.5l8 4.5v4.5" /><path d="M12 12l8 -4.5" /><path d="M12 12v9" /><path d="M12 12l-8 -4.5" /><path d="M22 18h-7" /><path d="M18 15l-3 3l3 3" /></svg>',
                    ]); ?>
                        <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                            <?php echo e(__('assetmanagement::lang.total_assets'), false); ?>

                        </p>
                        <p
                            class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                            <?php echo e(number_format($total_assets, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>

                        </p>
                    <?php echo $__env->renderComponent(); ?>
                    <?php $__env->startComponent('components.static', [
                    'svg_bg' => 'tw-bg-cyan-400',
                    'svg_text' => 'tw-text-white',
                        'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-package-import"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 21l-8 -4.5v-9l8 -4.5l8 4.5v4.5" /><path d="M12 12l8 -4.5" /><path d="M12 12v9" /><path d="M12 12l-8 -4.5" /><path d="M22 18h-7" /><path d="M18 15l-3 3l3 3" /></svg>',
                    ]); ?>
                        <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                            <?php echo e(__('assetmanagement::lang.total_assets_allocated'), false); ?>

                        </p>
                        <p
                            class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                            <?php echo e(number_format($total_assets_allocated_for_all_users, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>

                        </p>
                    <?php echo $__env->renderComponent(); ?>
                </div>

                <div class="col-md-4">
                    <?php $__env->startComponent('components.widget', [
                        'class' => '',
                        'title' => __('assetmanagement::lang.assets_by_category'),
                    ]); ?>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('product.category'); ?></th>
                                    <th><?php echo app('translator')->get('assetmanagement::lang.total_assets'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $assets_by_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($asset->category, false); ?></td>
                                        <td><?php echo e(number_format($asset->total_quantity, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php if(count($assets_by_category) == 0): ?>
                                    <tr>
                                        <td colspan="2" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    <?php echo $__env->renderComponent(); ?>
                </div>

                <div class="col-md-4">
                    <?php $__env->startComponent('components.widget', [
                        'class' => '',
                        'title' => __('assetmanagement::lang.expired_or_expiring_in_one_month'),
                    ]); ?>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('assetmanagement::lang.assets'); ?></th>
                                    <th><?php echo app('translator')->get('assetmanagement::lang.warranty_status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expiring_assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($asset->name, false); ?> - <?php echo e($asset->asset_code, false); ?></td>
                                        <td>
                                            <?php if(empty($asset->max_end_date)): ?>
                                                <span class="label bg-red"><?php echo app('translator')->get('report.expired'); ?></span>
                                            <?php else: ?>
                                                <?php if(\Carbon\Carbon::parse($asset->max_end_date)->lessThan(\Carbon\Carbon::today())): ?>
                                                    <span class="label bg-red"><?php echo app('translator')->get('report.expired'); ?>:
                                                        <?php echo e(\Carbon::createFromTimestamp(strtotime($asset->max_end_date))->format(session('business.date_format')), false); ?></span>
                                                <?php else: ?>
                                                    <span class="label bg-yellow"><?php echo app('translator')->get('assetmanagement::lang.expiring_on'); ?>:
                                                        <?php echo e(\Carbon::createFromTimestamp(strtotime($asset->max_end_date))->format(session('business.date_format')), false); ?></span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php if(count($expiring_assets) == 0): ?>
                                    <tr>
                                        <td colspan="2" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table>
                    <?php echo $__env->renderComponent(); ?>
                </div>


            </div>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/AssetManagement/Providers/../Resources/views/asset/dashboard.blade.php ENDPATH**/ ?>