
<?php $__env->startSection('title', __('messages.settings')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('hms::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Custom Tabs -->
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('messages.settings') . ':']); ?>
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#cn_1" data-toggle="tab" aria-expanded="true">
                            <?php echo app('translator')->get('hms::lang.booking_prefix'); ?>
                        </a>
                    </li>
                    <li class="">
                        <a href="#cn_2" data-toggle="tab" aria-expanded="true">
                            <?php echo app('translator')->get('lang_v1.customer_notifications'); ?>
                        </a>
                    </li>
                    <li class="">
                        <a href="#cn_3" data-toggle="tab" aria-expanded="true">
                            <?php echo app('translator')->get('hms::lang.print_pdf'); ?>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="cn_1">
                        <div class="row">
                            <div class="box-body">
                                <?php echo Form::open([
                                    'url' => action([\Modules\Hms\Http\Controllers\HmsSettingController::class, 'store']),
                                    'method' => 'post',
                                    'id' => 'hms_setting',
                                    'files' => true,
                                ]); ?>

                                <?php
                                    $settings = json_decode($busines->hms_settings);
                                ?>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php echo Form::label('booking_prefix', __('hms::lang.booking_prefix') . '*'); ?>

                                        <?php echo Form::text('booking_prefix', $settings->prefix ?? null, [
                                            'class' => 'form-control',
                                            'required',
                                            'placeholder' => __('hms::lang.booking_prefix'),
                                        ]); ?>

                                    </div>
                                </div>
                                <div class="col-md-12 text-center">
                                    <?php echo Form::submit(__('messages.submit'), ['class' => 'tw-dw-btn tw-dw-btn-success tw-text-white tw-dw-btn-lg']); ?>

                                </div>
                
                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="cn_2">
                        <h3><?php echo app('translator')->get('hms::lang.new_booking'); ?></h3>
                        <div class="row">
                            <?php echo Form::open([
                                'url' => action([\Modules\Hms\Http\Controllers\HmsSettingController::class, 'store_email_template']),
                                'method' => 'post',
                            ]); ?>

                            <div class="col-md-12">
                                <strong><?php echo app('translator')->get('lang_v1.available_tags'); ?>:</strong>
                                <p class="help-block">
                                    <?php echo e(implode(', ', $tags), false); ?>

                                </p>
                            </div>
                            <div class="col-md-12 mt-10">
                                <div class="form-group">
                                    <?php echo Form::label('subject', __('lang_v1.email_subject') . ':'); ?>

                                    <?php echo Form::text('subject', empty($template->subject) ? null : $template->subject, [
                                        'class' => 'form-control',
                                        'placeholder' => __('lang_v1.email_subject'),
                                        'id' => 'subject',
                                    ]); ?>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?php echo Form::label('cc', 'CC:'); ?>

                                    <?php echo Form::email('cc', empty($template->cc) ? null : $template->cc, [
                                        'class' => 'form-control',
                                        'placeholder' => 'CC',
                                        'id' => 'cc',
                                    ]); ?>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?php echo Form::label('bcc', 'BCC:'); ?>

                                    <?php echo Form::email('bcc', empty($template->bcc) ? null : $template->bcc, [
                                        'class' => 'form-control',
                                        'placeholder' => 'BCC',
                                        'id' => 'bcc',
                                    ]); ?>

                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <?php echo Form::label('email_body', __('lang_v1.email_body') . ':'); ?>

                                    <?php echo Form::textarea('email_body', empty($template->email_body) ? null : $template->email_body, [
                                        'class' => 'form-control ckeditor',
                                        'placeholder' => __('lang_v1.email_body'),
                                        'id' => 'email_body',
                                        'rows' => 6,
                                    ]); ?>

                                </div>
                            </div>
                            <div class="col-md-12 mt-15">
                                <label class="checkbox-inline">
                                    <?php echo Form::checkbox('auto_send', 1, empty($template->auto_send) ? null : $template->auto_send, [
                                        'class' => 'input-icheck',
                                    ]); ?> <?php echo app('translator')->get('lang_v1.autosend_email'); ?>
                                </label>
                            </div>
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <button type="submit" class="tw-dw-btn tw-dw-btn-error tw-text-white tw-dw-btn-lg"><?php echo app('translator')->get('messages.save'); ?></button>
                                </div>
                            </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                    <div class="tab-pane" id="cn_3">
                            <div class="row">
                                <div class="box-body">
                                    <?php echo Form::open([
                                        'url' => action([\Modules\Hms\Http\Controllers\HmsSettingController::class, 'post_pdf']),
                                        'method' => 'post',
                                        'id' => 'post_pdf',
                                        'files' => true,
                                    ]); ?>

                                    <?php
                                        $settings = json_decode($busines->hms_settings);
                                    ?>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <?php echo Form::label('footer_text', __('hms::lang.footer_text')); ?>

                                            <?php echo Form::textarea('footer_text', $settings->booking_pdf->footer_text ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('hms::lang.footer_text'),
                                            ]); ?>

                                        </div>
                                    </div>
                                    <div class="col-md-12 text-center">
                                        <?php echo Form::submit(__('messages.submit'), ['class' => 'tw-dw-btn tw-dw-btn-success tw-text-white tw-dw-btn-lg']); ?>

                                    </div>
                    
                                    <?php echo Form::close(); ?>

                                </div>
                            </div>
                    </div>
                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea#email_body',
        });
        tinymce.init({
            selector: 'textarea#footer_text',
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Hms/Resources/views/settings/index.blade.php ENDPATH**/ ?>