
<?php $__env->startSection('title', __('repair::lang.repair')); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('repair::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('repair::lang.invoices'); ?>
    </h1>
</section>

<section class="content no-print">
    <?php $__env->startComponent('components.filters', ['title' => __('report.filters'), 'closed' => false]); ?>
        <?php echo $__env->make('sell.partials.sell_list_filters', ['only' => ['sell_list_filter_location_id', 'sell_list_filter_customer_id', 'sell_list_filter_payment_status', 'sell_list_filter_date_range', 'created_by']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="col-md-3">
            <div class="form-group">
                <?php echo Form::label('repair_status_id',  __('sale.status') . ':'); ?>

                <?php echo Form::select('repair_status_id', $repair_status_dropdown['statuses'], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')]); ?>

            </div>
        </div>
        <?php if(in_array('service_staff' ,$enabled_modules)): ?>
        <div class="col-md-3">
            <div class="form-group">
                <?php echo Form::label('service_staff_id',  __('repair::lang.technician') . ':'); ?>

                <?php echo Form::select('service_staff_id', $service_staffs, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')]); ?>

            </div>
        </div>
        <?php endif; ?>
    <?php echo $__env->renderComponent(); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#pending_repair_tab" data-toggle="tab" aria-expanded="true">
                            <i class="fas fa-exclamation-circle text-orange"></i>
                            <?php echo app('translator')->get('repair::lang.pending'); ?>
                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('repair::lang.common_pending_status_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                        </a>
                    </li>
                    <li>
                        <a href="#completed_repair_tab" data-toggle="tab" aria-expanded="true">
                            <i class="fa fas fa-check-circle text-success"></i>
                            <?php echo app('translator')->get('repair::lang.completed'); ?>
                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('repair::lang.common_completed_status_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                        </a>
                    </li>
                    <li>
                        <a href="#report_tab" data-toggle="tab" aria-expanded="true"> <i class="fa fas fa-chart-line text-info"></i>
                            <?php echo app('translator')->get('repair::lang.report'); ?>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="pending_repair_tab">
                        <div class="row">
                            <div class="col-md-12 mb-12">
                                <a target="_blank" class="tw-dw-btn tw-dw-btn-sm tw-dw-btn-primary tw-text-white pull-right"
                                    href="<?php echo e(action([\App\Http\Controllers\SellPosController::class, 'create']). '?sub_type=repair', false); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M12 5l0 14" />
                                        <path d="M5 12l14 0" />
                                    </svg> <?php echo app('translator')->get('messages.add'); ?>
                                </a>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped ajax_view" id="pending_repair_table">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('messages.action'); ?></th>
                                        <th><?php echo app('translator')->get('receipt.date'); ?></th>
                                        <th>
                                            <?php echo app('translator')->get('repair::lang.delivery_date'); ?>
                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('repair::lang.repair_due_date_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                        </th>
                                        <th><?php echo app('translator')->get('repair::lang.job_sheet_no'); ?></th>
                                        <th><?php echo app('translator')->get('sale.invoice_no'); ?></th>
                                        <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                                            <th><?php echo app('translator')->get('repair::lang.technician'); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo app('translator')->get('lang_v1.added_by'); ?></th>
                                        <th><?php echo app('translator')->get('sale.customer_name'); ?></th>
                                        <th><?php echo app('translator')->get('product.brand'); ?></th>
                                        <th><?php echo app('translator')->get('repair::lang.device_model'); ?></th>
                                        <th><?php echo app('translator')->get('repair::lang.serial_no'); ?></th>
                                        <th><?php echo app('translator')->get('sale.status'); ?></th>
                                        <th><?php echo app('translator')->get('sale.location'); ?></th>
                                        <th><?php echo app('translator')->get('repair::lang.repair_warranty'); ?></th>
                                        <th><?php echo app('translator')->get('sale.payment_status'); ?></th>
                                        <th><?php echo app('translator')->get('sale.total_amount'); ?></th>
                                        <th><?php echo app('translator')->get('purchase.payment_due'); ?></th>
                                        <th><?php echo app('translator')->get('lang_v1.sell_return_due'); ?></th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr class="bg-gray font-17 footer-total text-center">
                                        <td
                                            <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                                                colspan="11"
                                            <?php else: ?>
                                                colspan="10"
                                            <?php endif; ?>>
                                            <strong><?php echo app('translator')->get('sale.total'); ?>:</strong>
                                        </td>
                                        <td id="footer_pending_repair_status_count"></td>
                                        <td></td>
                                        <td></td>
                                        <td id="pending_repair_footer_payment_status_count"></td>
                                        <td>
                                            <span class="display_currency" id="pending_repair_footer_total" data-currency_symbol ="true"></span>
                                        </td>
                                        <td class="text-left">
                                            <small>
                                                <span class="display_currency" id="pending_repair_footer_total_remaining" data-currency_symbol ="true"></span>
                                            </small>
                                        </td>
                                        <td><span class="display_currency" id="pending_repair_footer_total_sell_return_due" data-currency_symbol ="true"></span></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane" id="completed_repair_tab">
                        <div class="row">
                            <div class="col-md-12 mb-12">
                                <a target="_blank" class="tw-dw-btn tw-dw-btn-sm tw-dw-btn-primary tw-text-white pull-right"
                                    href="<?php echo e(action([\App\Http\Controllers\SellPosController::class, 'create']). '?sub_type=repair', false); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M12 5l0 14" />
                                        <path d="M5 12l14 0" />
                                    </svg> <?php echo app('translator')->get('messages.add'); ?>
                                </a>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped ajax_view" id="sell_table">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('messages.action'); ?></th>
                                        <th><?php echo app('translator')->get('receipt.date'); ?></th>
                                        <th>
                                            <?php echo app('translator')->get('repair::lang.delivery_date'); ?>
                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('repair::lang.repair_due_date_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                        </th>
                                        <th><?php echo app('translator')->get('repair::lang.job_sheet_no'); ?></th>
                                        <th><?php echo app('translator')->get('sale.invoice_no'); ?></th>
                                        <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                                            <th><?php echo app('translator')->get('repair::lang.technician'); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo app('translator')->get('lang_v1.added_by'); ?></th>
                                        <th><?php echo app('translator')->get('sale.customer_name'); ?></th>
                                        <th><?php echo app('translator')->get('product.brand'); ?></th>
                                        <th><?php echo app('translator')->get('repair::lang.device_model'); ?></th>
                                        <th><?php echo app('translator')->get('repair::lang.serial_no'); ?></th>
                                        <th><?php echo app('translator')->get('sale.status'); ?></th>
                                        <th><?php echo app('translator')->get('sale.location'); ?></th>
                                        <th><?php echo app('translator')->get('repair::lang.repair_warranty'); ?></th>
                                        <th><?php echo app('translator')->get('sale.payment_status'); ?></th>
                                        <th><?php echo app('translator')->get('sale.total_amount'); ?></th>
                                        <th><?php echo app('translator')->get('purchase.payment_due'); ?></th>
                                        <th><?php echo app('translator')->get('lang_v1.sell_return_due'); ?></th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr class="bg-gray font-17 footer-total text-center">
                                        <td
                                            <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                                                colspan="11"
                                            <?php else: ?>
                                                colspan="10"
                                            <?php endif; ?>>
                                            <strong><?php echo app('translator')->get('sale.total'); ?>:</strong>
                                        </td>
                                        <td id="footer_repair_status_count"></td>
                                        <td></td>
                                        <td></td>
                                        <td id="footer_payment_status_count"></td>
                                        <td>
                                            <span class="display_currency" id="footer_sale_total" data-currency_symbol ="true"></span>
                                        </td>
                                        <td class="text-left">
                                            <small>
                                                <span class="display_currency" id="footer_total_remaining" data-currency_symbol ="true"></span>
                                            </small>
                                        </td>
                                        <td><span class="display_currency" id="footer_total_sell_return_due" data-currency_symbol ="true"></span></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    
<div class="tab-pane" id="report_tab">
        <div class="row">
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fas fa-exclamation-circle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Unit Pending</span>
                        <span class="info-box-number" id="report_total_pending">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fas fa-dolly"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Unit Sudah Diambil</span>
                        <span class="info-box-number" id="report_total_completed">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-teal"><i class="fas fa-check-circle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Berhasil Service</span>
                        <span class="info-box-number" id="report_total_picked_up">0</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fas fa-dollar-sign"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Pendapatan</span>
                        <span class="info-box-number" id="report_total_revenue">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-purple"><i class="fas fa-tasks"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Progress Rate</span>
                        <span class="info-box-number" id="report_progress_rate">0 %</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-blue"><i class="fas fa-percent"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Success Rate</span>
                        <span class="info-box-number" id="report_success_percentage">0 %</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Papan Peringkat Staff</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr class="bg-light-gray">
                                        <th style="width: 70px;">Peringkat</th>
                                        <th>Total Ditangani</th>
                                        <th>Unit Pending</th>
                                        <th>Unit Diambil</th>
                                        <th>Pendapatan</th>
                                        <th>Progress Rate</th>
                                        <th>Success Rate</th>
                                        <th>Cancel Rate</th>
                                    </tr>
                                </thead>
                                <tbody id="staff_leaderboard_body">
                                    <tr>
                                        <td colspan="8" class="text-center">
                                            <i class="fa fa-refresh fa-spin"></i> Memuat data...
                                        </td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr class="bg-gray font-17 footer-total text-center">
                                        <td style="width: 70px;"><strong>Total</strong></td>
                                        <td id="footer_total_handled">0</td>
                                        <td id="footer_pending_units">0</td>
                                        <td id="footer_completed_units">0</td>
                                        <td id="footer_revenue">0</td>
                                        <td id="footer_progress_rate">0 %</td>
                                        <td id="footer_success_rate">0 %</td>
                                        <td id="footer_cancel_rate">0 %</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="box box-info">
                                    <div class="box-header with-border">
                                        <h3 class="box-title">Tren 30 Hari Terakhir</h3>
                                    </div>
                                    <div class="box-body">
                                        <canvas id="dailyTrendChart" height="250"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">Chart Status Pending</h3>
                    </div>
                    <div class="box-body">
                        <div style="width: 70%; margin: 0 auto; position: relative;">
                            <canvas id="pendingStatusChart" height="120"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">Chart Status Selesai</h3>
                    </div>
                    <div class="box-body">
                        <div style="width: 70%; margin: 0 auto; position: relative;">
                            <canvas id="completedStatusChart" height="120"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            
            
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">Tren Laporan Bulanan (Tahun Ini)</h3>
                    </div>
                    <div class="box-body">
                        <div style="width: 100%; margin: 0 auto; position: relative;">
                            <canvas id="monthlyTrendChart" height="300"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        </div>
    </div> <div class="modal fade payment_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade" id="edit_repair_status_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>


<script type="text/javascript">
$(document).ready( function(){
    //Date range as a button
    $('#sell_list_filter_date_range').daterangepicker(
        {
            ...dateRangeSettings,
            startDate: moment().startOf('year'),
            endDate: moment().endOf('year')
        },
        function (start, end) {
            $('#sell_list_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            sell_table.ajax.reload();
            pending_repair_table.ajax.reload();
            if ($('#report_tab').hasClass('active')) {
                loadReportData();
            }
        }
    );
    $('#sell_list_filter_date_range').val(moment().startOf('year').format(moment_date_format) + ' ~ ' + moment().endOf('year').format(moment_date_format));
    
    $('#sell_list_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
        $('#sell_list_filter_date_range').val('');
        sell_table.ajax.reload();
        pending_repair_table.ajax.reload();
        if ($('#report_tab').hasClass('active')) {
            loadReportData();
        }
    });

    // DataTable untuk TAB SELESAI
    sell_table = $('#sell_table').DataTable({
        processing: true,
        serverSide: true,
        fixedHeader:false,
        aaSorting: [[1, 'desc']],
        "ajax": {
            "url": "/repair/repair",
            "data": function ( d ) {
                if($('#sell_list_filter_date_range').val()) { 
                    var start = $('#sell_list_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                    d.start_date = start;
                    d.end_date = end;
                }
                d.is_direct_sale = 1;
                d.is_completed_status = 1; // Filter Selesai
                d.location_id = $('#sell_list_filter_location_id').val();
                d.customer_id = $('#sell_list_filter_customer_id').val();
                d.payment_status = $('#sell_list_filter_payment_status').val();
                d.created_by = $('#created_by').val();
                d.sub_type = 'repair';
                d.repair_status_id = $('#repair_status_id').val();
                <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                    d.service_staff_id = $('#service_staff_id').val();
                <?php endif; ?>
            }
        },
        columnDefs: [ { targets: [3, 8, 17], visible: false } ],
        columns: [
            { data: 'action', name: 'action', orderable: false, searchable: false},
            { data: 'transaction_date', name: 'transaction_date'  },
            { data: 'repair_due_date', name: 'repair_due_date'  },
            { data: 'job_sheet_no', name: 'rjs.job_sheet_no'},
            { data: 'invoice_no', name: 'invoice_no'},
            <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                { data: 'service_staff', name: 'ss.first_name'},
            <?php endif; ?>
            { data: 'added_by', name: 'added_by', orderable: false, searchable: false},
            { data: 'name', name: 'contacts.name'},
            { data: 'brand', name: 'b.name'},
            { data: 'device_model', name: 'rdm.name'},
            { data: 'repair_serial_no', name: 'transactions.repair_serial_no'},
            { data: 'repair_status', name: 'rs.name'},
            { data: 'business_location', name: 'bl.name'},
            { data: 'warranty_name', name: 'rw.name'},
            { data: 'payment_status', name: 'payment_status'},
            { data: 'final_total', name: 'final_total', orderable: false, searchable: false},
            { data: 'total_remaining', name: 'total_remaining', orderable: false, searchable: false},
            { data: 'return_due', name: 'return_due', orderable: false, searchable: false}
        ],
        "fnDrawCallback": function (oSettings) {
            $('#footer_sale_total').text(sum_table_col($('#sell_table'), 'final-total'));
            $('#footer_total_remaining').text(sum_table_col($('#sell_table'), 'payment_due'));
            $('#footer_total_sell_return_due').text(sum_table_col($('#sell_table'), 'sell_return_due'));
            $('#footer_payment_status_count').html(__sum_status_html($('#sell_table'), 'payment-status-label'));
            $('#footer_repair_status_count').html(__sum_status_html($('#sell_table'), 'edit_repair_status'));
            __currency_convert_recursively($('#sell_table'));
        },
        createdRow: function( row, data, dataIndex ) {
            $( row ).find('td:eq(11)').attr('class', 'clickable_td');
            $( row ).find('td:eq(14)').attr('class', 'clickable_td edit_status_td');
        }
    });

    // DataTable untuk TAB PENDING
    pending_repair_table = $('#pending_repair_table').DataTable({
        processing: true,
        serverSide: true,
        fixedHeader:false,
        aaSorting: [[4, 'desc']],
        "ajax": {
            "url": "/repair/repair",
            "data": function ( d ) {
                if($('#sell_list_filter_date_range').val()) { 
                    var start = $('#sell_list_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                    d.start_date = start;
                    d.end_date = end;
                }
                d.is_direct_sale = 1;
                d.is_completed_status = 0; // Filter Pending
                d.location_id = $('#sell_list_filter_location_id').val();
                d.customer_id = $('#sell_list_filter_customer_id').val();
                d.payment_status = $('#sell_list_filter_payment_status').val();
                d.created_by = $('#created_by').val();
                d.sub_type = 'repair';
                d.repair_status_id = $('#repair_status_id').val();
                <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                    d.service_staff_id = $('#service_staff_id').val();
                <?php endif; ?>
            }
        },
        columnDefs: [ { targets: [3, 8, 17], visible: false } ],
        columns: [
            { data: 'action', name: 'action', orderable: false, searchable: false},
            { data: 'transaction_date', name: 'transaction_date'  },
            { data: 'repair_due_date', name: 'repair_due_date'  },
            { data: 'job_sheet_no', name: 'rjs.job_sheet_no'},
            { data: 'invoice_no', name: 'invoice_no'},
            <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                { data: 'service_staff', name: 'ss.first_name'},
            <?php endif; ?>
            { data: 'added_by', name: 'added_by', orderable: false, searchable: false},
            { data: 'name', name: 'contacts.name'},
            { data: 'brand', name: 'b.name'},
            { data: 'device_model', name: 'rdm.name'},
            { data: 'repair_serial_no', name: 'transactions.repair_serial_no'},
            { data: 'repair_status', name: 'rs.name'},
            { data: 'business_location', name: 'bl.name'},
            { data: 'warranty_name', name: 'rw.name'},
            { data: 'payment_status', name: 'payment_status'},
            { data: 'final_total', name: 'final_total', orderable: false, searchable: false},
            { data: 'total_remaining', name: 'total_remaining', orderable: false, searchable: false},
            { data: 'return_due', name: 'return_due', orderable: false, searchable: false}
        ],
        "fnDrawCallback": function (oSettings) {
            $('#pending_repair_footer_total').text(sum_table_col($('#pending_repair_table'), 'final-total'));
            $('#pending_repair_footer_total_remaining').text(sum_table_col($('#pending_repair_table'), 'payment_due'));
            $('#pending_repair_footer_total_sell_return_due').text(sum_table_col($('#pending_repair_table'), 'sell_return_due'));
            $('#pending_repair_footer_payment_status_count').html(__sum_status_html($('#pending_repair_table'), 'payment-status-label'));
            $('#footer_pending_repair_status_count').html(__sum_status_html($('#pending_repair_table'), 'edit_repair_status'));
            __currency_convert_recursively($('#pending_repair_table'));
        },
        createdRow: function( row, data, dataIndex ) {
            $( row ).find('td:eq(11)').attr('class', 'clickable_td');
            $( row ).find('td:eq(14)').attr('class', 'clickable_td edit_status_td');
        }
    });

    // Filter change listener
    $(document).on('change', '#sell_list_filter_location_id, #sell_list_filter_customer_id, #sell_list_filter_payment_status, #service_staff_id, #repair_status_id, #created_by',  function() {
        sell_table.ajax.reload();
        pending_repair_table.ajax.reload();
        if ($('#report_tab').hasClass('active')) {
            loadReportData();
        }
    });

    // ===========================================
    // KODE UNTUK TAB REPORT
    // ===========================================
    var pendingStatusChart;
    var completedStatusChart;
    var myMonthlyTrendChart;
    var dailyTrendChart;

    function loadReportData() {
        // Tampilkan loading
        $('#report_total_pending').text('...');
        $('#report_total_completed').text('...');
        $('#report_total_picked_up').text('...');
        $('#report_total_revenue').text('...');
        $('#report_progress_rate').text('... %');
        $('#report_success_percentage').text('... %');
        $('#staff_leaderboard_body').html('<tr><td colspan="8" class="text-center"><i class="fa fa-refresh fa-spin"></i> Memuat data...</td></tr>');

        var start_date = '';
        var end_date = '';
        if ($('#sell_list_filter_date_range').val()) {
            start_date = $('#sell_list_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
            end_date = $('#sell_list_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
        }

        $.ajax({
            url: "<?php echo e(action([\Modules\Repair\Http\Controllers\RepairController::class, 'getRepairReportData']), false); ?>",
            type: "GET",
            data: {
                start_date: start_date,
                end_date: end_date,
                location_id: $('#sell_list_filter_location_id').val(),
                customer_id: $('#sell_list_filter_customer_id').val(),
                created_by: $('#created_by').val(),
                <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                    service_staff_id: $('#service_staff_id').val()
                <?php endif; ?>
            },
            dataType: "json",
            success: function(data) {
                // 1. Update Stat Boxes
                $('#report_total_pending').text(data.stat_boxes.total_pending);
                $('#report_total_completed').text(data.stat_boxes.total_completed); // Berhasil Service
                $('#report_total_picked_up').text(data.stat_boxes.total_picked_up); // Sudah Dijemput
                
                $('#report_success_percentage').text(data.stat_boxes.success_percentage + ' %');
                $('#report_progress_rate').text(data.stat_boxes.progress_rate + ' %');
                $('#report_total_revenue').text(data.stat_boxes.total_revenue);
                
                __currency_convert_recursively($('#report_tab'));

                // =============================================
                // 2. Update Chart Pending (Chart.js v3/v4)
                // =============================================
                var ctx_pending = document.getElementById('pendingStatusChart').getContext('2d');
                if (pendingStatusChart) {
                    pendingStatusChart.destroy();
                }
                pendingStatusChart = new Chart(ctx_pending, {
                    type: 'doughnut',
                    data: {
                        labels: data.pending_chart_data.labels.length > 0 ? data.pending_chart_data.labels : ['Tidak Ada Data'],
                        datasets: [{
                            data: data.pending_chart_data.values.length > 0 ? data.pending_chart_data.values : [1],
                            backgroundColor: data.pending_chart_data.colors.length > 0 ? data.pending_chart_data.colors : ['#f0f0f0'],
                        }]
                    },
                    options: {
                        responsive: true,
                        animation: false, // <-- Diubah
                        plugins: { // <-- Dibungkus 'plugins'
                            legend: { position: 'top' },
                            tooltip: { enabled: data.pending_chart_data.values.length > 0 }, // <-- 'tooltips' -> 'tooltip'
                            datalabels: {
                                formatter: (value, ctx) => {
                                    let sum = 0;
                                    let dataArr = ctx.chart.data.datasets[0].data;
                                    dataArr.map(data => { sum += data; });
                                    let percentage = (value * 100 / sum).toFixed(1) + "%";
                                    if (data.pending_chart_data.values.length == 1 && data.pending_chart_data.values[0] == 1) { return ''; }
                                    return percentage;
                                },
                                color: '#fff', 
                                font: { weight: 'bold' }
                            }
                        },
                        cutout: '50%', // <-- 'cutoutPercentage' -> 'cutout'
                    }
                });

                // =============================================
                // 3. Update Chart Completed (Chart.js v3/v4)
                // =============================================
                var ctx_completed = document.getElementById('completedStatusChart').getContext('2d');
                if (completedStatusChart) {
                    completedStatusChart.destroy();
                }
                completedStatusChart = new Chart(ctx_completed, {
                    type: 'doughnut',
                    data: {
                        labels: data.completed_chart_data.labels.length > 0 ? data.completed_chart_data.labels : ['Tidak Ada Data'],
                        datasets: [{
                            data: data.completed_chart_data.values.length > 0 ? data.completed_chart_data.values : [1],
                            backgroundColor: data.completed_chart_data.colors.length > 0 ? data.completed_chart_data.colors : ['#f0f0f0'],
                        }]
                    },
                    options: {
                        responsive: true,
                        animation: false, // <-- Diubah
                        plugins: { // <-- Dibungkus 'plugins'
                            legend: { position: 'top' },
                            tooltip: { enabled: data.completed_chart_data.values.length > 0 }, // <-- 'tooltips' -> 'tooltip'
                            datalabels: {
                                formatter: (value, ctx) => {
                                    let sum = 0;
                                    let dataArr = ctx.chart.data.datasets[0].data;
                                    dataArr.map(data => { sum += data; });
                                    let percentage = (value * 100 / sum).toFixed(1) + "%";
                                    if (data.completed_chart_data.values.length == 1 && data.completed_chart_data.values[0] == 1) { return ''; }
                                    return percentage;
                                },
                                color: '#fff',
                                font: { weight: 'bold' }
                            }
                        },
                        cutout: '50%', // <-- 'cutoutPercentage' -> 'cutout'
                    }
                });

                // 4. Update Tabel Papan Peringkat Staff (Versi PIVOT)
                // (Kode ini tidak diubah, karena tidak terkait Chart.js)
                var leaderboard_body = $('#staff_leaderboard_body');
                var leaderboard_table = leaderboard_body.closest('table');
                leaderboard_body.empty(); 

                var staff_data = data.staff_leaderboard;

                if (staff_data.length > 0) {
                    leaderboard_table.find('tfoot').show(); 
                    let ranks = staff_data.length;

                    let total_handled = 0, total_pending = 0, total_completed = 0, total_revenue = 0;
                    let total_progress_rate = 0, total_success_rate = 0, total_cancel_rate = 0;

                    $.each(staff_data, function(index, staff) {
                        staff.cancel_rate = 100.0 - staff.success_rate;
                        staff.cancel_units = staff.completed_units - staff.total_picked_up;
                        total_handled += staff.total_handled;
                        total_pending += staff.pending_units;
                        total_completed += staff.completed_units;
                        total_revenue += staff.revenue;
                        total_progress_rate += staff.progress_rate;
                        total_success_rate += staff.success_rate;
                        total_cancel_rate += staff.cancel_rate;
                    });

                    let avg_progress_rate = total_progress_rate / ranks;
                    let avg_success_rate = total_success_rate / ranks;
                    let avg_cancel_rate = total_cancel_rate / ranks;

                    let sorted_by_handled = staff_data.slice(0).sort((a, b) => b.total_handled - a.total_handled);
                    let sorted_by_pending = staff_data.slice(0).sort((a, b) => b.pending_units - a.pending_units);
                    let sorted_by_completed = staff_data.slice(0).sort((a, b) => b.completed_units - a.completed_units); 
                    let sorted_by_revenue = staff_data.slice(0).sort((a, b) => b.revenue - a.revenue);
                    let sorted_by_progress = staff_data.slice(0).sort((a, b) => b.progress_rate - a.progress_rate);
                    let sorted_by_success = staff_data.slice(0).sort((a, b) => b.success_rate - a.success_rate);
                    let sorted_by_cancel = staff_data.slice(0).sort((a, b) => a.cancel_rate - b.cancel_rate);

                    for (let i = 0; i < ranks; i++) {
                        let rank_html = `<td><h4><strong>#${i + 1}</strong></h4></td>`;
                        let handled_staff = sorted_by_handled[i];
                        let handled_html = `<td><strong>${handled_staff.staff_name}</strong> (${handled_staff.total_handled} unit)</td>`;
                        let pending_staff = sorted_by_pending[i];
                        let pending_html = `<td><strong>${pending_staff.staff_name}</strong> (${pending_staff.pending_units} unit)</td>`;
                        let completed_staff = sorted_by_completed[i];
                        let completed_html = `<td><strong>${completed_staff.staff_name}</strong> (${completed_staff.completed_units} unit)</td>`;
                        let revenue_staff = sorted_by_revenue[i];
                        let revenue_html = `<td><strong>${revenue_staff.staff_name}</strong> (${__currency_trans_from_en(revenue_staff.revenue, true)})</td>`;
                        let progress_staff = sorted_by_progress[i];
                        let progress_html = `<td><strong>${progress_staff.staff_name}</strong> (${progress_staff.progress_rate.toFixed(1)} %)</td>`;
                        let success_staff = sorted_by_success[i];
                        let success_html = `<td><strong>${success_staff.staff_name}</strong> (${success_staff.success_rate.toFixed(1)} %)(${success_staff.total_picked_up} unit)</td>`;
                        let cancel_staff = sorted_by_cancel[i];
                        let cancel_html = `<td><strong>${cancel_staff.staff_name}</strong> (${cancel_staff.cancel_rate.toFixed(1)} %)(${cancel_staff.cancel_units} unit)</td>`;

                        leaderboard_body.append(`
                            <tr>
                                ${rank_html}
                                ${handled_html}
                                ${pending_html}
                                ${completed_html} 
                                ${revenue_html}
                                ${progress_html}
                                ${success_html}
                                ${cancel_html}
                            </tr>
                        `);
                    }

                    $('#footer_total_handled').text(total_handled + ' unit');
                    $('#footer_pending_units').text(total_pending + ' unit');
                    $('#footer_completed_units').text(total_completed + ' unit');
                    $('#footer_revenue').html(__currency_trans_from_en(total_revenue, true));
                    $('#footer_progress_rate').closest('tr').find('td:first').html('<strong>Rata-rata</strong>');
                    $('#footer_progress_rate').html('<strong>' + avg_progress_rate.toFixed(1) + ' %</strong>');
                    $('#footer_success_rate').html('<strong>' + avg_success_rate.toFixed(1) + ' %</strong>');
                    $('#footer_cancel_rate').html('<strong>' + avg_cancel_rate.toFixed(1) + ' %</strong>');

                } else {
                    leaderboard_body.append('<tr><td colspan="8" class="text-center">Tidak ada data teknisi untuk ditampilkan.</td></tr>');
                    leaderboard_table.find('tfoot').hide();
                }

                // =============================================
                // 5. Update Chart Garis Bulanan (Chart.js v3/v4)
                // =============================================
                
                if (myMonthlyTrendChart) {
                    myMonthlyTrendChart.destroy();
                }

                var ctxLine = document.getElementById('monthlyTrendChart').getContext('2d');
                myMonthlyTrendChart = new Chart(ctxLine, {
                    type: 'line',
                    data: {
                        labels: data.monthly_trend_data.labels, // Data dari controller
                        datasets: data.monthly_trend_data.datasets // Data dari controller
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: { // <-- Dibungkus 'plugins'
                            legend: {
                                display: true
                            },
                            tooltip: { // <-- 'tooltips' -> 'tooltip'
                                callbacks: {
                                    label: function(tooltipItem) { // <-- Parameter diubah
                                        var label = tooltipItem.dataset.label || '';
                                        if (label) {
                                            label += ': ';
                                        }
                                        // Format pendapatan di tooltip
                                        if (tooltipItem.datasetIndex === 3) { // Asumsi Index 3 adalah 'Pendapatan'
                                            label += __currency_trans_from_en(tooltipItem.raw, true); // <-- 'yLabel' -> 'raw'
                                        } else {
                                            label += tooltipItem.formattedValue; // <-- 'yLabel' -> 'formattedValue'
                                        }
                                        return label;
                                    }
                                }
                            }
                        },
                        scales: { // <-- 'scales' diubah total
                            'y-axis-default': { // <-- ID Sumbu Y 1 (sesuai 'yAxisID' di dataset)
                                position: 'left',
                                ticks: {
                                    beginAtZero: true,
                                    callback: function(value) { if (Number.isInteger(value)) { return value; } } // Hanya angka bulat
                                }
                            },
                            'y-axis-revenue': { // <-- ID Sumbu Y 2 (sesuai 'yAxisID' di dataset)
                                position: 'right', // Pindahkan ke kanan
                                ticks: {
                                    beginAtZero: true,
                                    // Format sebagai mata uang
                                    callback: function(value, index, values) {
                                        return __currency_trans_from_en(value, true);
                                    }
                                },
                                grid: { // <-- 'gridLines' -> 'grid'
                                    drawOnChartArea: false, // Jangan tumpuk grid
                                }
                            },
                            x: { // <-- Sumbu X perlu didefinisikan
                                // Opsi sumbu X jika perlu
                            }
                        }
                    }
                });
                
                // =============================================
                // 6. Update Chart Tren Harian (Chart.js v3/v4)
                // =============================================
                var ctx_trend = document.getElementById('dailyTrendChart').getContext('2d');
                if (dailyTrendChart) {
                    dailyTrendChart.destroy();
                }
                dailyTrendChart = new Chart(ctx_trend, {
                    type: 'line',
                    data: data.daily_trend_data, // Data sudah disiapkan oleh Controller
                    options: {
                        responsive: true,
                        maintainAspectRatio: false, // <-- TAMBAHKAN BARIS INI
                        animation: false,
                        plugins: {
                            legend: {
                                position: 'top',
                            }
                        },
                        scales: {
                            y: { 
                                ticks: {
                                    beginAtZero: true,
                                    callback: function(value) { if (Number.isInteger(value)) { return value; } },
                                }
                            },
                            x: {}
                        }
                    }
                });

            } // akhir dari success:
        }); // akhir dari .ajax(
    }

    // Panggil fungsi saat tab report di-klik (pertama kali)
    $('a[href="#report_tab"]').on('shown.bs.tab', function (e) {
        if (!pendingStatusChart || !completedStatusChart) { 
            loadReportData();
        }
    });
    // ===========================================
    // AKHIR KODE TAB REPORT
    // ===========================================

    // ===========================================
    // KODE MODAL STATUS (INI YANG PENTING)
    // ===========================================
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check("repair_status.update")): ?>
        $(document).on('click', '.edit_repair_status', function(e){
            e.preventDefault();
            var url = $(this).data('href');
            $.ajax({
                method: 'GET',
                url: url,
                dataType: 'html',
                success: function(result) {
                    $('#edit_repair_status_modal').html(result).modal('show');
                }
            });
        });
    <?php endif; ?>

    $('#edit_repair_status_modal').on('shown.bs.modal', function (e) {
        $('#send_sms').change(function() {
            if ($(this). is(":checked")) {
                $('div.sms_body').fadeIn();
            } else {
                $('div.sms_body').fadeOut();
            }
        });

        if ($('#repair_status_id_modal').length) {
            ;
            $("#sms_body").val($("#repair_status_id_modal :selected").data('sms_template'));
        }

        $('#repair_status_id_modal').on('change', function() {
            var sms_template = $(this).find(':selected').data('sms_template');
            $("#sms_body").val(sms_template);
        });
    });

    $(document).on('submit', 'form#update_repair_status_form', function(e){
        e.preventDefault();
        var data = $(this).serialize();
        var ladda = Ladda.create(document.querySelector('.ladda-button'));
        ladda.start();
        $.ajax({
            method: $(this).attr("method"),
            url: $(this).attr("action"),
            dataType: "json",
            data: data,
            success: function(result){
                ladda.stop();
                if(result.success == true){
                    $('#edit_repair_status_modal').modal('hide');
                    toastr.success(result.msg);
                    sell_table.ajax.reload();
                    pending_repair_table.ajax.reload();
                } else {
                    toastr.error(result.msg);
                }
            }
        });
    });

    $(document).on('click', '.delete_media', function(e){
        e.preventDefault();
        var this_btn = $(this);
        $.ajax({
            url: $(this).attr("href"),
            dataType: "json",
            success: function(result){
                if(result.success == true){
                    this_btn.closest('tr').remove();
                    toastr.success(result.msg);
                } else {
                    toastr.error(result.msg);
                }
            }
        });
    });
    
    $(document).on('click', '.box-header', function () {
        const box = $(this).closest('.box');
        const boxBody = box.find('.box-body');
        const icon = $(this).find('[data-widget="collapse"] i');
        boxBody.slideToggle(300);
        box.toggleClass('collapsed-box');
        icon.toggleClass('fa-plus fa-minus');
    });

});
</script>
<script src="<?php echo e(asset('js/payment.js?v=' . $asset_v), false); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Repair/Providers/../Resources/views/repair/index.blade.php ENDPATH**/ ?>