<div class="col-md-12">
    <div class="box box-solid">
        <div class="box-header with-border">
            <h2 class="box-title">
                <i class="fas fa-wrench"></i>
                <?php echo e($transaction->invoice_no ?? '-', false); ?>

            </h2>
        </div>
        <div class="box-body">
            <!-- Tanggal Masuk & Defect -->
            <div class="row">
                <div class="row">
                    <div class="col-md-6">
                        <strong><?php echo e(__('Tanggal Masuk'), false); ?>: </strong>
                        <?php echo e(\Carbon\Carbon::parse($transaction->created_at)->translatedFormat('l, d F Y, H:i'), false); ?>

                    </div>
                <div class="col-md-6">
                    <strong><?php echo app('translator')->get('repair::lang.serial_no'); ?>: </strong>  
                    <?php echo e($transaction->repair_serial_no ?? '-', false); ?>


                </div>
            </div>

            <!-- Model & Current Repair Status -->
            <div class="row mt-10">
                <div class="col-md-6">
                    <strong><?php echo app('translator')->get('repair::lang.model'); ?>: </strong> 
                    <?php echo e($deviceModel->name ?? '-', false); ?>

                </div>
                <div class="col-md-6">
                     <strong><?php echo app('translator')->get('repair::lang.defect'); ?>: </strong>
                    <?php echo e(!empty($transaction->repair_defects) ? json_decode($transaction->repair_defects)[0]->value : '-', false); ?>

                </div>
            </div>

            <!-- Serial No & Waiter -->
            <div class="row mt-10">
                <div class="col-md-6">
                    <strong><?php echo e(__('repair::lang.current_repair_status'), false); ?>: </strong>
                    <span class="label" style="background-color: <?php echo e($repairStatus->color ?? '#ccc', false); ?>;"> 
                        <?php echo e($repairStatus->name ?? '-', false); ?> 
                    </span>
                </div>
                <div class="col-md-6">
                    <strong><?php echo e(__('repair::lang.waiter'), false); ?>: </strong>
                    <?php echo e($resWaiter ? $resWaiter->first_name : '-', false); ?>

                </div>
            </div>

            <!-- Activities -->
            <div class="row mt-10">
                <div class="col-md-12">
                    <strong><span><?php echo e(__('repair::lang.activities'), false); ?>:</span></strong>
                    <?php if ($__env->exists('repair::customer_repair.repair_activities', ['activities' => $activity_logs])) echo $__env->make('repair::customer_repair.repair_activities', ['activities' => $activity_logs], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Repair/Providers/../Resources/views/customer_repair/repair_details.blade.php ENDPATH**/ ?>