
<?php $__env->startSection('title', __('essentials::lang.hrm')); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('essentials::layouts.nav_hrm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<section class="content">
    <div class="row row-custom">
        <div class="col-md-4 col-sm-6 col-xs-12 col-custom">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <i class="fas fa-sign-out-alt"></i>
                    <h3 class="box-title"><?php echo app('translator')->get('essentials::lang.my_leaves'); ?></h3>
                </div>
                <div class="box-body p-10">
                    <table class="table no-margin">
                        <thead>
                            <?php $__empty_1 = true; $__currentLoopData = $users_leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <?php echo e(\Carbon::createFromTimestamp(strtotime($user_leave->start_date))->format(session('business.date_format')), false); ?>

                                        - <?php echo e(\Carbon::createFromTimestamp(strtotime($user_leave->end_date))->format(session('business.date_format')), false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($user_leave->leave_type->leave_type, false); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="2" class="text-center">
                                        <?php echo app('translator')->get('lang_v1.no_data'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-4 col-sm-6 col-xs-12 col-custom">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <i class="fas fa-bullseye"></i>
                    <h3 class="box-title"><?php echo app('translator')->get('essentials::lang.my_sales_targets'); ?></h3>
                </div>
                <div class="box-body p-10">
                    <table class="table no-margin">
                        <thead>
                            <tr>
                                <td>
                                    <strong><?php echo app('translator')->get('essentials::lang.target_achieved_last_month'); ?>:
                                    </strong>
                                    <h4 class="text-success"><?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $target_achieved_last_month, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></h4>
                                </td>
                                <td>
                                    <strong><?php echo app('translator')->get('essentials::lang.target_achieved_this_month'); ?>:
                                    </strong>
                                    <h4 class="text-success"><?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $target_achieved_this_month, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></h4>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo app('translator')->get('essentials::lang.targets'); ?>
                                </th>
                                <th>
                                    <?php echo app('translator')->get('essentials::lang.commission_percent'); ?>
                                </th>
                            </tr>
                            <?php $__empty_1 = true; $__currentLoopData = $sales_targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $target->target_start, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?>
                                        - <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $target->target_end, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?>
                                    </td>
                                    <td>
                                        <?php echo e(number_format($target->commission_percent, 2), false); ?>%
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="2" class="text-center">
                                        <?php echo app('translator')->get('lang_v1.no_data'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <?php echo $__env->make('essentials::dashboard.birthdays', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if(!$is_admin): ?>
            <?php echo $__env->make('essentials::dashboard.holidays', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div class="col-md-4 col-sm-6 col-xs-12 text-center">
            <a href="<?php echo e(action([\Modules\Essentials\Http\Controllers\PayrollController::class, 'getMyPayrolls']), false); ?>"
                class="btn btn-lg btn-success">
                <i class="fas fa-coins"></i>
                <?php echo app('translator')->get('essentials::lang.my_payrolls'); ?>
            </a>
        </div>
    </div>
    <?php if($is_admin): ?>
    <hr>
    <?php endif; ?>
    <div class="row row-custom">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user.view')): ?>
        <div class="col-md-4 col-sm-6 col-xs-12 col-custom">
            <div class="box box-solid">
                <div class="box-body p-10">
                    <div class="info-box info-box-new-style">
                        <span class="info-box-icon bg-aqua"><i class="fas fa-users"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text"><?php echo e(__('user.users'), false); ?></span>
                            <span class="info-box-number"><?php echo e($users->count(), false); ?></span>
                        </div>
                    </div>
                    <table class="table no-margin">
                        <thead>
                            <tr>
                                <th><?php echo e(__('essentials::lang.department'), false); ?></th>
                                <th><?php echo e(__('sale.total'), false); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($department->name, false); ?></td>
                                    <td><?php if(!empty($users_by_dept[$department->id])): ?><?php echo e(count($users_by_dept[$department->id]), false); ?> <?php else: ?> 0 <?php endif; ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="2" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('essentials.approve_leave')): ?>
        <div class="col-md-4 col-sm-6 col-xs-12 col-custom">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <i class="fas fa-user-times"></i>
                    <h3 class="box-title"><?php echo app('translator')->get('essentials::lang.leaves'); ?></h3>
                </div>
                <div class="box-body p-10">
                    <table class="table no-margin">
                        <tr>
                            <th class="bg-light-gray" colspan="2"><?php echo app('translator')->get('home.today'); ?></th>
                        </tr>
                        <?php $__empty_1 = true; $__currentLoopData = $todays_leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php echo e(\Carbon::createFromTimestamp(strtotime($leave->start_date))->format(session('business.date_format')), false); ?>

                                    - <?php echo e(\Carbon::createFromTimestamp(strtotime($leave->end_date))->format(session('business.date_format')), false); ?>

                                </td>
                                <td>
                                    <?php echo e($leave->leave_type->leave_type, false); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="2" class="text-center">
                                    <?php echo app('translator')->get('lang_v1.no_data'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr>
                            <th class="bg-light-gray" colspan="2"><?php echo app('translator')->get('lang_v1.upcoming'); ?></th>
                        </tr>
                        <?php $__empty_1 = true; $__currentLoopData = $upcoming_leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php echo e(\Carbon::createFromTimestamp(strtotime($leave->start_date))->format(session('business.date_format')), false); ?>

                                    - <?php echo e(\Carbon::createFromTimestamp(strtotime($leave->end_date))->format(session('business.date_format')), false); ?>

                                </td>
                                <td>
                                    <?php echo e($leave->leave_type->leave_type, false); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="2" class="text-center">
                                    <?php echo app('translator')->get('lang_v1.no_data'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if($is_admin): ?>
            <?php echo $__env->make('essentials::dashboard.holidays', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </div>
    
    <div class="row row-custom">
        <?php if($is_admin): ?>
            <div class="col-md-4 col-sm-6 col-xs-12 col-custom">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <i class="fas fa-user-check"></i>
                        <h3 class="box-title"><?php echo app('translator')->get('essentials::lang.todays_attendance'); ?></h3>
                    </div>
                    <div class="box-body p-10">
                        <table class="table no-margin">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('essentials::lang.employee'); ?></th>
                                    <th><?php echo app('translator')->get('essentials::lang.clock_in'); ?></th>
                                    <th><?php echo app('translator')->get('essentials::lang.clock_out'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $todays_attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($attendance->employee->user_full_name, false); ?></td>
                                        <td>
                                            <?php echo e(\Carbon::createFromTimestamp(strtotime($attendance->clock_in_time))->format(session('business.date_format') . ' ' . 'H:i'), false); ?>

                                            <?php if(!empty($attendance->clock_in_note)): ?>
                                                <br><small><?php echo e($attendance->clock_in_note, false); ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(!empty($attendance->clock_out_time)): ?>
                                                <?php echo e(\Carbon::createFromTimestamp(strtotime($attendance->clock_out_time))->format(session('business.date_format') . ' ' . 'H:i'), false); ?>

                                            <?php endif; ?>
                                            <?php if(!empty($attendance->clock_out_note)): ?>
                                                <br><small><?php echo e($attendance->clock_out_note, false); ?></small>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="<?php if($is_admin): ?> col-md-8 <?php else: ?> col-md-12 <?php endif; ?> col-sm-12 col-xs-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <i class="fas fa-bullseye"></i>
                    <h3 class="box-title"><?php echo app('translator')->get('essentials::lang.sales_targets'); ?></h3>
                </div>
                <div class="box-body">
                    <table class="table" id="sales_targets_table" style="width: 100%;">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('report.user'); ?></th>
                                <th><?php echo app('translator')->get('essentials::lang.target_achieved_last_month'); ?></th>
                                <th><?php echo app('translator')->get('essentials::lang.target_achieved_this_month'); ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="row row-custom">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <i class="fas fa-tasks"></i>
                    <h3 class="box-title">Staff Absen Performa</h3>
                    <div class="box-tools pull-right">
                        <button type.button" class="btn btn-default btn-sm" id="hrm_performance_date_filter">
                            <span>
                                <i class="fa fa-calendar"></i> <?php echo e(__('messages.filter_by_date'), false); ?>

                            </span>
                            <i class="fa fa-caret-down"></i>
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <table class="table table-bordered table-striped" id="employee_work_hours_table" style="width: 100%;">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('essentials::lang.employee'); ?></th>
                                <th>Jam Kerja (Periode)</th>
                                <th>Kehadiran (Periode)</th>
                                <th>Tdk Hadir (Periode)</th>
                                <th>Rata-Rata Jam Kerja/Hari</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    $(document).ready( function(){
        if ($('#sales_targets_table').length) {
            var sales_targets_table = $('#sales_targets_table').DataTable({
                processing: true,
                serverSide: true,
                searching: false,
                scrollY:        "75vh",
                scrollX:        true,
                scrollCollapse: true,
                dom: 'Btirp',
                fixedHeader: false,
                ajax: "<?php echo e(action([\Modules\Essentials\Http\Controllers\DashboardController::class, 'getUserSalesTargets']), false); ?>"
            });
        }

        // --- Inisialisasi Daterangepicker ---
        var start = moment().startOf('month');
        var end = moment().endOf('month');
        
        $('#hrm_performance_date_filter').daterangepicker(
            dateRangeSettings,
            function (cb_start, cb_end) { 
                start = cb_start; 
                end = cb_end;   
                $('#hrm_performance_date_filter span').html(start.format(moment_date_format) + ' - ' + end.format(moment_date_format));
                employee_work_hours_table.ajax.reload();
            }
        );

        $('#hrm_performance_date_filter').on('cancel.daterangepicker', function(ev, picker) {
            start = moment().startOf('month');
            end = moment().endOf('month');
            $('#hrm_performance_date_filter span').html(start.format(moment_date_format) + ' - ' + end.format(moment_date_format));
            employee_work_hours_table.ajax.reload();
        });
        $('#hrm_performance_date_filter span').html(start.format(moment_date_format) + ' - ' + end.format(moment_date_format));

        // --- Inisialisasi DataTables ---
        if ($('#employee_work_hours_table').length) {
            var employee_work_hours_table = $('#employee_work_hours_table').DataTable({
                processing: true,
                serverSide: true,
                searching: true,
                scrollY:        "75vh", 
                scrollX:        true,
                scrollCollapse: true,
                // --- MODIFIKASI DIMULAI ---
                dom: 'lBtirp', // 'l' ditambahkan untuk menampilkan length menu
                lengthMenu: [
                    [25, 50, 100, 200, 500, 1000, -1], // Nilai
                    ['25', '50', '100', '200', '500', '1000', 'Semua'] // Tampilan
                ],
                // --- AKHIR MODIFIKASI ---
                fixedHeader: false,
                ajax: {
                    url: "<?php echo e(route('hrm.employee_work_hours'), false); ?>",
                    data: function (d) {
                        d.start_date = start.format('YYYY-MM-DD');
                        d.end_date = end.format('YYYY-MM-DD');
                    }
                },
                columns: [
                    { data: 'employee_name', name: 'employee_name' },
                    { data: 'work_hours_in_period', name: 'total_seconds_in_period' },
                    { data: 'attendance_in_period', name: 'attendance_count_in_period' },
                    { data: 'absence_in_period', name: 'absence_in_period', orderable: false, searchable: false },
                    { data: 'avg_seconds_per_day', name: 'avg_seconds_per_day', searchable: false }
                ]
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Essentials/Providers/../Resources/views/dashboard/hrm_dashboard.blade.php ENDPATH**/ ?>