
<?php $__env->startSection('title', __('lang_v1.calendar')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('hms::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black" ><?php echo app('translator')->get('lang_v1.calendar'); ?></h1>
        <p><i class="fa fa-info-circle"></i> <?php echo app('translator')->get('hms::lang.calender_help_text'); ?> </p>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php $__env->startComponent('components.widget'); ?>
            <div class="box-header">
                <div class="box-tools pull-left">
                    <h3><?php echo app('translator')->get('hms::lang.jump_to'); ?></h3>
                    <input type="text" value="<?php echo e(request()->input('date') ? request()->input('date') : '', false); ?>"
                        class="form-control date_picker">
                </div>
                <div class="box-tools pull-left" style="margin-left: 25px; margin-top:45px;">
                    <a class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm" id="week_prev" aria-label="Previous">
                        <span aria-hidden="true">&laquo;</span>
                    </a>
                    <a class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm  mt-5" id="day_prev" aria-label="Previous">
                        <span aria-hidden="true">&lsaquo;</span>
                    </a>
                </div>

                <div class="box-tools pull-right" style="margin-top:45px;">
                    <a class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm" id="day_next" aria-label="next">
                        <span aria-hidden="true">&rsaquo;</span>
                    </a>
                    <a class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm" id="week_next" aria-label="next">
                        <span aria-hidden="true">&raquo;</span>
                    </a>
                </div>
            </div>
            <table class="table table-bordered " id="bookings_calender">
                <thead>
                    <tr>
                        <th style="width: 150px;">
                            <?php echo Form::select('type_id', $types, request()->input('type_id') ? request()->input('type_id') : null, [
                                'class' => 'form-control',
                                'id' => 'type_id',
                                'placeholder' => __('hms::lang.type'),
                            ]); ?>

                        </th>
                        <?php echo $date_html; ?>

                    </tr>
                    <?php echo $html; ?>

                </thead>
            </table>
        <?php echo $__env->renderComponent(); ?>

    </section>
    <!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).ready(function() {
            var currentDate = new Date();
            var currentDateTime = moment(currentDate);

            $('.date_picker').datetimepicker({
                format: moment_date_format,
                ignoreReadonly: true,
                defaultDate: currentDateTime
            });

            $('.date_picker').on('dp.change', function(e) {

                window.location.href = "<?php echo e(route('booking_calendar'), false); ?>?type_id=" + $('#type_id').val() +
                    "&date=" + $('.date_picker').val();

            });

            $('#type_id').on('change', function() {
                window.location.href = "<?php echo e(route('booking_calendar'), false); ?>?type_id=" + $('#type_id').val() +
                    "&date=" + $('.date_picker').val();
            })


            $('#week_next').on('click', function() {
                var weekNext = "<?php echo e(request()->input('week_next'), false); ?>";
                if (weekNext == '') {
                    weekNext = 1;
                } else {
                    weekNext++;
                }
                window.location.href = "<?php echo e(route('booking_calendar'), false); ?>?type_id=" + $('#type_id').val() +
                    "&week_next=" + weekNext;
            })

            $('#week_prev').on('click', function() {

                var weekNext = "<?php echo e(request()->input('week_next'), false); ?>";
                if (weekNext == '') {
                    weekNext = -1;
                } else {
                    weekNext--;
                }
                window.location.href = "<?php echo e(route('booking_calendar'), false); ?>?type_id=" + $('#type_id').val() +
                    "&week_next=" + weekNext;
            })


            $('#day_next').on('click', function() {

                var daynext = "<?php echo e(request()->input('day_next'), false); ?>";
                if (daynext == '') {
                    daynext = 1;
                } else {
                    daynext++;
                }
                window.location.href = "<?php echo e(route('booking_calendar'), false); ?>?type_id=" + $('#type_id').val() +
                    "&day_next=" + daynext;
            })

            $('#day_prev').on('click', function() {

                var daynext = "<?php echo e(request()->input('day_next'), false); ?>";
                if (daynext == '') {
                    daynext = -1;
                } else {
                    daynext--;
                }
                window.location.href = "<?php echo e(route('booking_calendar'), false); ?>?type_id=" + $('#type_id').val() +
                    "&day_next=" + daynext;
            })

            $(".add_booking").hover(
                function() {
                    $(this).find(".add_booking_div").fadeIn();
                },
                function() {
                    $(this).find(".add_booking_div").fadeOut();
                }
            );


        });
    </script>
<?php $__env->stopSection(); ?>

<style>
    .hotel-reservation-outer:last-child {
        padding-bottom: 5px;
        height: 30px;
    }

    .hotel-reservation-outer {
        height: 25px;
        width: 100%;
        position: relative;
    }

    .hotel-reservation-inner {
        height: 20px;
        width: 100%;
        border-radius: 2px;
        padding: 0 5px;
        color: #fff;
    }

    .bg-confirmed {
        background-color: #5ac5b6;
        border-color: #5ac5b6;
        color: #fff;
    }

    .add_booking_div {
        display: none;
        padding-top: 15px;
    }
</style>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Hms/Resources/views/bookings/calender.blade.php ENDPATH**/ ?>