

<?php
    $action_url = action([\Modules\Essentials\Http\Controllers\PayrollController::class, 'store']);
    $title = __( 'essentials::lang.add_payroll' );
    $subtitle = __( 'essentials::lang.add_payroll' );
    $submit_btn_text = __( 'messages.save' );
    $group_name = __('essentials::lang.payroll_for_month', ['date' => $month_name . ' ' . $year]);
    if ($action == 'edit') {
        $action_url = action([\Modules\Essentials\Http\Controllers\PayrollController::class, 'getUpdatePayrollGroup']);
        $title = __( 'essentials::lang.edit_payroll' );
        $subtitle = __( 'essentials::lang.edit_payroll' );
        $submit_btn_text = __( 'messages.update' );
    }
?>

<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('essentials::layouts.nav_hrm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<section class="content-header">
    <h1><?php echo e($subtitle, false); ?></h1>
</section>

<section class="content">
<?php echo Form::open(['url' => $action_url, 'method' => 'post', 'id' => 'add_payroll_form' ]); ?>

    <?php echo Form::hidden('transaction_date', $transaction_date); ?>

    <?php if($action == 'edit'): ?>
        <?php echo Form::hidden('payroll_group_id', $payroll_group->id); ?>

    <?php endif; ?>
    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <h3>
                                <?php echo $group_name; ?>

                            </h3>
                            <small>
                                <b><?php echo app('translator')->get('business.location'); ?></b> :
                                <?php if(!empty($location)): ?>
                                    <?php echo e($location->name, false); ?>

                                    <?php echo Form::hidden('location_id', $location->id); ?>

                                <?php else: ?>
                                    <?php echo e(__('report.all_locations'), false); ?>

                                    <?php echo Form::hidden('location_id', ''); ?>

                                <?php endif; ?>
                            </small>
                        </div>
                        <div class="col-md-4">
                            <?php echo Form::label('payroll_group_name', __( 'essentials::lang.payroll_group_name' ) . ':*'); ?>

                            <?php echo Form::text('payroll_group_name', !empty($payroll_group) ? $payroll_group->name : strip_tags($group_name), ['class' => 'form-control', 'placeholder' => __( 'essentials::lang.payroll_group_name' ), 'required']); ?>

                        </div>
                        <div class="col-md-4">
                            <?php echo Form::label('payroll_group_status', __( 'sale.status' ) . ':*'); ?>

                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('essentials::lang.group_status_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                <?php echo Form::select('payroll_group_status', ['draft' => __('sale.draft'), 'final' => __('sale.final')], !empty($payroll_group) ? $payroll_group->status : 'draft', ['class' => 'form-control select2', 'required', 'style' => 'width: 100%;']); ?>

                            <p class="help-block text-muted"><?php echo app('translator')->get('essentials::lang.payroll_cant_be_deleted_if_final'); ?></p>
                        </div>
                    </div><br><br>
                    <table class="table" id="payroll_table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('essentials::lang.employee'); ?></th>
                                <th><?php echo app('translator')->get('essentials::lang.salary'); ?></th>
                                <th><?php echo app('translator')->get('essentials::lang.allowances'); ?></th>
                                <th><?php echo app('translator')->get('essentials::lang.deductions'); ?></th>
                                <th><?php echo app('translator')->get('essentials::lang.gross_amount'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $payrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee => $payroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    if ($action != 'edit') {
                                        $amount_per_unit_duration = (double)$payroll['essentials_salary'];
                                        $total_work_duration = 1;
                                        $duration_unit = __('lang_v1.month');
                                        if ($payroll['essentials_pay_period'] == 'week') {
                                            $total_work_duration = 4;
                                            $duration_unit = __('essentials::lang.week');
                                        } elseif ($payroll['essentials_pay_period'] == 'day') {
                                            $total_work_duration = \Carbon::parse($transaction_date)->daysInMonth;
                                            $duration_unit = __('lang_v1.day');
                                        }
                                        $total = $total_work_duration * $amount_per_unit_duration;
                                    } else {
                                        $amount_per_unit_duration = $payroll['essentials_amount_per_unit_duration'];
                                        $total_work_duration = $payroll['essentials_duration'];
                                        $duration_unit = $payroll['essentials_duration_unit'];
                                        $total = $total_work_duration * $amount_per_unit_duration;
                                    }
                                ?>
                                <tr data-id="<?php echo e($employee, false); ?>">
                                    <input type="hidden" name="payrolls[<?php echo e($employee, false); ?>][expense_for]" value="<?php echo e($employee, false); ?>">
                                    <?php if($action == 'edit'): ?>
                                        <?php echo Form::hidden('payrolls['.$employee.'][transaction_id]', $payroll['transaction_id']); ?>

                                    <?php endif; ?>
                                    <td>
                                        <?php echo e($payroll['name'], false); ?>

                                        <br><br>
                                        <b><?php echo e(__('essentials::lang.leaves'), false); ?> :</b>
                                        <?php echo e(__('essentials::lang.total_leaves_days', ['total_leaves' => $payroll['total_leaves']]), false); ?>

                                        <br><br>
                                        <b><?php echo e(__('essentials::lang.work_duration'), false); ?> :</b> 
                                        <?php echo e(__('essentials::lang.work_duration_hour', ['duration' => $payroll['total_work_duration']]), false); ?>

                                        <br><br>
                                        <b><?php echo e(__('essentials::lang.attendance'), false); ?>:</b>
                                        <?php echo e($payroll['total_days_worked'], false); ?> <?php echo app('translator')->get('lang_v1.days'); ?>
                                    </td>
                                    <td>
                                        <?php echo Form::label('essentials_duration_'.$employee, __( 'essentials::lang.total_work_duration' ) . ':*'); ?>

                                        <?php echo Form::text('payrolls['.$employee.'][essentials_duration]', $total_work_duration, ['class' => 'form-control input_number essentials_duration', 'placeholder' => __( 'essentials::lang.total_work_duration' ), 'required', 'data-id' => $employee, 'id' => 'essentials_duration_'.$employee]); ?>

                                        <br>
                                        <?php echo Form::label('essentials_duration_unit_'.$employee, __( 'essentials::lang.duration_unit' ) . ':'); ?>

                                        <?php echo Form::text('payrolls['.$employee.'][essentials_duration_unit]', $duration_unit, ['class' => 'form-control', 'placeholder' => __( 'essentials::lang.duration_unit' ), 'data-id' => $employee, 'id' => 'essentials_duration_unit_'.$employee]); ?>

                                        <br>
                                        <?php echo Form::label('essentials_amount_per_unit_duration_'.$employee, __( 'essentials::lang.amount_per_unit_duartion' ) . ':*'); ?>

                                        <?php echo Form::text('payrolls['.$employee.'][essentials_amount_per_unit_duration]', $amount_per_unit_duration, ['class' => 'form-control input_number essentials_amount_per_unit_duration', 'placeholder' => __( 'essentials::lang.amount_per_unit_duartion' ), 'required', 'data-id' => $employee, 'id' => 'essentials_amount_per_unit_duration_'.$employee]); ?>

                                        <br>
                                        <?php echo Form::label('total_'.$employee, __( 'sale.total' ) . ':'); ?>

                                        <?php echo Form::text('payrolls['.$employee.'][total]', $total, ['class' => 'form-control input_number total', 'placeholder' => __( 'sale.total' ), 'data-id' => $employee, 'id' => 'total_'.$employee]); ?>

                                    </td>
                                    <td>
                                        <?php $__env->startComponent('components.widget'); ?>
                                            <table class="table table-condensed allowance_table" id="allowance_table_<?php echo e($employee, false); ?>" data-id="<?php echo e($employee, false); ?>">
                                                <thead>
                                                    <tr>
                                                        <th class="col-md-5"><?php echo app('translator')->get('essentials::lang.description'); ?></th>
                                                        <th class="col-md-3"><?php echo app('translator')->get('essentials::lang.amount_type'); ?></th>
                                                        <th class="col-md-3"><?php echo app('translator')->get('sale.amount'); ?></th>
                                                        <th class="col-md-1">&nbsp;</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        // 1. Siapkan array tunjangan yang akan ditampilkan.
                                                        // Bonus Pencapaian dimulai dengan nilai 0.
                                                        $allowances_to_render = [
                                                            'Bonus Lembur' => [
                                                                'name' => 'Bonus Lembur', 'value' => 0, 'amount_type' => 'fixed', 'percent' => 0
                                                            ],
                                                            'Bonus Pencapaian' => [
                                                                'name' => 'Bonus Pencapaian', 'value' => 0, 'amount_type' => 'fixed', 'percent' => 0
                                                            ]
                                                        ];
                                                
                                                        // 2. Ambil nilai komisi dari variabel terpisah jika ada (opsional).
                                                        if (!empty($payroll['sales_commission_value'])) {
                                                            $allowances_to_render['Bonus Pencapaian']['value'] += $payroll['sales_commission_value'];
                                                        }
                                                
                                                        // 3. Proses semua tunjangan yang sudah ada dari database.
                                                        if (!empty($payroll['allowances'])) {
                                                            foreach ($payroll['allowances']['allowance_names'] as $key => $name) {
                                                                $amount = (float) $payroll['allowances']['allowance_amounts'][$key];
                                                
                                                                // === LOGIKA KUNCI YANG DIPERBAIKI ===
                                                                // Jika nama tunjangan adalah "Sales Target Commission", tambahkan nilainya
                                                                // ke "Bonus Pencapaian" dan jangan tampilkan baris aslinya.
                                                                if (trim($name) === 'Sales Target Commission') {
                                                                    $allowances_to_render['Bonus Pencapaian']['value'] += $amount;
                                                                    continue; // Lanjutkan ke tunjangan berikutnya, jangan render baris ini.
                                                                }
                                                
                                                                // Untuk tunjangan lain (termasuk "Bonus Lembur" atau "Bonus Pencapaian" yang sudah tersimpan),
                                                                // tambahkan ke daftar untuk ditampilkan.
                                                                if (isset($allowances_to_render[$name])) {
                                                                    // Jika sudah ada (seperti Bonus Lembur), tambahkan nilainya
                                                                    $allowances_to_render[$name]['value'] += $amount;
                                                                } else {
                                                                    // Jika tunjangan baru, buat entri baru
                                                                    $allowances_to_render[$name] = [
                                                                        'name'        => $name,
                                                                        'value'       => $amount,
                                                                        'amount_type' => $payroll['allowances']['allowance_types'][$key],
                                                                        'percent'     => $payroll['allowances']['allowance_percents'][$key]
                                                                    ];
                                                                }
                                                            }
                                                        }
                                                
                                                        $total_allowances = 0;
                                                        $loop_index = 0;
                                                    ?>

                                                    
                                                    <?php $__currentLoopData = $allowances_to_render; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        
                                                        <?php if(!empty($allowance['name']) || !empty($allowance['value'])): ?>
                                                            <?php echo $__env->make('essentials::payroll.allowance_and_deduction_row', [
                                                                'add_button'  => $loop_index == 0 ? true : false,
                                                                'type'        => 'allowance',
                                                                'name'        => $allowance['name'],
                                                                'value'       => $allowance['value'],
                                                                'amount_type' => $allowance['amount_type'],
                                                                'percent'     => $allowance['percent']
                                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            <?php
                                                                $total_allowances += $allowance['value'] ?? 0;
                                                                $loop_index++;
                                                            ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th colspan="2"><?php echo app('translator')->get('sale.total'); ?></th>
                                                        <td>
                                                            <span id="total_allowances_<?php echo e($employee, false); ?>" class="display_currency" data-currency_symbol="true"><?php echo e($total_allowances, false); ?></span>
                                                        </td>
                                                        <td>&nbsp;</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        <?php echo $__env->renderComponent(); ?>
                                    </td>
                                    <td>
                                        <?php $__env->startComponent('components.widget'); ?>
                                            <table class="table table-condensed deductions_table" id="deductions_table_<?php echo e($employee, false); ?>" data-id="<?php echo e($employee, false); ?>">
                                                <thead>
                                                    <tr>
                                                        <th class="col-md-5"><?php echo app('translator')->get('essentials::lang.description'); ?></th>
                                                        <th class="col-md-3"><?php echo app('translator')->get('essentials::lang.amount_type'); ?></th>
                                                        <th class="col-md-3"><?php echo app('translator')->get('sale.amount'); ?></th>
                                                        <th class="col-md-1">&nbsp;</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $total_deductions = 0; ?>
                                                    <?php if(!empty($payroll['deductions'])): ?>
                                                        <?php $__currentLoopData = $payroll['deductions']['deduction_names']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo $__env->make('essentials::payroll.allowance_and_deduction_row', [
                                                                'add_button' => $loop->index == 0 ? true : false,
                                                                'type' => 'deduction',
                                                                'name' => $value,
                                                                'value' => $payroll['deductions']['deduction_amounts'][$key],
                                                                'amount_type' => $payroll['deductions']['deduction_types'][$key],
                                                                'percent' => $payroll['deductions']['deduction_percents'][$key]
                                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            <?php $total_deductions += $payroll['deductions']['deduction_amounts'][$key]; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        
                                                        <?php echo $__env->make('essentials::payroll.allowance_and_deduction_row', [
                                                            'add_button' => true,
                                                            'type' => 'deduction',
                                                            'name' => 'Ketidakhadiran'
                                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        <?php echo $__env->make('essentials::payroll.allowance_and_deduction_row', [
                                                            'type' => 'deduction',
                                                            'name' => 'Pengurangan Jam Kerja'
                                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        <?php echo $__env->make('essentials::payroll.allowance_and_deduction_row', [
                                                            'type' => 'deduction',
                                                            'name' => 'Koreksi Jam Kerja'
                                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    <?php endif; ?>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th colspan="2"><?php echo app('translator')->get('sale.total'); ?></th>
                                                        <td>
                                                            <span id="total_deductions_<?php echo e($employee, false); ?>" class="display_currency" data-currency_symbol="true"><?php echo e($total_deductions, false); ?></span>
                                                        </td>
                                                        <td>&nbsp;</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        <?php echo $__env->renderComponent(); ?>
                                    </td>
                                    <td>
                                        <strong>
                                            <span id="gross_amount_text_<?php echo e($employee, false); ?>" class="display_currency" data-currency_symbol="true">0</span>
                                        </strong>
                                        <br>
                                        <?php echo Form::hidden('payrolls['.$employee.'][final_total]', 0, ['id' => 'gross_amount_'.$employee, 'class' => 'gross_amount']); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="5">
                                        <div class="form-group">
                                            <?php echo Form::label('note_'.$employee, __( 'brand.note' ) . ':'); ?>

                                            <?php echo Form::textarea('payrolls['.$employee.'][staff_note]', $payroll['staff_note'] ?? null, ['class' => 'form-control', 'placeholder' => __( 'brand.note' ), 'id' => 'note_'.$employee, 'rows' => 3]); ?>

                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class="col-md-12 text-center">
        <div class="form-group m-8 mt-15">
            <?php echo Form::hidden('total_gross_amount', 0, ['id' => 'total_gross_amount']); ?>

            <label>
                <?php echo Form::checkbox('notify_employee', 1, 0 , 
                [ 'class' => 'input-icheck']); ?> <?php echo e(__( 'essentials::lang.notify_employee' ), false); ?>

            </label>
            <button type="submit" class="btn btn-primary btn-big m-8" id="submit_user_button">
                <?php echo e($submit_btn_text, false); ?>

            </button>
        </div>
    </div>
</div>
<?php echo Form::close(); ?>

</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<?php if ($__env->exists('essentials::payroll.form_script')) echo $__env->make('essentials::payroll.form_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script type="text/javascript">
    $(document).ready(function() {
        $('tr[data-id]').each(function() {
            var employeeId = $(this).data('id');
            var payrollData = <?php echo json_encode($payrolls, 15, 512) ?>;
            var currentEmployeePayroll = payrollData[employeeId];
            
            if (currentEmployeePayroll) {
                hitungGajiOtomatis(employeeId, currentEmployeePayroll);
            }
        });

        function hitungGajiOtomatis(employeeId, payroll) {
            const gajiPokok = __read_number($('input#essentials_amount_per_unit_duration_' + employeeId));

            // 1. HITUNG POTONGAN KETIDAKHADIRAN (BERDASARKAN CUTI)
            const hariHadir_absen = parseFloat(payroll.total_days_worked) || 0;
            const hariCuti = parseFloat(payroll.total_leaves) || 0;
            const totalHariDasar = hariHadir_absen + hariCuti;
            
            let nilaiPotonganAbsen = 0;
            if (totalHariDasar > 0 && hariCuti > 0) {
                nilaiPotonganAbsen = (gajiPokok / totalHariDasar) * hariCuti;
            }

            const inputPotonganAbsen = $('#deductions_table_' + employeeId).find('input[name*="[deduction_names]"][value="Ketidakhadiran"]').closest('tr').find('input[name*="[deduction_amounts]"]');

            if (inputPotonganAbsen.length) {
                __write_number(inputPotonganAbsen, nilaiPotonganAbsen);
                inputPotonganAbsen.trigger('change');
            }

            // 2. HITUNG BONUS LEMBUR / POTONGAN KEKURANGAN JAM KERJA
            const hariHadir_jam = parseFloat(payroll.total_days_worked) || 0;
            const totalJamKerjaAktual = parseFloat(payroll.total_work_duration) || 0;
            const jamKerjaHarusnya = 8 * hariHadir_jam;

            let nilaiLemburAtauPotongan = 0;

            if (jamKerjaHarusnya > 0) {
                const tarifPerJam = (gajiPokok / 26 / 8); 
                const selisihJam = totalJamKerjaAktual - jamKerjaHarusnya;
                nilaiLemburAtauPotongan = tarifPerJam * selisihJam;
            }

            const inputBonusLembur = $('#allowance_table_' + employeeId).find('input[name*="[allowance_names]"][value="Bonus Lembur"]').closest('tr').find('input[name*="[allowance_amounts]"]');
            const inputPotonganJam = $('#deductions_table_' + employeeId).find('input[name*="[deduction_names]"][value="Pengurangan Jam Kerja"]').closest('tr').find('input[name*="[deduction_amounts]"]');

            if(inputBonusLembur.length) __write_number(inputBonusLembur, 0);
            if(inputPotonganJam.length) __write_number(inputPotonganJam, 0);

            if (nilaiLemburAtauPotongan > 0) {
                if(inputBonusLembur.length) {
                    __write_number(inputBonusLembur, nilaiLemburAtauPotongan);
                }
            } else if (nilaiLemburAtauPotongan < 0) {
                if(inputPotonganJam.length) {
                    __write_number(inputPotonganJam, Math.abs(nilaiLemburAtauPotongan));
                }
            }

            if(inputBonusLembur.length) inputBonusLembur.trigger('change');
            if(inputPotonganJam.length) inputPotonganJam.trigger('change');
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Essentials/Providers/../Resources/views/payroll/create.blade.php ENDPATH**/ ?>