

<?php $__env->startSection('title', __('lang_v1.my_profile')); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
   <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('lang_v1.my_profile'); ?></h1>
</section>
<!-- Main content -->
<section class="content">
	<?php echo Form::open(['url' => action([\Modules\Crm\Http\Controllers\ManageProfileController::class, 'updatePassword']), 'method' => 'post', 'id' => 'update_password',
            'class' => 'form-horizontal' ]); ?>

		<div class="row">
		    <div class="col-sm-12">
		        <div class="box box-solid"> <!--business info box start-->
		            <div class="box-header">
		                <div class="box-header">
		                    <h3 class="box-title"> <?php echo app('translator')->get('user.change_password'); ?></h3>
		                </div>
		            </div>
		            <div class="box-body">
		                <div class="form-group">
		                    <?php echo Form::label('current_password', __('user.current_password') . ':*', ['class' => 'col-sm-3 control-label']); ?>

		                    <div class="col-sm-9">
		                        <div class="input-group">
		                            <span class="input-group-addon">
		                                <i class="fa fa-lock"></i>
		                            </span>
		                            <?php echo Form::password('current_password', ['class' => 'form-control','placeholder' => __('user.current_password'), 'required']); ?>

		                        </div>
		                    </div>
		                </div>
		                <div class="form-group">
		                    <?php echo Form::label('new_password', __('user.new_password') . ':*', ['class' => 'col-sm-3 control-label']); ?>

		                    <div class="col-sm-9">
		                        <div class="input-group">
		                            <span class="input-group-addon">
		                                <i class="fa fa-lock"></i>
		                            </span>
		                            <?php echo Form::password('new_password', ['class' => 'form-control','placeholder' => __('user.new_password'), 'required']); ?>

		                        </div>
		                    </div>
		                </div>
		                <div class="form-group">
		                    <?php echo Form::label('confirm_password', __('user.confirm_new_password') . ':*', ['class' => 'col-sm-3 control-label']); ?>

		                    <div class="col-sm-9">
		                        <div class="input-group">
		                            <span class="input-group-addon">
		                                <i class="fa fa-lock"></i>
		                            </span>
		                            <?php echo Form::password('confirm_password', ['class' => 'form-control','placeholder' =>  __('user.confirm_new_password'), 'required']); ?>

		                        </div>
		                    </div>
		                </div>
		                <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white pull-right"><?php echo app('translator')->get('messages.update'); ?></button>
		            </div>
		        </div>
		    </div>
		</div>
	<?php echo Form::close(); ?>

	<?php echo Form::open(['url' => action([\Modules\Crm\Http\Controllers\ManageProfileController::class, 'updateProfile']), 'method' => 'post', 'id' => 'edit_contact_profile', 'files' => true ]); ?>

		<div class="row">
		    <div class="col-sm-8">
		        <div class="box box-solid"> <!--business info box start-->
		            <div class="box-header">
		                <div class="box-header">
		                    <h3 class="box-title"> <?php echo app('translator')->get('user.edit_profile'); ?></h3>
		                </div>
		            </div>
		            <!-- user id -->
		            <input type="hidden" name="user_id" id="user_id" value="<?php echo e($user->id, false); ?>">
		            <div class="box-body">
		                <div class="form-group col-md-2">
		                    <?php echo Form::label('surname', __('business.prefix') . ':'); ?>

		                    <div class="input-group">
		                        <span class="input-group-addon">
		                            <i class="fa fa-info"></i>
		                        </span>
		                        <?php echo Form::text('surname', $user->surname, ['class' => 'form-control','placeholder' => __('business.prefix_placeholder')]); ?>

		                    </div>
		                </div>
		                <div class="form-group col-md-5">
		                    <?php echo Form::label('first_name', __('business.first_name') . ':*'); ?>

		                    <div class="input-group">
		                        <span class="input-group-addon">
		                            <i class="fa fa-info"></i>
		                        </span>
		                        <?php echo Form::text('first_name', $user->first_name, ['class' => 'form-control','placeholder' => __('business.first_name'), 'required']); ?>

		                    </div>
		                </div>
		                <div class="form-group col-md-5">
		                    <?php echo Form::label('last_name', __('business.last_name') . ':'); ?>

		                    <div class="input-group">
		                        <span class="input-group-addon">
		                            <i class="fa fa-info"></i>
		                        </span>
		                        <?php echo Form::text('last_name', $user->last_name, ['class' => 'form-control','placeholder' => __('business.last_name')]); ?>

		                    </div>
		                </div>
		                <div class="form-group col-md-6">
		                    <?php echo Form::label('email', __('business.email') . ':*'); ?>

		                    <div class="input-group">
		                        <span class="input-group-addon">
		                            <i class="fa fa-info"></i>
		                        </span>
		                        <?php echo Form::email('email',  $user->email, ['class' => 'form-control','placeholder' => __('business.email'), 'required']); ?>

		                    </div>
		                </div>
		                <div class="form-group col-md-6">
		                    <?php echo Form::label('language', __('business.language') . ':'); ?>

		                    <div class="input-group">
		                        <span class="input-group-addon">
		                            <i class="fa fa-info"></i>
		                        </span>
		                        <?php echo Form::select('language',$languages, $user->language, ['class' => 'form-control select2']); ?>

		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		    <div class="col-md-4">
		        <?php $__env->startComponent('components.widget', ['title' => __('lang_v1.profile_photo')]); ?>
		            <?php if(!empty($user->media)): ?>
		                <div class="col-md-12 text-center">
		                    <?php echo $user->media->thumbnail([150, 150], 'img-circle'); ?>

		                </div>
		            <?php endif; ?>
		            <div class="col-md-12">
		                <div class="form-group">
		                    <?php echo Form::label('profile_photo', __('lang_v1.upload_image') . ':'); ?>

		                    <?php echo Form::file('profile_photo', ['id' => 'profile_photo', 'accept' => 'image/*']); ?>

		                    <small><p class="help-block"><?php echo app('translator')->get('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)]); ?></p></small>
		                </div>
		            </div>
		        <?php echo $__env->renderComponent(); ?>
		    </div>
		</div>
		<div class="row">
		    <div class="col-md-12">
		        <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white pull-right"><?php echo app('translator')->get('messages.update'); ?></button>
		    </div>
		</div>
	<?php echo Form::close(); ?>

</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
	<script src="<?php echo e(asset('modules/crm/js/crm.js?v=' . $asset_v), false); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('crm::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Crm/Providers/../Resources/views/profile/edit.blade.php ENDPATH**/ ?>