<?php
    if($type == 'allowance') {
        $name_col = 'payrolls['.$employee.'][allowance_names]';
        $val_col = 'payrolls['.$employee.'][allowance_amounts]';
        $val_class = 'allowance';
        $type_col = 'payrolls['.$employee.'][allowance_types]';
        $percent_col = 'payrolls['.$employee.'][allowance_percent]';
    } elseif($type == 'deduction') {
        $name_col = 'payrolls['.$employee.'][deduction_names]';
        $val_col = 'payrolls['.$employee.'][deduction_amounts]';
        $val_class = 'deduction';
        $type_col = 'payrolls['.$employee.'][deduction_types]';
        $percent_col = 'payrolls['.$employee.'][deduction_percent]';
    }

    $amount_type = !empty($amount_type) ? $amount_type : 'fixed';
    $percent = $amount_type == 'percent' && !empty($percent) ? $percent : 0;
?>

<tr>
    <td>
        <?php echo Form::text(
            $name_col . '[]',
            !empty($name) ? $name : null,
            ['class' => 'form-control input-sm', 'placeholder' => __('essentials::lang.description')]
        ); ?>

    </td>

    <td>
        <?php echo Form::select(
            $type_col . '[]',
            ['fixed' => __('lang_v1.fixed'), 'percent' => __('lang_v1.percentage')],
            $amount_type,
            ['class' => 'form-control input-sm amount_type']
        ); ?>

        <div class="input-group percent_field <?php if($amount_type != 'percent'): ?> hide <?php endif; ?>">
            <?php echo Form::text(
                $percent_col . '[]',
                number_format($percent, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']),
                ['class' => 'form-control input-sm input_number percent']
            ); ?>

            <span class="input-group-addon"><i class="fa fa-percent"></i></span>
        </div>
    </td>

    <td>
        <?php
            // Menyiapkan atribut dasar untuk kolom input
            $attributes = [
                'class' => 'form-control input-sm value_field input_number ' . $val_class,
            ];

            if ($amount_type == 'percent') {
                $attributes['readonly'] = true;
            }
            
            // Memberikan ID unik berdasarkan nama deskripsi
            if (!empty($name) && $name == 'Ketidakhadiran') {
                $attributes['id'] = 'potongan_ketidakhadiran_' . $employee;
            }
            // === TAMBAHAN BARU DIMULAI DI SINI ===
            if (!empty($name) && $name == 'Bonus Lembur') {
                $attributes['id'] = 'bonus_lembur_' . $employee;
            }
            if (!empty($name) && $name == 'Pengurangan Jam Kerja') {
                $attributes['id'] = 'potongan_jam_kerja_' . $employee;
            }
            // === AKHIR TAMBAHAN BARU ===
        ?>

        <?php echo Form::text(
            $val_col . '[]',
            !empty($value) ? number_format((float) $value, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']) : 0,
            $attributes
        ); ?>

    </td>

    <td>
        <?php if(!empty($add_button)): ?>
            <button type="button"
                class="btn btn-primary btn-xs <?php if($type == 'allowance'): ?> add_allowance <?php else: ?> add_deduction <?php endif; ?>">
                <i class="fa fa-plus"></i>
            </button>
        <?php else: ?>
            <button type="button" class="btn btn-danger btn-xs remove_tr">
                <i class="fa fa-minus"></i>
            </button>
        <?php endif; ?>
    </td>
</tr><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Essentials/Providers/../Resources/views/payroll/allowance_and_deduction_row.blade.php ENDPATH**/ ?>