
<?php $__env->startSection('title', __('lang_v1.activity_log')); ?>

<?php $__env->startSection('content'); ?>

<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo e(__('lang_v1.activity_log'), false); ?></h1>
</section>

<section class="content">

    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('al_users_filter', __( 'lang_v1.by' ) . ':'); ?>

                        <?php echo Form::select('al_users_filter', $users, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'al_users_filter', 'placeholder' => __('lang_v1.all')]); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('subject_type', __( 'lang_v1.subject_type' ) . ':'); ?>

                        <?php echo Form::select('subject_type', $transaction_types, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'subject_type', 'placeholder' => __('lang_v1.all')]); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('al_date_filter', __('report.date_range') . ':'); ?>

                        <?php echo Form::text('al_date_filter', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly']); ?>

                    </div>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="activity_log_table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('lang_v1.date'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.subject_type'); ?></th>
                            <th><?php echo app('translator')->get('messages.action'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.by'); ?></th>
                            <th><?php echo app('translator')->get('brand.note'); ?></th>
                        </tr>
                    </thead>
                </table>
            </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>

    <div class="row">
        
        <div class="col-md-7">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Ringkasan Aktivitas Staff']); ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="summary_table">
                        <thead>
                            <tr>
                                <th>Nama Staff</th>
                                <th>Lokasi Kerja</th>
                                <th>Perubahan Status</th>
                                <th>Ditambahkan</th>
                                <th>Total Tindakan</th>
                                <th>Kontribusi</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                         <tfoot>
                            <tr class="bg-gray font-17 footer-total text-center">
                                <td colspan="2"><strong>Total</strong></td>
                                <td id="footer_total_perubahan">0</td>
                                <td id="footer_total_ditambahkan">0</td>
                                <td id="footer_grand_total">0</td>
                                <td>100%</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
        
        
        <div class="col-md-5">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Visualisasi Aktivitas (Gabungan)']); ?>
                <div class="chart-container" style="position: relative; height:300px; width:100%">
                    <canvas id="staffActivityChart"></canvas>
                </div>
            <?php echo $__env->renderComponent(); ?>

            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Papan Peringkat Staff']); ?>
                <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                    <table class="table table-bordered table-striped" id="ranking_table">
                        <thead>
                            <tr class="text-center">
                                <th style="width: 10%;">Peringkat</th>
                                <th style="width: 30%;">Perubahan Status</th>
                                <th style="width: 30%;">Ditambahkan</th>
                                <th style="width: 30%;">Total Tindakan</th>
                            </tr>
                        </thead>
                        <tbody id="ranking_table_body"></tbody>
                    </table>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>

    
    
    
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Tren Aktivitas Harian']); ?>
                <div class="chart-container" style="position: relative; height:300px; width:100%">
                    <canvas id="activityTimelineChart"></canvas>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    
    
    


    
    <div class="row">
        <div class="col-md-6">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Kontribusi Staff (Perubahan Status)']); ?>
                <div class="chart-container" style="position: relative; height:300px; width:100%">
                    <canvas id="perubahanStatusChart"></canvas>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
        <div class="col-md-6">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Kontribusi Staff (Ditambahkan)']); ?>
                <div class="chart-container" style="position: relative; height:300px; width:100%">
                    <canvas id="ditambahkanChart"></canvas>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script type="text/javascript">
$(document).ready(function () {
    // === DEKLARASI VARIABEL ===
    var activity_log_table, summary_table;
    
    // Deklarasi untuk SEMUA chart
    var staffChart, perubahanStatusChart, ditambahkanChart, activityTimelineChart;

    // --- FUNGSI UNTUK UPDATE SEMUA LAPORAN (TERMASUK CHART BARU) ---
    function updateAllReports() {
        var start_date = '', end_date = '';
        if ($('#al_date_filter').val()) {
            start_date = $('input#al_date_filter').data('daterangepicker').startDate.format('YYYY-MM-DD');
            end_date = $('input#al_date_filter').data('daterangepicker').endDate.format('YYYY-MM-DD');
        }
        var user_id = $('#al_users_filter').val();
        var subject_type = $('#subject_type').val();

        $.ajax({
            url: '<?php echo e(action([\App\Http\Controllers\ReportController::class, "getActivitySummary"]), false); ?>',
            dataType: 'json',
            data: { start_date, end_date, user_id, subject_type },
            success: function (data) {
                // 1. Proses data untuk Tabel Ringkasan
                var tableData = [], total_perubahan = 0, total_ditambahkan = 0;
                data.summary.forEach(function (item) {
                    var percentage = data.grand_total > 0 ? (item.total_actions / data.grand_total * 100).toFixed(1) : 0;
                    tableData.push([
                        item.staff_name, item.location_name || 'N/A',
                        item.perubahan_status_count, item.ditambahkan_count,
                        item.total_actions, percentage
                    ]);
                    total_perubahan += parseInt(item.perubahan_status_count) || 0;
                    total_ditambahkan += parseInt(item.ditambahkan_count) || 0;
                });
                summary_table.clear().rows.add(tableData).draw();
                
                var grand_total = total_perubahan + total_ditambahkan;
                $('#footer_total_perubahan').text(total_perubahan);
                $('#footer_total_ditambahkan').text(total_ditambahkan);
                $('#footer_grand_total').text(grand_total);

                // 2. Proses data untuk Papan Peringkat
                var sortedByPerubahan = [...data.summary].sort((a, b) => b.perubahan_status_count - a.perubahan_status_count);
                var sortedByDitambahkan = [...data.summary].sort((a, b) => b.ditambahkan_count - a.ditambahkan_count);
                var sortedByTotal = [...data.summary].sort((a, b) => b.total_actions - a.total_actions);
                
                var maxRank = data.summary.length; 
                var rankingTableBody = $('#ranking_table_body');
                rankingTableBody.empty();

                for (var i = 0; i < maxRank; i++) {
                    var rank = i + 1;
                    var perubahanHtml = (sortedByPerubahan[i] && sortedByPerubahan[i].perubahan_status_count > 0) ? `<strong>${sortedByPerubahan[i].staff_name}</strong> (${sortedByPerubahan[i].perubahan_status_count})` : '<i>-</i>';
                    var ditambahkanHtml = (sortedByDitambahkan[i] && sortedByDitambahkan[i].ditambahkan_count > 0) ? `<strong>${sortedByDitambahkan[i].staff_name}</strong> (${sortedByDitambahkan[i].ditambahkan_count})` : '<i>-</i>';
                    var totalHtml = (sortedByTotal[i] && sortedByTotal[i].total_actions > 0) ? `<strong>${sortedByTotal[i].staff_name}</strong> (${sortedByTotal[i].total_actions})` : '<i>-</i>';
                    
                    rankingTableBody.append(`<tr><td class="text-center"><h4>#${rank}</h4></td><td>${perubahanHtml}</td><td>${ditambahkanHtml}</td><td>${totalHtml}</td></tr>`);
                }

                // 3. Proses data untuk Chart Gabungan
                var sortedForTotalChart = [...data.summary].sort((a, b) => b.total_actions - a.total_actions);
                var labels1 = sortedForTotalChart.map(item => item.staff_name);
                var perubahanData1 = sortedForTotalChart.map(item => item.perubahan_status_count);
                var ditambahkanData1 = sortedForTotalChart.map(item => item.ditambahkan_count);
                
                if (staffChart) staffChart.destroy();
                const ctx1 = document.getElementById('staffActivityChart').getContext('2d');
                staffChart = new Chart(ctx1, { type: 'bar', data: { labels: labels1, datasets: [ { label: 'Ditambahkan', data: ditambahkanData1, backgroundColor: 'rgba(75, 192, 192, 0.5)' }, { label: 'Perubahan Status', data: perubahanData1, backgroundColor: 'rgba(255, 159, 64, 0.5)' } ]}, options: { responsive: true, maintainAspectRatio: false, scales: { x: { stacked: true }, y: { stacked: true, beginAtZero: true } } } });

                // 4. Proses data untuk Chart Perubahan Status
                var sortedForPerubahanChart = [...data.summary].filter(item => item.perubahan_status_count > 0).sort((a, b) => b.perubahan_status_count - a.perubahan_status_count);
                var labels2 = sortedForPerubahanChart.map(item => item.staff_name);
                var perubahanData2 = sortedForPerubahanChart.map(item => item.perubahan_status_count);
                
                if (perubahanStatusChart) perubahanStatusChart.destroy();
                const ctx2 = document.getElementById('perubahanStatusChart').getContext('2d');
                perubahanStatusChart = new Chart(ctx2, { type: 'bar', data: { labels: labels2, datasets: [{ label: 'Jumlah Perubahan Status', data: perubahanData2, backgroundColor: 'rgba(255, 159, 64, 0.5)' }]}, options: { responsive: true, maintainAspectRatio: false, scales: { y: { beginAtZero: true } } } });

                // 5. Proses data untuk Chart Ditambahkan
                var sortedForDitambahkanChart = [...data.summary].filter(item => item.ditambahkan_count > 0).sort((a, b) => b.ditambahkan_count - a.ditambahkan_count);
                var labels3 = sortedForDitambahkanChart.map(item => item.staff_name);
                var ditambahkanData3 = sortedForDitambahkanChart.map(item => item.ditambahkan_count);

                if (ditambahkanChart) ditambahkanChart.destroy();
                const ctx3 = document.getElementById('ditambahkanChart').getContext('2d');
                ditambahkanChart = new Chart(ctx3, { type: 'bar', data: { labels: labels3, datasets: [{ label: 'Jumlah Ditambahkan', data: ditambahkanData3, backgroundColor: 'rgba(75, 192, 192, 0.5)' }]}, options: { responsive: true, maintainAspectRatio: false, scales: { y: { beginAtZero: true } } } });

                // =================================================================
                // 6. Proses data untuk Chart Tren Aktivitas Harian (BARU)
                // =================================================================
                if (activityTimelineChart) {
                    activityTimelineChart.destroy();
                }
                var ctxTimeline = document.getElementById('activityTimelineChart').getContext('2d');
                
                activityTimelineChart = new Chart(ctxTimeline, {
                    type: 'bar',
                    data: {
                        labels: data.timeline_labels, // Data dari AJAX
                        datasets: [
                            {
                                label: 'Ditambahkan',
                                data: data.timeline_ditambahkan, // Data dari AJAX
                                backgroundColor: 'rgba(75, 192, 192, 0.5)', 
                            },
                            {
                                label: 'Perubahan Status',
                                data: data.timeline_perubahan, // Data dari AJAX
                                backgroundColor: 'rgba(255, 159, 64, 0.5)', 
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            x: {
                                stacked: true, 
                                ticks: {
                                    autoSkip: true,
                                    maxTicksLimit: 15 // Batasi label tanggal
                                }
                            },
                            y: {
                                stacked: true, 
                                beginAtZero: true,
                                ticks: {
                                    precision: 0 
                                }
                            }
                        },
                        plugins: {
                            tooltip: {
                                mode: 'index',
                                intersect: false
                            }
                        }
                    }
                });
                // --- AKHIR LOGIKA BARU ---

            } // Akhir 'success'
        });
    }

    // --- INISIALISASI & EVENT LISTENERS ---
    var newDateRangeSettings = $.extend(true, {}, dateRangeSettings);

    // --- MENGATUR DEFAULT TANGGAL KE HARI INI ---
    newDateRangeSettings.startDate = moment();
    newDateRangeSettings.endDate = moment();

    $('#al_date_filter').daterangepicker(newDateRangeSettings, function (start, end) {
        $('#al_date_filter').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
        activity_log_table.ajax.reload();
        updateAllReports();
    });
    
    // --- MENAMPILKAN TANGGAL HARI INI DI INPUT ---
    $('#al_date_filter').val(moment().format(moment_date_format) + ' ~ ' + moment().format(moment_date_format));
    
    $('#al_date_filter').on('cancel.daterangepicker', function (ev, picker) {
        $('#al_date_filter').val('');
        activity_log_table.ajax.reload();
        updateAllReports();
    });

    // Inisialisasi Tabel Log Aktivitas (KODE ASLI ANDA)
    activity_log_table = $('#activity_log_table').DataTable({
        processing: true, serverSide: true, fixedHeader: false,
        aaSorting: [[0, 'desc']],
        ajax: {
            url: '<?php echo e(action([\App\Http\Controllers\ReportController::class, "activityLog"]), false); ?>',
            data: function (d) {
                if ($('#al_date_filter').val()) {
                    d.start_date = $('input#al_date_filter').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    d.end_date = $('input#al_date_filter').data('daterangepicker').endDate.format('YYYY-MM-DD');
                }
                d.user_id = $('#al_users_filter').val();
                d.subject_type = $('#subject_type').val();
            },
        },
        columns: [
            { data: 'created_at', name: 'created_at' }, { data: 'subject_type', orderable: false, searchable: false },
            { data: 'description', name: 'description' }, { data: 'created_by', name: 'created_by' },
            { data: 'note', name: 'note' },
        ],
    });

    // Inisialisasi Tabel Ringkasan (KODE ASLI ANDA)
    summary_table = $('#summary_table').DataTable({
        "paging": false, "info": false, "searching": false,
        "order": [[ 5, "desc" ]],
        "columnDefs": [
            { "type": "num", "targets": [2, 3, 4] },
            { "type": "num", "targets": 5, "render": function ( data, type, row ) { if (type === 'sort') return parseFloat(data); return data + '%'; } }
        ]
    });

    // Event Listener (KODE ASLI ANDA)
    $(document).on('change', '#al_users_filter, #subject_type', function () {
        activity_log_table.ajax.reload();
        updateAllReports();
    });

    // Panggilan pertama untuk memuat semua data (KODE ASLI ANDA)
    updateAllReports();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/resources/views/report/activity_log.blade.php ENDPATH**/ ?>